﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.06.00
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1567 - PKLohn - SalaryManageFRM - hide inactive payroll groups

CREATE OR ALTER PROCEDURE sp_Pra_AccountList 
(
  pi_BuyUId DI_UID_NN  -- Id of business year
)
RETURNS 
(
  buy_IstAbreGruppiert DB_BOOLEAN,
  prm_UId              DI_UID,
  prm_Monat            DI_SMLINT,
  prm_AbreNr           DI_SMLINT,
  prm_Bezeichnung      DS_DESCR,
  prm_AzDatum          DD_DATE,
  prm_IstSoGruppiert   DB_BOOLEAN,
  prg_UId              DI_UID,
  prg_SortNr           DI_SMLINT,
  prg_Gruppe           DS_STR12,
  prg_Bezeichnung      DS_STR50,
  prg_IstInMoAbrech    DB_BOOLEAN,
  prg_IstAktiv         DB_BOOLEAN, 
  pra_UId              DI_UID,
  pra_IstVerbucht      DB_BOOLEAN
)
AS

  --  The procedure creates a list of all theoretical accounts of the year according to the settings:                            
  --  a) in BusinesYear (grouped/not grouped)                         
  --  b) in PayrollMonth                                              
  --  c) in PayrollAccounts                                           
  --                                                                 
  --  This procedure doesn't take consideration whether payroll      
  --  account data have already been created in PRA_ParrollAccount.  
  --                                                                 
  --  This procedure generates the next account when no              
  --  fixed(verbucht) records are present in the current account.    
  --                                                                 

  DECLARE VARIABLE iBuyGeschJahr  DI_BUSINESSYEAR;
  DECLARE VARIABLE iAnzGroups     INTEGER;
  DECLARE VARIABLE dAzDatum       DATE;
  DECLARE VARIABLE iAzTag         SMALLINT;
  DECLARE VARIABLE bAzFolgeMonat  DB_BOOLEAN;
  
BEGIN

  -- Ist Abrechnung gruppiert aus BusinessYear 
  
  SELECT buy_GeschJahr, buy_IstAbreGruppiert 
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iBuyGeschJahr, :buy_IstAbreGruppiert;


  -- Count Groups except standard group 
  
  SELECT COUNT(*) 
    FROM prg_PayrollGroup 
   WHERE prg_BuyUId      = :pi_BuyUId 
     AND prg_IstStandard = 0
    INTO :iAnzGroups;

  IF ( ( buy_IstAbreGruppiert = 1 ) AND ( iAnzGroups > 0 ) ) THEN 
  BEGIN

    -- Alle Monatsabrechnungen und alle Gruppierten Sonderabrechnungen

    FOR 
      SELECT prm_UId, prm_Monat, prm_AbreNr, prm_Bezeichnung, prm_IstSoGruppiert
        FROM prm_PayrollMonth 
       WHERE ( prm_BuyUId = :pi_BuyUId )
         AND ( prm_Monat  > 0          )
         AND ( 
               ( prm_AbreNr = 0 ) 
               OR 
               ( ( prm_AbreNr > 0 ) AND ( prm_IstSoGruppiert = 1 ) ) 
             )
       ORDER BY prm_Monat,prm_AbreNr
        INTO :prm_UId, :prm_Monat, :prm_AbreNr, :prm_Bezeichnung, :prm_IstSoGruppiert
    DO 
    BEGIN

      prm_AzDatum       = NULL; 
      prg_UId           = NULL;
      prg_SortNr        = NULL;
      prg_Gruppe        = NULL; 
      prg_Bezeichnung   = NULL;
      prg_IstInMoAbrech = NULL;
      prg_IstAktiv      = NULL;


      FOR 
        SELECT prg_UId,             prg_SortNr,        prg_Gruppe,         
               prg_Bezeichnung,     prg_IstInMoAbrech, prg_AzTag,  
               prg_IstAzFolgeMonat, prg_IstAktiv                     
          FROM prg_PayrollGroup
         WHERE prg_BuyUId      = :pi_BuyUId 
           AND prg_IstStandard = 0
         ORDER BY prg_SortNr, prg_Gruppe
          INTO :prg_UId,         :prg_SortNr,        :prg_Gruppe,
               :prg_Bezeichnung, :prg_IstInMoAbrech, :iAzTag,
               :bAzFolgeMonat,   :prg_IstAktiv
      DO 
      BEGIN

        -- Calculate AZDatum from Group-Defs 
        EXECUTE PROCEDURE sp_Pra_MakeAzDatum :iAzTag, :prm_Monat, :iBuyGeschJahr, :bAzFolgeMonat
           RETURNING_VALUES :dAzDatum;

        IF (dAzDatum IS NOT NULL) THEN 
          prm_AzDatum = dAzDatum;
         

        pra_UId          = NULL;                   
        pra_IstVerbucht  = NULL;
           
        -- Wenn MonatsAbrechnung
        IF (prm_AbreNr = 0) THEN 
        BEGIN    

          -- Wenn Gruppe in Monatsabrechnungen
          IF ( prg_IstInMoAbrech = 1 ) THEN 
          BEGIN

            -- If Account exists, get UID and Isclosed 
            SELECT pra_UId, pra_IstVerbucht 
              FROM pra_PayrollAccount
             WHERE pra_PrmUId = :prm_UId 
               AND pra_PrgUId = :prg_UId
              INTO :pra_UId,:pra_IstVerbucht;    

            IF ( pra_UId IS NULL ) THEN 
              pra_IstVerbucht = 0;

            SUSPEND;

          END
 
        END 
        ELSE 
        BEGIN                    
        
          -- Wenn Gruppierte SonderAbrechnung 
                
          -- If Account exists, get UID and IsClosed 
          SELECT pra_UId, pra_IstVerbucht 
            FROM pra_PayrollAccount
           WHERE pra_PrmUId = :prm_UId 
             AND pra_PrgUId = :prg_UId
            INTO :pra_UId, :pra_IstVerbucht;    
 
          IF ( pra_UId IS NULL ) THEN 
            pra_IstVerbucht = 0;

          SUSPEND;

        END

      END

    END     


     -- Alle nicht gruppierten Sonderabrechnungen (all no grupped special acconts) 
    FOR 
      SELECT prm_UId,          prm_Monat,          prm_AbreNr, 
             prm_Bezeichnung,  prm_IstSoGruppiert, prm_AzTag, 
             prm_IsAzFolgeMonat
        FROM prm_PayrollMonth 
       WHERE prm_BuyUId         = :pi_BuyUId 
         AND prm_Monat          > 0
         AND prm_AbreNr         > 0 
         AND prm_IstSoGruppiert = 0
       ORDER BY prm_Monat,prm_AbreNr
        INTO :prm_UId,         :prm_Monat,          :prm_AbreNr,
             :prm_Bezeichnung, :prm_IstSoGruppiert, :iAzTag,
             :bAzFolgeMonat
    DO 
    BEGIN

      prm_AzDatum       = NULL; 
      prg_UId           = NULL;
      prg_SortNr        = NULL;
      prg_Gruppe        = NULL; 
      prg_Bezeichnung   = NULL;
      prg_IstInMoAbrech = NULL;
      pra_UId           = NULL;
      pra_IstVerbucht   = 0;
      prg_IstAktiv      = NULL;

      -- Calculate AZDatum  
      EXECUTE PROCEDURE sp_Pra_MakeAzDatum :iAzTag, :prm_Monat, :iBuyGeschJahr, :bAzFolgeMonat
        RETURNING_VALUES :dAzDatum;

      IF ( dAzDatum IS NOT NULL ) THEN 
        prm_AzDatum = dAzDatum;


      -- Get Values from StandardGroup for all secial accounts 
      SELECT prg_UId, prg_SortNr, prg_Gruppe, prg_Bezeichnung, prg_IstInMoAbrech, prg_IstAktiv                    
        FROM prg_PayrollGroup
       WHERE prg_BuyUId = :pi_BuyUId 
         AND prg_IstStandard = 1
        INTO :prg_UId, :prg_SortNr, :prg_Gruppe, :prg_Bezeichnung, :prg_IstInMoAbrech, :prg_IstAktiv;

      -- If Account exists, get UID and Isclosed
      SELECT pra_UId, pra_IstVerbucht 
        FROM pra_PayrollAccount
       WHERE pra_PrmUId = :prm_UId
         AND pra_PrgUId = :prg_UId
        INTO :pra_UId, :pra_IstVerbucht;    
 
      IF ( pra_UId IS NULL ) THEN 
        pra_IstVerbucht = 0;

      SUSPEND;

    END        

  END 
  ELSE 
  BEGIN

    -- Falls keine Gruppierung oder keine Abrechnungs Gruppen definiert sind

    prg_UId           = NULL;
    prg_SortNr        = NULL;
    prg_Bezeichnung   = NULL;
    prg_IstInMoAbrech = NULL;
    prg_IstAktiv      = NULL;

    -- Get Values from StandardGroup for all Accounts 
    SELECT prg_UId, prg_SortNr, prg_Gruppe, prg_Bezeichnung, prg_IstInMoAbrech, prg_IstAktiv                     
      FROM prg_PayrollGroup
     WHERE prg_BuyUId      = :pi_BuyUId 
       AND prg_IstStandard = 1
      INTO :prg_UId,:prg_SortNr, :prg_Gruppe, :prg_Bezeichnung, :prg_IstInMoAbrech, :prg_IstAktiv;

    FOR 
      SELECT prm_UId,         prm_Monat, prm_AbreNr,
             prm_Bezeichnung, prm_AzTag, prm_IsAzFolgeMonat,
             prm_IstSoGruppiert
        FROM prm_PayrollMonth 
       WHERE prm_BuyUId = :pi_BuyUId 
         AND prm_Monat  > 0
       ORDER BY prm_Monat,prm_AbreNr
        INTO :prm_UId,         :prm_Monat, :prm_AbreNr, 
             :prm_Bezeichnung, :iAzTag,    :bAzFolgeMonat,
             :prm_IstSoGruppiert
    DO 
    BEGIN

      prm_AzDatum = NULL;

      -- Calculate AZDatum 
      EXECUTE PROCEDURE sp_Pra_MakeAzDatum :iAzTag, :prm_Monat, :iBuyGeschJahr, :bAzFolgeMonat
        RETURNING_VALUES :dAzDatum;

      IF ( dAzDatum IS NOT NULL ) THEN 
        prm_AzDatum = dAzDatum;

      -- If Account exists, get UID and IsClosed 
        
      pra_UId          = NULL;                   
      pra_IstVerbucht  = NULL;
        
      SELECT pra_UId, pra_IstVerbucht 
        FROM pra_PayrollAccount
       WHERE pra_PrmUId = :prm_UId 
         AND pra_PrgUId = :prg_UId
        INTO :pra_UId, :pra_IstVerbucht;    

      IF ( pra_UId IS NULL ) THEN  
          pra_IstVerbucht = 0;

      SUSPEND;

     END        

  END

END!!

COMMENT ON PROCEDURE sp_Pra_AccountList IS 'The procedure creates a list of all theoretical accounts of the year according to the settings' !!

COMMENT ON PARAMETER sp_Pra_AccountList.pi_BuyUId IS 'Business year Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_CheckNextAccount 
(
  pi_BuyUId DI_UID,  -- Business Year Id
  pi_UsrUId DI_UID   -- Application active user Id
)
RETURNS 
(
  pi_PraUId DI_UID
)
AS

  -- This procedure determines the UID of the next billing to be processed.
  --
  -- If the next account is not yet created, it will be automatically generated and the pra_UId of 
  -- the new account will be returned.                                             
  --                                                               
  -- If all invoices are fixed(verbucht) and no further invoices more exist, the pra_UId of the last 
  -- account is returned (if grouping is active, all groups will be inserted)         

  DECLARE VARIABLE iPrmFirst       DI_UID;
  DECLARE VARIABLE iPraUId         DI_UID;
  DECLARE VARIABLE iPrmUId         DI_UID;
  DECLARE VARIABLE iPrgUId         DI_UID;
  DECLARE VARIABLE bPraIstVerbucht DB_BOOLEAN;
  DECLARE VARIABLE iPrmMonat       DI_SMLINT;
  DECLARE VARIABLE iAnzAHL         DI_INT;
  DECLARE VARIABLE iLcMonat        DI_SMLINT;
  DECLARE VARIABLE iLcPraUId       DI_UID;
  DECLARE VARIABLE iLcPrmUId       DI_UID;
  DECLARE VARIABLE iLcPrgUId       DI_INT;
  DECLARE VARIABLE iNewPraUId      DI_INT;
  DECLARE VARIABLE bIstOK          DB_BOOLEAN;
  DECLARE VARIABLE bIstFound       DB_BOOLEAN;
  DECLARE VARIABLE dPrmAzDatum     DD_DATE;
  DECLARE VARIABLE iAnzMitInAbre   DI_INT;
  DECLARE VARIABLE bPrgIstAktiv    DB_BOOLEAN;
  
BEGIN

  -- Letzte Verbuchte Abrechnung suchen und alle nicht verbuchten und leeren Abrechnungen entfernen 
  iLcMonat  = 0;
  iPrmFirst = 0;
  iLcPrmUId = 0;
   
  FOR 
    SELECT prm_Monat,  pra_UId,         pra_PrmUId, 
           pra_PrgUId, pra_IstVerbucht, pra_AnzMitInabre 
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
     WHERE prm_BuyUId = :pi_BuyUId 
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr
      INTO :iPrmMonat, :iPraUId,         :iPrmUId,
           :iPrgUId,   :bPraIstVerbucht, :iAnzAHL
  DO 
  BEGIN

    --- Hold first prm_UId in the Year   
    IF ( iPrmFirst = 0 ) THEN 
      iPrmFirst = iPrmUId;


    IF ( bPraIstVerbucht = 1 ) THEN 
    BEGIN

      --- Hold last Closed PayrollAccont in then Year

      iLcPraUId = iPraUId;
      iLcPrmUId = iPrmUId;
      iLcPrgUId = iPrgUId;
      iLcMonat  = iPrmMonat;

    END

  END


   -- Alle Abrechnungen zuletzt verbuchten Monats bzw. Folgemonats anlegen, 
   -- falls Abrechnungen noch nicht anlegeleg

   -- Keine verbuchte Abrechnung im Jahr gefunden
   
  IF ( iLcMonat = 0 ) THEN 
  BEGIN       
    iLcMonat  = 1;
    iLcPrmUId = 0;
  END

   
  bIstFound = 0;
  
  -- Wenn noch gar keine Abrechnung angelegt ist
  
  IF ( iPrmFirst = 0 ) THEN 
  BEGIN        
    bIstFound = 1;
    iLcPrmUId = 0;
  END

  bIstOK    = 0;
  
  FOR 
    SELECT prm_UId,   prg_UId, prm_AzDatum,
           prm_Monat, pra_UId, pra_IstVerbucht
      FROM sp_Pra_AccountList ( :pi_BuyUId )
     WHERE prm_Monat    >= :iLcMonat 
       AND prm_Monat    <= ( :iLcMonat + 1 )
       AND prg_IstAktiv = 1
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe      
      INTO :iPrmUId,   :iPrgUId, :dPrmAzDatum,
           :iPrmMonat, :iPraUId, :bPraIstVerbucht
  DO 
  BEGIN

    IF ( ( bIstFound = 0 ) AND ( iPrmUId = iLcPrmUId ) ) THEN
      bIstFound = 1;


    IF (bIstFound = 1) THEN 
    BEGIN

      IF ( ( iPrmUId <> iLcPrmUId ) AND (bIstOK = 0) ) THEN 
        iLcPrmUId = iPrmUId; 


      IF ( iLcPrmUId = iPrmUId ) THEN 
      BEGIN 


        IF ((iPraUId IS NULL) OR (iPraUId = 0)) THEN 
        BEGIN   
        
          -- Abrechnung noch nicht angelegt
          
          EXECUTE PROCEDURE
            sp_Pra_Insert
            :iPrmUId,         -- PrmUId
            :iPrgUId,         -- PrgUId
            :dPrmAzDatum,     -- AZDatum
            0,                -- IstVerbucht
            1,                -- IstAktiv
            :pi_UsrUId        -- CreateUser
            RETURNING_VALUES :iNewPraUId;
            
          -- Set pra_LA_Text = fir_LA_Text
          UPDATE pra_PayrollAccount 
             SET pra_LA_Text = (
                SELECT fir_LA_Text 
                  FROM buy_BusinessYear
                  JOIN fir_Firm ON fir_UId = buy_FirUId
                 WHERE buy_UId = :pi_BuyUId
             )
            WHERE pra_UId = :iNewPraUId;
 
            bIstOK = 1;

        END 
        ELSE 
        BEGIN
   
          IF ( bPraIstVerbucht = 0 ) THEN
            bIstOK = 1;
        
        END
        
      END

    END

  END


  -- Erste unverbuchte Abrechnung aus PRA_PayrollAccont suchen, sonst letzte verbuchte Abrecnnung 

  pi_PraUId  = 0;
  
  FOR 
    SELECT pra_UId, pra_IstVerbucht, prg_IstAktiv,
           COALESCE( pra_AnzMitInAbre, 0)
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
      LEFT JOIN prg_PayrollGroup   ON prg_UId    = pra_PrgUId  
     WHERE prm_BuyUId = :pi_BuyUId
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe
      INTO :iPraUId, :bPraIstVerbucht, :bPrgIstAktiv, :iAnzMitInAbre
  DO 
  BEGIN

    pi_PraUId = iPraUId;
    
    IF ( bPraIstVerbucht = 0 ) THEN
    BEGIN

      IF (( iAnzMitInAbre = 0 ) AND ( bPrgIstAktiv = 0 )) THEN
      BEGIN
        
        EXECUTE PROCEDURE sp_Pra_Delete :iPraUId;

      END
      ELSE
        EXIT;

    END

  END

END!!


COMMENT ON PROCEDURE sp_Pra_CheckNextAccount IS 'This procedure determines the UID of the next billing to be processed' !!

COMMENT ON PARAMETER sp_Pra_CheckNextAccount.pi_BuyUId IS 'Business Year Id'!!
COMMENT ON PARAMETER sp_Pra_CheckNextAccount.pi_UsrUId IS 'Application active user Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_DeleteEmptyAccounts 
(
  pi_BuyUId DI_UID  -- Business year UId
)
AS

  -- The procedure deletes all empty and not fixed records. The procedure is executing when closing 
  -- the form SalaryManageFRM
  
  DECLARE VARIABLE iPraUId        DI_UID;
  DECLARE VARIABLE iAnzMitInabre  DI_INT;
  DECLARE VARIABLE bIstVerbucht   DB_BOOLEAN;
  
BEGIN

  -- Alle nicht verbuchten und leeren Abrechnungen entfernen 

  FOR
   
    SELECT pra_UId, pra_IstVerbucht, COALESCE( pra_AnzMitInabre, 0 )
      FROM pra_PayrollAccount
      JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
      JOIN prg_PayrollGroup ON prg_UId = pra_PrgUId
     WHERE prm_BuyUId = :pi_BuyUId
       AND prm_Monat  > 0
     ORDER BY prm_Monat DESC, prg_SortNr DESC, prm_AbreNr DESC
      INTO :iPraUId, :bIstVerbucht, :iAnzMitInabre
  DO
  BEGIN
    
    IF ( bIstVerbucht = 1 OR iAnzMitInabre > 0 ) THEN LEAVE;    
    
    EXECUTE PROCEDURE sp_Pra_Delete :iPraUId;    
        
  END

END!!


COMMENT ON PROCEDURE sp_Pra_DeleteEmptyAccounts IS 'The procedure deletes all empty and not fixed records' !!
COMMENT ON PARAMETER sp_Pra_DeleteEmptyAccounts.pi_BuyUId IS 'Business year UId'!!

COMMIT!!

-- FS#1567:END
-- +++


-- +++
-- FS#1571 - PKLohn - Fix Bruttolohn in TaxDeclarationUNT

CREATE OR ALTER PROCEDURE sp_Rpt_InfoForTaxDeclaration
(
  pi_FiiUId     DI_UID
)
RETURNS
(  
  fir_Code            DS_CODE, 
  fir_PeidNr          DS_STR20,
  fir_Bezeichnung     DS_DESCR,
  fir_Strasse         DS_STR50,
  fir_HausNr          DS_STR5,
  fir_Plz             DS_PLZ,
  fir_Ort             DS_STR50,
  buy_GeschJahr       DI_BUSINESSYEAR,
  emp_PeidNr          DS_STR20,
  emp_Name            DS_STR50,       
  emp_Vorname         DS_STR50,  
  emp_Strasse         DS_STR50,     
  emp_HausNr          DS_STR5,
  emp_Plz             DS_PLZ, 
  emp_SteuerGde       DS_PLZ,
  emp_Ort             DS_STR50,  
  emp_Aufenthalt      DS_ONECHARFLAG,
  coi_IsoCode         DS_CODE,  
  emp_GeburtsDatum    DD_DATE,
  lohn_Brutto         DN_NUMBER2, 
  k1_Beitrag_Ag       DN_NUMBER2,
  k1_Pflicht          DN_NUMBER2,
  start_date          DD_DATE,   
  end_date            DD_DATE
)
AS

  -- Get info for tax declaration

BEGIN  
  
  FOR
  
    SELECT fir_Code,    fir_PeidNr,       fir_Bezeichnung,  fir_Strasse,    
           fir_HausNr,  fir_Plz,          fir_Ort,          buy_GeschJahr,
           emp_PeidNr,  emp_Name,         emp_Vorname,      emp_Strasse,     emp_HausNr,
           emp_Plz,     emp_SteuerGde,    emp_Ort,          emp_Aufenthalt,  
           coi_IsoCode, emp_GeburtsDatum, lohn_Brutto,      k1_Beitrag_Ag,   k1_Pflicht,  
           start_date,  end_date
      FROM sp_Rpt_AnnualSte( :pi_FiiUId )
      JOIN (
            SELECT MIN( emy_PjAnfang ) AS start_date, MAX( emy_PjEnde ) AS end_date, emy_EmpUId
              FROM emy_EmploymentPeriod
             GROUP BY emy_EmpUId
           ) ON emy_EmpUId = emp_UId
   WHERE emp_UId IS NOT NULL
    INTO :fir_Code,    :fir_PeidNr,       :fir_Bezeichnung, :fir_Strasse,    
         :fir_HausNr,  :fir_Plz,          :fir_Ort,         :buy_GeschJahr,
         :emp_PeidNr,  :emp_Name,         :emp_Vorname,     :emp_Strasse,     :emp_HausNr,
         :emp_Plz,     :emp_SteuerGde,    :emp_Ort,         :emp_Aufenthalt,  
         :coi_IsoCode, :emp_GeburtsDatum, :lohn_Brutto,     :k1_Beitrag_Ag,   :k1_Pflicht, 
         :start_date,  :end_date
  
  DO
    SUSPEND;
  
END!!

COMMENT ON PROCEDURE sp_Rpt_InfoForTaxDeclaration IS 'Get info for tax declaration'!!
COMMENT ON PARAMETER sp_Rpt_InfoForTaxDeclaration.pi_FiiUId IS 'Firm institution UId'!!
COMMIT!!

-- FS#1571  :END
-- +++

SET TERM ;!!