﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.05.00
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1532 - PKLohn - AHVeasy export implementation

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERAHV
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_UID            DI_UID,
  EMY_BESGRAD        DN_NUMBER2_NN,
  EMY_MONATVON       DI_SMLINT,
  EMY_MONATBIS       DI_SMLINT,
  AHV_NICHTPFLICHT   DN_NUMBER2,
  ALV_PFLICHT        DN_NUMBER2,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMP_NATION         DS_STR2
)
AS

DECLARE VARIABLE SSTMT        VARCHAR(512);
DECLARE VARIABLE IBUYUID      DI_UID;
DECLARE VARIABLE SINTTYP      DS_STR3;
DECLARE VARIABLE ICOUNTER     DI_SMLINT;
DECLARE VARIABLE ISAXUID      DI_UID;
DECLARE VARIABLE SSAXBEZ      DS_DESCR;
DECLARE VARIABLE NFREI        DN_NUMBER2;
DECLARE VARIABLE NPFLICHT     DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN   DN_NUMBER2;
DECLARE VARIABLE ISDTUID      DI_UID;
DECLARE VARIABLE IEMYUID      DI_UID;
DECLARE VARIABLE DEMYPJANFANG DD_DATE;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
   WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT E.EMP_UID, Y.EMY_UID, Y.EMY_PJANFANG FROM EMP_EMPLOYEE E  '||
          'INNER JOIN EMY_EMPLOYMENTPERIOD Y  ON Y.EMY_EMPUID = E.EMP_UID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_AHV_FIIUID IS NOT NULL) AND (EMP_AHV_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (Y.EMY_ISUNEMPLOYED=0)' ;
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME, Y.EMY_PJANFANG ASC ' ;


  FOR 
    EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
    INTO :EMP_UID, :IEMYUID, :DEMYPJANFANG
  DO 
  BEGIN

    ISDTUID = 0;
    iCounter = 0;


    K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
    K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
    K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
    K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
    K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
    K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
    K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
    K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
    K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
    K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
    K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
    K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


    /* Get data from Employee */
    EMY_BESGRAD = 0;

    FOR
     SELECT EY.EMY_UID,
            EY.EMY_BESGRAD,
            SUBSTRING(EY.EMY_PJANFANG from 9 for 2) || '.' || SUBSTRING(EY.EMY_PJANFANG from 6 for 2),
            SUBSTRING(EY.EMY_PJENDE   from 9 for 2) || '.' || SUBSTRING(EY.EMY_PJENDE   from 6 for 2),
            EY.EMY_PJANFANG,
            EY.EMY_PJENDE
            
       FROM EMY_EMPLOYMENTPERIOD EY
      WHERE (EY.EMY_EMPUID=:EMP_UID) AND (EY.EMY_UID=:IEMYUID) AND (EY.EMY_ISUNEMPLOYED=0)
      ORDER BY EMY_PJANFANG
      
       INTO :EMY_UID,
            :EMY_BESGRAD,
            :EMY_MONATVON,
            :EMY_MONATBIS,
            :EMY_PJANFANG,
            :EMY_PJENDE
    DO
    BEGIN
      IF (EMY_BESGRAD IS NULL) THEN EMY_BESGRAD = 0;
    END

    FOR 
      SELECT SAX_UID,
             MONATVON,
             MONATBIS,
             BRUTTOLOHN,
             FREIBETRAG,
             PFLICHTLOHN,
             BEITRAGAG,
             BEITRAGAN    
             
        FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp, :ISDTUID, :EMY_UID )
       WHERE MONATVON IS NOT NULL
       ORDER BY SAX_UID
       
        INTO :iSaxUID,
             :PRM_MONATVON,
             :PRM_MONATBIS,
             :LOHN_BRUTTO, 
             :nFrei, 
             :nPflicht,
             :nBeitragAG,
             :nBeitragAN
    DO 
    BEGIN

      SELECT SAX_BEZEICHNUNG 
        FROM SAX_SALARYCATEGORIE
       WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

      iCounter = iCounter + 1; 

      IF (iCounter = 1) THEN 
      BEGIN        

        K1_SAXUID     = iSaxUID;
        K1_SAXBEZ     = sSaxBez;
        K1_PFLICHT    = nPflicht;
        K1_FREIBETRAG = nFrei;
        K1_BEITRAG_AN = nBeitragAN;
        K1_BEITRAG_AG = nBeitragAG;
        
        AHV_NICHTPFLICHT = LOHN_BRUTTO - nPflicht;

      END 
      ELSE IF (iCounter = 2) THEN 
      BEGIN        

        K2_SAXUID     = iSaxUID;
        K2_SAXBEZ     = sSaxBez;
        K2_PFLICHT    = nPflicht;
        K2_FREIBETRAG = nFrei;
        K2_BEITRAG_AN = nBeitragAN;
        K2_BEITRAG_AG = nBeitragAG;

      END 
      ELSE IF (iCounter = 3) THEN 
      BEGIN        

        K3_SAXUID     = iSaxUID;
        K3_SAXBEZ     = sSaxBez;
        K3_PFLICHT    = nPflicht;
        K3_FREIBETRAG = nFrei;
        K3_BEITRAG_AN = nBeitragAN;
        K3_BEITRAG_AG = nBeitragAG;

      END 
      ELSE IF (iCounter = 4) THEN 
      BEGIN        

        K4_SAXUID     = iSaxUID;
        K4_SAXBEZ     = sSaxBez;
        K4_PFLICHT    = nPflicht;
        K4_FREIBETRAG = nFrei;
        K4_BEITRAG_AN = nBeitragAN;
        K4_BEITRAG_AG = nBeitragAG;

      END

    END


    FOR 
      SELECT SAX_UID,
             MONATVON,
             MONATBIS,
             BRUTTOLOHN,
             FREIBETRAG,
             PFLICHTLOHN,
             BEITRAGAG,
             BEITRAGAN     
             
        FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, 'ALV', :ISDTUID, :EMY_UID )
       WHERE MONATVON IS NOT NULL
       ORDER BY SAX_UID
       
        INTO :iSaxUID,
             :PRM_MONATVON,
             :PRM_MONATBIS,
             :LOHN_BRUTTO, 
             :nFrei, 
             :nPflicht,
             :nBeitragAG,
             :nBeitragAN
    DO 
    BEGIN
      ALV_PFLICHT = nPflicht;
    END


    IF (iCounter > 0) THEN 
    BEGIN

      -- Get data from Employee
      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C1.COI_ISOCODE,    /* related to EMP_LANDUID */
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             UPPER(E.EMP_GESCHLECHT),
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM,
             C2.COI_ISOCODE   /* related to EMP_NATIONUID */

        FROM EMP_EMPLOYEE E

        LEFT OUTER JOIN COI_COUNTRYISO C1 ON C1.COI_UID = E.EMP_LANDUID
        LEFT OUTER JOIN COI_COUNTRYISO C2 ON C2.COI_UID = E.EMP_NATIONUID
 
       WHERE E.EMP_UID = :EMP_UID

        INTO :EMP_PERSNR,
             :EMP_PEIDNR,
             :EMP_NAME,
             :EMP_VORNAME,
             :EMP_STRASSE,
             :emp_HausNr,
             :COI_ISOCODE,
             :EMP_PLZ,
             :EMP_ORT, 
             :EMP_GEBURTSDATUM, 
             :EMP_PENSIONDATUM, 
             :EMP_GESCHLECHT,
             :EMP_EINTRITTSDATUM,
             :EMP_AUSTRITTSDATUM,
             :EMP_NATION;

      SUSPEND;

    END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERAHV IS 'Get data for the report: Quarter \ AHV Quartalsmeldung (AHV Quarter)'!!

COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALAHV 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    EMY_UID            DI_UID,
    EMY_BESGRAD        DN_NUMBER2_NN,
    EMY_MONATVON       DI_SMLINT,
    EMY_MONATBIS       DI_SMLINT,
    AHV_NICHTPFLICHT   DN_NUMBER2,
    ALV_PFLICHT        DN_NUMBER2,
    EMY_PJANFANG       DD_DATE,
    EMY_PJENDE         DD_DATE,
    EMP_NATION         DS_STR2
)
AS

DECLARE VARIABLE IALVFIIUID DI_UID;
DECLARE VARIABLE NK1PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK2PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK3PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK4PLICHT  DN_NUMBER2;

BEGIN

  FOR 
    SELECT EMP_UID,
           PRM_MONATVON,
           PRM_MONATBIS,
           LOHN_BRUTTO,
           K1_SAXUID,
           K1_SAXBEZ,
           K1_PFLICHT,
           K1_FREIBETRAG,
           K1_BEITRAG_AN,
           K1_BEITRAG_AG,
           K2_SAXUID,
           K2_SAXBEZ,
           K2_PFLICHT,
           K2_FREIBETRAG,
           K2_BEITRAG_AN,
           K2_BEITRAG_AG,
           K3_SAXUID,
           K3_SAXBEZ,
           K3_PFLICHT,
           K3_FREIBETRAG,
           K3_BEITRAG_AN,
           K3_BEITRAG_AG,
           K4_SAXUID,
           K4_SAXBEZ,
           K4_PFLICHT,
           K4_FREIBETRAG,
           K4_BEITRAG_AN,
           K4_BEITRAG_AG,
           BUY_GESCHJAHR,
           FIR_CODE,
           FIR_BEZEICHNUNG,
           FIR_BEZEICHNUNG2,
           FIR_STRASSE,
           fir_HausNr,
           FIR_PLZ,
           FIR_ORT,
           FII_ABRECHNUNGNR,
           FII_CODE,
           FII_NAME,
           FII_NAMEZUSATZ,
           FII_STRASSE,
           FII_PLZ,
           FII_ORT,
           FII_CONTACTPERSON,
           FII_TELNR,
           FII_EMAIL,
           FII_ANNUALCHK,
           FII_ANNUALTEXT,
           EMP_PERSNR,
           EMP_PEIDNR,
           EMP_NAME,
           EMP_VORNAME,
           EMP_STRASSE,
           emp_HausNr,
           COI_ISOCODE,
           EMP_PLZ,
           EMP_ORT,
           EMP_GEBURTSDATUM,
           EMP_PENSIONDATUM,
           UPPER(EMP_GESCHLECHT),
           EMP_EINTRITTSDATUM,
           EMP_AUSTRITTSDATUM,
           EMY_UID,
           EMY_BESGRAD,
           EMY_MONATVON,
           EMY_MONATBIS,
           AHV_NICHTPFLICHT,
           ALV_PFLICHT,
           EMY_PJANFANG,
           EMY_PJENDE,
           EMP_NATION

      FROM SP_RPT_QUARTERAHV (:PI_FIIUID,1,12,:PI_EMPUID,:PI_LANDUID,:PI_DEPUID,:PI_CATUID,:PI_PRGUID)

      INTO :EMP_UID,
           :PRM_MONATVON,
           :PRM_MONATBIS,
           :LOHN_BRUTTO,
           :K1_SAXUID,
           :K1_SAXBEZ,
           :K1_PFLICHT,
           :K1_FREIBETRAG,
           :K1_BEITRAG_AN,
           :K1_BEITRAG_AG,
           :K2_SAXUID,
           :K2_SAXBEZ,
           :K2_PFLICHT,
           :K2_FREIBETRAG,
           :K2_BEITRAG_AN,
           :K2_BEITRAG_AG,
           :K3_SAXUID,
           :K3_SAXBEZ,
           :K3_PFLICHT,
           :K3_FREIBETRAG,
           :K3_BEITRAG_AN,
           :K3_BEITRAG_AG,
           :K4_SAXUID,
           :K4_SAXBEZ,
           :K4_PFLICHT,
           :K4_FREIBETRAG,
           :K4_BEITRAG_AN,
           :K4_BEITRAG_AG,
           :BUY_GESCHJAHR,
           :FIR_CODE,
           :FIR_BEZEICHNUNG,
           :FIR_BEZEICHNUNG2,
           :FIR_STRASSE,
           :fir_HausNr,
           :FIR_PLZ,
           :FIR_ORT,
           :FII_ABRECHNUNGNR,
           :FII_CODE,
           :FII_NAME,
           :FII_NAMEZUSATZ,
           :FII_STRASSE,
           :FII_PLZ,
           :FII_ORT,
           :FII_CONTACTPERSON,
           :FII_TELNR,
           :FII_EMAIL,
           :FII_ANNUALCHK,
           :FII_ANNUALTEXT,
           :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT,
           :EMP_GEBURTSDATUM,
           :EMP_PENSIONDATUM,
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM,
           :EMY_UID,
           :EMY_BESGRAD,
           :EMY_MONATVON,
           :EMY_MONATBIS,
           :AHV_NICHTPFLICHT,
           :ALV_PFLICHT,
           :EMY_PJANFANG,
           :EMY_PJENDE,
           :EMP_NATION
  DO 
  BEGIN

    /* Letzter BesGrad des Mitarbeiters ermitteln --
    EMY_BESGRAD = 0;
    FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD
        WHERE (EMY_EMPUID=:EMP_UID) AND EMY_ISUNEMPLOYED = 0
        ORDER BY EMY_PJANFANG
        INTO :EMY_BESGRAD
    DO BEGIN
       IF (EMY_BESGRAD IS NULL) THEN EMY_BESGRAD = 0;  
    END     */

     
    /* ALV-Pflichtige Lohnsumme des Mitarbeiters ermitteln --  */
    /* ALV_PFLICHT = 0;   */

    iALVFiiUID  = 0;
    nK1Plicht   = 0;
    nK2Plicht   = 0;
    nK3Plicht   = 0;
    nK4Plicht   = 0;

    SELECT EMP_ALV_FIIUID 
      FROM EMP_EMPLOYEE 
     WHERE EMP_UID = :EMP_UID
      INTO :iALVFiiUID; 

     
    SELECT SUM(K1_PFLICHT),
           SUM(K2_PFLICHT),
           SUM(K3_PFLICHT),
           SUM(K4_PFLICHT) 

      FROM SP_RPT_QUARTERALV (:iALVFiiUID, 1, 12, :EMP_UID)

      INTO :nK1Plicht,
           :nK2Plicht,
           :nK3Plicht,
           :nK4Plicht;


    IF (nK1Plicht IS NULL) THEN nK1Plicht = 0; 
    IF (nK2Plicht IS NULL) THEN nK2Plicht = 0; 
    IF (nK3Plicht IS NULL) THEN nK3Plicht = 0; 
    IF (nK4Plicht IS NULL) THEN nK4Plicht = 0; 

    /*ALV_PFLICHT =  nK1Plicht + nK2Plicht + nK3Plicht + nK4Plicht;*/

    SUSPEND;         

  END 

END!!

COMMIT!!

-- +++

EXECUTE BLOCK
AS

  -- Fill accounting reports

DECLARE VARIABLE   iAfr_UId  DI_UID;
DECLARE VARIABLE   iApg_UId  DI_UID;
DECLARE VARIABLE   iUsr_UId  DI_UID;
DECLARE VARIABLE   iApr_UId  DI_UID;
DECLARE VARIABLE   iApt_UId  DI_UID;
DECLARE VARIABLE   iAfa_UId  DI_UID;
DECLARE VARIABLE   iCount    DI_INT;

BEGIN  

  SELECT COUNT(*)
    FROM apt_AppTemplate
   INNER JOIN apr_AppReport ON apr_UId = apt_AprUId
   INNER JOIN afr_AppForm   ON afr_UId = apr_AfrUId
   WHERE apt_Name  = 'Jahresabrechnung AHV'
     AND afr_Class = 'TfrmExportAHVEasy'
    INTO :iCount;

  IF ( iCount > 0 ) THEN EXIT;
  
  iApg_UId = NULL; 
  iUsr_UId = 1;

  -- search Basisdaten group

  SELECT MIN( apg_UId )
    FROM apg_AppObjectGroup
   WHERE apg_Typ  = 'F'          
     AND apg_Name = UPPER( 'Basisdaten' ) 
    INTO :iApg_UId;

  IF ( iApg_UId IS NULL ) THEN EXIT;
              
  -- store form
  EXECUTE PROCEDURE sp_Afr_Insert :iApg_UId, 'AHVeasy Export', '', 'TfrmExportAHVEasy', :iUsr_UId
   RETURNING_VALUES :iAfr_UId;
  
    EXECUTE PROCEDURE sp_Apr_Insert :iAfr_UId, 2, 'Jahresabrechnungen', 'Jahresabrechnungen Report', 1, 1
     RETURNING_VALUES :iApr_UId;
     
        EXECUTE PROCEDURE sp_Apt_Insert :iApr_UId, 'Jahresabrechnung AHV', 'Jahresabrechnung AHV.fr3', '', 1, 1, 1  
         RETURNING_VALUES :iApt_UId;
         
    EXECUTE PROCEDURE sp_Afa_Insert :iAfr_UId, 0,  6, 'Report Drucken', 0, 1  
      RETURNING_VALUES :iAfa_UId;
    
END!!

COMMIT!!

-- FS#1532 :END
-- +++

-- ++++++++

-- +++
-- FS#1541 - PKLohn - Document Assitant additional email fields

UPDATE par_Parameter
   SET par_Code       = 'EMAIL_LOHNABRSUBJECT',
       par_Bezeich    = 'Global Email Lohnabrechnung default subject'
 WHERE par_Code       = 'EMAIL_SUBJECT'
   AND par_MastPrefix = 'APP'!!
   
UPDATE par_Parameter
   SET par_Code       = 'EMAIL_LOHNABRTEXT',
       par_Bezeich    = 'Global Email Lohnabrechnung default text'
 WHERE par_Code       = 'EMAIL_TEXT'
   AND par_MastPrefix = 'APP'!!

COMMIT!!
     
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fir_Select'!!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_EmailSubject TO fir_EmailLohnabrSubject!!
ALTER TABLE fir_Firm ALTER fir_EmailText    TO fir_EmailLohnabrText!!

COMMIT!!
  
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EmailLohnauswSubject', 'DS_STR255'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailLohnauswText',    'DS_STR1024' )!!

COMMIT!!

ALTER TABLE fir_Firm ALTER fir_EmailLohnabrText     POSITION 42!!
ALTER TABLE fir_Firm ALTER fir_EmailLohnauswSubject POSITION 43!!
ALTER TABLE fir_Firm ALTER fir_EMailLohnauswText    POSITION 44!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Strasse               DS_STR50,
    fir_HausNr                DS_STR5,
    fir_Postfach              DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_Telefon               DS_STR50,
    fir_Fax                   DS_STR50,
    fir_Email                 DS_STR50,
    fir_PeidNr                DS_STR12,
    fir_Notiz                 DS_TEXT,
    fir_CoiUId                DI_UID,
    fir_La_Text               DS_STR1024,
    fir_La_LayoutTyp          DS_ONECHARFLAG,
    fir_La_KopfTyp            DS_ONECHARFLAG,
    fir_La_SortTyp            DS_ONECHARFLAG,
    fir_La_Logoname           DS_STR50,
    fir_La_IstStunden         DB_BOOLEAN,
    fir_La_IstFerien          DB_BOOLEAN,
    fir_La_IstZahlstelle      DB_BOOLEAN,
    fir_LA_UseOwnTemplate     DB_BOOLEAN,
    fir_La_ReportTemplate     DS_STR2048,
    fir_LA_NameTauschen       DB_BOOLEAN,
    fir_Va_LayoutTyp          DS_ONECHARFLAG,
    fir_Va_KopfTyp            DS_ONECHARFLAG,
    fir_Va_Logoname           DS_STR50,
    fir_Dta_Pfad              DS_STR2048,
    fir_Dta_SpesenTyp         DS_ONECHARFLAG,
    fir_Ezag_Pfad             DS_STR2048,
    fir_Ezag_SpesenTyp        DS_ONECHARFLAG,
    fir_ISO_Pfad              DS_STR2048,
    fir_ISO_SpesenTyp         DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp        DS_ONECHARFLAG,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG,
    fir_EMailMode             DI_INT,
    fir_EMailSenderAddress    DS_STR128,
    fir_EMailSenderName       DS_STR128,
    fir_EmailLohnabrSubject   DS_STR255,
    fir_EmailLohnabrText      DS_STR1024,
    fir_EmailLohnauswSubject  DS_STR255,
    fir_EMailLohnauswText     DS_STR1024,
    fir_EMailHost             DS_STR128,
    fir_EMailPort             DI_INT,   
    fir_EMailTLS              DI_INT,
    fir_EMailTLSVer           DI_INT,    
    fir_EMailUser             DS_STR50, 
    fir_EMailPassword         DS_STR255,
    fir_LicCusCode            DS_STR50,
    fir_IstAktiv              DB_ISACTIVE,
    fir_CreateDate            DD_TIMESTAMP,
    fir_CreateUsrUId          DI_UID,
    fir_MutDate               DD_TIMESTAMP,
    fir_MutUsrUId             DI_UID,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CreateUser            DS_USERLOGIN,
    fir_MutUser               DS_USERLOGIN,
    coi_IsoCode               DS_CODE,
    coi_Bezeichnung           DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_LA_NameTauschen,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_ISO_Zahlungskategorie,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EmailLohnabrSubject,
           fir_EmailLohnabrText,
           fir_EmailLohnauswSubject,
           fir_EMailLohnauswText,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,
           fir_EMailTLSVer,           
           fir_EMailUser, 
           fir_EMailPassword,
           fir_LicCusCode,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_LA_NameTauschen,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_ISO_Zahlungskategorie,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EmailLohnabrSubject,
           :fir_EmailLohnabrText,
           :fir_EmailLohnauswSubject,
           :fir_EMailLohnauswText,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,
           :fir_EMailTLSVer,           
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_LicCusCode,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!


COMMENT ON PROCEDURE sp_Fir_Select IS 'Select Firm(s) data'!!

COMMENT ON PARAMETER sp_Fir_Select.pi_fir_UId  IS 'Id of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.ps_fir_Code IS 'Code of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.pb_IstAktiv IS 'If not null select with specific active flag only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUserGroup
(
    pi_UsgUId   DI_UID_NN,     -- User group ID
    pb_InFirm   DB_BOOLEAN_NN, -- Flag: 1 - User group have access to firm, 0 - user group has no access to firm
    pb_IstAktiv DB_BOOLEAN     -- If TRUE - then select active firms only
)
RETURNS
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Postfach              DS_STR50,
    fir_Strasse               DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_PlzOrt                DS_STR80,
    fir_IstAktiv              DB_BOOLEAN,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CoiUId                DI_UID,
    coi_IsoCode               DS_CODE,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG
)
AS

  -- Select firms accessable/restricted for the user group

BEGIN

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, fir_Bezeichnung2, 
           fir_Postfach,  fir_Strasse,  fir_Plz,         fir_ISO_Zahlungskategorie,
           fir_Ort,       fir_IstAktiv, cui_IsoCode,     cui_UId,         
           fir_CoiUId,    coi_IsoCode,  
           fir_Plz || ' ' || fir_Ort AS fir_PlzOrt
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsgUId
                    AND dtm_TabPrefix  = 'USG' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsgUId
                    AND dtm_TabPrefix  = 'USG' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv )
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,      :fir_Code,     :fir_Bezeichnung, :fir_Bezeichnung2,
           :fir_Postfach, :fir_Strasse,  :fir_Plz,         :fir_ISO_Zahlungskategorie,
           :fir_Ort,      :fir_IstAktiv, :fir_CuiIsoCode,  :fir_CuiUId, 
           :fir_CoiUId,   :coi_IsoCode,  :fir_PlzOrt 
  DO
    SUSPEND;

END!!

COMMIT!!

COMMENT ON PROCEDURE sp_Fir_SelectByUserGroup IS 'Select users whom has/has no access to firm'!!


COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pi_UsgUId   IS 'User group Id'!!
COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pb_InFirm   IS 'Flag: 1 - User group have access to firm, 0 - user group has no access to firm'!!
COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pb_IstAktiv IS 'If TRUE - then select active firms only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUser 
(
    pi_UsrUId     DI_UID_NN,
    pb_InFirm     DB_BOOLEAN_NN,
    pb_IstAktiv   DB_BOOLEAN
)
RETURNS 
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Postfach              DS_STR50,
    fir_Strasse               DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_PlzOrt                DS_STR80,
    fir_IstAktiv              DB_BOOLEAN,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CoiUId                DI_UID,
    coi_IsoCode               DS_CODE,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG
)
AS
  /* Select firms accessable/restricted for the user*/
  
  DECLARE iUsgUId  DI_UID;
  DECLARE sFirUIds DS_STR1024  DEFAULT '';
  DECLARE sFirUId  DS_STR50    DEFAULT '';
  

BEGIN  

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, fir_Bezeichnung2, 
           fir_Postfach,  fir_Strasse,  fir_Plz,         fir_ISO_Zahlungskategorie,
           fir_Ort,       fir_IstAktiv, cui_IsoCode,     cui_UId,         
           fir_CoiUId,    coi_IsoCode,  
           fir_Plz || ' ' || fir_Ort AS fir_PlzOrt
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv ) 
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,      :fir_Code,     :fir_Bezeichnung, :fir_Bezeichnung2,
           :fir_Postfach, :fir_Strasse,  :fir_Plz,         :fir_ISO_Zahlungskategorie,
           :fir_Ort,      :fir_IstAktiv, :fir_CuiIsoCode,  :fir_CuiUId, 
           :fir_CoiUId,   :coi_IsoCode,  :fir_PlzOrt     
  DO
  BEGIN
  
    IF ( sFirUIds <> '' ) THEN
      sFirUIds = sFirUIds || ',';
      
    sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
    
    SUSPEND;
    
  END

  /* +++*/
    
  FOR
  
    SELECT usg_UId
      FROM usg_UserGroup      
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR usg_IstAktiv = :pb_IstAktiv )  
     ORDER BY usg_Name   
      INTO :iUsgUId
    
  DO
  BEGIN
    
    FOR
    
      SELECT fir_UId,       fir_Code,     fir_Bezeichnung, fir_Bezeichnung2, 
             fir_Postfach,  fir_Strasse,  fir_Plz,         fir_ISO_Zahlungskategorie,
             fir_Ort,       fir_IstAktiv, fir_CuiIsoCode,  fir_CuiUId,         
             fir_CoiUId,    coi_IsoCode,  
             fir_Plz || ' ' || fir_Ort AS fir_PlzOrt
        FROM sp_Fir_SelectByUserGroup( :iUsgUId, :pb_InFirm, :pb_IstAktiv )
        INTO :fir_UId,      :fir_Code,     :fir_Bezeichnung, :fir_Bezeichnung2,
             :fir_Postfach, :fir_Strasse,  :fir_Plz,         :fir_ISO_Zahlungskategorie,
             :fir_Ort,      :fir_IstAktiv, :fir_CuiIsoCode,  :fir_CuiUId, 
             :fir_CoiUId,   :coi_IsoCode,  :fir_PlzOrt 
             
    DO
    BEGIN
    
      sFirUId = CAST( fir_UId AS DS_STR50 );
      
      IF ( POSITION( sFirUId IN sFirUIds ) = 0 ) THEN      
        SUSPEND;

      IF ( sFirUIds <> '' ) THEN
        sFirUIds = sFirUIds || ',';
      
      sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
      
    END
    
  END

END!!
COMMIT!!

-- FS#1541 :END
-- +++

SET TERM ;!!