﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.04.00
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1442 - PKLohn - Error when add firm access rights


CREATE OR ALTER PROCEDURE sp_Emp_Select
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR50,
    emp_EmailPasswort     DS_STR50,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR,
    arf_UId               DI_UID
)                             
AS
  /* Select Employee data by Id or by Employee*/

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;
  DECLARE iVortragFerien       DI_INT;
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN

  SELECT buy_FirUId, buy_GeschJahr,
         EXTRACT(YEAR FROM buy_DatumVon),
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;

  SELECT buy_UId
    FROM buy_BusinessYear
   WHERE buy_FirUId    = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
     AND buy_UId       > 0
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_EmailPasswort,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_Code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,

           (
            SELECT E.emp_UId
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,

           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_EmailPasswort,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_Code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,

           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,

           :luk_Zivilstand

  DO
  BEGIN

    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;
    
    SELECT arf_UId 
      FROM arf_ArchiveFolder
     INNER JOIN arl_ArchiveLink ON arl_ArfUId = arf_UId
     WHERE arl_LinkedPrefix = 'EMP'
       AND arl_LinkedUId    = :emp_UId
      INTO arf_UId;

    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN

      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END

      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END

    END


    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;

      SUSPEND;

    END

  END

END!!

COMMIT!!


COMMENT ON PROCEDURE sp_Emp_Select IS 'Select Employee(s) data'!!

COMMENT ON PARAMETER sp_Emp_Select.pi_BuyUId IS 'Id of the Business Year'!!

COMMIT!!

-- FS#1442 :END
-- +++

-- ++++++++

-- +++
-- FS#1514 - PKLohn - Update Sozialfonds Reports

UPDATE apd_AppPdfTemplate 
   SET apd_Name      = 'Eintritt Mitarbeiter',
       apd_Schablone = 'SF_Report_EintrittMitarbeiter.pdf'
 WHERE apd_Name      = 'Eintritt Mitarbeiter (Obligatorisch)'!!
 
DELETE FROM apd_AppPdfTemplate WHERE apd_Name = 'Eintritt Mitarbeiter (Ueberobligatorisch)'!!

COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'emp_Employee', 'emp_ZivilstandSeit', 'DD_DATE' )!!

COMMIT!!

ALTER TABLE emp_Employee ALTER emp_ZivilstandSeit POSITION 22!!

COMMIT!!

COMMENT ON COLUMN emp_Employee.emp_ZivilstandSeit IS 'Date when EMP_ZIVILSTAND is valid from'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Select
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_ZivilstandSeit    DD_DATE,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR50,
    emp_EmailPasswort     DS_STR50,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR,
    arf_UId               DI_UID
)                             
AS
  /* Select Employee data by Id or by Employee*/

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;
  DECLARE iVortragFerien       DI_INT;
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN

  SELECT buy_FirUId, buy_GeschJahr,
         EXTRACT(YEAR FROM buy_DatumVon),
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;

  SELECT buy_UId
    FROM buy_BusinessYear
   WHERE buy_FirUId    = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
     AND buy_UId       > 0
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_ZivilstandSeit,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_EmailPasswort,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_Code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,

           (
            SELECT E.emp_UId
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,

           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_ZivilstandSeit,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_EmailPasswort,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_Code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,

           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,

           :luk_Zivilstand

  DO
  BEGIN

    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;
    
    SELECT arf_UId 
      FROM arf_ArchiveFolder
     INNER JOIN arl_ArchiveLink ON arl_ArfUId = arf_UId
     WHERE arl_LinkedPrefix = 'EMP'
       AND arl_LinkedUId    = :emp_UId
      INTO arf_UId;

    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN

      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END

      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END

    END


    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;

      SUSPEND;

    END

  END

END!!

COMMIT!!


COMMENT ON PROCEDURE sp_Emp_Select IS 'Select Employee(s) data'!!

COMMENT ON PARAMETER sp_Emp_Select.pi_BuyUId IS 'Id of the Business Year'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_Insert'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_Update'!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Insert
(
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    pd_emp_ZivilstandSeit   DD_DATE,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR50,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,    
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_IstCh            DB_BOOLEAN,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN,
    ps_emp_EmailPasswort    DS_STR50,
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
RETURNS( emp_UId DI_UID_NN )
AS

  -- Add a new Employee and return Employee Id
  
  DECLARE bIsIndustrialHours     DB_BOOLEAN;
  DECLARE iVortragStd            DI_INT;    
  DECLARE iVortragFerien         DI_INT;    

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
   
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  emp_UId = GEN_ID (GEN_Emp_UId, 1);

  INSERT INTO emp_Employee
  (
    emp_UId,
    emp_BuyUId,
    emp_PersNr,
    emp_PEIDNr,
    emp_Name,
    emp_Vorname,
    emp_Strasse,
    emp_HausNr,
    emp_LandUId,
    emp_PLZ,
    emp_Ort,
    emp_GeburtsDatum,
    emp_PensionDatum,
    emp_Geschlecht,
    emp_EintrittsDatum,
    emp_AustrittsDatum,
    emp_Zivilstand,
    emp_ZivilstandSeit,
    emp_Aufenthalt,
    emp_NationUId,
    emp_HeimatOrt,
    emp_AnzKinder,
    emp_Telefon,
    emp_Handy,
    emp_Email,
    emp_EmailPasswort,
    emp_Beruf,
    emp_Stellung,
    emp_Lohnklasse,
    emp_DepUId,
    emp_CatUId,
    emp_PrgUId,
    emp_EmiUId,
    emp_AHV_FiiUId,
    emp_ALV_FiiUId,
    emp_PK_FiiUId,
    emp_KKP_FiiUId,
    emp_KKT_FiiUId,
    emp_UNF_FiiUId,
    emp_STE_FiiUId,
    emp_ZPK_FiiUId,
    emp_VortragStd,
    emp_VortragFerien,
    emp_SonderFerien,
    emp_AnspruchFerien,
    emp_IstCh,
    emp_LA_IstStunden,
    emp_LA_IstFerien,
    emp_LA_IstZahlstelle,
    emp_IstAktiv,
    emp_CreateDate,
    emp_CreateUsrUId,
    emp_MutDate,
    emp_MutUsrUId
  )
  VALUES
  (
    :emp_UId,
    :pi_emp_BuyUId,
    :pi_emp_PersNr,
    :ps_emp_PEIDNr,
    :ps_emp_Name,
    :ps_emp_Vorname,
    :ps_emp_Strasse,
    :ps_emp_HausNr,
    :pi_emp_LandUId,
    :ps_emp_PLZ,
    :ps_emp_Ort,
    :pd_emp_GeburtsDatum,
    :pd_emp_PensionDatum,
    :ps_emp_Geschlecht,
    :pd_emp_EintrittsDatum,
    :pd_emp_AustrittsDatum,
    :ps_emp_Zivilstand,
    :pd_emp_ZivilstandSeit,
    :ps_emp_Aufenthalt,
    :pi_emp_NationUId,
    :ps_emp_HeimatOrt,
    :pi_emp_AnzKinder,
    :ps_emp_Telefon,
    :ps_emp_Handy,
    :ps_emp_Email,
    :ps_emp_EmailPasswort,
    :ps_emp_Beruf,
    :ps_emp_Stellung,
    :ps_emp_Lohnklasse,
    :pi_emp_DepUId,
    :pi_emp_CatUId,
    :pi_emp_PrgUId,
    :pi_emp_EmiUId,
    :pi_emp_AHV_FiiUId,
    :pi_emp_ALV_FiiUId,
    :pi_emp_PK_FiiUId,
    :pi_emp_KKP_FiiUId,
    :pi_emp_KKT_FiiUId,
    :pi_emp_UNF_FiiUId,
    :pi_emp_STE_FiiUId,
    :pi_emp_ZPK_FiiUId,
    :iVortragStd,
    :iVortragFerien,
    :pn_emp_SonderFerien,
    :pn_emp_AnspruchFerien,
    :pb_emp_IstCh,
    :pb_emp_LA_IstStunden,
    :pb_emp_LA_IstFerien,
    :pb_emp_LA_IstZahlstelle,
    :pb_emp_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!

COMMENT ON PROCEDURE sp_Emp_Insert IS 'Add a new Employee and return Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_ZivilstandSeit   IS 'Marital status date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Update
(
    pi_emp_UId              DI_UID_NN,
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_SteuerGde        DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    pd_emp_ZivilstandSeit   DD_DATE,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR50,
    ps_emp_EmailPasswort    DS_STR50,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,
    pb_emp_IstCh            DB_BOOLEAN,
    ps_emp_Ch_PeidNr        DS_STR20,
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN, 
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
AS

  -- Update Employee data by Id
  
  DECLARE bIsIndustrialHours DB_BOOLEAN;
  DECLARE iVortragStd        DI_INT;  
  DECLARE iVortragFerien     DI_INT;  

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
  
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  UPDATE emp_Employee
     SET emp_BuyUId           = :pi_emp_BuyUId          ,
         emp_PersNr           = :pi_emp_PersNr          ,
         emp_PEIDNr           = :ps_emp_PEIDNr          ,
         emp_Name             = :ps_emp_Name            ,
         emp_Vorname          = :ps_emp_Vorname         ,
         emp_Strasse          = :ps_emp_Strasse         ,
         emp_HausNr           = :ps_emp_HausNr          ,
         emp_LandUId          = :pi_emp_LandUId         ,
         emp_PLZ              = :ps_emp_PLZ             ,
         emp_SteuerGde        = :ps_emp_SteuerGde       ,
         emp_Ort              = :ps_emp_Ort             ,
         emp_GeburtsDatum     = :pd_emp_GeburtsDatum    ,
         emp_PensionDatum     = :pd_emp_PensionDatum    ,
         emp_Geschlecht       = :ps_emp_Geschlecht      ,
         emp_EintrittsDatum   = :pd_emp_EintrittsDatum  ,
         emp_AustrittsDatum   = :pd_emp_AustrittsDatum  ,
         emp_Zivilstand       = :ps_emp_Zivilstand      ,
         emp_ZivilstandSeit   = :pd_emp_ZivilstandSeit  ,
         emp_Aufenthalt       = :ps_emp_Aufenthalt      ,
         emp_NationUId        = :pi_emp_NationUId       ,
         emp_HeimatOrt        = :ps_emp_HeimatOrt       ,
         emp_AnzKinder        = :pi_emp_AnzKinder       ,
         emp_Telefon          = :ps_emp_Telefon         ,
         emp_Handy            = :ps_emp_Handy           ,
         emp_Email            = :ps_emp_Email           ,
         emp_EmailPasswort    = :ps_emp_EmailPasswort   ,
         emp_Beruf            = :ps_emp_Beruf           ,
         emp_Stellung         = :ps_emp_Stellung        ,
         emp_Lohnklasse       = :ps_emp_Lohnklasse      ,
         emp_IstCh            = :pb_emp_IstCh           ,
         emp_Ch_PeidNr        = :ps_emp_Ch_PeidNr       ,
         emp_DepUId           = :pi_emp_DepUId          ,
         emp_CatUId           = :pi_emp_CatUId          ,
         emp_PrgUId           = :pi_emp_PrgUId          ,
         emp_EmiUId           = :pi_emp_EmiUId          ,
         emp_AHV_FiiUId       = :pi_emp_AHV_FiiUId      ,
         emp_ALV_FiiUId       = :pi_emp_ALV_FiiUId      ,
         emp_PK_FiiUId        = :pi_emp_PK_FiiUId       ,
         emp_KKP_FiiUId       = :pi_emp_KKP_FiiUId      ,
         emp_KKT_FiiUId       = :pi_emp_KKT_FiiUId      ,
         emp_UNF_FiiUId       = :pi_emp_UNF_FiiUId      ,
         emp_STE_FiiUId       = :pi_emp_STE_FiiUId      ,
         emp_ZPK_FiiUId       = :pi_emp_ZPK_FiiUId      ,
         emp_VortragStd       = :iVortragStd            ,
         emp_VortragFerien    = :iVortragFerien         ,
         emp_SonderFerien     = :pn_emp_SonderFerien    ,
         emp_AnspruchFerien   = :pn_emp_AnspruchFerien  ,
         emp_LA_IstStunden    = :pb_emp_LA_IstStunden   ,
         emp_LA_IstFerien     = :pb_emp_LA_IstFerien    ,
         emp_LA_IstZahlstelle = :pb_emp_LA_IstZahlstelle,
         emp_IstAktiv         = :pb_emp_IstAktiv        ,
         emp_MutDate          = Current_TimeStamp       ,
         emp_MutUsrUId        = :pi_app_ActiveUser
   WHERE emp_UId              = :pi_emp_UId;

END!!

COMMENT ON PROCEDURE sp_Emp_Update IS 'Update Employee by Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Update.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_ZivilstandSeit   IS 'Marital status date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- FS#1514 :END
-- +++

-- +++
-- FS#1516 - PKLohn - Bug in Firm ExportImport

CREATE OR ALTER PROCEDURE sp_Fii_Select
(
   pi_BuyUId        DI_UID     DEFAULT NULL,  -- Business year Id
   pi_IntUId        DI_UID     DEFAULT NULL,  -- Institution type Id
   pb_IstAktiv      DB_BOOLEAN DEFAULT NULL   -- If not null select with specific active flag only
)
RETURNS
(
  fii_UId           DI_UID,
  fii_BuyUId        DI_UID,
  fii_IntUId        DI_UID,
  fii_AbrechnungNr  DS_STR20,
  fii_Code          DS_CODE,
  fii_Name          DS_STR50,
  fii_NameZusatz    DS_STR50,
  fii_Strasse       DS_STR50,
  fii_PLZ           DS_PLZ,
  fii_Ort           DS_STR50,
  fii_A1_SdtUId     DI_UID,	
  fii_A2_SdtUId     DI_UID,	
  fii_A3_SdtUId     DI_UID,	
  fii_A4_SdtUId     DI_UID,  
  fii_ContactPerson DS_STR50,    
  fii_TelNr         DS_STR20,    
  fii_EMail         DS_STR50,    
  fii_AnnualChk     DB_BOOLEAN,  
  fii_AnnualText    DS_STR150,   
  fii_IstAktiv      DB_ISACTIVE,
  fii_CreateDate    DD_TIMESTAMP,
  fii_CreateUsrUId  DI_UID,
  fii_MutDate       DD_TIMESTAMP,
  fii_MutUsrUId     DI_UID,
  int_Typ           DS_STR3,
  int_Bezeichnung   DS_DESCR,
  sdt_A1_Lart       DS_STR5,
  sdt_A2_Lart       DS_STR5,
  sdt_A3_Lart       DS_STR5,
  sdt_A4_Lart       DS_STR5,
  arf_UId           DI_UID
)
AS

  -- Select institution records 

BEGIN

  FOR
    SELECT -- Firm institution columns
           fii_UId,          fii_BuyUId,       fii_IntUId,        fii_AbrechnungNr,
           fii_Code,         fii_Name,         fii_NameZusatz,    fii_Strasse,
           fii_PLZ,          fii_Ort,          fii_A1_SdtUId,     fii_A2_SdtUId,
           fii_A3_SdtUId,    fii_A4_SdtUId,    fii_ContactPerson, fii_TelNr, 
           fii_EMail,        fii_AnnualChk,    fii_AnnualText,    fii_IstAktiv,   
           fii_CreateDate,   fii_CreateUsrUId, fii_MutDate,       fii_MutUsrUId,
           -- Institution type columns
           int_Typ, int_Bezeichnung,
           -- Deductions columns
           A1.sdt_Lart, 
           A2.sdt_Lart, 
           A3.sdt_Lart, 
           A4.sdt_Lart
      FROM fii_FirmInstitution
      LEFT JOIN int_InstitutionType        ON int_UId    = fii_IntUId
      LEFT JOIN sdt_SalaryDeductionType A1 ON A1.sdt_UId = fii_A1_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A2 ON A2.sdt_UId = fii_A2_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A3 ON A3.sdt_UId = fii_A3_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A4 ON A4.sdt_UId = fii_A4_SdtUId
     WHERE ( :pi_BuyUId     IS NULL OR fii_BuyUId   = :pi_BuyUId )
       AND ( :pi_IntUId     IS NULL OR fii_IntUId   = :pi_IntUId )
       AND ( :pb_IstAktiv   IS NULL OR fii_IstAktiv = :pb_IstAktiv   )
      INTO -- Firm institution columns
           :fii_UId,          :fii_BuyUId,       :fii_IntUId,        :fii_AbrechnungNr,
           :fii_Code,         :fii_Name,         :fii_NameZusatz,    :fii_Strasse,
           :fii_PLZ,          :fii_Ort,          :fii_A1_SdtUId,     :fii_A2_SdtUId,
           :fii_A3_SdtUId,    :fii_A4_SdtUId,    :fii_ContactPerson, :fii_TelNr, 
           :fii_EMail,        :fii_AnnualChk,    :fii_AnnualText,    :fii_IstAktiv,   
           :fii_CreateDate,   :fii_CreateUsrUId, :fii_MutDate,       :fii_MutUsrUId,
           -- Institution type columns
           int_Typ, int_Bezeichnung,
           -- Deductions columns
           :sdt_A1_Lart, 
           :sdt_A2_Lart, 
           :sdt_A3_Lart,
           :sdt_A4_Lart 
  DO           
  BEGIN
    
    SELECT arf_UId 
      FROM arf_ArchiveFolder
     INNER JOIN arl_ArchiveLink ON arl_ArfUId = arf_UId
     WHERE arl_LinkedPrefix = 'FII'
       AND arl_LinkedUId    = :fii_UId
      INTO arf_UId;
      
    SUSPEND;
    
  END
    
END!!


COMMENT ON PROCEDURE sp_Fii_Select IS 'Select firm Institution record (possible ony one record by Id)'!!

COMMENT ON PARAMETER sp_Fii_Select.pi_BuyUId     IS 'Business year Id'!!
COMMENT ON PARAMETER sp_Fii_Select.pi_IntUId     IS 'Institution type Id'!!
COMMENT ON PARAMETER sp_Fii_Select.pb_IstAktiv   IS 'If not null select with specific active flag only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fib_Select
(
   pi_BuyUId   DI_UID     DEFAULT NULL,  -- Id of the firm banks record to be selected
   pb_IstAktiv DB_BOOLEAN DEFAULT NULL   -- If not null select with specific active flag only
)
RETURNS
(
  fib_UId           DI_UID,  
  fib_BuyUId        DI_UID,
  fib_BanUId        DI_UID,         
  fib_DTAAbsenderID DS_STR5,           
  fib_DTAZlgArt     DS_ONECHARFLAG, 
  fib_KontoNr       DS_STR35,          
  fib_IBANNr        DS_STR35,          
  fib_AcnUId        DI_UID,            
  fib_IstAktiv      DB_ISACTIVE,
  fib_CreateDate    DD_TIMESTAMP,
  fib_CreateUsrUId  DI_UID,
  fib_MutDate       DD_TIMESTAMP,
  fib_MutUsrUId     DI_UID,
  ban_Code          DS_BANK,
  ban_Name          DS_STR50,
  ban_Strasse       DS_STR50,
  ban_Postfach      DS_STR50,
  ban_PLZ           DS_PLZ,
  ban_Ort           DS_STR50,
  ban_BCNR          DS_STR5,
  ban_SWIFT         DS_STR15,
  ban_IstInland     DB_BOOLEAN,
  ban_KontoArt      DI_SMLINT,
  acn_Konto         DS_STR13,
  acn_Bezeichnung   DS_STR50,
  arf_UId           DI_UID
)
AS

  -- Select insitution records (possible ony one record by Id)

BEGIN

  FOR
    SELECT -- Firm banks columns
           fib_UId,        fib_BanUId,       fib_DTAAbsenderID, fib_DTAZlgArt, 
           fib_KontoNr,    fib_IBANNr,       fib_AcnUId,        fib_IstAktiv,
           fib_CreateDate, fib_CreateUsrUId, fib_MutDate,       fib_MutUsrUId,
           fib_BuyUId,
           -- Bank columns
           ban_Code,       ban_Name,         ban_Strasse,       ban_Postfach,
           ban_PLZ,        ban_Ort,          ban_BCNR,          ban_SWIFT,
           ban_IstInland,  ban_KontoArt,
           -- Accounts columns
           acn_Konto,      acn_Bezeichnung
      FROM fib_FirmBank
      LEFT JOIN ban_Bank          ON ban_UId = fib_BanUId
      LEFT JOIN acn_AccountNumber ON acn_UId = fib_AcnUId
     WHERE ( :pi_BuyUId   IS NULL OR fib_BuyUId   = :pi_BuyUId   )
       AND ( :pb_IstAktiv IS NULL OR fib_IstAktiv = :pb_IstAktiv )
      INTO -- Firm banks columns
           :fib_UId,        :fib_BanUId,       :fib_DTAAbsenderID, :fib_DTAZlgArt, 
           :fib_KontoNr,    :fib_IBANNr,       :fib_AcnUId,        :fib_IstAktiv,
           :fib_CreateDate, :fib_CreateUsrUId, :fib_MutDate,       :fib_MutUsrUId,
           :fib_BuyUId,
           -- Bank columns
           :ban_Code,       :ban_Name,         :ban_Strasse,       :ban_Postfach,
           :ban_PLZ,        :ban_Ort,          :ban_BCNR,          :ban_SWIFT,
           :ban_IstInland,  :ban_KontoArt,
           -- Accounts columns
           :acn_Konto,      :acn_Bezeichnung
  DO  
  BEGIN  
  
    SELECT arf_UId 
      FROM arf_ArchiveFolder
     INNER JOIN arl_ArchiveLink ON arl_ArfUId = arf_UId
     WHERE arl_LinkedPrefix = 'FIB'
       AND arl_LinkedUId    = :fib_UId
      INTO arf_UId;
  
    SUSPEND;
    
  END
  
END!!


COMMENT ON PROCEDURE sp_Fib_Select IS 'Select firm banks record (possible ony one record by Id)'!!

COMMENT ON PARAMETER sp_Fib_Select.pi_BuyUId     IS 'Busness year Id'!!
COMMENT ON PARAMETER sp_Fib_Select.pb_IstAktiv   IS 'If not null select with specific active flag only'!!

COMMIT!!

-- FS#1516 :END
-- +++

SET TERM ;!!