﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.03.00
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1480 - PKLohn - Error when add firm access rights

CREATE OR ALTER PROCEDURE SP_RPT_QUATERANNUAL_HLP 
(
  PI_EMPUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PS_INT_TYP  DS_STR3,
  PI_SDTUID   DI_UID,
  PI_EMYUID   DI_UID
)
RETURNS 
(
  EMP_UID     DI_UID,
  SAX_UID     DI_UID,
  SDT_UID     DI_UID,
  MONATVON    DI_SMLINT,
  MONATBIS    DI_SMLINT,
  BRUTTOLOHN  DN_NUMBER2,
  FREIBETRAG  DN_NUMBER2,
  PFLICHTLOHN DN_NUMBER2,
  BEITRAGAG   DN_NUMBER2,
  BEITRAGAN   DN_NUMBER2
)
AS

DECLARE VARIABLE BOK        DI_SMLINT;
DECLARE VARIABLE IBUYUID    DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NFREIBET   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

    -- Das Return-Field "Freibetrag" wird nicht mehr benutzt ------------------------
    FREIBETRAG = 0.0;
   

    EMP_UID = PI_EMPUID;
  
    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)
           AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))

    INTO :BRUTTOLOHN,:MONATVON,:MONATBIS;   



     -- Basis(pflichtiger Lohn) und Beitraege rechnen ------------------------------

     SELECT EMP_BUYUID FROM EMP_EMPLOYEE E
         WHERE EMP_UID=:PI_EMPUID
     INTO :iBuyUId;

    bOk = 0;

    FOR SELECT DISTINCT TX.SAX_UID
        FROM EMP_EMPLOYEE E
        INNER JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_EMPUID = E.EMP_UID
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
        WHERE (E.EMP_BUYUID=:iBuyUId) AND (A.PRA_ISTVERBUCHT = 1) AND
              (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND
              (TI.INT_TYP=:PS_INT_TYP) AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))

        ORDER BY TX.SAX_UID

        INTO :SAX_UID

    DO BEGIN

       bOk = 1;

       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;
       NBEITRAGAN = 0.0;


       --  Alle Lohnarten "Prozent von BASIS" ------------------------------------------
       SELECT SUM(D.SAD_BASIS)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND (C.SCT_CALCTYPE in (2,3,4))
            AND (E.EMP_UID=:PI_EMPUID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
            AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
            AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NPFLICHT;

       IF (NPFLICHT   IS NULL) THEN NPFLICHT   = 0.0;        

       PFLICHTLOHN   = NPFLICHT;


       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
             AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
             AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        

       BEITRAGAG     = NBEITRAGAG;
       BEITRAGAN     = NBEITRAGAN;


       --  Alle Lohnarten NICHT "Prozent von BASIS" ------------------------------------
       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;

       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE not in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
             AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
             AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        


       --  Total fuer Rueckgabe ---------------------------------------------------------

       PFLICHTLOHN   = PFLICHTLOHN + NPFLICHT;
       BEITRAGAG     = BEITRAGAG   + NBEITRAGAG;
       BEITRAGAN     = BEITRAGAN   + NBEITRAGAN;
       SDT_UID       = :PI_SDTUID;


       SUSPEND;

    END

    -- Bruttolohn zurueckgaben, falls keine Abzuege (zB bei STE)
    IF (bOk = 0) THEN 
       SUSPEND;


END!!

COMMENT ON PROCEDURE SP_RPT_QUATERANNUAL_HLP IS 'Helper procedure: get detail data for procedure sp_Rpt_QuaterXXX and sp_Rpt_AnnualXXX!! Rports Quartal and Annual'!!

COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PS_INT_TYP  IS 'Reports Institution Type (AHV, ALV, PK, KK, UNF, STE, ZPK)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_SDTUID   IS 'Salary or deduction type UId'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_EMYUID   IS 'Employment period UId'!!

COMMIT!!

-- FS#1480 :END
-- +++

SET TERM ;!!