﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.02.00
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1438 - PKLohn - Error when add firm access rights

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUser 
(
    pi_UsrUId     DI_UID_NN,
    pb_InFirm     DB_BOOLEAN_NN,
    pb_IstAktiv   DB_BOOLEAN
)
RETURNS 
(
    fir_UId         DI_UID,
    fir_Code        DS_CODE,
    fir_Bezeichnung DS_DESCR,
    fir_Postfach    DS_STR50,
    fir_Strasse     DS_STR50,
    fir_Plz         DS_PLZ,
    fir_Ort         DS_STR50,
    fir_PlzOrt      DS_STR80,
    fir_IstAktiv    DB_BOOLEAN,
    fir_CuiIsoCode  DS_CODE,
    fir_CuiUId      DI_UID,
    fir_CoiUId      DI_UID,
    coi_IsoCode     DS_CODE
)
AS
  /* Select firms accessable/restricted for the user*/
  
  DECLARE iUsgUId  DI_UID;
  DECLARE sFirUIds DS_STR1024  DEFAULT '';
  DECLARE sFirUId  DS_STR50    DEFAULT '';
  

BEGIN  

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
           fir_Postfach,  fir_Strasse,  fir_Plz,
           fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
           fir_IstAktiv,  cui_IsoCode,   cui_UId,
           fir_CoiUId,    coi_IsoCode
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv ) 
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
           :fir_Postfach,   :fir_Strasse,     :fir_Plz,
           :fir_Ort,        :fir_PlzOrt,
           :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
           :fir_CoiUId,     :coi_IsoCode
  DO
  BEGIN
  
    IF ( sFirUIds <> '' ) THEN
      sFirUIds = sFirUIds || ',';
      
    sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
    
    SUSPEND;
    
  END

  /* +++*/
    
  FOR
  
    SELECT usg_UId
      FROM usg_UserGroup      
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR usg_IstAktiv = :pb_IstAktiv )  
     ORDER BY usg_Name   
      INTO :iUsgUId
    
  DO
  BEGIN
    
    FOR
    
      SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
             fir_Postfach,  fir_Strasse,  fir_Plz,
             fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
             fir_IstAktiv,  fir_CuiIsoCode,   fir_CuiUId,
             fir_CoiUId,    coi_IsoCode
        FROM sp_Fir_SelectByUserGroup( :iUsgUId, :pb_InFirm, :pb_IstAktiv )
        INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
             :fir_Postfach,   :fir_Strasse,     :fir_Plz,
             :fir_Ort,        :fir_PlzOrt,
             :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
             :fir_CoiUId,     :coi_IsoCode
             
    DO
    BEGIN
    
      sFirUId = CAST( fir_UId AS DS_STR50 );
      
      IF ( POSITION( sFirUId IN sFirUIds ) = 0 ) THEN      
        SUSPEND;

      IF ( sFirUIds <> '' ) THEN
        sFirUIds = sFirUIds || ',';
      
      sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
      
    END
    
  END

END!!

COMMIT!!

-- FS#1438:END
-- +++


-- +++
-- FS#1391 - PKLohn - Performance Improvements

CREATE OR ALTER PROCEDURE sp_Rpt_QuaterAnnual_Hlp 
(
  pi_EmpUId   DI_UID,
  pi_MonatVon DI_SMLINT,
  pi_MonatBis DI_SMLINT,
  ps_Int_Typ  DS_STR3,
  pi_SdtUId   DI_UID,
  pi_EmyUId   DI_UID
)
RETURNS 
(
  emp_UId     DI_UID,
  sax_UId     DI_UID,
  sdt_UId     DI_UID,
  MonatVon    DI_SMLINT,
  MonatBis    DI_SMLINT,
  BruttoLohn  DN_NUMBER2,
  FreiBetrag  DN_NUMBER2,
  PflichtLohn DN_NUMBER2,
  BeitragAG   DN_NUMBER2,
  BeitragAN   DN_NUMBER2
)
AS

DECLARE VARIABLE bOK                DI_SMLINT;
DECLARE VARIABLE iBuyUId            DN_NUMBER2;
DECLARE VARIABLE nSumBasis          DN_NUMBER2;
DECLARE VARIABLE nSumBeitragAGBasis DN_NUMBER2;
DECLARE VARIABLE nSumBeitragANBasis DN_NUMBER2;
DECLARE VARIABLE nSumBeitragAG      DN_NUMBER2;
DECLARE VARIABLE nSumBeitragAN      DN_NUMBER2;

BEGIN
 
  emp_UId = pi_EmpUId;  

  -- Das Return-Field "FreiBetrag" wird nicht mehr benutzt ---------------------
  
  FreiBetrag = 0.0;
     
  
  -- BruttoLohn rechnen  -------------------------------------------------------   
  
  SELECT SUM( D.sad_Total ), 
         MIN( M.prm_Monat ), 
         MAX( M.prm_Monat ) 

    FROM emp_Employee E    

   INNER JOIN emy_EmploymentPeriod    Y ON Y.emy_EmpUId = E.emp_UId     
   INNER JOIN say_Salary              S ON S.say_EmyUId = Y.emy_UId               
   INNER JOIN sad_SalaryDetail        D ON D.sad_SayUId = S.say_UId
    LEFT JOIN sdt_SalaryDeductionType T ON T.sdt_UId    = D.sad_SdtUId 
    LEFT JOIN pra_PayrollAccount      A ON A.pra_UId    = S.say_PraUId        
    LEFT JOIN prm_PayrollMonth        M ON M.prm_UId    = A.pra_PrmUId      

   WHERE ( E.emp_UId = :pi_EmpUId ) 
     AND ( A.pra_IstVerbucht = 1  ) 
     AND ( M.prm_Monat       > 0  ) 
     AND ( M.prm_Monat BETWEEN :pi_MonatVon AND :pi_MonatBis ) 
     AND ( T.sdt_Typ         = 'L' ) 
     AND ( T.sdt_IstLohnTeil = 1   )
     AND ( :pi_EmyUId = 0 OR Y.emy_UId = :pi_EmyUId )

    INTO :BruttoLohn, :MonatVon, :MonatBis;   


  -- Basis(pflichtiger Lohn) und Beitraege rechnen -----------------------------

  SELECT emp_BuyUId 
    FROM emp_Employee E
   WHERE emp_UId=:pi_EmpUId
    INTO :iBuyUId;

  bOK = 0;

  FOR 
    SELECT DISTINCT TX.sax_UId
      FROM emp_Employee E
     INNER JOIN emy_EmploymentPeriod    Y  ON Y.emy_EmpUId = E.emp_UId
     INNER JOIN say_Salary              S  ON S.say_EmyUId = Y.emy_UId
     INNER JOIN sad_SalaryDetail        D  ON D.sad_SayUId = S.say_UId
      LEFT JOIN sdt_SalaryDeductionType T  ON T.sdt_UId    = D.sad_SdtUId
      LEFT JOIN int_InstitutionType     TI ON TI.int_UId   = T.sdt_IntUId
      LEFT JOIN sax_SalaryCategorie     TX ON TX.sax_UId   = T.sdt_SaxUId
      LEFT JOIN pra_PayrollAccount      A  ON A.pra_UId    = S.say_PraUId
      LEFT JOIN prm_PayrollMonth        M  ON M.prm_UId    = A.pra_PrmUId
     WHERE ( E.emp_BuyUId = :iBuyUId ) 
       AND ( A.pra_IstVerbucht = 1   ) 
       AND ( M.prm_Monat       > 0   ) 
       AND ( M.prm_Monat BETWEEN :pi_MonatVon AND :pi_MonatBis ) 
       AND ( T.sdt_Typ         = 'A'  ) 
       AND ( T.sdt_IstLohnTeil = 1    ) 
       AND ( TI.Int_Typ = :ps_Int_Typ ) 
       AND ( :pi_SdtUId=0 OR T.sdt_UId = :pi_SdtUId )
     ORDER BY TX.sax_UId
      INTO :sax_UId

  DO 
  BEGIN

    bOK = 1;

    SELECT -- Alle Lohnarten "Prozent von BASIS"
           SUM
           ( 
             CASE 
               WHEN ( T.sdt_ExcludeSalaryCalc = 0 )
                AND ( D.sad_AnsatzAN <> 0.0 OR D.sad_AnsatzAG <> 0.0 )
               THEN D.sad_Basis
               ELSE 0
             END 
           ) AS SUM_Basis,
           SUM
           ( 
             CASE 
               WHEN ( D.sad_AnsatzAN <> 0.0 OR D.sad_AnsatzAG <> 0.0 )
               THEN D.sad_BeitragAG
               ELSE 0
             END 
           ) AS SUM_BeitragAG_Basis,
           SUM
           ( 
             CASE 
               WHEN ( D.sad_AnsatzAN <> 0.0 OR D.sad_AnsatzAG <> 0.0 )
               THEN D.sad_BeitragAN
               ELSE 0
             END 
           ) AS SUM_BeitragAN_Basis,
           -- Alle Lohnarten NICHT "Prozent von BASIS"
           SUM( D.sad_BeitragAG ) AS SUM_BeitragAG,
           SUM( D.sad_BeitragAN ) AS SUM_BeitragAN

      FROM sdt_SalaryDeductiontype T

     LEFT  JOIN sct_SalaryCalcType   C ON C.sct_UId    = T.sdt_SCTUId
     INNER JOIN sad_SalaryDetail     D ON D.sad_SdtUId = T.sdt_UId
     LEFT  JOIN say_Salary           S ON S.say_UId    = D.sad_SayUId
     LEFT  JOIN pra_PayrollAccount   A ON A.pra_UId    = S.say_PraUId
     LEFT  JOIN prm_PayrollMonth     M ON M.prm_UId    = A.pra_PrmUId
     LEFT  JOIN emy_EmploymentPeriod Y ON Y.emy_UId    = S.say_EmyUId
     LEFT  JOIN emp_Employee         E ON E.emp_UId    = Y.emy_EmpUId

    WHERE ( E.emp_UId    = :pi_EmpUId ) 
      AND ( T.sdt_SaxUId = :sax_UId   )
      AND ( :pi_SdtUId = 0 OR T.sdt_UId = :pi_SdtUId )
      AND ( :pi_EmyUId = 0 OR Y.emy_UId = :pi_EmyUId )
      AND ( T.sdt_Typ         = 'A' )
      AND ( T.sdt_IstLohnTeil = 1   ) 
      AND ( A.pra_IstVerbucht = 1   )
      AND ( M.prm_Monat       > 0   )
      AND ( M.prm_Monat BETWEEN :pi_MonatVon AND :pi_MonatBis )
      AND ( C.sct_CalcType = 2 OR C.sct_CalcType = 3 OR C.sct_CalcType = 4 )
      
     INTO :nSumBasis, :nSumBeitragAGBasis, :nSumBeitragANBasis, :nSumBeitragAG, :nSumBeitragAN;
     
    PflichtLohn = COALESCE( nSumBasis, 0.0 );
  
    BeitragAG   = COALESCE( nSumBeitragAGBasis, 0.0 ) + COALESCE( nSumBeitragAG, 0.0 );
    BeitragAN   = COALESCE( nSumBeitragANBasis, 0.0 ) + COALESCE( nSumBeitragAN, 0.0 );
  
    sdt_UId     = :pi_SdtUId;


    SUSPEND;

  END

  -- BruttoLohn zurueckgaben, falls keine Abzuege (zB bei STE)
  IF (bOK = 0) THEN 
    SUSPEND;

END!!


COMMENT ON PROCEDURE sp_Rpt_QuaterAnnual_Hlp IS 'Helper procedure: get detail data for procedure sp_Rpt_QuaterXXX and sp_Rpt_AnnualXXX!! Rports Quartal and Annual'!!

COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.pi_EmpUId   IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.pi_MonatBis IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.pi_MonatVon IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.ps_Int_Typ  IS 'Reports Institution Type (AHV, ALV, PK, KK, UNF, STE, ZPK)'!!
COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.pi_SdtUId   IS 'Salary or deduction type UId'!!
COMMENT ON PARAMETER sp_Rpt_QuaterAnnual_Hlp.pi_EmyUId   IS 'Employment period UId'!!

COMMIT!!

-- FS#1391:END
-- +++


-- +++
-- FS#1447 - PKLohn - Add option for ISO20022 file

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_ISO_Zahlungskategorie', 'DS_ONECHARFLAG_NN DEFAULT ''1''' )!!

COMMIT!!

ALTER TABLE fir_Firm ALTER fir_ISO_Zahlungskategorie POSITION 37!!

COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_ISO_Zahlungskategorie IS 'ISO20022 Zahlungskategorie – Verwendung'!!

COMMIT!!

UPDATE fir_Firm SET fir_ISO_Zahlungskategorie = 1!!

COMMIT!!

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Strasse               DS_STR50,
    fir_HausNr                DS_STR5,
    fir_Postfach              DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_Telefon               DS_STR50,
    fir_Fax                   DS_STR50,
    fir_Email                 DS_STR50,
    fir_PeidNr                DS_STR12,
    fir_Notiz                 DS_TEXT,
    fir_CoiUId                DI_UID,
    fir_La_Text               DS_STR1024,
    fir_La_LayoutTyp          DS_ONECHARFLAG,
    fir_La_KopfTyp            DS_ONECHARFLAG,
    fir_La_SortTyp            DS_ONECHARFLAG,
    fir_La_Logoname           DS_STR50,
    fir_La_IstStunden         DB_BOOLEAN,
    fir_La_IstFerien          DB_BOOLEAN,
    fir_La_IstZahlstelle      DB_BOOLEAN,
    fir_LA_UseOwnTemplate     DB_BOOLEAN,
    fir_La_ReportTemplate     DS_STR2048,
    fir_LA_NameTauschen       DB_BOOLEAN,
    fir_Va_LayoutTyp          DS_ONECHARFLAG,
    fir_Va_KopfTyp            DS_ONECHARFLAG,
    fir_Va_Logoname           DS_STR50,
    fir_Dta_Pfad              DS_STR2048,
    fir_Dta_SpesenTyp         DS_ONECHARFLAG,
    fir_Ezag_Pfad             DS_STR2048,
    fir_Ezag_SpesenTyp        DS_ONECHARFLAG,
    fir_ISO_Pfad              DS_STR2048,
    fir_ISO_SpesenTyp         DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp        DS_ONECHARFLAG,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG,
    fir_EMailMode             DI_INT,
    fir_EMailSenderAddress    DS_STR128,
    fir_EMailSenderName       DS_STR128,
    fir_EMailSubject          DS_STR255,
    fir_EMailHost             DS_STR128,
    fir_EMailPort             DI_INT,   
    fir_EMailTLS              DI_INT,
    fir_EMailTLSVer           DI_INT,    
    fir_EMailUser             DS_STR50, 
    fir_EMailPassword         DS_STR255,
    fir_EMailText             DS_STR1024,
    fir_LicCusCode            DS_STR50,
    fir_IstAktiv              DB_ISACTIVE,
    fir_CreateDate            DD_TIMESTAMP,
    fir_CreateUsrUId          DI_UID,
    fir_MutDate               DD_TIMESTAMP,
    fir_MutUsrUId             DI_UID,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CreateUser            DS_USERLOGIN,
    fir_MutUser               DS_USERLOGIN,
    coi_IsoCode               DS_CODE,
    coi_Bezeichnung           DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_LA_NameTauschen,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_ISO_Zahlungskategorie,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,
           fir_EMailTLSVer,           
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_LicCusCode,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_LA_NameTauschen,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_ISO_Zahlungskategorie,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,
           :fir_EMailTLSVer,           
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           :fir_LicCusCode,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!

COMMENT ON PROCEDURE sp_Fir_Select IS 'Select Firm(s) data'!!

COMMENT ON PARAMETER sp_Fir_Select.pi_fir_UId  IS 'Id of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.ps_fir_Code IS 'Code of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.pb_IstAktiv IS 'If not null select with specific active flag only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUserGroup
(
    pi_UsgUId   DI_UID_NN,     -- User group ID
    pb_InFirm   DB_BOOLEAN_NN, -- Flag: 1 - User group have access to firm, 0 - user group has no access to firm
    pb_IstAktiv DB_BOOLEAN     -- If TRUE - then select active firms only
)
RETURNS
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Postfach              DS_STR50,
    fir_Strasse               DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_PlzOrt                DS_STR80,
    fir_IstAktiv              DB_BOOLEAN,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CoiUId                DI_UID,
    coi_IsoCode               DS_CODE,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG
)
AS

  -- Select firms accessable/restricted for the user group

BEGIN

  FOR

    SELECT fir_UId,       fir_Code,      fir_Bezeichnung, 
           fir_Postfach,  fir_Strasse,   fir_Plz,
           fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
           fir_IstAktiv,  cui_IsoCode,   cui_UId,
           fir_CoiUId,    coi_IsoCode,   fir_ISO_Zahlungskategorie
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsgUId
                    AND dtm_TabPrefix  = 'USG' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsgUId
                    AND dtm_TabPrefix  = 'USG' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv )
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
           :fir_Postfach,   :fir_Strasse,     :fir_Plz,
           :fir_Ort,        :fir_PlzOrt,
           :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
           :fir_CoiUId,     :coi_IsoCode,     :fir_ISO_Zahlungskategorie
  DO
    SUSPEND;

END!!

COMMIT!!

COMMENT ON PROCEDURE sp_Fir_SelectByUserGroup IS 'Select users whom has/has no access to firm'!!


COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pi_UsgUId   IS 'User group Id'!!
COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pb_InFirm   IS 'Flag: 1 - User group have access to firm, 0 - user group has no access to firm'!!
COMMENT ON PARAMETER sp_Fir_SelectByUserGroup.pb_IstAktiv IS 'If TRUE - then select active firms only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUser 
(
    pi_UsrUId     DI_UID_NN,
    pb_InFirm     DB_BOOLEAN_NN,
    pb_IstAktiv   DB_BOOLEAN
)
RETURNS 
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Postfach              DS_STR50,
    fir_Strasse               DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_PlzOrt                DS_STR80,
    fir_IstAktiv              DB_BOOLEAN,
    fir_CuiIsoCode            DS_CODE,
    fir_CuiUId                DI_UID,
    fir_CoiUId                DI_UID,
    coi_IsoCode               DS_CODE,
    fir_ISO_Zahlungskategorie DS_ONECHARFLAG
)
AS
  /* Select firms accessable/restricted for the user*/
  
  DECLARE iUsgUId  DI_UID;
  DECLARE sFirUIds DS_STR1024  DEFAULT '';
  DECLARE sFirUId  DS_STR50    DEFAULT '';
  

BEGIN  

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
           fir_Postfach,  fir_Strasse,  fir_Plz,
           fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
           fir_IstAktiv,  cui_IsoCode,  cui_UId,
           fir_CoiUId,    coi_IsoCode,  fir_ISO_Zahlungskategorie
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv ) 
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
           :fir_Postfach,   :fir_Strasse,     :fir_Plz,
           :fir_Ort,        :fir_PlzOrt,
           :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
           :fir_CoiUId,     :coi_IsoCode,     :fir_ISO_Zahlungskategorie
  DO
  BEGIN
  
    IF ( sFirUIds <> '' ) THEN
      sFirUIds = sFirUIds || ',';
      
    sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
    
    SUSPEND;
    
  END

  /* +++*/
    
  FOR
  
    SELECT usg_UId
      FROM usg_UserGroup      
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR usg_IstAktiv = :pb_IstAktiv )  
     ORDER BY usg_Name   
      INTO :iUsgUId
    
  DO
  BEGIN
    
    FOR
    
      SELECT fir_UId,       fir_Code,         fir_Bezeichnung, 
             fir_Postfach,  fir_Strasse,      fir_Plz,
             fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
             fir_IstAktiv,  fir_CuiIsoCode,   fir_CuiUId,
             fir_CoiUId,    coi_IsoCode,      fir_ISO_Zahlungskategorie
        FROM sp_Fir_SelectByUserGroup( :iUsgUId, :pb_InFirm, :pb_IstAktiv )
        INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
             :fir_Postfach,   :fir_Strasse,     :fir_Plz,
             :fir_Ort,        :fir_PlzOrt,
             :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
             :fir_CoiUId,     :coi_IsoCode,     :fir_ISO_Zahlungskategorie
             
    DO
    BEGIN
    
      sFirUId = CAST( fir_UId AS DS_STR50 );
      
      IF ( POSITION( sFirUId IN sFirUIds ) = 0 ) THEN      
        SUSPEND;

      IF ( sFirUIds <> '' ) THEN
        sFirUIds = sFirUIds || ',';
      
      sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
      
    END
    
  END

END!!
COMMIT!!

-- FS#1447:END
-- +++


-- +++
-- FS#1443 - PKLohn - Salary List Export

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALPK
(
  PI_FIIUID DI_UID,
  PI_EMPUID DI_UID  = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID  = NULL,
  PI_CATUID DI_UID  = NULL,
  PI_PRGUID DI_UID  = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  EMY_UID            DI_UID,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  EMY_ISUNEMPLOYED   DB_BOOLEAN,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FIR_PEIDNR         DS_STR20,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IEMY_UID   DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         F.fir_PeidNr,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :fir_PeidNr,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( T.SDT_EXCLUDESALARYCALC = 0     )
             AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALPK IS 'Get data for the report: Annual \ Jahresabrechnung PK (PK Annual)'!!

COMMIT!!

-- FS#1443 :END
-- +++


-- +++
-- FS#1452 - PKLohn - Add option for ISO20022 file

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'say_Salary', 'say_RptMail',    'DD_DATE' )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'say_Salary', 'say_RptFolder',  'DD_DATE' )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'say_Salary', 'say_RptArchive', 'DD_DATE' )!!
COMMIT!!

ALTER TABLE say_Salary ALTER say_RptMail    POSITION 10!!
COMMIT!!

ALTER TABLE say_Salary ALTER say_RptFolder  POSITION 11!!
COMMIT!!

ALTER TABLE say_Salary ALTER say_RptArchive POSITION 12!!
COMMIT!!

COMMENT ON COLUMN say_Salary.say_RptMail    IS 'Date when PRA report was sent to employee'!!
COMMENT ON COLUMN say_Salary.say_RptFolder  IS 'Date when PRA report was stored to folder'!!
COMMENT ON COLUMN say_Salary.say_RptArchive IS 'Date when PRA report was stored to archive'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'sar_SalaryReport', 'sar_RptMail',    'DD_DATE' )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'sar_SalaryReport', 'sar_RptFolder',  'DD_DATE' )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'sar_SalaryReport', 'sar_RptArchive', 'DD_DATE' )!!
COMMIT!!

ALTER TABLE sar_SalaryReport ALTER sar_RptMail    POSITION 78!!
COMMIT!!

ALTER TABLE sar_SalaryReport ALTER sar_RptFolder  POSITION 79!!
COMMIT!!

ALTER TABLE sar_SalaryReport ALTER sar_RptArchive POSITION 80!!
COMMIT!!

COMMENT ON COLUMN sar_SalaryReport.sar_RptMail    IS 'Date when salary report was sent to employee'!!
COMMENT ON COLUMN sar_SalaryReport.sar_RptFolder  IS 'Date when salary report was stored to folder'!!
COMMENT ON COLUMN sar_SalaryReport.sar_RptArchive IS 'Date when salary report was stored to archive'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'ard_ArchiveDocument', 'ard_SarUId', 'DI_UID' )!!
COMMIT!!

ALTER TABLE ard_ArchiveDocument ALTER ard_SarUId POSITION 4!!
COMMIT!!

COMMENT ON COLUMN ard_ArchiveDocument.ard_SarUId IS 'UId to regarding SAR entry in case of replacement'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ArdSar2Sar'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ArdSay2Say'!!
COMMIT!!

ALTER TABLE ard_ArchiveDocument
  ADD CONSTRAINT FK_ArdSay2Say
  FOREIGN KEY ( ard_SayUId )
  REFERENCES say_Salary( say_UId )
  ON DELETE SET NULL
  USING INDEX IDX_Ard_BySalary!!

ALTER TABLE ard_ArchiveDocument
  ADD CONSTRAINT FK_ArdSar2Sar
  FOREIGN KEY (ard_SarUId)
  REFERENCES sar_SalaryReport(sar_UId)
  ON DELETE SET NULL
  USING INDEX IDX_ARD_BySalaryReport!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sar_EmployeeList 
(
  pi_BuyUId   DI_UID
)
RETURNS 
(
    sar_UId           DI_UID,
    sar_Count         DI_INT,
    emp_UId           DI_UID,
    emp_BuyUId        DI_UID,
    emp_PersNr        DI_INT,
    emp_PeidNr        DS_STR20,
    emp_Name          DS_STR50,
    emp_Vorname       DS_STR50,
    emp_Strasse       DS_STR50,
    emp_HausNr        DS_STR5,
    emp_Aufenthalt    DS_ONECHARFLAG,
    emp_Email         DS_STR50,
    emp_EMailPasswort DS_STR50,
    coi_IsoCode       DS_CODE,
    fir_La_LayoutTyp  DS_ONECHARFLAG,
    fir_La_KopfTyp    DS_ONECHARFLAG,
    emp_MutDate       DD_TIMESTAMP,
    emp_MutUsrUId     DI_UID,
    sar_RptMail       DD_DATE,
    sar_RptFolder     DD_DATE,
    sar_RptArchive    DD_DATE
)
AS
  
  /* Get employee list for salary report, select all employees which have salary data*/
  DECLARE VARIABLE iPraUId DI_UID;

BEGIN

  FOR 
    SELECT E.emp_UId,
           E.emp_BuyUId,
           E.emp_PersNr,
           E.emp_PEIDNr,
           E.emp_Name,
           E.emp_Vorname,
           E.emp_Strasse,
           E.emp_HausNr,
           E.emp_Aufenthalt,
           E.emp_Email,
           E.emp_EMailPasswort,
           C.coi_IsoCode,
           F.fir_LA_LayoutTyp,
           F.fir_LA_KopfTyp,
           E.emp_MutDate,
           E.emp_MutUsrUId
      FROM emp_Employee E
      LEFT JOIN buy_BusinessYear Y  ON Y.buy_UId = E.emp_BuyUId
      LEFT JOIN fir_Firm         F  ON F.fir_UId = Y.buy_FirUId
      LEFT JOIN coi_CountryISO   C  ON C.coi_UId = E.emp_LandUId

     WHERE emp_BuyUId = :pi_BuyUId

     INTO  :emp_uid, 
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_Aufenthalt,
           :emp_Email,
           :emp_EMailPasswort,
           :coi_IsoCode,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :emp_MutDate,
           :emp_MutUsrUId
  DO 
  BEGIN

    sar_UId = NULL;    
    
    SELECT sar_UId, 
           sar_RptMail,
           sar_RptFolder,
           sar_RptArchive
      FROM sar_SalaryReport
     WHERE sar_EmpUId = :emp_uid
      INTO :sar_UId,
           :sar_RptMail,
           :sar_RptFolder,
           :sar_RptArchive;
      
    SELECT COUNT(sar_UId)
      FROM sar_SalaryReport
      JOIN emp_Employee ON emp_UId = sar_EmpUId
     WHERE emp_BuyUId = :pi_BuyUId
      INTO :sar_Count;

    SUSPEND;
    
  END
  
END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_EmployeeList 
(
    PI_PRAUID DI_UID
)
RETURNS 
(
    emp_UId             DI_UID,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_LandUId         DI_UID,
    emp_DepCode         DS_DESCR,
    emp_CatCode         DS_DESCR,
    emp_Aufenthalt      DS_DESCR,
    emp_Hausnr          DS_STR5,
    coi_IsoCode         DS_CODE,
    coi_Bezeichnung     DS_DESCR,
    emp_Plz             DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_GeschlechtBezei DS_DESCR,
    emp_PrgUId          DI_UID,
    emp_Stellung        DS_STR50,
    emy_Besgrad         DN_NUMBER2,
    emy_Ivgrad          DN_NUMBER2,
    emp_Email           DS_STR50,
    emp_EMailPasswort   DS_STR50,
    say_UId             DI_UID,
    say_EmyUId          DI_UID,
    say_DatumVom        DD_DATE,
    say_DatumBis        DD_DATE,
    say_Anzdetails      DI_INT,
    say_BruttoLohn      DN_NUMBER2,
    say_NettoLohn       DN_NUMBER2,
    say_La_Text         DS_STR1024,
    say_JahresLohn      DN_NUMBER2,
    say_Status          DI_SMLINT,
    say_RptMail         DD_DATE,
    say_RptFolder       DD_DATE,
    say_RptArchive      DD_DATE,
    prm_Bezeichnung     DS_DESCR,
    buy_GeschJahr       DI_BUSINESSYEAR
)
AS
  /* The procedure creates the employee list in the form SalaryManageFRM for the ID <pi_PraUId>.  */
  /*                                                               */
  /* The procedure creates the list of employees in the form SalaryManageFRM. */
  /* Following is considered:*/
  /*   a) already existing accounts per employee                  */
  /*   b) Firm/BusninessYear settings "Lohnabrechnung gruppiert ..." */
  /*   c) Filter settings for special accounts in "Abrechnungsvorlagen" */
                                       
  DECLARE iBuyUId         DI_UID;
  DECLARE iPrmUId         DI_UID;
  DECLARE iPrmMonat       DI_SMLINT;
  DECLARE iPrmAbreNr      DI_SMLINT;
  DECLARE iPrmCoiUId      DI_UID;
  DECLARE iPrmDepUId      DI_UID;
  DECLARE iPrmCatUId      DI_UID;
  DECLARE iPrmPrgUId      DI_UID;
  DECLARE bPrmIstUnd      DB_BOOLEAN;
  DECLARE iPraPrgUId      DI_UID;
  DECLARE bPrgInMoAre     DB_BOOLEAN;
  DECLARE bPrgIstStandard DB_BOOLEAN;
  DECLARE dEmyPjAnfang    DD_DATE;
  DECLARE dEmyPjEnde      DD_DATE;
  DECLARE iEmpLandUId     DI_UID;
  DECLARE iEmpDepUId      DI_UID;
  DECLARE iEmpCatUId      DI_UID;
  DECLARE iEmpPrgUId      DI_UID;
  DECLARE bIstOK          DB_BOOLEAN;
  DECLARE bCoiIstOK       DB_BOOLEAN;
  DECLARE bDepIstOK       DB_BOOLEAN;
  DECLARE bCatIstOK       DB_BOOLEAN;
  DECLARE bPrgIstOK       DB_BOOLEAN;
  DECLARE bPrmIsGroupped  DB_BOOLEAN;
  DECLARE bSuspendRec     DB_BOOLEAN;
  DECLARE iEmptyStatus    DI_SMLINT;
  
BEGIN

  /* Abrechnungs-Infos */
  
  SELECT pra_PrgUId,      prm_BuyUId,     prm_UId,    prm_Monat,  prm_AbreNr,        prm_CoiUId, 
         prm_DepUId,      prm_CatUId,     prm_PrgUId, prm_IstUnd, prg_IstInMoAbrech, prg_IstStandard,
         prm_Bezeichnung, buy_GeschJahr,  prm_IstSoGruppiert
    FROM pra_PayrollAccount
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
    LEFT JOIN prg_PayrollGroup ON prg_UId = pra_PrgUId
    LEFT JOIN buy_BusinessYear ON buy_UId = prm_BuyUId
   WHERE pra_UId = :pi_PraUId 
    INTO :iPraPrgUId,      :iBuyUId,       :iPrmUId,    :iPrmMonat,  :iPrmAbreNr,  :iPrmCoiUId,
         :iPrmDepUId,      :iPrmCatUId,    :iPrmPrgUId, :bPrmIstUnd, :bPrgInMoAre, :bPrgIstStandard,
         :prm_Bezeichnung, :buy_GeschJahr, :bPrmIsGroupped;
         
         
  
  iEmptyStatus = -1;

  /* 1. Alle Mitarbeiter die bereits in der Abrechnung Lohndaten haben */

  FOR 
    SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,           
           emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
           emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
           emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   say_UId,         
           say_EmyUId,         say_DatumVom,       say_DatumBis,     say_AnzDetails,
           say_BruttoLohn,     say_NettoLohn,      say_LA_Text,      emy_BesGrad,
           emy_IVGrad,         emp_PrgUId,         coi_IsoCode,      emp_Stellung,
           dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung,  emp_Hausnr,
           emp_Email,          emp_EMailPasswort,  say_RptMail,      say_RptFolder,
           say_RptArchive,
           (
              SELECT IIF( COUNT(1) > 0, 1, 0 )
                FROM sad_SalaryDetail
                JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
               WHERE sad_SayUId = say_UId
                 AND sdt_IstVariabel = 1
           )
      FROM pra_PayrollAccount
     INNER JOIN say_Salary           ON say_PraUId = pra_UId
      LEFT JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
      LEFT JOIN emp_Employee         ON emp_UID    = emy_EmpUId
      LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId 
      LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
      LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
      LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
     WHERE pra_UId = :pi_PraUId
     ORDER BY emp_UId, emy_UId
      INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,           
           :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
           :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
           :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_UId,         
           :say_EmyUId,         :say_DatumVom,       :say_DatumBis,     :say_AnzDetails,
           :say_BruttoLohn,     :say_NettoLohn,      :say_LA_Text,      :emy_BesGrad,
           :emy_IVGrad,         :emp_PrgUId,         :coi_IsoCode,      :emp_Stellung,
           :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt,   :emp_Hausnr,
           :emp_Email,          :emp_EMailPasswort,  :say_RptMail,      :say_RptFolder,
           :say_RptArchive,
           :say_Status
  DO 
  BEGIN
  
     EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
       RETURNING_VALUES say_JahresLohn; 
       
     EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
       RETURNING_VALUES emp_GeschlechtBezei; 
       
     SUSPEND;
  END 


  IF ( iPrmAbreNr = 0 ) THEN 
  BEGIN

    /* Wenn Monatsabrechnung*/

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/

      /* Alle MA's, welche eine BesPeriode im aktuellen Monat haben und dieser Abrechnung noch */
      /* keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,         emp_PersNr,         emp_PeidNr,         emp_Name, 
               emp_Vorname,     emp_Strasse,        emp_LandUId,        coi_Bezeichnung,    
               emp_PLZ,         emp_ORT,            emp_GeburtsDatum,   emp_PensionDatum, 
               emp_Geschlecht,  emp_EintrittsDatum, emp_AustrittsDatum, emy_UId,  
               emy_PjAnfang,    emy_PjEnde,         emy_BesGrad,        emy_IVGrad,
               emp_PrgUId,      coi_IsoCode,        emp_Stellung,       :iEmptyStatus,
               dep_Bezeichnung, cat_Bezeichnung,    luk_Bezeichnung,    emp_Hausnr,
               emp_Email,       emp_EMailPasswort
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,        :emp_PersNr,         :emp_PeidNr,         :emp_Name,    
               :emp_Vorname,    :emp_Strasse,        :emp_LandUId,        :coi_Bezeichnung,    
               :emp_PLZ,        :emp_ORT,            :emp_GeburtsDatum,   :emp_PensionDatum, 
               :emp_Geschlecht, :emp_EintrittsDatum, :emp_AustrittsDatum, :say_EmyUId,  
               :dEmyPjAnfang,   :dEmyPjEnde,         :emy_BesGrad,        :emy_IVGrad,
               :emp_PrgUId,     :coi_IsoCode,        :emp_Stellung,       :say_Status,
               :emp_DepCode,    :emp_CatCode,        :emp_Aufenthalt,     :emp_Hausnr,
               :emp_Email,      :emp_EMailPasswort
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis */
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;
        say_RptMail    = NULL;      
        say_RptFolder  = NULL;
        say_RptArchive = NULL;
        
        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 

        SUSPEND;

      END 


    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       

      /* Alle MA's der Gruppe, welche eine BesPeriode im aktuellen Monat haben und in allen */
      /* Abrechnungen von diesem Monat noch keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emy_UId,         
               emy_PjAnfang,       emy_PjEnde,         emy_BesGrad,      emy_IVGrad,
               emp_PrgUId,         coi_IsoCode,        emp_Stellung,    :iEmptyStatus,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung, emp_Hausnr,
               emp_Email,          emp_EMailPasswort
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
          LEFT JOIN prg_PayrollGroup     ON prg_UId    = emp_PrgUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId         = :iBuyUId
           AND emp_PrgUId         = :iPraPrgUId
           AND prg_IstInMoAbrech  = 1
           AND emy_IsUnemployed   = 0 
           AND :iPrmMonat         >= EXTRACT(MONTH FROM emy_PjAnfang )
           AND :iPrmMonat         <= EXTRACT(MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_EmyUId,      
               :dEmyPjAnfang,       :dEmyPjEnde,         :emy_BesGrad,      :emy_IVGrad,
               :emp_PrgUId,         :coi_IsoCode,        :emp_Stellung,     :say_Status,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt,   :emp_Hausnr,
               :emp_Email,          :emp_EMailPasswort
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis*/
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;
        say_RptMail    = NULL;      
        say_RptFolder  = NULL;
        say_RptArchive = NULL;

        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 
          
        SUSPEND;

      END

    END

  END 
  ELSE 
  BEGIN

     /*** Wenn Sonderabrechnung ***/
     
    IF ( 
          ( 
            iPrmCoiUId IS NOT NULL
            OR
            iPrmDepUId IS NOT NULL
            OR 
            iPrmCatUId IS NOT NULL
            OR
            iPrmPrgUId IS NOT NULL
          )
          AND
          ( bPrmIsGroupped = 0 )
          AND 
          ( bPrmIstUnd     = 1 )
       )
    THEN
      bSuspendRec = 1;
    ELSE
      bSuspendRec = bPrmIsGroupped;
    

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/       

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,      emp_Hausnr,
               emp_Email,          emp_EMailPasswort,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,         :emp_Hausnr,
               :emp_Email,          :emp_EMailPasswort,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
        bPrgIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND ( emp_LandUId <> iPrmCoiUId ) ) THEN 
          bCoiIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1;

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId )
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;          

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId ) 
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;
                  
        /* PersonenGruppe als Filter definiert */
        IF ( ( iPrmPrgUId IS NOT NULL ) AND ( emp_PrgUId <> iPrmPrgUId ) )
        THEN
          bPrgIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmPrgUId IS NOT NULL ) ) THEN
          bPrgIstOK = 1;
                  

        /* UND- / ODER- Verknuepfung */
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN /* UND-Verknuepfung  */
          
          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) = 4 ) THEN
            bIstOK = 1;
            
        END 
        ELSE 
        BEGIN /* OR-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) > 0 ) THEN
            bIstOK = 1;

        END


        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von */
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;
          say_RptMail    = NULL;      
          say_RptFolder  = NULL;
          say_RptArchive = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
          
          SUSPEND;

        END

      END        

    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       
        
      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,   
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,      emp_Hausnr,
               emp_Email,          emp_EMailPasswort,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee 
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId       = :iBuyUId
           AND emp_PrgUId       = :iPraPrgUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat       >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat       <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount 
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,   
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,         :emp_Hausnr,
               :emp_Email,          :emp_EMailPasswort,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND (emp_LandUId <> iPrmCoiUId) )
        THEN 
          bCoiIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1; 

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId) 
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;   
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;
                  

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId )
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;


        /* UND- / ODER- Verknuepfung*/
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN   /* UND-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) = 3 ) THEN
            bIstOK = 1;

        END 
        ELSE 
        BEGIN  /* OR-Verknuepfung*/

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) > 0 ) THEN
            bIstOK = 1;

        END

        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von*/
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;
          say_RptMail    = NULL;      
          say_RptFolder  = NULL;
          say_RptArchive = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
            
          SUSPEND;

        END

      END
 
    END

  END

END!!
COMMIT!!

-- +++

EXECUTE BLOCK AS
BEGIN

  IF ( NOT EXISTS (SELECT 1 FROM par_Parameter WHERE par_Code = 'RPT_WINDOWS_FOLDER_PATH' AND par_MastPrefix = 'APP' ) ) THEN
  BEGIN
    
    INSERT INTO par_Parameter
    (
      par_UId,            
      par_MastUId,       
      par_MastPrefix,      
      par_Code,
      par_Bezeich,        
      par_Typ,           
      par_Val,             
      par_CreateDate,
      par_CreateUsrUId,   
      par_MutDate,       
      par_MutUsrUId
    )
    VALUES
    (
      GEN_ID( GEN_Par_UId, 1 ),           
      0,   
      'APP',  
      'RPT_WINDOWS_FOLDER_PATH',
      'Windows folder path for document assistant',    
      2,       
      'C:\Program Files (x86)\Sozialfonds\PKLohn\%FIRM%\%BUY%\%EMP%',         
      Current_TimeStamp,
      1, 
      Current_TimeStamp, 
      1
    );  
    
  END
  
END!!

COMMIT!!

-- FS#1452 :END
-- +++


-- +++
-- FS#1462 - PKLohn - Adjustment for Procedure sp_Emp_IsLastAccontInYear

create or alter procedure SP_EMP_ISLASTACCONTINYEAR 
(
    PI_EMPUID DI_UID,
    PI_PRAUID DI_UID
)
returns (
    PB_RESULT DB_BOOLEAN)
as
-- Check if the given account is the last account for the given employee
declare variable DEMYPJENDE DD_DATE;
declare variable IBUYUID DI_UID;
declare variable IPRGUID DI_UID;
declare variable IPRMMONAT DI_UID;
declare variable BBUYISTGRUPPIERT DB_BOOLEAN;
declare variable ILASTPRAUID DI_SMLINT;
declare variable ILASTPRGUID DI_SMLINT;
declare variable ILASTMONAT DI_SMLINT;
declare variable BFOUND DB_BOOLEAN;
declare variable IEMPPRGUID DI_UID;
BEGIN

  -- Prüft ob die letzte Abrechnung des Mitarbeiters im Jahr ist
  -- Entwerder beim Austritt oder im Dezember des lfd. Jahres  
  -- In der Lohnvorlage gibt es niemals eine letzte Abrechnung (Result = immer False)

  pb_Result = 0;

  -- Define business year Id
  
  SELECT M.prm_BuyUId, 
         M.prm_Monat,
         A.pra_PrgUId, 
         Y.buy_IstAbreGruppiert
    FROM pra_PayrollAccount A
    LEFT JOIN prm_PayrollMonth M ON M.prm_UId = A.PRA_PRMUId
    LEFT JOIN buy_BusinessYear Y ON Y.buy_UId = M.PRM_BuyUId
   WHERE pra_UId = :pi_PraUId 
    INTO :iBuyUId,
         :iPrmMONAT,
         :iPrgUId,
         :bBuyIstGruppiert;

  IF ( iBuyUId IS NULL ) THEN EXIT;
  IF ( iPrmMONAT = 0)    THEN EXIT;  -- Wenn Saylary-Template -> never LastAccount is True

  -- Letzte Beschaefigs-Datum des MA's ermitteln 
  FOR 
    SELECT emy_PjEnde 
      FROM emy_EmploymentPeriod
     WHERE emy_EmpUId       = :pi_EmpUId 
       AND emy_IsUnEmployed = 0
     ORDER BY emy_PjAnfang
      INTO :dEmyPjEnde
  DO 
  BEGIN
   
    IF (dEmyPjEnde IS NULL) THEN 
      dEmyPjEnde = 0;
     
  END
  
    -- Define employee payroll group
  
  SELECT emp_PrgUId
    FROM emp_Employee
   WHERE emp_UId       = :pi_EmpUId
    INTO :iEmpPrgUId;
  
  iLastMonat = EXTRACT( MONTH FROM :dEmyPjEnde );

  pb_Result = 1;
  bFound    = 0;
   
  FOR 
    SELECT prg_UId,
           pra_UId
      FROM sp_Pra_AccountList( :iBuyUId )    
     WHERE prm_Monat <= :iLastMonat
     ORDER BY prm_Monat, prm_AbreNr
      INTO :iLastPrgUId,
           :iLastPraUId   
  DO 
  BEGIN

    IF ( iLastPraUId IS NULL ) THEN 
      iLastPraUId = -1;

    IF ( ( bFound = 0 ) AND ( iLastPraUId = pi_PraUId) ) THEN 
    BEGIN

      bFound = 1; 

    END 
    ELSE 
    BEGIN

      IF ( bFound = 1 ) THEN 
      BEGIN 

        IF ( bBuyIstGruppiert = 1 ) THEN 
        BEGIN

          IF ( iLastPrgUId = iEmpPrgUId ) THEN 
            pb_Result = 0;
 
        END 
        ELSE 
        BEGIN

          pb_Result = 0;       

        END

      END
 
    END      

  END

 SUSPEND;

END!!

COMMIT!!

-- FS#1462 :END
-- +++

-- +++
-- FS#1461 - PKLohn - Adjustment for procedure SP_RPT_STATWAGEEXPENSESHLP

CREATE OR ALTER PROCEDURE SP_RPT_STATWAGEEXPENSESHLP 
(
  PI_PRAUID DI_UID,
  PI_EMPUID DI_UID
)
RETURNS 
(
  PRA_UID        DI_INT,
  EMY_UID        DI_INT,
  EMP_UID        DI_INT,
  PRM_MONAT      DI_SMLINT,
  BRUTTOLOHN     DN_NUMBER2,
  AHVLOHN        DN_NUMBER2,
  NETTOLOHN      DN_NUMBER2,
  AZBETRAG       DN_NUMBER2,
  SPALTE3_AG     DN_NUMBER2,
  SPALTE3_AN     DN_NUMBER2,
  SPALTE4_AG     DN_NUMBER2,
  SPALTE4_AN     DN_NUMBER2,
  SPALTE5_AG     DN_NUMBER2,
  SPALTE5_AN     DN_NUMBER2,
  SPALTE6_BASIS  DN_NUMBER2,
  SPALTE6_AG     DN_NUMBER2,
  SPALTE6_AN     DN_NUMBER2,
  SPALTE7_BASIS  DN_NUMBER2,
  SPALTE7_AG     DN_NUMBER2,
  SPALTE7_AN     DN_NUMBER2,
  SPALTE8_BASIS  DN_NUMBER2,
  SPALTE8_AG     DN_NUMBER2,
  SPALTE8_AN     DN_NUMBER2,
  SPALTE9_BASIS  DN_NUMBER2,
  SPALTE9_AG     DN_NUMBER2,
  SPALTE9_AN     DN_NUMBER2,
  SPALTE10_BASIS DN_NUMBER2,
  SPALTE10_AG    DN_NUMBER2,
  SPALTE10_AN    DN_NUMBER2,
  SPALTE11_BASIS DN_NUMBER2,
  SPALTE11_AG    DN_NUMBER2,
  SPALTE11_AN    DN_NUMBER2,
  SPALTE12_BASIS DN_NUMBER2,
  SPALTE12_AG    DN_NUMBER2,
  SPALTE12_AN    DN_NUMBER2,
  SPALTE13_BASIS DN_NUMBER2,
  SPALTE13_AG    DN_NUMBER2,
  SPALTE13_AN    DN_NUMBER2,
  SPALTE14_BASIS DN_NUMBER2,
  SPALTE14_AG    DN_NUMBER2,
  SPALTE14_AN    DN_NUMBER2
)
AS

DECLARE VARIABLE NSDT_EXCLUDESALARYCALC DB_BOOLEAN;
DECLARE VARIABLE SSDT_TYP               DS_ONECHARFLAG;
DECLARE VARIABLE BSDT_ISTLOHNTEIL       DB_BOOLEAN;
DECLARE VARIABLE BSTD_BASIS1            DB_BOOLEAN;
DECLARE VARIABLE NBETRAGAG              DN_NUMBER2;
DECLARE VARIABLE NBETRAGAN              DN_NUMBER2;
DECLARE VARIABLE NBASIS                 DN_NUMBER2;
DECLARE VARIABLE ISPALTENR              DI_SMLINT;
DECLARE VARIABLE NSAD_ANSATZAN          DN_NUMBER4;
DECLARE VARIABLE NSAD_ANSATZAG          DN_NUMBER4;
DECLARE VARIABLE NAG_KKLOHN             DN_NUMBER2;

BEGIN

   BruttoLohn     = 0;  NettoLohn      = 0; 
   AHVLohn        = 0;  AzBetrag       = 0;
   Spalte3_AG     = 0;  Spalte3_AN     = 0;  
   Spalte4_AG     = 0;  Spalte4_AN     = 0;  
   Spalte5_AG     = 0;  Spalte5_AN     = 0;  
   Spalte6_AG     = 0;  Spalte6_AN     = 0;  
   Spalte7_AG     = 0;  Spalte7_AN     = 0;  
   Spalte8_AG     = 0;  Spalte8_AN     = 0;  
   Spalte9_AG     = 0;  Spalte9_AN     = 0;  
   Spalte10_AG    = 0;  Spalte10_AN    = 0;  
   Spalte11_AG    = 0;  Spalte11_AN    = 0;  
   Spalte12_AG    = 0;  Spalte12_AN    = 0;   
   Spalte13_AG    = 0;  Spalte13_AN    = 0;   
   Spalte14_AG    = 0;  Spalte14_AN    = 0;  
   Spalte6_Basis  = 0;  Spalte7_Basis  = 0;  
   Spalte8_Basis  = 0;  Spalte9_Basis  = 0;  
   Spalte10_Basis = 0;  Spalte11_Basis = 0;  
   Spalte12_Basis = 0;  Spalte13_Basis = 0;  
   Spalte14_Basis = 0;  nAG_KKLohn     = 0;
   
   
   FOR SELECT sdt_Typ, sdt_IstLohnTeil, sdt_Basis1, sdt_EXCLUDESALARYCALC,
              pra_UId, emy_UId,         emy_EmpUId,
              COALESCE( sad_BeitragAG, 0 ), COALESCE( sad_BeitragAN, 0 ), COALESCE( sad_Basis,    0 ), 
              COALESCE( sad_AnsatzAN,  0 ), COALESCE( sad_AnsatzAG,  0 ), COALESCE( sax_SpalteNr, 0 ), 
              prm_Monat
    
         FROM pra_PayrollAccount AC

    LEFT JOIN prm_PayrollMonth        ON prm_UId    = pra_PrmUId
   INNER JOIN say_Salary              ON say_PraUId = pra_UId
    LEFT JOIN emy_EmploymentPeriod    ON emy_UId    = say_EmyUId
   INNER JOIN sad_SalaryDetail        ON sad_SayUId = say_UId
    LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_SdtUId
    LEFT JOIN sax_SalaryCategorie     ON sax_UId    = sdt_SaxUId

        WHERE ( pra_UId          = :pi_PraUId ) 
          AND ( pra_IstVerbucht  = 1          ) 
          AND ( prm_Monat        > 0          ) 
          AND ( emy_EmpUId       = :pi_EmpUId )     

         INTO :ssdt_Typ,      :bSdt_IstLohnTeil, :bStd_Basis1, :nSDT_EXCLUDESALARYCALC,
              :pra_UId,       :emy_UId,          :emp_UId,
              :nBetragAG,     :nBetragAN,        :nBasis,
              :nSad_AnsatzAN, :nSad_AnsatzAG,    :iSpalteNr,
              :prm_Monat

  DO 
  BEGIN

    IF ( ssdt_Typ = 'L' ) THEN 
    BEGIN

      AzBetrag = AzBetrag + nBetragAG;
  
      IF ( bSdt_IstLohnTeil = 1 ) THEN 
      BEGIN
        BruttoLohn = BruttoLohn + nBetragAG;
        NettoLohn  = NettoLohn  + nBetragAG;
      END         

      IF ( iSpalteNr = 13 ) THEN 
      BEGIN -- KK-PlegeBeitrag vom AG als Lohn ausbezahlt

            -- Falls der AG den KK-PflegeBeitrag als Lohn ausbezahlt,
            -- und der MA im Kollektiv versichert ist, wird beim Abzug
            -- der volle KK-Beitrag (AG und AN) abgezogen 
            -- und muss auf der Statistik korregiert werden  

             nAG_KKLohn  = nAG_KKLohn + nBetragAG;
      END
      
    END 
    ELSE 
    BEGIN

      AzBetrag = AzBetrag - nBetragAN;

      IF ( bSdt_IstLohnTeil = 1 ) THEN 
      BEGIN
        
        NettoLohn  = NettoLohn - nBetragAN;
         
        -- AHV-Beitraege 
        IF ( iSpalteNr = 6 ) THEN 
        BEGIN 
        
          IF ( ( nSad_AnsatzAN <> 0.0 ) AND ( nSad_AnsatzAG <> 0.0 ) ) THEN 
          BEGIN
            IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
                AHVLohn = AHVLohn + nBasis;
            ELSE
                AHVLohn = AHVLohn;
          END  

        END


      END  

    END
    
    -- Sonderbeitraege 
    IF ( iSpalteNr = 3 ) THEN 
    BEGIN 

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte3_AG = Spalte3_AG + nBetragAG;   
        END 
        ELSE 
        BEGIN
          Spalte3_AN = Spalte3_AN + nBetragAN;
        END
  
    END 
  
    -- Vorschuss 
    IF ( iSpalteNr = 4 ) THEN 
    BEGIN 

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte4_AG = Spalte4_AG + nBetragAG;
        END 
        ELSE 
        BEGIN
          Spalte4_AN = Spalte4_AN + nBetragAN;
        END  
            
    END 
    
    -- Spesen
    IF ( iSpalteNr = 5 ) THEN 
    BEGIN 

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte5_AG = Spalte5_AG + nBetragAG;
        END 
        ELSE 
        BEGIN
          Spalte5_AN = Spalte5_AN + nBetragAN;
        END

    END 
    
    -- AHV
    IF ( iSpalteNr = 6 ) THEN 
    BEGIN 
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte6_Basis = Spalte6_Basis + nBasis;
      ELSE
        Spalte6_Basis = Spalte6_Basis;
      Spalte6_AG    = Spalte6_AG    + nBetragAG;
      Spalte6_AN    = Spalte6_AN    + nBetragAN;
    END 
    
    -- ALV
    IF ( iSpalteNr = 7 ) THEN 
    BEGIN
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte7_Basis = Spalte7_Basis + nBasis;
      ELSE
        Spalte7_Basis = Spalte7_Basis;
      Spalte7_AG    = Spalte7_AG    + nBetragAG;
      Spalte7_AN    = Spalte7_AN    + nBetragAN;
    END 
    
    -- NBU / BU
    IF ( iSpalteNr = 8 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte8_Basis = Spalte8_Basis + nBasis;
      ELSE
        Spalte8_Basis = Spalte8_Basis;
      Spalte8_AG    = Spalte8_AG    + nBetragAG;
      Spalte8_AN    = Spalte8_AN    + nBetragAN;
    END 
    
    -- PK1
    IF ( iSpalteNr = 9 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte9_Basis = Spalte9_Basis + nBasis;
      ELSE
        Spalte9_Basis = Spalte9_Basis;
      Spalte9_AG    = Spalte9_AG    + nBetragAG;
      Spalte9_AN    = Spalte9_AN    + nBetragAN;
    END 
    
    -- PK2
    IF ( iSpalteNr = 10 ) THEN 
    BEGIN
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte10_Basis = Spalte10_Basis + nBasis;
      ELSE             
        Spalte10_Basis = Spalte10_Basis;
      Spalte10_AG    = Spalte10_AG    + nBetragAG;
      Spalte10_AN    = Spalte10_AN    + nBetragAN;
    END 
    
    -- PK3
    IF ( iSpalteNr = 11 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte11_Basis = Spalte11_Basis + nBasis;
      ELSE 
        Spalte11_Basis = Spalte11_Basis;
      Spalte11_AG    = Spalte11_AG    + nBetragAG;
      Spalte11_AN    = Spalte11_AN    + nBetragAN;
    END 
    
    -- KK Taggeld
    IF ( iSpalteNr = 12 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte12_Basis = Spalte12_Basis + nBasis;
      ELSE 
        Spalte12_Basis = Spalte12_Basis;
      Spalte12_AG    = Spalte12_AG    + nBetragAG;
      Spalte12_AN    = Spalte12_AN    + nBetragAN;
    END 
    
    -- KK Pflege
    IF ( iSpalteNr = 13 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte13_Basis = Spalte13_Basis + nBasis;
      ELSE 
        Spalte13_Basis = Spalte13_Basis;
      Spalte13_AG    = Spalte13_AG    + nBetragAG;
      Spalte13_AN    = Spalte13_AN    + nBetragAN;
    END 
    
    -- STE
    IF ( iSpalteNr = 14 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte14_Basis = Spalte14_Basis + nBasis;
      ELSE 
        Spalte14_Basis = Spalte14_Basis;
      Spalte14_AG    = Spalte14_AG    + nBetragAG;
      Spalte14_AN    = Spalte14_AN    + nBetragAN;
    END 

  END


   -- Korrektur des AN-Anteils der KK-Pflegeversicherung
   IF ( ( nAG_KKLohn <> 0.0 ) AND ( Spalte13_AN <> 0.0 ) ) THEN 
   BEGIN
  
      -- Korr. des AN-Anteils, falls der AG-Anteil als Lohn ausgezahlt wird
      -- und der MA im Kollektiv versichert ist (dh. einen Abzug KK hat)
      -- Falls der MA nicht im Kollektiv ist, muss keine Korrektur gemacht werden

      Spalte13_AN = Spalte13_AN - nAG_KKLohn;

   END
   
   SUSPEND;

END!!

COMMENT ON PROCEDURE SP_RPT_STATWAGEEXPENSESHLP IS 'Helper procedure: get detail data for procedure sp_Rpt_StatWageExpensesDet; Rports Lohnaufwendungen'!!

COMMIT!!

-- FS#1461 :END
-- +++


-- +++
-- FS#1458 - PKLohn - Adjustment for procedure SP_RPT_ANNUALUNF

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALUNF 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    AHV_LOHN           DN_NUMBER2,
    AHV_LOHN_NP        DN_NUMBER2,
    AHV_LOHN_US        DN_NUMBER2,
    BU_LOHN            DN_NUMBER2,
    STD8_LOHN          DN_NUMBER2,
    NBU_LOHN           DN_NUMBER2,
    BEITRAG_BU         DN_NUMBER2,
    BEITRAG_NBU        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;
DECLARE VARIABLE NBULOHNPFL    DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     AHV_LOHN    = 0;
     AHV_LOHN_NP = 0;
     AHV_LOHN_US = 0;
     BU_LOHN     = 0;
     STD8_LOHN   = 0;
     NBU_LOHN    = 0;
     BEITRAG_BU  = 0;
     BEITRAG_NBU = 0;

     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn ;   


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;   


      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;

      AHV_LOHN    = nAHVLohnPfl;
      AHV_LOHN_NP = nAHVLohn - nAHVLohnPfl;



     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle NBU-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 13)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   


     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 14)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nBULohnPfl;


      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;
      IF (nBULohnPfl  IS NULL) THEN nBULohnPfl  = 0;

      -- AHV_LOHN_US: Uebersteigender BU/NBU Lohn 
      AHV_LOHN_US = CASE
        WHEN nNBULohnPfl > 0                     THEN nNBULohn - nNBULohnPfl
        WHEN nNBULohnPfl = 0 AND nBULohnPFl > 0  THEN nNBULohn - nBULohnPfl
        WHEN nNBULohnPfl = 0 AND nBULohnPFl = 0  THEN 0
      END;
      
 
      -- BU-Pflichtiger Lohn----
      BU_LOHN     = AHV_LOHN + AHV_LOHN_NP - AHV_LOHN_US;


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 1)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      STD8_LOHN = nAHVUnter8Std;

      NBU_LOHN  = BU_LOHN - nAHVUnter8Std;


     -- Beitraege AG und AN rechnen ----

     SELECT SUM(D.SAD_BEITRAGAG),
            SUM(D.SAD_BEITRAGAN)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
            (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
            (T.SDT_SAXUID in (13,14))

     INTO :BEITRAG_BU,
          :BEITRAG_NBU;


     -- Personalien des MA's ----

      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C.COI_ISOCODE,
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             E.EMP_GESCHLECHT,
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM


       FROM EMP_EMPLOYEE E

       LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

       WHERE E.EMP_UID = :EMP_UID

       INTO :EMP_PERSNR,
            :EMP_PEIDNR,
            :EMP_NAME,
            :EMP_VORNAME,
            :EMP_STRASSE,
            :emp_HausNr,
            :COI_ISOCODE,
            :EMP_PLZ,
            :EMP_ORT, 
            :EMP_GEBURTSDATUM, 
            :EMP_PENSIONDATUM, 
            :EMP_GESCHLECHT,
            :EMP_EINTRITTSDATUM,
            :EMP_AUSTRITTSDATUM;


      SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALUNF IS 'Get data for the report: Annual \ Jahresabrechnung UNF (UNF Annual)'!!

COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_CATUID  IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_DEPUID  IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_EMPUID  IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_FIIUID  IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_LANDUID IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_PRGUID  IS 'Payroll group Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sar_SelectByBuy 
(
    pi_BuyUId DI_UID
)
RETURNS 
(
    SAR_UID DI_UID,
    SAR_EMPUID DI_UID,
    SAR_ISTAUSWEIS_CH DB_BOOLEAN,
    SAR_FL_A DB_BOOLEAN,
    SAR_FL_B DB_BOOLEAN,
    SAR_FL_C DS_STR20,
    SAR_CH_C DS_STR20,
    SAR_FL_D DI_INT,
    SAR_FL_E_N1 DD_DATE,
    SAR_FL_E_N2 DD_DATE,
    SAR_FL_F DB_BOOLEAN,
    SAR_FL_G DB_BOOLEAN,
    SAR_FL_1 DI_INT,
    SAR_FL_2_1 DI_INT,
    SAR_FL_2_2 DI_INT,
    SAR_FL_2_3_1 DS_TEXT,
    SAR_FL_2_3_2 DI_INT,
    SAR_FL_3_1 DS_TEXT,
    SAR_FL_3_2 DI_INT,
    SAR_FL_4_1 DS_TEXT,
    SAR_FL_4_2 DI_INT,
    SAR_FL_5 DI_INT,
    SAR_FL_6_1 DS_TEXT,
    SAR_FL_6_2 DI_INT,
    SAR_FL_7_1 DS_TEXT,
    SAR_FL_7_2 DI_INT,
    SAR_FL_9 DI_INT,
    SAR_FL_10_1 DI_INT,
    SAR_FL_10_2 DI_INT,
    SAR_FL_12 DI_INT,
    SAR_FL_13_1_0 DB_BOOLEAN,
    SAR_FL_13_1_1 DI_INT,
    SAR_FL_13_1_2_1 DS_TEXT,
    SAR_FL_13_1_2_2 DI_INT,
    SAR_FL_13_2_1 DI_INT,
    SAR_FL_13_2_2 DI_INT,
    SAR_FL_13_2_3_1 DS_TEXT,
    SAR_FL_13_2_3_2 DI_INT,
    SAR_FL_13_3 DI_INT,
    SAR_FL_14 DS_TEXT,
    SAR_FL_15 DS_TEXT,
    SAR_FL_ORT_DATUM DS_STR128,
    SAR_FL_FIRMA_ADR DS_STR512,
    SAR_AT_1A DI_INT,
    SAR_AT_1B_1 DI_INT,
    SAR_AT_1B_2 DI_INT,
    SAR_AT_1B_3 DI_INT,
    SAR_AT_1B_4 DI_INT,
    SAR_AT_1B_5 DI_INT,
    SAR_AT_1B_6 DI_INT,
    SAR_AT_1B_7 DI_INT,
    SAR_AT_1C_1 DI_INT,
    SAR_AT_1C_2_1 DI_INT,
    SAR_AT_1C_2_2 DI_INT,
    SAR_AT_1C_3_1 DI_INT,
    SAR_AT_1C_3_2 DI_INT,
    SAR_AT_1C_4 DI_INT,
    SAR_AT_1D_1 DI_INT,
    SAR_AT_1D_2 DI_INT,
    SAR_AT_1D_3 DI_INT,
    SAR_AT_1D_4 DI_INT,
    SAR_AT_1D_5_1 DS_TEXT,
    SAR_AT_1D_5_2 DI_INT,
    SAR_AT_2_1 DI_INT,
    SAR_AT_2_2 DI_INT,
    SAR_AT_2_3 DI_INT,
    SAR_AT_2_4_1 DS_TEXT,
    SAR_AT_2_4_2 DI_INT,
    SAR_AT_2_5_1 DI_INT,
    SAR_AT_2_5_2 DI_INT,
    SAR_AT_3_1 DI_INT,
    SAR_AT_3_2 DI_INT,
    SAR_AT_3_3 DI_INT,
    SAR_AT_3_4 DI_INT,
    SAR_AT_3_5 DI_INT,
    SAR_AT_3_6_1 DS_TEXT,
    SAR_AT_3_6_2 DI_INT,
    EMP_NAME DS_STR50,
    EMP_VORNAME DS_STR50,
    EMP_STRASSE DS_STR50,
    EMP_HAUSNR  DS_STR5,
    EMP_PLZ DS_PLZ,
    EMP_ORT DS_STR50,
    COI_ISOCODE DS_CODE)
AS
-- Select salary report data by employee UId
BEGIN


  FOR
    SELECT sar_UId        ,  sar_EmpUId     ,  sar_IstAusweis_CH, sar_FL_A       ,  sar_FL_B,
           sar_FL_C       ,  sar_CH_C       ,  sar_FL_D        ,  sar_FL_E_N1    ,  sar_FL_E_N2,   
           sar_FL_F       ,  sar_FL_G       ,  sar_FL_1        ,  sar_FL_2_1     ,  sar_FL_2_2,
           sar_FL_2_3_1   ,  sar_FL_2_3_2   ,  sar_FL_3_1      ,  sar_FL_3_2     ,  sar_FL_4_1,
           sar_FL_4_2     ,  sar_FL_5       ,  sar_FL_6_1      ,  sar_FL_6_2     ,  sar_FL_7_1,
           sar_FL_7_2     ,  sar_FL_9       ,  sar_FL_10_1     ,  sar_FL_10_2    ,  sar_FL_12,
           sar_FL_13_1_0  ,  sar_FL_13_1_1  ,  sar_FL_13_1_2_1 ,  sar_FL_13_1_2_2 , sar_FL_13_2_1,
           sar_FL_13_2_2  ,  sar_FL_13_2_3_1,  sar_FL_13_2_3_2 ,  sar_FL_ORT_DATUM, sar_FL_FIRMA_ADR,
           sar_FL_13_3    ,  sar_FL_14      ,  sar_FL_15       ,  sar_AT_1A      ,  sar_AT_1B_1,
           sar_AT_1B_2    ,  sar_AT_1B_3    ,  sar_AT_1B_4     ,  sar_AT_1B_5    ,  sar_AT_1B_6,
           sar_AT_1B_7    ,  sar_AT_1C_1    ,  sar_AT_1C_2_1   ,  sar_AT_1C_2_2  ,  sar_AT_1C_3_1,
           sar_AT_1C_3_2  ,  sar_AT_1C_4    ,  sar_AT_1D_1     ,  sar_AT_1D_2    ,  sar_AT_1D_3,
           sar_AT_1D_4    ,  sar_AT_1D_5_1  ,  sar_AT_1D_5_2   ,  sar_AT_2_1     ,  sar_AT_2_2,
           sar_AT_2_3     ,  sar_AT_2_4_1   ,  sar_AT_2_4_2    ,  sar_AT_2_5_1   ,  sar_AT_2_5_2,
           sar_AT_3_1     ,  sar_AT_3_2     ,  sar_AT_3_3      ,  sar_AT_3_4     ,  sar_AT_3_5,
           sar_AT_3_6_1   ,  sar_AT_3_6_2   ,  emp_Name        ,  emp_Vorname    ,  emp_Strasse,
           emp_HausNr     ,  emp_Plz        ,  emp_Ort         ,  coi_IsoCode
      FROM sar_SalaryReport
     INNER JOIN emp_Employee   ON sar_EmpUId   = emp_UID
      LEFT JOIN coi_CountryISO  ON emp_LandUId  = coi_UId
     WHERE emp_BuyUId = :pi_BuyUId
      INTO :sar_UId        , :sar_EmpUId     , :sar_IstAusweis_CH, :sar_FL_A       , :sar_FL_B       ,
           :sar_FL_C       , :sar_CH_C       , :sar_FL_D         , :sar_FL_E_N1    , :sar_FL_E_N2    , 
           :sar_FL_F       , :sar_FL_G       , :sar_FL_1         , :sar_FL_2_1     , :sar_FL_2_2     , 
           :sar_FL_2_3_1   , :sar_FL_2_3_2   , :sar_FL_3_1       , :sar_FL_3_2     , :sar_FL_4_1     ,
           :sar_FL_4_2     , :sar_FL_5       , :sar_FL_6_1       , :sar_FL_6_2     , :sar_FL_7_1     ,
           :sar_FL_7_2     , :sar_FL_9       , :sar_FL_10_1      , :sar_FL_10_2    , :sar_FL_12      ,
           :sar_FL_13_1_0  , :sar_FL_13_1_1  , :sar_FL_13_1_2_1  , :sar_FL_13_1_2_2, :sar_FL_13_2_1  , 
           :sar_FL_13_2_2  , :sar_FL_13_2_3_1, :sar_FL_13_2_3_2  , :sar_FL_ORT_DATUM,:sar_FL_FIRMA_ADR,
           :sar_FL_13_3    , :sar_FL_14      , :sar_FL_15        , :sar_AT_1A      , :sar_AT_1B_1    ,
           :sar_AT_1B_2    , :sar_AT_1B_3    , :sar_AT_1B_4      , :sar_AT_1B_5    , :sar_AT_1B_6    ,
           :sar_AT_1B_7    , :sar_AT_1C_1    , :sar_AT_1C_2_1    , :sar_AT_1C_2_2  , :sar_AT_1C_3_1  ,
           :sar_AT_1C_3_2  , :sar_AT_1C_4    , :sar_AT_1D_1      , :sar_AT_1D_2    , :sar_AT_1D_3    ,
           :sar_AT_1D_4    , :sar_AT_1D_5_1  , :sar_AT_1D_5_2    , :sar_AT_2_1     , :sar_AT_2_2     ,
           :sar_AT_2_3     , :sar_AT_2_4_1   , :sar_AT_2_4_2     , :sar_AT_2_5_1   , :sar_AT_2_5_2   ,
           :sar_AT_3_1     , :sar_AT_3_2     , :sar_AT_3_3       , :sar_AT_3_4     , :sar_AT_3_5     ,
           :sar_AT_3_6_1   , :sar_AT_3_6_2   , :emp_Name         , :emp_Vorname    , :emp_Strasse    ,
           :emp_HausNr     , :emp_Plz        , :emp_Ort          , :coi_IsoCode
  DO
    SUSPEND;

END!!

COMMIT!!

COMMENT ON PROCEDURE sp_Sar_SelectByBuy IS 'Get salary report data by business year'!!

COMMENT ON PARAMETER sp_Sar_SelectByBuy.pi_BuyUId IS 'Business Year Id'!!

COMMIT!!

-- FS#1458 :END
-- +++

SET TERM ;!!