﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 3.01.01
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- +++
-- FS#1343 - PKLohn – Error when create new Business Year

DELETE FROM arl_ArchiveLink
 WHERE arl_LinkedPrefix = 'EMP'
   AND NOT EXISTS ( SELECT 1 FROM emp_Employee WHERE emp_UId = arl_LinkedUId )!!
   
DELETE FROM arl_ArchiveLink
 WHERE arl_LinkedPrefix = 'FII'
   AND NOT EXISTS ( SELECT 1 FROM fii_FirmInstitution WHERE fii_UId = arl_LinkedUId )!!
   
DELETE FROM arl_ArchiveLink
 WHERE arl_LinkedPrefix = 'FIB'
   AND NOT EXISTS ( SELECT 1 FROM fib_firmBank WHERE fib_UId = arl_LinkedUId )!!
  
DELETE FROM arl_ArchiveLink
 WHERE arl_LinkedPrefix = 'FIR'
   AND NOT EXISTS ( SELECT 1 FROM fir_Firm WHERE fir_UId = arl_LinkedUId )!!
   
DELETE FROM arm_ArchiveMaster
 WHERE arm_MastPrefix = 'FIR'
   AND NOT EXISTS ( SELECT 1 FROM fir_Firm WHERE fir_UId = arm_MastUId )!!
   
COMMIT!!
   
-- +++      

CREATE OR ALTER PROCEDURE sp_Fir_DeleteDataCascade
(
    pi_FirUId         DI_UID_NN,    -- Id of the firm to be deleted
    pb_IsDelFirRecord DB_BOOLEAN_NN -- Flag: delete or not firm record itself
)
AS

  -- Delete all related data for the given firm

DECLARE VARIABLE iBuyUId DI_INT;

BEGIN

  -- Delete year records
  
  FOR
    SELECT buy_UId 
      FROM buy_BusinessYear
     WHERE buy_FirUId = :pi_FirUId
      INTO :iBuyUId
  DO
    EXECUTE PROCEDURE sp_Buy_DeleteDataCascade( :iBuyUId, 1 );
  
  
  -- Delete other basic data
  
  DELETE FROM cur_CurrencyRate
   WHERE cur_MastUId    = :pi_FirUId
     AND cur_MastPrefix = 'FIR';

  DELETE FROM cul_CurrencyList
   WHERE cul_MastUId    = :pi_FirUId
     AND cul_MastPrefix = 'FIR';
     
  DELETE FROM cou_Country
   WHERE cou_MastUId    = :pi_FirUId
     AND cou_MastPrefix = 'FIR';     
     
  DELETE FROM par_Parameter
   WHERE par_MastUId    = :pi_FirUId
     AND par_MastPrefix = 'FIR';          
     
  DELETE FROM dtm_Data2Master
   WHERE dtm_MastUId    = :pi_FirUId
     AND dtm_MastPrefix = 'FIR';     

  DELETE FROM ban_Bank
   WHERE ban_MastUId    = :pi_FirUId
     AND ban_MastPrefix = 'FIR';
     
  DELETE FROM arl_ArchiveLink
   WHERE arl_LinkedUId    = :pi_FirUId
     AND arl_LinkedPrefix = 'FIR';
     
  DELETE FROM arm_ArchiveMaster
   WHERE arm_MastUId    = :pi_FirUId
     AND arm_MastPrefix = 'FIR';
  
  IF ( pb_IsDelFirRecord = 1 ) THEN
    DELETE FROM fir_Firm WHERE fir_UId = :pi_FirUId;
    
END!!


COMMENT ON PROCEDURE sp_Fir_DeleteDataCascade IS 'Delete all related data for the given firm' !!

COMMENT ON PARAMETER sp_Fir_DeleteDataCascade.pi_FirUId         IS 'Id of the firm to be deleted'!!
COMMENT ON PARAMETER sp_Fir_DeleteDataCascade.pb_IsDelFirRecord IS 'Flag: delete or not year firm record itself'!!

COMMIT!!

-- +++

CREATE OR ALTER TRIGGER TRG_Emp_BeforeDel_0
  FOR emp_Employee ACTIVE BEFORE DELETE POSITION 0
AS
BEGIN
  
  DELETE FROM arl_ArchiveLink
   WHERE arl_LinkedUId    = old.emp_UId
     AND arl_LinkedPrefix = 'EMP';

END!!


COMMENT ON TRIGGER TRG_Emp_BeforeDel_0 IS 'emp_Employee: Delete required data cascade'!!

-- +++

CREATE OR ALTER TRIGGER TRG_Fib_BeforeDel_0
  FOR fib_FirmBank ACTIVE BEFORE DELETE POSITION 0
AS
BEGIN
  
  DELETE FROM arl_ArchiveLink
   WHERE arl_LinkedUId    = old.fib_UId
     AND arl_LinkedPrefix = 'FIB';

END!!


COMMENT ON TRIGGER TRG_Fib_BeforeDel_0 IS 'fib_FirmBank: Delete required data cascade'!!

-- +++

CREATE OR ALTER TRIGGER TRG_Fii_BeforeDel_0
  FOR fii_FirmInstitution ACTIVE BEFORE DELETE POSITION 0
AS
BEGIN
  
  DELETE FROM arl_ArchiveLink
   WHERE arl_LinkedUId    = old.fii_UId
     AND arl_LinkedPrefix = 'FII';

END!!


COMMENT ON TRIGGER TRG_Fii_BeforeDel_0 IS 'fii_FirmInstitution: Delete required data cascade'!!

-- FS#1343:END
-- +++

-- +++
-- FS#1366 - PKLohn - Email TLS improvement

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailTLSVer', 'DI_INT' )!!

COMMIT!!

ALTER TABLE fir_Firm ALTER fir_EMailTLSVer POSITION 44!!

COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_EMailTLS    IS 'Firm specific email SSL/TLS mode'!!
COMMENT ON COLUMN fir_Firm.fir_EMailTLSVer IS 'Firm specific email SSL/TLS version'!!

COMMIT!!

UPDATE fir_Firm SET fir_EMailTLS    = 2 WHERE fir_EMailTLS > 2!!
UPDATE fir_Firm SET fir_EMailTLSVer = 5!!

COMMIT!!

UPDATE par_Parameter SET par_Val = 2 WHERE par_Code = 'EMAIL_SMTP_TLS' AND par_Val > 2!!

COMMIT!!

INSERT INTO par_Parameter 
(
    par_MastUId,    par_MastPrefix, 
    par_Code,       par_Bezeich, 
    par_Typ,        par_Val,        
    par_CreateDate, par_CreateUsrUId, 
    par_MutDate,    par_MutUsrUId
) 
VALUES 
(
    0,                    'APP', 
    'EMAIL_SMTP_TLS_VER', 'Global SMTP TLS version', 
    0,                    '5',    
    Current_TimeStamp,    1, 
    Current_TimeStamp,    1
)!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_LA_UseOwnTemplate   DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_LA_NameTauschen     DB_BOOLEAN,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp      DS_ONECHARFLAG,
    fir_EMailMode           DI_INT,
    fir_EMailSenderAddress  DS_STR128,
    fir_EMailSenderName     DS_STR128,
    fir_EMailSubject        DS_STR255,
    fir_EMailHost           DS_STR128,
    fir_EMailPort           DI_INT,   
    fir_EMailTLS            DI_INT,
    fir_EMailTLSVer         DI_INT,    
    fir_EMailUser           DS_STR50, 
    fir_EMailPassword       DS_STR255,
    fir_EMailText           DS_STR1024,
    fir_LicCusCode          DS_STR50,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_LA_NameTauschen,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,
           fir_EMailTLSVer,           
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_LicCusCode,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_LA_NameTauschen,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,
           :fir_EMailTLSVer,           
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           :fir_LicCusCode,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!

COMMIT!!

-- FS#1366:END
-- +++

-- +++
-- FS#1368 - PKLohn - Bug in EmpClosePraFRM

EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_SADSAY2SAY'!!
COMMIT!!

ALTER TABLE SAD_SALARYDETAIL
    ADD CONSTRAINT FK_SADSAY2SAY
    FOREIGN KEY (SAD_SAYUID)
    REFERENCES SAY_SALARY(SAY_UID)
    ON UPDATE CASCADE
    USING INDEX IDX_SAD_BYSALARY!!

-- FS#1368:END
-- +++


-- +++
-- FS#1372 - PKLohn - cul_CurrencyList entries not deleted

CREATE OR ALTER PROCEDURE SP_Buy_DeletedataCascade 
(
    pi_BuyUId         DI_UID_NN,
    pb_IsDelBuyRecord DB_BOOLEAN_NN
)
AS

-- Delete all related data for the given business year

DECLARE VARIABLE iEmpUId DI_INT;

BEGIN

  -- Delete employee records
  
  FOR
    SELECT emp_UId 
      FROM emp_Employee        
     WHERE emp_BuyUId = :pi_BuyUId
      INTO :iEmpUId
  DO
    EXECUTE PROCEDURE sp_Emp_DeleteDataCascade( :iEmpUId, 1 );
  
  -- Delete firm instituation records
  
  DELETE FROM fii_FirmInstitution WHERE fii_BuyUId = :pi_BuyUId;
  
  -- Delete salary related records

  UPDATE sdt_SalaryDeductionType SET SDT_LART_SDTUID = NULL
     WHERE sdt_BuyUId = :pi_BuyUId;  
  
  DELETE FROM sat_SalaryTemplate      WHERE sat_BuyUId = :pi_BuyUId;  
  DELETE FROM sdt_SalaryDeductionType WHERE sdt_BuyUId = :pi_BuyUId;  
  DELETE FROM sal_SalaryStatement     WHERE sal_BuyUId = :pi_BuyUId;
  DELETE FROM sab_SalaryBasis         WHERE sab_BuyUId = :pi_BuyUId;
    
  
  -- Delete other firm related records
  
  DELETE FROM fib_FirmBank        WHERE fib_BuyUId = :pi_BuyUId;
  DELETE FROM fih_FirmHours       WHERE fih_BuyUId = :pi_BuyUId; 
    
  
  -- Delete other basic data
  
  DELETE FROM prm_PayrollMonth  WHERE prm_BuyUId = :pi_BuyUId;
  DELETE FROM prg_PayrollGroup  WHERE prg_BuyUId = :pi_BuyUId;
  DELETE FROM acn_AccountNumber WHERE acn_BuyUId = :pi_BuyUId;
  DELETE FROM cat_Category      WHERE cat_BuyUId = :pi_BuyUId;
  DELETE FROM dep_Department    WHERE dep_BuyUId = :pi_BuyUId;
  
  DELETE FROM cul_CurrencyList
   WHERE cul_MastUId    = :pi_BuyUId
     AND cul_MastPrefix = 'BUY';
  
  IF ( pb_IsDelBuyRecord = 1 ) THEN
    DELETE FROM buy_BusinessYear WHERE buy_UId = :pi_BuyUId;
    
END!!

COMMIT!!

DELETE FROM cul_CurrencyList
 WHERE cul_MastPrefix='FIR'
   AND NOT EXISTS ( SELECT 1 FROM fir_Firm WHERE fir_UId = cul_MastUId )!!
   

DELETE FROM cul_CurrencyList
 WHERE cul_MastPrefix='BUY'
   AND NOT EXISTS ( SELECT 1 FROM buy_BusinessYear WHERE buy_UId = cul_MastUId )!!
   
COMMIT!!

-- FS#1372:END
-- +++


-- +++
-- FS#1374 - PKLohn - Bug with salaries in Sonderabrechnungen

UPDATE luk_LookUp
   SET luk_Bezeichnung = 'nur Monatsabrechnung'
 WHERE luk_Bezeichnung = 'nur MonatsAbrechnung'!!
 
COMMIT!!
 
-- FS#1374:END
-- +++

SET TERM ;!!