﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.23
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!; 

-- ++++++++

-- +++
-- FS#1211 - PKLohn - Adjust field tab2cbxSdtBerechBasisNr in SDT Form

DELETE FROM sab_SalaryBasis WHERE sab_BasisNr = 16!!

COMMIT!!

-- FS#1211:END
-- +++

-- +++
-- FS#1205 - PKLohn - Email length in EmployeeManageFRM

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_Insert'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_Update'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_SelectNotInPrm'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_SelectWithSalary'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_Select'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField 'emp_Employee', 'tmp_Email', 'DS_STR50'!!
COMMIT!!

UPDATE emp_Employee SET tmp_Email = emp_Email!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropField 'emp_Employee', 'emp_Email'!!
COMMIT!!

ALTER TABLE emp_Employee ALTER tmp_Email TO emp_Email!!
ALTER TABLE emp_Employee ALTER emp_Email POSITION 17!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Insert
(
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR50,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,    
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_IstCh            DB_BOOLEAN,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN,
    ps_emp_EmailPasswort    DS_STR50,
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
RETURNS( emp_UId DI_UID_NN )
AS

  -- Add a new Employee and return Employee Id
  
  DECLARE bIsIndustrialHours     DB_BOOLEAN;
  DECLARE iVortragStd            DI_INT;    
  DECLARE iVortragFerien         DI_INT;    

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
   
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  emp_UId = GEN_ID (GEN_Emp_UId, 1);

  INSERT INTO emp_Employee
  (
    emp_UId,
    emp_BuyUId,
    emp_PersNr,
    emp_PEIDNr,
    emp_Name,
    emp_Vorname,
    emp_Strasse,
    emp_HausNr,
    emp_LandUId,
    emp_PLZ,
    emp_Ort,
    emp_GeburtsDatum,
    emp_PensionDatum,
    emp_Geschlecht,
    emp_EintrittsDatum,
    emp_AustrittsDatum,
    emp_Zivilstand,
    emp_Aufenthalt,
    emp_NationUId,
    emp_HeimatOrt,
    emp_AnzKinder,
    emp_Telefon,
    emp_Handy,
    emp_Email,
    emp_EmailPasswort,
    emp_Beruf,
    emp_Stellung,
    emp_Lohnklasse,
    emp_DepUId,
    emp_CatUId,
    emp_PrgUId,
    emp_EmiUId,
    emp_AHV_FiiUId,
    emp_ALV_FiiUId,
    emp_PK_FiiUId,
    emp_KKP_FiiUId,
    emp_KKT_FiiUId,
    emp_UNF_FiiUId,
    emp_STE_FiiUId,
    emp_ZPK_FiiUId,
    emp_VortragStd,
    emp_VortragFerien,
    emp_SonderFerien,
    emp_AnspruchFerien,
    emp_IstCh,
    emp_LA_IstStunden,
    emp_LA_IstFerien,
    emp_LA_IstZahlstelle,
    emp_IstAktiv,
    emp_CreateDate,
    emp_CreateUsrUId,
    emp_MutDate,
    emp_MutUsrUId
  )
  VALUES
  (
    :emp_UId,
    :pi_emp_BuyUId,
    :pi_emp_PersNr,
    :ps_emp_PEIDNr,
    :ps_emp_Name,
    :ps_emp_Vorname,
    :ps_emp_Strasse,
    :ps_emp_HausNr,
    :pi_emp_LandUId,
    :ps_emp_PLZ,
    :ps_emp_Ort,
    :pd_emp_GeburtsDatum,
    :pd_emp_PensionDatum,
    :ps_emp_Geschlecht,
    :pd_emp_EintrittsDatum,
    :pd_emp_AustrittsDatum,
    :ps_emp_Zivilstand,
    :ps_emp_Aufenthalt,
    :pi_emp_NationUId,
    :ps_emp_HeimatOrt,
    :pi_emp_AnzKinder,
    :ps_emp_Telefon,
    :ps_emp_Handy,
    :ps_emp_Email,
    :ps_emp_EmailPasswort,
    :ps_emp_Beruf,
    :ps_emp_Stellung,
    :ps_emp_Lohnklasse,
    :pi_emp_DepUId,
    :pi_emp_CatUId,
    :pi_emp_PrgUId,
    :pi_emp_EmiUId,
    :pi_emp_AHV_FiiUId,
    :pi_emp_ALV_FiiUId,
    :pi_emp_PK_FiiUId,
    :pi_emp_KKP_FiiUId,
    :pi_emp_KKT_FiiUId,
    :pi_emp_UNF_FiiUId,
    :pi_emp_STE_FiiUId,
    :pi_emp_ZPK_FiiUId,
    :iVortragStd,
    :iVortragFerien,
    :pn_emp_SonderFerien,
    :pn_emp_AnspruchFerien,
    :pb_emp_IstCh,
    :pb_emp_LA_IstStunden,
    :pb_emp_LA_IstFerien,
    :pb_emp_LA_IstZahlstelle,
    :pb_emp_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!

COMMENT ON PROCEDURE sp_Emp_Insert IS 'Add a new Employee and return Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Update
(
    pi_emp_UId              DI_UID_NN,
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_SteuerGde        DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR50,
    ps_emp_EmailPasswort    DS_STR50,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,
    pb_emp_IstCh            DB_BOOLEAN,
    ps_emp_Ch_PeidNr        DS_STR20,
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN, 
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
AS

  -- Update Employee data by Id
  
  DECLARE bIsIndustrialHours DB_BOOLEAN;
  DECLARE iVortragStd        DI_INT;  
  DECLARE iVortragFerien     DI_INT;  

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
  
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  UPDATE emp_Employee
     SET emp_BuyUId           = :pi_emp_BuyUId                 ,
         emp_PersNr           = :pi_emp_PersNr                 ,
         emp_PEIDNr           = :ps_emp_PEIDNr                 ,
         emp_Name             = :ps_emp_Name            ,
         emp_Vorname          = :ps_emp_Vorname         ,
         emp_Strasse          = :ps_emp_Strasse         ,
         emp_HausNr           = :ps_emp_HausNr          ,
         emp_LandUId          = :pi_emp_LandUId         ,
         emp_PLZ              = :ps_emp_PLZ             ,
         emp_SteuerGde        = :ps_emp_SteuerGde       ,
         emp_Ort              = :ps_emp_Ort             ,
         emp_GeburtsDatum     = :pd_emp_GeburtsDatum    ,
         emp_PensionDatum     = :pd_emp_PensionDatum    ,
         emp_Geschlecht       = :ps_emp_Geschlecht      ,
         emp_EintrittsDatum   = :pd_emp_EintrittsDatum  ,
         emp_AustrittsDatum   = :pd_emp_AustrittsDatum  ,
         emp_Zivilstand       = :ps_emp_Zivilstand      ,
         emp_Aufenthalt       = :ps_emp_Aufenthalt      ,
         emp_NationUId        = :pi_emp_NationUId       ,
         emp_HeimatOrt        = :ps_emp_HeimatOrt       ,
         emp_AnzKinder        = :pi_emp_AnzKinder       ,
         emp_Telefon          = :ps_emp_Telefon         ,
         emp_Handy            = :ps_emp_Handy           ,
         emp_Email            = :ps_emp_Email           ,
         emp_EmailPasswort    = :ps_emp_EmailPasswort   ,
         emp_Beruf            = :ps_emp_Beruf           ,
         emp_Stellung         = :ps_emp_Stellung        ,
         emp_Lohnklasse       = :ps_emp_Lohnklasse      ,
         emp_IstCh            = :pb_emp_IstCh           ,
         emp_Ch_PeidNr        = :ps_emp_Ch_PeidNr       ,
         emp_DepUId           = :pi_emp_DepUId          ,
         emp_CatUId           = :pi_emp_CatUId          ,
         emp_PrgUId           = :pi_emp_PrgUId          ,
         emp_EmiUId           = :pi_emp_EmiUId          ,
         emp_AHV_FiiUId       = :pi_emp_AHV_FiiUId      ,
         emp_ALV_FiiUId       = :pi_emp_ALV_FiiUId      ,
         emp_PK_FiiUId        = :pi_emp_PK_FiiUId       ,
         emp_KKP_FiiUId       = :pi_emp_KKP_FiiUId      ,
         emp_KKT_FiiUId       = :pi_emp_KKT_FiiUId      ,
         emp_UNF_FiiUId       = :pi_emp_UNF_FiiUId      ,
         emp_STE_FiiUId       = :pi_emp_STE_FiiUId      ,
         emp_ZPK_FiiUId       = :pi_emp_ZPK_FiiUId      ,
         emp_VortragStd       = :iVortragStd            ,
         emp_VortragFerien    = :iVortragFerien         ,
         emp_SonderFerien     = :pn_emp_SonderFerien    ,
         emp_AnspruchFerien   = :pn_emp_AnspruchFerien  ,
         emp_LA_IstStunden    = :pb_emp_LA_IstStunden   ,
         emp_LA_IstFerien     = :pb_emp_LA_IstFerien    ,
         emp_LA_IstZahlstelle = :pb_emp_LA_IstZahlstelle,
         emp_IstAktiv         = :pb_emp_IstAktiv        ,
         emp_MutDate          = Current_TimeStamp       ,
         emp_MutUsrUId        = :pi_app_ActiveUser
   WHERE emp_UId              = :pi_emp_UId;

END!!

COMMENT ON PROCEDURE sp_Emp_Update IS 'Update Employee by Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Update.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Select
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR50,
    emp_EmailPasswort     DS_STR50,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR
)                             
AS
  /* Select Employee data by Id or by Employee*/

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;
  DECLARE iVortragFerien       DI_INT;
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN

  SELECT buy_FirUId, buy_GeschJahr,
         EXTRACT(YEAR FROM buy_DatumVon),
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;

  SELECT buy_UId
    FROM buy_BusinessYear
   WHERE buy_FirUId    = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
     AND buy_UId       > 0
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_EmailPasswort,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_Code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,

           (
            SELECT E.emp_UId
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,

           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_EmailPasswort,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_Code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,

           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,

           :luk_Zivilstand

  DO
  BEGIN

    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;

    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN

      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END

      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END

    END


    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;

      SUSPEND;

    END

  END

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_SelectNotInPrm
(  
  pi_BuyUId   DI_UID,
  pi_PraUId   DI_UID
)
RETURNS
(
  emp_UId                    DI_UID,
  emp_BuyUId                 DI_UID,
  emp_PersNr                 DI_INT,
  emp_PEIDNr                 DS_STR20,
  emp_Name                   DS_STR50,
  emp_Vorname                DS_STR50,
  emp_Strasse                DS_STR50,
  emp_LandUId                DI_UID,
  emp_PLZ                    DS_PLZ,
  emp_Ort                    DS_STR50,
  emp_GeburtsDatum           DD_DATE,
  emp_PensionDatum           DD_DATE,
  emp_Geschlecht             DS_ONECHARFLAG,
  emp_EintrittsDatum         DD_DATE,
  emp_AustrittsDatum         DD_DATE,
  emp_Zivilstand             DS_ONECHARFLAG,
  emp_Aufenthalt             DS_ONECHARFLAG,
  emp_NationUId              DI_UID,
  emp_HeimatOrt              DS_STR50,
  emp_AnzKinder              DI_SMLINT,
  emp_Telefon                DS_STR30,
  emp_Handy                  DS_STR30,
  emp_Email                  DS_STR50,
  emp_Beruf                  DS_STR50,
  emp_Stellung               DS_STR50,
  emp_Lohnklasse             DS_STR50,
  emp_DepUId                 DI_UID,
  emp_CatUId                 DI_UID,
  emp_PrgUId                 DI_UID,
  emp_EmiUId                 DI_UID,
  emp_AHV_FiiUId             DI_UID,
  emp_ALV_FiiUId             DI_UID,
  emp_PK_FiiUId              DI_UID,
  emp_KKP_FiiUId             DI_UID,
  emp_KKT_FiiUId             DI_UID,
  emp_UNF_FiiUId             DI_UID,
  emp_STE_FiiUId             DI_UID,
  emp_ZPK_FiiUId             DI_UID,
  emp_VortragStd             DI_INT,
  emp_VortragFerien          DN_NUMBER2,
  emp_SonderFerien           DN_NUMBER2,
  emp_AnspruchFerien         DN_NUMBER2,
  emp_LA_IstStunden          DB_BOOLEAN,
  emp_LA_IstFerien           DB_BOOLEAN,
  emp_LA_IstZahlstelle       DB_BOOLEAN,
  emp_IstAktiv               DB_ISACTIVE,
  emp_CreateDate             DD_TIMESTAMP,
  emp_CreateUsrUId           DI_UID,
  emp_MutDate                DD_TIMESTAMP,
  emp_MutUsrUId              DI_UID
)
AS

  -- Select employees that are not in the current payroll month
  
  DECLARE iMonth    DI_SMLINT;

BEGIN

  SELECT prm_Monat
    FROM pra_PayrollAccount
    JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :iMonth;    
  
  FOR 
    SELECT emp_UId,             
           emp_BuyUId,         
           emp_PersNr,          
           emp_PEIDNr,         
           emp_Name,
           emp_Vorname,
           emp_Strasse,        
           emp_LandUId,        
           emp_PLZ,        
           emp_Ort,             
           emp_GeburtsDatum,
           emp_PensionDatum,   
           emp_Geschlecht,   
           emp_EintrittsDatum,
           emp_AustrittsDatum, 
           emp_Zivilstand,
           emp_Aufenthalt,      
           emp_NationUId,       
           emp_HeimatOrt,       
           emp_AnzKinder,       
           emp_Telefon,        
           emp_Handy,           
           emp_Email,           
           emp_Beruf,           
           emp_Stellung,        
           emp_Lohnklasse,      
           emp_DepUId,          
           emp_CatUId,          
           emp_PrgUId,          
           emp_EmiUId,          
           emp_AHV_FiiUId,      
           emp_ALV_FiiUId,      
           emp_PK_FiiUId,       
           emp_KKP_FiiUId,      
           emp_KKT_FiiUId,      
           emp_UNF_FiiUId,      
           emp_STE_FiiUId,      
           emp_ZPK_FiiUId,      
           emp_VortragStd,      
           emp_VortragFerien,   
           emp_SonderFerien,    
           emp_AnspruchFerien,  
           emp_LA_IstStunden,   
           emp_LA_IstFerien,    
           emp_LA_IstZahlstelle,
           emp_IstAktiv,        
           emp_CreateDate,      
           emp_CreateUsrUId,    
           emp_MutDate,         
           emp_MutUsrUId
      FROM sp_Emp_Select( :pi_BuyUId )
     WHERE emp_UId NOT IN
           ( 
             SELECT emp_UId 
               FROM sp_Pra_EmployeeList( :pi_PraUId )
           )
       AND 0 = ( SELECT bIsUnemployed FROM sp_Emp_IsUnemployedInMonth( emp_UId, :iMonth ) )
      INTO :emp_UId,             
           :emp_BuyUId,         
           :emp_PersNr,          
           :emp_PEIDNr,         
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,        
           :emp_LandUId,        
           :emp_PLZ,        
           :emp_Ort,             
           :emp_GeburtsDatum,
           :emp_PensionDatum,   
           :emp_Geschlecht,   
           :emp_EintrittsDatum,
           :emp_AustrittsDatum, 
           :emp_Zivilstand,
           :emp_Aufenthalt,      
           :emp_NationUId,       
           :emp_HeimatOrt,       
           :emp_AnzKinder,       
           :emp_Telefon,        
           :emp_Handy,           
           :emp_Email,           
           :emp_Beruf,           
           :emp_Stellung,        
           :emp_Lohnklasse,      
           :emp_DepUId,          
           :emp_CatUId,          
           :emp_PrgUId,          
           :emp_EmiUId,          
           :emp_AHV_FiiUId,      
           :emp_ALV_FiiUId,      
           :emp_PK_FiiUId,       
           :emp_KKP_FiiUId,      
           :emp_KKT_FiiUId,      
           :emp_UNF_FiiUId,      
           :emp_STE_FiiUId,      
           :emp_ZPK_FiiUId,      
           :emp_VortragStd,      
           :emp_VortragFerien,   
           :emp_SonderFerien,    
           :emp_AnspruchFerien,  
           :emp_LA_IstStunden,   
           :emp_LA_IstFerien,    
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,        
           :emp_CreateDate,      
           :emp_CreateUsrUId,    
           :emp_MutDate,         
           :emp_MutUsrUId
  DO
    SUSPEND;

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_SelectWithSalary
(
   pi_PraUId                  DI_UID_NN             -- Id of the Payroll Account
)
RETURNS
(
   emp_UId                    DI_UID,
   emp_BuyUId                 DI_UID,
   emp_PersNr                 DI_INT,
   emp_PEIDNr                 DS_STR20,
   emp_Name                   DS_STR50,
   emp_Vorname                DS_STR50,
   emp_Strasse                DS_STR50,
   emp_LandUId                DI_UID,
   emp_PLZ                    DS_PLZ,
   emp_Ort                    DS_STR50,
   emp_GeburtsDatum           DD_DATE,
   emp_PensionDatum           DD_DATE,
   emp_Geschlecht             DS_ONECHARFLAG,
   emp_EintrittsDatum         DD_DATE,
   emp_AustrittsDatum         DD_DATE,
   emp_Zivilstand             DS_ONECHARFLAG,
   emp_Aufenthalt             DS_ONECHARFLAG,
   emp_NationUId              DI_UID,
   emp_HeimatOrt              DS_STR50,
   emp_AnzKinder              DI_SMLINT,
   emp_Telefon                DS_STR30,
   emp_Handy                  DS_STR30,
   emp_Email                  DS_STR50,
   emp_Beruf                  DS_STR50,
   emp_Stellung               DS_STR50,
   emp_Lohnklasse             DS_STR50,
   emp_DepUId                 DI_UID,
   emp_CatUId                 DI_UID,
   emp_PrgUId                 DI_UID,
   emp_EmiUId                 DI_UID,
   emp_AHV_FiiUId             DI_UID,
   emp_ALV_FiiUId             DI_UID,
   emp_PK_FiiUId              DI_UID,
   emp_KKP_FiiUId             DI_UID,
   emp_KKT_FiiUId             DI_UID,
   emp_UNF_FiiUId             DI_UID,
   emp_STE_FiiUId             DI_UID,
   emp_ZPK_FiiUId             DI_UID,
   emp_VortragStd             DN_NUMBER2,
   emp_VortragFerien          DN_NUMBER2,
   emp_SonderFerien           DN_NUMBER2,
   emp_AnspruchFerien         DN_NUMBER2,
   emp_IstAktiv               DB_ISACTIVE,
   emp_LandIsoCode            DS_CODE,
   emp_LandBezeichnung        DS_DESCR,
   dep_code                   DS_STR12,
   dep_Bezeichnung            DS_STR50,
   cat_code                   DS_STR12,
   cat_Bezeichnung            DS_STR50,
   prg_Gruppe                 DS_STR12,
   prg_Bezeichnung            DS_STR50,
   emp_GeschlechtBezeichnung  DS_DESCR,
   emy_UId                    DI_UID,
   pra_UId                    DI_UID,
   emp_Status                 DI_SMLINT,      -- calc. field
   emp_Variabel               DI_SMLINT,      -- calc. field
   say_UId                    DI_UID,
   say_PraUId                 DI_UID,
   say_EmyUId                 DI_UID,
   say_DatumVom               DD_DATE,
   say_DatumBis               DD_DATE,
   say_AnzDetails             DI_INT,
   say_BruttoLohn             DN_NUMBER2,
   say_NettoLohn              DN_NUMBER2

)
AS

  -- Select employee list with salary for the payroll account
  
  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;  
  DECLARE iVortragFerien       DI_INT;  

BEGIN

  -- Determine setting industry minutes (Industrieminuten)

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByPra( :pi_PraUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  -- Select employees with salary

  FOR

    SELECT EMP.emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_LandUId,
           emp_PLZ,
           emp_Ort,
           emp_GeburtsDatum,
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_IstAktiv,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           dep_code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,
           GESCHLECHT.luk_Bezeichnung AS emp_GeschlechtBezeichnung,
           PROC.emy_UId

      FROM sp_Emp_EmpListForAccount ( :pi_PraUId ) PROC

     INNER JOIN emp_Employee        EMP       ON EMP.emp_UId      = PROC.emp_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN luk_Lookup         GESCHLECHT ON luk_Gruppe       = 'GESCHLECHT' AND luk_Code = emp_Geschlecht

  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_LandUId,
           :emp_PLZ,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_IstAktiv,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :dep_code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,
           :emp_GeschlechtBezeichnung,
           :emy_UId

  DO
  BEGIN

    -- init. variabls

    pra_UId          = pi_PraUId;
    emp_Status       = 0;
    emp_Variabel     = 0;
    say_UId          = NULL;
    say_PraUId       = NULL;
    say_EmyUId       = NULL;
    say_DatumVom     = NULL;
    say_DatumBis     = NULL;
    say_AnzDetails   = 0;
    say_BruttoLohn   = 0;
    say_NettoLohn    = 0;
    
    EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
     RETURNING_VALUES :emp_VortragStd;
    
    EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
     RETURNING_VALUES :emp_VortragFerien;

    -- get salary head record for given PayrollAccount and EmployeePeriod

    SELECT say_UId,
           say_PraUId,
           say_EmyUId,
           say_DatumVom,
           say_DatumBis,
           say_AnzDetails,
           say_BruttoLohn,
           say_NettoLohn
      FROM say_Salary
     WHERE say_PraUId = :pra_UId
       AND say_EmyUId = :emy_UId
      INTO :say_UId,
           :say_PraUId,
           :say_EmyUId,
           :say_DatumVom,
           :say_DatumBis,
           :say_AnzDetails,
           :say_BruttoLohn,
           :say_NettoLohn;

     -- calc. second column 'Variabel' in a grid

     IF (
          EXISTS (
                   SELECT *
                     FROM say_Salary
                     JOIN sad_SalaryDetail        ON say_UId    = sad_SayUId
                     JOIN sdt_SalaryDeductionType ON sad_SdtUId = sdt_UId
                    WHERE say_PraUId      = :pra_UId
                      AND say_EmyUId      = :emy_UId
                      AND sdt_IstVariabel = 1
                 )
        )
     THEN
       emp_Variabel = 1;


     SUSPEND;

  END -- for select

END!!

COMMENT ON PROCEDURE sp_Emp_SelectWithSalary IS 'Select employee list with salary for the payroll account'!!
COMMENT ON PARAMETER sp_Emp_SelectWithSalary.pi_PraUId      IS 'Id of the Payroll Account'!!

COMMIT!!

-- FS#1205:END
-- +++


-- +++
-- FS#1220 - PKLohn - Error with ClosePraFRM and selection list

UPDATE grd_GridSelection 
   SET grd_UniqueColumn = 'colSayUId'
 WHERE grd_FormName     = 'frmClosePra'!!
 
COMMIT!!

DELETE FROM sel_Selection 
 WHERE sel_GrdUId = 2!!
 
COMMIT!!

-- FS#1220:END
-- +++   

-- +++
-- FS#1228 - PKLohn - Error with ClosePraFRM and selection list

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALPK
(
  PI_FIIUID DI_UID,
  PI_EMPUID DI_UID  = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID  = NULL,
  PI_CATUID DI_UID  = NULL,
  PI_PRGUID DI_UID  = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  EMY_UID            DI_UID,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  EMY_ISUNEMPLOYED   DB_BOOLEAN,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IEMY_UID   DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( T.SDT_EXCLUDESALARYCALC = 0     )
             AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALPK IS 'Get data for the report: Annual \ Jahresabrechnung PK (PK Annual)'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'SP_RPT_ANNUALUNF'!!
COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALUNF 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    AHV_LOHN           DN_NUMBER2,
    AHV_LOHN_NP        DN_NUMBER2,
    AHV_LOHN_US        DN_NUMBER2,
    BU_LOHN            DN_NUMBER2,
    STD8_LOHN          DN_NUMBER2,
    NBU_LOHN           DN_NUMBER2,
    BEITRAG_BU         DN_NUMBER2,
    BEITRAG_NBU        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     AHV_LOHN    = 0;
     AHV_LOHN_NP = 0;
     AHV_LOHN_US = 0;
     BU_LOHN     = 0;
     STD8_LOHN   = 0;
     NBU_LOHN    = 0;
     BEITRAG_BU  = 0;
     BEITRAG_NBU = 0;

     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn ;   


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;   


      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;

      AHV_LOHN    = nAHVLohnPfl;
      AHV_LOHN_NP = nAHVLohn - nAHVLohnPfl;



     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 13)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   


      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

      AHV_LOHN_US = nNBULohn - nNBULohnPfl;
      
 
      -- BU-Pflichtiger Lohn----
      BU_LOHN     = AHV_LOHN + AHV_LOHN_NP - AHV_LOHN_US;


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 1)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      STD8_LOHN = nAHVUnter8Std;

      NBU_LOHN  = BU_LOHN - nAHVUnter8Std;


     -- Beitraege AG und AN rechnen ----

     SELECT SUM(D.SAD_BEITRAGAG),
            SUM(D.SAD_BEITRAGAN)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
            (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
            (T.SDT_SAXUID in (13,14))

     INTO :BEITRAG_BU,
          :BEITRAG_NBU;


     -- Personalien des MA's ----

      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C.COI_ISOCODE,
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             E.EMP_GESCHLECHT,
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM


       FROM EMP_EMPLOYEE E

       LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

       WHERE E.EMP_UID = :EMP_UID

       INTO :EMP_PERSNR,
            :EMP_PEIDNR,
            :EMP_NAME,
            :EMP_VORNAME,
            :EMP_STRASSE,
            :emp_HausNr,
            :COI_ISOCODE,
            :EMP_PLZ,
            :EMP_ORT, 
            :EMP_GEBURTSDATUM, 
            :EMP_PENSIONDATUM, 
            :EMP_GESCHLECHT,
            :EMP_EINTRITTSDATUM,
            :EMP_AUSTRITTSDATUM;


      SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALUNF IS 'Get data for the report: Annual \ Jahresabrechnung UNF (UNF Annual)'!!

COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_CATUID  IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_DEPUID  IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_EMPUID  IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_FIIUID  IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_LANDUID IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_ANNUALUNF.PI_PRGUID  IS 'Payroll group Id'!!

COMMIT!!

-- +++

COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PS_INT_TYP  IS 'Reports Institution Type (AHV, ALV, PK, KK, UNF, STE, ZPK)'!!

COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_QUATERANNUAL_HLP 
(
  PI_EMPUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PS_INT_TYP  DS_STR3,
  PI_SDTUID   DI_UID,
  PI_EMYUID   DI_UID
)
RETURNS 
(
  EMP_UID     DI_UID,
  SAX_UID     DI_UID,
  SDT_UID     DI_UID,
  MONATVON    DI_SMLINT,
  MONATBIS    DI_SMLINT,
  BRUTTOLOHN  DN_NUMBER2,
  FREIBETRAG  DN_NUMBER2,
  PFLICHTLOHN DN_NUMBER2,
  BEITRAGAG   DN_NUMBER2,
  BEITRAGAN   DN_NUMBER2
)
AS

DECLARE VARIABLE BOK        DI_SMLINT;
DECLARE VARIABLE IBUYUID    DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NFREIBET   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

    -- Das Return-Field "Freibetrag" wird nicht mehr benutzt ------------------------
    FREIBETRAG = 0.0;
   

    EMP_UID = PI_EMPUID;
  
    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)
           AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))

    INTO :BRUTTOLOHN,:MONATVON,:MONATBIS;   



     -- Basis(pflichtiger Lohn) und Beitraege rechnen ------------------------------

     SELECT EMP_BUYUID FROM EMP_EMPLOYEE E
         WHERE EMP_UID=:PI_EMPUID
     INTO :iBuyUId;

    bOk = 0;

    FOR SELECT DISTINCT TX.SAX_UID
        FROM EMP_EMPLOYEE E
        INNER JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_EMPUID = E.EMP_UID
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
        WHERE (E.EMP_BUYUID=:iBuyUId) AND (A.PRA_ISTVERBUCHT = 1) AND
              (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND
              (TI.INT_TYP=:PS_INT_TYP) AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))

        ORDER BY TX.SAX_UID

        INTO :SAX_UID

    DO BEGIN

       bOk = 1;

       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;
       NBEITRAGAN = 0.0;


       --  Alle Lohnarten "Prozent von BASIS" ------------------------------------------
       SELECT SUM(D.SAD_BASIS)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND (C.SCT_CALCTYPE in (2,3,4))
            AND (E.EMP_UID=:PI_EMPUID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
            AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
            AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NPFLICHT;

       IF (NPFLICHT   IS NULL) THEN NPFLICHT   = 0.0;        

       PFLICHTLOHN   = NPFLICHT;


       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
             AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
             AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        

       BEITRAGAG     = NBEITRAGAG;
       BEITRAGAN     = NBEITRAGAN;


       --  Alle Lohnarten NICHT "Prozent von BASIS" ------------------------------------
       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;

       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE not in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
             AND ((:PI_SDTUID=0) OR (T.SDT_UID = :PI_SDTUID))
             AND ((:PI_EMYUID=0) OR (Y.EMY_UID = :PI_EMYUID))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        


       --  Total fuer Rueckgabe ---------------------------------------------------------

       PFLICHTLOHN   = PFLICHTLOHN + NPFLICHT;
       BEITRAGAG     = BEITRAGAG   + NBEITRAGAG;
       BEITRAGAN     = BEITRAGAN   + NBEITRAGAN;
       SDT_UID       = :PI_SDTUID;


       SUSPEND;

    END

    -- Bruttolohn zurueckgaben, falls keine Abzuege (zB bei STE)
    IF (bOk = 0) THEN 
       SUSPEND;


END!!

COMMENT ON PROCEDURE SP_RPT_QUATERANNUAL_HLP IS 'Helper procedure: get detail data for procedure sp_Rpt_QuaterXXX and sp_Rpt_AnnualXXX; Rports Quartal and Annual'!!

COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PS_INT_TYP  IS 'Reports Institution Type (AHV, ALV, PK, KK, UNF, STE, ZPK)'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_SDTUID   IS 'Salary or deduction type UId'!!
COMMENT ON PARAMETER SP_RPT_QUATERANNUAL_HLP.PI_EMYUID   IS 'Employment period UId'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'SP_RPT_QUARTERPK'!!
COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERPK 
(
    PI_FIIUID   DI_UID,
    PI_MONATVON DI_SMLINT,
    PI_MONATBIS DI_SMLINT,
    PI_EMPUID   DI_UID = NULL,
    PI_LANDUID  DI_UID = NULL,
    PI_DEPUID   DI_UID = NULL,
    PI_CATUID   DI_UID = NULL,
    PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE ISDTUID    DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     ISDTUID = 0;
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp, :ISDTUID, 0 )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END


  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERPK IS 'Get data for the report: Quarter \ (PK Quarter)'!!

COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERPK.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

-- +++

COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_FiiUId   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_MonatVon IS'Report month from (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_MonatBis IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_EmpUId   IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_LandUId  IS 'Land Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_CatUId   IS 'Department Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_PrgUId   IS 'Payrool group Id'!!

COMMIT!!

CREATE OR ALTER PROCEDURE sp_Rpt_QuarterSte
(
    pi_FiiUId       DI_UID,
    pi_MonatVon     DI_SMLINT,
    pi_MonatBis     DI_SMLINT,
    pi_EmpUId       DI_UID = null,
    pi_LandUId      DI_UID = null,
    pi_DepUId       DI_UID = null,
    pi_CatUId       DI_UID = null,
    pi_PrgUId       DI_UID = null
)
RETURNS 
(
    rpt_Gruppe          DS_STR15,
    emp_UId             DI_UID,
    prm_MonatVon        DI_SMLINT,
    prm_MonatBis        DI_SMLINT,
    lohn_Brutto         DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_SaxBez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreiBetrag       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_SaxBez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_Freibetrag       DN_NUMBER2,
    k2_Beitrag_an       DN_NUMBER2,
    k2_Beitrag_ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_SaxBez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreiBetrag       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_SaxBez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreiBetrag       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_PeidNr          DS_STR12,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    fii_ContactPerson   DS_STR50,
    fii_TelNr           DS_STR20,
    fii_EMail           DS_STR50,
    fii_AnnualChk       DB_BOOLEAN,
    fii_AnnualText      DS_STR150,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_SteuerGde       DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Aufenthalt_Bez  DS_DESCR
)
AS

  DECLARE sStmt       VARCHAR(512);
  DECLARE iBuyUId     DI_UID;
  DECLARE sIntTyp     DS_STR3;
  DECLARE iCounter    DI_SMLINT;
  DECLARE iSaxUId     DI_UID;
  DECLARE sSaxBez     DS_DESCR;
  DECLARE nFrei       DN_NUMBER2;
  DECLARE nPflicht    DN_NUMBER2;
  DECLARE nBeitragAg  DN_NUMBER2;
  DECLARE nBeitragAn  DN_NUMBER2;
  DECLARE ISDTUID     DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.fii_BuyUId, 
         I.fii_AbrechnungNr,
         I.fii_Code,
         I.fii_Name,
         I.fii_NameZusatz,
         I.fii_Strasse,
         I.fii_Plz,
         I.fii_Ort,
         I.fii_ContactPerson,   
         I.fii_TelNr,           
         I.fii_EMail,           
         I.fii_AnnualChk,       
         I.fii_AnnualText,      
         Y.buy_Geschjahr,
         F.fir_Code,
         F.fir_PeidNr,
         F.fir_Bezeichnung,
         F.fir_Bezeichnung2,
         F.fir_Strasse,  
         F.fir_HausNr,
         F.fir_Plz,  
         F.fir_Ort,
         IT.int_Typ   
    FROM fii_FirmInstitution I
    LEFT JOIN buy_BusinessYear    Y  ON Y.buy_UId  = I.fii_BuyUId
    LEFT JOIN fir_Firm            F  ON F.fir_UId  = Y.buy_FirUId
    LEFT JOIN int_InstitutionType IT ON IT.int_UId = I.fii_IntUId       
   WHERE I.fii_UId = :pi_FiiUId
    INTO :iBuyUId,
         :fii_AbrechnungNr,
         :fii_Code,
         :fii_Name,
         :fii_NameZusatz,
         :fii_Strasse,
         :fii_Plz,
         :fii_Ort,
         :fii_ContactPerson,   
         :fii_TelNr,           
         :fii_EMail,           
         :fii_AnnualChk,       
         :fii_AnnualText, 
         :buy_Geschjahr,
         :fir_Code,
         :fir_PeidNr,
         :fir_Bezeichnung,
         :fir_Bezeichnung2,
         :fir_Strasse,  
         :fir_HausNr,
         :fir_Plz,  
         :fir_Ort,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_STE_FIIUID IS NOT NULL) AND (EMP_STE_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     ISDTUID = 0;
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp, :ISDTUID, 0 )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.emp_PersNr,
               E.emp_PeidNr,
               E.emp_Name,
               E.emp_Vorname,
               E.emp_Strasse,
               E.emp_HausNr,
               C.coi_IsoCode,
               E.emp_Plz,
               E.emp_SteuerGde,
               E.emp_Ort, 
               E.emp_GeburtsDatum, 
               E.emp_PensionDatum, 
               E.emp_Geschlecht,
               E.emp_EintrittsDatum,
               E.emp_AustrittsDatum,
               E.emp_Aufenthalt
          FROM emp_Employee E
          LEFT OUTER JOIN coi_CountryIso C ON C.coi_UId = E.emp_LandUId 
         WHERE e.emp_UId = :emp_UId
         INTO :emp_PersNr,
              :emp_PeidNr,
              :emp_Name,
              :emp_Vorname,
              :emp_Strasse,
              :emp_HausNr,
              :coi_IsoCode,
              :emp_Plz,
              :emp_SteuerGde,
              :emp_Ort, 
              :emp_GeburtsDatum, 
              :emp_PensionDatum, 
              :emp_Geschlecht,
              :emp_EintrittsDatum,
              :emp_AustrittsDatum,
              :emp_Aufenthalt;

         

         -- ReportGruppe fuer Jahresabrechnung ---
         RPT_GRUPPE = '';  
         IF (EMP_AUFENTHALT = '1') THEN BEGIN           -- wohnhaft im FL

            RPT_GRUPPE = EMP_AUFENTHALT || EMP_PLZ;


         END ELSE IF (EMP_AUFENTHALT = '2') THEN BEGIN  -- wohnhaft im CH

            RPT_GRUPPE = EMP_AUFENTHALT;


         END ELSE IF (EMP_AUFENTHALT = '3') THEN BEGIN  -- wohnhaft im AT

            RPT_GRUPPE = EMP_AUFENTHALT;

         END ELSE BEGIN                                 -- wohnhaft uebriges Ausland

            RPT_GRUPPE = '5';        

         END

         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMIT!!

COMMENT ON PROCEDURE sp_Rpt_QuarterSTE             IS 'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_FiiUId   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_MonatVon IS'Report month from (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_MonatBis IS'Report month to (1..12)'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_EmpUId   IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_LandUId  IS 'Land Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_CatUId   IS 'Department Id'!!
COMMENT ON PARAMETER sp_Rpt_QuarterSTE.pi_PrgUId   IS 'Payrool group Id'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'SP_RPT_QUARTERUNF'!!
COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERUNF 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE ISAXUID       DI_UID;
DECLARE VARIABLE NBEITRAGAG    DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN    DN_NUMBER2;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;




    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :LOHN_BRUTTO,:PRM_MONATVON,:PRM_MONATBIS;



     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn;


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS )
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;  

      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;


     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 0)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 3)
            AND (T.SDT_SAXUID = 13)
            AND (T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   

      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

 
      -- BU-Pflichtiger Lohn----
      K2_SAXUID   = 14;    -- (14 = BU)
      K2_PFLICHT  = nAHVLohnPfl + (nAHVLohn - nAHVLohnPfl) - (nNBULohn - nNBULohnPfl);


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 1)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            
      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      K1_SAXUID  = 13;    -- (13 = NBU)
      K1_PFLICHT = K2_PFLICHT - nAHVUnter8Std;


     --- Beitraege rechnen ----------------------------------------------------

     FOR SELECT T.SDT_SAXUID,
                SUM(D.SAD_BEITRAGAG),
                SUM(D.SAD_BEITRAGAN)

         FROM EMY_EMPLOYMENTPERIOD Y
       
         INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
         LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
         LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
               (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
               (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
               (T.SDT_SAXUID in (13,14))
         
         GROUP BY T.SDT_SAXUID

         INTO :iSAXUid,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF ( iSAXUid = 13) THEN BEGIN        -- wenn NBU

           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END      

        IF ( iSAXUid = 14) THEN BEGIN        -- wenn BU

           K2_BEITRAG_AN = nBeitragAN;      
           K2_BEITRAG_AG = nBeitragAG;

        END      

     END


     -- SAX-Bezeichung holen  
     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 13
     INTO :K1_SAXBEZ;

     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 14
     INTO :K2_SAXBEZ;


     -- Get data from Employee
     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM

      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND; 


  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERUNF IS 'Get data for the report: Quarter \ Unfall Quartalsmeldung (UNF Quarter)'!!

COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERUNF.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

-- FS#1228:END
-- +++ 

-- +++
-- FS#1232 - PKLohn - Changed AHV reports

COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERAHV 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_UID            DI_UID,
  EMY_BESGRAD        DN_NUMBER2_NN,
  EMY_MONATVON       DI_SMLINT,
  EMY_MONATBIS       DI_SMLINT,
  ALV_PFLICHT        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT        VARCHAR(512);
DECLARE VARIABLE IBUYUID      DI_UID;
DECLARE VARIABLE SINTTYP      DS_STR3;
DECLARE VARIABLE ICOUNTER     DI_SMLINT;
DECLARE VARIABLE ISAXUID      DI_UID;
DECLARE VARIABLE SSAXBEZ      DS_DESCR;
DECLARE VARIABLE NFREI        DN_NUMBER2;
DECLARE VARIABLE NPFLICHT     DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN   DN_NUMBER2;
DECLARE VARIABLE ISDTUID      DI_UID;
DECLARE VARIABLE IEMYUID      DI_UID;
DECLARE VARIABLE DEMYPJANFANG DD_DATE;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT E.EMP_UID, Y.EMY_UID, Y.EMY_PJANFANG FROM EMP_EMPLOYEE E  '||
          'INNER JOIN EMY_EMPLOYMENTPERIOD Y  ON Y.EMY_EMPUID = E.EMP_UID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_AHV_FIIUID IS NOT NULL) AND (EMP_AHV_FIIUID = :piFIIUid )' ;
  sStmt = sStmt || ' AND (Y.EMY_ISUNEMPLOYED=0)' ;
  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME, Y.EMY_PJANFANG ASC ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID, :IEMYUID, :DEMYPJANFANG
  DO BEGIN


     ISDTUID = 0;
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     /* Get data from Employee */
     EMY_BESGRAD = 0;
     FOR SELECT EY.EMY_UID, EY.EMY_BESGRAD, EXTRACT (MONTH FROM EY.EMY_PJANFANG), EXTRACT (MONTH FROM EY.EMY_PJENDE) FROM EMY_EMPLOYMENTPERIOD EY
        WHERE (EY.EMY_EMPUID=:EMP_UID) AND (EY.EMY_UID=:IEMYUID) AND (EY.EMY_ISUNEMPLOYED=0)
        ORDER BY EMY_PJANFANG
        INTO :EMY_UID,
             :EMY_BESGRAD,
             :EMY_MONATVON,
             :EMY_MONATBIS
     DO BEGIN
       IF (EMY_BESGRAD IS NULL) THEN EMY_BESGRAD = 0;
     END

     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp, :ISDTUID, :EMY_UID )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, 'ALV', :ISDTUID, :EMY_UID )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN
       ALV_PFLICHT = nPflicht;

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               LOWER(E.EMP_GESCHLECHT),
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERAHV IS 'Get data for the report: Quarter \ AHV Quartalsmeldung (AHV Quarter)'!!

COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERAHV.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

-- +++

COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERALV 
(
  PI_FIIUID DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID = NULL,
  PI_CATUID DI_UID = NULL,
  PI_PRGUID DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMP_AUFENTHALT     DS_ONECHARFLAG,
  EMP_AUFENTHALT_BEZ DS_DESCR
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE ISDTUID    DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_ALV_FIIUID IS NOT NULL) AND (EMP_ALV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     ISDTUID = 0;
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp, :ISDTUID , 0 )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM,
               E.EMP_AUFENTHALT


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM,
              :EMP_AUFENTHALT; 

 
         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERALV IS 'Get data for the report: Quarter \ ALV Quartalsmeldung (ALV Quarter)'!!

COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_CATUID   IS 'Category Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_DEPUID   IS 'Department Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_FIIUID   IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_LANDUID  IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_MONATBIS IS 'Report month to (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_MONATVON IS 'Report month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_QUARTERALV.PI_PRGUID   IS 'Payroll group Id'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'SP_RPT_ANNUALAHV'!!
COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALAHV 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    EMY_UID            DI_UID,
    EMY_BESGRAD        DN_NUMBER2_NN,
    EMY_MONATVON       DI_SMLINT,
    EMY_MONATBIS       DI_SMLINT,
    ALV_PFLICHT        DN_NUMBER2
)
AS

DECLARE VARIABLE IALVFIIUID DI_UID;
DECLARE VARIABLE NK1PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK2PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK3PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK4PLICHT  DN_NUMBER2;

BEGIN

  FOR SELECT EMP_UID,
             PRM_MONATVON,
             PRM_MONATBIS,
             LOHN_BRUTTO,
             K1_SAXUID,
             K1_SAXBEZ,
             K1_PFLICHT,
             K1_FREIBETRAG,
             K1_BEITRAG_AN,
             K1_BEITRAG_AG,
             K2_SAXUID,
             K2_SAXBEZ,
             K2_PFLICHT,
             K2_FREIBETRAG,
             K2_BEITRAG_AN,
             K2_BEITRAG_AG,
             K3_SAXUID,
             K3_SAXBEZ,
             K3_PFLICHT,
             K3_FREIBETRAG,
             K3_BEITRAG_AN,
             K3_BEITRAG_AG,
             K4_SAXUID,
             K4_SAXBEZ,
             K4_PFLICHT,
             K4_FREIBETRAG,
             K4_BEITRAG_AN,
             K4_BEITRAG_AG,
             BUY_GESCHJAHR,
             FIR_CODE,
             FIR_BEZEICHNUNG,
             FIR_BEZEICHNUNG2,
             FIR_STRASSE,
             fir_HausNr,
             FIR_PLZ,
             FIR_ORT,
             FII_ABRECHNUNGNR,
             FII_CODE,
             FII_NAME,
             FII_NAMEZUSATZ,
             FII_STRASSE,
             FII_PLZ,
             FII_ORT,
             FII_CONTACTPERSON,
             FII_TELNR,
             FII_EMAIL,
             FII_ANNUALCHK,
             FII_ANNUALTEXT,
             EMP_PERSNR,
             EMP_PEIDNR,
             EMP_NAME,
             EMP_VORNAME,
             EMP_STRASSE,
             emp_HausNr,
             COI_ISOCODE,
             EMP_PLZ,
             EMP_ORT,
             EMP_GEBURTSDATUM,
             EMP_PENSIONDATUM,
             EMP_GESCHLECHT,
             EMP_EINTRITTSDATUM,
             EMP_AUSTRITTSDATUM,
             EMY_UID,
             EMY_BESGRAD,
             EMY_MONATVON,
             EMY_MONATBIS,
             ALV_PFLICHT

      FROM SP_RPT_QUARTERAHV (:PI_FIIUID,1,12,:PI_EMPUID,:PI_LANDUID,:PI_DEPUID,:PI_CATUID,:PI_PRGUID)


      INTO   :EMP_UID,
             :PRM_MONATVON,
             :PRM_MONATBIS,
             :LOHN_BRUTTO,
             :K1_SAXUID,
             :K1_SAXBEZ,
             :K1_PFLICHT,
             :K1_FREIBETRAG,
             :K1_BEITRAG_AN,
             :K1_BEITRAG_AG,
             :K2_SAXUID,
             :K2_SAXBEZ,
             :K2_PFLICHT,
             :K2_FREIBETRAG,
             :K2_BEITRAG_AN,
             :K2_BEITRAG_AG,
             :K3_SAXUID,
             :K3_SAXBEZ,
             :K3_PFLICHT,
             :K3_FREIBETRAG,
             :K3_BEITRAG_AN,
             :K3_BEITRAG_AG,
             :K4_SAXUID,
             :K4_SAXBEZ,
             :K4_PFLICHT,
             :K4_FREIBETRAG,
             :K4_BEITRAG_AN,
             :K4_BEITRAG_AG,
             :BUY_GESCHJAHR,
             :FIR_CODE,
             :FIR_BEZEICHNUNG,
             :FIR_BEZEICHNUNG2,
             :FIR_STRASSE,
             :fir_HausNr,
             :FIR_PLZ,
             :FIR_ORT,
             :FII_ABRECHNUNGNR,
             :FII_CODE,
             :FII_NAME,
             :FII_NAMEZUSATZ,
             :FII_STRASSE,
             :FII_PLZ,
             :FII_ORT,
             :FII_CONTACTPERSON,
             :FII_TELNR,
             :FII_EMAIL,
             :FII_ANNUALCHK,
             :FII_ANNUALTEXT,
             :EMP_PERSNR,
             :EMP_PEIDNR,
             :EMP_NAME,
             :EMP_VORNAME,
             :EMP_STRASSE,
             :emp_HausNr,
             :COI_ISOCODE,
             :EMP_PLZ,
             :EMP_ORT,
             :EMP_GEBURTSDATUM,
             :EMP_PENSIONDATUM,
             :EMP_GESCHLECHT,
             :EMP_EINTRITTSDATUM,
             :EMP_AUSTRITTSDATUM,
             :EMY_UID,
             :EMY_BESGRAD,
             :EMY_MONATVON,
             :EMY_MONATBIS,
             :ALV_PFLICHT

  DO BEGIN


    /* Letzter BesGrad des Mitarbeiters ermitteln --
    EMY_BESGRAD = 0;
    FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD
        WHERE (EMY_EMPUID=:EMP_UID) AND EMY_ISUNEMPLOYED = 0
        ORDER BY EMY_PJANFANG
        INTO :EMY_BESGRAD
    DO BEGIN
       IF (EMY_BESGRAD IS NULL) THEN EMY_BESGRAD = 0;  
    END     */

     
    /* ALV-Pflichtige Lohnsumme des Mitarbeiters ermitteln --  */
    /* ALV_PFLICHT = 0;   */

    iALVFiiUID  = 0;
    nK1Plicht   = 0;
    nK2Plicht   = 0;
    nK3Plicht   = 0;
    nK4Plicht   = 0;

    SELECT EMP_ALV_FIIUID FROM EMP_EMPLOYEE 
       WHERE EMP_UID = :EMP_UID
    INTO :iALVFiiUID; 

     
    SELECT SUM(K1_PFLICHT),
           SUM(K2_PFLICHT),
           SUM(K3_PFLICHT),
           SUM(K4_PFLICHT) 

    FROM SP_RPT_QUARTERALV (:iALVFiiUID, 1, 12, :EMP_UID)

    INTO :nK1Plicht,
         :nK2Plicht,
         :nK3Plicht,
         :nK4Plicht;


    IF (nK1Plicht IS NULL) THEN nK1Plicht = 0; 
    IF (nK2Plicht IS NULL) THEN nK2Plicht = 0; 
    IF (nK3Plicht IS NULL) THEN nK3Plicht = 0; 
    IF (nK4Plicht IS NULL) THEN nK4Plicht = 0; 


    /*ALV_PFLICHT =  nK1Plicht + nK2Plicht + nK3Plicht + nK4Plicht;*/

    SUSPEND;         


  END 

END!!
COMMIT!!

-- FS#1232:END
-- +++

-- +++
-- FS#1229 - PKLohn - Additional Jahresabrechnung KK.fr3 report

CREATE OR ALTER PROCEDURE sp_Rpt_AnnualKKDetail 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  SDT_BEZEICHNUNG    DS_STR50,
  SAX_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

  -- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual Detail)

DECLARE VARIABLE SSTMT          DS_TEXT;
DECLARE VARIABLE IBUYUID        DI_UID;
DECLARE VARIABLE SINTTYP        DS_STR3;
DECLARE VARIABLE ISAXUID        DI_UID;
DECLARE VARIABLE NPFLICHT       DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG     DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN     DN_NUMBER2;
DECLARE VARIABLE IPF_INTUID     DI_UID;
DECLARE VARIABLE ITG_INTUID     DI_UID;
DECLARE VARIABLE SEMPGESCHLECHT DS_STR10;
DECLARE VARIABLE SEMPNAME       DS_STR128;
DECLARE VARIABLE SEMPVORNAME    DS_STR128;
DECLARE VARIABLE ISAXCODE       DI_UID;
DECLARE VARIABLE ISDTUID    DI_UID;

BEGIN

   /* Get Data from FirmInstitution and Firm for all records  */
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT DISTINCT T.SDT_BEZEICHNUNG, T.SDT_UID, E.EMP_UID, e.emp_geschlecht, e.emp_name, e.emp_vorname, t.sdt_saxuid '||
          'FROM EMP_EMPLOYEE E '||
          'LEFT JOIN BUY_BUSINESSYEAR X  ON X.BUY_UID  = E.EMP_BUYUID '||
          'INNER JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_EMPUID = E.EMP_UID '||
          'INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID '||
          'INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID '||
          'LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID '||
          'LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID '||
          'LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID '||
          'LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID '||
          'LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID '||

          'WHERE (EMP_BUYUID = :piBUYUID)';

        IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
            sStmt = sStmt || ' AND (E.EMP_UID= ' || PI_EMPUID || ')';

        IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
            sStmt = sStmt || ' AND (E.EMP_LANDUID= ' || PI_LANDUID || ')';

        IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
            sStmt = sStmt || ' AND (E.EMP_DEPUID= ' || PI_DEPUID || ')';

        IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
            sStmt = sStmt || ' AND (E.EMP_CATUID= ' || PI_CATUID || ')';

        IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
            sStmt = sStmt || ' AND (E.EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid )) ';
  sStmt = sStmt || ' AND (A.PRA_ISTVERBUCHT = 1) AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN 1 AND 12) ';
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= X.BUY_GESCHJAHR) ';
  sStmt = sStmt || ' AND (T.SDT_TYP = ''A'') AND (T.SDT_ISTLOHNTEIL = 1) AND (TI.INT_TYP=''KK'') ';
  sStmt = sStmt || ' AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0)) ';
  sStmt = sStmt || ' ORDER BY 1,4,5,6 ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :SDT_BEZEICHNUNG, :ISDTUID, :EMP_UID, :SEMPGESCHLECHT,  :SEMPNAME, :SEMPVORNAME, :ISAXCODE
  DO BEGIN
  
    /* Check if Employee has KKP or KKT from this FII */
     IPF_INTUID = 0;
     ITG_INTUID = 0;

     SELECT EMP_KKP_FIIUID,
            EMP_KKT_FIIUID
     FROM   EMP_EMPLOYEE
     WHERE  (EMP_UID = :EMP_UID)
     INTO   :IPF_INTUID,
            :ITG_INTUID;

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp, :ISDTUID, 0 )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18 AND ITG_INTUID = :pi_FiiUId AND :ISAXCODE = 18) THEN BEGIN /* wenn Taggeld */

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;
           SAX_UID         = :ISAXCODE;


        END ELSE IF (iSaxUID = 19 AND IPF_INTUID = :pi_FiiUId AND :ISAXCODE = 19) THEN BEGIN /* wenn Pflege */

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;
           SAX_UID         = :ISAXCODE;
        
        END 

     END


     /* Alle AHV-Pflichtigen Loehne des MA's ---- */

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 )

       INTO :LOHN_AHV;   

     /* Letzter Bes.Grad des Mitarbeiters  */

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     /* Personalien des MA's ---- */

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE sp_Rpt_AnnualKKDetail            IS 'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual Detail)'!!

COMMENT ON PARAMETER sp_Rpt_AnnualKKDetail.pi_FiiUId  IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKKDetail.pi_EmpUId  IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKKDetail.pi_LandUId IS 'Land Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKKDetail.pi_CatUId  IS 'Department Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKKDetail.pi_PrgUId  IS 'Payrool group Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL)
RETURNS 
(
  EMP_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IPF_INTUID DI_UID;
DECLARE VARIABLE ITG_INTUID DI_UID;
DECLARE VARIABLE ISDTUID    DI_UID;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE E  '||
          'LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID = E.EMP_BUYUID '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';
  sStmt = sStmt || ' AND (EXTRACT (YEAR FROM EMP_EINTRITTSDATUM) <= Y.BUY_GESCHJAHR)';
  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN
  
    -- Check if Employee has KKP or KKT from this FII
     IPF_INTUID = 0;
     ITG_INTUID = 0;
     ISDTUID = 0;

     SELECT EMP_KKP_FIIUID,
            EMP_KKT_FIIUID
     FROM   EMP_EMPLOYEE
     WHERE  (EMP_UID = :EMP_UID)
     INTO   :IPF_INTUID,
            :ITG_INTUID;

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp, :ISDTUID, 0 )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18 AND ITG_INTUID = :pi_FiiUId) THEN BEGIN -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19 AND IPF_INTUID = :pi_FiiUId) THEN BEGIN -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 )

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE sp_Rpt_AnnualKK            IS 'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMENT ON PARAMETER sp_Rpt_AnnualKK.pi_FiiUId  IS 'Firm-Institution Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKK.pi_EmpUId  IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKK.pi_LandUId IS 'Land Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKK.pi_CatUId  IS 'Department Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualKK.pi_PrgUId  IS 'Payrool group Id'!!

COMMIT!!

-- +++

EXECUTE BLOCK
AS

DECLARE VARIABLE iUsr_UId DI_UID;
DECLARE VARIABLE iApr_UId DI_UID;
DECLARE VARIABLE iApt_UId DI_UID;

BEGIN  

  iUsr_UId = 1;

  SELECT apr_UID
    FROM apr_AppReport
   WHERE apr_Name = 'Jahresabrechnungen'
    INTO :iApr_UId;
       
  EXECUTE PROCEDURE sp_Apt_Insert :iApr_UId, 'Jahresabrechnung KK (Detail)', 'Jahresabrechnung KK Detail.fr3', '', 1, 1, 1  
    RETURNING_VALUES :iApt_UId;
    
END!!

COMMIT!!

UPDATE apt_AppTemplate
   SET apt_SortOrder  = 0,
       apt_IstDefault = 1
 WHERE apt_Name       = 'Jahresabrechnung AHV'!!
 
UPDATE apt_AppTemplate
   SET apt_SortOrder = 1 
 WHERE apt_Name      = 'Jahresabrechnung ALV'!!
 
UPDATE apt_AppTemplate
   SET apt_SortOrder = 2 
 WHERE apt_Name      = 'Jahresabrechnung KK'!!
 
UPDATE apt_AppTemplate
   SET apt_SortOrder  = 3,
       apt_IstDefault = 0
 WHERE apt_Name       = 'Jahresabrechnung KK (Detail)'!!
 
UPDATE apt_AppTemplate
   SET apt_SortOrder = 4 
 WHERE apt_Name      = 'Jahresabrechnung PK'!!
 
UPDATE apt_AppTemplate
   SET apt_SortOrder = 5 
 WHERE apt_Name      = 'Jahresabrechnung STE'!!

UPDATE apt_AppTemplate
   SET apt_SortOrder = 6 
 WHERE apt_Name      = 'Jahresabrechnung UNF'!!

UPDATE apt_AppTemplate
   SET apt_SortOrder = 7 
 WHERE apt_Name      = 'Jahresabrechnung ZPK'!! 

-- FS#1229:END
-- +++ 

-- +++
-- FS#1234 - PKLohn - Add housenumber field to SalaryManageFRM

CREATE OR ALTER PROCEDURE sp_Pra_EmployeeList 
(
    PI_PRAUID DI_UID
)
RETURNS 
(
    emp_UId                 DI_UID,
    emp_PersNr              DI_INT,
    emp_PeidNr              DS_STR20,
    emp_Name                DS_STR50,
    emp_Vorname             DS_STR50,
    emp_Strasse             DS_STR50,
    emp_LandUId             DI_UID,
    emp_DepCode             DS_DESCR,
    emp_CatCode             DS_DESCR,
    emp_Aufenthalt          DS_DESCR,
    emp_Hausnr              DS_STR5,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR,
    emp_Plz                 DS_PLZ,
    emp_Ort                 DS_STR50,
    emp_GeburtsDatum        DD_DATE,
    emp_PensionDatum        DD_DATE,
    emp_EintrittsDatum      DD_DATE,
    emp_AustrittsDatum      DD_DATE,
    emp_Geschlecht          DS_ONECHARFLAG,
    emp_GeschlechtBezei     DS_DESCR,
    emp_PrgUId              DI_UID,
    emp_Stellung            DS_STR50,
    emy_Besgrad             DN_NUMBER2,
    emy_Ivgrad              DN_NUMBER2,
    say_UId                 DI_UID,
    say_EmyUId              DI_UID,
    say_DatumVom            DD_DATE,
    say_DatumBis            DD_DATE,
    say_Anzdetails          DI_INT,
    say_BruttoLohn          DN_NUMBER2,
    say_NettoLohn           DN_NUMBER2,
    say_La_Text             DS_STR1024,
    say_JahresLohn          DN_NUMBER2,
    say_Status              DI_SMLINT,
    prm_Bezeichnung         DS_DESCR,
    buy_GeschJahr           DI_BUSINESSYEAR
)
AS
  /* The procedure creates the employee list in the form SalaryManageFRM for the ID <pi_PraUId>.  */
  /*                                                               */
  /* The procedure creates the list of employees in the form SalaryManageFRM. */
  /* Following is considered:*/
  /*   a) already existing accounts per employee                  */
  /*   b) Firm/BusninessYear settings "Lohnabrechnung gruppiert ..." */
  /*   c) Filter settings for special accounts in "Abrechnungsvorlagen" */
                                       
  DECLARE iBuyUId         DI_UID;
  DECLARE iPrmUId         DI_UID;
  DECLARE iPrmMonat       DI_SMLINT;
  DECLARE iPrmAbreNr      DI_SMLINT;
  DECLARE iPrmCoiUId      DI_UID;
  DECLARE iPrmDepUId      DI_UID;
  DECLARE iPrmCatUId      DI_UID;
  DECLARE iPrmPrgUId      DI_UID;
  DECLARE bPrmIstUnd      DB_BOOLEAN;
  DECLARE iPraPrgUId      DI_UID;
  DECLARE bPrgInMoAre     DB_BOOLEAN;
  DECLARE bPrgIstStandard DB_BOOLEAN;
  DECLARE dEmyPjAnfang    DD_DATE;
  DECLARE dEmyPjEnde      DD_DATE;
  DECLARE iEmpLandUId     DI_UID;
  DECLARE iEmpDepUId      DI_UID;
  DECLARE iEmpCatUId      DI_UID;
  DECLARE iEmpPrgUId      DI_UID;
  DECLARE bIstOK          DB_BOOLEAN;
  DECLARE bCoiIstOK       DB_BOOLEAN;
  DECLARE bDepIstOK       DB_BOOLEAN;
  DECLARE bCatIstOK       DB_BOOLEAN;
  DECLARE bPrgIstOK       DB_BOOLEAN;
  DECLARE bPrmIsGroupped  DB_BOOLEAN;
  DECLARE bSuspendRec     DB_BOOLEAN;
  DECLARE iEmptyStatus    DI_SMLINT;
  
BEGIN

  /* Abrechnungs-Infos */
  
  SELECT pra_PrgUId,      prm_BuyUId,     prm_UId,    prm_Monat,  prm_AbreNr,        prm_CoiUId, 
         prm_DepUId,      prm_CatUId,     prm_PrgUId, prm_IstUnd, prg_IstInMoAbrech, prg_IstStandard,
         prm_Bezeichnung, buy_GeschJahr,  prm_IstSoGruppiert
    FROM pra_PayrollAccount
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
    LEFT JOIN prg_PayrollGroup ON prg_UId = pra_PrgUId
    LEFT JOIN buy_BusinessYear ON buy_UId = prm_BuyUId
   WHERE pra_UId = :pi_PraUId 
    INTO :iPraPrgUId,      :iBuyUId,       :iPrmUId,    :iPrmMonat,  :iPrmAbreNr,  :iPrmCoiUId,
         :iPrmDepUId,      :iPrmCatUId,    :iPrmPrgUId, :bPrmIstUnd, :bPrgInMoAre, :bPrgIstStandard,
         :prm_Bezeichnung, :buy_GeschJahr, :bPrmIsGroupped;
         
         
  
  iEmptyStatus = -1;

  /* 1. Alle Mitarbeiter die bereits in der Abrechnung Lohndaten haben */

  FOR 
    SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,           
           emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
           emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
           emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   say_UId,         
           say_EmyUId,         say_DatumVom,       say_DatumBis,     say_AnzDetails,
           say_BruttoLohn,     say_NettoLohn,      say_LA_Text,      emy_BesGrad,
           emy_IVGrad,         emp_PrgUId,         coi_IsoCode,      emp_Stellung,
           dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung,  emp_Hausnr,
           (
              SELECT IIF( COUNT(1) > 0, 1, 0 )
                FROM sad_SalaryDetail
                JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
               WHERE sad_SayUId = say_UId
                 AND sdt_IstVariabel = 1
           )
      FROM pra_PayrollAccount
     INNER JOIN say_Salary           ON say_PraUId = pra_UId
      LEFT JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
      LEFT JOIN emp_Employee         ON emp_UID    = emy_EmpUId
      LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId 
      LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
      LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
      LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
     WHERE pra_UId = :pi_PraUId
     ORDER BY emp_UId, emy_UId
      INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,           
           :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
           :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
           :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_UId,         
           :say_EmyUId,         :say_DatumVom,       :say_DatumBis,     :say_AnzDetails,
           :say_BruttoLohn,     :say_NettoLohn,      :say_LA_Text,      :emy_BesGrad,
           :emy_IVGrad,         :emp_PrgUId,         :coi_IsoCode,      :emp_Stellung,
           :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt,   :emp_Hausnr,
           :say_Status
  DO 
  BEGIN
  
     EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
       RETURNING_VALUES say_JahresLohn; 
       
     EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
       RETURNING_VALUES emp_GeschlechtBezei; 
       
     SUSPEND;
  END 


  IF ( iPrmAbreNr = 0 ) THEN 
  BEGIN

    /* Wenn Monatsabrechnung*/

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/

      /* Alle MA's, welche eine BesPeriode im aktuellen Monat haben und dieser Abrechnung noch */
      /* keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,         emp_PersNr,         emp_PeidNr,         emp_Name, 
               emp_Vorname,     emp_Strasse,        emp_LandUId,        coi_Bezeichnung,    
               emp_PLZ,         emp_ORT,            emp_GeburtsDatum,   emp_PensionDatum, 
               emp_Geschlecht,  emp_EintrittsDatum, emp_AustrittsDatum, emy_UId,  
               emy_PjAnfang,    emy_PjEnde,         emy_BesGrad,        emy_IVGrad,
               emp_PrgUId,      coi_IsoCode,        emp_Stellung,       :iEmptyStatus,
               dep_Bezeichnung, cat_Bezeichnung,    luk_Bezeichnung,    emp_Hausnr
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,        :emp_PersNr,         :emp_PeidNr,         :emp_Name,    
               :emp_Vorname,    :emp_Strasse,        :emp_LandUId,        :coi_Bezeichnung,    
               :emp_PLZ,        :emp_ORT,            :emp_GeburtsDatum,   :emp_PensionDatum, 
               :emp_Geschlecht, :emp_EintrittsDatum, :emp_AustrittsDatum, :say_EmyUId,  
               :dEmyPjAnfang,   :dEmyPjEnde,         :emy_BesGrad,        :emy_IVGrad,
               :emp_PrgUId,     :coi_IsoCode,        :emp_Stellung,       :say_Status,
               :emp_DepCode,    :emp_CatCode,        :emp_Aufenthalt,     :emp_Hausnr
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis */
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;
        
        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 

        SUSPEND;

      END 


    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       

      /* Alle MA's der Gruppe, welche eine BesPeriode im aktuellen Monat haben und in allen */
      /* Abrechnungen von diesem Monat noch keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emy_UId,         
               emy_PjAnfang,       emy_PjEnde,         emy_BesGrad,      emy_IVGrad,
               emp_PrgUId,         coi_IsoCode,        emp_Stellung,    :iEmptyStatus,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung, emp_Hausnr
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
          LEFT JOIN prg_PayrollGroup     ON prg_UId    = emp_PrgUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId         = :iBuyUId
           AND emp_PrgUId         = :iPraPrgUId
           AND prg_IstInMoAbrech  = 1
           AND emy_IsUnemployed   = 0 
           AND :iPrmMonat         >= EXTRACT(MONTH FROM emy_PjAnfang )
           AND :iPrmMonat         <= EXTRACT(MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_EmyUId,      
               :dEmyPjAnfang,       :dEmyPjEnde,         :emy_BesGrad,      :emy_IVGrad,
               :emp_PrgUId,         :coi_IsoCode,        :emp_Stellung,     :say_Status,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt,   :emp_Hausnr
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis*/
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;

        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 
          
        SUSPEND;

      END

    END

  END 
  ELSE 
  BEGIN

     /*** Wenn Sonderabrechnung ***/
     
    IF ( 
          ( 
            iPrmCoiUId IS NOT NULL
            OR
            iPrmDepUId IS NOT NULL
            OR 
            iPrmCatUId IS NOT NULL
            OR
            iPrmPrgUId IS NOT NULL
          )
          AND
          ( bPrmIsGroupped = 0 )
          AND 
          ( bPrmIstUnd     = 1 )
       )
    THEN
      bSuspendRec = 1;
    ELSE
      bSuspendRec = bPrmIsGroupped;
    

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/       

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,      emp_Hausnr,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,         :emp_Hausnr,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
        bPrgIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND ( emp_LandUId <> iPrmCoiUId ) ) THEN 
          bCoiIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1;

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId )
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;          

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId ) 
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;
                  
        /* PersonenGruppe als Filter definiert */
        IF ( ( iPrmPrgUId IS NOT NULL ) AND ( emp_PrgUId <> iPrmPrgUId ) )
        THEN
          bPrgIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmPrgUId IS NOT NULL ) ) THEN
          bPrgIstOK = 1;
                  

        /* UND- / ODER- Verknuepfung */
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN /* UND-Verknuepfung  */
          
          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) = 4 ) THEN
            bIstOK = 1;
            
        END 
        ELSE 
        BEGIN /* OR-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) > 0 ) THEN
            bIstOK = 1;

        END


        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von */
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
          
          SUSPEND;

        END

      END        

    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       
        
      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,   
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,      emp_Hausnr,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee 
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId       = :iBuyUId
           AND emp_PrgUId       = :iPraPrgUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat       >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat       <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount 
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,   
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,         :emp_Hausnr,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND (emp_LandUId <> iPrmCoiUId) )
        THEN 
          bCoiIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1; 

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId) 
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;   
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;
                  

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId )
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;


        /* UND- / ODER- Verknuepfung*/
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN   /* UND-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) = 3 ) THEN
            bIstOK = 1;

        END 
        ELSE 
        BEGIN  /* OR-Verknuepfung*/

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) > 0 ) THEN
            bIstOK = 1;

        END

        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von*/
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
            
          SUSPEND;

        END

      END
 
    END

  END

END!!
COMMIT!!

-- FS#1234:END
-- +++ 

-- +++
-- FS#1226 - PKLohn - License Management

EXECUTE PROCEDURE sp_DDL_SafeAddField 'fir_Firm', 'fir_LicCusCode', 'DS_STR50' !!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_LicCusCode POSITION 47!!
COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_LicCusCode  IS 'Code of customer which license is used to create the firm'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_LA_UseOwnTemplate   DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_LA_NameTauschen     DB_BOOLEAN,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp      DS_ONECHARFLAG,
    fir_EMailMode           DI_INT,
    fir_EMailSenderAddress  DS_STR128,
    fir_EMailSenderName     DS_STR128,
    fir_EMailSubject        DS_STR255,
    fir_EMailHost           DS_STR128,
    fir_EMailPort           DI_INT,   
    fir_EMailTLS            DI_INT,   
    fir_EMailUser           DS_STR50, 
    fir_EMailPassword       DS_STR255,
    fir_EMailText           DS_STR1024,
    fir_LicCusCode          DS_STR50,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_LA_NameTauschen,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,   
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_LicCusCode,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_LA_NameTauschen,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,   
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           :fir_LicCusCode,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!


COMMENT ON PROCEDURE sp_Fir_Select IS 'Select Firm(s) data'!!

COMMENT ON PARAMETER sp_Fir_Select.pi_fir_UId  IS 'Id of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.ps_fir_Code IS 'Code of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.pb_IstAktiv IS 'If not null select with specific active flag only'!!

COMMIT!!

-- FS#1226:END
-- +++ 

SET TERM ;!!