﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.21
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;    

-- +++
-- FS#1123 - PKLohn - EmpClosePraFRM

CREATE OR ALTER PROCEDURE sp_Afa_GrantAccess
(
  pi_apa_ObjUId          DI_UID_NN,        -- Object Id to grant access
  ps_afa_ObjPrefix       DS_TABPREFIX_NN,  -- Object Prefix
  pi_app_ActiveUser      DI_UID_NN         -- Application active user Id
)
AS

  -- Grant access to given object to all users and user groups

BEGIN  
  
  INSERT INTO apa_AppAccess 
  ( 
      apa_ObjUId,       apa_ObjPrefix,   apa_UsrUId,     apa_UsrPrefix, 
      apa_IstAktiviert, apa_IstSichtbar, apa_CreateDate, apa_CreateUsrUId, 
      apa_MutDate,      apa_MutUsrUId 
  )
  SELECT :pi_apa_ObjUId,    :ps_afa_ObjPrefix, usr_UId,           'USR', 
         1,                 1,                 Current_TimeStamp, :pi_app_ActiveUser, 
         Current_TimeStamp, :pi_app_ActiveUser 
    FROM usr_User
   WHERE usr_UId <> 1
     AND NOT EXISTS ( SELECT 1 FROM utg_User2Group WHERE utg_UsgUId = 1 AND utg_UsrUId = usr_UId);

  INSERT INTO apa_AppAccess 
  ( 
      apa_ObjUId,       apa_ObjPrefix,   apa_UsrUId,     apa_UsrPrefix, 
      apa_IstAktiviert, apa_IstSichtbar, apa_CreateDate, apa_CreateUsrUId, 
      apa_MutDate,      apa_MutUsrUId 
  )
  SELECT :pi_apa_ObjUId,    :ps_afa_ObjPrefix, usg_UId,           'USG', 
         1,                 1,                 Current_TimeStamp, :pi_app_ActiveUser, 
         Current_TimeStamp, :pi_app_ActiveUser 
    FROM usg_UserGroup
   WHERE usg_UId <> 1; 
    
END!!

COMMENT ON PROCEDURE sp_Afa_GrantAccess IS 'Add or update application form and return form Id'!!

COMMENT ON PARAMETER sp_Afa_GrantAccess.pi_apa_ObjUId     IS 'Object Id to grant access'!!
COMMENT ON PARAMETER sp_Afa_GrantAccess.ps_afa_ObjPrefix  IS 'Object Prefix'!!
COMMENT ON PARAMETER sp_Afa_GrantAccess.pi_app_ActiveUser IS 'Application active user Id'!!

COMMIT!!


CREATE OR ALTER PROCEDURE sp_Tmp_FillAccess
AS


  -- Fill application objects structure


DECLARE VARIABLE   iUsr_UId          DI_UID;
DECLARE VARIABLE   iApg_UId          DI_UID;
DECLARE VARIABLE   iAfr_UId          DI_UID;
DECLARE VARIABLE   iAfa_UId          DI_UID;
DECLARE VARIABLE   iApr_UId          DI_UID;
DECLARE VARIABLE   iApt_UId          DI_UID;

BEGIN

  iApg_UId = NULL;

  -- Search Basisdaten group

  SELECT MIN( apg_UId )
    FROM apg_AppObjectGroup
   WHERE ( apg_Typ  = 'F' )
         AND
         ( apg_Name = UPPER( 'Basisdaten' ) )
    INTO :iApg_UId;

  IF ( iApg_UId IS NULL ) THEN
    EXIT;

  -- Master user Id
  iUsr_UId = 1;
  
  -- *** TfrmEmpClosePra
  
  -- Delete form with actions
  
  DELETE FROM afr_AppForm WHERE afr_Class = 'TfrmEmpClosePra';

  -- Add form
  EXECUTE PROCEDURE sp_Afr_Insert :iApg_UId, 'Aktueller Mitarbeiter zurücksetzen', '', 'TfrmEmpClosePra', :iUsr_UId  RETURNING_VALUES :iAfr_UId;
  
  -- Grant access
  
  EXECUTE PROCEDURE sp_Afa_GrantAccess :iAfr_UId, 'AFR', :iUsr_UId; 
  
  -- Add report and templates
  
  EXECUTE PROCEDURE sp_Apr_Insert :iAfr_UId, 2, 'Abrechnung verbuchen Report', 'Abrechnung verbuchen Report', 1, 1   RETURNING_VALUES :iApr_UId;
    EXECUTE PROCEDURE sp_Apt_Insert :iApr_UId, 'Lohnabrechnung', 'Lohnabrechnung.fr3', '', 1, 1, 1 RETURNING_VALUES :iApt_UId;
    
  -- Grant access
  
  EXECUTE PROCEDURE sp_Afa_GrantAccess :iApr_UId, 'APR', :iUsr_UId;
  EXECUTE PROCEDURE sp_Afa_GrantAccess :iApt_UId, 'APT', :iUsr_UId;  
     
  -- Add report and templates
  
  EXECUTE PROCEDURE sp_Apr_Insert :iAfr_UId, 2, 'Statistiken Report', 'Statistiken Report', 1, 1   RETURNING_VALUES :iApr_UId;
    EXECUTE PROCEDURE sp_Apt_Insert :iApr_UId, 'Lohnkonto pro Mitarbeiter', 'Lohnkonto pro Mitarbeiter.fr3', '', 0, 1, 1 RETURNING_VALUES :iApt_UId;
    
  EXECUTE PROCEDURE sp_Afa_GrantAccess :iApr_UId, 'APR', :iUsr_UId;
  EXECUTE PROCEDURE sp_Afa_GrantAccess :iApt_UId, 'APT', :iUsr_UId;  
    
END!!


COMMIT!!


EXECUTE PROCEDURE sp_Tmp_FillAccess!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure  'sp_Tmp_FillAccess'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_StatPraPerEmpDet 
(
  pi_EmpUId     DI_UID,
  pi_MonatVon   DI_SMLINT,
  pi_MonatBis   DI_SMLINT
)
RETURNS 
(
  emp_UId       DI_UID,
  gruppe        DS_ONECHARFLAG,
  sdt_SortNr    DI_SMLINT,
  sortNr2       DI_SMLINT,
  sdt_LArt      DS_STR5,
  sdt_Text      DS_DESCR,
  monat1        DN_NUMBER2,
  monat2        DN_NUMBER2,
  monat3        DN_NUMBER2,
  monat4        DN_NUMBER2,
  monat5        DN_NUMBER2,
  monat6        DN_NUMBER2,
  monat7        DN_NUMBER2,
  monat8        DN_NUMBER2,
  monat9        DN_NUMBER2,
  monat10       DN_NUMBER2,
  monat11       DN_NUMBER2,
  monat12       DN_NUMBER2
)
AS

  DECLARE iSdtUId           DI_INT;
  DECLARE iSdtUId1          DI_INT;
  DECLARE iBuyUId           DI_INT;
  DECLARE iBasisNr          DI_INT;
  DECLARE iMonat            DI_INT;
  DECLARE iSdt_UId          DI_UID;
  DECLARE nBetrag           DN_NUMBER2;
  DECLARE nMoBetrag         DN_NUMBER2;
  DECLARE nBetragAg         DN_NUMBER2;
  DECLARE nBetragAn         DN_NUMBER2;
  DECLARE sSdt_Typ          DS_ONECHARFLAG;
  DECLARE sSdt_LArt         DS_STR5;
  DECLARE iSdt_IstLohnTeil  DB_BOOLEAN;
  DECLARE iIst_Ok           DB_BOOLEAN;
  DECLARE sSabText          DS_DESCR;
  DECLARE sBasisText        DS_DESCR;
  DECLARE iPos              INTEGER;
  DECLARE iEmptyInt         INTEGER;
         
BEGIN

  iEmptyInt = 2147483600;
  iSdtUID   = iEmptyInt;
  SORTNR2   = 0;
  
  FOR 
  
    SELECT emp_UId,               prm_Monat, 
           sad_SdtUId,            SUM( sad_Total ),
           SUM( sad_BeitragAg ),  SUM( sad_BeitragAn )
      FROM emp_Employee
     INNER JOIN emy_EmploymentPeriod  ON emy_EmpUId = emp_UId
     INNER JOIN say_Salary            ON say_EmyUId = emy_UId
     INNER JOIN sad_SalaryDetail      ON sad_SayUId = say_UId
      LEFT JOIN pra_PayrollAccount    ON pra_UId    = say_PraUId
      LEFT JOIN prm_PayrollMonth      ON prm_UId    = pra_PrmUId
    WHERE ( emp_UId = :pi_EmpUId )      
      AND ( prm_Monat > 0 )
      AND ( prm_Monat BETWEEN :pi_MonatVon AND :pi_MonatBis )
    GROUP BY emp_UId, prm_Monat, sad_SdtUId
    ORDER BY ABS( sad_SdtUId ), prm_Monat
     INTO :emp_UId, :iMonat,: iSdt_UId, :nBetrag, :nBetragAg, :nBetragAn

  DO 
  BEGIN

    IF ( ( iSdtUId = iEmptyInt ) OR ( iSdtUId <> iSdt_UId ) ) THEN
    BEGIN

      IF ( iSdtUId <> iEmptyInt ) THEN 
      BEGIN

        SUSPEND;

        monat1 = NULL;  monat7  = NULL;
        monat2 = NULL;  monat8  = NULL;
        monat3 = NULL;  monat9  = NULL;
        monat4 = NULL;  monat10 = NULL;
        monat5 = NULL;  monat11 = NULL;
        monat6 = NULL;  monat12 = NULL;

      END


      iSdtUID = iSdt_UId;

      SELECT sdt_Typ,   sdt_LArt,   sdt_Text,   sdt_SortNr,   sdt_IstLohnteil  
        FROM sdt_SalaryDeductionType
       WHERE sdt_UId = :iSdt_UId
        INTO :sSdt_Typ, :sdt_LArt,  :sdt_Text,  :sdt_SortNr,  :iSdt_IstLohnteil;

      IF ( sSdt_Typ = 'L' ) THEN 
      BEGIN
         
        gruppe = '1';

        IF ( iSdt_IstLohnteil = 0 ) THEN
          gruppe = '3';

        nMoBetrag = nBetrag;

      END 
      ELSE 
      BEGIN

         gruppe = '2';
         
         IF ( iSdt_IstLohnteil = 0 ) THEN
          gruppe = '4';

        nMoBetrag = 0-nBetragAN; 

      END

    END 
    ELSE 
    BEGIN

      IF ( sSdt_Typ = 'L' ) THEN
        nMoBetrag = nBetrag;
      ELSE
        nMoBetrag = 0 - nBetragAN;

    END

    IF ( iMonat = 1 ) THEN     
      monat1 = nMoBetrag;      
    ELSE 
    IF ( iMonat = 2 ) THEN 
      monat2 = nMoBetrag;
    ELSE 
    IF ( iMonat = 3 ) THEN 
      monat3 = nMoBetrag; 
    ELSE 
    IF ( iMonat = 4 ) THEN
      monat4 = nMoBetrag;
    ELSE 
    IF ( iMonat = 5 ) THEN
      monat5 = nMoBetrag; 
    ELSE 
    IF ( iMonat = 6 ) THEN
      monat6 = nMoBetrag;
    ELSE 
    IF ( iMonat = 7 ) THEN 
      monat7 = nMoBetrag;
    ELSE 
    IF ( iMonat = 8 ) THEN 
      monat8 = nMoBetrag;
    ELSE 
    IF ( iMonat = 9 ) THEN 
      monat9 = nMoBetrag; 
    ELSE 
    IF ( iMonat = 10 ) THEN
      monat10 = nMoBetrag;
    ELSE 
    IF ( iMonat = 11 ) THEN
      monat11 = nMoBetrag;
    ELSE 
    IF ( iMonat = 12 ) THEN
      monat12 = nMoBetrag;    

  END

  IF ( iSdtUId <> iEmptyInt ) THEN
    SUSPEND; 



    /*************************** Alle Basen und Loehne rechnen  *******************************/
  SELECT emp_BuyUId 
    FROM emp_Employee 
   WHERE emp_UId = :pi_EmpUId 
    INTO :iBuyUId;

  FOR 
    
    SELECT sab_BasisNr, sab_Bezeichnung 
      FROM sab_SalaryBasis
     WHERE sab_BuyUId = :iBuyUId  
       AND sab_BasisNr <= 15   -- kann entfernt werden, wenn nur 15 Basen ind SAB_SALARYBASIS 
      INTO :iBasisNr,   :sSabText

  DO 
  BEGIN


    sBasisText = sSabText;
    iPos = POSITION( '(' IN sBasisText );
    IF( iPos > 0 ) THEN 
      sBasisText = LEFT( sBasisText, iPos - 1 );    
  
    /************ Alle Basen ************************************/
    gruppe      = '5';
    sdt_SortNr  = iBasisNr;
    sdt_LArt    = 'Basis'; 

    iIst_Ok     = 0;
    iSdtUId1    = iEmptyInt;
    
    FOR 
      
      SELECT sdt_UId, prm_Monat, SUM( sad_Basis ) 
        FROM emp_Employee
       INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UId
       INNER JOIN say_Salary ON say_EmyUId = emy_UId
       INNER JOIN sad_SalaryDetail ON sad_SayUId = say_UId
        LEFT JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
        LEFT JOIN pra_PayrollAccount ON pra_UId = say_PraUId
        LEFT JOIN prm_PayrollMonth ON prm_UId   = pra_PrmUId
       WHERE ( emp_UId = :pi_EmpUId ) 
         AND ( prm_Monat > 0 ) 
         AND ( prm_Monat BETWEEN :pi_MonatVon AND :pi_MonatBis )
         AND ( sdt_BerechBasisNr = :iBasisNr )
       GROUP BY sdt_UId, prm_Monat, sdt_UId
       INTO :iSdtUID, :iMonat, :nBetrag
       
    DO 
    BEGIN

      IF ( iSdtUID1 <> iSdtUID ) THEN 
      BEGIN

        IF ( iSdtUID1 = iEmptyInt ) THEN 
        BEGIN

          iSdtUID1 = iSdtUID;
      
          monat1 = NULL;  monat7  = NULL;
          monat2 = NULL;  monat8  = NULL;
          monat3 = NULL;  monat9  = NULL;
          monat4 = NULL;  monat10 = NULL;
          monat5 = NULL;  monat11 = NULL;
          monat6 = NULL;  monat12 = NULL;

          sortNr2   = 0;
          sSdt_LArt = '';
          
          SELECT sdt_LArt,    sdt_SortNr 
            FROM sdt_SalaryDeductionType
           WHERE sdt_UId = :iSdtUId
            INTO :sSdt_LArt,  :sortNr2;

          sdt_Text = Trim( sBasisText ) || ' (' || Trim( sSdt_LArt ) || ')';

        END 
        ELSE 
        BEGIN
 
          SUSPEND;

          monat1 = NULL;  monat7  = NULL;
          monat2 = NULL;  monat8  = NULL;
          monat3 = NULL;  monat9  = NULL;
          monat4 = NULL;  monat10 = NULL;
          monat5 = NULL;  monat11 = NULL;
          monat6 = NULL;  monat12 = NULL;

          sortNr2   = 0;
          sSdt_LArt = '';
          
          SELECT sdt_LArt, sdt_SortNr 
            FROM sdt_SalaryDeductionType
           WHERE sdt_UId = :iSdtUId
            INTO :sSdt_LArt, :sortNr2;

          sdt_Text    = Trim( sBasisText ) || ' (' || Trim( sSdt_LArt ) || ')';

          iSdtUID1 = iSdtUID;

        END       
 
      END
  
      iIst_Ok = 1;
 
      IF ( iMonat = 1 ) THEN 
        monat1 = nBetrag;
      ELSE 
      IF ( iMonat = 2 ) THEN 
        monat2 = nBetrag;
      ELSE 
      IF ( iMonat = 3 ) THEN
        monat3 = nBetrag;
      ELSE 
      IF ( iMonat = 4 ) THEN 
        monat4 = nBetrag; 
      ELSE 
      IF ( iMonat = 5 ) THEN 
        monat5 = nBetrag; 
      ELSE 
      IF ( iMonat = 6 ) THEN
        monat6 = nBetrag; 
      ELSE 
      IF ( iMonat = 7 ) THEN 
        monat7 = nBetrag; 
      ELSE 
      IF ( iMonat = 8 ) THEN 
        monat8 = nBetrag; 
      ELSE 
      IF ( iMonat = 9 ) THEN 
        monat9 = nBetrag; 
      ELSE 
      IF ( iMonat = 10 ) THEN
        monat10 = nBetrag; 
      ELSE 
      IF ( iMonat = 11 ) THEN
        monat11 = nBetrag; 
      ELSE 
      IF ( iMonat = 12 ) THEN
        monat12 = nBetrag;        

    END

    IF ( iIst_Ok = 1 ) THEN 
      SUSPEND; 

 
    /************ Alle Loehne *****************************************/

    IF ( iIst_Ok = 1 ) THEN 
    BEGIN     -- (nur falls auch eine Basis berechnet wurde)
 
      iIst_Ok = 0;

      gruppe      = '5';
      sdt_SortNr  = iBasisNr;
      sortNr2     = -9999;
      sdt_LArt    = 'Lohn'; 
      sdt_Text    = sBasisText;

      FOR EXECUTE STATEMENT
  
          'SELECT M.PRM_MONAT,T.SDT_TYP,SUM(D.SAD_TOTAL) FROM EMP_EMPLOYEE E    '||
          '    INNER JOIN EMY_EMPLOYMENTPERIOD Y ON Y.EMY_EMPUID=E.EMP_UID      '|| 
          '    INNER JOIN SAY_SALARY S ON S.SAY_EMYUID=Y.EMY_UID                '|| 
          '    INNER JOIN SAD_SALARYDETAIL D ON D.SAD_SAYUID=S.SAY_UID          '|| 
          '    LEFT JOIN SDT_SALARYDEDUCTIONTYPE T on T.SDT_UID=D.SAD_SDTUID    '||   
          '    LEFT JOIN PRA_PAYROLLACCOUNT A ON A.PRA_UID=S.SAY_PRAUID         '||   
          '    LEFT JOIN PRM_PAYROLLMONTH M ON M.PRM_UID=A.PRA_PRMUID           '|| 
          '   WHERE (E.EMP_UID='||pi_EmpUId||') AND (A.PRA_ISTVERBUCHT = 1) AND '|| 
          '         (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN '||pi_MonatVon||' AND '||pi_MonatBis||') '||
          '         AND (T.SDT_BASIS'||iBasisNr||' = 1 )                        '||
          '   GROUP BY M.PRM_MONAT,T.SDT_TYP                                    '

              INTO :iMonat,:sSdt_Typ,:nBetrag
              
      DO 
      BEGIN


        iIST_OK = 1;
         
        IF ( sSdt_Typ = 'L' ) THEN 
        BEGIN

          IF ( iMonat = 1 ) THEN 
            monat1 = nBetrag;
          ELSE 
          IF ( iMonat = 2 ) THEN 
            monat2 = nBetrag;
          ELSE 
          IF ( iMonat = 3 ) THEN
            monat3 = nBetrag;
          ELSE 
          IF ( iMonat = 4 ) THEN 
            monat4 = nBetrag; 
          ELSE 
          IF ( iMonat = 5 ) THEN 
            monat5 = nBetrag; 
          ELSE 
          IF ( iMonat = 6 ) THEN
            monat6 = nBetrag; 
          ELSE 
          IF ( iMonat = 7 ) THEN 
            monat7 = nBetrag; 
          ELSE 
          IF ( iMonat = 8 ) THEN 
            monat8 = nBetrag; 
          ELSE 
          IF ( iMonat = 9 ) THEN 
            monat9 = nBetrag; 
          ELSE 
          IF ( iMonat = 10 ) THEN
            monat10 = nBetrag; 
          ELSE 
          IF ( iMonat = 11 ) THEN
            monat11 = nBetrag; 
          ELSE 
          IF ( iMonat = 12 ) THEN
            monat12 = nBetrag;
 
        END
  
      END
  
      IF ( iIst_Ok = 1 ) THEN
        SUSPEND;

    END 

  END

END!!

COMMENT ON PROCEDURE SP_RPT_STATPRAPEREMPDET IS 'Helper procedure: Get detail data for the report: Statistik \ Lohnkonto pro Mitarbeiter (Data Per Employee)'!!

COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.EMP_UID     IS 'Employee ID'!!
COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.GRUPPE      IS 'Report Group: 1= salary and IstLohn=True; 2 = deduction and IstLohn=True; 3=salary and IstLohn=False; 4= deduction and IstLohn=False; 5= Lohn/Basis'!!
COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.SDT_SORTNR  IS 'Sort in Group: G1..G4 -> SDT_SortNr; G5 = SDT_BasisNo'!!
COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.PI_EMPUID   IS 'Employee Id'!!
COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.PI_MONATVON IS 'Month from (1..12)'!!
COMMENT ON PARAMETER SP_RPT_STATPRAPEREMPDET.PI_MONATBIS IS 'Month to (1..12)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Buy_Select
(
    pi_buy_FirUId   DI_UID     DEFAULT NULL,  -- Id of the Firm to select Bisness Years
    pi_buy_UId      DI_UID     DEFAULT NULL,  -- Id of the Business Year to be selected
    pb_IstAktivJahr DB_BOOLEAN DEFAULT NULL   -- If not null select only active Bisness Year
)
RETURNS
(
   buy_UId                        DI_UID,
   buy_FirUId                     DI_UID,
   buy_GeschJahr                  DI_BUSINESSYEAR,
   buy_IstAktGeschJahr            DB_ISACTIVE,
   buy_IstIndustrieMinuten        DB_BOOLEAN,
   buy_IstAbreGruppiert           DB_BOOLEAN,
   buy_DatumVon                   DD_DATE,
   buy_DatumBis                   DD_DATE,
   buy_OptAkt_Ist18               DB_BOOLEAN,
   buy_OptAkt_Ist24               DB_BOOLEAN,
   buy_OptAkt_IstPensionAkt       DB_BOOLEAN,
   buy_OptAkt_IstPensionNext      DB_BOOLEAN,
   buy_OptAkt_IstGeburtstagAkt    DB_BOOLEAN,
   buy_OptAkt_IstGeburtstagNext   DB_BOOLEAN,
   buy_OptAkt_IstLetzteAbrechnung DB_BOOLEAN,
   buy_OptAkt_IstGanzesJahr       DB_BOOLEAN,
   buy_Sage_IstAktiv              DB_BOOLEAN,
   buy_Sage_Passwort              DS_PASSWORD,
   buy_Sage_Pfad                  DS_STR128,
   buy_Sage_KontierungTyp         DS_ONECHARFLAG,
   buy_Sage_Kreis                 DS_STR20,
   buy_Sage_AutoMwSt              DB_BOOLEAN,
   buy_CreateDate                 DD_TIMESTAMP,
   buy_CreateUsrUId               DI_UID,
   buy_MutDate                    DD_TIMESTAMP,
   buy_MutUsrUId                  DI_UID,
   buy_CuiIsoCode                 DS_CODE,
   buy_CuiUId                     DI_UID,
   buy_CreateUser                 DS_USERLOGIN,
   buy_MutUser                    DS_USERLOGIN
)
AS

  -- Select Business year data
  
BEGIN

  FOR

    SELECT buy_UId,
           buy_FirUId,
           buy_GeschJahr,
           buy_IstAktGeschJahr,
           buy_IstIndustrieMinuten,
           buy_IstAbreGruppiert,
           buy_DatumVon,
           buy_DatumBis,
           buy_OptAkt_Ist18,
           buy_OptAkt_Ist24,
           buy_OptAkt_IstPensionAkt,
           buy_OptAkt_IstPensionNext,
           buy_OptAkt_IstGeburtstagAkt,
           buy_OptAkt_IstGeburtstagNext,
           buy_OptAkt_IstLetzteAbrechnung,
           buy_OptAkt_IstGanzesJahr,
           buy_Sage_IstAktiv,
           buy_Sage_Passwort,
           buy_Sage_Pfad,
           buy_Sage_KontierungTyp,
           buy_Sage_Kreis,
           buy_Sage_AutoMwSt,
           buy_CreateDate,
           buy_CreateUsrUId,
           buy_MutDate,
           buy_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS buy_CreateUser,
           USR_M.usr_Login AS buy_MutUser
      FROM buy_BusinessYear
      LEFT JOIN cul_CurrencyList ON cul_MastUId = buy_UId AND cul_MastPrefix = 'BUY' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON buy_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON buy_MutUsrUId    = USR_M.usr_UId
     WHERE ( :pi_buy_FirUId   IS NULL OR buy_FirUId          = :pi_buy_FirUId   )
       AND ( :pb_IstAktivJahr IS NULL OR buy_IstAktGeschJahr = :pb_IstAktivJahr )
       AND ( 
              :pi_buy_UId IS NULL AND buy_UId > 0 
              OR 
              buy_UId = :pi_buy_UId       
           )
      INTO :buy_UId,
           :buy_FirUId,
           :buy_GeschJahr,
           :buy_IstAktGeschJahr,
           :buy_IstIndustrieMinuten,
           :buy_IstAbreGruppiert,
           :buy_DatumVon,
           :buy_DatumBis,
           :buy_OptAkt_Ist18,
           :buy_OptAkt_Ist24,
           :buy_OptAkt_IstPensionAkt,
           :buy_OptAkt_IstPensionNext,
           :buy_OptAkt_IstGeburtstagAkt,
           :buy_OptAkt_IstGeburtstagNext,
           :buy_OptAkt_IstLetzteAbrechnung,
           :buy_OptAkt_IstGanzesJahr,
           :buy_Sage_IstAktiv,
           :buy_Sage_Passwort,
           :buy_Sage_Pfad,
           :buy_Sage_KontierungTyp,
           :buy_Sage_Kreis,
           :buy_Sage_AutoMwSt,
           :buy_CreateDate,
           :buy_CreateUsrUId,
           :buy_MutDate,
           :buy_MutUsrUId,
           :buy_CuiIsoCode,
           :buy_CuiUId,
           :buy_CreateUser,
           :buy_MutUser
  DO
    SUSPEND;

END!!


COMMENT ON PROCEDURE sp_buy_Select IS 'Select Business year data'!!

COMMENT ON PARAMETER sp_buy_Select.pi_buy_UId      IS 'Id of the Currency to be selected'!!
COMMENT ON PARAMETER sp_buy_Select.pi_buy_FirUId   IS 'Id of the Firm to select Bisness Years'!!
COMMENT ON PARAMETER sp_buy_Select.pb_IstAktivJahr IS 'If not null select only active Bisness Year'!!

COMMIT!!

-- FS#1123:END
-- +++


-- +++
-- FS#1148 - PKLohn - In FirmManagement bug when reset FirmHours

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERUNF 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE ISAXUID       DI_UID;
DECLARE VARIABLE NBEITRAGAG    DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN    DN_NUMBER2;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;




    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :LOHN_BRUTTO,:PRM_MONATVON,:PRM_MONATBIS;



     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn;


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS )
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;  

      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;


     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 0)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 3)
            AND (T.SDT_SAXUID = 13)
            AND (T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   

      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

 
      -- BU-Pflichtiger Lohn----
      K2_SAXUID   = 14;    -- (14 = BU)
      K2_PFLICHT  = nAHVLohnPfl + (nAHVLohn - nAHVLohnPfl) - (nNBULohn - nNBULohnPfl);


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 1)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            
      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      K1_SAXUID  = 13;    -- (13 = NBU)
      K1_PFLICHT = K2_PFLICHT - nAHVUnter8Std;


     --- Beitraege rechnen ----------------------------------------------------

     FOR SELECT T.SDT_SAXUID,
                SUM(D.SAD_BEITRAGAG),
                SUM(D.SAD_BEITRAGAN)

         FROM EMY_EMPLOYMENTPERIOD Y
       
         INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
         LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
         LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
               (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
               (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
               (T.SDT_SAXUID in (13,14))
         
         GROUP BY T.SDT_SAXUID

         INTO :iSAXUid,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF ( iSAXUid = 13) THEN BEGIN        -- wenn NBU

           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END      

        IF ( iSAXUid = 14) THEN BEGIN        -- wenn BU

           K2_BEITRAG_AN = nBeitragAN;      
           K2_BEITRAG_AG = nBeitragAG;

        END      

     END


     -- SAX-Bezeichung holen  
     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 13
     INTO :K1_SAXBEZ;

     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 14
     INTO :K2_SAXBEZ;


     -- Get data from Employee
     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM

      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND; 


  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERUNF IS 'Get data for the report: Quarter \ Unfall Quartalsmeldung (UNF Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALUNF 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    AHV_LOHN           DN_NUMBER2,
    AHV_LOHN_NP        DN_NUMBER2,
    AHV_LOHN_US        DN_NUMBER2,
    BU_LOHN            DN_NUMBER2,
    STD8_LOHN          DN_NUMBER2,
    NBU_LOHN           DN_NUMBER2,
    BEITRAG_BU         DN_NUMBER2,
    BEITRAG_NBU        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     AHV_LOHN    = 0;
     AHV_LOHN_NP = 0;
     AHV_LOHN_US = 0;
     BU_LOHN     = 0;
     STD8_LOHN   = 0;
     NBU_LOHN    = 0;
     BEITRAG_BU  = 0;
     BEITRAG_NBU = 0;

     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn ;   


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;   


      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;

      AHV_LOHN    = nAHVLohnPfl;
      AHV_LOHN_NP = nAHVLohn - nAHVLohnPfl;



     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 13)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   


      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

      AHV_LOHN_US = nNBULohn - nNBULohnPfl;
      
 
      -- BU-Pflichtiger Lohn----
      BU_LOHN     = AHV_LOHN + AHV_LOHN_NP - AHV_LOHN_US;


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 1)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      STD8_LOHN = nAHVUnter8Std;

      NBU_LOHN  = BU_LOHN - nAHVUnter8Std;


     -- Beitraege AG und AN rechnen ----

     SELECT SUM(D.SAD_BEITRAGAG),
            SUM(D.SAD_BEITRAGAN)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
            (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
            (T.SDT_SAXUID in (13,14))

     INTO :BEITRAG_BU,
          :BEITRAG_NBU;


     -- Personalien des MA's ----

      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C.COI_ISOCODE,
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             E.EMP_GESCHLECHT,
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM


       FROM EMP_EMPLOYEE E

       LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

       WHERE E.EMP_UID = :EMP_UID

       INTO :EMP_PERSNR,
            :EMP_PEIDNR,
            :EMP_NAME,
            :EMP_VORNAME,
            :EMP_STRASSE,
            :emp_HausNr,
            :COI_ISOCODE,
            :EMP_PLZ,
            :EMP_ORT, 
            :EMP_GEBURTSDATUM, 
            :EMP_PENSIONDATUM, 
            :EMP_GESCHLECHT,
            :EMP_EINTRITTSDATUM,
            :EMP_AUSTRITTSDATUM;


      SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALUNF IS 'Get data for the report: Annual \ Jahresabrechnung UNF (UNF Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Select
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR30,
    emp_EmailPasswort     DS_STR50,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR
)                             
AS
  /* Select Employee data by Id or by Employee*/

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;
  DECLARE iVortragFerien       DI_INT;
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN

  SELECT buy_FirUId, buy_GeschJahr,
         EXTRACT(YEAR FROM buy_DatumVon),
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;

  SELECT buy_UId
    FROM buy_BusinessYear
   WHERE buy_FirUId    = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
     AND buy_UId       > 0
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_EmailPasswort,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_Code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,

           (
            SELECT E.emp_UId
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,

           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_EmailPasswort,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_Code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,

           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,

           :luk_Zivilstand

  DO
  BEGIN

    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;

    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN

      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END

      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END

    END


    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;

      SUSPEND;

    END

  END

END!!

COMMIT!!


COMMENT ON PROCEDURE sp_Emp_Select IS 'Select Employee(s) data'!!

COMMENT ON PARAMETER sp_Emp_Select.pi_BuyUId IS 'Id of the Business Year'!!

COMMIT!!

-- FS#1148:END
-- +++

SET TERM ;!!