﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.19
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;    

-- +++
-- FS#1041 - PKLohn - In FirmManagement bug when reset FirmHours

CREATE OR ALTER PROCEDURE sp_Fih_ZeroHours
(
    pi_BuyUId           DI_UID_NN,            -- Id of the Business Year
    pi_App_ActiveUser   DI_UID_NN             -- Id of User
)
AS

  -- Zero firm hours values
  
  DECLARE iTplPraUId DI_UID;

BEGIN

  EXECUTE PROCEDURE sp_Pra_GetAccountForTemplate :pi_BuyUId
   RETURNING_VALUES :iTplPraUId;
    
  UPDATE fih_FirmHours
     SET fih_SollTage     = 0,
         fih_SollAzMonat  = 0,
         fih_MutDate      = Current_TimeStamp,
         fih_MutUsrUId    = :pi_App_ActiveUser
   WHERE fih_BuyUId       = :pi_BuyUId
     AND NOT EXISTS
         (
            SELECT say_UId
              FROM say_Salary
             WHERE say_PraUId <> :iTplPraUId
               AND fih_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                             AND     EXTRACT(MONTH FROM say_DatumBis)
         );
  
END!!

COMMENT ON PROCEDURE sp_Fih_ZeroHours                    IS 'Zero firm hours values'!!
COMMENT ON PARAMETER sp_Fih_ZeroHours.pi_BuyUId          IS 'Id of the Business Year'!!
COMMENT ON PARAMETER sp_Fih_ZeroHours.pi_App_ActiveUser  IS 'Id of User'!!  

COMMIT!!

-- FS#1041:END


-- +++

-- +++
-- FS#1048 - PKLohn - Add FibuBeleg.fr3 to ReportOtherNotificationsFRM

EXECUTE BLOCK
AS

DECLARE VARIABLE iApr_UId DI_UID;
DECLARE VARIABLE iApt_UId DI_UID;

BEGIN  

  SELECT apr_UId
    FROM apr_AppReport
   WHERE apr_ApgUId = 2
     AND apr_Name        = 'Sonstige Meldungen Report'
     AND apr_Bezeichnung = 'Sonstige Meldungen Report'
    INTO iApr_UId;

  EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Buchungsbeleg', 'FibuBeleg.fr3', '', 0, 1, 1
  RETURNING_VALUES :iApt_UId;
  
  UPDATE apt_AppTemplate SET apt_SortOrder = 1 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Lohnabrechnung';
  UPDATE apt_AppTemplate SET apt_SortOrder = 2 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Buchungsbeleg';
  UPDATE apt_AppTemplate SET apt_SortOrder = 3 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Ein- u. Austritte an Amt';
  UPDATE apt_AppTemplate SET apt_SortOrder = 4 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Geburtstagsliste';
  UPDATE apt_AppTemplate SET apt_SortOrder = 5 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Jubilarenliste';
  UPDATE apt_AppTemplate SET apt_SortOrder = 6 WHERE apt_AprUId = :iApr_UId AND apt_Name = 'Mitarbeiterliste';

END!!
COMMIT!!

-- FS#1048:END

-- +++
-- FS#1051 - PKLohn - NotRepeat option for PayrollMonths

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'prm_PayrollMonth', 'prm_IstEinmalig', 'DB_BOOLEAN_NN DEFAULT 0' )!!
COMMIT!!

COMMENT ON COLUMN prm_PayrollMonth.prm_IstEinmalig IS 'Flag, transfer or not month to the next business year'!!
COMMIT!!

ALTER TABLE prm_PayrollMonth ALTER prm_IstEinmalig POSITION 15!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Prm_Insert
(
    pi_prm_BuyUId          DI_UID_NN,
    pi_prm_Monat           DI_SMLINT_NN,
    pi_prm_AbreNr          DI_SMLINT_NN,
    ps_prm_Bezeichnung     DS_DESCR_NN,
    pi_prm_AZTag           DI_SMLINT_NN,
    pb_prm_IsAzFolgeMonat  DB_BOOLEAN_NN,
    pb_prm_IstSoGruppiert  DB_BOOLEAN_NN,
    pi_prm_CoiUId          DI_UID,
    pi_prm_DepUId          DI_UID,
    pi_prm_CatUId          DI_UID,
    pi_prm_PrgUId          DI_UID,
    pb_prm_IstUnd          DB_BOOLEAN_NN,
    ps_prm_LA_Text         DS_STR1024,
    pb_prm_IstEinmalig     DB_BOOLEAN_NN,
    pb_prm_IstAktiv        DB_ISACTIVE_NN,
    pi_app_ActiveUser      DI_UID_NN
)
RETURNS( prm_UId DI_UID_NN )
AS

  -- Add a new PayrollMonth and return PayrollMonth Id

BEGIN

  prm_UId = GEN_ID (GEN_Prm_UId,1);


  INSERT INTO prm_PayrollMonth
  (
    prm_UId,
    prm_BuyUId,
    prm_Monat,
    prm_AbreNr,
    prm_Bezeichnung,
    prm_AZTag,
    prm_IsAzFolgeMonat,
    prm_IstSoGruppiert,
    prm_CoiUId,
    prm_DepUId,
    prm_CatUId,
    prm_PrgUId,
    prm_IstUnd,
    prm_LA_Text,
    prm_IstEinmalig,
    prm_IstAktiv,
    prm_CreateDate,
    prm_CreateUsrUId,
    prm_MutDate,
    prm_MutUsrUId
  )
  VALUES
  (
    :prm_UId,
    :pi_prm_BuyUId,
    :pi_prm_Monat,
    :pi_prm_AbreNr,
    :ps_prm_Bezeichnung,
    :pi_prm_AZTag,
    :pb_prm_IsAzFolgeMonat,
    :pb_prm_IstSoGruppiert,
    :pi_prm_CoiUId,
    :pi_prm_DepUId,
    :pi_prm_CatUId,
    :pi_prm_PrgUId,
    :pb_prm_IstUnd,
    :ps_prm_LA_Text,
    :pb_prm_IstEinmalig,
    :pb_prm_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!


COMMENT ON PROCEDURE sp_Prm_Insert IS 'Add a new PayrollMonth and return PayrollMonth Id'!!

COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_BuyUId          IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_Monat           IS 'Month 1..12, 0 - special type (Master record for account templates)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_AbreNr          IS 'Billing number'!!
COMMENT ON PARAMETER sp_Prm_Insert.ps_prm_Bezeichnung     IS 'Description'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_AZTag           IS 'Payout day'!!
COMMENT ON PARAMETER sp_Prm_Insert.pb_prm_IsAzFolgeMonat  IS 'Flag, true = payment date next month, false = * current month'!!
COMMENT ON PARAMETER sp_Prm_Insert.pb_prm_IstSoGruppiert  IS ''!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_CoiUId          IS 'Country Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_DepUId          IS 'Department Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_CatUId          IS 'Category Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_prm_PrgUId          IS 'Payroll group Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Insert.pb_prm_IstUnd          IS 'true - selection and, false - selection or'!!
COMMENT ON PARAMETER sp_Prm_Insert.ps_prm_LA_Text         IS 'Text for all PayrollAccount'!!
COMMENT ON PARAMETER sp_Prm_Insert.pb_prm_IstEinmalig     IS 'Flag, transfer or not month to the next business year'!!
COMMENT ON PARAMETER sp_Prm_Insert.pb_prm_IstAktiv        IS 'Active flag'!!
COMMENT ON PARAMETER sp_Prm_Insert.pi_app_ActiveUser      IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Prm_Update
(
    pi_prm_UId             DI_UID_NN,
    pi_prm_BuyUId          DI_UID_NN,
    pi_prm_Monat           DI_SMLINT_NN,
    pi_prm_AbreNr          DI_SMLINT_NN,
    ps_prm_Bezeichnung     DS_DESCR_NN,
    pi_prm_AZTag           DI_SMLINT_NN,
    pb_prm_IsAzFolgeMonat  DB_BOOLEAN_NN,
    pb_prm_IstSoGruppiert  DB_BOOLEAN_NN,
    pi_prm_CoiUId          DI_UID,
    pi_prm_DepUId          DI_UID,
    pi_prm_CatUId          DI_UID,
    pi_prm_PrgUId          DI_UID,
    pb_prm_IstUnd          DB_BOOLEAN_NN,
    ps_prm_LA_Text         DS_STR1024,
    pb_prm_IstEinmalig     DB_BOOLEAN_NN,
    pb_prm_IstAktiv        DB_ISACTIVE_NN,
    pi_app_ActiveUser      DI_UID_NN
)
AS

  -- Update PayrollMonth data by Id

BEGIN

  UPDATE prm_PayrollMonth
     SET prm_BuyUId          = :pi_prm_BuyUId,
         prm_Monat           = :pi_prm_Monat,
         prm_AbreNr          = :pi_prm_AbreNr,
         prm_Bezeichnung     = :ps_prm_Bezeichnung,
         prm_AZTag           = :pi_prm_AZTag,
         prm_IsAzFolgeMonat  = :pb_prm_IsAzFolgeMonat,
         prm_IstSoGruppiert  = :pb_prm_IstSoGruppiert,
         prm_CoiUId          = :pi_prm_CoiUId,
         prm_DepUId          = :pi_prm_DepUId,
         prm_CatUId          = :pi_prm_CatUId,
         prm_PrgUId          = :pi_prm_PrgUId,
         prm_IstUnd          = :pb_prm_IstUnd,
         prm_LA_Text         = :ps_prm_LA_Text,
         prm_IstEinmalig     = :pb_prm_IstEinmalig,
         prm_IstAktiv        = :pb_prm_IstAktiv,
         prm_MutDate         = Current_TimeStamp,
         prm_MutUsrUId       = :pi_app_ActiveUser
   WHERE prm_UId             = :pi_prm_UId;

END!!


COMMENT ON PROCEDURE sp_Prm_Update IS 'Update PayrollMonth data by Id'!!

COMMENT ON PARAMETER sp_Prm_Update.pi_prm_UId             IS 'Id of the PayrollMonth to be updated'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_BuyUId          IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_Monat           IS 'Month 1..12, 0 - special type (Master record for account templates)'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_AbreNr          IS 'Billing number'!!
COMMENT ON PARAMETER sp_Prm_Update.ps_prm_Bezeichnung     IS 'Description'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_AZTag           IS 'Payout day'!!
COMMENT ON PARAMETER sp_Prm_Update.pb_prm_IsAzFolgeMonat  IS 'Flag, true = payment date next month, false = * current month'!!
COMMENT ON PARAMETER sp_Prm_Update.pb_prm_IstSoGruppiert  IS ''!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_CoiUId          IS 'Country Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_DepUId          IS 'Department Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_CatUId          IS 'Category Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_prm_PrgUId          IS 'Payroll group Id (FK)'!!
COMMENT ON PARAMETER sp_Prm_Update.pb_prm_IstUnd          IS 'true - selection and, false - selection or'!!
COMMENT ON PARAMETER sp_Prm_Update.ps_prm_LA_Text         IS 'Text for all PayrollAccount'!!
COMMENT ON PARAMETER sp_Prm_Update.pb_prm_IstEinmalig     IS 'Flag, transfer or not month to the next business year'!!
COMMENT ON PARAMETER sp_Prm_Update.pb_prm_IstAktiv        IS 'Active flag'!!
COMMENT ON PARAMETER sp_Prm_Update.pi_app_ActiveUser      IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Prm_Select
(
   pi_PrmUId           DI_UID       DEFAULT NULL,  -- Id of the PayrollMonth to be selected
   pi_BuyUId           DI_UID       DEFAULT NULL   -- Id of the Business year
)
RETURNS
(
   prm_UId             DI_UID,
   prm_BuyUId          DI_UID,
   prm_Monat           DI_SMLINT,
   prm_AbreNr          DI_SMLINT,
   prm_Bezeichnung     DS_DESCR,
   prm_AZTag           DI_SMLINT,
   prm_IsAzFolgeMonat  DB_BOOLEAN,
   prm_IstSoGruppiert  DB_BOOLEAN,
   prm_CoiUId          DI_UID,
   prm_DepUId          DI_UID,
   prm_CatUId          DI_UID,
   prm_PrgUId          DI_UID,
   prm_IstUnd          DB_BOOLEAN,
   prm_LA_Text         DS_STR1024,
   prm_IstAktiv        DB_ISACTIVE,
   prm_IstEinmalig     DB_BOOLEAN_NN,
   prm_CreateDate      DD_TIMESTAMP,
   prm_CreateUsrUId    DI_UID,
   prm_MutDate         DD_TIMESTAMP,
   prm_MutUsrUId       DI_UID,
   prm_CreateUser      DS_USERLOGIN,
   prm_MutUser         DS_USERLOGIN
)
AS

  -- Select PayrollMonth data by Id or by Business year Id

BEGIN

  FOR

    SELECT prm_UId,
           prm_BuyUId,
           prm_Monat,
           prm_AbreNr,
           prm_Bezeichnung,
           prm_AZTag,
           prm_IsAzFolgeMonat,
           prm_IstSoGruppiert,
           prm_CoiUId,
           prm_DepUId,
           prm_CatUId,
           prm_PrgUId,
           prm_IstUnd,
           prm_LA_Text,
           prm_IstEinmalig,
           prm_IstAktiv,
           prm_CreateDate,
           prm_CreateUsrUId,
           prm_MutDate,
           prm_MutUsrUId,
           USR_C.usr_Login AS prm_CreateUser,
           USR_M.usr_Login AS prm_MutUser
      FROM prm_PayrollMonth
      LEFT JOIN usr_User USR_C ON prm_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M ON prm_MutUsrUId    = USR_M.usr_UId
     WHERE (
             :pi_PrmUId IS NULL
             OR
             prm_UId = :pi_PrmUId
           )
           AND
           (
             :pi_BuyUId IS NULL
             OR
             prm_BuyUId  = :pi_BuyUId
           )
           AND ( prm_Monat <> 0 )
     ORDER BY prm_BuyUId, prm_Monat, prm_AbreNr
      INTO :prm_UId,
           :prm_BuyUId,
           :prm_Monat,
           :prm_AbreNr,
           :prm_Bezeichnung,
           :prm_AZTag,
           :prm_IsAzFolgeMonat,
           :prm_IstSoGruppiert,
           :prm_CoiUId,
           :prm_DepUId,
           :prm_CatUId,
           :prm_PrgUId,
           :prm_IstUnd,
           :prm_LA_Text,
           :prm_IstEinmalig,
           :prm_IstAktiv,
           :prm_CreateDate,
           :prm_CreateUsrUId,
           :prm_MutDate,
           :prm_MutUsrUId,
           :prm_CreateUser,
           :prm_MutUser

  DO
  BEGIN

    SUSPEND;

  END


END!!


COMMENT ON PROCEDURE sp_Prm_Select IS 'Select PayrollMonth(s) data'!!

COMMENT ON PARAMETER sp_Prm_Select.pi_PrmUId     IS 'Id of the PayrollMonth to be selected'!!
COMMENT ON PARAMETER sp_Prm_Select.pi_BuyUId     IS 'Id of the bussines year '!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_InsDefaultRecs4BusYear
(
  pi_BuyUId     DI_UID,
  pi_MutUsrUId  DI_UID
)
AS

  -- Insert default payroll account data
  
DECLARE VARIABLE iPrmUId DI_UID;
DECLARE VARIABLE iPraUId DI_UID;
DECLARE VARIABLE iPrgUId DI_UID;

BEGIN

  -- Get payroll mont UId

  SELECT prm_UId 
    FROM prm_PayrollMonth
   WHERE prm_BuyUId = :pi_BuyUId
     AND prm_Monat  = 0
    INTO :iPrmUId;
    
  IF ( iPrmUId IS NULL ) THEN
    EXECUTE PROCEDURE sp_Prm_Insert
                      ( 
                        :pi_BuyUId,                             0,    0, 
                        'Master record for account templates',  1,    1, 
                        0,                                      NULL, NULL, 
                        NULL,                                   NULL, 0, 
                        '',                                     0,    1,    
                        :pi_MutUsrUId
                      ) 
     RETURNING_VALUES :iPrmUId;
     
  -- Get payroll group UId
  
  SELECT prg_UId 
    FROM prg_PayrollGroup
   WHERE prg_IstStandard = 1
     AND prg_BuyUId      = :pi_BuyUId
    INTO :iPrgUId;
  
  
  EXECUTE PROCEDURE sp_Pra_Insert( :iPrmUId, :iPrgUId, CAST( 'NOW' AS DATE ), 0, 1, :pi_MutUsrUId )
   RETURNING_VALUES :iPraUId;

END!!

COMMENT ON PROCEDURE sp_Pra_InsDefaultRecs4BusYear              IS 'Insert default pra data into new business year'!!
COMMENT ON PARAMETER sp_Pra_InsDefaultRecs4BusYear.pi_BuyUId    IS 'Business year UId'!!
COMMENT ON PARAMETER sp_Pra_InsDefaultRecs4BusYear.pi_MutUsrUId IS 'Modification user UId'!!

COMMIT!!

-- FS#1051:END


-- +++
-- FS#1047 - PKLohn - Additional data fields for Reports

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fii_FirmInstitution', 'fii_ContactPerson', 'DS_STR50_NN DEFAULT '''' '  )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fii_FirmInstitution', 'fii_TelNr',         'DS_STR20_NN DEFAULT '''' '  )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fii_FirmInstitution', 'fii_EMail',         'DS_STR50_NN DEFAULT '''' '  )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fii_FirmInstitution', 'fii_AnnualChk',     'DB_BOOLEAN_NN DEFAULT 0'    )!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fii_FirmInstitution', 'fii_AnnualText',    'DS_STR150_NN DEFAULT '''' ' )!!
COMMIT!!

COMMENT ON COLUMN fii_FirmInstitution.fii_ContactPerson IS 'Name of Contact Person for Annual Report'!!
COMMENT ON COLUMN fii_FirmInstitution.fii_TelNr         IS 'Phone number of Contact Person for Annual Report'!!
COMMENT ON COLUMN fii_FirmInstitution.fii_EMail         IS 'Email address of Contact Person for Annual Report'!!
COMMENT ON COLUMN fii_FirmInstitution.fii_AnnualChk     IS 'Checkbox on Annual Report'!!
COMMENT ON COLUMN fii_FirmInstitution.fii_AnnualText    IS 'Text on Annual Report'!!
COMMIT!!

ALTER TABLE fii_FirmInstitution ALTER fii_ContactPerson POSITION 15!!
ALTER TABLE fii_FirmInstitution ALTER fii_TelNr         POSITION 16!!
ALTER TABLE fii_FirmInstitution ALTER fii_EMail         POSITION 17!!
ALTER TABLE fii_FirmInstitution ALTER fii_AnnualChk     POSITION 18!!
ALTER TABLE fii_FirmInstitution ALTER fii_AnnualText    POSITION 19!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_FiiCopyByBuy
(
  pi_SourceBuyUId     DI_UID,
  pi_TargetBuyUId     DI_UID,
  pb_IncEmpRef        DB_BOOLEAN,
  pb_IsSkipAnnual     DB_BOOLEAN,     
  pi_App_ActiveUser   DI_UID
)
AS

  -- Copy firm institutions from one bus. year to another

BEGIN
  
  INSERT INTO fii_FirmInstitution 
  ( 
    fii_BuyUId,     fii_IntUId,     fii_AbrechnungNr, fii_Code,          fii_Name,         
    fii_NameZusatz, fii_Strasse,    fii_PLZ,          fii_Ort,           fii_A1_SdtUId,    
    fii_A2_SdtUId,  fii_A3_SdtUId,  fii_A4_SdtUId,    fii_ContactPerson, fii_TelNr, 
    fii_EMail,      fii_AnnualChk,  fii_AnnualText,   fii_IstAktiv,      fii_CreateUsrUId, 
    fii_MutUsrUId,  fii_CreateDate, fii_MutDate
  )
  SELECT :pi_TargetBuyUId,  fii_IntUId,     fii_AbrechnungNr, fii_Code,     
         fii_Name,          fii_NameZusatz, fii_Strasse,      fii_PLZ,          
         fii_Ort,           
         ( 
            SELECT iTargetSdtUId FROM sp_Sdt_GetUIdOfTargetBuy( fii_A1_SdtUId, :pi_TargetBuyUId ) 
         ) AS fii_A1_SdtUId,  
         (
            SELECT iTargetSdtUId FROM sp_Sdt_GetUIdOfTargetBuy( fii_A2_SdtUId, :pi_TargetBuyUId ) 
         ) AS fii_A2_SdtUId,   
         (
            SELECT iTargetSdtUId FROM sp_Sdt_GetUIdOfTargetBuy( fii_A3_SdtUId, :pi_TargetBuyUId )
         ) AS fii_A3_SdtUId,  
         (
            SELECT iTargetSdtUId FROM sp_Sdt_GetUIdOfTargetBuy( fii_A4_SdtUId, :pi_TargetBuyUId )
         ) AS fii_A4_SdtUId,
         CASE WHEN :pb_IsSkipAnnual = 0 THEN fii_ContactPerson ELSE '' END, 
         CASE WHEN :pb_IsSkipAnnual = 0 THEN fii_TelNr         ELSE '' END, 
         CASE WHEN :pb_IsSkipAnnual = 0 THEN fii_EMail         ELSE '' END, 
         CASE WHEN :pb_IsSkipAnnual = 0 THEN fii_AnnualChk     ELSE 0  END, 
         CASE WHEN :pb_IsSkipAnnual = 0 THEN fii_AnnualText    ELSE '' END, 
         fii_IstAktiv, :pi_App_ActiveUser, :pi_App_ActiveUser, Current_TimeStamp, 
         Current_TimeStamp
    FROM fii_FirmInstitution                                   
   WHERE fii_BuyUId = :pi_SourceBuyUId                          
     AND (  
            fii_IstAktiv = 1                                    
            OR 
            ( 
              :pb_IncEmpRef = 1                                
              AND                                            
              EXISTS                                         
              (                                              
                SELECT 1                                     
                  FROM emp_Employee                          
                 WHERE emp_BuyUId = :pi_SourceBuyUId          
                   AND ( 
                         emp_AHV_FiiUId = fii_UId OR
                         emp_ALV_FiiUId = fii_UId OR
                         emp_PK_FiiUId  = fii_UId OR
                         emp_KKP_FiiUId = fii_UId OR
                         emp_KKT_FiiUId = fii_UId OR
                         emp_UNF_FiiUId = fii_UId OR
                         emp_STE_FiiUId = fii_UId OR
                         emp_ZPK_FiiUId = fii_UId
                       )
              )                                              
            )                                                
         );

END!!

COMMENT ON PROCEDURE sp_FiiCopyByBuy                   IS 'Copy firm institutions from one bus. year to another'!!
COMMENT ON PARAMETER sp_FiiCopyByBuy.pi_SourceBuyUId   IS 'Source bus. year UId'!!
COMMENT ON PARAMETER sp_FiiCopyByBuy.pi_TargetBuyUId   IS 'Target bus. year UId'!!
COMMENT ON PARAMETER sp_FiiCopyByBuy.pb_IncEmpRef      IS 'Include recs referenced by employee flag'!!
COMMENT ON PARAMETER sp_FiiCopyByBuy.pb_IsSkipAnnual   IS 'Skip annual values when copy'!!
COMMENT ON PARAMETER sp_FiiCopyByBuy.pi_App_ActiveUser IS 'Active user UId'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fii_Insert
(
   pi_fii_BuyUId        DI_UID_NN,         -- Reference to bus. year (FK:buy_UId)
   pi_fii_IntUId        DI_UID_NN,         -- Reference to institution type  (FK:int_UId)
   ps_fii_AbrechnungNr  DS_STR20_NN,       -- Statement Nr
   ps_fii_Code          DS_CODE_NN,        -- Code
   ps_fii_Name	        DS_STR50_NN,       -- Name 
   ps_fii_NameZusatz    DS_STR50,          -- Additional name
   ps_fii_Strasse       DS_STR50,          -- Address: street
   ps_fii_PLZ           DS_PLZ,            -- Address: postal code
   ps_fii_Ort           DS_STR50,          -- Address: location
   pi_fii_A1_SdtUId     DI_UID,	           -- Deduction type 1 (FK: sdt_UId)
   pi_fii_A2_SdtUId     DI_UID,	           -- Deduction type 2 (FK: sdt_UId)
   pi_fii_A3_SdtUId     DI_UID,            -- Deduction type 3 (FK: sdt_UId)	
   pi_fii_A4_SdtUId     DI_UID,            -- Deduction type 4 (FK: sdt_UId)
   ps_fii_ContactPerson DS_STR50_NN,       -- Name of Contact Person for Annual Report
   ps_fii_TelNr         DS_STR20_NN,       -- Phone number of Contact Person for Annual Report
   ps_fii_EMail         DS_STR50_NN,       -- Email address of Contact Person for Annual Report
   pb_fii_AnnualChk     DB_BOOLEAN_NN,     -- Checkbox on Annual Report
   ps_fii_AnnualText    DS_STR150_NN,      -- Text on Annual Report
   pb_fii_IstAktiv      DB_ISACTIVE_NN,    -- Active flag
   pi_app_ActiveUser    DI_UID_NN          -- Application active user id
)
RETURNS( fii_UId DI_UID_NN )
AS

  -- Add a new institution record for firm

BEGIN

  fii_UId = GEN_ID (GEN_Fii_UId,1);

  INSERT INTO fii_FirmInstitution
  (
    fii_UId,
    fii_BuyUId,
    fii_IntUId,
    fii_AbrechnungNr,
    fii_Code,
    fii_Name,
    fii_NameZusatz,
    fii_Strasse,
    fii_PLZ,
    fii_Ort,
    fii_A1_SdtUId,	
    fii_A2_SdtUId,	
    fii_A3_SdtUId,	
    fii_A4_SdtUId,
    fii_ContactPerson, 
    fii_TelNr,         
    fii_EMail,         
    fii_AnnualChk,     
    fii_AnnualText,    
    fii_IstAktiv,
    fii_CreateDate,
    fii_CreateUsrUId,
    fii_MutDate,
    fii_MutUsrUId
  )
  VALUES
  (
    :fii_UId,
    :pi_fii_BuyUId,
    :pi_fii_IntUId,
    :ps_fii_AbrechnungNr,
    :ps_fii_Code,
    :ps_fii_Name,
    :ps_fii_NameZusatz,
    :ps_fii_Strasse,
    :ps_fii_PLZ,
    :ps_fii_Ort,
    :pi_fii_A1_SdtUId,
    :pi_fii_A2_SdtUId,
    :pi_fii_A3_SdtUId,
    :pi_fii_A4_SdtUId,
    :ps_fii_ContactPerson,
    :ps_fii_TelNr,         
    :ps_fii_EMail,         
    :pb_fii_AnnualChk,     
    :ps_fii_AnnualText,    
    :pb_fii_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!


COMMENT ON PROCEDURE sp_Fii_Insert IS 'Add a new institution record for firm'!!

COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_BuyUId        IS 'Reference to bus. year (FK:buy_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_IntUId        IS 'Reference to institution type  (FK:int_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_AbrechnungNr  IS 'Statement Nr'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_Code          IS 'Code'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_Name	        IS 'Name'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_NameZusatz    IS 'Additional name'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_Strasse       IS 'Address: street'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_PLZ           IS 'Address: postal code'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_Ort           IS 'Address: location'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_A1_SdtUId	    IS 'Deduction type 1 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_A2_SdtUId	    IS 'Deduction type 2 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_A3_SdtUId	    IS 'Deduction type 3 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_fii_A4_SdtUId	    IS 'Deduction type 4 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Insert.pb_fii_IstAktiv      IS 'Active flag'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_ContactPerson IS 'Name of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_TelNr         IS 'Phone number of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_EMail         IS 'Email address of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Insert.pb_fii_AnnualChk     IS 'Checkbox on Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Insert.ps_fii_AnnualText    IS 'Text on Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Insert.pi_app_ActiveUser    IS 'Application active user id'!!
COMMENT ON PARAMETER sp_Fii_Insert.fii_UId              IS 'Output: New added institution Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fii_Update
(
   pi_fii_UId           DI_UID_NN,         -- Id of the firm institution record to be updated
   pi_fii_BuyUId        DI_UID_NN,         -- Reference to bus. year (FK:buy_UId)
   pi_fii_IntUId        DI_UID_NN,         -- Reference to institution type  (FK:int_UId)
   ps_fii_AbrechnungNr  DS_STR20_NN,       -- Statement Nr
   ps_fii_Code          DS_CODE_NN,        -- Code
   ps_fii_Name	        DS_STR50_NN,       -- Name 
   ps_fii_NameZusatz    DS_STR50,          -- Additional name
   ps_fii_Strasse       DS_STR50,          -- Address: street
   ps_fii_PLZ           DS_PLZ,            -- Address: postal code
   ps_fii_Ort           DS_STR50,          -- Address: location
   pi_fii_A1_SdtUId     DI_UID,	           -- Deduction type 1 (FK: sdt_UId)
   pi_fii_A2_SdtUId     DI_UID,	           -- Deduction type 2 (FK: sdt_UId)
   pi_fii_A3_SdtUId     DI_UID,            -- Deduction type 3 (FK: sdt_UId)	
   pi_fii_A4_SdtUId     DI_UID,            -- Deduction type 4 (FK: sdt_UId)
   ps_fii_ContactPerson DS_STR50_NN,       -- Name of Contact Person for Annual Report
   ps_fii_TelNr         DS_STR20_NN,       -- Phone number of Contact Person for Annual Report
   ps_fii_EMail         DS_STR50_NN,       -- Email address of Contact Person for Annual Report
   pb_fii_AnnualChk     DB_BOOLEAN_NN,     -- Checkbox on Annual Report
   ps_fii_AnnualText    DS_STR150_NN,      -- Text on Annual Report
   pb_fii_IstAktiv      DB_ISACTIVE_NN,    -- Active flag
   pi_app_ActiveUser    DI_UID_NN          -- Application active user id
)
AS

  -- Update a firm institution record by Id

BEGIN

  UPDATE fii_FirmInstitution
     SET fii_BuyUId        = :pi_fii_BuyUId,
         fii_IntUId        = :pi_fii_IntUId,
         fii_AbrechnungNr  = :ps_fii_AbrechnungNr,
         fii_Code          = :ps_fii_Code,
         fii_Name          = :ps_fii_Name,
         fii_NameZusatz    = :ps_fii_NameZusatz,
         fii_Strasse       = :ps_fii_Strasse,
         fii_PLZ           = :ps_fii_PLZ,
         fii_Ort           = :ps_fii_Ort,
         fii_A1_SdtUId     = :pi_fii_A1_SdtUId,
         fii_A2_SdtUId     = :pi_fii_A2_SdtUId,
         fii_A3_SdtUId     = :pi_fii_A3_SdtUId,
         fii_A4_SdtUId     = :pi_fii_A4_SdtUId,
         fii_ContactPerson = :ps_fii_ContactPerson,
         fii_TelNr         = :ps_fii_TelNr,         
         fii_EMail         = :ps_fii_EMail,         
         fii_AnnualChk     = :pb_fii_AnnualChk,     
         fii_AnnualText    = :ps_fii_AnnualText, 
         fii_IstAktiv      = :pb_Fii_IstAktiv,
         fii_MutDate       = Current_TimeStamp,
         fii_MutUsrUId     = :pi_app_ActiveUser
   WHERE fii_UId           = :pi_fii_UId;
    
END!!


COMMENT ON PROCEDURE sp_Fii_Update IS 'Update a firm institution record by Id'!!

COMMENT ON PARAMETER sp_Fii_Update.pi_fii_UId           IS 'Id of the record to be updated'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_fii_IntUId        IS 'Reference to institution type  (FK:int_UId)'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_AbrechnungNr  IS 'Statement Nr'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_Code          IS 'Code'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_Name	        IS 'Name'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_NameZusatz    IS 'Additional name'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_Strasse       IS 'Address: street'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_PLZ           IS 'Address: postal code'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_Ort           IS 'Address: location'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_fii_A1_SdtUId	    IS 'Deduction type 1 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_fii_A2_SdtUId	    IS 'Deduction type 2 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_fii_A3_SdtUId	    IS 'Deduction type 3 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_fii_A4_SdtUId	    IS 'Deduction type 4 (FK: sdt_UId)'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_ContactPerson IS 'Name of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_TelNr         IS 'Phone number of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_EMail         IS 'Email address of Contact Person for Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Update.pb_fii_AnnualChk     IS 'Checkbox on Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Update.ps_fii_AnnualText    IS 'Text on Annual Report'!!
COMMENT ON PARAMETER sp_Fii_Update.pb_fii_IstAktiv      IS 'Active flag'!!
COMMENT ON PARAMETER sp_Fii_Update.pi_app_ActiveUser    IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fii_Select
(
   pi_BuyUId        DI_UID     DEFAULT NULL,  -- Business year Id
   pi_IntUId        DI_UID     DEFAULT NULL,  -- Institution type Id
   pb_IstAktiv      DB_BOOLEAN DEFAULT NULL   -- If not null select with specific active flag only
)
RETURNS
(
  fii_UId           DI_UID,
  fii_BuyUId        DI_UID,
  fii_IntUId        DI_UID,
  fii_AbrechnungNr  DS_STR20,
  fii_Code          DS_CODE,
  fii_Name	        DS_STR50,
  fii_NameZusatz    DS_STR50,
  fii_Strasse       DS_STR50,
  fii_PLZ           DS_PLZ,
  fii_Ort           DS_STR50,
  fii_A1_SdtUId     DI_UID,	
  fii_A2_SdtUId     DI_UID,	
  fii_A3_SdtUId     DI_UID,	
  fii_A4_SdtUId     DI_UID,  
  fii_ContactPerson DS_STR50,    
  fii_TelNr         DS_STR20,    
  fii_EMail         DS_STR50,    
  fii_AnnualChk     DB_BOOLEAN,  
  fii_AnnualText    DS_STR150,   
  fii_IstAktiv      DB_ISACTIVE,
  fii_CreateDate    DD_TIMESTAMP,
  fii_CreateUsrUId  DI_UID,
  fii_MutDate       DD_TIMESTAMP,
  fii_MutUsrUId     DI_UID,
  int_Typ           DS_STR3,
  int_Bezeichnung   DS_DESCR,
  sdt_A1_Lart       DS_STR5,
  sdt_A2_Lart       DS_STR5,
  sdt_A3_Lart       DS_STR5,
  sdt_A4_Lart       DS_STR5
)
AS

  -- Select institution records 

BEGIN

  FOR
    SELECT -- Firm institution columns
           fii_UId,          fii_BuyUId,       fii_IntUId,        fii_AbrechnungNr,
           fii_Code,         fii_Name,         fii_NameZusatz,    fii_Strasse,
           fii_PLZ,          fii_Ort,          fii_A1_SdtUId,     fii_A2_SdtUId,
           fii_A3_SdtUId,    fii_A4_SdtUId,    fii_ContactPerson, fii_TelNr, 
           fii_EMail,        fii_AnnualChk,    fii_AnnualText,    fii_IstAktiv,   
           fii_CreateDate,   fii_CreateUsrUId, fii_MutDate,       fii_MutUsrUId,
           -- Institution type columns
           int_Typ, int_Bezeichnung,
           -- Deductions columns
           A1.sdt_Lart, 
           A2.sdt_Lart, 
           A3.sdt_Lart, 
           A4.sdt_Lart
      FROM fii_FirmInstitution
      LEFT JOIN int_InstitutionType        ON int_UId    = fii_IntUId
      LEFT JOIN sdt_SalaryDeductionType A1 ON A1.sdt_UId = fii_A1_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A2 ON A2.sdt_UId = fii_A2_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A3 ON A3.sdt_UId = fii_A3_SdtUId
      LEFT JOIN sdt_SalaryDeductionType A4 ON A4.sdt_UId = fii_A4_SdtUId
     WHERE ( :pi_BuyUId     IS NULL OR fii_BuyUId   = :pi_BuyUId )
       AND ( :pi_IntUId     IS NULL OR fii_IntUId   = :pi_IntUId )
       AND ( :pb_IstAktiv   IS NULL OR fii_IstAktiv = :pb_IstAktiv   )
      INTO -- Firm institution columns
           :fii_UId,          :fii_BuyUId,       :fii_IntUId,        :fii_AbrechnungNr,
           :fii_Code,         :fii_Name,         :fii_NameZusatz,    :fii_Strasse,
           :fii_PLZ,          :fii_Ort,          :fii_A1_SdtUId,     :fii_A2_SdtUId,
           :fii_A3_SdtUId,    :fii_A4_SdtUId,    :fii_ContactPerson, :fii_TelNr, 
           :fii_EMail,        :fii_AnnualChk,    :fii_AnnualText,    :fii_IstAktiv,   
           :fii_CreateDate,   :fii_CreateUsrUId, :fii_MutDate,       :fii_MutUsrUId,
           -- Institution type columns
           int_Typ, int_Bezeichnung,
           -- Deductions columns
           :sdt_A1_Lart, 
           :sdt_A2_Lart, 
           :sdt_A3_Lart,
           :sdt_A4_Lart 
  DO           
    SUSPEND;
    
END!!


COMMENT ON PROCEDURE sp_Fii_Select IS 'Select firm Institution record (possible ony one record by Id)'!!

COMMENT ON PARAMETER sp_Fii_Select.pi_BuyUId     IS 'Business year Id'!!
COMMENT ON PARAMETER sp_Fii_Select.pi_IntUId     IS 'Institution type Id'!!
COMMENT ON PARAMETER sp_Fii_Select.pb_IstAktiv   IS 'If not null select with specific active flag only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERAHV 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_AHV_FIIUID IS NOT NULL) AND (EMP_AHV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERAHV IS 'Get data for the report: Quarter \ AHV Quartalsmeldung (AHV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERALV 
(
  PI_FIIUID DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID = NULL,
  PI_CATUID DI_UID = NULL,
  PI_PRGUID DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMP_AUFENTHALT     DS_ONECHARFLAG,
  EMP_AUFENTHALT_BEZ DS_DESCR
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_ALV_FIIUID IS NOT NULL) AND (EMP_ALV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM,
               E.EMP_AUFENTHALT


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM,
              :EMP_AUFENTHALT; 

 
         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERALV IS 'Get data for the report: Quarter \ ALV Quartalsmeldung (ALV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERPK 
(
    PI_FIIUID   DI_UID,
    PI_MONATVON DI_SMLINT,
    PI_MONATBIS DI_SMLINT,
    PI_EMPUID   DI_UID = NULL,
    PI_LANDUID  DI_UID = NULL,
    PI_DEPUID   DI_UID = NULL,
    PI_CATUID   DI_UID = NULL,
    PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END


  END

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_QuarterSte
(
    pi_FiiUId       DI_UID,
    pi_MonatVon     DI_SMLINT,
    pi_MonatBis     DI_SMLINT,
    pi_EmpUId       DI_UID = null,
    pi_LandUId      DI_UID = null,
    pi_DepUId       DI_UID = null,
    pi_CatUId       DI_UID = null,
    pi_PrgUId       DI_UID = null
)
RETURNS 
(
    rpt_Gruppe          DS_STR15,
    emp_UId             DI_UID,
    prm_MonatVon        DI_SMLINT,
    prm_MonatBis        DI_SMLINT,
    lohn_Brutto         DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_SaxBez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreiBetrag       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_SaxBez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_Freibetrag       DN_NUMBER2,
    k2_Beitrag_an       DN_NUMBER2,
    k2_Beitrag_ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_SaxBez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreiBetrag       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_SaxBez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreiBetrag       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_PeidNr          DS_STR12,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    fii_ContactPerson   DS_STR50,
    fii_TelNr           DS_STR20,
    fii_EMail           DS_STR50,
    fii_AnnualChk       DB_BOOLEAN,
    fii_AnnualText      DS_STR150,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_SteuerGde       DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Aufenthalt_Bez  DS_DESCR
)
AS

  DECLARE sStmt       VARCHAR(512);
  DECLARE iBuyUId     DI_UID;
  DECLARE sIntTyp     DS_STR3;
  DECLARE iCounter    DI_SMLINT;
  DECLARE iSaxUId     DI_UID;
  DECLARE sSaxBez     DS_DESCR;
  DECLARE nFrei       DN_NUMBER2;
  DECLARE nPflicht    DN_NUMBER2;
  DECLARE nBeitragAg  DN_NUMBER2;
  DECLARE nBeitragAn  DN_NUMBER2;
  
BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.fii_BuyUId, 
         I.fii_AbrechnungNr,
         I.fii_Code,
         I.fii_Name,
         I.fii_NameZusatz,
         I.fii_Strasse,
         I.fii_Plz,
         I.fii_Ort,
         I.fii_ContactPerson,   
         I.fii_TelNr,           
         I.fii_EMail,           
         I.fii_AnnualChk,       
         I.fii_AnnualText,      
         Y.buy_Geschjahr,
         F.fir_Code,
         F.fir_PeidNr,
         F.fir_Bezeichnung,
         F.fir_Bezeichnung2,
         F.fir_Strasse,  
         F.fir_HausNr,
         F.fir_Plz,  
         F.fir_Ort,
         IT.int_Typ   
    FROM fii_FirmInstitution I
    LEFT JOIN buy_BusinessYear    Y  ON Y.buy_UId  = I.fii_BuyUId
    LEFT JOIN fir_Firm            F  ON F.fir_UId  = Y.buy_FirUId
    LEFT JOIN int_InstitutionType IT ON IT.int_UId = I.fii_IntUId       
   WHERE I.fii_UId = :pi_FiiUId
    INTO :iBuyUId,
         :fii_AbrechnungNr,
         :fii_Code,
         :fii_Name,
         :fii_NameZusatz,
         :fii_Strasse,
         :fii_Plz,
         :fii_Ort,
         :fii_ContactPerson,   
         :fii_TelNr,           
         :fii_EMail,           
         :fii_AnnualChk,       
         :fii_AnnualText, 
         :buy_Geschjahr,
         :fir_Code,
         :fir_PeidNr,
         :fir_Bezeichnung,
         :fir_Bezeichnung2,
         :fir_Strasse,  
         :fir_HausNr,
         :fir_Plz,  
         :fir_Ort,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_STE_FIIUID IS NOT NULL) AND (EMP_STE_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.emp_PersNr,
               E.emp_PeidNr,
               E.emp_Name,
               E.emp_Vorname,
               E.emp_Strasse,
               E.emp_HausNr,
               C.coi_IsoCode,
               E.emp_Plz,
               E.emp_SteuerGde,
               E.emp_Ort, 
               E.emp_GeburtsDatum, 
               E.emp_PensionDatum, 
               E.emp_Geschlecht,
               E.emp_EintrittsDatum,
               E.emp_AustrittsDatum,
               E.emp_Aufenthalt
          FROM emp_Employee E
          LEFT OUTER JOIN coi_CountryIso C ON C.coi_UId = E.emp_LandUId 
         WHERE e.emp_UId = :emp_UId
         INTO :emp_PersNr,
              :emp_PeidNr,
              :emp_Name,
              :emp_Vorname,
              :emp_Strasse,
              :emp_HausNr,
              :coi_IsoCode,
              :emp_Plz,
              :emp_SteuerGde,
              :emp_Ort, 
              :emp_GeburtsDatum, 
              :emp_PensionDatum, 
              :emp_Geschlecht,
              :emp_EintrittsDatum,
              :emp_AustrittsDatum,
              :emp_Aufenthalt;

         

         -- ReportGruppe fuer Jahresabrechnung ---
         RPT_GRUPPE = '';  
         IF (EMP_AUFENTHALT = '1') THEN BEGIN           -- wohnhaft im FL

            RPT_GRUPPE = EMP_AUFENTHALT || EMP_PLZ;


         END ELSE IF (EMP_AUFENTHALT = '2') THEN BEGIN  -- wohnhaft im CH

            RPT_GRUPPE = EMP_AUFENTHALT;


         END ELSE IF (EMP_AUFENTHALT = '3') THEN BEGIN  -- wohnhaft im AT

            RPT_GRUPPE = EMP_AUFENTHALT;

         END ELSE BEGIN                                 -- wohnhaft uebriges Ausland

            RPT_GRUPPE = '5';        

         END

         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERUNF 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE ISAXUID       DI_UID;
DECLARE VARIABLE NBEITRAGAG    DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN    DN_NUMBER2;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;




    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :LOHN_BRUTTO,:PRM_MONATVON,:PRM_MONATBIS;



     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn;


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS )
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;  

      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;


     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 0)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 3)
            AND (T.SDT_SAXUID = 13)
            AND (T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   

      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

 
      -- BU-Pflichtiger Lohn----
      K2_SAXUID   = 14;    -- (14 = BU)
      K2_PFLICHT  = nAHVLohnPfl + (nAHVLohn - nAHVLohnPfl) - (nNBULohn - nNBULohnPfl);


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 1)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))


      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      K1_SAXUID  = 13;    -- (13 = NBU)
      K1_PFLICHT = K2_PFLICHT - nAHVUnter8Std;


     --- Beitraege rechnen ----------------------------------------------------

     FOR SELECT T.SDT_SAXUID,
                SUM(D.SAD_BEITRAGAG),
                SUM(D.SAD_BEITRAGAN)

         FROM EMY_EMPLOYMENTPERIOD Y
       
         INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
         LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
         LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
               (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
               (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
               (T.SDT_SAXUID in (13,14))
         
         GROUP BY T.SDT_SAXUID

         INTO :iSAXUid,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF ( iSAXUid = 13) THEN BEGIN        -- wenn NBU

           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END      

        IF ( iSAXUid = 14) THEN BEGIN        -- wenn BU

           K2_BEITRAG_AN = nBeitragAN;      
           K2_BEITRAG_AG = nBeitragAG;

        END      

     END


     -- SAX-Bezeichung holen  
     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 13
     INTO :K1_SAXBEZ;

     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 14
     INTO :K2_SAXBEZ;


     -- Get data from Employee
     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM

      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND; 


  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERUNF IS 'Get data for the report: Quarter \ Unfall Quartalsmeldung (UNF Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALAHV 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    EMY_BESGRAD        DN_NUMBER2_NN,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    ALV_PFLICHT        DN_NUMBER2
)
AS

DECLARE VARIABLE IALVFIIUID DI_UID;
DECLARE VARIABLE NK1PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK2PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK3PLICHT  DN_NUMBER2;
DECLARE VARIABLE NK4PLICHT  DN_NUMBER2;

BEGIN

  FOR SELECT EMP_UID,
             PRM_MONATVON,
             PRM_MONATBIS,
             LOHN_BRUTTO,
             K1_SAXUID,
             K1_SAXBEZ,
             K1_PFLICHT,
             K1_FREIBETRAG,
             K1_BEITRAG_AN,
             K1_BEITRAG_AG,
             K2_SAXUID,
             K2_SAXBEZ,
             K2_PFLICHT,
             K2_FREIBETRAG,
             K2_BEITRAG_AN,
             K2_BEITRAG_AG,
             K3_SAXUID,
             K3_SAXBEZ,
             K3_PFLICHT,
             K3_FREIBETRAG,
             K3_BEITRAG_AN,
             K3_BEITRAG_AG,
             K4_SAXUID,
             K4_SAXBEZ,
             K4_PFLICHT,
             K4_FREIBETRAG,
             K4_BEITRAG_AN,
             K4_BEITRAG_AG,
             BUY_GESCHJAHR,
             FIR_CODE,
             FIR_BEZEICHNUNG,
             FIR_BEZEICHNUNG2,
             FIR_STRASSE,
             fir_HausNr,
             FIR_PLZ,
             FIR_ORT,
             FII_ABRECHNUNGNR,
             FII_CODE,
             FII_NAME,
             FII_NAMEZUSATZ,
             FII_STRASSE,
             FII_PLZ,
             FII_ORT,
             FII_CONTACTPERSON,
             FII_TELNR,
             FII_EMAIL,
             FII_ANNUALCHK,
             FII_ANNUALTEXT,
             EMP_PERSNR,
             EMP_PEIDNR,
             EMP_NAME,
             EMP_VORNAME,
             EMP_STRASSE,
             emp_HausNr,
             COI_ISOCODE,
             EMP_PLZ,
             EMP_ORT,
             EMP_GEBURTSDATUM,
             EMP_PENSIONDATUM,
             EMP_GESCHLECHT,
             EMP_EINTRITTSDATUM,
             EMP_AUSTRITTSDATUM

      FROM SP_RPT_QUARTERAHV (:PI_FIIUID,1,12,:PI_EMPUID,:PI_LANDUID,:PI_DEPUID,:PI_CATUID,:PI_PRGUID)


      INTO   :EMP_UID,
             :PRM_MONATVON,
             :PRM_MONATBIS,
             :LOHN_BRUTTO,
             :K1_SAXUID,
             :K1_SAXBEZ,
             :K1_PFLICHT,
             :K1_FREIBETRAG,
             :K1_BEITRAG_AN,
             :K1_BEITRAG_AG,
             :K2_SAXUID,
             :K2_SAXBEZ,
             :K2_PFLICHT,
             :K2_FREIBETRAG,
             :K2_BEITRAG_AN,
             :K2_BEITRAG_AG,
             :K3_SAXUID,
             :K3_SAXBEZ,
             :K3_PFLICHT,
             :K3_FREIBETRAG,
             :K3_BEITRAG_AN,
             :K3_BEITRAG_AG,
             :K4_SAXUID,
             :K4_SAXBEZ,
             :K4_PFLICHT,
             :K4_FREIBETRAG,
             :K4_BEITRAG_AN,
             :K4_BEITRAG_AG,
             :BUY_GESCHJAHR,
             :FIR_CODE,
             :FIR_BEZEICHNUNG,
             :FIR_BEZEICHNUNG2,
             :FIR_STRASSE,
             :fir_HausNr,
             :FIR_PLZ,
             :FIR_ORT,
             :FII_ABRECHNUNGNR,
             :FII_CODE,
             :FII_NAME,
             :FII_NAMEZUSATZ,
             :FII_STRASSE,
             :FII_PLZ,
             :FII_ORT,
             :FII_CONTACTPERSON,
             :FII_TELNR,
             :FII_EMAIL,
             :FII_ANNUALCHK,
             :FII_ANNUALTEXT,
             :EMP_PERSNR,
             :EMP_PEIDNR,
             :EMP_NAME,
             :EMP_VORNAME,
             :EMP_STRASSE,
             :emp_HausNr,
             :COI_ISOCODE,
             :EMP_PLZ,
             :EMP_ORT,
             :EMP_GEBURTSDATUM,
             :EMP_PENSIONDATUM,
             :EMP_GESCHLECHT,
             :EMP_EINTRITTSDATUM,
             :EMP_AUSTRITTSDATUM

  DO BEGIN


    -- Letzter BesGrad des Mitarbeiters ermitteln -- 
    EMY_BESGRAD = 0;
    FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD
        WHERE (EMY_EMPUID=:EMP_UID) AND EMY_ISUNEMPLOYED = 0
        ORDER BY EMY_PJANFANG
        INTO :EMY_BESGRAD
    DO BEGIN
       IF (EMY_BESGRAD IS NULL) THEN EMY_BESGRAD = 0;  
    END

     
    -- ALV-Pflichtige Lohnsumme des Mitarbeiters ermitteln -- 
    ALV_PFLICHT = 0;

    iALVFiiUID  = 0;
    nK1Plicht   = 0;
    nK2Plicht   = 0;
    nK3Plicht   = 0;
    nK4Plicht   = 0;

    SELECT EMP_ALV_FIIUID FROM EMP_EMPLOYEE 
       WHERE EMP_UID = :EMP_UID
    INTO :iALVFiiUID; 

     
    SELECT SUM(K1_PFLICHT),
           SUM(K2_PFLICHT),
           SUM(K3_PFLICHT),
           SUM(K4_PFLICHT) 

    FROM SP_RPT_QUARTERALV (:iALVFiiUID, 1, 12, :EMP_UID)

    INTO :nK1Plicht,
         :nK2Plicht,
         :nK3Plicht,
         :nK4Plicht;


    IF (nK1Plicht IS NULL) THEN nK1Plicht = 0; 
    IF (nK2Plicht IS NULL) THEN nK2Plicht = 0; 
    IF (nK3Plicht IS NULL) THEN nK3Plicht = 0; 
    IF (nK4Plicht IS NULL) THEN nK4Plicht = 0; 


    ALV_PFLICHT =  nK1Plicht + nK2Plicht + nK3Plicht + nK4Plicht;

    SUSPEND;         


  END 

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALALV 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    EMP_AUFENTHALT     DS_ONECHARFLAG,
    EMP_AUFENTHALT_BEZ DS_DESCR
)
AS

-- Get data for the report: Annual \ Jahresabrechnung ALV (ALV Annual)

BEGIN

  FOR SELECT EMP_UID,
             PRM_MONATVON,
             PRM_MONATBIS,       
             LOHN_BRUTTO, 
             K1_SAXUID,
             K1_SAXBEZ,
             K1_PFLICHT,
             K1_FREIBETRAG, 
             K1_BEITRAG_AN,
             K1_BEITRAG_AG,
             K2_SAXUID,
             K2_SAXBEZ,
             K2_PFLICHT,
             K2_FREIBETRAG, 
             K2_BEITRAG_AN,
             K2_BEITRAG_AG,
             K3_SAXUID,
             K3_SAXBEZ,
             K3_PFLICHT,
             K3_FREIBETRAG, 
             K3_BEITRAG_AN,
             K3_BEITRAG_AG,
             K4_SAXUID,
             K4_SAXBEZ,
             K4_PFLICHT,
             K4_FREIBETRAG, 
             K4_BEITRAG_AN,
             K4_BEITRAG_AG,
             BUY_GESCHJAHR, 
             FIR_CODE, 
             FIR_BEZEICHNUNG,
             FIR_BEZEICHNUNG2,
             FIR_STRASSE,
             fir_HausNr,
             FIR_PLZ,
             FIR_ORT,
             FII_ABRECHNUNGNR,
             FII_CODE,
             FII_NAME,
             FII_NAMEZUSATZ,
             FII_STRASSE,
             FII_PLZ,
             FII_ORT,
             FII_CONTACTPERSON,
             FII_TELNR,
             FII_EMAIL,
             FII_ANNUALCHK,
             FII_ANNUALTEXT,
             EMP_PERSNR,
             EMP_PEIDNR,
             EMP_NAME,
             EMP_VORNAME,
             EMP_STRASSE,
             emp_HausNr,
             COI_ISOCODE,
             EMP_PLZ,
             EMP_ORT,
             EMP_GEBURTSDATUM,
             EMP_PENSIONDATUM,
             EMP_GESCHLECHT,
             EMP_EINTRITTSDATUM,
             EMP_AUSTRITTSDATUM,
             EMP_AUFENTHALT,
             EMP_AUFENTHALT_BEZ


      FROM SP_RPT_QUARTERAlV (:PI_FIIUID,1,12,:PI_EMPUID,:PI_LANDUID,:PI_DEPUID,:PI_CATUID,:PI_PRGUID)
     
      ORDER BY EMP_AUFENTHALT,EMP_NAME,EMP_VORNAME
       
        into :EMP_UID,
             :PRM_MONATVON,
             :PRM_MONATBIS,       
             :LOHN_BRUTTO, 
             :K1_SAXUID,
             :K1_SAXBEZ,
             :K1_PFLICHT,
             :K1_FREIBETRAG, 
             :K1_BEITRAG_AN,
             :K1_BEITRAG_AG,
             :K2_SAXUID,
             :K2_SAXBEZ,
             :K2_PFLICHT,
             :K2_FREIBETRAG, 
             :K2_BEITRAG_AN,
             :K2_BEITRAG_AG,
             :K3_SAXUID,
             :K3_SAXBEZ,
             :K3_PFLICHT,
             :K3_FREIBETRAG, 
             :K3_BEITRAG_AN,
             :K3_BEITRAG_AG,
             :K4_SAXUID,
             :K4_SAXBEZ,
             :K4_PFLICHT,
             :K4_FREIBETRAG, 
             :K4_BEITRAG_AN,
             :K4_BEITRAG_AG,
             :BUY_GESCHJAHR, 
             :FIR_CODE, 
             :FIR_BEZEICHNUNG,
             :FIR_BEZEICHNUNG2,
             :FIR_STRASSE,
             :fir_HausNr,
             :FIR_PLZ,
             :FIR_ORT,
             :FII_ABRECHNUNGNR,
             :FII_CODE,
             :FII_NAME,
             :FII_NAMEZUSATZ,
             :FII_STRASSE,
             :FII_PLZ,
             :FII_ORT,
             :FII_CONTACTPERSON,
             :FII_TELNR,
             :FII_EMAIL,
             :FII_ANNUALCHK,
             :FII_ANNUALTEXT,
             :EMP_PERSNR,
             :EMP_PEIDNR,
             :EMP_NAME,
             :EMP_VORNAME,
             :EMP_STRASSE,
             :emp_HausNr,
             :COI_ISOCODE,
             :EMP_PLZ,
             :EMP_ORT,
             :EMP_GEBURTSDATUM,
             :EMP_PENSIONDATUM,
             :EMP_GESCHLECHT,
             :EMP_EINTRITTSDATUM,
             :EMP_AUSTRITTSDATUM,
             :EMP_AUFENTHALT,
             :EMP_AUFENTHALT_BEZ

  DO BEGIN


     SUSPEND;
     

  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL)
RETURNS 
(
  EMP_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18) THEN BEGIN                    -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19) THEN BEGIN           -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 )

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALKK IS'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALPK
(
  PI_FIIUID DI_UID,
  PI_EMPUID DI_UID  = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID  = NULL,
  PI_CATUID DI_UID  = NULL,
  PI_PRGUID DI_UID  = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  EMY_UID            DI_UID,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  EMY_ISUNEMPLOYED   DB_BOOLEAN,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IEMY_UID   DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( T.SDT_EXCLUDESALARYCALC = 0     )
             AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALPK IS 'Get data for the report: Annual \ Jahresabrechnung PK (PK Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_AnnualSte
(
    pi_FiiUId     DI_UID,
    pi_EmpUId     DI_UID = NULL,
    pi_LandUId    DI_UID = NULL,
    pi_DepUId     DI_UID = NULL,
    pi_CatUId     DI_UID = NULL,
    pi_PrgUId     DI_UID = NULL
)
RETURNS 
(
    rpt_Gruppe          DS_STR15,
    emp_UId             DI_UID,
    prm_MonatVon        DI_SMLINT,
    prm_MonatBis        DI_SMLINT,
    lohn_Brutto         DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_Saxbez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreibetrAg       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_Saxbez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_FreibetrAg       DN_NUMBER2,
    k2_Beitrag_An       DN_NUMBER2,
    k2_Beitrag_Ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_Saxbez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreibetrAg       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_Saxbez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreibetrAg       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_PeidNr          DS_STR12,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fir_CoiUId          DI_UID,
    fir_CoiCode         DS_CODE,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    fii_ContactPerson   DS_STR50,
    fii_TelNr           DS_STR20,
    fii_EMail           DS_STR50,
    fii_AnnualChk       DB_BOOLEAN,
    fii_AnnualText      DS_STR150,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_SteuerGde       DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Aufenthalt_Bez  DS_DESCR
)
AS
  
  -- Get data for the report: Annual \ Jahresabrechnung STE (STE Annual)
  
  DECLARE sgruppe DS_STR15;
  
BEGIN

  --- Firmensitz ermitteln und fuer Report zurueckgeben ---

  SELECT F.fir_CoiUId, C.coi_IsoCode 
    FROM fii_FirmInstitution I
    LEFT JOIN buy_BusinessYear Y      ON Y.buy_UId = I.fii_BuyUId
    LEFT JOIN fir_Firm F              ON F.fir_UId = Y.buy_FirUId
    LEFT OUTER JOIN coi_CountryIso C  ON C.coi_UId = F.fir_CoiUId
   WHERE I.fii_UId = :pi_FiiUId
    INTO :fir_CoiUId, :fir_CoiCode;


  FOR 
    SELECT rpt_Gruppe,
           emp_UId,
           prm_MonatVon,
           prm_MonatBis,
           lohn_Brutto,
           k1_SaxUId,
           k1_Saxbez,
           k1_Pflicht,
           k1_FreibetrAg,
           k1_Beitrag_An,
           k1_Beitrag_Ag,
           k2_SaxUId,
           k2_Saxbez,
           k2_Pflicht,
           k2_FreibetrAg,
           k2_Beitrag_An,
           k2_Beitrag_Ag,
           k3_SaxUId,
           k3_Saxbez,
           k3_Pflicht,
           k3_FreibetrAg,
           k3_Beitrag_An,
           k3_Beitrag_Ag,
           k4_SaxUId,
           k4_Saxbez,
           k4_Pflicht,
           k4_FreibetrAg,
           k4_Beitrag_An,
           k4_Beitrag_Ag,
           buy_Geschjahr,
           fir_Code,
           fir_PeidNr,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Plz,
           fir_Ort,
           fii_Abrechnungnr,
           fii_Code,
           fii_Name,
           fii_NameZusatz,
           fii_Strasse,
           fii_Plz,
           fii_Ort,
           fii_ContactPerson, 
           fii_TelNr,  
           fii_EMail,          
           fii_AnnualChk,       
           fii_AnnualText,      
           emp_PersNr,
           emp_PeidNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           coi_IsoCode,
           emp_Plz,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Aufenthalt,
           emp_Aufenthalt_Bez
           
      FROM sp_Rpt_QuarterSte
           ( 
            :pi_FiiUId,   1,          12,         :pi_EmpUId, 
            :pi_LandUId, :pi_DepUId,  :pi_CatUId, :pi_PrgUId
           )     
     ORDER BY rpt_Gruppe, emp_Name, emp_Vorname
      INTO :rpt_Gruppe,
           :emp_UId,
           :prm_MonatVon,
           :prm_MonatBis,
           :lohn_Brutto,
           :k1_SaxUId,
           :k1_Saxbez,
           :k1_Pflicht,
           :k1_FreibetrAg,
           :k1_Beitrag_An,
           :k1_Beitrag_Ag,
           :k2_SaxUId,
           :k2_Saxbez,
           :k2_Pflicht,
           :k2_FreibetrAg,
           :k2_Beitrag_An,
           :k2_Beitrag_Ag,
           :k3_SaxUId,
           :k3_Saxbez,
           :k3_Pflicht,
           :k3_FreibetrAg,
           :k3_Beitrag_An,
           :k3_Beitrag_Ag,
           :k4_SaxUId,
           :k4_Saxbez,
           :k4_Pflicht,
           :k4_FreibetrAg,
           :k4_Beitrag_An,
           :k4_Beitrag_Ag,
           :buy_Geschjahr,
           :fir_Code,
           :fir_PeidNr,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Plz,
           :fir_Ort,
           :fii_AbrechnungNr,
           :fii_Code,
           :fii_Name,
           :fii_NameZusatz,
           :fii_Strasse,
           :fii_Plz,
           :fii_Ort,
           :fii_ContactPerson, 
           :fii_TelNr,  
           :fii_EMail,          
           :fii_AnnualChk,       
           :fii_AnnualText, 
           :emp_PersNr,
           :emp_PeidNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :coi_IsoCode,
           :emp_Plz,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Aufenthalt,
           :emp_Aufenthalt_Bez
  
  DO       
    SUSPEND;  

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALUNF 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    AHV_LOHN           DN_NUMBER2,
    AHV_LOHN_NP        DN_NUMBER2,
    AHV_LOHN_US        DN_NUMBER2,
    BU_LOHN            DN_NUMBER2,
    STD8_LOHN          DN_NUMBER2,
    NBU_LOHN           DN_NUMBER2,
    BEITRAG_BU         DN_NUMBER2,
    BEITRAG_NBU        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     AHV_LOHN    = 0;
     AHV_LOHN_NP = 0;
     AHV_LOHN_US = 0;
     BU_LOHN     = 0;
     STD8_LOHN   = 0;
     NBU_LOHN    = 0;
     BEITRAG_BU  = 0;
     BEITRAG_NBU = 0;

     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn ;   


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;   


      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;

      AHV_LOHN    = nAHVLohnPfl;
      AHV_LOHN_NP = nAHVLohn - nAHVLohnPfl;



     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 13)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   


      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

      AHV_LOHN_US = nNBULohn - nNBULohnPfl;
      
 
      -- BU-Pflichtiger Lohn----
      BU_LOHN     = AHV_LOHN + AHV_LOHN_NP - AHV_LOHN_US;


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 1)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))


      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      STD8_LOHN = nAHVUnter8Std;

      NBU_LOHN  = BU_LOHN - nAHVUnter8Std;


     -- Beitraege AG und AN rechnen ----

     SELECT SUM(D.SAD_BEITRAGAG),
            SUM(D.SAD_BEITRAGAN)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
            (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
            (T.SDT_SAXUID in (13,14))

     INTO :BEITRAG_BU,
          :BEITRAG_NBU;


     -- Personalien des MA's ----

      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C.COI_ISOCODE,
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             E.EMP_GESCHLECHT,
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM


       FROM EMP_EMPLOYEE E

       LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

       WHERE E.EMP_UID = :EMP_UID

       INTO :EMP_PERSNR,
            :EMP_PEIDNR,
            :EMP_NAME,
            :EMP_VORNAME,
            :EMP_STRASSE,
            :emp_HausNr,
            :COI_ISOCODE,
            :EMP_PLZ,
            :EMP_ORT, 
            :EMP_GEBURTSDATUM, 
            :EMP_PENSIONDATUM, 
            :EMP_GESCHLECHT,
            :EMP_EINTRITTSDATUM,
            :EMP_AUSTRITTSDATUM;


      SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALUNF IS 'Get data for the report: Annual \ Jahresabrechnung UNF (UNF Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_AnnualZPK
(
    PI_FIIUID   DI_UID,
    PI_EMPUID   DI_UID = NULL,
    PI_LANDUID  DI_UID = NULL,
    PI_DEPUID   DI_UID = NULL,
    PI_CATUID   DI_UID = NULL,
    PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    EMY_UID            DI_UID,
    EMY_PJANFANG       DD_DATE,
    EMY_PJENDE         DD_DATE,
    EMY_BESGRAD        DN_NUMBER2,
    LOHN_BRUTTO        DN_NUMBER2,
    BEITRAG_AN         DN_NUMBER2,
    BEITRAG_AG         DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS
-- Get data for the report: Annual \ Jahresabrechnung ZPK (ZPK Annual)

   DECLARE VARIABLE SSTMT VARCHAR(512);
   DECLARE VARIABLE IBUYUID DI_UID;
   DECLARE VARIABLE SINTTYP DS_STR3;
   DECLARE VARIABLE ICOUNTER DI_INT;


BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;



  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_ZPK_FIIUID IS NOT NULL) AND (EMP_ZPK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN


   
     FOR SELECT EMY_UID, 
                EMY_PJANFANG, 
                EMY_PJENDE,
                EMY_BESGRAD  

         FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG

         INTO :EMY_UID,
               EMY_PJANFANG, 
               EMY_PJENDE,
               EMY_BESGRAD  


     DO BEGIN


       -- Bruttolohn fuer Periode rechnen  ---------------------------------------------------------   
       SELECT SUM(D.SAD_TOTAL) 

          FROM EMY_EMPLOYMENTPERIOD Y   

          INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
          INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
          LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
          LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
          LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_UID=:EMY_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

       INTO :LOHN_BRUTTO;   


       --  Beitraege rechnen ------------------------------
       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

         FROM EMY_EMPLOYMENTPERIOD Y
 
         INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
         LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
         LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (Y.EMY_UID=:EMY_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_TYP = 'A')  AND (TI.INT_TYP=:sIntTyp)

       INTO :BEITRAG_AG,
            :BEITRAG_AN;


        -- Get data from Employee
       SELECT E.EMP_PERSNR,
              E.EMP_PEIDNR,
              E.EMP_NAME,
              E.EMP_VORNAME,
              E.EMP_STRASSE,
              E.emp_HausNr,
              C.COI_ISOCODE,
              E.EMP_PLZ,
              E.EMP_ORT, 
              E.EMP_GEBURTSDATUM, 
              E.EMP_PENSIONDATUM, 
              E.EMP_GESCHLECHT,
              E.EMP_EINTRITTSDATUM,
              E.EMP_AUSTRITTSDATUM


        FROM EMP_EMPLOYEE E

        LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
        WHERE E.EMP_UID = :EMP_UID

        INTO :EMP_PERSNR,
             :EMP_PEIDNR,
             :EMP_NAME,
             :EMP_VORNAME,
             :EMP_STRASSE,
             :emp_HausNr,
             :COI_ISOCODE,
             :EMP_PLZ,
             :EMP_ORT, 
             :EMP_GEBURTSDATUM, 
             :EMP_PENSIONDATUM, 
             :EMP_GESCHLECHT,
             :EMP_EINTRITTSDATUM,
             :EMP_AUSTRITTSDATUM;

        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE sp_Rpt_AnnualZPK IS 'Get data for the report: Annual \ Jahresabrechnung ZPK (ZPK Annual)'!!

COMMENT ON PARAMETER sp_Rpt_AnnualZPK.pi_EmpUId    IS 'Employee Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualZPK.pi_LandUId   IS 'Employee country Id (address, emp_LandUId)'!!
COMMENT ON PARAMETER sp_Rpt_AnnualZPK.pi_DepUId    IS 'Department Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualZPK.pi_CatUId    IS 'Category Id'!!
COMMENT ON PARAMETER sp_Rpt_AnnualZPK.pi_PrgUId    IS 'Payroll group Id'!!

COMMIT!!

-- FS#1047:END


-- +++
-- FS#1053 - PKLohn - Option for edit description in closed accountings

EXECUTE BLOCK
AS
BEGIN

  IF ( NOT EXISTS
           ( 
              SELECT par_UId 
                FROM par_Parameter 
               WHERE par_Code = 'ALLOW_EDIT_TEXT_IN_CLOSED'
           ) 
     ) 
  THEN
  BEGIN
    
    INSERT INTO par_Parameter 
    (
      par_MastUId,    par_MastPrefix,   par_Code,    par_Bezeich,  par_Typ, par_Val,
      par_CreateDate, par_CreateUsrUId, par_MutDate, par_MutUsrUId
    )
    VALUES (
      0, 'APP', 'ALLOW_EDIT_TEXT_IN_CLOSED', 'Allow or not edit text on closed payroll', 1, '0',
      Current_Timestamp, 1, Current_Timestamp, 1
    );
    
  END

END!!
COMMIT!!  
  
-- FS#1053:END
-- +++

-- +++
-- FS#1060 - PKLohn - NotRepeat option for PayrollMonths

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', ' fir_LA_NameTauschen', 'DB_BOOLEAN_NN DEFAULT 0' )!!
COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_LA_NameTauschen IS 'Flag, swap position of firstname and lastname on Lohnabrechnung report'!!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_LA_NameTauschen POSITION 26!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_LA_UseOwnTemplate   DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_LA_NameTauschen     DB_BOOLEAN,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp      DS_ONECHARFLAG,
    fir_EMailMode           DI_INT,
    fir_EMailSenderAddress  DS_STR128,
    fir_EMailSenderName     DS_STR128,
    fir_EMailSubject        DS_STR255,
    fir_EMailHost           DS_STR128,
    fir_EMailPort           DI_INT,   
    fir_EMailTLS            DI_INT,   
    fir_EMailUser           DS_STR50, 
    fir_EMailPassword       DS_STR255,
    fir_EMailText           DS_STR1024,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_LA_NameTauschen,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,   
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_LA_NameTauschen,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,   
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!


COMMENT ON PROCEDURE sp_Fir_Select IS 'Select Firm(s) data'!!

COMMENT ON PARAMETER sp_Fir_Select.pi_fir_UId  IS 'Id of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.ps_fir_Code IS 'Code of the Firm to be selected'!!
COMMENT ON PARAMETER sp_Fir_Select.pb_IstAktiv IS 'If not null select with specific active flag only'!!

COMMIT!!

-- FS#1060:END
-- +++


-- +++
-- FS#1073 - PKLohn - Improve logic for Quarter Report procedures

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERAHV 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_AHV_FIIUID IS NOT NULL) AND (EMP_AHV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERAHV IS 'Get data for the report: Quarter \ AHV Quartalsmeldung (AHV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERALV 
(
  PI_FIIUID DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID = NULL,
  PI_CATUID DI_UID = NULL,
  PI_PRGUID DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMP_AUFENTHALT     DS_ONECHARFLAG,
  EMP_AUFENTHALT_BEZ DS_DESCR
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_ALV_FIIUID IS NOT NULL) AND (EMP_ALV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM,
               E.EMP_AUFENTHALT


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM,
              :EMP_AUFENTHALT; 

 
         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERALV IS 'Get data for the report: Quarter \ ALV Quartalsmeldung (ALV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERPK 
(
    PI_FIIUID   DI_UID,
    PI_MONATVON DI_SMLINT,
    PI_MONATBIS DI_SMLINT,
    PI_EMPUID   DI_UID = NULL,
    PI_LANDUID  DI_UID = NULL,
    PI_DEPUID   DI_UID = NULL,
    PI_CATUID   DI_UID = NULL,
    PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    fir_HausNr         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    FII_CONTACTPERSON  DS_STR50,
    FII_TELNR          DS_STR20,
    FII_EMAIL          DS_STR50,
    FII_ANNUALCHK      DB_BOOLEAN,
    FII_ANNUALTEXT     DS_STR150,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    emp_HausNr         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END


  END

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_QuarterSte
(
    pi_FiiUId       DI_UID,
    pi_MonatVon     DI_SMLINT,
    pi_MonatBis     DI_SMLINT,
    pi_EmpUId       DI_UID = null,
    pi_LandUId      DI_UID = null,
    pi_DepUId       DI_UID = null,
    pi_CatUId       DI_UID = null,
    pi_PrgUId       DI_UID = null
)
RETURNS 
(
    rpt_Gruppe          DS_STR15,
    emp_UId             DI_UID,
    prm_MonatVon        DI_SMLINT,
    prm_MonatBis        DI_SMLINT,
    lohn_Brutto         DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_SaxBez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreiBetrag       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_SaxBez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_Freibetrag       DN_NUMBER2,
    k2_Beitrag_an       DN_NUMBER2,
    k2_Beitrag_ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_SaxBez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreiBetrag       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_SaxBez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreiBetrag       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_PeidNr          DS_STR12,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    fii_ContactPerson   DS_STR50,
    fii_TelNr           DS_STR20,
    fii_EMail           DS_STR50,
    fii_AnnualChk       DB_BOOLEAN,
    fii_AnnualText      DS_STR150,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_SteuerGde       DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Aufenthalt_Bez  DS_DESCR
)
AS

  DECLARE sStmt       VARCHAR(512);
  DECLARE iBuyUId     DI_UID;
  DECLARE sIntTyp     DS_STR3;
  DECLARE iCounter    DI_SMLINT;
  DECLARE iSaxUId     DI_UID;
  DECLARE sSaxBez     DS_DESCR;
  DECLARE nFrei       DN_NUMBER2;
  DECLARE nPflicht    DN_NUMBER2;
  DECLARE nBeitragAg  DN_NUMBER2;
  DECLARE nBeitragAn  DN_NUMBER2;
  
BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.fii_BuyUId, 
         I.fii_AbrechnungNr,
         I.fii_Code,
         I.fii_Name,
         I.fii_NameZusatz,
         I.fii_Strasse,
         I.fii_Plz,
         I.fii_Ort,
         I.fii_ContactPerson,   
         I.fii_TelNr,           
         I.fii_EMail,           
         I.fii_AnnualChk,       
         I.fii_AnnualText,      
         Y.buy_Geschjahr,
         F.fir_Code,
         F.fir_PeidNr,
         F.fir_Bezeichnung,
         F.fir_Bezeichnung2,
         F.fir_Strasse,  
         F.fir_HausNr,
         F.fir_Plz,  
         F.fir_Ort,
         IT.int_Typ   
    FROM fii_FirmInstitution I
    LEFT JOIN buy_BusinessYear    Y  ON Y.buy_UId  = I.fii_BuyUId
    LEFT JOIN fir_Firm            F  ON F.fir_UId  = Y.buy_FirUId
    LEFT JOIN int_InstitutionType IT ON IT.int_UId = I.fii_IntUId       
   WHERE I.fii_UId = :pi_FiiUId
    INTO :iBuyUId,
         :fii_AbrechnungNr,
         :fii_Code,
         :fii_Name,
         :fii_NameZusatz,
         :fii_Strasse,
         :fii_Plz,
         :fii_Ort,
         :fii_ContactPerson,   
         :fii_TelNr,           
         :fii_EMail,           
         :fii_AnnualChk,       
         :fii_AnnualText, 
         :buy_Geschjahr,
         :fir_Code,
         :fir_PeidNr,
         :fir_Bezeichnung,
         :fir_Bezeichnung2,
         :fir_Strasse,  
         :fir_HausNr,
         :fir_Plz,  
         :fir_Ort,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_STE_FIIUID IS NOT NULL) AND (EMP_STE_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
          FROM SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )
         WHERE MONATVON IS NOT NULL
         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAG;
           K1_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAG;
           K2_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAG;
           K3_BEITRAG_AG = nBeitragAN;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAG;
           K4_BEITRAG_AG = nBeitragAN;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.emp_PersNr,
               E.emp_PeidNr,
               E.emp_Name,
               E.emp_Vorname,
               E.emp_Strasse,
               E.emp_HausNr,
               C.coi_IsoCode,
               E.emp_Plz,
               E.emp_SteuerGde,
               E.emp_Ort, 
               E.emp_GeburtsDatum, 
               E.emp_PensionDatum, 
               E.emp_Geschlecht,
               E.emp_EintrittsDatum,
               E.emp_AustrittsDatum,
               E.emp_Aufenthalt
          FROM emp_Employee E
          LEFT OUTER JOIN coi_CountryIso C ON C.coi_UId = E.emp_LandUId 
         WHERE e.emp_UId = :emp_UId
         INTO :emp_PersNr,
              :emp_PeidNr,
              :emp_Name,
              :emp_Vorname,
              :emp_Strasse,
              :emp_HausNr,
              :coi_IsoCode,
              :emp_Plz,
              :emp_SteuerGde,
              :emp_Ort, 
              :emp_GeburtsDatum, 
              :emp_PensionDatum, 
              :emp_Geschlecht,
              :emp_EintrittsDatum,
              :emp_AustrittsDatum,
              :emp_Aufenthalt;

         

         -- ReportGruppe fuer Jahresabrechnung ---
         RPT_GRUPPE = '';  
         IF (EMP_AUFENTHALT = '1') THEN BEGIN           -- wohnhaft im FL

            RPT_GRUPPE = EMP_AUFENTHALT || EMP_PLZ;


         END ELSE IF (EMP_AUFENTHALT = '2') THEN BEGIN  -- wohnhaft im CH

            RPT_GRUPPE = EMP_AUFENTHALT;


         END ELSE IF (EMP_AUFENTHALT = '3') THEN BEGIN  -- wohnhaft im AT

            RPT_GRUPPE = EMP_AUFENTHALT;

         END ELSE BEGIN                                 -- wohnhaft uebriges Ausland

            RPT_GRUPPE = '5';        

         END

         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMIT!!

-- FS#1073:END


-- +++
-- FS#1074 - PKLohn - Improve logic for Quarter Report procedures

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL)
RETURNS 
(
  EMP_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  FII_CONTACTPERSON  DS_STR50,
  FII_TELNR          DS_STR20,
  FII_EMAIL          DS_STR50,
  FII_ANNUALCHK      DB_BOOLEAN,
  FII_ANNUALTEXT     DS_STR150,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IPF_INTUID DI_UID;
DECLARE VARIABLE ITG_INTUID DI_UID;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         I.FII_CONTACTPERSON,
         I.FII_TELNR,
         I.FII_EMAIL,
         I.FII_ANNUALCHK,
         I.FII_ANNUALTEXT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :FII_CONTACTPERSON,
         :FII_TELNR,
         :FII_EMAIL,
         :FII_ANNUALCHK,
         :FII_ANNUALTEXT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN
  
    -- Check if Employee has KKP or KKT from this FII
     IPF_INTUID = 0;
     ITG_INTUID = 0;

     SELECT EMP_KKP_FIIUID,
            EMP_KKT_FIIUID
     FROM   EMP_EMPLOYEE
     WHERE  (EMP_UID = :EMP_UID)
     INTO   :IPF_INTUID,
            :ITG_INTUID;

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18 AND ITG_INTUID = :pi_FiiUId) THEN BEGIN -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19 AND IPF_INTUID = :pi_FiiUId) THEN BEGIN -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 )

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALKK IS'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMIT!!

-- FS#1074:END

SET TERM ;!!