﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.18
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;    

-- +++
-- FS#977:START - PKLohn - Improve reporting for Institutions
-- FS#982:START - PKLohn - Individual Lohnabrechnung report doesn’t work

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', ' fir_ISO_AnzeigeTyp', 'DS_ONECHARFLAG_NN DEFAULT ''2''' )!!
COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_ISO_AnzeigeTyp IS 'ISO20022 Anzeigetyp'!!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_ISO_AnzeigeTyp POSITION 32!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', ' fir_LA_UseOwnTemplate', 'DB_BOOLEAN_NN DEFAULT 0' )!!
COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_LA_UseOwnTemplate IS 'Use individual Lohnabrechnung template'!!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_LA_UseOwnTemplate POSITION 22!!
COMMIT!!

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_LA_UseOwnTemplate   DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_ISO_AnzeigeTyp      DS_ONECHARFLAG,
    fir_EMailMode           DI_INT,
    fir_EMailSenderAddress  DS_STR128,
    fir_EMailSenderName     DS_STR128,
    fir_EMailSubject        DS_STR255,
    fir_EMailHost           DS_STR128,
    fir_EMailPort           DI_INT,   
    fir_EMailTLS            DI_INT,   
    fir_EMailUser           DS_STR50, 
    fir_EMailPassword       DS_STR255,
    fir_EMailText           DS_STR1024,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_UseOwnTemplate,
           fir_LA_ReportTemplate,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_ISO_AnzeigeTyp,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,   
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_UseOwnTemplate,
           :fir_LA_ReportTemplate,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_ISO_AnzeigeTyp,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,   
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!

COMMIT!!

-- FS#977:END
-- FS#982:END


-- +++
-- FS#981:START - PKLohn - Improvement in SP_RPT_ANNUALXX

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL)
RETURNS 
(
  EMP_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18) THEN BEGIN                    -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19) THEN BEGIN           -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 )

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALKK IS'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure  'SP_RPT_ANNUALPK'!!

COMMIT!!

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALPK
(
  PI_FIIUID DI_UID,
  PI_EMPUID DI_UID  = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID  = NULL,
  PI_CATUID DI_UID  = NULL,
  PI_PRGUID DI_UID  = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  EMY_UID            DI_UID,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  EMY_ISUNEMPLOYED   DB_BOOLEAN,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IEMY_UID   DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( T.SDT_EXCLUDESALARYCALC = 0     )
             AND ( SAD_BEITRAGAG <> 0 OR SAD_BEITRAGAN <> 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALPK IS 'Get data for the report: Annual \ Jahresabrechnung PK (PK Annual)'!!

COMMIT!!

-- FS#981:END
       
SET TERM ;!!
