﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.17
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#934/FS#942:START - PKLohn - Improve reporting for Institutions

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'sdt_SalaryDeductionType', ' sdt_ExcludeSalaryCalc', 'DB_BOOLEAN_NN DEFAULT 0' )!!
COMMIT!!

COMMENT ON COLUMN sdt_SalaryDeductionType.sdt_ExcludeSalaryCalc IS 'Abzugsart bei Basis-Kalkulation in Reports ignorieren'!!
COMMIT!!

ALTER TABLE sdt_SalaryDeductionType ALTER sdt_ExcludeSalaryCalc POSITION 96!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'sdt_SalaryDeductionType', ' sdt_IgnoreSparenCalc', 'DB_BOOLEAN_NN DEFAULT 0' )!!
COMMIT!!

COMMENT ON COLUMN sdt_SalaryDeductionType.sdt_IgnoreSparenCalc IS 'Übergangskalkulation für PK-Sparen ignorieren'!!
COMMIT!!

ALTER TABLE sdt_SalaryDeductionType ALTER sdt_IgnoreSparenCalc POSITION 97!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sdt_Insert
(
    pi_sdt_BuyUId                 DI_UID_NN,
    ps_sdt_Typ                    DS_ONECHARFLAG_NN,
    ps_sdt_LArt                   DS_STR5_NN,
    ps_sdt_Bezeichnung            DS_DESCR_NN,
    ps_sdt_Text                   DS_DESCR_NN,
    ps_sdt_TextLohnAusweis        DS_STR30,
    pi_sdt_SortNr                 DI_SMLINT_NN,
    pi_sdt_SaxUId                 DI_UID_NN,
    pi_sdt_IntUId                 DI_UID,
    pi_sdt_A_SalUId               DI_UID,
    pi_sdt_C_SalUId               DI_UID,
    pi_sdt_Z_SalUId               DI_UID,
    pi_sdt_Soll_AcnUId            DI_UID,
    pi_sdt_Haben_AcnUId           DI_UID,
    pb_sdt_IstNullAusgabe         DB_BOOLEAN_NN,
    pb_sdt_IstBearbeitbar         DB_BOOLEAN_NN,
    ps_sdt_Kommentar              DS_STR255,
    pi_sdt_SctUId                 DI_UID_NN,
    pi_sdt_BerechBasisNr          DI_SMLINT_NN,
    pb_sdt_IstLohnTeil            DB_BOOLEAN_NN,
    pb_sdt_IstVariabel            DB_BOOLEAN_NN,
    pb_sdt_IstAutoBerechnung      DB_BOOLEAN_NN,
    pi_sdt_Lart_sdtUid            DI_UID,
    ps_sdt_InsInAbreTyp           DS_ONECHARFLAG_NN,
    pn_sdt_MinLohn                DN_AMOUNT,
    pn_sdt_MaxLohn                DN_AMOUNT,
    pn_sdt_Freibetrag             DN_AMOUNT,
    pn_sdt_MinPflichtLohn         DN_AMOUNT,
    pn_sdt_MaxPflichtLohn         DN_AMOUNT,
    pb_sdt_IstBesGradMin          DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMax          DB_BOOLEAN_NN,
    pb_sdt_IstBesGradFrei         DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMinPfl       DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMaxPfl       DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMin           DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMax           DB_BOOLEAN_NN,
    pb_sdt_IstIVGradFrei          DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMinPfl        DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMaxPfl        DB_BOOLEAN_NN,
    ps_sdt_StdAbreTyp             DS_ONECHARFLAG_NN,
    pb_sdt_IstLehrlingFrei        DB_BOOLEAN_NN,
    pb_sdt_Ist8StdFrei            DB_BOOLEAN_NN,
    ps_sdt_Masseinheit            DS_STR10,
    pb_sdt_IstZivilStand          DB_BOOLEAN_NN,
    pb_sdt_IstAbJahresLohn        DB_BOOLEAN_NN,
    ps_sdt_BerArtAbAlter          DS_ONECHARFLAG_NN,
    ps_sdt_BerArtBisAlter         DS_ONECHARFLAG_NN,
    pi_sdt_BisAlter1              DI_SMLINT,
    pi_sdt_BisAlter2              DI_SMLINT,
    pi_sdt_Ab1_1                  DI_INT,
    pi_sdt_Ab1_2                  DI_INT,
    pi_sdt_Ab1_3                  DI_INT,
    pi_sdt_Ab1_4                  DI_INT,
    pi_sdt_Ab1_5                  DI_INT,
    pi_sdt_Ab2_1                  DI_INT,
    pi_sdt_Ab2_2                  DI_INT,
    pi_sdt_Ab2_3                  DI_INT,
    pi_sdt_Ab2_4                  DI_INT,
    pi_sdt_Ab2_5                  DI_INT,
    pn_sdt_Sa1_Anteil1            DN_AMOUNT,
    pn_sdt_Sa1_Anteil2            DN_AMOUNT,
    pn_sdt_Sa1_Anteil3            DN_AMOUNT,
    pn_sdt_Sa1_Anteil4            DN_AMOUNT,
    pn_sdt_Sa1_Anteil5            DN_AMOUNT,
    pn_sdt_Sa2_Anteil1            DN_AMOUNT,
    pn_sdt_Sa2_Anteil2            DN_AMOUNT,
    pn_sdt_Sa2_Anteil3            DN_AMOUNT,
    pn_sdt_Sa2_Anteil4            DN_AMOUNT,
    pn_sdt_Sa2_Anteil5            DN_AMOUNT,
    pn_sdt_Sb1_Anteil1            DN_AMOUNT,
    pn_sdt_Sb1_Anteil2            DN_AMOUNT,
    pn_sdt_Sb1_Anteil3            DN_AMOUNT,
    pn_sdt_Sb1_Anteil4            DN_AMOUNT,
    pn_sdt_Sb1_Anteil5            DN_AMOUNT,
    pn_sdt_Sb2_Anteil1            DN_AMOUNT,
    pn_sdt_Sb2_Anteil2            DN_AMOUNT,
    pn_sdt_Sb2_Anteil3            DN_AMOUNT,
    pn_sdt_Sb2_Anteil4            DN_AMOUNT,
    pn_sdt_Sb2_Anteil5            DN_AMOUNT,
    pb_sdt_Basis1                 DB_BOOLEAN_NN,
    pb_sdt_Basis2                 DB_BOOLEAN_NN,
    pb_sdt_Basis3                 DB_BOOLEAN_NN,
    pb_sdt_Basis4                 DB_BOOLEAN_NN,
    pb_sdt_Basis5                 DB_BOOLEAN_NN,
    pb_sdt_Basis6                 DB_BOOLEAN_NN,
    pb_sdt_Basis7                 DB_BOOLEAN_NN,
    pb_sdt_Basis8                 DB_BOOLEAN_NN,
    pb_sdt_Basis9                 DB_BOOLEAN_NN,
    pb_sdt_Basis10                DB_BOOLEAN_NN,
    pb_sdt_Basis11                DB_BOOLEAN_NN,
    pb_sdt_Basis12                DB_BOOLEAN_NN,
    pb_sdt_Basis13                DB_BOOLEAN_NN,
    pb_sdt_Basis14                DB_BOOLEAN_NN,
    pb_sdt_Basis15                DB_BOOLEAN_NN,
    pb_sdt_ExcludeSalaryCalc      DB_BOOLEAN_NN,
    pb_sdt_IgnoreSparenCalc       DB_BOOLEAN_NN,
    pb_sdt_IstAktiv               DB_ISACTIVE_NN,
    pi_app_ActiveUser             DI_UID_NN
)
RETURNS( sdt_UId DI_UID_NN )
AS

  -- Add a new SalaryDeductionType and return SalaryDeductionType Id

BEGIN

  sdt_UId = GEN_ID (GEN_Sdt_UId, 1);

  INSERT INTO sdt_SalaryDeductionType
  (
    sdt_UId,
    sdt_BuyUId,
    sdt_Typ,
    sdt_LArt,
    sdt_Bezeichnung,
    sdt_Text,
    sdt_TextLohnAusweis,
    sdt_SortNr,
    sdt_SaxUId,
    sdt_IntUId,
    sdt_A_SalUId,
    sdt_C_SalUId,
    sdt_Z_SalUId,
    sdt_Soll_AcnUId,
    sdt_Haben_AcnUId,
    sdt_IstNullAusgabe,
    sdt_IstBearbeitbar,
    sdt_Kommentar,
    sdt_SctUId,
    sdt_BerechBasisNr,
    sdt_IstLohnTeil,
    sdt_IstVariabel,
    sdt_IstAutoBerechnung,
    sdt_Lart_sdtUid,
    sdt_InsInAbreTyp,
    sdt_MinLohn,
    sdt_MaxLohn,
    sdt_Freibetrag,
    sdt_MinPflichtLohn,
    sdt_MaxPflichtLohn,
    sdt_IstBesGradMin,
    sdt_IstBesGradMax,
    sdt_IstBesGradFrei,
    sdt_IstBesGradMinPfl,
    sdt_IstBesGradMaxPfl,
    sdt_IstIVGradMin,
    sdt_IstIVGradMax,
    sdt_IstIVGradFrei,
    sdt_IstIVGradMinPfl,
    sdt_IstIVGradMaxPfl,
    sdt_StdAbreTyp,
    sdt_IstLehrlingFrei,
    sdt_Ist8StdFrei,
    sdt_Masseinheit,
    sdt_IstZivilStand,
    sdt_IstAbJahresLohn,
    sdt_BerArtAbAlter,
    sdt_BerArtBisAlter,
    sdt_BisAlter1,
    sdt_BisAlter2,
    sdt_Ab1_1,
    sdt_Ab1_2,
    sdt_Ab1_3,
    sdt_Ab1_4,
    sdt_Ab1_5,
    sdt_Ab2_1,
    sdt_Ab2_2,
    sdt_Ab2_3,
    sdt_Ab2_4,
    sdt_Ab2_5,
    sdt_Sa1_Anteil1,
    sdt_Sa1_Anteil2,
    sdt_Sa1_Anteil3,
    sdt_Sa1_Anteil4,
    sdt_Sa1_Anteil5,
    sdt_Sa2_Anteil1,
    sdt_Sa2_Anteil2,
    sdt_Sa2_Anteil3,
    sdt_Sa2_Anteil4,
    sdt_Sa2_Anteil5,
    sdt_Sb1_Anteil1,
    sdt_Sb1_Anteil2,
    sdt_Sb1_Anteil3,
    sdt_Sb1_Anteil4,
    sdt_Sb1_Anteil5,
    sdt_Sb2_Anteil1,
    sdt_Sb2_Anteil2,
    sdt_Sb2_Anteil3,
    sdt_Sb2_Anteil4,
    sdt_Sb2_Anteil5,
    sdt_Basis1,
    sdt_Basis2,
    sdt_Basis3,
    sdt_Basis4,
    sdt_Basis5,
    sdt_Basis6,
    sdt_Basis7,
    sdt_Basis8,
    sdt_Basis9,
    sdt_Basis10,
    sdt_Basis11,
    sdt_Basis12,
    sdt_Basis13,
    sdt_Basis14,
    sdt_Basis15,
    sdt_ExcludeSalaryCalc,
    sdt_IgnoreSparenCalc,
    sdt_IstAktiv,
    sdt_CreateDate,
    sdt_CreateUsrUId,
    sdt_MutDate,
    sdt_MutUsrUId
  )
  VALUES
  (
    :sdt_UId,
    :pi_sdt_BuyUId,
    :ps_sdt_Typ,
    :ps_sdt_LArt,
    :ps_sdt_Bezeichnung,
    :ps_sdt_Text,
    :ps_sdt_TextLohnAusweis,
    :pi_sdt_SortNr,
    :pi_sdt_SaxUId,
    :pi_sdt_IntUId,
    :pi_sdt_A_SalUId,
    :pi_sdt_C_SalUId,
    :pi_sdt_Z_SalUId,
    :pi_sdt_Soll_AcnUId,
    :pi_sdt_Haben_AcnUId,
    :pb_sdt_IstNullAusgabe,
    :pb_sdt_IstBearbeitbar,
    :ps_sdt_Kommentar,
    :pi_sdt_SctUId,
    :pi_sdt_BerechBasisNr,
    :pb_sdt_IstLohnTeil,
    :pb_sdt_IstVariabel,
    :pb_sdt_IstAutoBerechnung,
    :pi_sdt_Lart_sdtUid,
    :ps_sdt_InsInAbreTyp,
    :pn_sdt_MinLohn,
    :pn_sdt_MaxLohn,
    :pn_sdt_Freibetrag,
    :pn_sdt_MinPflichtLohn,
    :pn_sdt_MaxPflichtLohn,
    :pb_sdt_IstBesGradMin,
    :pb_sdt_IstBesGradMax,
    :pb_sdt_IstBesGradFrei,
    :pb_sdt_IstBesGradMinPfl,
    :pb_sdt_IstBesGradMaxPfl,
    :pb_sdt_IstIVGradMin,
    :pb_sdt_IstIVGradMax,
    :pb_sdt_IstIVGradFrei,
    :pb_sdt_IstIVGradMinPfl,
    :pb_sdt_IstIVGradMaxPfl,
    :ps_sdt_StdAbreTyp,
    :pb_sdt_IstLehrlingFrei,
    :pb_sdt_Ist8StdFrei,
    :ps_sdt_Masseinheit,
    :pb_sdt_IstZivilStand,
    :pb_sdt_IstAbJahresLohn,
    :ps_sdt_BerArtAbAlter,
    :ps_sdt_BerArtBisAlter,
    :pi_sdt_BisAlter1,
    :pi_sdt_BisAlter2,
    :pi_sdt_Ab1_1,
    :pi_sdt_Ab1_2,
    :pi_sdt_Ab1_3,
    :pi_sdt_Ab1_4,
    :pi_sdt_Ab1_5,
    :pi_sdt_Ab2_1,
    :pi_sdt_Ab2_2,
    :pi_sdt_Ab2_3,
    :pi_sdt_Ab2_4,
    :pi_sdt_Ab2_5,
    :pn_sdt_Sa1_Anteil1,
    :pn_sdt_Sa1_Anteil2,
    :pn_sdt_Sa1_Anteil3,
    :pn_sdt_Sa1_Anteil4,
    :pn_sdt_Sa1_Anteil5,
    :pn_sdt_Sa2_Anteil1,
    :pn_sdt_Sa2_Anteil2,
    :pn_sdt_Sa2_Anteil3,
    :pn_sdt_Sa2_Anteil4,
    :pn_sdt_Sa2_Anteil5,
    :pn_sdt_Sb1_Anteil1,
    :pn_sdt_Sb1_Anteil2,
    :pn_sdt_Sb1_Anteil3,
    :pn_sdt_Sb1_Anteil4,
    :pn_sdt_Sb1_Anteil5,
    :pn_sdt_Sb2_Anteil1,
    :pn_sdt_Sb2_Anteil2,
    :pn_sdt_Sb2_Anteil3,
    :pn_sdt_Sb2_Anteil4,
    :pn_sdt_Sb2_Anteil5,
    :pb_sdt_Basis1,
    :pb_sdt_Basis2,
    :pb_sdt_Basis3,
    :pb_sdt_Basis4,
    :pb_sdt_Basis5,
    :pb_sdt_Basis6,
    :pb_sdt_Basis7,
    :pb_sdt_Basis8,
    :pb_sdt_Basis9,
    :pb_sdt_Basis10,
    :pb_sdt_Basis11,
    :pb_sdt_Basis12,
    :pb_sdt_Basis13,
    :pb_sdt_Basis14,
    :pb_sdt_Basis15,
    :pb_sdt_ExcludeSalaryCalc,
    :pb_sdt_IgnoreSparenCalc,
    :pb_sdt_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!


COMMENT ON PROCEDURE sp_Sdt_Insert IS 'Add a new SalaryDeductionType and return SalaryDeductionType Id'!!

COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_BuyUId              IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_Typ                 IS 'Type'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_LArt                IS 'Kurzbezeichnung für die Lohn- bzw. Abzugsart'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_Bezeichnung         IS 'Bezeichnung zur Auswahl'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_Text                IS 'Text-Vorschlag in Lohn-Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_SortNr              IS 'Sortierung im der Lohnabrechnung und Reihenfolge der Berechnung'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_SaxUId              IS 'Salary-Caterory (for Report Statistik) (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_IntUId              IS 'Institution Type Id (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_A_SalUId            IS 'Position im Lohnausweis (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Z_SalUId            IS 'Position im Lohn-ausweis-Zusatzblatt(für A-Grenzgänger) FK'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Soll_AcnUId         IS 'Konto Soll (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Haben_AcnUId        IS 'Konto Haben (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstNullAusgabe      IS 'Ausgabe auf Lohnabrechnung wenn 0.00'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBearbeitbar      IS 'Beim Einfügen in Abrechnung bearbeitbar'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_Kommentar           IS 'Anzeige im Bearbeit-ungsfenseter beim Einfügen in Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_SctUId              IS 'Berechnungsart'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_BerechBasisNr       IS 'Basis Nr (1..16)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstLohnTeil         IS 'Lohnbestandteil ja/nein'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstVariabel         IS 'Variabel in Lohnabrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstAutoBerechnung   IS 'Autom. gemäss Alter o. Zivilstand berechnet'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Lart_sdtUid         IS 'Lohnart die autom. AlsKorr-Lohnart eingefügtwird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_InsInAbreTyp        IS 'Verhalten beim Kopieren der Lohnvorlage in Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_MinLohn             IS 'Eintrittschwelle'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_MaxLohn             IS 'MaximalLohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Freibetrag          IS 'Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_MinPflichtLohn      IS 'Minimal beitragspflichtiger Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_MaxPflichtLohn      IS 'Maximal beitragspflichtiger Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBesGradMin       IS 'BesGrad bei Min.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBesGradMax       IS 'BesGrad bei Max.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBesGradFrei      IS 'BesGrad bei Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBesGradMinPfl    IS 'BesGrad bei Min. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstBesGradMaxPfl    IS 'BesGrad bei Max. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstIVGradMin        IS 'IV-Grad bei Min.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstIVGradMax        IS 'IV-Grad bei Max.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstIVGradFrei       IS 'IV-Grad bei Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstIVGradMinPfl     IS 'IV-Grad bei Min. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstIVGradMaxPfl     IS 'IV-Grad bei Max. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_StdAbreTyp          IS 'In Stundenabrechnung übernehmen(nur bei Menge x Ansatz Massgebend)'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstLehrlingFrei     IS 'Sind Lehrlinge beitragsbefreit'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Ist8StdFrei         IS 'Sind MA’s < 8Std/Woche beitragsbefreit'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_Masseinheit         IS 'Masseinheit '!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstZivilStand       IS 'Prozente nach Zivilstand oder nach Geschlecht'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstAbJahresLohn     IS 'Abstufung nach Alter oder nach Jahreslohn'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_BerArtAbAlter       IS 'Berechnung für  Datum Alter-Ab'!!
COMMENT ON PARAMETER sp_Sdt_Insert.ps_sdt_BerArtBisAlter      IS 'Berechnung für  Datum Alter-Bis'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_BisAlter1           IS 'Ablauf der Beitragspflicht Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_BisAlter2           IS 'Ablauf der Beitragspflicht Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab1_1               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab1_2               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab1_3               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab1_4               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab1_5               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab2_1               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab2_2               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab2_3               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab2_4               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_sdt_Ab2_5               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa1_Anteil1         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa1_Anteil2         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa1_Anteil3         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa1_Anteil4         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa1_Anteil5         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa2_Anteil1         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa2_Anteil2         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa2_Anteil3         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa2_Anteil4         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sa2_Anteil5         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb1_Anteil1         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb1_Anteil2         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb1_Anteil3         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb1_Anteil4         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb1_Anteil5         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb2_Anteil1         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb2_Anteil2         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb2_Anteil3         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb2_Anteil4         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pn_sdt_Sb2_Anteil5         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis1              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis2              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis3              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis4              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis5              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis6              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis7              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis8              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis9              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis10             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis11             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis12             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis13             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis14             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_Basis15             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_ExcludeSalaryCalc   IS 'Abzugsart bei Basis-Kalkulation in Reports ignorieren'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IgnoreSparenCalc    IS 'Übergangskalkulation für PK-Sparen ignorieren'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IstAktiv            IS 'Active flag'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pi_app_ActiveUser          IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sdt_Update
(
    pi_sdt_UId                    DI_UID_NN,
    pi_sdt_BuyUId                 DI_UID_NN,
    ps_sdt_Typ                    DS_ONECHARFLAG_NN,
    ps_sdt_LArt                   DS_STR5_NN,
    ps_sdt_Bezeichnung            DS_DESCR_NN,
    ps_sdt_Text                   DS_DESCR_NN,
    ps_sdt_TextLohnAusweis        DS_DESCR_NN,
    pi_sdt_SortNr                 DI_SMLINT_NN,
    pi_sdt_SaxUId                 DI_UID_NN,
    pi_sdt_IntUId                 DI_UID,
    pi_sdt_A_SalUId               DI_UID,
    pi_sdt_C_SalUId               DI_UID,
    pi_sdt_Z_SalUId               DI_UID,
    pi_sdt_Soll_AcnUId            DI_UID,
    pi_sdt_Haben_AcnUId           DI_UID,
    pb_sdt_IstNullAusgabe         DB_BOOLEAN_NN,
    pb_sdt_IstBearbeitbar         DB_BOOLEAN_NN,
    ps_sdt_Kommentar              DS_STR255,
    pi_sdt_SctUId                 DI_UID_NN,
    pi_sdt_BerechBasisNr          DI_SMLINT_NN,
    pb_sdt_IstLohnTeil            DB_BOOLEAN_NN,
    pb_sdt_IstVariabel            DB_BOOLEAN_NN,
    pb_sdt_IstAutoBerechnung      DB_BOOLEAN_NN,
    pi_sdt_Lart_sdtUid            DI_UID,
    ps_sdt_InsInAbreTyp           DS_ONECHARFLAG_NN,
    pn_sdt_MinLohn                DN_AMOUNT,
    pn_sdt_MaxLohn                DN_AMOUNT,
    pn_sdt_Freibetrag             DN_AMOUNT,
    pn_sdt_MinPflichtLohn         DN_AMOUNT,
    pn_sdt_MaxPflichtLohn         DN_AMOUNT,
    pb_sdt_IstBesGradMin          DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMax          DB_BOOLEAN_NN,
    pb_sdt_IstBesGradFrei         DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMinPfl       DB_BOOLEAN_NN,
    pb_sdt_IstBesGradMaxPfl       DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMin           DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMax           DB_BOOLEAN_NN,
    pb_sdt_IstIVGradFrei          DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMinPfl        DB_BOOLEAN_NN,
    pb_sdt_IstIVGradMaxPfl        DB_BOOLEAN_NN,
    ps_sdt_StdAbreTyp             DS_ONECHARFLAG_NN,
    pb_sdt_IstLehrlingFrei        DB_BOOLEAN_NN,
    pb_sdt_Ist8StdFrei            DB_BOOLEAN_NN,
    ps_sdt_Masseinheit            DS_STR10,
    pb_sdt_IstZivilStand          DB_BOOLEAN_NN,
    pb_sdt_IstAbJahresLohn        DB_BOOLEAN_NN,
    ps_sdt_BerArtAbAlter          DS_ONECHARFLAG_NN,
    ps_sdt_BerArtBisAlter         DS_ONECHARFLAG_NN,
    pi_sdt_BisAlter1              DI_SMLINT,
    pi_sdt_BisAlter2              DI_SMLINT,
    pi_sdt_Ab1_1                  DI_INT,
    pi_sdt_Ab1_2                  DI_INT,
    pi_sdt_Ab1_3                  DI_INT,
    pi_sdt_Ab1_4                  DI_INT,
    pi_sdt_Ab1_5                  DI_INT,
    pi_sdt_Ab2_1                  DI_INT,
    pi_sdt_Ab2_2                  DI_INT,
    pi_sdt_Ab2_3                  DI_INT,
    pi_sdt_Ab2_4                  DI_INT,
    pi_sdt_Ab2_5                  DI_INT,
    pn_sdt_Sa1_Anteil1            DN_AMOUNT,
    pn_sdt_Sa1_Anteil2            DN_AMOUNT,
    pn_sdt_Sa1_Anteil3            DN_AMOUNT,
    pn_sdt_Sa1_Anteil4            DN_AMOUNT,
    pn_sdt_Sa1_Anteil5            DN_AMOUNT,
    pn_sdt_Sa2_Anteil1            DN_AMOUNT,
    pn_sdt_Sa2_Anteil2            DN_AMOUNT,
    pn_sdt_Sa2_Anteil3            DN_AMOUNT,
    pn_sdt_Sa2_Anteil4            DN_AMOUNT,
    pn_sdt_Sa2_Anteil5            DN_AMOUNT,
    pn_sdt_Sb1_Anteil1            DN_AMOUNT,
    pn_sdt_Sb1_Anteil2            DN_AMOUNT,
    pn_sdt_Sb1_Anteil3            DN_AMOUNT,
    pn_sdt_Sb1_Anteil4            DN_AMOUNT,
    pn_sdt_Sb1_Anteil5            DN_AMOUNT,
    pn_sdt_Sb2_Anteil1            DN_AMOUNT,
    pn_sdt_Sb2_Anteil2            DN_AMOUNT,
    pn_sdt_Sb2_Anteil3            DN_AMOUNT,
    pn_sdt_Sb2_Anteil4            DN_AMOUNT,
    pn_sdt_Sb2_Anteil5            DN_AMOUNT,
    pb_sdt_Basis1                 DB_BOOLEAN_NN,
    pb_sdt_Basis2                 DB_BOOLEAN_NN,
    pb_sdt_Basis3                 DB_BOOLEAN_NN,
    pb_sdt_Basis4                 DB_BOOLEAN_NN,
    pb_sdt_Basis5                 DB_BOOLEAN_NN,
    pb_sdt_Basis6                 DB_BOOLEAN_NN,
    pb_sdt_Basis7                 DB_BOOLEAN_NN,
    pb_sdt_Basis8                 DB_BOOLEAN_NN,
    pb_sdt_Basis9                 DB_BOOLEAN_NN,
    pb_sdt_Basis10                DB_BOOLEAN_NN,
    pb_sdt_Basis11                DB_BOOLEAN_NN,
    pb_sdt_Basis12                DB_BOOLEAN_NN,
    pb_sdt_Basis13                DB_BOOLEAN_NN,
    pb_sdt_Basis14                DB_BOOLEAN_NN,
    pb_sdt_Basis15                DB_BOOLEAN_NN,
    pb_sdt_ExcludeSalaryCalc      DB_BOOLEAN_NN,
    pb_sdt_IgnoreSparenCalc       DB_BOOLEAN_NN,
    pb_sdt_IstAktiv               DB_ISACTIVE_NN,
    pi_app_ActiveUser             DI_UID_NN
)
AS

  -- Update SalaryDeductionType data by Id

BEGIN

  UPDATE sdt_SalaryDeductionType
     SET sdt_BuyUId              = :pi_sdt_BuyUId                 ,
         sdt_Typ                 = :ps_sdt_Typ                    ,
         sdt_LArt                = :ps_sdt_LArt                   ,
         sdt_Bezeichnung         = :ps_sdt_Bezeichnung            ,
         sdt_Text                = :ps_sdt_Text                   ,
         sdt_TextLohnAusweis     = :ps_sdt_TextLohnAusweis        ,
         sdt_SortNr              = :pi_sdt_SortNr                 ,
         sdt_SaxUId              = :pi_sdt_SaxUId                 ,
         sdt_IntUId              = :pi_sdt_IntUId                 ,
         sdt_A_SalUId            = :pi_sdt_A_SalUId               ,
         sdt_C_SalUId            = :pi_sdt_C_SalUId               ,
         sdt_Z_SalUId            = :pi_sdt_Z_SalUId               ,
         sdt_Soll_AcnUId         = :pi_sdt_Soll_AcnUId            ,
         sdt_Haben_AcnUId        = :pi_sdt_Haben_AcnUId           ,
         sdt_IstNullAusgabe      = :pb_sdt_IstNullAusgabe         ,
         sdt_IstBearbeitbar      = :pb_sdt_IstBearbeitbar         ,
         sdt_Kommentar           = :ps_sdt_Kommentar              ,
         sdt_SctUId              = :pi_sdt_SctUId                 ,
         sdt_BerechBasisNr       = :pi_sdt_BerechBasisNr          ,
         sdt_IstLohnTeil         = :pb_sdt_IstLohnTeil            ,
         sdt_IstVariabel         = :pb_sdt_IstVariabel            ,
         sdt_IstAutoBerechnung   = :pb_sdt_IstAutoBerechnung      ,
         sdt_Lart_sdtUid         = :pi_sdt_Lart_sdtUid            ,
         sdt_InsInAbreTyp        = :ps_sdt_InsInAbreTyp           ,
         sdt_MinLohn             = :pn_sdt_MinLohn                ,
         sdt_MaxLohn             = :pn_sdt_MaxLohn                ,
         sdt_Freibetrag          = :pn_sdt_Freibetrag             ,
         sdt_MinPflichtLohn      = :pn_sdt_MinPflichtLohn         ,
         sdt_MaxPflichtLohn      = :pn_sdt_MaxPflichtLohn         ,
         sdt_IstBesGradMin       = :pb_sdt_IstBesGradMin          ,
         sdt_IstBesGradMax       = :pb_sdt_IstBesGradMax          ,
         sdt_IstBesGradFrei      = :pb_sdt_IstBesGradFrei         ,
         sdt_IstBesGradMinPfl    = :pb_sdt_IstBesGradMinPfl       ,
         sdt_IstBesGradMaxPfl    = :pb_sdt_IstBesGradMaxPfl       ,
         sdt_IstIVGradMin        = :pb_sdt_IstIVGradMin           ,
         sdt_IstIVGradMax        = :pb_sdt_IstIVGradMax           ,
         sdt_IstIVGradFrei       = :pb_sdt_IstIVGradFrei          ,
         sdt_IstIVGradMinPfl     = :pb_sdt_IstIVGradMinPfl        ,
         sdt_IstIVGradMaxPfl     = :pb_sdt_IstIVGradMaxPfl        ,
         sdt_StdAbreTyp          = :ps_sdt_StdAbreTyp             ,
         sdt_IstLehrlingFrei     = :pb_sdt_IstLehrlingFrei        ,
         sdt_Ist8StdFrei         = :pb_sdt_Ist8StdFrei            ,
         sdt_Masseinheit         = :ps_sdt_Masseinheit            ,
         sdt_IstZivilStand       = :pb_sdt_IstZivilStand          ,
         sdt_IstAbJahresLohn     = :pb_sdt_IstAbJahresLohn        ,
         sdt_BerArtAbAlter       = :ps_sdt_BerArtAbAlter          ,
         sdt_BerArtBisAlter      = :ps_sdt_BerArtBisAlter         ,
         sdt_BisAlter1           = :pi_sdt_BisAlter1              ,
         sdt_BisAlter2           = :pi_sdt_BisAlter2              ,
         sdt_Ab1_1               = :pi_sdt_Ab1_1                  ,
         sdt_Ab1_2               = :pi_sdt_Ab1_2                  ,
         sdt_Ab1_3               = :pi_sdt_Ab1_3                  ,
         sdt_Ab1_4               = :pi_sdt_Ab1_4                  ,
         sdt_Ab1_5               = :pi_sdt_Ab1_5                  ,
         sdt_Ab2_1               = :pi_sdt_Ab2_1                  ,
         sdt_Ab2_2               = :pi_sdt_Ab2_2                  ,
         sdt_Ab2_3               = :pi_sdt_Ab2_3                  ,
         sdt_Ab2_4               = :pi_sdt_Ab2_4                  ,
         sdt_Ab2_5               = :pi_sdt_Ab2_5                  ,
         sdt_Sa1_Anteil1         = :pn_sdt_Sa1_Anteil1            ,
         sdt_Sa1_Anteil2         = :pn_sdt_Sa1_Anteil2            ,
         sdt_Sa1_Anteil3         = :pn_sdt_Sa1_Anteil3            ,
         sdt_Sa1_Anteil4         = :pn_sdt_Sa1_Anteil4            ,
         sdt_Sa1_Anteil5         = :pn_sdt_Sa1_Anteil5            ,
         sdt_Sa2_Anteil1         = :pn_sdt_Sa2_Anteil1            ,
         sdt_Sa2_Anteil2         = :pn_sdt_Sa2_Anteil2            ,
         sdt_Sa2_Anteil3         = :pn_sdt_Sa2_Anteil3            ,
         sdt_Sa2_Anteil4         = :pn_sdt_Sa2_Anteil4            ,
         sdt_Sa2_Anteil5         = :pn_sdt_Sa2_Anteil5            ,
         sdt_Sb1_Anteil1         = :pn_sdt_Sb1_Anteil1            ,
         sdt_Sb1_Anteil2         = :pn_sdt_Sb1_Anteil2            ,
         sdt_Sb1_Anteil3         = :pn_sdt_Sb1_Anteil3            ,
         sdt_Sb1_Anteil4         = :pn_sdt_Sb1_Anteil4            ,
         sdt_Sb1_Anteil5         = :pn_sdt_Sb1_Anteil5            ,
         sdt_Sb2_Anteil1         = :pn_sdt_Sb2_Anteil1            ,
         sdt_Sb2_Anteil2         = :pn_sdt_Sb2_Anteil2            ,
         sdt_Sb2_Anteil3         = :pn_sdt_Sb2_Anteil3            ,
         sdt_Sb2_Anteil4         = :pn_sdt_Sb2_Anteil4            ,
         sdt_Sb2_Anteil5         = :pn_sdt_Sb2_Anteil5            ,
         sdt_Basis1              = :pb_sdt_Basis1                 ,
         sdt_Basis2              = :pb_sdt_Basis2                 ,
         sdt_Basis3              = :pb_sdt_Basis3                 ,
         sdt_Basis4              = :pb_sdt_Basis4                 ,
         sdt_Basis5              = :pb_sdt_Basis5                 ,
         sdt_Basis6              = :pb_sdt_Basis6                 ,
         sdt_Basis7              = :pb_sdt_Basis7                 ,
         sdt_Basis8              = :pb_sdt_Basis8                 ,
         sdt_Basis9              = :pb_sdt_Basis9                 ,
         sdt_Basis10             = :pb_sdt_Basis10                ,
         sdt_Basis11             = :pb_sdt_Basis11                ,
         sdt_Basis12             = :pb_sdt_Basis12                ,
         sdt_Basis13             = :pb_sdt_Basis13                ,
         sdt_Basis14             = :pb_sdt_Basis14                ,
         sdt_Basis15             = :pb_sdt_Basis15                ,
         sdt_ExcludeSalaryCalc   = :pb_sdt_ExcludeSalaryCalc      ,
         sdt_IgnoreSparenCalc    = :pb_sdt_IgnoreSparenCalc       ,
         sdt_IstAktiv            = :pb_sdt_IstAktiv               ,
         sdt_MutDate             = Current_TimeStamp              ,
         sdt_MutUsrUId           = :pi_app_ActiveUser
   WHERE sdt_UId                 = :pi_sdt_UId;

END!!


COMMENT ON PROCEDURE sp_Sdt_Update IS 'Update SalaryDeductionType data by Id'!!

COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_UId                 IS 'Id of the SalaryDeductionType to be updated'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_BuyUId              IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_Typ                 IS 'Type'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_LArt                IS 'Kurzbezeichnung für die Lohn- bzw. Abzugsart'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_Bezeichnung         IS 'Bezeichnung zur Auswahl'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_Text                IS 'Text-Vorschlag in Lohn-Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_TextLohnAusweis     IS 'Salary statement text'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_SortNr              IS 'Sortierung im der Lohnabrechnung und Reihenfolge der Berechnung'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_SaxUId              IS 'Salary-Caterory (for Report Statistik) (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_IntUId              IS 'Institution Type Id (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_A_SalUId            IS 'Position im Lohnausweis (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_C_SalUId            IS 'Position im Lohnausweis (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Z_SalUId            IS 'Position im Lohn-ausweis-Zusatzblatt(für A-Grenzgänger) FK'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Soll_AcnUId         IS 'Konto Soll (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Haben_AcnUId        IS 'Konto Haben (FK)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstNullAusgabe      IS 'Ausgabe auf Lohnabrechnung wenn 0.00'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBearbeitbar      IS 'Beim Einfügen in Abrechnung bearbeitbar'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_Kommentar           IS 'Anzeige im Bearbeit-ungsfenseter beim Einfügen in Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_SctUId              IS 'Berechnungsart'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_BerechBasisNr       IS 'Basis Nr (1..16)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstLohnTeil         IS 'Lohnbestandteil ja/nein'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstVariabel         IS 'Variabel in Lohnabrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstAutoBerechnung   IS 'Autom. gemäss Alter o. Zivilstand berechnet'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Lart_sdtUid         IS 'Lohnart die autom. AlsKorr-Lohnart eingefügtwird'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_InsInAbreTyp        IS 'Verhalten beim Kopieren der Lohnvorlage in Abrechnung'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_MinLohn             IS 'Eintrittschwelle'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_MaxLohn             IS 'MaximalLohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Freibetrag          IS 'Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_MinPflichtLohn      IS 'Minimal beitragspflichtiger Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_MaxPflichtLohn      IS 'Maximal beitragspflichtiger Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBesGradMin       IS 'BesGrad bei Min.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBesGradMax       IS 'BesGrad bei Max.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBesGradFrei      IS 'BesGrad bei Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBesGradMinPfl    IS 'BesGrad bei Min. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstBesGradMaxPfl    IS 'BesGrad bei Max. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstIVGradMin        IS 'IV-Grad bei Min.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstIVGradMax        IS 'IV-Grad bei Max.Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstIVGradFrei       IS 'IV-Grad bei Freibetrag'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstIVGradMinPfl     IS 'IV-Grad bei Min. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstIVGradMaxPfl     IS 'IV-Grad bei Max. pflichtigem Lohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_StdAbreTyp          IS 'In Stundenabrechnung übernehmen(nur bei Menge x Ansatz Massgebend)'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstLehrlingFrei     IS 'Sind Lehrlinge beitragsbefreit'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Ist8StdFrei         IS 'Sind MA’s < 8Std/Woche beitragsbefreit'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_Masseinheit         IS 'Masseinheit '!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstZivilStand       IS 'Prozente nach Zivilstand oder nach Geschlecht'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstAbJahresLohn     IS 'Abstufung nach Alter oder nach Jahreslohn'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_BerArtAbAlter       IS 'Berechnung für  Datum Alter-Ab'!!
COMMENT ON PARAMETER sp_Sdt_Update.ps_sdt_BerArtBisAlter      IS 'Berechnung für  Datum Alter-Bis'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_BisAlter1           IS 'Ablauf der Beitragspflicht Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_BisAlter2           IS 'Ablauf der Beitragspflicht Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab1_1               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab1_2               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab1_3               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab1_4               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab1_5               IS 'Abstufung  nach Alter oder nach JahresLohn Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab2_1               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab2_2               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab2_3               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab2_4               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_sdt_Ab2_5               IS 'Abstufung  nach Alter oder nach JahresLohn Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa1_Anteil1         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa1_Anteil2         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa1_Anteil3         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa1_Anteil4         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa1_Anteil5         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa2_Anteil1         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa2_Anteil2         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa2_Anteil3         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa2_Anteil4         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sa2_Anteil5         IS 'Total - Spalte A (Arbeitnehmer-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb1_Anteil1         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb1_Anteil2         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb1_Anteil3         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb1_Anteil4         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb1_Anteil5         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 1'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb2_Anteil1         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb2_Anteil2         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb2_Anteil3         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb2_Anteil4         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pn_sdt_Sb2_Anteil5         IS 'Total- Spalte B (Arbeitgeber-Anteil) Page 2'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis1              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis2              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis3              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis4              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis5              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis6              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis7              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis8              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis9              IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis10             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis11             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis12             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis13             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis14             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_Basis15             IS 'Basen von welchem der beitragspflichtige Lohn gerechnet wird'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_ExcludeSalaryCalc   IS 'Abzugsart bei Basis-Kalkulation in Reports ignorieren'!!
COMMENT ON PARAMETER sp_Sdt_Insert.pb_sdt_IgnoreSparenCalc    IS 'Übergangskalkulation für PK-Sparen ignorieren'!!
COMMENT ON PARAMETER sp_Sdt_Update.pb_sdt_IstAktiv            IS 'Active flag'!!
COMMENT ON PARAMETER sp_Sdt_Update.pi_app_ActiveUser          IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sdt_Select 
(
  pi_BuyUId       DI_UID,
  ps_sdt_Typ      DS_ONECHARFLAG,
  pb_sdt_IstAktiv DB_BOOLEAN
)
RETURNS 
(
  sdt_UId                   DI_UID,
  sdt_LArt                  DS_STR5,
  sdt_BerechBasisNr         DI_SMLINT,
  sdt_Typ                   DS_ONECHARFLAG,  
  sdt_Bezeichnung           DS_DESCR,
  sdt_Text                  DS_DESCR,
  sdt_SortNr                DI_SMLINT,
  sdt_IstVariabel           DB_BOOLEAN,
  sdt_IstLohnTeil           DB_BOOLEAN,
  sdt_MassEinheit           DS_STR10,
  sdt_StdAbreTyp            DS_ONECHARFLAG, 
  sdt_InsInAbreTyp          DS_ONECHARFLAG,
  sdt_BuyUId                DI_UID,          
  sdt_LArt_SdtUId           DI_UID,
  
  sdt_MinLohn               DN_AMOUNT,
  sdt_MaxLohn               DN_AMOUNT,
  sdt_Freibetrag            DN_AMOUNT,
  sdt_MinPflichtLohn        DN_AMOUNT,
  sdt_MaxPflichtLohn        DN_AMOUNT,
  
  sdt_IstZivilstand         DB_BOOLEAN,    
  sdt_IstAbJahresLohn       DB_BOOLEAN,  
  sdt_IstLehrlingFrei       DB_BOOLEAN, 
  sdt_Ist8StdFrei           DB_BOOLEAN,  
  sdt_IstBesGradMin         DB_BOOLEAN,
  sdt_IstBesGradMax         DB_BOOLEAN,
  sdt_IstBesGradFrei        DB_BOOLEAN,
  sdt_IstBesGradMinPfl      DB_BOOLEAN,
  sdt_IstBesGradMaxPfl      DB_BOOLEAN,
  sdt_IstIVGradMin          DB_BOOLEAN,
  sdt_IstIVGradMax          DB_BOOLEAN,
  sdt_IstIVGradFrei         DB_BOOLEAN,
  sdt_IstIVGradMinPfl       DB_BOOLEAN,
  sdt_IstIVGradMaxPfl       DB_BOOLEAN,
  sdt_IstAutoBerechnung     DB_BOOLEAN,
  sdt_BerArtAbAlter         DS_ONECHARFLAG,
  sdt_BerArtBisAlter        DS_ONECHARFLAG,
  sdt_BisAlter1             DI_SMLINT,         
  sdt_BisAlter2             DI_SMLINT,
  
  sdt_Ab1_1                 DI_INT,            
  sdt_Ab1_2                 DI_INT,             
  sdt_Ab1_3                 DI_INT,             
  sdt_Ab1_4                 DI_INT,            
  sdt_Ab1_5                 DI_INT,            
  sdt_Ab2_1                 DI_INT,             
  sdt_Ab2_2                 DI_INT,             
  sdt_Ab2_3                 DI_INT,            
  sdt_Ab2_4                 DI_INT,            
  sdt_Ab2_5                 DI_INT,
  
  sdt_Sa1_Anteil1           DN_AMOUNT,
  sdt_Sa1_Anteil2           DN_AMOUNT,      
  sdt_Sa1_Anteil3           DN_AMOUNT,      
  sdt_Sa1_Anteil4           DN_AMOUNT,       
  sdt_Sa1_Anteil5           DN_AMOUNT,       
  sdt_Sa2_Anteil1           DN_AMOUNT,      
  sdt_Sa2_Anteil2           DN_AMOUNT,      
  sdt_Sa2_Anteil3           DN_AMOUNT,       
  sdt_Sa2_Anteil4           DN_AMOUNT,       
  sdt_Sa2_Anteil5           DN_AMOUNT,      
  sdt_Sb1_Anteil1           DN_AMOUNT,      
  sdt_Sb1_Anteil2           DN_AMOUNT,       
  sdt_Sb1_Anteil3           DN_AMOUNT,       
  sdt_Sb1_Anteil4           DN_AMOUNT,      
  sdt_Sb1_Anteil5           DN_AMOUNT,      
  sdt_Sb2_Anteil1           DN_AMOUNT,       
  sdt_Sb2_Anteil2           DN_AMOUNT,       
  sdt_Sb2_Anteil3           DN_AMOUNT,      
  sdt_Sb2_Anteil4           DN_AMOUNT,      
  sdt_Sb2_Anteil5           DN_AMOUNT,
  
  sdt_Basis1                DB_BOOLEAN,
  sdt_Basis2                DB_BOOLEAN,
  sdt_Basis3                DB_BOOLEAN,
  sdt_Basis4                DB_BOOLEAN,
  sdt_Basis5                DB_BOOLEAN,
  sdt_Basis6                DB_BOOLEAN,
  sdt_Basis7                DB_BOOLEAN,
  sdt_Basis8                DB_BOOLEAN,
  sdt_Basis9                DB_BOOLEAN,
  sdt_Basis10               DB_BOOLEAN,
  sdt_Basis11               DB_BOOLEAN,
  sdt_Basis12               DB_BOOLEAN,
  sdt_Basis13               DB_BOOLEAN,
  sdt_Basis14               DB_BOOLEAN,
  sdt_Basis15               DB_BOOLEAN,
  
  sdt_Kommentar             DS_STR255,
  sdt_IstBearbeitbar        DB_BOOLEAN,
  sct_CalcType              DI_SMLINT,
  sct_Typ                   DS_ONECHARFLAG,
  sct_Bezeichnung           DS_DESCR,
  sdt_TextLohnAusweis       DS_STR30,
  sdt_SaxUId                DI_UID,
  sdt_IntUId                DI_UID,
  sdt_A_SalUId              DI_UID,
  sdt_C_SalUId              DI_UID,
  sdt_Z_SalUId              DI_UID,
  sdt_Soll_AcnUId           DI_UID,
  sdt_Haben_AcnUId          DI_UID,
  sdt_IstNullAusgabe        DB_BOOLEAN,
  sdt_SctUId                DI_UID,
  
  sdt_ExcludeSalaryCalc     DB_BOOLEAN,
  sdt_IgnoreSparenCalc      DB_BOOLEAN,
  
  sdt_IstAktiv              DB_ISACTIVE,
  sdt_CreateDate            DD_TIMESTAMP,
  sdt_CreateUsrUId          DI_UID,
  sdt_MutDate               DD_TIMESTAMP,
  sdt_MutUsrUId             DI_UID,
  sdt_CreateUser            DS_USERLOGIN,
  sdt_MutUser               DS_USERLOGIN,
  
  sax_Typ                   DS_ONECHARFLAG,
  sax_Bezeichnung           DS_DESCR,
  sax_SpalteNr              DI_SMLINT,
  
  buy_GeschJahr             DI_INT,
  
  int_Typ                   DS_STR3,
  int_Bezeichnung           DS_DESCR,
    
  ps_LArt_Korr              DS_STR5,
  
  A_Sal_Typ                 DS_ONECHARFLAG,
  A_Sal_Code                DS_STR10,
  A_Sal_Bezeichnung         DS_DESCR,
  C_Sal_Typ                 DS_ONECHARFLAG,
  C_Sal_Code                DS_STR10,
  C_Sal_Bezeichnung         DS_DESCR,
  Z_Sal_Typ                 DS_ONECHARFLAG,
  Z_Sal_Code                DS_STR10,
  Z_Sal_Bezeichnung         DS_DESCR,
  
  Soll_Acn_Konto            DS_STR13,
  Soll_Acn_Bezeichnung      DS_STR50,
  
  Haben_Acn_Konto           DS_STR13,
  Haben_Acn_Bezeichnung     DS_STR50
)
AS

  -- Select SalaryDeductionType data by Id or by SalaryDeductionType

BEGIN

  FOR

    SELECT sdt_UId,
           sdt_BuyUId,
           buy_GeschJahr,
           sdt_Typ,
           sdt_LArt,
           sdt_Bezeichnung,
           sdt_Text,
           sdt_TextLohnAusweis,
           sdt_SortNr,
           sdt_SaxUId,
           sdt_IntUId,
           sdt_A_SalUId,
           sdt_C_SalUId,
           sdt_Z_SalUId,
           sdt_Soll_AcnUId,
           sdt_Haben_AcnUId,
           sdt_IstNullAusgabe,
           sdt_IstBearbeitbar,
           sdt_Kommentar,
           sdt_SctUId,
           sdt_BerechBasisNr,
           sdt_IstLohnTeil,
           sdt_IstVariabel,
           sdt_IstAutoBerechnung,
           sdt_Lart_sdtUid,
           sdt_InsInAbreTyp,
           sdt_MinLohn,
           sdt_MaxLohn,
           sdt_Freibetrag,
           sdt_MinPflichtLohn,
           sdt_MaxPflichtLohn,
           sdt_IstBesGradMin,
           sdt_IstBesGradMax,
           sdt_IstBesGradFrei,
           sdt_IstBesGradMinPfl,
           sdt_IstBesGradMaxPfl,
           sdt_IstIVGradMin,
           sdt_IstIVGradMax,
           sdt_IstIVGradFrei,
           sdt_IstIVGradMinPfl,
           sdt_IstIVGradMaxPfl,
           sdt_StdAbreTyp,
           sdt_IstLehrlingFrei,
           sdt_Ist8StdFrei,
           sdt_Masseinheit,
           sdt_IstZivilStand,
           sdt_IstAbJahresLohn,
           sdt_BerArtAbAlter,
           sdt_BerArtBisAlter,
           sdt_BisAlter1,
           sdt_BisAlter2,
           sdt_Ab1_1,
           sdt_Ab1_2,
           sdt_Ab1_3,
           sdt_Ab1_4,
           sdt_Ab1_5,
           sdt_Ab2_1,
           sdt_Ab2_2,
           sdt_Ab2_3,
           sdt_Ab2_4,
           sdt_Ab2_5,
           sdt_Sa1_Anteil1,
           sdt_Sa1_Anteil2,
           sdt_Sa1_Anteil3,
           sdt_Sa1_Anteil4,
           sdt_Sa1_Anteil5,
           sdt_Sa2_Anteil1,
           sdt_Sa2_Anteil2,
           sdt_Sa2_Anteil3,
           sdt_Sa2_Anteil4,
           sdt_Sa2_Anteil5,
           sdt_Sb1_Anteil1,
           sdt_Sb1_Anteil2,
           sdt_Sb1_Anteil3,
           sdt_Sb1_Anteil4,
           sdt_Sb1_Anteil5,
           sdt_Sb2_Anteil1,
           sdt_Sb2_Anteil2,
           sdt_Sb2_Anteil3,
           sdt_Sb2_Anteil4,
           sdt_Sb2_Anteil5,
           sdt_Basis1,
           sdt_Basis2,
           sdt_Basis3,
           sdt_Basis4,
           sdt_Basis5,
           sdt_Basis6,
           sdt_Basis7,
           sdt_Basis8,
           sdt_Basis9,
           sdt_Basis10,
           sdt_Basis11,
           sdt_Basis12,
           sdt_Basis13,
           sdt_Basis14,
           sdt_Basis15,
           sdt_ExcludeSalaryCalc,
           sdt_IgnoreSparenCalc,
           sdt_IstAktiv,
           sdt_CreateDate,
           sdt_CreateUsrUId,
           sdt_MutDate,
           sdt_MutUsrUId,
           USR_C.usr_Login AS sdt_CreateUser,
           USR_M.usr_Login AS sdt_MutUser,
           sax_Typ,
           sax_Bezeichnung,
           sax_SpalteNr,
           int_Typ,
           int_Bezeichnung,
           SAL_A.sal_Typ             AS A_Sal_Typ,
           SAL_A.sal_Code            AS A_Sal_Code,
           SAL_A.sal_Bezeichnung     AS A_Sal_Bezeichnung,
           SAL_C.sal_Typ             AS C_Sal_Typ,
           SAL_C.sal_Code            AS C_Sal_Code,
           SAL_C.sal_Bezeichnung     AS C_Sal_Bezeichnung,
           SAL_Z.sal_Typ             AS Z_Sal_Typ,
           SAL_Z.sal_Code            AS Z_Sal_Code,
           SAL_Z.sal_Bezeichnung     AS Z_Sal_Bezeichnung,
           ACN_SOLL.acn_Konto        AS Soll_Acn_Konto,
           ACN_SOLL.acn_Bezeichnung  AS Soll_Acn_Bezeichnung,
           ACN_HABEN.acn_Konto       AS Haben_Acn_Konto,
           ACN_HABEN.acn_Bezeichnung AS Haben_Acn_Bezeichnung,
           sct_Typ,
           sct_Bezeichnung,
           sct_CalcType

      FROM sdt_SalaryDeductionType

      LEFT JOIN usr_User USR_C                ON sdt_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M                ON sdt_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN sax_SalaryCategorie           ON sdt_SaxUId       = sax_UId
      LEFT JOIN int_InstitutionType           ON sdt_IntUId       = int_UId
      LEFT JOIN sal_SalaryStatement SAL_A     ON sdt_A_SalUId     = SAL_A.sal_UId
      LEFT JOIN sal_SalaryStatement SAL_C     ON sdt_C_SalUId     = SAL_C.sal_UId
      LEFT JOIN sal_SalaryStatement SAL_Z     ON sdt_Z_SalUId     = SAL_Z.sal_UId
      LEFT JOIN acn_AccountNumber   ACN_SOLL  ON sdt_Soll_AcnUId  = ACN_SOLL.acn_UId
      LEFT JOIN acn_AccountNumber   ACN_HABEN ON sdt_Haben_AcnUId = ACN_HABEN.acn_UId
      LEFT JOIN sct_SalaryCalcType            ON sdt_SctUId       = sct_UId
           JOIN buy_BusinessYear              ON sdt_BuyUId       = buy_UId

     WHERE (
            :pi_BuyUId IS NULL
            OR
            sdt_BuyUId = :pi_BuyUId
           )
           AND
           (
            :ps_sdt_Typ IS NULL
            OR
            sdt_Typ = :ps_sdt_Typ
           )
           AND
           (
            :pb_sdt_IstAktiv IS NULL
            OR
            sdt_IstAktiv = :pb_sdt_IstAktiv
           )

  ORDER BY sdt_BuyUId, sdt_Typ, sdt_LArt

      INTO :sdt_UId,
           :sdt_BuyUId,
           :buy_GeschJahr,
           :sdt_Typ,
           :sdt_LArt,
           :sdt_Bezeichnung,
           :sdt_Text,
           :sdt_TextLohnAusweis,
           :sdt_SortNr,
           :sdt_SaxUId,
           :sdt_IntUId,
           :sdt_A_SalUId,
           :sdt_C_SalUId,
           :sdt_Z_SalUId,
           :sdt_Soll_AcnUId,
           :sdt_Haben_AcnUId,
           :sdt_IstNullAusgabe,
           :sdt_IstBearbeitbar,
           :sdt_Kommentar,
           :sdt_SctUId,
           :sdt_BerechBasisNr,
           :sdt_IstLohnTeil,
           :sdt_IstVariabel,
           :sdt_IstAutoBerechnung,
           :sdt_Lart_sdtUid,
           :sdt_InsInAbreTyp,
           :sdt_MinLohn,
           :sdt_MaxLohn,
           :sdt_Freibetrag,
           :sdt_MinPflichtLohn,
           :sdt_MaxPflichtLohn,
           :sdt_IstBesGradMin,
           :sdt_IstBesGradMax,
           :sdt_IstBesGradFrei,
           :sdt_IstBesGradMinPfl,
           :sdt_IstBesGradMaxPfl,
           :sdt_IstIVGradMin,
           :sdt_IstIVGradMax,
           :sdt_IstIVGradFrei,
           :sdt_IstIVGradMinPfl,
           :sdt_IstIVGradMaxPfl,
           :sdt_StdAbreTyp,
           :sdt_IstLehrlingFrei,
           :sdt_Ist8StdFrei,
           :sdt_Masseinheit,
           :sdt_IstZivilStand,
           :sdt_IstAbJahresLohn,
           :sdt_BerArtAbAlter,
           :sdt_BerArtBisAlter,
           :sdt_BisAlter1,
           :sdt_BisAlter2,
           :sdt_Ab1_1,
           :sdt_Ab1_2,
           :sdt_Ab1_3,
           :sdt_Ab1_4,
           :sdt_Ab1_5,
           :sdt_Ab2_1,
           :sdt_Ab2_2,
           :sdt_Ab2_3,
           :sdt_Ab2_4,
           :sdt_Ab2_5,
           :sdt_Sa1_Anteil1,
           :sdt_Sa1_Anteil2,
           :sdt_Sa1_Anteil3,
           :sdt_Sa1_Anteil4,
           :sdt_Sa1_Anteil5,
           :sdt_Sa2_Anteil1,
           :sdt_Sa2_Anteil2,
           :sdt_Sa2_Anteil3,
           :sdt_Sa2_Anteil4,
           :sdt_Sa2_Anteil5,
           :sdt_Sb1_Anteil1,
           :sdt_Sb1_Anteil2,
           :sdt_Sb1_Anteil3,
           :sdt_Sb1_Anteil4,
           :sdt_Sb1_Anteil5,
           :sdt_Sb2_Anteil1,
           :sdt_Sb2_Anteil2,
           :sdt_Sb2_Anteil3,
           :sdt_Sb2_Anteil4,
           :sdt_Sb2_Anteil5,
           :sdt_Basis1,
           :sdt_Basis2,
           :sdt_Basis3,
           :sdt_Basis4,
           :sdt_Basis5,
           :sdt_Basis6,
           :sdt_Basis7,
           :sdt_Basis8,
           :sdt_Basis9,
           :sdt_Basis10,
           :sdt_Basis11,
           :sdt_Basis12,
           :sdt_Basis13,
           :sdt_Basis14,
           :sdt_Basis15,
           :sdt_ExcludeSalaryCalc,
           :sdt_IgnoreSparenCalc,
           :sdt_IstAktiv,
           :sdt_CreateDate,
           :sdt_CreateUsrUId,
           :sdt_MutDate,
           :sdt_MutUsrUId,
           :sdt_CreateUser,
           :sdt_MutUser,
           :sax_Typ,
           :sax_Bezeichnung,
           :sax_SpalteNr,
           :int_Typ,
           :int_Bezeichnung,
           :A_Sal_Typ,
           :A_Sal_Code,
           :A_Sal_Bezeichnung,
           :C_Sal_Typ,
           :C_Sal_Code,
           :C_Sal_Bezeichnung,
           :Z_Sal_Typ,
           :Z_Sal_Code,
           :Z_Sal_Bezeichnung,
           :Soll_Acn_Konto,
           :Soll_Acn_Bezeichnung,
           :Haben_Acn_Konto,
           :Haben_Acn_Bezeichnung,
           :sct_Typ,
           :sct_Bezeichnung,
           :sct_CalcType

  DO BEGIN


     -- Korrekur-Lohnart fuer Taggelder ermitteln 

     PS_LART_KORR = NULL;

     IF (sdt_Lart_sdtUid is not NULL) THEN BEGIN             


        SELECT SDT_LART FROM sdt_SalaryDeductionType

            WHERE SDT_UID = :sdt_Lart_sdtUid

        INTO :PS_LART_KORR;             

     END


    SUSPEND;

  END
END!!

COMMENT ON PROCEDURE sp_Sdt_Select                 IS 'Select salary deduction type data by given filters'!!

COMMENT ON PARAMETER sp_Sdt_Select.pi_BuyUId       IS 'Business year UId'!!
COMMENT ON PARAMETER sp_Sdt_Select.ps_sdt_Typ      IS 'Salary deduction type'!!
COMMENT ON PARAMETER sp_Sdt_Select.pb_sdt_IstAktiv IS 'Flag, if true then select active records only'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sdt_SelectByUId
(
  pi_SdtUId     DI_UID
)
RETURNS
(
  sdt_UId                   DI_UID,
  sdt_LArt                  DS_STR5,
  sdt_BerechBasisNr         DI_SMLINT,
  sdt_Typ                   DS_ONECHARFLAG,  
  sdt_Bezeichnung           DS_DESCR,
  sdt_Text                  DS_DESCR,
  sdt_SortNr                DI_SMLINT,
  sdt_IstVariabel           DB_BOOLEAN,
  sdt_IstLohnTeil           DB_BOOLEAN,
  sdt_MassEinheit           DS_STR10,
  sdt_StdAbreTyp            DS_ONECHARFLAG, 
  sdt_InsInAbreTyp          DS_ONECHARFLAG,
  sdt_BuyUId                DI_UID,          
  sdt_LArt_SdtUId           DI_UID,
  
  sdt_MinLohn               DN_AMOUNT,
  sdt_MaxLohn               DN_AMOUNT,
  sdt_Freibetrag            DN_AMOUNT,
  sdt_MinPflichtLohn        DN_AMOUNT,
  sdt_MaxPflichtLohn        DN_AMOUNT,
  
  sdt_IstZivilstand         DB_BOOLEAN,    
  sdt_IstAbJahresLohn       DB_BOOLEAN,  
  sdt_IstLehrlingFrei       DB_BOOLEAN, 
  sdt_Ist8StdFrei           DB_BOOLEAN,  
  sdt_IstBesGradMin         DB_BOOLEAN,
  sdt_IstBesGradMax         DB_BOOLEAN,
  sdt_IstBesGradFrei        DB_BOOLEAN,
  sdt_IstBesGradMinPfl      DB_BOOLEAN,
  sdt_IstBesGradMaxPfl      DB_BOOLEAN,
  sdt_IstIVGradMin          DB_BOOLEAN,
  sdt_IstIVGradMax          DB_BOOLEAN,
  sdt_IstIVGradFrei         DB_BOOLEAN,
  sdt_IstIVGradMinPfl       DB_BOOLEAN,
  sdt_IstIVGradMaxPfl       DB_BOOLEAN,
  sdt_IstAutoBerechnung     DB_BOOLEAN,
  sdt_BerArtAbAlter         DS_ONECHARFLAG,
  sdt_BerArtBisAlter        DS_ONECHARFLAG,
  sdt_BisAlter1             DI_SMLINT,         
  sdt_BisAlter2             DI_SMLINT,        
  
  sdt_Ab1_1                 DI_INT,            
  sdt_Ab1_2                 DI_INT,             
  sdt_Ab1_3                 DI_INT,             
  sdt_Ab1_4                 DI_INT,            
  sdt_Ab1_5                 DI_INT,            
  sdt_Ab2_1                 DI_INT,             
  sdt_Ab2_2                 DI_INT,             
  sdt_Ab2_3                 DI_INT,            
  sdt_Ab2_4                 DI_INT,            
  sdt_Ab2_5                 DI_INT,             
  
  sdt_Sa1_Anteil1           DN_AMOUNT,
  sdt_Sa1_Anteil2           DN_AMOUNT,      
  sdt_Sa1_Anteil3           DN_AMOUNT,      
  sdt_Sa1_Anteil4           DN_AMOUNT,       
  sdt_Sa1_Anteil5           DN_AMOUNT,       
  sdt_Sa2_Anteil1           DN_AMOUNT,      
  sdt_Sa2_Anteil2           DN_AMOUNT,      
  sdt_Sa2_Anteil3           DN_AMOUNT,       
  sdt_Sa2_Anteil4           DN_AMOUNT,       
  sdt_Sa2_Anteil5           DN_AMOUNT,      
  sdt_Sb1_Anteil1           DN_AMOUNT,      
  sdt_Sb1_Anteil2           DN_AMOUNT,       
  sdt_Sb1_Anteil3           DN_AMOUNT,       
  sdt_Sb1_Anteil4           DN_AMOUNT,      
  sdt_Sb1_Anteil5           DN_AMOUNT,      
  sdt_Sb2_Anteil1           DN_AMOUNT,       
  sdt_Sb2_Anteil2           DN_AMOUNT,       
  sdt_Sb2_Anteil3           DN_AMOUNT,      
  sdt_Sb2_Anteil4           DN_AMOUNT,      
  sdt_Sb2_Anteil5           DN_AMOUNT,
  
  sdt_Basis1                DB_BOOLEAN,
  sdt_Basis2                DB_BOOLEAN,
  sdt_Basis3                DB_BOOLEAN,
  sdt_Basis4                DB_BOOLEAN,
  sdt_Basis5                DB_BOOLEAN,
  sdt_Basis6                DB_BOOLEAN,
  sdt_Basis7                DB_BOOLEAN,
  sdt_Basis8                DB_BOOLEAN,
  sdt_Basis9                DB_BOOLEAN,
  sdt_Basis10               DB_BOOLEAN,
  sdt_Basis11               DB_BOOLEAN,
  sdt_Basis12               DB_BOOLEAN,
  sdt_Basis13               DB_BOOLEAN,
  sdt_Basis14               DB_BOOLEAN,
  sdt_Basis15               DB_BOOLEAN,
  
  sdt_Kommentar             DS_STR255,
  sdt_IstBearbeitbar        DB_BOOLEAN,
  sdt_ExcludeSalaryCalc     DB_BOOLEAN,
  sdt_IgnoreSparenCalc      DB_BOOLEAN,
  sdt_SaxUId                DI_INT,
  
  sct_CalcType              DI_SMLINT,
  sct_Typ                   DS_ONECHARFLAG,
  sct_Bezeichnung           DS_DESCR,
  sct_UId                   DI_UID  
)
AS

  -- Select salary deduction type data by UId

BEGIN
  
  FOR
  
    SELECT sdt_UId,               sdt_LArt,             sdt_BerechBasisNr,     sdt_Typ,
           sdt_Bezeichnung,       sdt_Text,             sdt_SortNr,            sdt_IstVariabel,
           sdt_IstLohnTeil,       sdt_MassEinheit,      sdt_StdAbreTyp,        sdt_BuyUId,
           sdt_LArt_SdtUId,       sdt_MinLohn,          sdt_MaxLohn,           sdt_Freibetrag,
           sdt_MinPflichtLohn,    sdt_MaxPflichtLohn,   sdt_IstZivilstand,     sdt_IstAbJahresLohn,
           sdt_IstLehrlingFrei,   sdt_Ist8StdFrei,      sdt_IstBesGradMin,     sdt_IstBesGradMax,
           sdt_IstBesGradFrei,    sdt_IstBesGradMinPfl, sdt_IstBesGradMaxPfl,  sdt_IstIVGradMin,
           sdt_IstIVGradMax,      sdt_IstIVGradFrei,    sdt_IstIVGradMinPfl,   sdt_IstIVGradMaxPfl,
           sdt_IstAutoBerechnung, sdt_BerArtAbAlter,    sdt_BerArtBisAlter,    sdt_BisAlter1,
           sdt_BisAlter2,         sdt_Ab1_1,            sdt_Ab1_2,             sdt_Ab1_3, 
           sdt_Ab1_4,             sdt_Ab1_5,            sdt_Ab2_1,             sdt_Ab2_2, 
           sdt_Ab2_3,             sdt_Ab2_4,            sdt_Ab2_5,             sdt_Sa1_Anteil1,
           sdt_Sa1_Anteil2,       sdt_Sa1_Anteil3,      sdt_Sa1_Anteil4,       sdt_Sa1_Anteil5,
           sdt_Sa2_Anteil1,       sdt_Sa2_Anteil2,      sdt_Sa2_Anteil3,       sdt_Sa2_Anteil4,
           sdt_Sa2_Anteil5,       sdt_Sb1_Anteil1,      sdt_Sb1_Anteil2,       sdt_Sb1_Anteil3,
           sdt_Sb1_Anteil4,       sdt_Sb1_Anteil5,      sdt_Sb2_Anteil1,       sdt_Sb2_Anteil2,
           sdt_Sb2_Anteil3,       sdt_Sb2_Anteil4,      sdt_Sb2_Anteil5,       sdt_Basis1,
           sdt_Basis2,            sdt_Basis3,           sdt_Basis4,            sdt_Basis5,
           sdt_Basis6,            sdt_Basis7,           sdt_Basis8,            sdt_Basis9,
           sdt_Basis10,           sdt_Basis11,          sdt_Basis12,           sdt_Basis13,
           sdt_Basis14,           sdt_Basis15,          sdt_Kommentar,         sdt_IstBearbeitbar,
           sct_CalcType,          sct_Typ,              sct_Bezeichnung,       sdt_SctUId,
           sdt_InsInAbreTyp,      sdt_IstBearbeitbar,   sdt_ExcludeSalaryCalc, sdt_IgnoreSparenCalc,
           sdt_SaxUId           
      FROM sp_Sdt_Select( NULL, NULL, NULL )
     WHERE sdt_UId = :pi_SdtUID
     ORDER BY sdt_SctUId
      INTO :sdt_UId,               :sdt_LArt,             :sdt_BerechBasisNr,     :sdt_Typ,
           :sdt_Bezeichnung,       :sdt_Text,             :sdt_SortNr,            :sdt_IstVariabel,
           :sdt_IstLohnTeil,       :sdt_MassEinheit,      :sdt_StdAbreTyp,        :sdt_BuyUId,
           :sdt_LArt_SdtUId,       :sdt_MinLohn,          :sdt_MaxLohn,           :sdt_Freibetrag,
           :sdt_MinPflichtLohn,    :sdt_MaxPflichtLohn,   :sdt_IstZivilstand,     :sdt_IstAbJahresLohn,
           :sdt_IstLehrlingFrei,   :sdt_Ist8StdFrei,      :sdt_IstBesGradMin,     :sdt_IstBesGradMax,
           :sdt_IstBesGradFrei,    :sdt_IstBesGradMinPfl, :sdt_IstBesGradMaxPfl,  :sdt_IstIVGradMin,
           :sdt_IstIVGradMax,      :sdt_IstIVGradFrei,    :sdt_IstIVGradMinPfl,   :sdt_IstIVGradMaxPfl,
           :sdt_IstAutoBerechnung, :sdt_BerArtAbAlter,    :sdt_BerArtBisAlter,    :sdt_BisAlter1,
           :sdt_BisAlter2,         :sdt_Ab1_1,            :sdt_Ab1_2,             :sdt_Ab1_3, 
           :sdt_Ab1_4,             :sdt_Ab1_5,            :sdt_Ab2_1,             :sdt_Ab2_2, 
           :sdt_Ab2_3,             :sdt_Ab2_4,            :sdt_Ab2_5,             :sdt_Sa1_Anteil1,
           :sdt_Sa1_Anteil2,       :sdt_Sa1_Anteil3,      :sdt_Sa1_Anteil4,       :sdt_Sa1_Anteil5,
           :sdt_Sa2_Anteil1,       :sdt_Sa2_Anteil2,      :sdt_Sa2_Anteil3,       :sdt_Sa2_Anteil4,
           :sdt_Sa2_Anteil5,       :sdt_Sb1_Anteil1,      :sdt_Sb1_Anteil2,       :sdt_Sb1_Anteil3,
           :sdt_Sb1_Anteil4,       :sdt_Sb1_Anteil5,      :sdt_Sb2_Anteil1,       :sdt_Sb2_Anteil2,
           :sdt_Sb2_Anteil3,       :sdt_Sb2_Anteil4,      :sdt_Sb2_Anteil5,       :sdt_Basis1,
           :sdt_Basis2,            :sdt_Basis3,           :sdt_Basis4,            :sdt_Basis5,
           :sdt_Basis6,            :sdt_Basis7,           :sdt_Basis8,            :sdt_Basis9,
           :sdt_Basis10,           :sdt_Basis11,          :sdt_Basis12,           :sdt_Basis13,
           :sdt_Basis14,           :sdt_Basis15,          :sdt_Kommentar,         :sdt_IstBearbeitbar,
           :sct_CalcType,          :sct_Typ,              :sct_Bezeichnung,       :sct_UId,
           :sdt_InsInAbreTyp,      :sdt_IstBearbeitbar,   :sdt_ExcludeSalaryCalc, :sdt_IgnoreSparenCalc,
           :sdt_SaxUId           
  
  DO
    SUSPEND;
  
END!!

COMMENT ON PROCEDURE sp_Sdt_SelectByUId           IS 'Select salary deduction type data by UId'!!
COMMENT ON PARAMETER sp_Sdt_SelectByUId.pi_SdtUID IS 'Salary deduction type UId'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sdt_SelectBySayOrEmy
(
  pi_SayUId   DI_UID    DEFAULT NULL,
  ps_SdtTyp   DS_DESCR  DEFAULT NULL,
  pi_EmyUId   DI_UID    DEFAULT NULL
)
RETURNS
(
  emp_UId                   DI_UID,  
  emy_UId                   DI_UID, 
  emp_GeburtsDatum          DD_DATE, 
  emp_Geschlecht            DS_ONECHARFLAG,
  emp_Zivilstand            DS_ONECHARFLAG,
  emy_PjAnfang              DD_DATE, 
  emy_PjEnde                DD_DATE,
  emy_JahresLohn            DN_NUMBER2,
  emy_IstLehrling           DB_BOOLEAN,
  emy_IstWoStd8             DB_BOOLEAN,
  emy_BesGrad               DN_NUMBER2,
  emy_IVGrad                DN_NUMBER2,
  prm_Monat                 DI_SMLINT,
  prm_AbreNr                DI_SMLINT,
  
  sad_UId                   DI_UID,
  sad_SayUId                DI_UID,
  sad_SdtUId                DI_UID,
  sad_IstKorr               DB_BOOLEAN,
  sad_IstAuto               DB_BOOLEAN,
  sad_Text                  DS_DESCR,
  sad_SortNr                DI_SMLINT,
  sad_Total                 DN_NUMBER2,
  sad_BeitragAG             DN_NUMBER2,
  sad_BeitragAN             DN_NUMBER2,
  sad_Basis                 DN_NUMBER2,
  sad_AnsatzAG              DN_NUMBER4,
  sad_AnsatzAN              DN_NUMBER4,
  sad_Menge                 DN_NUMBER2,
  sad_Faktor                DN_NUMBER4,
  sad_Freibetrag            DN_NUMBER2,
  sad_AnzMorgen             DI_SMLINT,
  sad_AnzMittag             DI_SMLINT,
  sad_AnzAbend              DI_SMLINT,
  sad_AnzUnterkunft         DI_SMLINT,
  sad_IstAktiv              DB_ISACTIVE,
  sad_CreateDate            DD_TIMESTAMP,
  sad_CreateUsrUId          DI_UID,
  sad_MutDate               DD_TIMESTAMP,
  sad_MutUsrUId             DI_UID,
  
  say_DatumVom              DD_DATE,
  say_DatumBis              DD_DATE,
  say_PraUId                DI_UID,
  
  sdt_LArt                  DS_STR5,
  sdt_BerechBasisNr         DI_SMLINT,
  sdt_Typ                   DS_ONECHARFLAG,  
  sdt_Bezeichnung           DS_DESCR,
  sdt_Text                  DS_DESCR,
  sdt_SortNr                DI_SMLINT,
  sdt_UId                   DI_UID,
  sdt_IstVariabel           DB_BOOLEAN,
  sdt_IstLohnTeil           DB_BOOLEAN,
  sdt_MassEinheit           DS_STR10,
  sdt_StdAbreTyp            DS_ONECHARFLAG, 
  sdt_InsInAbreTyp          DS_ONECHARFLAG,  
  sdt_BuyUId                DI_UID,          
  sdt_LArt_SdtUId           DI_UID,
  
  sdt_MinLohn               DN_AMOUNT,
  sdt_MaxLohn               DN_AMOUNT,
  sdt_Freibetrag            DN_AMOUNT,
  sdt_MinPflichtLohn        DN_AMOUNT,
  sdt_MaxPflichtLohn        DN_AMOUNT,
  
  sdt_IstZivilstand         DB_BOOLEAN,    
  sdt_IstAbJahresLohn       DB_BOOLEAN,  
  sdt_IstLehrlingFrei       DB_BOOLEAN, 
  sdt_Ist8StdFrei           DB_BOOLEAN,  
  sdt_IstBesGradMin         DB_BOOLEAN,
  sdt_IstBesGradMax         DB_BOOLEAN,
  sdt_IstBesGradFrei        DB_BOOLEAN,
  sdt_IstBesGradMinPfl      DB_BOOLEAN,
  sdt_IstBesGradMaxPfl      DB_BOOLEAN,
  sdt_IstIVGradMin          DB_BOOLEAN,
  sdt_IstIVGradMax          DB_BOOLEAN,
  sdt_IstIVGradFrei         DB_BOOLEAN,
  sdt_IstIVGradMinPfl       DB_BOOLEAN,
  sdt_IstIVGradMaxPfl       DB_BOOLEAN,
  sdt_IstAutoBerechnung     DB_BOOLEAN,
  sdt_BerArtAbAlter         DS_ONECHARFLAG,
  sdt_BerArtBisAlter        DS_ONECHARFLAG,
  sdt_BisAlter1             DI_SMLINT,         
  sdt_BisAlter2             DI_SMLINT,        
  
  sdt_Ab1_1                 DI_INT,            
  sdt_Ab1_2                 DI_INT,             
  sdt_Ab1_3                 DI_INT,             
  sdt_Ab1_4                 DI_INT,            
  sdt_Ab1_5                 DI_INT,            
  sdt_Ab2_1                 DI_INT,             
  sdt_Ab2_2                 DI_INT,             
  sdt_Ab2_3                 DI_INT,            
  sdt_Ab2_4                 DI_INT,            
  sdt_Ab2_5                 DI_INT,             
  
  sdt_Sa1_Anteil1           DN_AMOUNT,
  sdt_Sa1_Anteil2           DN_AMOUNT,      
  sdt_Sa1_Anteil3           DN_AMOUNT,      
  sdt_Sa1_Anteil4           DN_AMOUNT,       
  sdt_Sa1_Anteil5           DN_AMOUNT,       
  sdt_Sa2_Anteil1           DN_AMOUNT,      
  sdt_Sa2_Anteil2           DN_AMOUNT,      
  sdt_Sa2_Anteil3           DN_AMOUNT,       
  sdt_Sa2_Anteil4           DN_AMOUNT,       
  sdt_Sa2_Anteil5           DN_AMOUNT,      
  sdt_Sb1_Anteil1           DN_AMOUNT,      
  sdt_Sb1_Anteil2           DN_AMOUNT,       
  sdt_Sb1_Anteil3           DN_AMOUNT,       
  sdt_Sb1_Anteil4           DN_AMOUNT,      
  sdt_Sb1_Anteil5           DN_AMOUNT,      
  sdt_Sb2_Anteil1           DN_AMOUNT,       
  sdt_Sb2_Anteil2           DN_AMOUNT,       
  sdt_Sb2_Anteil3           DN_AMOUNT,         
  sdt_Sb2_Anteil4           DN_AMOUNT,      
  sdt_Sb2_Anteil5           DN_AMOUNT,
  
  sdt_Basis1                DB_BOOLEAN,
  sdt_Basis2                DB_BOOLEAN,
  sdt_Basis3                DB_BOOLEAN,
  sdt_Basis4                DB_BOOLEAN,
  sdt_Basis5                DB_BOOLEAN,
  sdt_Basis6                DB_BOOLEAN,
  sdt_Basis7                DB_BOOLEAN,
  sdt_Basis8                DB_BOOLEAN,
  sdt_Basis9                DB_BOOLEAN,
  sdt_Basis10               DB_BOOLEAN,
  sdt_Basis11               DB_BOOLEAN,
  sdt_Basis12               DB_BOOLEAN,
  sdt_Basis13               DB_BOOLEAN,
  sdt_Basis14               DB_BOOLEAN,
  sdt_Basis15               DB_BOOLEAN,
  sdt_Kommentar             DS_STR255,
  sdt_IstBearbeitbar        DB_BOOLEAN,
  
  sdt_ExcludeSalaryCalc     DB_BOOLEAN,
  sdt_IgnoreSparenCalc      DB_BOOLEAN,
  sdt_SaxUId                DI_UID,  
  
  sct_CalcType              DI_SMLINT,
  sct_UId                   DI_UID
)
AS

  -- Select salary deduction type, salary detail, employee data for payroll account recalculation
  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iSayUId              DI_UID;

BEGIN

  iSayUId = pi_SayUId;

  IF ( iSayUId IS NULL AND pi_EmyUId IS NOT NULL ) THEN
  BEGIN
    
    SELECT say_UId
      FROM pra_PayrollAccount,
           prm_PayrollMonth,
           say_Salary
     WHERE pra_PrmUId = prm_UId
       AND say_PraUId = pra_UId
       AND say_EmyUId = :pi_EmyUId
       AND prm_Monat  = 0
      INTO :iSayUId;
    
  END
  
  IF ( iSayUId IS NULL ) THEN EXIT;
  
  SELECT prm_Monat, prm_AbreNr
    FROM pra_PayrollAccount
    JOIN prm_PayrollMonth ON prm_UId    = pra_PrmUId
    JOIN say_Salary       ON say_PraUId = pra_UId
   WHERE say_UId = :iSayUId
    INTO :prm_Monat, :prm_AbreNr;
  
  FOR
  
    SELECT sad_UId,               sad_SayUId,           sad_SdtUId,           sad_IstKorr,        
           sad_IstAuto,           sad_Text,             sad_SortNr,           sad_Total,            
           sad_BeitragAG,         sad_BeitragAN,        sad_Basis,            sad_AnsatzAG,         
           sad_AnsatzAN,          sad_Menge,            sad_Faktor,           sad_Freibetrag,      
           sad_AnzMorgen,         sad_AnzMittag,        sad_AnzAbend,         sad_AnzUnterkunft,
           sad_IstAktiv,          sad_CreateDate,       sad_CreateUsrUId,     sad_MutDate,        
           sad_MutUsrUId,         say_DatumVom,         say_DatumBis,         say_PraUId,
           sdt_LArt,              sdt_BerechBasisNr,    sdt_Bezeichnung,      sdt_Text,             
           sdt_Typ,               sdt_SortNr,           sdt_UId,              sdt_IstVariabel,      
           sdt_IstLohnTeil,       sdt_MassEinheit,      sdt_StdAbreTyp,       sdt_BuyUId,          
           sdt_LArt_SdtUId,       sdt_MinLohn,          sdt_MaxLohn,          sdt_Freibetrag,
           sdt_MinPflichtLohn,    sdt_MaxPflichtLohn,   sdt_IstZivilstand,    sdt_IstAbJahresLohn,  
           sdt_IstLehrlingFrei,   sdt_Ist8StdFrei,      sdt_IstBesGradMin,    sdt_IstBesGradMax,    
           sdt_IstBesGradFrei,    sdt_IstBesGradMinPfl, sdt_IstBesGradMaxPfl, sdt_IstIVGradMin,     
           sdt_IstIVGradMax,      sdt_IstIVGradFrei,    sdt_IstIVGradMinPfl,  sdt_IstIVGradMaxPfl,  
           sdt_IstAutoBerechnung, sdt_BerArtAbAlter,    sdt_BerArtBisAlter,   sdt_BisAlter1,        
           sdt_BisAlter2,         sdt_Ab1_1,            sdt_Ab1_2,            sdt_InsInAbreTyp,
           sdt_Ab1_3,             sdt_Ab1_4,            sdt_Ab1_5,            sdt_Ab2_1,
           sdt_Ab2_2,             sdt_Ab2_3,            sdt_Ab2_4,            sdt_Ab2_5,
           sdt_Sa1_Anteil1,       sdt_Sa1_Anteil2,      sdt_Sa1_Anteil3,      sdt_Sa1_Anteil4,
           sdt_Sa1_Anteil5,       sdt_Sa2_Anteil1,      sdt_Sa2_Anteil2,      sdt_Sa2_Anteil3,
           sdt_Sa2_Anteil4,       sdt_Sa2_Anteil5,      sdt_Sb1_Anteil1,      sdt_Sb1_Anteil2,
           sdt_Sb1_Anteil3,       sdt_Sb1_Anteil4,      sdt_Sb1_Anteil5,      sdt_Sb2_Anteil1,
           sdt_Sb2_Anteil2,       sdt_Sb2_Anteil3,      sdt_Sb2_Anteil4,      sdt_Sb2_Anteil5,
           sdt_Basis1,            sdt_Basis2,           sdt_Basis3,           sdt_Basis4,
           sdt_Basis5,            sdt_Basis6,           sdt_Basis7,           sdt_Basis8,
           sdt_Basis9,            sdt_Basis10,          sdt_Basis11,          sdt_Basis12,
           sdt_Basis13,           sdt_Basis14,          sdt_Basis15,          sct_CalcType,
           emp_UId,               emy_UId,              emp_GeburtsDatum,     emp_Geschlecht,
           emp_Zivilstand,        emy_PjAnfang,         emy_PjEnde,           emy_JahresLohn,     
           emy_IstLehrling,       emy_IstWoStd8,        emy_BesGrad,          emy_IVGrad,
           sct_UId,               sdt_Kommentar,        sdt_IstBearbeitbar,   sdt_ExcludeSalaryCalc,
           sdt_IgnoreSparenCalc,  sdt_SaxUId
       FROM say_Salary 
       LEFT JOIN emy_EmploymentPeriod    ON emy_UID    = say_EmyUID 
       LEFT JOIN emp_Employee            ON emp_UID    = emy_EmpUID 
      INNER JOIN sad_SalaryDetail        ON sad_SayUID = say_UID    
       LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_SdtUId 
       LEFT JOIN sct_SalaryCalcType      ON sct_UId    = sdt_SctUId
     WHERE ( :iSayUId   IS NULL OR :iSayUId   = say_UId   )
       AND ( :ps_SdtTyp IS NULL OR :ps_SdtTyp = sdt_Typ   )       
     ORDER BY sdt_Typ DESC, sct_UId, sad_SortNr
      INTO :sad_UId,               :sad_SayUId,           :sad_SdtUId,           :sad_IstKorr,        
           :sad_IstAuto,           :sad_Text,             :sad_SortNr,           :sad_Total,            
           :sad_BeitragAG,         :sad_BeitragAN,        :sad_Basis,            :sad_AnsatzAG,         
           :sad_AnsatzAN,          :sad_Menge,            :sad_Faktor,           :sad_Freibetrag,      
           :sad_AnzMorgen,         :sad_AnzMittag,        :sad_AnzAbend,         :sad_AnzUnterkunft,
           :sad_IstAktiv,          :sad_CreateDate,       :sad_CreateUsrUId,     :sad_MutDate,        
           :sad_MutUsrUId,         :say_DatumVom,         :say_DatumBis,         :say_PraUId,
           :sdt_LArt,              :sdt_BerechBasisNr,    :sdt_Bezeichnung,      :sdt_Text,             
           :sdt_Typ,               :sdt_SortNr,           :sdt_UId,              :sdt_IstVariabel,      
           :sdt_IstLohnTeil,       :sdt_MassEinheit,      :sdt_StdAbreTyp,       :sdt_BuyUId,          
           :sdt_LArt_SdtUId,       :sdt_MinLohn,          :sdt_MaxLohn,          :sdt_Freibetrag,
           :sdt_MinPflichtLohn,    :sdt_MaxPflichtLohn,
           :sdt_IstZivilstand,     :sdt_IstAbJahresLohn,  :sdt_IstLehrlingFrei, 
           :sdt_Ist8StdFrei,       :sdt_IstBesGradMin,    :sdt_IstBesGradMax,    :sdt_IstBesGradFrei,  
           :sdt_IstBesGradMinPfl,  :sdt_IstBesGradMaxPfl, :sdt_IstIVGradMin,     :sdt_IstIVGradMax,    
           :sdt_IstIVGradFrei,     :sdt_IstIVGradMinPfl,  :sdt_IstIVGradMaxPfl,  :sdt_IstAutoBerechnung, 
           :sdt_BerArtAbAlter,     :sdt_BerArtBisAlter,   :sdt_BisAlter1,        :sdt_BisAlter2,        
           :sdt_Ab1_1,             :sdt_Ab1_2,            :sdt_InsInAbreTyp,
           :sdt_Ab1_3,             :sdt_Ab1_4,            :sdt_Ab1_5,            :sdt_Ab2_1,
           :sdt_Ab2_2,             :sdt_Ab2_3,            :sdt_Ab2_4,            :sdt_Ab2_5,
           :sdt_Sa1_Anteil1,       :sdt_Sa1_Anteil2,      :sdt_Sa1_Anteil3,      :sdt_Sa1_Anteil4,
           :sdt_Sa1_Anteil5,       :sdt_Sa2_Anteil1,      :sdt_Sa2_Anteil2,      :sdt_Sa2_Anteil3,
           :sdt_Sa2_Anteil4,       :sdt_Sa2_Anteil5,      :sdt_Sb1_Anteil1,      :sdt_Sb1_Anteil2,
           :sdt_Sb1_Anteil3,       :sdt_Sb1_Anteil4,      :sdt_Sb1_Anteil5,      :sdt_Sb2_Anteil1,
           :sdt_Sb2_Anteil2,       :sdt_Sb2_Anteil3,      :sdt_Sb2_Anteil4,      :sdt_Sb2_Anteil5,
           :sdt_Basis1,            :sdt_Basis2,           :sdt_Basis3,           :sdt_Basis4,
           :sdt_Basis5,            :sdt_Basis6,           :sdt_Basis7,           :sdt_Basis8,
           :sdt_Basis9,            :sdt_Basis10,          :sdt_Basis11,          :sdt_Basis12,
           :sdt_Basis13,           :sdt_Basis14,          :sdt_Basis15,          :sct_CalcType,
           :emp_UId,               :emy_UId,              :emp_GeburtsDatum,     :emp_Geschlecht,
           :emp_Zivilstand,        :emy_PjAnfang,         :emy_PjEnde,           :emy_JahresLohn,     
           :emy_IstLehrling,       :emy_IstWoStd8,        :emy_BesGrad,          :emy_IVGrad,
           :sct_UId,               :sdt_Kommentar,        :sdt_IstBearbeitbar,   :sdt_ExcludeSalaryCalc,
           :sdt_IgnoreSparenCalc,  :sdt_SaxUId

  DO
  BEGIN
    
    IF ( sdt_Typ = 'L' AND sct_CalcType = 5 ) THEN
    BEGIN
    
      EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :sdt_BuyUId )
       RETURNING_VALUES :bIsIndustrieMinuten;
      
      EXECUTE PROCEDURE sp_WorkMinutesToHours( :sad_Menge, :bIsIndustrieMinuten )
       RETURNING_VALUES :sad_Menge;
      
    END
    
    SUSPEND;    
    
  END  
  
END!!

COMMENT ON PROCEDURE sp_Sdt_SelectBySayOrEmy IS 'Select salary deduction type, salary detail, employee data for payroll account recalculation'!!
COMMENT ON PARAMETER sp_Sdt_SelectBySayOrEmy.pi_SayUId IS 'Salary UId'!!
COMMENT ON PARAMETER sp_Sdt_SelectBySayOrEmy.ps_SdtTyp IS 'Salary deduction type'!!
COMMENT ON PARAMETER sp_Sdt_SelectBySayOrEmy.pi_EmyUId IS 'Employment period UId'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
  PI_FIIUID  DI_UID,
  PI_EMPUID  DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID  DI_UID = NULL,
  PI_CATUID  DI_UID = NULL,
  PI_PRGUID  DI_UID = NULL)
RETURNS 
(
  EMP_UID            DI_UID,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  TG_LOHN_PFLICHT    DN_NUMBER2,
  TG_BETRAG_AG       DN_NUMBER2,
  TG_BETRAG_AN       DN_NUMBER2,
  PF_LOHN_PFLICHT    DN_NUMBER2,
  PF_BETRAG_AG       DN_NUMBER2,
  PF_BETRAG_AN       DN_NUMBER2
)
AS

-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18) THEN BEGIN                    -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19) THEN BEGIN           -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ( SAD_BEITRAGAG > 0 OR SAD_BEITRAGAN > 0 )

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALKK IS'Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALPK 
(
  PI_FIIUID DI_UID,
  PI_EMPUID DI_UID  = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID  = NULL,
  PI_CATUID DI_UID  = NULL,
  PI_PRGUID DI_UID  = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  EMY_UID            DI_UID,
  EMY_PJANFANG       DD_DATE,
  EMY_PJENDE         DD_DATE,
  EMY_BESGRAD        DN_NUMBER2,
  EMY_ISUNEMPLOYED   DB_BOOLEAN,
  LOHN_BRUTTO        DN_NUMBER2,
  LOHN_AHV           DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
DECLARE VARIABLE IEMY_UID   DI_UID;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( T.SDT_EXCLUDESALARYCALC = 0     )
             AND ( SAD_BEITRAGAG > 0 OR SAD_BEITRAGAN > 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALPK IS 'Get data for the report: Annual \ Jahresabrechnung PK (PK Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALUNF 
(
    PI_FIIUID  DI_UID,
    PI_EMPUID  DI_UID = NULL,
    PI_LANDUID DI_UID = NULL,
    PI_DEPUID  DI_UID = NULL,
    PI_CATUID  DI_UID = NULL,
    PI_PRGUID  DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    AHV_LOHN           DN_NUMBER2,
    AHV_LOHN_NP        DN_NUMBER2,
    AHV_LOHN_US        DN_NUMBER2,
    BU_LOHN            DN_NUMBER2,
    STD8_LOHN          DN_NUMBER2,
    NBU_LOHN           DN_NUMBER2,
    BEITRAG_BU         DN_NUMBER2,
    BEITRAG_NBU        DN_NUMBER2
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     AHV_LOHN    = 0;
     AHV_LOHN_NP = 0;
     AHV_LOHN_US = 0;
     BU_LOHN     = 0;
     STD8_LOHN   = 0;
     NBU_LOHN    = 0;
     BEITRAG_BU  = 0;
     BEITRAG_NBU = 0;

     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn ;   


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;   


      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;

      AHV_LOHN    = nAHVLohnPfl;
      AHV_LOHN_NP = nAHVLohn - nAHVLohnPfl;



     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 0)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 3)
        AND (T.SDT_SAXUID = 13)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   


      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

      AHV_LOHN_US = nNBULohn - nNBULohnPfl;
      
 
      -- BU-Pflichtiger Lohn----
      BU_LOHN     = AHV_LOHN + AHV_LOHN_NP - AHV_LOHN_US;


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
        AND (Y.EMY_ISTWOSTD8 = 1)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_BERECHBASISNR = 1)
        AND ( T.SDT_EXCLUDESALARYCALC = 0)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))


      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      STD8_LOHN = nAHVUnter8Std;

      NBU_LOHN  = BU_LOHN - nAHVUnter8Std;


     -- Beitraege AG und AN rechnen ----

     SELECT SUM(D.SAD_BEITRAGAG),
            SUM(D.SAD_BEITRAGAN)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
            (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
            (T.SDT_SAXUID in (13,14))

     INTO :BEITRAG_BU,
          :BEITRAG_NBU;


     -- Personalien des MA's ----

      SELECT E.EMP_PERSNR,
             E.EMP_PEIDNR,
             E.EMP_NAME,
             E.EMP_VORNAME,
             E.EMP_STRASSE,
             E.emp_HausNr,
             C.COI_ISOCODE,
             E.EMP_PLZ,
             E.EMP_ORT, 
             E.EMP_GEBURTSDATUM, 
             E.EMP_PENSIONDATUM, 
             E.EMP_GESCHLECHT,
             E.EMP_EINTRITTSDATUM,
             E.EMP_AUSTRITTSDATUM


       FROM EMP_EMPLOYEE E

       LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

       WHERE E.EMP_UID = :EMP_UID

       INTO :EMP_PERSNR,
            :EMP_PEIDNR,
            :EMP_NAME,
            :EMP_VORNAME,
            :EMP_STRASSE,
            :emp_HausNr,
            :COI_ISOCODE,
            :EMP_PLZ,
            :EMP_ORT, 
            :EMP_GEBURTSDATUM, 
            :EMP_PENSIONDATUM, 
            :EMP_GESCHLECHT,
            :EMP_EINTRITTSDATUM,
            :EMP_AUSTRITTSDATUM;


      SUSPEND;

  END

END!!

COMMENT ON PROCEDURE SP_RPT_ANNUALUNF IS 'Get data for the report: Annual \ Jahresabrechnung UNF (UNF Annual)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_PERIOD_HLP 
(
  PI_EMYUID DI_UID,
  PS_INT_TYP DS_STR3
)
RETURNS 
(
  EMP_UID          DI_UID,
  SAX_UID          DI_UID,
  EMY_UID          DI_UID,
  EMY_PJANFANG     DD_DATE,
  EMY_PJENDE       DD_DATE,
  EMY_BESGRAD      DN_NUMBER2,
  EMY_ISUNEMPLOYED DB_BOOLEAN,
  BRUTTOLOHN       DN_NUMBER2,
  FREIBETRAG       DN_NUMBER2,
  PFLICHTLOHN      DN_NUMBER2,
  BEITRAGAG        DN_NUMBER2,
  BEITRAGAN        DN_NUMBER2
)
AS

DECLARE VARIABLE BOK         DI_SMLINT;
DECLARE VARIABLE IBUYUID     DN_NUMBER2;
DECLARE VARIABLE NPFLICHT    DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG  DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN  DN_NUMBER2;
DECLARE VARIABLE NFREIBETRAG DN_NUMBER2;

BEGIN
     
    SELECT EMY_UID,EMY_PJANFANG,EMY_PJENDE,EMY_BESGRAD,EMY_ISUNEMPLOYED FROM EMY_EMPLOYMENTPERIOD
        WHERE EMY_UID=:PI_EMYUID
    INTO :EMY_UID,:EMY_PJANFANG,:EMY_PJENDE,:EMY_BESGRAD,:EMY_ISUNEMPLOYED;

    -- Bruttolohn fuer Periode rechnen  --------------------------------------------
    SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (Y.EMY_UID=:PI_EMYUID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :BRUTTOLOHN;   


    -- Basis(pflichtiger Lohn) und Beitraege rechnen ------------------------------
    bOk = 0;


    SELECT E.EMP_BUYUID FROM EMY_EMPLOYMENTPERIOD Y
      LEFT JOIN EMP_EMPLOYEE E ON E.EMP_UID=Y.EMY_EMPUID
        WHERE Y.EMY_UID=:PI_EMYUID
    INTO :iBuyUId;

    FOR SELECT DISTINCT TX.SAX_UID
        FROM EMP_EMPLOYEE E   
        INNER JOIN EMY_EMPLOYMENTPERIOD Y ON Y.EMY_EMPUID=E.EMP_UID
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
        WHERE (E.EMP_BUYUID=:iBuyUId) AND (A.PRA_ISTVERBUCHT = 1) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND
              (TI.INT_TYP=:PS_INT_TYP)

        ORDER BY TX.SAX_UID
        INTO :SAX_UID

    DO BEGIN

       bOk = 1;

       NPFLICHT    = 0.0;
       NBEITRAGAG  = 0.0;
       NBEITRAGAN  = 0.0;
       NFREIBETRAG = 0.0;


       --  Alle Lohnarten "Prozent von BASIS" ------------------------------------------
       SELECT SUM(D.SAD_BASIS)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (T.SDT_EXCLUDESALARYCALC = 0)
        AND (C.SCT_CALCTYPE in (2,3,4))
        AND (Y.EMY_UID=:PI_EMYUID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NPFLICHT;

       IF (NPFLICHT    IS NULL) THEN NPFLICHT    = 0.0;        

       PFLICHTLOHN   = NPFLICHT;


       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN),
              MAX(D.SAD_FREIBETRAG)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID)
        AND (T.SDT_TYP = 'A')
        AND (T.SDT_ISTLOHNTEIL = 1)
        AND (C.SCT_CALCTYPE in (2,3,4))
        AND (Y.EMY_UID=:PI_EMYUID)
        AND (A.PRA_ISTVERBUCHT = 1)
        AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NBEITRAGAG,:NBEITRAGAN, :NFREIBETRAG;

       IF (NBEITRAGAG  IS NULL) THEN NBEITRAGAG  = 0.0;        
       IF (NBEITRAGAN  IS NULL) THEN NBEITRAGAN  = 0.0;        
       IF (NFREIBETRAG IS NULL) THEN NFREIBETRAG = 0.0; 

       BEITRAGAG     = NBEITRAGAG;
       BEITRAGAN     = NBEITRAGAN;
       FREIBETRAG    = NFREIBETRAG;


       --  Alle Lohnarten NICHT "Prozent von BASIS" ------------------------------------
       NPFLICHT   = 0.0;
       NBEITRAGAG = 0.0;
       NBEITRAGAN = 0.0;

       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE not in (2,3,4)) 
             AND (Y.EMY_UID=:PI_EMYUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        

       --  Total fuer Rueckgabe ---------------------------------------------------------

       PFLICHTLOHN   = PFLICHTLOHN + NPFLICHT;
       BEITRAGAG     = BEITRAGAG   + NBEITRAGAG;
       BEITRAGAN     = BEITRAGAN   + NBEITRAGAN;


       SUSPEND;

    END
  

    -- Bruttolohn zurueckgaben, falls keine Abzuege (zB bei STE)
    IF (bOk = 0) THEN 
       SUSPEND;

END!!

COMMENT ON PROCEDURE SP_RPT_PERIOD_HLP IS 'Helper procedure: get detail data per Period for procedure sp_Rpt_AnnualXXX; Rports Annual'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERALV 
(
  PI_FIIUID DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID DI_UID = NULL,
  PI_LANDUID DI_UID = NULL,
  PI_DEPUID DI_UID = NULL,
  PI_CATUID DI_UID = NULL,
  PI_PRGUID DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE,
  EMP_AUFENTHALT     DS_ONECHARFLAG,
  EMP_AUFENTHALT_BEZ DS_DESCR
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_ALV_FIIUID IS NOT NULL) AND (EMP_ALV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM,
               E.EMP_AUFENTHALT


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM,
              :EMP_AUFENTHALT; 

 
         -- Bezeichnung des Aufentalts ---
         EMP_AUFENTHALT_BEZ = '';
         SELECT LUK_BEZEICHNUNG FROM LUK_LOOKUP 
              WHERE LUK_GRUPPE = 'AUFENTHALT' AND LUK_CODE=:EMP_AUFENTHALT
         INTO :EMP_AUFENTHALT_BEZ;   


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERALV IS 'Get data for the report: Quarter \ ALV Quartalsmeldung (ALV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERAHV 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
  EMP_UID            DI_UID,
  PRM_MONATVON       DI_SMLINT,
  PRM_MONATBIS       DI_SMLINT,
  LOHN_BRUTTO        DN_NUMBER2,
  K1_SAXUID          DI_UID,
  K1_SAXBEZ          DS_DESCR,
  K1_PFLICHT         DN_NUMBER2,
  K1_FREIBETRAG      DN_NUMBER2,
  K1_BEITRAG_AN      DN_NUMBER2,
  K1_BEITRAG_AG      DN_NUMBER2,
  K2_SAXUID          DI_UID,
  K2_SAXBEZ          DS_DESCR,
  K2_PFLICHT         DN_NUMBER2,
  K2_FREIBETRAG      DN_NUMBER2,
  K2_BEITRAG_AN      DN_NUMBER2,
  K2_BEITRAG_AG      DN_NUMBER2,
  K3_SAXUID          DI_UID,
  K3_SAXBEZ          DS_DESCR,
  K3_PFLICHT         DN_NUMBER2,
  K3_FREIBETRAG      DN_NUMBER2,
  K3_BEITRAG_AN      DN_NUMBER2,
  K3_BEITRAG_AG      DN_NUMBER2,
  K4_SAXUID          DI_UID,
  K4_SAXBEZ          DS_DESCR,
  K4_PFLICHT         DN_NUMBER2,
  K4_FREIBETRAG      DN_NUMBER2,
  K4_BEITRAG_AN      DN_NUMBER2,
  K4_BEITRAG_AG      DN_NUMBER2,
  BUY_GESCHJAHR      DI_BUSINESSYEAR,
  FIR_CODE           DS_CODE,
  FIR_BEZEICHNUNG    DS_DESCR,
  FIR_BEZEICHNUNG2   DS_STR50,
  FIR_STRASSE        DS_STR50,
  FIR_HAUSNR         DS_STR5,
  FIR_PLZ            DS_PLZ,
  FIR_ORT            DS_STR50,
  FII_ABRECHNUNGNR   DS_STR20,
  FII_CODE           DS_CODE,
  FII_NAME           DS_STR50,
  FII_NAMEZUSATZ     DS_STR50,
  FII_STRASSE        DS_STR50,
  FII_PLZ            DS_PLZ,
  FII_ORT            DS_STR50,
  EMP_PERSNR         DI_INT,
  EMP_PEIDNR         DS_STR20,
  EMP_NAME           DS_STR50,
  EMP_VORNAME        DS_STR50,
  EMP_STRASSE        DS_STR50,
  EMP_HAUSNR         DS_STR5,
  COI_ISOCODE        DS_CODE,
  EMP_PLZ            DS_PLZ,
  EMP_ORT            DS_STR50,
  EMP_GEBURTSDATUM   DD_DATE,
  EMP_PENSIONDATUM   DD_DATE,
  EMP_GESCHLECHT     DS_ONECHARFLAG,
  EMP_EINTRITTSDATUM DD_DATE,
  EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT      VARCHAR(512);
DECLARE VARIABLE IBUYUID    DI_UID;
DECLARE VARIABLE SINTTYP    DS_STR3;
DECLARE VARIABLE ICOUNTER   DI_SMLINT;
DECLARE VARIABLE ISAXUID    DI_UID;
DECLARE VARIABLE SSAXBEZ    DS_DESCR;
DECLARE VARIABLE NFREI      DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_AHV_FIIUID IS NOT NULL) AND (EMP_AHV_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     iCounter = 0;


     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;


     FOR SELECT SAX_UID,
                MONATVON,
                MONATBIS,
                BRUTTOLOHN,
                FREIBETRAG,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :PRM_MONATVON,
              :PRM_MONATBIS,
              :LOHN_BRUTTO, 
              :nFrei, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
        INTO :sSaxBez;

        iCounter = iCounter + 1; 

        IF (iCounter = 1) THEN BEGIN        

           K1_SAXUID     = iSaxUID;
           K1_SAXBEZ     = sSaxBez;
           K1_PFLICHT    = nPflicht;
           K1_FREIBETRAG = nFrei;
           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 2) THEN BEGIN        

           K2_SAXUID     = iSaxUID;
           K2_SAXBEZ     = sSaxBez;
           K2_PFLICHT    = nPflicht;
           K2_FREIBETRAG = nFrei;
           K2_BEITRAG_AN = nBeitragAN;
           K2_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 3) THEN BEGIN        

           K3_SAXUID     = iSaxUID;
           K3_SAXBEZ     = sSaxBez;
           K3_PFLICHT    = nPflicht;
           K3_FREIBETRAG = nFrei;
           K3_BEITRAG_AN = nBeitragAN;
           K3_BEITRAG_AG = nBeitragAG;

        END ELSE IF (iCounter = 4) THEN BEGIN        

           K4_SAXUID     = iSaxUID;
           K4_SAXBEZ     = sSaxBez;
           K4_PFLICHT    = nPflicht;
           K4_FREIBETRAG = nFrei;
           K4_BEITRAG_AN = nBeitragAN;
           K4_BEITRAG_AG = nBeitragAG;

        END

     END

     IF (iCounter > 0) THEN BEGIN

        -- Get data from Employee
        SELECT E.EMP_PERSNR,
               E.EMP_PEIDNR,
               E.EMP_NAME,
               E.EMP_VORNAME,
               E.EMP_STRASSE,
               E.emp_HausNr,
               C.COI_ISOCODE,
               E.EMP_PLZ,
               E.EMP_ORT, 
               E.EMP_GEBURTSDATUM, 
               E.EMP_PENSIONDATUM, 
               E.EMP_GESCHLECHT,
               E.EMP_EINTRITTSDATUM,
               E.EMP_AUSTRITTSDATUM


         FROM EMP_EMPLOYEE E

         LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
         WHERE E.EMP_UID = :EMP_UID

         INTO :EMP_PERSNR,
              :EMP_PEIDNR,
              :EMP_NAME,
              :EMP_VORNAME,
              :EMP_STRASSE,
              :emp_HausNr,
              :COI_ISOCODE,
              :EMP_PLZ,
              :EMP_ORT, 
              :EMP_GEBURTSDATUM, 
              :EMP_PENSIONDATUM, 
              :EMP_GESCHLECHT,
              :EMP_EINTRITTSDATUM,
              :EMP_AUSTRITTSDATUM;


        SUSPEND; 

     END

  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERAHV IS 'Get data for the report: Quarter \ AHV Quartalsmeldung (AHV Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUATERANNUAL_HLP 
(
  PI_EMPUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PS_INT_TYP  DS_STR3
)
RETURNS 
(
  EMP_UID     DI_UID,
  SAX_UID     DI_UID,
  MONATVON    DI_SMLINT,
  MONATBIS    DI_SMLINT,
  BRUTTOLOHN  DN_NUMBER2,
  FREIBETRAG  DN_NUMBER2,
  PFLICHTLOHN DN_NUMBER2,
  BEITRAGAG   DN_NUMBER2,
  BEITRAGAN   DN_NUMBER2
)
AS

DECLARE VARIABLE BOK        DI_SMLINT;
DECLARE VARIABLE IBUYUID    DN_NUMBER2;
DECLARE VARIABLE NPFLICHT   DN_NUMBER2;
DECLARE VARIABLE NFREIBET   DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;

BEGIN

    -- Das Return-Field "Freibetrag" wird nicht mehr benutzt ------------------------
    FREIBETRAG = 0.0;
   

    EMP_UID = PI_EMPUID;
  
    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :BRUTTOLOHN,:MONATVON,:MONATBIS;   



     -- Basis(pflichtiger Lohn) und Beitraege rechnen ------------------------------

     SELECT EMP_BUYUID FROM EMP_EMPLOYEE E
         WHERE EMP_UID=:PI_EMPUID
     INTO :iBuyUId;

    bOk = 0;

    FOR SELECT DISTINCT TX.SAX_UID
        FROM EMP_EMPLOYEE E
        INNER JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_EMPUID = E.EMP_UID
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
        WHERE (E.EMP_BUYUID=:iBuyUId) AND (A.PRA_ISTVERBUCHT = 1) AND
              (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND
              (TI.INT_TYP=:PS_INT_TYP)

        ORDER BY TX.SAX_UID

        INTO :SAX_UID

    DO BEGIN

       bOk = 1;

       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;
       NBEITRAGAN = 0.0;


       --  Alle Lohnarten "Prozent von BASIS" ------------------------------------------
       SELECT SUM(D.SAD_BASIS)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND (C.SCT_CALCTYPE in (2,3,4))
            AND (E.EMP_UID=:PI_EMPUID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NPFLICHT;

       IF (NPFLICHT   IS NULL) THEN NPFLICHT   = 0.0;        

       PFLICHTLOHN   = NPFLICHT;


       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        

       BEITRAGAG     = NBEITRAGAG;
       BEITRAGAN     = NBEITRAGAN;


       --  Alle Lohnarten NICHT "Prozent von BASIS" ------------------------------------
       NPFLICHT   = 0.0;
       NFREIBET   = 0.0;
       NBEITRAGAG = 0.0;

       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE not in (2,3,4)) 
             AND (E.EMP_UID=:PI_EMPUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        


       --  Total fuer Rueckgabe ---------------------------------------------------------

       PFLICHTLOHN   = PFLICHTLOHN + NPFLICHT;
       BEITRAGAG     = BEITRAGAG   + NBEITRAGAG;
       BEITRAGAN     = BEITRAGAN   + NBEITRAGAN;


       SUSPEND;

    END

    -- Bruttolohn zurueckgaben, falls keine Abzuege (zB bei STE)
    IF (bOk = 0) THEN 
       SUSPEND;


END!!

COMMENT ON PROCEDURE SP_RPT_QUATERANNUAL_HLP IS 'Helper procedure: get detail data for procedure sp_Rpt_QuaterXXX and sp_Rpt_AnnualXXX; Rports Quartal and Annual'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_QUARTERUNF 
(
  PI_FIIUID   DI_UID,
  PI_MONATVON DI_SMLINT,
  PI_MONATBIS DI_SMLINT,
  PI_EMPUID   DI_UID = NULL,
  PI_LANDUID  DI_UID = NULL,
  PI_DEPUID   DI_UID = NULL,
  PI_CATUID   DI_UID = NULL,
  PI_PRGUID   DI_UID = NULL
)
RETURNS 
(
    EMP_UID            DI_UID,
    PRM_MONATVON       DI_SMLINT,
    PRM_MONATBIS       DI_SMLINT,
    LOHN_BRUTTO        DN_NUMBER2,
    K1_SAXUID          DI_UID,
    K1_SAXBEZ          DS_DESCR,
    K1_PFLICHT         DN_NUMBER2,
    K1_FREIBETRAG      DN_NUMBER2,
    K1_BEITRAG_AN      DN_NUMBER2,
    K1_BEITRAG_AG      DN_NUMBER2,
    K2_SAXUID          DI_UID,
    K2_SAXBEZ          DS_DESCR,
    K2_PFLICHT         DN_NUMBER2,
    K2_FREIBETRAG      DN_NUMBER2,
    K2_BEITRAG_AN      DN_NUMBER2,
    K2_BEITRAG_AG      DN_NUMBER2,
    K3_SAXUID          DI_UID,
    K3_SAXBEZ          DS_DESCR,
    K3_PFLICHT         DN_NUMBER2,
    K3_FREIBETRAG      DN_NUMBER2,
    K3_BEITRAG_AN      DN_NUMBER2,
    K3_BEITRAG_AG      DN_NUMBER2,
    K4_SAXUID          DI_UID,
    K4_SAXBEZ          DS_DESCR,
    K4_PFLICHT         DN_NUMBER2,
    K4_FREIBETRAG      DN_NUMBER2,
    K4_BEITRAG_AN      DN_NUMBER2,
    K4_BEITRAG_AG      DN_NUMBER2,
    BUY_GESCHJAHR      DI_BUSINESSYEAR,
    FIR_CODE           DS_CODE,
    FIR_BEZEICHNUNG    DS_DESCR,
    FIR_BEZEICHNUNG2   DS_STR50,
    FIR_STRASSE        DS_STR50,
    FIR_HAUSNR         DS_STR5,
    FIR_PLZ            DS_PLZ,
    FIR_ORT            DS_STR50,
    FII_ABRECHNUNGNR   DS_STR20,
    FII_CODE           DS_CODE,
    FII_NAME           DS_STR50,
    FII_NAMEZUSATZ     DS_STR50,
    FII_STRASSE        DS_STR50,
    FII_PLZ            DS_PLZ,
    FII_ORT            DS_STR50,
    EMP_PERSNR         DI_INT,
    EMP_PEIDNR         DS_STR20,
    EMP_NAME           DS_STR50,
    EMP_VORNAME        DS_STR50,
    EMP_STRASSE        DS_STR50,
    EMP_HAUSNR         DS_STR5,
    COI_ISOCODE        DS_CODE,
    EMP_PLZ            DS_PLZ,
    EMP_ORT            DS_STR50,
    EMP_GEBURTSDATUM   DD_DATE,
    EMP_PENSIONDATUM   DD_DATE,
    EMP_GESCHLECHT     DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE
)
AS

DECLARE VARIABLE SSTMT         VARCHAR(512);
DECLARE VARIABLE IBUYUID       DI_UID;
DECLARE VARIABLE SINTTYP       DS_STR3;
DECLARE VARIABLE ISAXUID       DI_UID;
DECLARE VARIABLE NBEITRAGAG    DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN    DN_NUMBER2;
DECLARE VARIABLE NAHVLOHN      DN_NUMBER2;
DECLARE VARIABLE NAHVLOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NNBULOHN      DN_NUMBER2;
DECLARE VARIABLE NNBULOHNPFL   DN_NUMBER2;
DECLARE VARIABLE NAHVUNTER8STD DN_NUMBER2;

BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE,  
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_UNF_FIIUID IS NOT NULL) AND (EMP_UNF_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

   
     K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
     K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
     K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
     K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
     K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
     K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
     K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
     K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
     K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
     K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
     K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
     K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;




    -- Bruttolohn rechnen  ---------------------------------------------------------   
    SELECT SUM(D.SAD_TOTAL), 
           MIN(M.PRM_MONAT), 
           MAX(M.PRM_MONAT) 

       FROM EMP_EMPLOYEE E    

       INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID     
       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (E.EMP_UID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :LOHN_BRUTTO,:PRM_MONATVON,:PRM_MONATBIS;



     -- Alle AHV-Loehne des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS1 = 1)

       INTO :nAHVLohn;


     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS )
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))

      INTO :nAHVLohnPfl;  

      -- Nicht pflichtiger AHVLohn von Pensinisten/Lehrlingen ----
      IF (nAHVLohn    IS NULL) THEN nAHVLohn    = 0;
      IF (nAHVLohnPfl IS NULL) THEN nAHVLohnPfl = 0;


     -- Alle NBU-Loehne (nur BesPerioden > 8 Std) des MA's--------

     SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

       WHERE (Y.EMY_EMPUID=:EMP_UID) AND (Y.EMY_ISTWOSTD8 = 0) AND (A.PRA_ISTVERBUCHT = 1) AND
             (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
             (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BASIS3 = 1)


       INTO :nNBULohn;   


     -- Alle AHV-Pflichtigen Loehne (nur BesPerioden > 8 Std) des MA's ----

     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 0)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 3)
            AND (T.SDT_SAXUID = 13)
            AND (T.SDT_EXCLUDESALARYCALC = 0)

      INTO :nNBULohnPfl;   

      -- Uebersteigender AHVLohn  von 126000----
      IF (nNBULohn    IS NULL) THEN nNBULohn    = 0;
      IF (nNBULohnPfl IS NULL) THEN nNBULohnPfl = 0;

 
      -- BU-Pflichtiger Lohn----
      K2_SAXUID   = 14;    -- (14 = BU)
      K2_PFLICHT  = nAHVLohnPfl + (nAHVLohn - nAHVLohnPfl) - (nNBULohn - nNBULohnPfl);


     -- Alle AHV-Pflichtigen Loehne (< 8Std) des MA's ----
     SELECT SUM(D.SAD_BASIS)

        FROM EMY_EMPLOYMENTPERIOD Y
     
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE (Y.EMY_EMPUID = :EMP_UID)
            AND (Y.EMY_ISTWOSTD8 = 1)
            AND (A.PRA_ISTVERBUCHT = 1)
            AND (M.PRM_MONAT > 0)
            AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS)
            AND (T.SDT_TYP = 'A')
            AND (T.SDT_ISTLOHNTEIL = 1)
            AND (T.SDT_BERECHBASISNR = 1)
            AND (T.SDT_EXCLUDESALARYCALC = 0)
            AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))


      INTO :nAHVUnter8Std;   

      IF (nAHVUnter8Std  IS NULL) THEN nAHVUnter8Std   = 0;

      K1_SAXUID  = 13;    -- (13 = NBU)
      K1_PFLICHT = K2_PFLICHT - nAHVUnter8Std;


     --- Beitraege rechnen ----------------------------------------------------

     FOR SELECT T.SDT_SAXUID,
                SUM(D.SAD_BEITRAGAG),
                SUM(D.SAD_BEITRAGAN)

         FROM EMY_EMPLOYMENTPERIOD Y
       
         INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
         LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
         LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (Y.EMY_EMPUID=:EMP_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
               (M.PRM_MONAT > 0) AND (M.PRM_MONAT BETWEEN :PI_MONATVON AND :PI_MONATBIS ) AND
               (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1)  AND
               (T.SDT_SAXUID in (13,14))
         
         GROUP BY T.SDT_SAXUID

         INTO :iSAXUid,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF ( iSAXUid = 13) THEN BEGIN        -- wenn NBU

           K1_BEITRAG_AN = nBeitragAN;
           K1_BEITRAG_AG = nBeitragAG;

        END      

        IF ( iSAXUid = 14) THEN BEGIN        -- wenn BU

           K2_BEITRAG_AN = nBeitragAN;      
           K2_BEITRAG_AG = nBeitragAG;

        END      

     END


     -- SAX-Bezeichung holen  
     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 13
     INTO :K1_SAXBEZ;

     SELECT SAX_BEZEICHNUNG FROM SAX_SALARYCATEGORIE
         WHERE SAX_UID = 14
     INTO :K2_SAXBEZ;


     -- Get data from Employee
     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM

      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND; 


  END

END!!

COMMENT ON PROCEDURE SP_RPT_QUARTERUNF IS 'Get data for the report: Quarter \ Unfall Quartalsmeldung (UNF Quarter)'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE SP_RPT_STATWAGEEXPENSESHLP 
(
  PI_PRAUID DI_UID,
  PI_EMPUID DI_UID
)
RETURNS 
(
  PRA_UID        DI_INT,
  EMY_UID        DI_INT,
  EMP_UID        DI_INT,
  PRM_MONAT      DI_SMLINT,
  BRUTTOLOHN     DN_NUMBER2,
  AHVLOHN        DN_NUMBER2,
  NETTOLOHN      DN_NUMBER2,
  AZBETRAG       DN_NUMBER2,
  SPALTE3_AG     DN_NUMBER2,
  SPALTE3_AN     DN_NUMBER2,
  SPALTE4_AG     DN_NUMBER2,
  SPALTE4_AN     DN_NUMBER2,
  SPALTE5_AG     DN_NUMBER2,
  SPALTE5_AN     DN_NUMBER2,
  SPALTE6_BASIS  DN_NUMBER2,
  SPALTE6_AG     DN_NUMBER2,
  SPALTE6_AN     DN_NUMBER2,
  SPALTE7_BASIS  DN_NUMBER2,
  SPALTE7_AG     DN_NUMBER2,
  SPALTE7_AN     DN_NUMBER2,
  SPALTE8_BASIS  DN_NUMBER2,
  SPALTE8_AG     DN_NUMBER2,
  SPALTE8_AN     DN_NUMBER2,
  SPALTE9_BASIS  DN_NUMBER2,
  SPALTE9_AG     DN_NUMBER2,
  SPALTE9_AN     DN_NUMBER2,
  SPALTE10_BASIS DN_NUMBER2,
  SPALTE10_AG    DN_NUMBER2,
  SPALTE10_AN    DN_NUMBER2,
  SPALTE11_BASIS DN_NUMBER2,
  SPALTE11_AG    DN_NUMBER2,
  SPALTE11_AN    DN_NUMBER2,
  SPALTE12_BASIS DN_NUMBER2,
  SPALTE12_AG    DN_NUMBER2,
  SPALTE12_AN    DN_NUMBER2,
  SPALTE13_BASIS DN_NUMBER2,
  SPALTE13_AG    DN_NUMBER2,
  SPALTE13_AN    DN_NUMBER2,
  SPALTE14_BASIS DN_NUMBER2,
  SPALTE14_AG    DN_NUMBER2,
  SPALTE14_AN    DN_NUMBER2
)
AS

DECLARE VARIABLE NSDT_EXCLUDESALARYCALC DB_BOOLEAN;
DECLARE VARIABLE SSDT_TYP               DS_ONECHARFLAG;
DECLARE VARIABLE BSDT_ISTLOHNTEIL       DB_BOOLEAN;
DECLARE VARIABLE BSTD_BASIS1            DB_BOOLEAN;
DECLARE VARIABLE NBETRAGAG              DN_NUMBER2;
DECLARE VARIABLE NBETRAGAN              DN_NUMBER2;
DECLARE VARIABLE NBASIS                 DN_NUMBER2;
DECLARE VARIABLE ISPALTENR              DI_SMLINT;
DECLARE VARIABLE NSAD_ANSATZAN          DN_NUMBER4;
DECLARE VARIABLE NSAD_ANSATZAG          DN_NUMBER4;
DECLARE VARIABLE NAG_KKLOHN             DN_NUMBER2;

BEGIN

   BruttoLohn     = 0;  NettoLohn      = 0; 
   AHVLohn        = 0;  AzBetrag       = 0;
   Spalte3_AG     = 0;  Spalte3_AN     = 0;  
   Spalte4_AG     = 0;  Spalte4_AN     = 0;  
   Spalte5_AG     = 0;  Spalte5_AN     = 0;  
   Spalte6_AG     = 0;  Spalte6_AN     = 0;  
   Spalte7_AG     = 0;  Spalte7_AN     = 0;  
   Spalte8_AG     = 0;  Spalte8_AN     = 0;  
   Spalte9_AG     = 0;  Spalte9_AN     = 0;  
   Spalte10_AG    = 0;  Spalte10_AN    = 0;  
   Spalte11_AG    = 0;  Spalte11_AN    = 0;  
   Spalte12_AG    = 0;  Spalte12_AN    = 0;   
   Spalte13_AG    = 0;  Spalte13_AN    = 0;   
   Spalte14_AG    = 0;  Spalte14_AN    = 0;  
   Spalte6_Basis  = 0;  Spalte7_Basis  = 0;  
   Spalte8_Basis  = 0;  Spalte9_Basis  = 0;  
   Spalte10_Basis = 0;  Spalte11_Basis = 0;  
   Spalte12_Basis = 0;  Spalte13_Basis = 0;  
   Spalte14_Basis = 0;  nAG_KKLohn     = 0;
   
   
   FOR SELECT sdt_Typ, sdt_IstLohnTeil, sdt_Basis1, sdt_EXCLUDESALARYCALC,
              pra_UId, emy_UId,         emy_EmpUId,
              COALESCE( sad_BeitragAG, 0 ), COALESCE( sad_BeitragAN, 0 ), COALESCE( sad_Basis,    0 ), 
              COALESCE( sad_AnsatzAN,  0 ), COALESCE( sad_AnsatzAG,  0 ), COALESCE( sax_SpalteNr, 0 ), 
              prm_Monat
    
         FROM pra_PayrollAccount AC

    LEFT JOIN prm_PayrollMonth        ON prm_UId    = pra_PrmUId
   INNER JOIN say_Salary              ON say_PraUId = pra_UId
    LEFT JOIN emy_EmploymentPeriod    ON emy_UId    = say_EmyUId
   INNER JOIN sad_SalaryDetail        ON sad_SayUId = say_UId
    LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_SdtUId
    LEFT JOIN sax_SalaryCategorie     ON sax_UId    = sdt_SaxUId

        WHERE ( pra_UId          = :pi_PraUId ) 
          AND ( pra_IstVerbucht  = 1          ) 
          AND ( prm_Monat        > 0          ) 
          AND ( emy_EmpUId       = :pi_EmpUId )     

         INTO :ssdt_Typ,      :bSdt_IstLohnTeil, :bStd_Basis1, :nSDT_EXCLUDESALARYCALC,
              :pra_UId,       :emy_UId,          :emp_UId,
              :nBetragAG,     :nBetragAN,        :nBasis,
              :nSad_AnsatzAN, :nSad_AnsatzAG,    :iSpalteNr,
              :prm_Monat

  DO 
  BEGIN

    IF ( ssdt_Typ = 'L' ) THEN 
    BEGIN

      AzBetrag = AzBetrag + nBetragAG;
  
      IF ( bSdt_IstLohnTeil = 1 ) THEN 
      BEGIN
        BruttoLohn = BruttoLohn + nBetragAG;
        NettoLohn  = NettoLohn  + nBetragAG;
      END         

      IF ( iSpalteNr = 13 ) THEN 
      BEGIN -- KK-PlegeBeitrag vom AG als Lohn ausbezahlt

            -- Falls der AG den KK-PflegeBeitrag als Lohn ausbezahlt,
            -- und der MA im Kollektiv versichert ist, wird beim Abzug
            -- der volle KK-Beitrag (AG und AN) abgezogen 
            -- und muss auf der Statistik korregiert werden  

             nAG_KKLohn  = nAG_KKLohn + nBetragAG;
      END
      
    END 
    ELSE 
    BEGIN

      AzBetrag = AzBetrag - nBetragAN;

      IF ( bSdt_IstLohnTeil = 1 ) THEN 
      BEGIN
        
        NettoLohn  = NettoLohn - nBetragAN;
         
        -- AHV-Beitraege 
        IF ( iSpalteNr = 6 ) THEN 
        BEGIN 
        
          IF ( ( nSad_AnsatzAN <> 0.0 ) AND ( nSad_AnsatzAG <> 0.0 ) ) THEN 
          BEGIN
            IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
                AHVLohn = AHVLohn + nBasis;
            ELSE
                AHVLohn = AHVLohn;
          END  

        END


      END  

    END
    
    -- Sonderbeitraege 
    IF ( iSpalteNr = 3 ) THEN 
    BEGIN 

      IF ( bSdt_IstLohnTeil = 0 ) THEN 
      BEGIN                                  

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte3_AG = Spalte3_AG + nBetragAG;   
        END 
        ELSE 
        BEGIN
          Spalte3_AN = Spalte3_AN + nBetragAN;
        END

      END 
  
    END 
  
    -- Vorschuss 
    IF ( iSpalteNr = 4 ) THEN 
    BEGIN 

      IF ( bSdt_IstLohnTeil = 0 ) THEN
      BEGIN                                  

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte4_AG = Spalte4_AG + nBetragAG;
        END 
        ELSE 
        BEGIN
          Spalte4_AN = Spalte4_AN + nBetragAN;
        END  

      END 
            
    END 
    
    -- Spesen
    IF ( iSpalteNr = 5 ) THEN 
    BEGIN 

      IF ( bSdt_IstLohnTeil = 0 ) THEN 
      BEGIN                                  

        IF ( ssdt_Typ = 'L' ) THEN 
        BEGIN
          Spalte5_AG = Spalte5_AG + nBetragAG;
        END 
        ELSE 
        BEGIN
          Spalte5_AN = Spalte5_AN + nBetragAN;
        END

      END 

    END 
    
    -- AHV
    IF ( iSpalteNr = 6 ) THEN 
    BEGIN 
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte6_Basis = Spalte6_Basis + nBasis;
      ELSE
        Spalte6_Basis = Spalte6_Basis;
      Spalte6_AG    = Spalte6_AG    + nBetragAG;
      Spalte6_AN    = Spalte6_AN    + nBetragAN;
    END 
    
    -- ALV
    IF ( iSpalteNr = 7 ) THEN 
    BEGIN
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte7_Basis = Spalte7_Basis + nBasis;
      ELSE
        Spalte7_Basis = Spalte7_Basis;
      Spalte7_AG    = Spalte7_AG    + nBetragAG;
      Spalte7_AN    = Spalte7_AN    + nBetragAN;
    END 
    
    -- NBU / BU
    IF ( iSpalteNr = 8 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte8_Basis = Spalte8_Basis + nBasis;
      ELSE
        Spalte8_Basis = Spalte8_Basis;
      Spalte8_AG    = Spalte8_AG    + nBetragAG;
      Spalte8_AN    = Spalte8_AN    + nBetragAN;
    END 
    
    -- PK1
    IF ( iSpalteNr = 9 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte9_Basis = Spalte9_Basis + nBasis;
      ELSE
        Spalte9_Basis = Spalte9_Basis;
      Spalte9_AG    = Spalte9_AG    + nBetragAG;
      Spalte9_AN    = Spalte9_AN    + nBetragAN;
    END 
    
    -- PK2
    IF ( iSpalteNr = 10 ) THEN 
    BEGIN
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte10_Basis = Spalte10_Basis + nBasis;
      ELSE             
        Spalte10_Basis = Spalte10_Basis;
      Spalte10_AG    = Spalte10_AG    + nBetragAG;
      Spalte10_AN    = Spalte10_AN    + nBetragAN;
    END 
    
    -- PK3
    IF ( iSpalteNr = 11 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte11_Basis = Spalte11_Basis + nBasis;
      ELSE 
        Spalte11_Basis = Spalte11_Basis;
      Spalte11_AG    = Spalte11_AG    + nBetragAG;
      Spalte11_AN    = Spalte11_AN    + nBetragAN;
    END 
    
    -- KK Taggeld
    IF ( iSpalteNr = 12 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte12_Basis = Spalte12_Basis + nBasis;
      ELSE 
        Spalte12_Basis = Spalte12_Basis;
      Spalte12_AG    = Spalte12_AG    + nBetragAG;
      Spalte12_AN    = Spalte12_AN    + nBetragAN;
    END 
    
    -- KK Pflege
    IF ( iSpalteNr = 13 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte13_Basis = Spalte13_Basis + nBasis;
      ELSE 
        Spalte13_Basis = Spalte13_Basis;
      Spalte13_AG    = Spalte13_AG    + nBetragAG;
      Spalte13_AN    = Spalte13_AN    + nBetragAN;
    END 
    
    -- STE
    IF ( iSpalteNr = 14 ) THEN 
    BEGIN          
      IF ( nSDT_EXCLUDESALARYCALC = 0 ) THEN
        Spalte14_Basis = Spalte14_Basis + nBasis;
      ELSE 
        Spalte14_Basis = Spalte14_Basis;
      Spalte14_AG    = Spalte14_AG    + nBetragAG;
      Spalte14_AN    = Spalte14_AN    + nBetragAN;
    END 

  END


   -- Korrektur des AN-Anteils der KK-Pflegeversicherung
   IF ( ( nAG_KKLohn <> 0.0 ) AND ( Spalte13_AN <> 0.0 ) ) THEN 
   BEGIN
  
      -- Korr. des AN-Anteils, falls der AG-Anteil als Lohn ausgezahlt wird
      -- und der MA im Kollektiv versichert ist (dh. einen Abzug KK hat)
      -- Falls der MA nicht im Kollektiv ist, muss keine Korrektur gemacht werden

      Spalte13_AN = Spalte13_AN - nAG_KKLohn;

   END
   
   SUSPEND;

END!!

COMMENT ON PROCEDURE SP_RPT_STATWAGEEXPENSESHLP IS 'Helper procedure: get detail data for procedure sp_Rpt_StatWageExpensesDet; Rports Lohnaufwendungen'!!

COMMIT!!

-- FS#934/FS#942:END

-- +++
-- FS#942:START - PKLohn - Additional conditions for salary calculation

-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- Create a new Salary Custom Rules table

EXECUTE BLOCK
AS

  DECLARE VARIABLE bExists      DB_BOOLEAN;

BEGIN
  
  EXECUTE PROCEDURE sp_DDL_ExistsTable( 'scr_SalaryCustomRules' )
   RETURNING_VALUES :bExists;
   
  IF ( bExists = 0 ) THEN
  BEGIN
    
    EXECUTE STATEMENT
      'CREATE TABLE scr_SalaryCustomRules
       (
          scr_UId             DI_UID_NN,
          scr_SaxUId          DI_UID_NN,
          scr_Fir_CoiUId      DI_UID_NN,
          scr_Emp_GeburtsJahr DI_BUSINESSYEAR_NN,
          scr_Emp_Alter       DI_SMLINT_NN,
          scr_IstAktiv        DB_ISACTIVE_NN,
          scr_CreateDate      DD_TIMESTAMP_NN,
          scr_CreateUsrUId    DI_UID_NN,
          scr_MutDate         DD_TIMESTAMP_NN,
          scr_MutUsrUId       DI_UID_NN
       );';
    
  END
  
  EXECUTE PROCEDURE sp_DDL_CreatePrimaryKey 
    'scr_SalaryCustomRules', 'scr_UId',
    'PK_Scr',                'IDX_Scr_PK';
  
  EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ScrSax2Sax';
  EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ScrCreateUsr2Usr';
  EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ScrMutUsr2Usr';
  EXECUTE PROCEDURE sp_DDL_SafeDropFK 'FK_ScrFirCoi2Coi';
  
END!!

COMMIT!!

COMMENT ON TABLE scr_SalaryCustomRules IS 'Custom Salary Calculation Rules'!!

COMMENT ON COLUMN scr_SalaryCustomRules.scr_UId             IS 'Unique record Id'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_SaxUId          IS 'Salary Category to apply the rule, FK: reference to sax_SalaryCategorie.sax_UId'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_Fir_CoiUId      IS 'Firm Country to apply the rule, FK: reference to coi_CountryISO.coi_UId'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_Emp_GeburtsJahr IS 'Employee year of birth to apply the rule'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_Emp_Alter       IS 'Age when employee have to pay deduction'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_IstAktiv        IS 'Active/Disabled flag'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_CreateDate      IS 'Record creation date'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_CreateUsrUId    IS 'User Id whom created the record'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_MutDate         IS 'Record last modifcation date'!!
COMMENT ON COLUMN scr_SalaryCustomRules.scr_MutUsrUId       IS 'User Id whom last time modified the record'!!


ALTER TABLE scr_SalaryCustomRules
  ADD CONSTRAINT FK_ScrSax2Sax
  FOREIGN KEY (scr_SaxUId)
  REFERENCES sax_SalaryCategorie
  USING INDEX IDX_Scr_BySax!!

ALTER TABLE scr_SalaryCustomRules
  ADD CONSTRAINT FK_ScrFirCoi2Coi
  FOREIGN KEY (scr_Fir_CoiUId)
  REFERENCES coi_CountryISO
  USING INDEX IDX_Scr_ByCoi!!

ALTER TABLE scr_SalaryCustomRules
  ADD CONSTRAINT FK_ScrCreateUsr2Usr
  FOREIGN KEY (scr_CreateUsrUId)
  REFERENCES usr_User(usr_UId)
  USING INDEX IDX_Scr_ByCreateUsr!!

ALTER TABLE scr_SalaryCustomRules
  ADD CONSTRAINT FK_ScrMutUsr2Usr
  FOREIGN KEY (scr_MutUsrUId)
  REFERENCES usr_User(usr_UId)
  USING INDEX IDX_Scr_ByMutUsr!!

COMMENT ON INDEX IDX_scr_PK          IS 'scr_SalaryCustomRules by UId - Primary Key'!!
COMMENT ON INDEX IDX_Scr_BySax       IS 'scr_SalaryCustomRules by Salary Category (search over FK usage)'!!
COMMENT ON INDEX IDX_Scr_ByCoi       IS 'scr_SalaryCustomRules by Country ISO (search over FK usage)'!!
COMMENT ON INDEX IDX_sat_ByCreateUsr IS 'scr_SalaryCustomRules by ID of the user whom has created the record (search over FK usage)'!!
COMMENT ON INDEX IDX_sat_ByMutUsr    IS 'scr_SalaryCustomRules by ID of the user whom has updated the record last time (search over FK usage)'!!

COMMIT!!


-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- Create generator and trigger for sat_UId field

EXECUTE PROCEDURE sp_DDL_CreateGenerator( 'GEN_Scr_UId' )!!

COMMIT!!

COMMENT ON GENERATOR GEN_Scr_UId IS 'ID for scr_SalaryCustomRules table'!!

-- Trigger for default values in scr_SalaryCustomRules table

EXECUTE PROCEDURE sp_DDL_SafeDropTrigger( 'TRG_Scr_BeforeIns_0' )!!

COMMIT!!

CREATE TRIGGER TRG_Scr_BeforeIns_0
  FOR scr_SalaryCustomRules ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN

  IF ( ( new.scr_UId IS NULL ) OR ( new.scr_UId = 0 ) ) THEN
  BEGIN
     new.scr_UId = GEN_ID (GEN_Scr_UId,1);
  END

END!!

COMMENT ON TRIGGER TRG_Scr_BeforeIns_0 IS 'scr_SalaryCustomRules: Set ID for new record'!!

COMMIT!!

-- Insert data to table

DELETE FROM scr_SalaryCustomRules
 WHERE scr_SaxUId          = 16
   AND scr_Fir_CoiUId      = 295
   AND scr_Emp_GeburtsJahr = 1996!!

INSERT INTO scr_SalaryCustomRules
(
    scr_SaxUId,
    scr_Fir_CoiUId,
    scr_Emp_GeburtsJahr,
    scr_Emp_Alter,
    scr_IstAktiv,
    scr_CreateDate,
    scr_CreateUsrUId,
    scr_MutDate,
    scr_MutUsrUId
)
VALUES
(
    16,
    295,
    1996,
    24,
    1,
    Current_TimeStamp,
    1,
    Current_TimeStamp,
    1
)!!

DELETE FROM scr_SalaryCustomRules
 WHERE scr_SaxUId          = 16
   AND scr_Fir_CoiUId      = 295
   AND scr_Emp_GeburtsJahr = 1997!!

INSERT INTO scr_SalaryCustomRules
(
    scr_SaxUId,
    scr_Fir_CoiUId,
    scr_Emp_GeburtsJahr,
    scr_Emp_Alter,
    scr_IstAktiv,
    scr_CreateDate,
    scr_CreateUsrUId,
    scr_MutDate,
    scr_MutUsrUId
)
VALUES
(
    16,
    295,
    1997,
    23,
    1,
    Current_TimeStamp,
    1,
    Current_TimeStamp,
    1
)!!

DELETE FROM scr_SalaryCustomRules
 WHERE scr_SaxUId          = 16
   AND scr_Fir_CoiUId      = 295
   AND scr_Emp_GeburtsJahr = 1998!!

INSERT INTO scr_SalaryCustomRules
(
    scr_SaxUId,
    scr_Fir_CoiUId,
    scr_Emp_GeburtsJahr,
    scr_Emp_Alter,
    scr_IstAktiv,
    scr_CreateDate,
    scr_CreateUsrUId,
    scr_MutDate,
    scr_MutUsrUId
)
VALUES
(
    16,
    295,
    1998,
    23,
    1,
    Current_TimeStamp,
    1,
    Current_TimeStamp,
    1
)!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Sad_SelectBySayAndSdtTyp
(
   pi_SayUId  DI_INT,
   ps_SdtTyp  DS_ONECHARFLAG  DEFAULT NULL,
   pi_SdtUId  DI_UID          DEFAULT NULL,
   pi_SadUId  DI_UID          DEFAULT NULL
)
RETURNS
(
  sad_UId                   DI_UID,
  sad_SayUId                DI_UID,
  sad_SdtUId                DI_UID,
  sad_IstKorr               DB_BOOLEAN,
  sad_IstAuto               DB_BOOLEAN,
  sad_Text                  DS_DESCR,
  sad_SortNr                DI_SMLINT,
  sad_Total                 DN_NUMBER2,
  sad_BeitragAG             DN_NUMBER2,
  sad_BeitragAN             DN_NUMBER2,
  sad_Basis                 DN_NUMBER2,
  sad_AnsatzAG              DN_NUMBER4,
  sad_AnsatzAN              DN_NUMBER4,
  sad_Menge                 DN_NUMBER2,
  sad_Faktor                DN_NUMBER4,
  sad_Freibetrag            DN_NUMBER2,
  sad_AnzMorgen             DI_SMLINT,
  sad_AnzMittag             DI_SMLINT,
  sad_AnzAbend              DI_SMLINT,
  sad_AnzUnterkunft         DI_SMLINT,
  sad_IstAktiv              DB_ISACTIVE,
  sad_CreateDate            DD_TIMESTAMP,
  sad_CreateUsrUId          DI_UID,
  sad_MutDate               DD_TIMESTAMP,
  sad_MutUsrUId             DI_UID,
  
  say_DatumVom              DD_DATE,
  say_DatumBis              DD_DATE,
  
  sdt_LArt                  DS_STR5,
  sdt_BerechBasisNr         DI_SMLINT,
  sdt_Typ                   DS_ONECHARFLAG,  
  sdt_Bezeichnung           DS_DESCR,
  sdt_Text                  DS_DESCR,
  sdt_SortNr                DI_SMLINT,
  sdt_UId                   DI_UID,
  sdt_IstVariabel           DB_BOOLEAN,
  sdt_IstLohnTeil           DB_BOOLEAN,
  sdt_MassEinheit           DS_STR10,
  sdt_StdAbreTyp            DS_ONECHARFLAG,  
  sdt_InsInAbreTyp          DS_ONECHARFLAG,
  sdt_BuyUId                DI_UID,          
  sdt_LArt_SdtUId           DI_UID,
  
  sdt_MinLohn               DN_AMOUNT,
  sdt_MaxLohn               DN_AMOUNT,
  sdt_Freibetrag            DN_AMOUNT,
  sdt_MinPflichtLohn        DN_AMOUNT,
  sdt_MaxPflichtLohn        DN_AMOUNT,
  
  sdt_IstZivilstand         DB_BOOLEAN,    
  sdt_IstAbJahresLohn       DB_BOOLEAN,  
  sdt_IstLehrlingFrei       DB_BOOLEAN, 
  sdt_Ist8StdFrei           DB_BOOLEAN,  
  sdt_IstBesGradMin         DB_BOOLEAN,
  sdt_IstBesGradMax         DB_BOOLEAN,
  sdt_IstBesGradFrei        DB_BOOLEAN,
  sdt_IstBesGradMinPfl      DB_BOOLEAN,
  sdt_IstBesGradMaxPfl      DB_BOOLEAN,
  sdt_IstIVGradMin          DB_BOOLEAN,
  sdt_IstIVGradMax          DB_BOOLEAN,
  sdt_IstIVGradFrei         DB_BOOLEAN,
  sdt_IstIVGradMinPfl       DB_BOOLEAN,
  sdt_IstIVGradMaxPfl       DB_BOOLEAN,
  sdt_IstAutoBerechnung     DB_BOOLEAN,
  sdt_BerArtAbAlter         DS_ONECHARFLAG,
  sdt_BerArtBisAlter        DS_ONECHARFLAG,
  sdt_BisAlter1             DI_SMLINT,         
  sdt_BisAlter2             DI_SMLINT,        
  
  sdt_Ab1_1                 DI_INT,            
  sdt_Ab1_2                 DI_INT,             
  sdt_Ab1_3                 DI_INT,             
  sdt_Ab1_4                 DI_INT,            
  sdt_Ab1_5                 DI_INT,            
  sdt_Ab2_1                 DI_INT,             
  sdt_Ab2_2                 DI_INT,             
  sdt_Ab2_3                 DI_INT,            
  sdt_Ab2_4                 DI_INT,            
  sdt_Ab2_5                 DI_INT,             
  
  sdt_Sa1_Anteil1           DN_AMOUNT,
  sdt_Sa1_Anteil2           DN_AMOUNT,      
  sdt_Sa1_Anteil3           DN_AMOUNT,      
  sdt_Sa1_Anteil4           DN_AMOUNT,       
  sdt_Sa1_Anteil5           DN_AMOUNT,       
  sdt_Sa2_Anteil1           DN_AMOUNT,      
  sdt_Sa2_Anteil2           DN_AMOUNT,      
  sdt_Sa2_Anteil3           DN_AMOUNT,       
  sdt_Sa2_Anteil4           DN_AMOUNT,       
  sdt_Sa2_Anteil5           DN_AMOUNT,      
  sdt_Sb1_Anteil1           DN_AMOUNT,      
  sdt_Sb1_Anteil2           DN_AMOUNT,       
  sdt_Sb1_Anteil3           DN_AMOUNT,       
  sdt_Sb1_Anteil4           DN_AMOUNT,      
  sdt_Sb1_Anteil5           DN_AMOUNT,      
  sdt_Sb2_Anteil1           DN_AMOUNT,       
  sdt_Sb2_Anteil2           DN_AMOUNT,       
  sdt_Sb2_Anteil3           DN_AMOUNT,      
  sdt_Sb2_Anteil4           DN_AMOUNT,      
  sdt_Sb2_Anteil5           DN_AMOUNT,
  
  sdt_Basis1                DB_BOOLEAN,
  sdt_Basis2                DB_BOOLEAN,
  sdt_Basis3                DB_BOOLEAN,
  sdt_Basis4                DB_BOOLEAN,
  sdt_Basis5                DB_BOOLEAN,
  sdt_Basis6                DB_BOOLEAN,
  sdt_Basis7                DB_BOOLEAN,
  sdt_Basis8                DB_BOOLEAN,
  sdt_Basis9                DB_BOOLEAN,
  sdt_Basis10               DB_BOOLEAN,
  sdt_Basis11               DB_BOOLEAN,
  sdt_Basis12               DB_BOOLEAN,
  sdt_Basis13               DB_BOOLEAN,
  sdt_Basis14               DB_BOOLEAN,
  sdt_Basis15               DB_BOOLEAN,
  sdt_Kommentar             DS_STR255,
  sdt_IstBearbeitbar        DB_BOOLEAN,
  
  sdt_ExcludeSalaryCalc     DB_BOOLEAN,
  sdt_IgnoreSparenCalc      DB_BOOLEAN,
  sdt_SaxUId                DI_UID,  
  
  sct_CalcType              DI_SMLINT,
  sct_UId                   DI_UID
)
AS

  -- Select salary detail data by sayUId and sdtTyp   

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;

BEGIN
  
  FOR
    SELECT sad_UId,               sad_SayUId,            sad_SdtUId,           sad_IstKorr,        
           sad_IstAuto,           sad_Text,              sad_SortNr,           sad_Total,            
           sad_BeitragAG,         sad_BeitragAN,         sad_Basis,            sad_AnsatzAG,         
           sad_AnsatzAN,          sad_Menge,             sad_Faktor,           sad_Freibetrag,      
           sad_AnzMorgen,         sad_AnzMittag,         sad_AnzAbend,         sad_AnzUnterkunft,
           sad_IstAktiv,          sad_CreateDate,        sad_CreateUsrUId,     sad_MutDate,        
           sad_MutUsrUId,         say_DatumVom,          say_DatumBis,         sdt_LArt,             
           sdt_BerechBasisNr,     sdt_Bezeichnung,       sdt_Text,             sdt_Typ,               
           sdt_SortNr,            sdt_UId,               sdt_IstVariabel,      sdt_InsInAbreTyp,
           sdt_IstLohnTeil,       sdt_MassEinheit,       sdt_StdAbreTyp,       sdt_BuyUId,          
           sdt_LArt_SdtUId,       sdt_MinLohn,           sdt_MaxLohn,          sdt_Freibetrag,
           sdt_MinPflichtLohn,    sdt_MaxPflichtLohn,    sdt_IstZivilstand,    sdt_IstAbJahresLohn,  
           sdt_IstLehrlingFrei,   sdt_Ist8StdFrei,       sdt_IstBesGradMin,    sdt_IstBesGradMax,    
           sdt_IstBesGradFrei,    sdt_IstBesGradMinPfl,  sdt_IstBesGradMaxPfl, sdt_IstIVGradMin,     
           sdt_IstIVGradMax,      sdt_IstIVGradFrei,     sdt_IstIVGradMinPfl,  sdt_IstIVGradMaxPfl,  
           sdt_IstAutoBerechnung, sdt_BerArtAbAlter,     sdt_BerArtBisAlter,   sdt_BisAlter1,        
           sdt_BisAlter2,         sdt_Ab1_1,             sdt_Ab1_2,
           sdt_Ab1_3,             sdt_Ab1_4,             sdt_Ab1_5,            sdt_Ab2_1,
           sdt_Ab2_2,             sdt_Ab2_3,             sdt_Ab2_4,            sdt_Ab2_5,
           sdt_Sa1_Anteil1,       sdt_Sa1_Anteil2,       sdt_Sa1_Anteil3,      sdt_Sa1_Anteil4,
           sdt_Sa1_Anteil5,       sdt_Sa2_Anteil1,       sdt_Sa2_Anteil2,      sdt_Sa2_Anteil3,
           sdt_Sa2_Anteil4,       sdt_Sa2_Anteil5,       sdt_Sb1_Anteil1,      sdt_Sb1_Anteil2,
           sdt_Sb1_Anteil3,       sdt_Sb1_Anteil4,       sdt_Sb1_Anteil5,      sdt_Sb2_Anteil1,
           sdt_Sb2_Anteil2,       sdt_Sb2_Anteil3,       sdt_Sb2_Anteil4,      sdt_Sb2_Anteil5,
           sdt_Basis1,            sdt_Basis2,            sdt_Basis3,           sdt_Basis4,
           sdt_Basis5,            sdt_Basis6,            sdt_Basis7,           sdt_Basis8,
           sdt_Basis9,            sdt_Basis10,           sdt_Basis11,          sdt_Basis12,
           sdt_Basis13,           sdt_Basis14,           sdt_Basis15,          sdt_Kommentar,
           sdt_IstBearbeitbar,    sdt_ExcludeSalaryCalc, sdt_IgnoreSparenCalc, sdt_SaxUId,
           sct_CalcType,          sct_UId
      FROM sad_SalaryDetail 
      LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_SdtUId
      LEFT JOIN sct_SalaryCalcType      ON sdt_SctUId = sct_UId
           JOIN say_Salary              ON say_UId    = sad_SayUId
     WHERE :pi_SayUId = sad_SayUID
       AND ( :ps_SdtTyp IS NULL OR :ps_SdtTyp = sdt_Typ    )
       AND ( :pi_SdtUId IS NULL OR :pi_SdtUId = sdt_UId    )
       AND ( :pi_SadUId IS NULL OR :pi_SadUId = sad_UId    )
     ORDER BY sdt_Typ DESC, sct_UId, sad_SortNr
      INTO :sad_UId,               :sad_SayUId,            :sad_SdtUId,           :sad_IstKorr,        
           :sad_IstAuto,           :sad_Text,              :sad_SortNr,           :sad_Total,            
           :sad_BeitragAG,         :sad_BeitragAN,         :sad_Basis,            :sad_AnsatzAG,         
           :sad_AnsatzAN,          :sad_Menge,             :sad_Faktor,           :sad_Freibetrag,      
           :sad_AnzMorgen,         :sad_AnzMittag,         :sad_AnzAbend,         :sad_AnzUnterkunft,
           :sad_IstAktiv,          :sad_CreateDate,        :sad_CreateUsrUId,     :sad_MutDate,        
           :sad_MutUsrUId,         :say_DatumVom,          :say_DatumBis,         :sdt_LArt,             
           :sdt_BerechBasisNr,     :sdt_Bezeichnung,       :sdt_Text,             :sdt_Typ,               
           :sdt_SortNr,            :sdt_UId,               :sdt_IstVariabel,      :sdt_InsInAbreTyp,
           :sdt_IstLohnTeil,       :sdt_MassEinheit,       :sdt_StdAbreTyp,       :sdt_BuyUId,          
           :sdt_LArt_SdtUId,       :sdt_MinLohn,           :sdt_MaxLohn,          :sdt_Freibetrag,
           :sdt_MinPflichtLohn,    :sdt_MaxPflichtLohn,    
           :sdt_IstZivilstand,     :sdt_IstAbJahresLohn,   :sdt_IstLehrlingFrei, 
           :sdt_Ist8StdFrei,       :sdt_IstBesGradMin,     :sdt_IstBesGradMax,    :sdt_IstBesGradFrei,  
           :sdt_IstBesGradMinPfl,  :sdt_IstBesGradMaxPfl,  :sdt_IstIVGradMin,     :sdt_IstIVGradMax,    
           :sdt_IstIVGradFrei,     :sdt_IstIVGradMinPfl,   :sdt_IstIVGradMaxPfl,  :sdt_IstAutoBerechnung, 
           :sdt_BerArtAbAlter,     :sdt_BerArtBisAlter,    :sdt_BisAlter1,        :sdt_BisAlter2,        
           :sdt_Ab1_1,             :sdt_Ab1_2,             
           :sdt_Ab1_3,             :sdt_Ab1_4,             :sdt_Ab1_5,            :sdt_Ab2_1,
           :sdt_Ab2_2,             :sdt_Ab2_3,             :sdt_Ab2_4,            :sdt_Ab2_5,
           :sdt_Sa1_Anteil1,       :sdt_Sa1_Anteil2,       :sdt_Sa1_Anteil3,      :sdt_Sa1_Anteil4,
           :sdt_Sa1_Anteil5,       :sdt_Sa2_Anteil1,       :sdt_Sa2_Anteil2,      :sdt_Sa2_Anteil3,
           :sdt_Sa2_Anteil4,       :sdt_Sa2_Anteil5,       :sdt_Sb1_Anteil1,      :sdt_Sb1_Anteil2,
           :sdt_Sb1_Anteil3,       :sdt_Sb1_Anteil4,       :sdt_Sb1_Anteil5,      :sdt_Sb2_Anteil1,
           :sdt_Sb2_Anteil2,       :sdt_Sb2_Anteil3,       :sdt_Sb2_Anteil4,      :sdt_Sb2_Anteil5,
           :sdt_Basis1,            :sdt_Basis2,            :sdt_Basis3,           :sdt_Basis4,
           :sdt_Basis5,            :sdt_Basis6,            :sdt_Basis7,           :sdt_Basis8,
           :sdt_Basis9,            :sdt_Basis10,           :sdt_Basis11,          :sdt_Basis12,
           :sdt_Basis13,           :sdt_Basis14,           :sdt_Basis15,          :sdt_Kommentar,
           :sdt_IstBearbeitbar,    :sdt_ExcludeSalaryCalc, :sdt_IgnoreSparenCalc, :sdt_SaxUId,
           :sct_CalcType,          :sct_UId
  DO
  BEGIN
    
    IF ( sdt_Typ = 'L' AND sct_CalcType  = 5 ) THEN
    BEGIN
    
      EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :sdt_BuyUId )
       RETURNING_VALUES :bIsIndustrieMinuten;
      
      EXECUTE PROCEDURE sp_WorkMinutesToHours( :sad_Menge, :bIsIndustrieMinuten )
       RETURNING_VALUES :sad_Menge;
      
    END
    
    SUSPEND;    
    
  END
  
END!!

COMMENT ON PROCEDURE sp_Sad_SelectBySayAndSdtTyp           IS 'Get salary data by sayUId and sdtTyp'!!
COMMENT ON PARAMETER sp_Sad_SelectBySayAndSdtTyp.pi_SayUId IS 'Salary UId'!!
COMMENT ON PARAMETER sp_Sad_SelectBySayAndSdtTyp.ps_SdtTyp IS 'Salary deduction type'!!
COMMENT ON PARAMETER sp_Sad_SelectBySayAndSdtTyp.pi_SdtUID IS 'Salary deduction type UId'!!
COMMENT ON PARAMETER sp_Sad_SelectBySayAndSdtTyp.pi_SadUID IS 'Salary detail UId'!!

COMMIT!!

-- FS#942:END

SET TERM ;!!
