﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.16
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#907:START - PKLohn - SP for annual report KK & PK have a bug

CREATE OR ALTER PROCEDURE sp_Rpt_AnnualPk 
(
    pi_FiiUId   DI_UID,
    pi_EmpUId   DI_UID = NULL,
    pi_LandUId  DI_UID = NULL,
    pi_DepUId   DI_UID = NULL,
    pi_CatUId   DI_UID = NULL,
    pi_PrgUId   DI_UID = NULL
)
RETURNS 
(
    emp_UId             DI_UID,
    emy_UId             DI_UID,
    emy_PjAnfang        DD_DATE,
    emy_PjEnde          DD_DATE,
    emy_Besgrad         DN_NUMBER2,
    emy_IsUnemployed    DB_BOOLEAN,
    lohn_Brutto         DN_NUMBER2,
    lohn_Ahv            DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_SaxBez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreiBetrag       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_SaxBez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_FreiBetrag       DN_NUMBER2,
    k2_Beitrag_An       DN_NUMBER2,
    k2_Beitrag_Ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_SaxBez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreiBetrag       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_SaxBez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreiBetrag       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE
)
AS
DECLARE VARIABLE sStmt      VARCHAR(512);
DECLARE VARIABLE iBuyUId    DI_UID;
DECLARE VARIABLE sIntTyp    DS_STR3;
DECLARE VARIABLE iCounter   DI_SMLINT;
DECLARE VARIABLE iSaxUId    DI_UID;
DECLARE VARIABLE sSaxBez    DS_DESCR;
DECLARE VARIABLE nFrei      DN_NUMBER2;
DECLARE VARIABLE nPflicht   DN_NUMBER2;
DECLARE VARIABLE nBeitragAg DN_NUMBER2;
DECLARE VARIABLE nBeitragAn DN_NUMBER2;
DECLARE VARIABLE iEmy_UId   DI_UID;
BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

          SELECT SUM(D.SAD_BASIS)

            FROM EMY_EMPLOYMENTPERIOD Y
     
           INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
           INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
            LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
            LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
            LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
            LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
            LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE ( Y.EMY_UID           = :iEMY_UID ) 
             AND ( A.PRA_ISTVERBUCHT   = 1         ) 
             AND ( T.SDT_TYP           = 'A'       ) 
             AND ( T.SDT_ISTLOHNTEIL   = 1         ) 
             AND ( T.SDT_BERECHBASISNR = 1         )
             AND ( SAD_BEITRAGAG > 0 OR SAD_BEITRAGAN > 0 ) 
             
            INTO :LOHN_AHV;   


           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!

COMMIT!!

--+++

CREATE OR ALTER PROCEDURE SP_RPT_ANNUALKK 
(
    PI_FIIUID DI_UID,
    PI_EMPUID DI_UID = null,
    PI_LANDUID DI_UID = null,
    PI_DEPUID DI_UID = null,
    PI_CATUID DI_UID = null,
    PI_PRGUID DI_UID = null
)
RETURNS (
    EMP_UID DI_UID,
    BUY_GESCHJAHR DI_BUSINESSYEAR,
    FIR_CODE DS_CODE,
    FIR_BEZEICHNUNG DS_DESCR,
    FIR_BEZEICHNUNG2 DS_STR50,
    FIR_STRASSE DS_STR50,
    fir_HausNr  DS_STR5,
    FIR_PLZ DS_PLZ,
    FIR_ORT DS_STR50,
    FII_ABRECHNUNGNR DS_STR20,
    FII_CODE DS_CODE,
    FII_NAME DS_STR50,
    FII_NAMEZUSATZ DS_STR50,
    FII_STRASSE DS_STR50,
    FII_PLZ DS_PLZ,
    FII_ORT DS_STR50,
    EMP_PERSNR DI_INT,
    EMP_PEIDNR DS_STR20,
    EMP_NAME DS_STR50,
    EMP_VORNAME DS_STR50,
    EMP_STRASSE DS_STR50,
    emp_HausNr  DS_STR5,
    COI_ISOCODE DS_CODE,
    EMP_PLZ DS_PLZ,
    EMP_ORT DS_STR50,
    EMP_GEBURTSDATUM DD_DATE,
    EMP_PENSIONDATUM DD_DATE,
    EMP_GESCHLECHT DS_ONECHARFLAG,
    EMP_EINTRITTSDATUM DD_DATE,
    EMP_AUSTRITTSDATUM DD_DATE,
    EMY_BESGRAD DN_NUMBER2,
    LOHN_BRUTTO DN_NUMBER2,
    LOHN_AHV DN_NUMBER2,
    TG_LOHN_PFLICHT DN_NUMBER2,
    TG_BETRAG_AG DN_NUMBER2,
    TG_BETRAG_AN DN_NUMBER2,
    PF_LOHN_PFLICHT DN_NUMBER2,
    PF_BETRAG_AG DN_NUMBER2,
    PF_BETRAG_AN DN_NUMBER2)
AS
-- Get data for the report: Annual \ Jahresabrechnung KK (KK Annual)
DECLARE VARIABLE SSTMT VARCHAR(512);
DECLARE VARIABLE IBUYUID DI_UID;
DECLARE VARIABLE SINTTYP DS_STR3;
DECLARE VARIABLE ISAXUID DI_UID;
DECLARE VARIABLE NPFLICHT DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAG DN_NUMBER2;
DECLARE VARIABLE NBEITRAGAN DN_NUMBER2;
BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND ((EMP_KKP_FIIUID = :piFIIUid ) OR (EMP_KKT_FIIUID = :piFIIUid ))';

  sStmt = sStmt || ' ORDER BY EMP_GESCHLECHT,EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO BEGIN

     LOHN_AHV        = 0;
     TG_LOHN_PFLICHT = 0;
     TG_BETRAG_AG    = 0;
     TG_BETRAG_AN    = 0;
     PF_LOHN_PFLICHT = 0;
     PF_BETRAG_AG    = 0;
     PF_BETRAG_AN    = 0;
     EMY_BESGRAD     = 0;

     FOR SELECT SAX_UID,
                BRUTTOLOHN,
                PFLICHTLOHN,
                BEITRAGAG,
                BEITRAGAN
              
         FROM  SP_RPT_QUATERANNUAL_HLP ( :EMP_UID, 1, 12, :sIntTyp )

         ORDER BY SAX_UID

         INTO :iSaxUID,
              :LOHN_BRUTTO, 
              :nPflicht,
              :nBeitragAG,
              :nBeitragAN

     DO BEGIN

        IF (nPflicht   IS NULL) THEN nPflicht   = 0;
        IF (nBeitragAG IS NULL) THEN nBeitragAG = 0;
        IF (nBeitragAN IS NULL) THEN nBeitragAN = 0;


        IF (iSaxUID = 18) THEN BEGIN                    -- wenn Taggeld

           TG_LOHN_PFLICHT = nPflicht;
           TG_BETRAG_AG    = nBeitragAG;
           TG_BETRAG_AN    = nBeitragAN;


        END ELSE IF (iSaxUID = 19) THEN BEGIN           -- wenn Pflege

           PF_LOHN_PFLICHT = nPflicht;
           PF_BETRAG_AG    = nBeitragAG;
           PF_BETRAG_AN    = nBeitragAN;

        
        END 


     END



     -- Alle AHV-Pflichtigen Loehne des MA's ----

     SELECT SUM(D.SAD_BASIS)

       FROM EMY_EMPLOYMENTPERIOD Y
     
      INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
      INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
       LEFT JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
       LEFT JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
       LEFT JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
       LEFT JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

      WHERE ( Y.EMY_EMPUID        = :EMP_UID ) 
        AND ( A.PRA_ISTVERBUCHT   = 1        ) 
        AND ( T.SDT_TYP           = 'A'      ) 
        AND ( T.SDT_ISTLOHNTEIL   = 1        ) 
        AND ( T.SDT_BERECHBASISNR = 1        )
        AND ( SAD_BEITRAGAG > 0 OR SAD_BEITRAGAN > 0 ) 

       INTO :LOHN_AHV;   

     -- Letzter Bes.Grad des Mitarbeiters 

     FOR SELECT EMY_BESGRAD FROM EMY_EMPLOYMENTPERIOD

         WHERE (EMY_EMPUID=:EMP_UID) AND (EMY_ISUNEMPLOYED = 0)

         ORDER BY EMY_PJANFANG  

         INTO :EMY_BESGRAD

     DO BEGIN

        IF (EMY_BESGRAD IS NULL) THEN 
           EMY_BESGRAD  = 0;
         
     END                 
        

     -- Personalien des MA's ----

     SELECT E.EMP_PERSNR,
            E.EMP_PEIDNR,
            E.EMP_NAME,
            E.EMP_VORNAME,
            E.EMP_STRASSE,
            E.emp_HausNr,
            C.COI_ISOCODE,
            E.EMP_PLZ,
            E.EMP_ORT, 
            E.EMP_GEBURTSDATUM, 
            E.EMP_PENSIONDATUM, 
            E.EMP_GESCHLECHT,
            E.EMP_EINTRITTSDATUM,
            E.EMP_AUSTRITTSDATUM


      FROM EMP_EMPLOYEE E

      LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID

      WHERE E.EMP_UID = :EMP_UID

      INTO :EMP_PERSNR,
           :EMP_PEIDNR,
           :EMP_NAME,
           :EMP_VORNAME,
           :EMP_STRASSE,
           :emp_HausNr,
           :COI_ISOCODE,
           :EMP_PLZ,
           :EMP_ORT, 
           :EMP_GEBURTSDATUM, 
           :EMP_PENSIONDATUM, 
           :EMP_GESCHLECHT,
           :EMP_EINTRITTSDATUM,
           :EMP_AUSTRITTSDATUM;


     SUSPEND;

  END

END!!

COMMIT!!

-- FS#907:END
-- +++

-- +++
-- FS#908:START - PKLohn - Sending Lohnabrechnung.fr3 in an email

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'emp_Employee', 'emp_EmailPasswort', 'DS_STR50' )!!
COMMIT!!

COMMENT ON COLUMN emp_Employee.emp_EmailPasswort IS 'Password for files which shoul be send encrypted via email'!!
COMMIT!!

ALTER TABLE emp_Employee ALTER emp_EmailPasswort POSITION 28!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Select
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR30,
    emp_EmailPasswort     DS_STR50,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR
)                             
AS
  /* Select Employee data by Id or by Employee*/

  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;
  DECLARE iVortragFerien       DI_INT;
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN

  SELECT buy_FirUId, buy_GeschJahr,
         EXTRACT(YEAR FROM buy_DatumVon),
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;

  SELECT buy_UId
    FROM buy_BusinessYear
   WHERE buy_FirUId = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */

  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_EmailPasswort,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_Code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,

           (
            SELECT E.emp_UId
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,

           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_EmailPasswort,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_Code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,

           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,

           :luk_Zivilstand

  DO
  BEGIN

    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;

    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN

      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END

      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN

        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END

    END


    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;

      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;

      SUSPEND;

    END

  END

END!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Insert
(
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR30,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,    
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_IstCh            DB_BOOLEAN,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN,
    ps_emp_EmailPasswort    DS_STR50,
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
RETURNS( emp_UId DI_UID_NN )
AS

  -- Add a new Employee and return Employee Id
  
  DECLARE bIsIndustrialHours     DB_BOOLEAN;
  DECLARE iVortragStd            DI_INT;    
  DECLARE iVortragFerien         DI_INT;    

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
   
  EXECUTE PROCEDURE  sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  emp_UId = GEN_ID (GEN_Emp_UId, 1);

  INSERT INTO emp_Employee
  (
    emp_UId,
    emp_BuyUId,
    emp_PersNr,
    emp_PEIDNr,
    emp_Name,
    emp_Vorname,
    emp_Strasse,
    emp_HausNr,
    emp_LandUId,
    emp_PLZ,
    emp_Ort,
    emp_GeburtsDatum,
    emp_PensionDatum,
    emp_Geschlecht,
    emp_EintrittsDatum,
    emp_AustrittsDatum,
    emp_Zivilstand,
    emp_Aufenthalt,
    emp_NationUId,
    emp_HeimatOrt,
    emp_AnzKinder,
    emp_Telefon,
    emp_Handy,
    emp_Email,
    emp_EmailPasswort,
    emp_Beruf,
    emp_Stellung,
    emp_Lohnklasse,
    emp_DepUId,
    emp_CatUId,
    emp_PrgUId,
    emp_EmiUId,
    emp_AHV_FiiUId,
    emp_ALV_FiiUId,
    emp_PK_FiiUId,
    emp_KKP_FiiUId,
    emp_KKT_FiiUId,
    emp_UNF_FiiUId,
    emp_STE_FiiUId,
    emp_ZPK_FiiUId,
    emp_VortragStd,
    emp_VortragFerien,
    emp_SonderFerien,
    emp_AnspruchFerien,
    emp_IstCh,
    emp_LA_IstStunden,
    emp_LA_IstFerien,
    emp_LA_IstZahlstelle,
    emp_IstAktiv,
    emp_CreateDate,
    emp_CreateUsrUId,
    emp_MutDate,
    emp_MutUsrUId
  )
  VALUES
  (
    :emp_UId,
    :pi_emp_BuyUId,
    :pi_emp_PersNr,
    :ps_emp_PEIDNr,
    :ps_emp_Name,
    :ps_emp_Vorname,
    :ps_emp_Strasse,
    :ps_emp_HausNr,
    :pi_emp_LandUId,
    :ps_emp_PLZ,
    :ps_emp_Ort,
    :pd_emp_GeburtsDatum,
    :pd_emp_PensionDatum,
    :ps_emp_Geschlecht,
    :pd_emp_EintrittsDatum,
    :pd_emp_AustrittsDatum,
    :ps_emp_Zivilstand,
    :ps_emp_Aufenthalt,
    :pi_emp_NationUId,
    :ps_emp_HeimatOrt,
    :pi_emp_AnzKinder,
    :ps_emp_Telefon,
    :ps_emp_Handy,
    :ps_emp_Email,
    :ps_emp_EmailPasswort,
    :ps_emp_Beruf,
    :ps_emp_Stellung,
    :ps_emp_Lohnklasse,
    :pi_emp_DepUId,
    :pi_emp_CatUId,
    :pi_emp_PrgUId,
    :pi_emp_EmiUId,
    :pi_emp_AHV_FiiUId,
    :pi_emp_ALV_FiiUId,
    :pi_emp_PK_FiiUId,
    :pi_emp_KKP_FiiUId,
    :pi_emp_KKT_FiiUId,
    :pi_emp_UNF_FiiUId,
    :pi_emp_STE_FiiUId,
    :pi_emp_ZPK_FiiUId,
    :iVortragStd,
    :iVortragFerien,
    :pn_emp_SonderFerien,
    :pn_emp_AnspruchFerien,
    :pb_emp_IstCh,
    :pb_emp_LA_IstStunden,
    :pb_emp_LA_IstFerien,
    :pb_emp_LA_IstZahlstelle,
    :pb_emp_IstAktiv,
    Current_TimeStamp,
    :pi_app_ActiveUser,
    Current_TimeStamp,
    :pi_app_ActiveUser
  );

END!!


COMMENT ON PROCEDURE sp_Emp_Insert IS 'Add a new Employee and return Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Insert.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Insert.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Insert.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Insert.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_Update
(
    pi_emp_UId              DI_UID_NN,
    pi_emp_BuyUId           DI_UID_NN,
    pi_emp_PersNr           DI_INT_NN,
    ps_emp_PEIDNr           DS_STR20,
    ps_emp_Name             DS_STR50_NN,
    ps_emp_Vorname          DS_STR50_NN,
    ps_emp_Strasse          DS_STR50,
    ps_emp_HausNr           DS_STR5,
    pi_emp_LandUId          DI_UID_NN,
    ps_emp_PLZ              DS_PLZ_NN,
    ps_emp_SteuerGde        DS_PLZ_NN,
    ps_emp_Ort              DS_STR50_NN,
    pd_emp_GeburtsDatum     DD_DATE_NN,
    pd_emp_PensionDatum     DD_DATE_NN,
    ps_emp_Geschlecht       DS_ONECHARFLAG_NN,
    pd_emp_EintrittsDatum   DD_DATE_NN,
    pd_emp_AustrittsDatum   DD_DATE,
    ps_emp_Zivilstand       DS_ONECHARFLAG_NN,
    ps_emp_Aufenthalt       DS_ONECHARFLAG_NN,
    pi_emp_NationUId        DI_UID,
    ps_emp_HeimatOrt        DS_STR50,
    pi_emp_AnzKinder        DI_SMLINT,
    ps_emp_Telefon          DS_STR30,
    ps_emp_Handy            DS_STR30,
    ps_emp_Email            DS_STR30,
    ps_emp_EmailPasswort    DS_STR50,
    ps_emp_Beruf            DS_STR50,
    ps_emp_Stellung         DS_STR50,
    ps_emp_Lohnklasse       DS_STR50,
    pb_emp_IstCh            DB_BOOLEAN,
    ps_emp_Ch_PeidNr        DS_STR20,
    pi_emp_DepUId           DI_UID,
    pi_emp_CatUId           DI_UID,
    pi_emp_PrgUId           DI_UID_NN,
    pi_emp_EmiUId           DI_UID_NN,
    pi_emp_AHV_FiiUId       DI_UID,
    pi_emp_ALV_FiiUId       DI_UID,
    pi_emp_PK_FiiUId        DI_UID,
    pi_emp_KKP_FiiUId       DI_UID,
    pi_emp_KKT_FiiUId       DI_UID,
    pi_emp_UNF_FiiUId       DI_UID,
    pi_emp_STE_FiiUId       DI_UID,
    pi_emp_ZPK_FiiUId       DI_UID,
    pn_emp_VortragStd       DN_NUMBER2,
    pn_emp_VortragFerien    DN_NUMBER2,
    pn_emp_SonderFerien     DN_NUMBER2,
    pn_emp_AnspruchFerien   DN_NUMBER2,
    pb_emp_LA_IstStunden    DB_BOOLEAN_NN,
    pb_emp_LA_IstFerien     DB_BOOLEAN_NN,
    pb_emp_LA_IstZahlstelle DB_BOOLEAN_NN, 
    pb_emp_IstAktiv         DB_ISACTIVE_NN,
    pi_app_ActiveUser       DI_UID_NN
)
AS

  -- Update Employee data by Id
  
  DECLARE bIsIndustrialHours DB_BOOLEAN;
  DECLARE iVortragStd        DI_INT;  
  DECLARE iVortragFerien     DI_INT;  

BEGIN

  -- Einstellung Industrieminuten ermitteln 
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_emp_BuyUId )
   RETURNING_VALUES :bIsIndustrialHours;
    
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragStd,    :bIsIndustrialHours )
   RETURNING_VALUES :iVortragStd;
  
  EXECUTE PROCEDURE sp_WorkHoursToMinutes( :pn_emp_VortragFerien, :bIsIndustrialHours )
   RETURNING_VALUES :iVortragFerien;

  UPDATE emp_Employee
     SET emp_BuyUId           = :pi_emp_BuyUId                 ,
         emp_PersNr           = :pi_emp_PersNr                 ,
         emp_PEIDNr           = :ps_emp_PEIDNr                 ,
         emp_Name             = :ps_emp_Name            ,
         emp_Vorname          = :ps_emp_Vorname         ,
         emp_Strasse          = :ps_emp_Strasse         ,
         emp_HausNr           = :ps_emp_HausNr          ,
         emp_LandUId          = :pi_emp_LandUId         ,
         emp_PLZ              = :ps_emp_PLZ             ,
         emp_SteuerGde        = :ps_emp_SteuerGde       ,
         emp_Ort              = :ps_emp_Ort             ,
         emp_GeburtsDatum     = :pd_emp_GeburtsDatum    ,
         emp_PensionDatum     = :pd_emp_PensionDatum    ,
         emp_Geschlecht       = :ps_emp_Geschlecht      ,
         emp_EintrittsDatum   = :pd_emp_EintrittsDatum  ,
         emp_AustrittsDatum   = :pd_emp_AustrittsDatum  ,
         emp_Zivilstand       = :ps_emp_Zivilstand      ,
         emp_Aufenthalt       = :ps_emp_Aufenthalt      ,
         emp_NationUId        = :pi_emp_NationUId       ,
         emp_HeimatOrt        = :ps_emp_HeimatOrt       ,
         emp_AnzKinder        = :pi_emp_AnzKinder       ,
         emp_Telefon          = :ps_emp_Telefon         ,
         emp_Handy            = :ps_emp_Handy           ,
         emp_Email            = :ps_emp_Email           ,
         emp_EmailPasswort    = :ps_emp_EmailPasswort   ,
         emp_Beruf            = :ps_emp_Beruf           ,
         emp_Stellung         = :ps_emp_Stellung        ,
         emp_Lohnklasse       = :ps_emp_Lohnklasse      ,
         emp_IstCh            = :pb_emp_IstCh           ,
         emp_Ch_PeidNr        = :ps_emp_Ch_PeidNr       ,
         emp_DepUId           = :pi_emp_DepUId          ,
         emp_CatUId           = :pi_emp_CatUId          ,
         emp_PrgUId           = :pi_emp_PrgUId          ,
         emp_EmiUId           = :pi_emp_EmiUId          ,
         emp_AHV_FiiUId       = :pi_emp_AHV_FiiUId      ,
         emp_ALV_FiiUId       = :pi_emp_ALV_FiiUId      ,
         emp_PK_FiiUId        = :pi_emp_PK_FiiUId       ,
         emp_KKP_FiiUId       = :pi_emp_KKP_FiiUId      ,
         emp_KKT_FiiUId       = :pi_emp_KKT_FiiUId      ,
         emp_UNF_FiiUId       = :pi_emp_UNF_FiiUId      ,
         emp_STE_FiiUId       = :pi_emp_STE_FiiUId      ,
         emp_ZPK_FiiUId       = :pi_emp_ZPK_FiiUId      ,
         emp_VortragStd       = :iVortragStd            ,
         emp_VortragFerien    = :iVortragFerien         ,
         emp_SonderFerien     = :pn_emp_SonderFerien    ,
         emp_AnspruchFerien   = :pn_emp_AnspruchFerien  ,
         emp_LA_IstStunden    = :pb_emp_LA_IstStunden   ,
         emp_LA_IstFerien     = :pb_emp_LA_IstFerien    ,
         emp_LA_IstZahlstelle = :pb_emp_LA_IstZahlstelle,
         emp_IstAktiv         = :pb_emp_IstAktiv        ,
         emp_MutDate          = Current_TimeStamp       ,
         emp_MutUsrUId        = :pi_app_ActiveUser
   WHERE emp_UId              = :pi_emp_UId;

END!!

COMMENT ON PROCEDURE sp_Emp_Update IS 'Update Employee by Employee Id'!!

COMMENT ON PARAMETER sp_Emp_Update.pi_emp_BuyUId           IS 'Business Year Id (FK)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PersNr           IS 'Personal Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PEIDNr           IS 'PEID-Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Name             IS 'Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Vorname          IS 'First Name'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Strasse          IS 'Street'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HausNr           IS 'House number'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_LandUId          IS 'Country, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_PLZ              IS 'Postal code'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Ort              IS 'Place'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_GeburtsDatum     IS 'Date of Birth'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_PensionDatum     IS 'Pension date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Geschlecht       IS 'Sex'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_EintrittsDatum   IS 'Admission date'!!
COMMENT ON PARAMETER sp_Emp_Update.pd_emp_AustrittsDatum   IS 'Leaving date'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Zivilstand       IS 'Marital status'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Aufenthalt       IS 'Aufenthalt(abidance)'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_NationUId        IS 'Nation, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_HeimatOrt        IS 'Hometown'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AnzKinder        IS 'Number of children'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Telefon          IS 'Phone Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Handy            IS 'Handy Number'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Email            IS 'EMail'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_EmailPasswort    IS 'Password for files which shoul be send encrypted via email'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Beruf            IS 'Profession'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Stellung         IS 'Position'!!
COMMENT ON PARAMETER sp_Emp_Update.ps_emp_Lohnklasse       IS 'Wage class'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_DepUId           IS 'Department, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_CatUId           IS 'Category, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PrgUId           IS 'PayrollGroup, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_EmiUId           IS 'EmployeePicture, FK'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_AHV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ALV_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_PK_FiiUId        IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKP_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_KKT_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_UNF_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_STE_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pi_emp_ZPK_FiiUId       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragStd       IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_VortragFerien    IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_SonderFerien     IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pn_emp_AnspruchFerien   IS ''!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstCh            IS 'Is getting wage from Switzerland'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstStunden    IS 'Setting for Report Lohnaberechnung, True = Print "Stunden"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstFerien     IS 'Setting for Report Lohnaberechnung, True = Print "Ferien"'!!
COMMENT ON PARAMETER sp_Emp_Update.pb_emp_LA_IstZahlstelle IS 'Setting for Report Lohnaberechnung, True = Print "Payout Bank"'!!

COMMENT ON PARAMETER sp_Emp_Update.pb_emp_IstAktiv         IS 'Active flag'!!
COMMENT ON PARAMETER sp_Emp_Update.pi_app_ActiveUser       IS 'Application active user id'!!

COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailMode',          'DI_INT'     )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailSenderAddress', 'DS_STR128'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailSenderName',    'DS_STR128'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailSubject',       'DS_STR255'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailHost',          'DS_STR128'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailPort',          'DI_INT'     )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailTLS',           'DI_INT'     )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailUser',          'DS_STR50'   )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailPassword',      'DS_STR255'  )!!
EXECUTE PROCEDURE sp_DDL_SafeAddField( 'fir_Firm', 'fir_EMailText',          'DS_STR1024' )!!

COMMIT!!
 
ALTER TABLE fir_Firm ALTER fir_EMailMode          POSITION 34!!
ALTER TABLE fir_Firm ALTER fir_EMailSenderAddress POSITION 35!!
ALTER TABLE fir_Firm ALTER fir_EMailSenderName    POSITION 36!!
ALTER TABLE fir_Firm ALTER fir_EMailSubject       POSITION 37!!
ALTER TABLE fir_Firm ALTER fir_EMailHost          POSITION 38!!
ALTER TABLE fir_Firm ALTER fir_EMailPort          POSITION 39!!
ALTER TABLE fir_Firm ALTER fir_EMailTLS           POSITION 40!!
ALTER TABLE fir_Firm ALTER fir_EMailUser          POSITION 41!!
ALTER TABLE fir_Firm ALTER fir_EMailPassword      POSITION 42!!
ALTER TABLE fir_Firm ALTER fir_EMailText          POSITION 43!!

COMMIT!!

COMMENT ON COLUMN fir_Firm.fir_EMailMode          IS 'Firm email usage mode'!!
COMMENT ON COLUMN fir_Firm.fir_EMailSenderAddress IS 'Firm specific email sender address'!!
COMMENT ON COLUMN fir_Firm.fir_EMailSenderName    IS 'Firm specific email sender name'!!
COMMENT ON COLUMN fir_Firm.fir_EMailSubject       IS 'Firm specific email subject'!!
COMMENT ON COLUMN fir_Firm.fir_EMailHost          IS 'Firm specific email SMTP host'!!
COMMENT ON COLUMN fir_Firm.fir_EMailPort          IS 'Firm specific email SMTP port'!!
COMMENT ON COLUMN fir_Firm.fir_EMailTLS           IS 'Firm specific email sender address'!!
COMMENT ON COLUMN fir_Firm.fir_EMailUser          IS 'Firm specific email user name'!!
COMMENT ON COLUMN fir_Firm.fir_EMailPassword      IS 'Firm specific email password'!!
COMMENT ON COLUMN fir_Firm.fir_EMailText          IS 'Firm specific email text'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_EMailMode           DI_INT,
    fir_EMailSenderAddress  DS_STR128,
    fir_EMailSenderName     DS_STR128,
    fir_EMailSubject        DS_STR255,
    fir_EMailHost           DS_STR128,
    fir_EMailPort           DI_INT,   
    fir_EMailTLS            DI_INT,   
    fir_EMailUser           DS_STR50, 
    fir_EMailPassword       DS_STR255,
    fir_EMailText           DS_STR1024,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_ReportTemplate,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_EMailMode,
           fir_EMailSenderAddress,
           fir_EMailSenderName,
           fir_EMailSubject,
           fir_EMailHost,
           fir_EMailPort,   
           fir_EMailTLS,   
           fir_EMailUser, 
           fir_EMailPassword,
           fir_EMailText,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_ReportTemplate,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_EMailMode,
           :fir_EMailSenderAddress,
           :fir_EMailSenderName,
           :fir_EMailSubject,
           :fir_EMailHost,
           :fir_EMailPort,   
           :fir_EMailTLS,   
           :fir_EMailUser, 
           :fir_EMailPassword,
           :fir_EMailText,
           
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!

COMMIT!!

-- FS#908:END

SET TERM ;!!
