﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.14
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#867:START - PKLohn - SP_PRA_RPTEINAUSTRITT crashes

CREATE OR ALTER PROCEDURE sp_Pra_RptEinAustritte 
(
    pi_BuyUId DI_UID,
    pi_Monat  DI_INT = NULL
)
RETURNS 
(
    buy_UId             DI_UID,
    pra_UId             DI_UID,
    emp_UId             DI_UID,
    emp_Peidnr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    emp_Land            DS_CODE,
    emp_Plz             DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Nation          DS_CODE,
    emp_Zivilstand      DS_ONECHARFLAG,
    emp_Ahv_FiiUId      DI_UID,
    emp_IstEintritt     DS_ONECHARFLAG,
    emp_IstAustritt     DS_ONECHARFLAG,
    emy_Besgrad         DN_NUMBER2,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50
)
AS
DECLARE VARIABLE iCbxMonat    DI_SMLINT;
DECLARE VARIABLE iPraMonat    DI_SMLINT;
DECLARE VARIABLE iPraJahr     DI_BUSINESSYEAR;
DECLARE VARIABLE iEinMonat    DI_SMLINT;
DECLARE VARIABLE iAusMonat    DI_SMLINT;
DECLARE VARIABLE iEinJahr     DI_BUSINESSYEAR;
DECLARE VARIABLE iAusJahr     DI_BUSINESSYEAR;
BEGIN

  pra_UId = NULL;

  iCbxMonat = :pi_Monat;

  SELECT FIRST 1 DISTINCT
          :iCbxMonat,
          buy_UId,
          buy_GeschJahr,
          pra_UId
     FROM buy_businessyear buy
     LEFT JOIN prm_PayrollMonth prm ON prm.prm_buyuid = buy.buy_uid  
     LEFT JOIN pra_PayrollAccount pra ON pra.pra_PrmUId = prm.prm_UId
     WHERE buy.buy_uid = :pi_BuyUId
     AND ( :pi_Monat IS NULL OR :pi_Monat = prm_Monat )
     AND prm_AbreNr = 0
    INTO :iPraMonat,
         :buy_UId,
         :iPraJAHR,
         :pra_UId;

  IF (buy_UId IS NOT NULL) THEN
  BEGIN

     FOR 
       SELECT DISTINCT emp_UId
         FROM emp_Employee
         LEFT JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UId
        WHERE emp_BuyUid = :buy_UId          
          AND emp_AHV_FiiUId IS NOT NULL
         INTO :emp_UId

     DO 
     BEGIN
       
        SELECT emp_PeidNr,      emp_Name,            emp_Vorname,         emp_Strasse,
               CL.coi_IsoCode,  emp_Plz,             emp_Ort,             emp_GeburtsDatum,
               emp_Geschlecht,  emp_EintrittsDatum,  emp_AustrittsDatum,  emp_Aufenthalt,
               emp_Zivilstand,  CN.coi_IsoCode,      emp_AHV_FiiUId,      fii_AbrechnungNr,
               fii_Code,        fii_Name,            fii_NameZusatz,      fii_Strasse,
               fii_Plz,         fii_Ort,             emp_HausNr
          FROM emp_Employee
          LEFT JOIN coi_CountryIso   CL ON CL.coi_UId = emp_LandUId
          LEFT JOIN coi_CountryIso   CN ON CN.coi_UId = emp_NationUId
          LEFT JOIN fii_FirmInstitution ON fii_UId    = emp_AHV_FiiUId
         WHERE emp_UID = :emp_UID
          INTO :emp_PeidNr,     :emp_Name,           :emp_Vorname,        :emp_Strasse,
               :emp_Land,       :emp_Plz,            :emp_Ort,            :emp_GeburtsDatum,
               :emp_Geschlecht, :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Aufenthalt,
               :emp_Zivilstand, :emp_Nation,         :emp_AHV_FiiUId,     :fii_AbrechnungNr,
               :fii_Code,       :fii_Name,           :fii_NameZusatz,     :fii_Strasse,
               :fii_Plz,        :fii_Ort,            :emp_HausNr;


       emp_IstEintritt = '0';
       emp_IstAustritt = '0';

       iEinMonat = EXTRACT( MONTH FROM :emp_EintrittsDatum );
       iEinJahr  = EXTRACT( YEAR  FROM :emp_EintrittsDatum );
       iAusMonat = 0;
       iAusJahr  = 0;


       IF (emp_AustrittsDatum IS NOT NULL) THEN 
       BEGIN
      
         iAusMonat = EXTRACT( MONTH FROM :emp_AustrittsDatum );
         iAusJahr  = EXTRACT( YEAR  FROM :emp_AustrittsDatum );

       END

       IF ( ( iPraJahr = iEinJahr ) AND ( iPraMONAT = iEinMonat ) ) THEN
       BEGIN
         emp_IstEintritt = '1';
       END 
          
       IF ( ( iPraJahr = iAusJahr ) AND ( iPraMonat = iAusMonat ) ) THEN 
       BEGIN
         emp_IstAustritt = '1';
       END 

      IF ( ( emp_IstEintritt = '1' ) OR ( emp_IstAustritt = '1' ) ) THEN 
      BEGIN
           
         -- BesGrad des Mitarbeiters bei der Abrechnung   
         FOR 
           SELECT emy_BesGrad 
             FROM emy_EmploymentPeriod 
            WHERE emy_EmpUId = :emp_UId 
             INTO :emy_BesGrad 
         DO 
         BEGIN
           
           IF ( emy_BesGrad IS NULL ) THEN 
             emy_BesGrad = 0;
             
         END

         SUSPEND;

      END

    END

  END

END!!
COMMIT!!
  
-- FS#867:END
-- +++

-- +++
-- FS#879:START - Report "Jahresabrechnung PK" value fields confused

CREATE OR ALTER PROCEDURE sp_Rpt_AnnualPk 
(
    pi_FiiUId   DI_UID,
    pi_EmpUId   DI_UID = NULL,
    pi_LandUId  DI_UID = NULL,
    pi_DepUId   DI_UID = NULL,
    pi_CatUId   DI_UID = NULL,
    pi_PrgUId   DI_UID = NULL
)
RETURNS 
(
    emp_UId             DI_UID,
    emy_UId             DI_UID,
    emy_PjAnfang        DD_DATE,
    emy_PjEnde          DD_DATE,
    emy_Besgrad         DN_NUMBER2,
    emy_IsUnemployed    DB_BOOLEAN,
    lohn_Brutto         DN_NUMBER2,
    lohn_Ahv            DN_NUMBER2,
    k1_SaxUId           DI_UID,
    k1_SaxBez           DS_DESCR,
    k1_Pflicht          DN_NUMBER2,
    k1_FreiBetrag       DN_NUMBER2,
    k1_Beitrag_An       DN_NUMBER2,
    k1_Beitrag_Ag       DN_NUMBER2,
    k2_SaxUId           DI_UID,
    k2_SaxBez           DS_DESCR,
    k2_Pflicht          DN_NUMBER2,
    k2_FreiBetrag       DN_NUMBER2,
    k2_Beitrag_An       DN_NUMBER2,
    k2_Beitrag_Ag       DN_NUMBER2,
    k3_SaxUId           DI_UID,
    k3_SaxBez           DS_DESCR,
    k3_Pflicht          DN_NUMBER2,
    k3_FreiBetrag       DN_NUMBER2,
    k3_Beitrag_An       DN_NUMBER2,
    k3_Beitrag_Ag       DN_NUMBER2,
    k4_SaxUId           DI_UID,
    k4_SaxBez           DS_DESCR,
    k4_Pflicht          DN_NUMBER2,
    k4_FreiBetrag       DN_NUMBER2,
    k4_Beitrag_An       DN_NUMBER2,
    k4_Beitrag_Ag       DN_NUMBER2,
    buy_GeschJahr       DI_BUSINESSYEAR,
    fir_Code            DS_CODE,
    fir_Bezeichnung     DS_DESCR,
    fir_Bezeichnung2    DS_STR50,
    fir_Strasse         DS_STR50,
    fir_HausNr          DS_STR5,
    fir_Plz             DS_PLZ,
    fir_Ort             DS_STR50,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50,
    emp_PersNr          DI_INT,
    emp_PeidNr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    coi_IsoCode         DS_CODE,
    emp_Plz             DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_PensionDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE
)
AS
DECLARE VARIABLE sStmt      VARCHAR(512);
DECLARE VARIABLE iBuyUId    DI_UID;
DECLARE VARIABLE sIntTyp    DS_STR3;
DECLARE VARIABLE iCounter   DI_SMLINT;
DECLARE VARIABLE iSaxUId    DI_UID;
DECLARE VARIABLE sSaxBez    DS_DESCR;
DECLARE VARIABLE nFrei      DN_NUMBER2;
DECLARE VARIABLE nPflicht   DN_NUMBER2;
DECLARE VARIABLE nBeitragAg DN_NUMBER2;
DECLARE VARIABLE nBeitragAn DN_NUMBER2;
DECLARE VARIABLE iEmy_UId   DI_UID;
BEGIN


   -- Get Data from FirmInstitution and Firm for all records 
  SELECT I.FII_BUYUID, 
         I.FII_ABRECHNUNGNR,
         I.FII_CODE,
         I.FII_NAME,
         I.FII_NAMEZUSATZ,
         I.FII_STRASSE,
         I.FII_PLZ,
         I.FII_ORT,
         Y.BUY_GESCHJAHR,
         F.FIR_CODE,
         F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,  
         F.fir_HausNr,
         F.FIR_PLZ,  
         F.FIR_ORT,
         IT.INT_TYP   

    FROM FII_FIRMINSTITUTION I

    LEFT JOIN BUY_BUSINESSYEAR    Y  ON Y.BUY_UID  = I.FII_BUYUID
    LEFT JOIN FIR_FIRM            F  ON F.FIR_UID  = Y.BUY_FIRUID
    LEFT JOIN INT_INSTITUTIONTYPE IT ON IT.INT_UID = I.FII_INTUID
       
    WHERE I.FII_UID=:PI_FIIUID 

    INTO :iBUYUID,
         :FII_ABRECHNUNGNR,
         :FII_CODE,
         :FII_NAME,
         :FII_NAMEZUSATZ,
         :FII_STRASSE,
         :FII_PLZ,
         :FII_ORT,
         :BUY_GESCHJAHR,
         :FIR_CODE,
         :FIR_BEZEICHNUNG,
         :FIR_BEZEICHNUNG2,
         :FIR_STRASSE, 
         :fir_HausNr,
         :FIR_PLZ,  
         :FIR_ORT,
         :sIntTyp;


  sStmt = 'SELECT EMP_UID FROM EMP_EMPLOYEE   '||
          'WHERE (EMP_BUYUID = :piBUYUID)     ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  IF (( PI_PRGUID IS NOT NULL ) AND (PI_PRGUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_PRGUID= ' || PI_PRGUID || ')';

  sStmt = sStmt || ' AND (EMP_PK_FIIUID IS NOT NULL) AND (EMP_PK_FIIUID = :piFIIUid )' ;

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :iBUYUID, piFIIUid := :PI_FIIUID )
      INTO :EMP_UID 
  DO 
  BEGIN

   
     FOR SELECT EMY_UID 
           FROM EMY_EMPLOYMENTPERIOD
          WHERE EMY_EMPUID=:EMP_UID 
          ORDER BY EMY_PJANFANG
           INTO :iEMY_UID
     DO 
     BEGIN
      
        iCounter = 0;


        K1_SAXUID     = NULL;    K3_SAXUID     = NULL;
        K1_SAXBEZ     = NULL;    K3_SAXBEZ     = NULL;
        K1_PFLICHT    = NULL;    K3_PFLICHT    = NULL;
        K1_FREIBETRAG = NULL;    K3_FREIBETRAG = NULL;
        K1_BEITRAG_AN = NULL;    K3_BEITRAG_AN = NULL; 
        K1_BEITRAG_AG = NULL;    K3_BEITRAG_AG = NULL;
        K2_SAXUID     = NULL;    K4_SAXUID     = NULL;
        K2_SAXBEZ     = NULL;    K4_SAXBEZ     = NULL;
        K2_PFLICHT    = NULL;    K4_PFLICHT    = NULL;
        K2_FREIBETRAG = NULL;    K4_FREIBETRAG = NULL;
        K2_BEITRAG_AN = NULL;    K4_BEITRAG_AN = NULL;
        K2_BEITRAG_AG = NULL;    K4_BEITRAG_AG = NULL;



        FOR SELECT SAX_UID,
                   EMY_UID,
                   EMY_PJANFANG,
                   EMY_PJENDE,
                   EMY_BESGRAD,
                   EMY_ISUNEMPLOYED,
                   BRUTTOLOHN,
                   FREIBETRAG,
                   PFLICHTLOHN,
                   BEITRAGAG,
                   BEITRAGAN              
              FROM  SP_RPT_PERIOD_HLP ( :iEMY_UID, :sIntTyp )
             ORDER BY SAX_UID
              INTO :iSaxUID,
                   :EMY_UID,
                   :EMY_PJANFANG,
                   :EMY_PJENDE,
                   :EMY_BESGRAD,
                   :EMY_ISUNEMPLOYED,
                   :LOHN_BRUTTO, 
                   :nFrei, 
                   :nPflicht,
                   :nBeitragAG,
                   :nBeitragAN

        DO 
        BEGIN

           SELECT SAX_BEZEICHNUNG 
             FROM SAX_SALARYCATEGORIE
            WHERE SAX_UID = :iSaxUID
             INTO :sSaxBez;

           iCounter = iCounter + 1; 

           IF (iCounter = 1) THEN 
           BEGIN        

              K1_SAXUID     = iSaxUID;
              K1_SAXBEZ     = sSaxBez;
              K1_PFLICHT    = nPflicht;
              K1_FREIBETRAG = nFrei;
              K1_BEITRAG_AG = nBeitragAG;
              K1_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 2) THEN 
           BEGIN        

              K2_SAXUID     = iSaxUID;
              K2_SAXBEZ     = sSaxBez;
              K2_PFLICHT    = nPflicht;
              K2_FREIBETRAG = nFrei;
              K2_BEITRAG_AG = nBeitragAG;
              K2_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 3) THEN 
           BEGIN        

              K3_SAXUID     = iSaxUID;
              K3_SAXBEZ     = sSaxBez;
              K3_PFLICHT    = nPflicht;
              K3_FREIBETRAG = nFrei;
              K3_BEITRAG_AG = nBeitragAG;
              K3_BEITRAG_AN = nBeitragAN;

           END 
           ELSE 
           IF (iCounter = 4) THEN 
           BEGIN        

              K4_SAXUID     = iSaxUID;
              K4_SAXBEZ     = sSaxBez;
              K4_PFLICHT    = nPflicht;
              K4_FREIBETRAG = nFrei;
              K4_BEITRAG_AG = nBeitragAG;
              K4_BEITRAG_AN = nBeitragAN;

           END

        END

        IF (iCounter > 0) THEN 
        BEGIN

           -- AHV-Pflichtiger Lohn 

           SELECT SUM(D.SAD_BASIS)

              FROM EMY_EMPLOYMENTPERIOD Y
     
              INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
              INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
              LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
              LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
              LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
              LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
              LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID

           WHERE (Y.EMY_UID=:iEMY_UID) AND (A.PRA_ISTVERBUCHT = 1) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND (T.SDT_BERECHBASISNR=1)

           INTO :LOHN_AHV;   



           -- Get data from Employee
           SELECT E.EMP_PERSNR,
                  E.EMP_PEIDNR,
                  E.EMP_NAME,
                  E.EMP_VORNAME,
                  E.EMP_STRASSE,
                  E.emp_HausNr,
                  C.COI_ISOCODE,
                  E.EMP_PLZ,
                  E.EMP_ORT, 
                  E.EMP_GEBURTSDATUM, 
                  E.EMP_PENSIONDATUM, 
                  E.EMP_GESCHLECHT,
                  E.EMP_EINTRITTSDATUM,
                  E.EMP_AUSTRITTSDATUM


            FROM EMP_EMPLOYEE E

            LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID = E.EMP_LANDUID
 
            WHERE E.EMP_UID = :EMP_UID

            INTO :EMP_PERSNR,
                 :EMP_PEIDNR,
                 :EMP_NAME,
                 :EMP_VORNAME,
                 :EMP_STRASSE,
                 :emp_HausNr,
                 :COI_ISOCODE,
                 :EMP_PLZ,
                 :EMP_ORT, 
                 :EMP_GEBURTSDATUM, 
                 :EMP_PENSIONDATUM, 
                 :EMP_GESCHLECHT,
                 :EMP_EINTRITTSDATUM,
                 :EMP_AUSTRITTSDATUM;


           SUSPEND; 

        END

     END

  END

END!!
COMMIT!!

-- FS#879:END
-- +++

-- +++
-- FS#870:START - PKLohn - ISO20022 Payment Method

EXECUTE PROCEDURE sp_DDL_SafeAddField 'fir_Firm', 'fir_ISO_Pfad', 'DS_STR2048'!!
ALTER TABLE fir_Firm ALTER fir_ISO_Pfad POSITION 32!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeAddField 'fir_Firm', 'fir_ISO_SpesenTyp', 'DS_ONECHARFLAG_NN DEFAULT '''''!!
ALTER TABLE fir_Firm ALTER fir_ISO_SpesenTyp POSITION 32!!
COMMIT!!

EXECUTE BLOCK AS
    DECLARE iLukCount DI_INT;    
    DECLARE iLukUId DI_INT;    
BEGIN
    
    SELECT COUNT(1) 
      FROM luk_Lookup
     WHERE luk_Gruppe = 'VERG_TYP' AND luk_Code = 6
      INTO :iLukCount;
      
    IF (iLukCount = 0) THEN
    BEGIN
        
        EXECUTE PROCEDURE sp_Luk_Insert 'VERG_TYP', 6, 'ISO20022-Auftrag', 0, 1, 1
         RETURNING_VALUES :iLukUId;
        
    END
    
END!!
COMMIT!!

--

ALTER TABLE emb_EmployeeBank DROP CONSTRAINT CHK_EMB_VERGTYP!!
ALTER TABLE emb_EmployeeBank ADD  CONSTRAINT CHK_EMB_VERGTYP CHECK ( emb_VergTyp IN ('1', '2', '3', '4', '5', '6' ) )!!

--

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                 DI_UID,
    fir_Code                DS_CODE,
    fir_Bezeichnung         DS_DESCR,
    fir_Bezeichnung2        DS_STR50,
    fir_Strasse             DS_STR50,
    fir_HausNr              DS_STR5,
    fir_Postfach            DS_STR50,
    fir_Plz                 DS_PLZ,
    fir_Ort                 DS_STR50,
    fir_Telefon             DS_STR50,
    fir_Fax                 DS_STR50,
    fir_Email               DS_STR50,
    fir_PeidNr              DS_STR12,
    fir_Notiz               DS_TEXT,
    fir_CoiUId              DI_UID,
    fir_La_Text             DS_STR1024,
    fir_La_LayoutTyp        DS_ONECHARFLAG,
    fir_La_KopfTyp          DS_ONECHARFLAG,
    fir_La_SortTyp          DS_ONECHARFLAG,
    fir_La_Logoname         DS_STR50,
    fir_La_IstStunden       DB_BOOLEAN,
    fir_La_IstFerien        DB_BOOLEAN,
    fir_La_IstZahlstelle    DB_BOOLEAN,
    fir_La_ReportTemplate   DS_STR2048,
    fir_Va_LayoutTyp        DS_ONECHARFLAG,
    fir_Va_KopfTyp          DS_ONECHARFLAG,
    fir_Va_Logoname         DS_STR50,
    fir_Dta_Pfad            DS_STR2048,
    fir_Dta_SpesenTyp       DS_ONECHARFLAG,
    fir_Ezag_Pfad           DS_STR2048,
    fir_Ezag_SpesenTyp      DS_ONECHARFLAG,
    fir_ISO_Pfad            DS_STR2048,
    fir_ISO_SpesenTyp       DS_ONECHARFLAG,
    fir_IstAktiv            DB_ISACTIVE,
    fir_CreateDate          DD_TIMESTAMP,
    fir_CreateUsrUId        DI_UID,
    fir_MutDate             DD_TIMESTAMP,
    fir_MutUsrUId           DI_UID,
    fir_CuiIsoCode          DS_CODE,
    fir_CuiUId              DI_UID,
    fir_CreateUser          DS_USERLOGIN,
    fir_MutUser             DS_USERLOGIN,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_ReportTemplate,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_ISO_Pfad,
           fir_ISO_SpesenTyp,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_ReportTemplate,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_ISO_Pfad,
           :fir_ISO_SpesenTyp,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!
COMMIT!!

-- 

CREATE OR ALTER PROCEDURE sp_Pra_PaymentOrdersBanks 
(
    pi_PraUId   DI_UID,
    ps_VergTyp  DS_ONECHARFLAG = NULL
)
RETURNS 
(
    fib_UId             DI_UID,
    fib_Code            DS_BANK,
    fib_BanUId          DI_UID,
    fib_DtaAbsenderId   DS_STR5,
    fib_DtaZlgArt       DS_ONECHARFLAG,
    fib_KontoNr         DS_STR35,
    fib_IbanNr          DS_STR35,
    ban_Name            DS_STR50,
    ban_Strasse         DS_STR50,
    ban_Postfach        DS_STR50,
    ban_Plz             DS_PLZ,
    ban_Ort             DS_STR50,
    ban_BcNr            DS_STR5,
    ban_Swift           DS_STR15
)
AS
BEGIN
  
  -- Get unique FirmBank-List from PaymentOrders

  FOR 
    SELECT DISTINCT emb_FibUId  
     FROM sp_Pra_PaymentOrders( :pi_PraUId, :ps_VergTyp )
     INTO :fib_UId
  DO 
  BEGIN
     
    SELECT  ban_Code,
            fib_BanUId,  
            fib_DtaAbsenderId,
            fib_DtaZlgArt,
            fib_kontoNr,
            fib_IbanNr,
            ban_Name,
            ban_Strasse,
            ban_Postfach,
            ban_Plz,
            ban_Ort,
            ban_BcNr,
            ban_Swift
      FROM fib_Firmbank
      LEFT JOIN ban_Bank ON ban_UId = fib_BanUId      
     WHERE fib_UId = :fib_UId
      INTO :fib_Code,
           :fib_BanUId, 
           :fib_DtaAbsenderId,
           :fib_DtaZlgArt,
           :fib_kontoNr,
           :fib_IbanNr,
           :ban_Name,         
           :ban_Strasse,      
           :ban_Postfach,     
           :ban_Plz,          
           :ban_Ort,
           :ban_BcNr,
           :ban_Swift;
         
     SUSPEND;
 
  END

END!!
COMMIT!!

--

EXECUTE BLOCK AS

  DECLARE iAprUId DI_UID;
  DECLARE iAptUId DI_UID;

BEGIN
    
  EXECUTE PROCEDURE sp_Apr_InsertOrUpdate 31, 2, 'Vergütungsauftrag ISO Report', 'Vergütungsauftrag Report', 1, 1
   RETURNING_VALUES :iAprUId;
   
  EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iAprUId, 'VergütungsauftragISO', 'AuftragISO.fr3', '', 1, 1, 1
   RETURNING_VALUES :iAptUId;
    
END!!
COMMIT!!

-- FS#870:END
--+++



SET TERM ;!!
