﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.13
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#863:START - PKLohn - Improved error messages

EXECUTE BLOCK
AS
BEGIN
  
  UPDATE ape_appException
     SET ape_Meldung = 'Abrechnungsgruppe kann nicht gelöscht werden.' ||ASCII_CHAR(13)||ASCII_CHAR(10)|| 
                       'Wird in Abrechnungsvorlage verwendet.'
   WHERE ape_UId = 'FK_PRMPRG2PRG';
  
END!!
COMMIT!!

-- FS#863:END
-- 

-- +++
-- FS#857:START - PKLohn - New Meldung type for ClosePraFRM

CREATE OR ALTER PROCEDURE sp_Pra_CloseAccountMessages( pi_PraUId DI_UID )
RETURNS 
(
  emp_UId       DI_UID,
  emp_PersNr    DI_INT,
  emp_Name      DS_STR50,
  emp_Vorname   DS_STR50,
  say_Anzdet    DI_INT,
  pra_Message   DS_STR128
)
AS

DECLARE VARIABLE iSayUId      DI_UID;
DECLARE VARIABLE iSdtUId      DI_UID;
DECLARE VARIABLE iAnzAhl      DI_UID;
DECLARE VARIABLE sSadText     DS_DESCR;
DECLARE VARIABLE sLArt        DS_STR5;
DECLARE VARIABLE dGebDatum    DD_DATE;
DECLARE VARIABLE dPensDatum   DD_DATE;
DECLARE VARIABLE dSayVon      DD_DATE;
DECLARE VARIABLE sAufenthalt  DS_ONECHARFLAG;
DECLARE VARIABLE iGesJahr     DI_BUSINESSYEAR;
DECLARE VARIABLE iAlter       DI_UID;
DECLARE VARIABLE iAnzAhv      DI_UID;
DECLARE VARIABLE iAnzAlv      DI_UID;
DECLARE VARIABLE iAnzPk       DI_UID;
DECLARE VARIABLE iAnzKk       DI_UID;
DECLARE VARIABLE iAnzUnf      DI_UID;
DECLARE VARIABLE iAnzSte      DI_UID;
DECLARE VARIABLE iAnzZpk      DI_UID;
DECLARE VARIABLE sIntTyp      DS_STR3;

BEGIN

   -- Meldungen und Fehler wenn Abrechnung verucht wird

  FOR 
    SELECT  el.emp_UId,
            el.emp_PersNr,
            el.emp_Name, 
            el.emp_Vorname, 
            el.say_UId,
            el.say_AnzDetails,
            el.emp_GeburtsDatum,
            el.emp_PensionDatum,
            el.buy_GeschJahr,
            el.say_DatumVom,
            e.emp_Aufenthalt
      FROM sp_Pra_EmployeeList( :pi_PraUId ) el
      LEFT JOIN emp_Employee e ON e.emp_UId = el.emp_UId
      INTO :emp_UId,
           :emp_PersNr,
           :emp_Name,
           :emp_Vorname,
           :iSayUId,
           :say_Anzdet,
           :dGebDatum,
           :dPensDatum, 
           :iGesJahr,
           :dSayVon,
           :sAufenthalt
  DO 
  BEGIN

    pra_Message = NULL;

    IF ( ( iSayUId IS NULL ) OR ( say_Anzdet = 0 ) ) THEN 
    BEGIN

      -- Keine Lohndaten 
      pra_Message = 'Mitarbeitende hat keine Lohndaten';
       
      SUSPEND;

    END 
    ELSE 
    BEGIN

      -- Doppelete Lohnpositionen prüefen  ---
      FOR 
        SELECT  sad_SdtUId,
                COUNT(*) 
          FROM sad_SalaryDetail
         WHERE sad_SayUId=:iSayUId
         GROUP BY sad_SdtUId
        HAVING COUNT(*) > 1
          INTO :iSdtUId,
               :iAnzAhl
      DO 
      BEGIN

        SELECT sdt_LArt 
          FROM sdt_SalaryDeductionType
         WHERE sdt_UId = :iSdtUId
          INTO :sLArt;

        pra_Message = 'Mitarbeitende hat doppelte Lohnpositionen [' || CAST( iAnzAhl AS VARCHAR(4) ) || 'x ' || sLArt || ']';
     
        SUSPEND;

      END

      FOR
        SELECT sad_Text
          FROM sad_SalaryDetail
          JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
         WHERE sad_SayUId = :iSayUId
           AND sdt_Typ = 'A'
           AND sad_Total < 0
         GROUP BY 1
          INTO :sSadText
      DO
      BEGIN
      
        pra_Message = 'Abzugsart <' || sSadText ||  '> rechnet einen negativen Betrag';
        SUSPEND;
        
      END


      -- Abzuege pruefen  ---
      iAnzAhv = 0;
      iAnzAlv = 0;
      iAnzPk  = 0;
      iAnzKk  = 0;
      iAnzUnf = 0;
      iAnzSte = 0;
      iAnzZpk = 0;

      FOR 
        SELECT int_Typ, COUNT(*)
          FROM sad_SalaryDetail
          LEFT JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
          LEFT JOIN int_InstitutionType     ON int_UId = sdt_IntUId
         WHERE ( sad_SayUId = :iSayUId ) AND ( sdt_Typ = 'A' )
         GROUP BY int_Typ
          INTO :sIntTyp, :iAnzAhl

      DO 
      BEGIN

        IF ( sIntTyp = 'AHV' ) THEN
          iAnzAhv = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'ALV' ) THEN
          iAnzAlv = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'PK'  ) THEN
          iAnzPk = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'KK'  ) THEN
          iAnzKk = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'UNF' ) THEN
            iAnzUnf = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'STE' ) THEN
          iAnzSte = iAnzAhl;
        ELSE 
        IF ( sIntTyp = 'ZPK' ) THEN
            iAnzZpk = iAnzAhl;        

      END 


      -- ALter des Mitarbeitenden
      iAlter = iGesJahr  - EXTRACT( YEAR FROM dGebDatum );

      IF ( ( iAlter >= 18 ) AND ( iAlter <= 64 ) AND ( dSayVon < dPensDatum ) ) THEN 
      BEGIN

        IF ( iAnzAhv = 0 ) THEN 
        BEGIN

           pra_Message = 'Mitarbeitende hat keinen AHV-Abzug';
           SUSPEND;

        END

        IF ( iAnzAlv = 0 ) THEN 
        BEGIN

           pra_Message = 'Mitarbeitende hat keinen ALV-Abzug';
           SUSPEND;

        END

        IF ( iAnzPk = 0 ) THEN 
        BEGIN

           pra_Message = 'Mitarbeitende hat keinen PK-Abzug';
           SUSPEND;

        END

      END


      IF ( sAufenthalt = '1' ) THEN 
      BEGIN                -- Aufenthalt: Wohnhaft im FL

        IF ( iAnzSte = 0 ) THEN 
        BEGIN

          pra_Message = 'Mitarbeitende hat keinen Steuer-Abzug';
          SUSPEND;

        END

      END 
      ELSE 
      IF ( sAufenthalt = '2' ) THEN 
      BEGIN       -- Aufenthalt: Grenzgaenger CH

         IF ( iAnzSte > 0 ) THEN 
         BEGIN

          pra_Message = 'Steuer-Abzug für CH-Grenzgänger definiert';
          SUSPEND;

         END


      END 
      ELSE 
      IF ( sAufenthalt = '3' ) THEN 
      BEGIN       -- Aufenthalt: Grenzgaenger AT

        IF ( iAnzSte = 0 ) THEN 
        BEGIN

          pra_Message = 'Mitarbeitende hat keinen Quellsteuer-Abzug';
          SUSPEND;

        END

      END 
      ELSE 
      IF ( sAufenthalt = '4' ) THEN 
      BEGIN       -- Aufenthalt: Grenzgaenger DE


      END 
      ELSE 
      BEGIN                                   -- Aufenthalt: andere


      END

    END   

  END

END!!
COMMIT!!

-- FS#857:END
-- +++
    
SET TERM ;!!
