﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.12
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#835:START - PKLohn - Improvement in SP_RPT_HOURS_SURVEY

CREATE OR ALTER PROCEDURE sp_Rpt_Hours_Survey 
(
  pi_BuyUId     DI_UID,
  pi_MonatVon   DI_SMLINT,
  pi_MonatBis   DI_SMLINT,
  pi_EmpUId     DI_UID = null,
  pi_LandUId    DI_UID = null,
  pi_DepUId     DI_UID = null,
  pi_CatUId     DI_UID = null,
  pi_PrgUId     DI_UID = null
)
RETURNS 
(
  buy_GeschJahr             DI_BUSINESSYEAR,
  buy_IstIndustrieMinuten   DB_BOOLEAN,
  fir_Code                  DS_CODE,
  fir_Bezeichnung           DS_DESCR,
  fir_Bezeichnung2          DS_STR50,
  fir_Strasse               DS_STR50,
  fir_HausNr                DS_STR5,
  fir_Plz                   DS_PLZ,
  fir_Ort                   DS_STR50,
  emp_Uid                   DI_UID,
  emp_PersNr                DI_INT,
  emp_PeidNr                DS_STR20,
  emp_Name                  DS_STR50,
  emp_Vorname               DS_STR50,
  emp_Strasse               DS_STR50,
  emp_HausNr                DS_STR5,
  coi_IsoCode               DS_CODE,
  emp_Plz                   DS_PLZ,
  emp_Ort                   DS_STR50,
  emp_GeburtsDatum          DD_DATE,
  monat_Von                 DI_SMLINT,
  monat_Bis                 DI_SMLINT,
  emh_Monat                 DI_INT,
  emh_Soll_Tage             DN_NUMBER2,
  emh_Soll_AzTag            DN_NUMBER2,
  emh_Soll_AzMonat          DN_NUMBER2,
  emh_Ist_AzMonat           DN_NUMBER2,
  emh_Ist_FerienTage        DN_NUMBER2,
  emh_Ist_FerienStd         DN_NUMBER2,
  emh_Ist_AbsenzTage        DN_NUMBER2,
  emh_Ist_AbsenzStd         DN_NUMBER2,
  emh_Ist_KrankTage         DN_NUMBER2,
  emh_Ist_KrankStd          DN_NUMBER2,
  emh_Ist_KorrGz            DN_NUMBER2,
  fer_Vortrag_Tage          DN_NUMBER2,
  fer_Anspruch_Tage         DN_NUMBER2,
  fer_Sonder_Tage           DN_NUMBER2,
  total_Ist_Std             DN_NUMBER2,
  total_Diff_Monat          DN_NUMBER2,
  total_Gz_Saldo            DN_NUMBER2,
  total_Fer_Saldo           DN_NUMBER2,
  total_Fer_Tage            DN_NUMBER2,
  total_Soll_AzTag          DN_NUMBER2
)
AS
DECLARE VARIABLE sStmt    DS_STR512;
DECLARE VARIABLE iCoiUId  DI_INT;
BEGIN
   
    -- Get Firm - Fields 
    SELECT Y.BUY_GESCHJAHR,
           F.FIR_CODE, 
           F.FIR_BEZEICHNUNG, 
           F.FIR_BEZEICHNUNG2,
           F.FIR_STRASSE,
           F.fir_HausNr,
           F.FIR_PLZ,
           F.FIR_ORT   
      FROM BUY_BUSINESSYEAR Y
      LEFT JOIN FIR_FIRM F ON F.FIR_UID=Y.BUY_FIRUID
     WHERE BUY_UID = :PI_BUYUID
      INTO :BUY_GESCHJAHR,
           :FIR_CODE,
           :FIR_BEZEICHNUNG,
           :FIR_BEZEICHNUNG2,
           :FIR_STRASSE,
           :fir_HausNr,
           :FIR_PLZ,
           :FIR_ORT; 



  sStmt = 'SELECT EMP_UID, EMP_PERSNR, EMP_PEIDNR, EMP_NAME, EMP_VORNAME,      '||
          '       EMP_STRASSE, emp_HausNr, EMP_LANDUID, EMP_PLZ, EMP_ORT, EMP_GEBURTSDATUM '|| 
          ' FROM EMP_EMPLOYEE                                                  '||
          ' WHERE (EMP_BUYUID = :piBUYUID) ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  -- Monatsbereich fuer Liste zurueckgeben--

  MONAT_VON  = PI_MONATVON;
  MONAT_BIS  = PI_MONATBIS;


  FOR 
    EXECUTE STATEMENT (sStmt) ( piBUYUID := :PI_BUYUID )
      INTO :EMP_UID,     :EMP_PERSNR,  :EMP_PEIDNR, :EMP_NAME, :EMP_VORNAME,
           :EMP_STRASSE, :emp_HausNr, :iCoiUid, :EMP_PLZ,    :EMP_ORT, :EMP_GEBURTSDATUM
 
  DO 
  BEGIN

     SELECT COI_ISOCODE 
       FROM COI_COUNTRYISO
      WHERE COI_UID = :iCoiUid 
       INTO :COI_ISOCODE;


     SELECT EMH_MONAT,
            EMH_SOLL_TAGE,
            EMH_SOLL_AZTAG,
            EMH_SOLL_AZMONAT,
            EMH_IST_AZMONAT,
            EMH_IST_FERIENTAGE,
            EMH_IST_FERIENSTD,
            EMH_IST_ABSENZTAGE,
            EMH_IST_ABSENZSTD,
            EMH_IST_KRANKTAGE,
            EMH_IST_KRANKSTD,
            EMH_IST_KORRGZ,
            FER_VORTRAG_TAGE,
            FER_ANSPRUCH_TAGE,
            FER_SONDER_TAGE,
            TOTAL_IST_STD,
            TOTAL_DIFF_MONAT,
            TOTAL_GZ_SALDO,
            TOTAL_FER_SALDO,
            TOTAL_FER_TAGE,
            TOTAL_SOLL_AZTAG,
            BUY_ISTINDUSTRIEMINUTEN
       FROM SP_RPT_HOURSPEREMP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS )
      WHERE (EMH_MONAT = 13)         
       INTO :EMH_MONAT,
            :EMH_SOLL_TAGE,
            :EMH_SOLL_AZTAG,
            :EMH_SOLL_AZMONAT,
            :EMH_IST_AZMONAT,
            :EMH_IST_FERIENTAGE,
            :EMH_IST_FERIENSTD,
            :EMH_IST_ABSENZTAGE,
            :EMH_IST_ABSENZSTD,
            :EMH_IST_KRANKTAGE,
            :EMH_IST_KRANKSTD,
            :EMH_IST_KORRGZ,
            :FER_VORTRAG_TAGE,
            :FER_ANSPRUCH_TAGE,
            :FER_SONDER_TAGE,
            :TOTAL_IST_STD,
            :TOTAL_DIFF_MONAT, 
            :TOTAL_GZ_SALDO,
            :TOTAL_FER_SALDO,
            :TOTAL_FER_TAGE,
            :TOTAL_SOLL_AZTAG,
            :BUY_ISTINDUSTRIEMINUTEN;

       -- Feriensaldo (Tage) einfügen (Monat 13 hat keine Ferien Saldo)--

     SELECT TOTAL_FER_TAGE
       FROM SP_RPT_HOURSPEREMP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS )
      WHERE (EMH_MONAT = :PI_MONATBIS)         
       INTO :TOTAL_FER_TAGE;
    
     SUSPEND;  

  END

END!!
COMMIT!!

-- FS#835:END
-- +++

-- +++
-- FS#825:START - Incorrect number of records in form „Firm Selection“

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUser 
(
    pi_UsrUId     DI_UID_NN,
    pb_InFirm     DB_BOOLEAN_NN,
    pb_IstAktiv   DB_BOOLEAN
)
RETURNS 
(
    fir_UId         DI_UID,
    fir_Code        DS_CODE,
    fir_Bezeichnung DS_DESCR,
    fir_Postfach    DS_STR50,
    fir_Strasse     DS_STR50,
    fir_Plz         DS_PLZ,
    fir_Ort         DS_STR50,
    fir_PlzOrt      DS_STR80,
    fir_IstAktiv    DB_BOOLEAN,
    fir_CuiIsoCode  DS_CODE,
    fir_CuiUId      DI_UID,
    fir_CoiUId      DI_UID,
    coi_IsoCode     DS_CODE
)
AS
  /* Select firms accessable/restricted for the user*/
  
  DECLARE iUsgUId     DI_UID;
  DECLARE sFirUIds    DS_STR255   DEFAULT '';
  DECLARE sFirUId     DS_STR50    DEFAULT '';
  

BEGIN  

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
           fir_Postfach,  fir_Strasse,  fir_Plz,
           fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
           fir_IstAktiv,  cui_IsoCode,   cui_UId,
           fir_CoiUId,    coi_IsoCode
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv ) 
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
           :fir_Postfach,   :fir_Strasse,     :fir_Plz,
           :fir_Ort,        :fir_PlzOrt,
           :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
           :fir_CoiUId,     :coi_IsoCode
  DO
  BEGIN
  
    IF ( sFirUIds <> '' ) THEN
      sFirUIds = sFirUIds || ',';
      
    sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
    
    SUSPEND;
    
  END

  /* +++*/
    
  FOR
  
    SELECT usg_UId
      FROM usg_UserGroup      
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR usg_IstAktiv = :pb_IstAktiv )  
     ORDER BY usg_Name   
      INTO :iUsgUId
    
  DO
  BEGIN
    
    FOR
    
      SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
             fir_Postfach,  fir_Strasse,  fir_Plz,
             fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
             fir_IstAktiv,  fir_CuiIsoCode,   fir_CuiUId,
             fir_CoiUId,    coi_IsoCode
        FROM sp_Fir_SelectByUserGroup( :iUsgUId, :pb_InFirm, :pb_IstAktiv )
        INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
             :fir_Postfach,   :fir_Strasse,     :fir_Plz,
             :fir_Ort,        :fir_PlzOrt,
             :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
             :fir_CoiUId,     :coi_IsoCode
             
    DO
    BEGIN
    
      sFirUId = CAST( fir_UId AS DS_STR50 );
      
      IF ( POSITION( sFirUId IN sFirUIds ) = 0 ) THEN      
        SUSPEND;

      IF ( sFirUIds <> '' ) THEN
        sFirUIds = sFirUIds || ',';
      
      sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
      
    END
    
  END

END!!
COMMIT!!

-- FS#825:END
-- +++

-- +++
-- FS#836:START - PKLohn - Improvement for text on Lohnabrechnung.fr3

EXECUTE PROCEDURE  sp_DDL_SafeAddField 'emp_Employee', 'emp_LA_Text', 'DS_STR1024'!!
COMMIT!!

ALTER TABLE emp_Employee ALTER emp_LA_Text POSITION 47!!
COMMIT!!

EXECUTE PROCEDURE  sp_DDL_SafeAddField 'fir_Firm', 'fir_LA_Text', 'DS_STR1024'!!
COMMIT!!

ALTER TABLE fir_Firm ALTER fir_LA_Text POSITION 16!!
COMMIT!!

EXECUTE PROCEDURE  sp_DDL_SafeAddField 'pra_PayrollAccount', 'pra_LA_Text', 'DS_STR1024'!!
COMMIT!!

ALTER TABLE pra_PayrollAccount ALTER pra_LA_Text POSITION 6!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_SalaryAccount_Emp 
(
  pi_PraUId DI_UID,
  pi_EmyUId DI_UID
)
RETURNS 
(
    SAY_UID DI_UID,
    GRUPPE DS_ONECHARFLAG,
    SDTSORT DI_UID,
    LA_SORT DS_STR30,
    EMY_UID DI_UID,
    SAD_UID DI_UID,
    STD_UID DI_UID,
    SDT_TYP DS_ONECHARFLAG,
    SDT_LART DS_STR5,
    SDT_ISTNULLAUSGABE DB_BOOLEAN,
    SDT_ISTLOHNTEIL DB_BOOLEAN,
    SDT_BERECHBASISNR DI_SMLINT,
    SDT_MASSEINHEIT DS_STR10,
    SCT_CALCTYPE DI_SMLINT,
    SAD_TEXT DS_DESCR,
    SAD_MENGE DN_NUMBER2,
    SAD_ANSATZAG DN_NUMBER4,
    SAD_ANSATZAN DN_NUMBER4,
    SAD_BASIS DN_NUMBER2,
    SAD_FAKTOR DN_NUMBER4,
    SAD_TOTAL DN_NUMBER2,
    EMB_UID DI_UID,
    EMB_VERGTYP DS_ONECHARFLAG,
    EMB_IBANNR DS_STR35,
    EMB_KONTONR DS_STR35,
    EMB_BETRAG DN_NUMBER2,
    BAN_NAME DS_STR50,
    BAN_PLZ DS_PLZ,
    BAN_ORT DS_STR50,
    EMP_VORTRAGFERIEN DN_NUMBER2,
    EMP_SONDERFERIEN DN_NUMBER2,
    EMP_ANSPRUCHFERIEN DN_NUMBER2,
    FERIENBEZUG_VORMONAT DN_NUMBER2,
    FERIENBEZUG_MONAT DN_NUMBER2,
    STD_VORJAHR DN_NUMBER2,
    STD_SOLL_AZMONAT DN_NUMBER2,
    STD_IST_AZMONAT DN_NUMBER2,
    STD_IST_KRANK DN_NUMBER2,
    STD_IST_ABSENZ DN_NUMBER2,
    STD_IST_FERIEN DN_NUMBER2,
    STD_IST_KORRGZ DN_NUMBER2,
    STD_VORTRAG_VORMONAT DN_NUMBER2,
    STD_DIFF_MONAT DN_NUMBER2,
    STD_GZ_MONAT DN_NUMBER2,
    TXT_TEXT DS_STR1024
)
AS

  DECLARE  NAZBETRAG DN_NUMBER2;
  DECLARE  IEMPUID DI_UID;
  DECLARE  IMONAT DI_UID;
  DECLARE  IEHMONAT DI_UID;
  DECLARE  NSOLL_TAGE DN_NUMBER2;
  DECLARE  NSOLL_AZTAG DN_NUMBER2;
  DECLARE  NIST_AZMONAT DN_NUMBER2;
  DECLARE  NIST_FERIENTAGE DN_NUMBER2;
  DECLARE  NIST_ABSENZTAGE DN_NUMBER2;
  DECLARE  NIST_KRANKTAGE DN_NUMBER2;
  DECLARE  SSAY_LA_TEXT DS_STR1024;
  DECLARE  sPra_LA_Text DS_STR1024;
  DECLARE  B_LA_ISTSTUNDEN DB_BOOLEAN;
  DECLARE  B_LA_ISTFERIEN DB_BOOLEAN;
  DECLARE  B_LA_ISTZAHLSTELLE DB_BOOLEAN;
  DECLARE  V_SOLL DN_NUMBER2;
  DECLARE  V_IST DN_NUMBER2;
  DECLARE  SABRETYP DS_ONECHARFLAG;
  DECLARE  BISINDUSTRIEMINUTEN DB_BOOLEAN;
  DECLARE  SFIRLASORTTYP DS_ONECHARFLAG;
  DECLARE  IEMPPERSNR DI_INT;
  DECLARE  SEMPNAME DS_STR50;
  DECLARE  SEMPVORNAME DS_STR50;
  DECLARE  SDEPCODE DS_STR12;
  DECLARE  SCATCODE DS_STR12;
  DECLARE  IEMPVORTRAGVERIEN DI_INT;
  DECLARE  BISINDUSTRIALHOURS DB_BOOLEAN;
  
BEGIN

   -- PayrollAccount-Data from one Employee 

  -- 1. Get Data from Employee and generate Sort field

  SELECT p.emy_EmpUId,       e.emp_La_IstStunden, 
         e.emp_La_IstFerien, e.emp_La_IstZahlstelle,
         e.emp_PersNr,       e.emp_Name, e.emp_Vorname,
         d.dep_Code,         c.cat_Code,
         f.fir_la_sorttyp  

    FROM emy_EmploymentPeriod p

    LEFT JOIN emp_Employee          e ON e.emp_UId = p.emy_EmpUId 
    LEFT JOIN buy_BusinessYear      y ON y.buy_UId = e.emp_BuyUId
    LEFT JOIN fir_firm              f on f.fir_uid = y.buy_firUId
    LEFT OUTER JOIN dep_department  d ON d.dep_UId = e.emp_depUId
    LEFT OUTER JOIN cat_category    c ON c.cat_UId = e.emp_catUId

   WHERE p.emy_UId = :pi_EmyUId

    INTO :iEmpUId, :b_La_IstStunden, 
         :b_La_IstFerien, :b_La_IstZahlStelle,
         :iEmpPersNr, :sEmpName, :sEmpVorname, :sDepCode, 
         :sCatCode,:sFirLASortTyp;


  -- Geneate SortField for salay Report Order
  LA_SORT  = '';

  if (sDepCode is NULL) THEN 
     sDepCode = '';

  if (sCatCode is NULL) THEN 
     sCatCode = '';
   

  if (sFirLASortTyp = '0') THEN BEGIN              

      -- salary sort = emp_PersNr

     LA_SORT = LPAD( CAST( iEmpPersNr AS VARCHAR(14) ), 14, '0' );

  END ELSE if (sFirLASortTyp = '1') THEN BEGIN       

     -- salary sort = emp_Name + epm_Vorname 

     LA_SORT = RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');


  END ELSE if (sFirLASortTyp = '2') THEN BEGIN    

     -- salary sort = Dep_Code + emp_Name + epm_Vorname 

     LA_SORT = RPAD(sDepCode, 12,' ') ||
              RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');


  END ELSE if (sFirLASortTyp = '3') THEN BEGIN       

     -- salary sort = Cat_Code + emp_Name + epm_Vorname 

     LA_SORT = RPAD(sCatCode, 12,' ') || 
               RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');

  END ELSE BEGIN                                       

     -- salary sort = emp_PersNr

     LA_SORT = LPAD( CAST( iEmpPersNr AS VARCHAR(14) ), 14, '0' );

  END


   --  2. Get all exists SalaryDeduction types from SalaryDetail

  emb_UId             = NULL;     ferienbezug_Monat   = NULL;
  emb_VergTyp         = NULL;     std_VorJahr         = NULL;
  emb_IbanNr          = NULL;     std_Soll_AzMonat    = NULL;
  emb_kontoNr         = NULL;     std_Ist_AzMonat     = NULL;
  emb_betrag          = NULL;     std_Ist_Krank       = NULL;  
  ban_Name            = NULL;     std_Ist_Absenz      = NULL;  
  ban_Plz             = NULL;     std_Ist_Ferien      = NULL;
  ban_Ort             = NULL;     std_Ist_Korrgz      = NULL; 
  emp_VortragFerien   = NULL;     std_Vortrag_Vormonat= NULL;
  emp_SonderFerien    = NULL;     txt_Text            = NULL; 
  emp_AnspruchFerien  = NULL;     sSay_La_Text        = NULL;
  ferienbezug_VorMonat= NULL;     sPra_LA_Text        = NULL;


  sdtSort             = 0;
  nAzbetrag           = 0;    

  FOR 
    SELECT  sa.say_UId,
            sa.say_EmyUId, 
            sa.say_La_Text,
            sd.sad_UId,
            sd.sad_SdtUId,
            st.sdt_Typ, 
            st.sdt_IstNullAusgabe, 
            st.sdt_IstLohnTeil,
            st.sdt_BerechBasisNr,
            st.sdt_LArt,
            st.sdt_Masseinheit, 
            st.sdt_StdAbreTyp,
            ct.sct_CalcType, 
            COALESCE( sd.sad_Text, st.sdt_Text, sd.sad_Text ),
            sd.sad_Menge,
            sd.sad_AnsatzAg,
            sd.sad_AnsatzAn,
            sd.sad_Basis,
            sd.sad_Faktor,
            sd.sad_Total, 
            y.buy_IstIndustrieMinuten
      FROM  say_Salary sa
     INNER JOIN sad_SalaryDetail        sd ON sd.sad_SayUId = sa.say_UId
      LEFT JOIN sdt_SalaryDeductionType st ON st.sdt_UId    = sd.sad_SdtUId
      LEFT JOIN buy_BusinessYear        y  ON y .buy_UId    = st.sdt_BuyUId
      LEFT JOIN sct_SalaryCalcType      ct ON ct.sct_UId    = st.sdt_SctUId

     WHERE sa.say_PraUId = :pi_PraUId AND sa.say_EmyUId = :pi_EmyUId 

     ORDER BY st.sdt_IstLohnTeil DESC, st.sdt_Typ DESC, st.sdt_SortNr

      INTO :say_UId,
           :emy_UId,
           :sSay_La_Text,   
           :sad_UId,
           :std_UId,
           :sdt_Typ,
           :sdt_IstNullAusgabe,
           :sdt_IstLohnTeil,
           :sdt_BerechBasisNr,
           :sdt_LArt, 
           :sdt_Masseinheit,
           :sAbretyp, 
           :sct_CalcType,
           :sad_Text,
           :sad_Menge,
           :sad_AnsatzAg,
           :sad_AnsatzAn,
           :sad_Basis,
           :sad_Faktor,   
           :sad_Total,
           :bIsIndustrieMinuten
  DO 
  BEGIN

    gruppe  = 'a';
    sdtSort = sdtSort+1; 

    IF ( sdt_Typ = 'L' ) THEN 
    BEGIN

      nAzbetrag = nAzbetrag + sad_Total;

      -- If there's an hour-based field, then one has to encode that field
      IF  ( sct_CalcType = 5 )  THEN                                           -- WF: 17.04.2015
      BEGIN

        EXECUTE PROCEDURE sp_WorkMinutesToHours( :sad_Menge, :bIsIndustrieMinuten )
         RETURNING_VALUES :sad_Menge;

      END

    END 
    ELSE 
    BEGIN  

      nAzbetrag = nAzbetrag - sad_Total;
      
    END     

    SUSPEND;

  END
  
  
  -- 3. Get payout value(s) for all employee-payout-bank(s)

  IF ( ( b_La_IstZahlStelle = 1 ) AND ( nAzbetrag > 0 ) ) THEN
  BEGIN

    sad_UId             = NULL;        emp_VortragFerien   = NULL;
    std_UId             = NULL;        emp_SonderFerien    = NULL;
    sdt_Typ             = NULL;        emp_AnspruchFerien  = NULL;
    sdt_LArt            = NULL;        ferienbezug_VorMonat= NULL; 
    sdt_IstNullAusgabe  = NULL;        ferienbezug_Monat   = NULL; 
    sdt_IstLohnTeil     = NULL;        std_VorJahr         = NULL;
    sdt_BerechBasisNr   = NULL;        std_Soll_AzMonat    = NULL;
    sct_CalcType        = NULL;        std_Ist_AzMonat     = NULL; 
    sad_Text            = NULL;        std_Ist_Krank       = NULL;
    sad_Menge           = NULL;        std_Ist_Absenz      = NULL;
    sad_AnsatzAg        = NULL;        std_Ist_Ferien      = NULL; 
    sad_AnsatzAn        = NULL;        std_Ist_Korrgz      = NULL; 
    sad_Basis           = NULL;        std_Vortrag_Vormonat= NULL;
    sad_Faktor          = NULL;        txt_Text            = NULL; 
    sad_Total           = NULL; 

   
    sdtSort    = 0;  

    FOR 
      SELECT  pa.emb_UId,
              pa.emb_VergTyp,    
              pa.emb_IbanNr,
              pa.emb_kontoNr,
              pa.az_betrag, 
              b.ban_Name,
              b.ban_Plz,
              b.ban_Ort 
        FROM  sp_Pra_Payout_Splitt ( :iEmpUId, :nAzbetrag, 0.0 ) pa
        LEFT OUTER JOIN ban_Bank b ON b.ban_UId = pa.emb_BanUId
       ORDER BY pa.emb_Sort 
        INTO :emb_UId,
             :emb_VergTyp,
             :emb_IbanNr,
             :emb_kontoNr,
             :emb_betrag,
             :ban_Name,
             :ban_Plz,
             :ban_Ort
    DO 
    BEGIN

       gruppe  = 'b';
       sdtSort = sdtSort + 1;

       SUSPEND;  

    END

  END

   --  Stunden und Ferienrechnung 

  IF ( ( b_La_IstStunden = 1 ) OR ( b_La_IstFerien = 1 ) ) THEN
  BEGIN

    sdt_Typ             = NULL;   sad_Faktor          = NULL;
    sdt_LArt            = NULL;   sad_Total           = NULL; 
    sdt_IstNullAusgabe  = NULL;   emb_UId             = NULL;
    sdt_IstLohnTeil     = NULL;   emb_VergTyp         = NULL;
    sdt_BerechBasisNr   = NULL;   emb_IbanNr          = NULL;
    sdt_Masseinheit     = NULL;   emb_kontoNr         = NULL;
    sct_CalcType        = NULL;   emb_betrag          = NULL;
    sad_Text            = NULL;   ban_Name            = NULL;
    sad_Menge           = NULL;   ban_Plz             = NULL;
    sad_AnsatzAg        = NULL;   ban_Ort             = NULL;
    sad_AnsatzAn        = NULL;   txt_Text            = NULL; 
    sad_Basis           = NULL;

    emp_VortragFerien    = 0;
    emp_SonderFerien     = 0;
    emp_AnspruchFerien   = 0;
    ferienbezug_VorMonat = 0;
    ferienbezug_Monat    = 0;
    std_VorJahr          = 0;
    std_Soll_AzMonat     = 0;
    std_Ist_AzMonat      = 0;
    std_Ist_Krank        = 0;
    std_Ist_Absenz       = 0;
    std_Ist_Ferien       = 0;
    std_Ist_Korrgz       = 0; 
    std_Vortrag_Vormonat = 0;
    std_Diff_Monat       = 0;  
    std_GZ_Monat         = 0;  

    SELECT m.prm_Monat, a.pra_La_Text 
      FROM pra_PayrollAccount a
      LEFT JOIN prm_PayrollMonth m ON m.prm_UId = a.pra_PrmUId
     WHERE a.pra_UId = :pi_PraUId
      INTO :iMonat, :sPra_LA_Text;

     -- Salovortrag vom Vorjahr 

    SELECT FER_VORTRAG_TAGE, FER_SONDER_TAGE,
           FER_ANSPRUCH_TAGE, TOTAL_GZ_SALDO
       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, 12 )
       WHERE EMH_MONAT = 0
    INTO  :emp_VortragFerien,  :emp_SonderFerien,
          :emp_AnspruchFerien, :std_VorJahr;

    -- Werte aus dem Vormonats 
    SELECT TOTAL_GZ_SALDO,
           EMH_IST_FERIENTAGE2
       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, (:iMonat - 1) )
       WHERE EMH_MONAT = 13
    INTO :std_Vortrag_Vormonat,
         :ferienbezug_VorMonat;

    -- Werte Bezuege aus aktuellem Monat 
    SELECT EMH_SOLL_AZMONAT,
           EMH_IST_AZMONAT, 
           EMH_IST_KRANKSTD,  
           EMH_IST_ABSENZSTD,
           EMH_IST_FERIENSTD,
           EMH_IST_KORRGZ,
           TOTAL_DIFF_MONAT,
           TOTAL_GZ_SALDO,
           EMH_IST_FERIENTAGE2

       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, 12 )
       WHERE EMH_MONAT = :iMonat
 
    INTO :std_Soll_AzMonat,
         :std_Ist_AzMonat,
         :std_Ist_Krank,
         :std_Ist_Absenz,
         :std_Ist_Ferien,
         :std_Ist_Korrgz, 
         :std_Diff_Monat,
         :std_GZ_Monat,
         :ferienbezug_Monat;

    gruppe  = 'C';
    sdtSort = 1; 

    SUSPEND;  


  END 
  ELSE 
  BEGIN

    SELECT a.pra_La_Text 
      FROM pra_PayrollAccount a
     WHERE a.pra_UId = :pi_PraUId
      INTO :sPra_LA_Text;

  END


  -- Text und Zusatztexte auf Abrechnung

  sad_UId              = NULL;   emb_kontoNr          = NULL;
  std_UId              = NULL;   emb_betrag           = NULL;
  sdt_Typ              = NULL;   ban_Name             = NULL;
  sdt_LArt             = NULL;   ban_Plz              = NULL;
  sdt_IstNullAusgabe   = NULL;   ban_Ort              = NULL;
  sdt_IstLohnTeil      = NULL;   emp_VortragFerien    = NULL; 
  sdt_BerechBasisNr    = NULL;   emp_SonderFerien     = NULL;
  sdt_Masseinheit      = NULL;   emp_AnspruchFerien   = NULL;
  sct_CalcType         = NULL;   ferienbezug_VorMonat = NULL;
  sad_Text             = NULL;   ferienbezug_Monat    = NULL;
  sad_Menge            = NULL;   std_VorJahr          = NULL;
  sad_AnsatzAg         = NULL;   std_Soll_AzMonat     = NULL;
  sad_AnsatzAn         = NULL;   std_Ist_AzMonat      = NULL;
  sad_Basis            = NULL;   std_Ist_Krank        = NULL;
  sad_Faktor           = NULL;   std_Ist_Absenz       = NULL;
  sad_Total            = NULL;   std_Ist_Ferien       = NULL;
  emb_UId              = NULL;   std_Ist_Korrgz       = NULL;  
  emb_VergTyp          = NULL;   std_Vortrag_Vormonat = NULL;
  emb_IbanNr           = NULL;   txt_Text             = NULL;    

     
  -- Zusatztext aktuelle Abrechnung

  IF ( ( sSay_La_Text IS NOT NULL ) AND ( sSay_La_Text <> '' ) ) THEN 
  BEGIN

    txt_Text  = sSay_La_Text; 
    gruppe    = 'D';
    sdtSort   = 1; 

    SUSPEND;  

  END 


  --  Zusatztext alle Abrechnungen

  IF ( ( sPra_LA_Text IS NOT NULL ) AND ( sPra_LA_Text <> '' ) ) THEN 
  BEGIN

    txt_Text = sPra_LA_Text; 
    gruppe   = 'e';
    sdtSort  = 1; 

    SUSPEND;  
    
  END

END!!
COMMIT!!

-- FS#836:END
-- +++

-- +++
-- FS#841:START - PKLohn - Filter for reports

CREATE OR ALTER PROCEDURE sp_Emp_Select 
(
  pi_BuyUId   DI_UID,
  pi_Month    DI_SMLINT DEFAULT NULL
)
RETURNS 
(
    emp_UId               DI_UID,
    emp_BuyUId            DI_UID,
    emp_PersNr            DI_INT,
    emp_PeidNr            DS_STR20,
    emp_Name              DS_STR50,
    emp_Vorname           DS_STR50,
    emp_Strasse           DS_STR50,
    emp_Hausnr            DS_STR5,
    emp_LandUId           DI_UID,
    emp_Plz               DS_PLZ,
    emp_Steuergde         DS_PLZ,
    emp_Ort               DS_STR50,
    emp_Geburtsdatum      DD_DATE,
    emp_Geburtsday        DI_INT,
    emp_Geburtsmonth      DI_INT,
    emp_Pensiondatum      DD_DATE,
    emp_Geschlecht        DS_ONECHARFLAG,
    emp_Eintrittsdatum    DD_DATE,
    emp_Austrittsdatum    DD_DATE,
    emp_Zivilstand        DS_ONECHARFLAG,
    emp_Aufenthalt        DS_ONECHARFLAG,
    emp_Nationuid         DI_UID,
    emp_Heimatort         DS_STR50,
    emp_Anzkinder         DI_SMLINT,
    emp_Telefon           DS_STR30,
    emp_Handy             DS_STR30,
    emp_Email             DS_STR30,
    emp_Beruf             DS_STR50,
    emp_Stellung          DS_STR50,
    emp_Lohnklasse        DS_STR50,
    emp_Depuid            DI_UID,
    emp_Catuid            DI_UID,
    emp_Prguid            DI_UID,
    emp_Emiuid            DI_UID,
    emp_Ahv_fiiuid        DI_UID,
    emp_Alv_fiiuid        DI_UID,
    emp_Pk_fiiuid         DI_UID,
    emp_Kkp_fiiuid        DI_UID,
    emp_Kkt_fiiuid        DI_UID,
    emp_Unf_fiiuid        DI_UID,
    emp_Ste_fiiuid        DI_UID,
    emp_Zpk_fiiuid        DI_UID,
    emp_Vortragstd        DN_NUMBER2,
    emp_Vortragferien     DN_NUMBER2,
    emp_Sonderferien      DN_NUMBER2,
    emp_Anspruchferien    DN_NUMBER2,
    emp_La_Text           DS_STR1024,
    emp_La_Iststunden     DB_BOOLEAN,
    emp_La_Istferien      DB_BOOLEAN,
    emp_La_Istzahlstelle  DB_BOOLEAN,
    emp_IstAktiv          DB_ISACTIVE,
    emp_Createdate        DD_TIMESTAMP,
    emp_Createusruid      DI_UID,
    emp_Mutdate           DD_TIMESTAMP,
    emp_Mutusruid         DI_UID,
    emp_Createuser        DS_USERLOGIN,
    emp_Mutuser           DS_USERLOGIN,
    emp_Landisocode       DS_CODE,
    emp_Landbezeichnung   DS_DESCR,
    emp_Nationisocode     DS_CODE,
    emp_Nationbezeichnung DS_DESCR,
    emp_Istch             DB_BOOLEAN,
    emp_Ch_peidnr         DS_STR20,
    emp_Prevyearuid       DI_UID,
    dep_Code              DS_STR12,
    dep_Bezeichnung       DS_STR50,
    cat_Code              DS_STR12,
    cat_Bezeichnung       DS_STR50,
    prg_Gruppe            DS_STR12,
    prg_Bezeichnung       DS_STR50,
    ahv_Code              DS_CODE,
    ahv_Name              DS_STR50,
    ahv_Strasse           DS_STR50,
    ahv_Plz               DS_PLZ,
    ahv_Ort               DS_STR50,
    ahv_Intuid            DI_UID,
    ahv_Abrenr            DS_STR20,
    alv_Code              DS_CODE,
    alv_Name              DS_STR50,
    alv_Strasse           DS_STR50,
    alv_Plz               DS_PLZ,
    alv_Ort               DS_STR50,
    alv_IntUId            DI_UID,
    alv_AbreNr            DS_STR20,
    pk_Code               DS_CODE,
    pk_Name               DS_STR50,
    pk_Strasse            DS_STR50,
    pk_Plz                DS_PLZ,
    pk_Ort                DS_STR50,
    pk_IntUId             DI_UID,
    pk_AbreNr             DS_STR20,
    kkp_Code              DS_CODE,
    kkp_Name              DS_STR50,
    kkp_Strasse           DS_STR50,
    kkp_Plz               DS_PLZ,
    kkp_Ort               DS_STR50,
    kkp_Intuid            DI_UID,
    kkp_Abrenr            DS_STR20,
    kkt_Code              DS_CODE,
    kkt_Name              DS_STR50,
    kkt_Strasse           DS_STR50,
    kkt_Plz               DS_PLZ,
    kkt_Ort               DS_STR50,
    kkt_IntUId            DI_UID,
    kkt_AbreNr            DS_STR20,
    unf_Code              DS_CODE,
    unf_Name              DS_STR50,
    unf_Strasse           DS_STR50,
    unf_Plz               DS_PLZ,
    unf_Ort               DS_STR50,
    unf_IntUId            DI_UID,
    unf_AbreNr            DS_STR20,
    ste_Code              DS_CODE,
    ste_Name              DS_STR50,
    ste_Strasse           DS_STR50,
    ste_Plz               DS_PLZ,
    ste_Ort               DS_STR50,
    ste_IntUId            DI_UID,
    ste_AbreNr            DS_STR20,
    zpk_Code              DS_CODE,
    zpk_Name              DS_STR50,
    zpk_Strasse           DS_STR50,
    zpk_Plz               DS_PLZ,
    zpk_Ort               DS_STR50,
    zpk_IntUId            DI_UID,
    zpk_AbreNr            DS_STR20,
    luk_Zivilstand        DS_DESCR
)
AS
  /* Select Employee data by Id or by Employee*/
  
  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;  
  DECLARE iVortragFerien       DI_INT;  
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;
  DECLARE iStartYear           DI_INT;
  DECLARE iEndYear             DI_INT;
  DECLARE bShouldSkipByStartDate   DB_BOOLEAN;
  DECLARE bShouldSkipByEndDate     DB_BOOLEAN;

BEGIN  
  
  SELECT buy_FirUId, buy_GeschJahr, 
         EXTRACT(YEAR FROM buy_DatumVon), 
         EXTRACT(YEAR FROM buy_DatumBis)
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear, :iStartYear, :iEndYear;
    
  SELECT buy_UId 
    FROM buy_BusinessYear
   WHERE buy_FirUId = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */
  
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),           
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_La_Text,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,
           
           (
            SELECT E.emp_UId 
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,
           
           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code 
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId
  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_La_Text,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,
           
           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,
           
           :luk_Zivilstand

  DO
  BEGIN
    
    bShouldSkipByStartDate = 0;
    bShouldSkipByEndDate   = 0;
    
    IF ( :pi_Month IS NOT NULL ) THEN
    BEGIN
      
      IF ( emp_EintrittsDatum IS NOT NULL ) THEN
      BEGIN
        
        bShouldSkipByStartDate = IIF(
          :iStartYear < EXTRACT(YEAR FROM emp_EintrittsDatum) OR
          (
            :iStartYear = EXTRACT(YEAR FROM emp_EintrittsDatum) AND
            :pi_Month < EXTRACT(MONTH FROM emp_EintrittsDatum)
          ),
          1,
          0
        );

      END
      
      IF ( emp_AustrittsDatum IS NOT NULL ) THEN
      BEGIN
        
        bShouldSkipByEndDate = IIF(
          :iEndYear > EXTRACT(YEAR FROM emp_AustrittsDatum) OR
          (
            :iEndYear = EXTRACT(YEAR FROM emp_AustrittsDatum) AND
            :pi_Month > EXTRACT(MONTH FROM emp_AustrittsDatum)
          ),
          1,
          0
        );

      END
      
    END 
    
      
    IF ( bShouldSkipByStartDate = 0 AND bShouldSkipByEndDate = 0 ) THEN
    BEGIN
    
      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragStd;
      
      EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
       RETURNING_VALUES :emp_VortragFerien;
      
      SUSPEND;
    
    END
    
  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_Select 
(
    pi_Fir_UId  DI_UID      DEFAULT NULL,
    ps_Fir_Code DS_CODE     DEFAULT NULL,
    pb_IstAktiv DB_BOOLEAN  DEFAULT NULL
)
RETURNS 
(
    fir_UId                   DI_UID,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Strasse               DS_STR50,
    fir_HausNr                DS_STR5,
    fir_Postfach              DS_STR50,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    fir_Telefon               DS_STR50,
    fir_Fax                   DS_STR50,
    fir_Email						      DS_STR50,
    fir_PeidNr					      DS_STR12,
    fir_Notiz						      DS_TEXT,
    fir_Coiuid					      DI_UID,
    fir_LA_Text		            DS_STR1024,
    fir_LA_Layouttyp		      DS_ONECHARFLAG,
    fir_LA_Kopftyp			      DS_ONECHARFLAG,
    fir_LA_Sorttyp			      DS_ONECHARFLAG,
    fir_LA_Logoname			      DS_STR50,
    fir_LA_Iststunden					DB_BOOLEAN,
    fir_LA_Istferien					DB_BOOLEAN,
    fir_LA_Istzahlstelle			DB_BOOLEAN,
    fir_LA_Reporttemplate			DS_STR2048,
    fir_VA_Layouttyp					DS_ONECHARFLAG,
    fir_VA_Kopftyp						DS_ONECHARFLAG,
    fir_VA_Logoname						DS_STR50,
    fir_Dta_Pfad							DS_STR2048,
    fir_Dta_Spesentyp					DS_ONECHARFLAG,
    fir_Ezag_Pfad							DS_STR2048,
    fir_Ezag_Spesentyp				DS_ONECHARFLAG,
    fir_IstAktiv							DB_ISACTIVE,
    fir_CreateDate						DD_TIMESTAMP,
    fir_CreateUsrUId					DI_UID,
    fir_MutDate							  DD_TIMESTAMP,
    fir_MutUsrUId							DI_UID,
    fir_CuiIsoCode						DS_CODE,
    fir_CuiUId							  DI_UID,
    fir_CreateUser						DS_USERLOGIN,
    fir_MutUser							  DS_USERLOGIN,
    coi_IsoCode							  DS_CODE,
    coi_Bezeichnung						DS_DESCR
)
AS
  /* Select user data (maybe by ID or Login name)*/

BEGIN

  FOR

    SELECT fir_UId,
           fir_Code,
           fir_Bezeichnung,
           fir_Bezeichnung2,
           fir_Strasse,
           fir_HausNr,
           fir_Postfach,
           fir_PLZ,
           fir_Ort,
           fir_Telefon,
           fir_Fax,
           fir_EMail,
           fir_PEIDNR,
           fir_Notiz,
           fir_CoiUId,
           fir_LA_Text,
           fir_LA_LayoutTyp,
           fir_LA_KopfTyp,
           fir_LA_SortTyp,
           fir_LA_LogoName,
           fir_LA_IstStunden,
           fir_LA_IstFerien,
           fir_LA_IstZahlstelle,
           fir_LA_ReportTemplate,
           fir_VA_LayoutTyp,
           fir_VA_KopfTyp,
           fir_VA_LogoName,
           fir_DTA_Pfad,
           fir_DTA_SpesenTyp,
           fir_EZAG_Pfad,
           fir_EZAG_SpesenTyp,
           fir_IstAktiv,
           fir_CreateDate,
           fir_CreateUsrUId,
           fir_MutDate,
           fir_MutUsrUId,
           cui_IsoCode,
           cui_UId,
           USR_C.usr_Login AS fir_CreateUser,
           USR_M.usr_Login AS fir_MutUser,
           coi_IsoCode,
           coi_Bezeichnung
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN usr_User USR_C   ON fir_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User USR_M   ON fir_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO   ON coi_UId          = fir_CoiUId
     WHERE ( :pi_fir_UId  IS NULL OR fir_UId           = :pi_fir_UId           )
       AND ( :ps_fir_Code IS NULL OR UPPER( fir_Code ) = UPPER( :ps_fir_Code ) )
       AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv      = :pb_IstAktiv          )
      INTO :fir_UId,
           :fir_Code,
           :fir_Bezeichnung,
           :fir_Bezeichnung2,
           :fir_Strasse,
           :fir_HausNr,
           :fir_Postfach,
           :fir_PLZ,
           :fir_Ort,
           :fir_Telefon,
           :fir_Fax,
           :fir_EMail,
           :fir_PEIDNR,
           :fir_Notiz,
           :fir_CoiUId,
           :fir_LA_Text,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :fir_LA_SortTyp,
           :fir_LA_LogoName,
           :fir_LA_IstStunden,
           :fir_LA_IstFerien,
           :fir_LA_IstZahlstelle,
           :fir_LA_ReportTemplate,
           :fir_VA_LayoutTyp,
           :fir_VA_KopfTyp,
           :fir_VA_LogoName,
           :fir_DTA_Pfad,
           :fir_DTA_SpesenTyp,
           :fir_EZAG_Pfad,
           :fir_EZAG_SpesenTyp,
           :fir_IstAktiv,
           :fir_CreateDate,
           :fir_CreateUsrUId,
           :fir_MutDate,
           :fir_MutUsrUId,
           :fir_CuiIsoCode,
           :fir_CuiUId,
           :fir_CreateUser,
           :fir_MutUser,
           :coi_IsoCode,
           :coi_Bezeichnung
  DO
    SUSPEND;

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emp_GetDataByPraAndEmy 
(
    pi_EmyUId   DI_UID,
    pi_PraUId   DI_UID
)
RETURNS
(
    emp_UId							DI_UID,
    emp_LA_Text         DS_STR1024,
    emy_UId							DI_UID,
    emp_Geburtsdatum	  DD_DATE,
    emp_Geschlecht			DS_ONECHARFLAG,
    emp_Zivilstand			DS_ONECHARFLAG,
    emy_Pjanfang			  DD_DATE,
    emy_Pjende					DD_DATE,
    emy_Jahreslohn			DN_NUMBER2,
    emy_Istlehrling			DB_BOOLEAN,
    emy_Istwostd8				DB_BOOLEAN,
    emy_Besgrad					DN_NUMBER2,
    emy_Ivgrad					DN_NUMBER2,
    prm_Monat						DI_SMLINT,
    prm_Abrenr					DI_SMLINT
)
AS
  /* Select employee and emp. period data by emy_UId and pra_UId*/
  
BEGIN
  
  SELECT emp_UId,           emp_LA_Text,    emy_UId,           
         emp_GeburtsDatum,  emp_Geschlecht,    
         emp_Zivilstand,    emy_PjAnfang,      
         emy_PjEnde,        emy_JahresLohn,     
         emy_IstLehrling,   emy_IstWoStd8,     
         emy_BesGrad,       emy_IVGrad
    FROM emy_EmploymentPeriod
    JOIN emp_Employee ON emp_UId = emy_EmpUId
   WHERE emy_UId = :pi_EmyUId
    INTO :emp_UId,           :emp_LA_Text, :emy_UId,           
         :emp_GeburtsDatum,  :emp_Geschlecht,    
         :emp_Zivilstand,    :emy_PjAnfang,      
         :emy_PjEnde,        :emy_JahresLohn,     
         :emy_IstLehrling,   :emy_IstWoStd8,     
         :emy_BesGrad,       :emy_IVGrad;
  
  SELECT prm_Monat, prm_AbreNr
    FROM pra_PayrollAccount
    JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :prm_Monat, :prm_AbreNr;
    
  SUSPEND;
    
  
END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_CheckNextAccount 
(
    pi_BuyUId   DI_UID,
    pi_UsrUId   DI_UID
)
RETURNS 
(
    pi_PraUId   DI_UID
)
AS
  /* This procedure determines the UID of the next billing to be processed.*/
  /**/
  /* If the next account is not yet created, it will be automatically generated and the pra_UId of */
  /* the new account will be returned.                                             */
  /*                                                               */
  /* If all invoices are fixed(verbucht) and no further invoices more exist, the pra_UId of the last */
  /* account is returned (if grouping is active, all groups will be inserted)         */

  DECLARE VARIABLE iPrmFirst       DI_UID;
  DECLARE VARIABLE iPraUId         DI_UID;
  DECLARE VARIABLE iPrmUId         DI_UID;
  DECLARE VARIABLE iPrgUId         DI_UID;
  DECLARE VARIABLE bPraIstVerbucht DB_BOOLEAN;
  DECLARE VARIABLE iPrmMonat       DI_SMLINT;
  DECLARE VARIABLE iAnzAHL         DI_INT;
  DECLARE VARIABLE iLcMonat        DI_SMLINT;
  DECLARE VARIABLE iLcPraUId       DI_UID;
  DECLARE VARIABLE iLcPrmUId       DI_UID;
  DECLARE VARIABLE iLcPrgUId       DI_INT;
  DECLARE VARIABLE iNewPraUId      DI_INT;
  DECLARE VARIABLE bIstOK          DB_BOOLEAN;
  DECLARE VARIABLE bIstFound       DB_BOOLEAN;
  DECLARE VARIABLE dPrmAzDatum     DD_DATE;
  
BEGIN

  /* Letzte Verbuchte Abrechnung suchen und alle nicht verbuchten und leeren Abrechnungen entfernen */
  iLcMonat  = 0;
  iPrmFirst = 0;
  iLcPrmUId = 0;
   
  FOR 
    SELECT prm_Monat,  pra_UId,         pra_PrmUId, 
           pra_PrgUId, pra_IstVerbucht, pra_AnzMitInabre 
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
     WHERE prm_BuyUId = :pi_BuyUId 
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr
      INTO :iPrmMonat, :iPraUId,         :iPrmUId,
           :iPrgUId,   :bPraIstVerbucht, :iAnzAHL
  DO 
  BEGIN

    /*- Hold first prm_UId in the Year   */
    IF ( iPrmFirst = 0 ) THEN 
      iPrmFirst = iPrmUId;


    IF ( bPraIstVerbucht = 1 ) THEN 
    BEGIN

      /*- Hold last Closed PayrollAccont in then Year*/

      iLcPraUId = iPraUId;
      iLcPrmUId = iPrmUId;
      iLcPrgUId = iPrgUId;
      iLcMonat  = iPrmMonat;

    END

  END


   /* Alle Abrechnungen zuletzt verbuchten Monats bzw. Folgemonats anlegen, */
   /* falls Abrechnungen noch nicht anlegeleg*/

   /* Keine verbuchte Abrechnung im Jahr gefunden*/
   
  IF ( iLcMonat = 0 ) THEN 
  BEGIN       
    iLcMonat  = 1;
    iLcPrmUId = 0;
  END

   
  bIstFound = 0;
  
  /* Wenn noch gar keine Abrechnung angelegt ist*/
  
  IF ( iPrmFirst = 0 ) THEN 
  BEGIN        
    bIstFound = 1;
    iLcPrmUId = 0;
  END

  bIstOK    = 0;
  
  FOR 
    SELECT prm_UId,   prg_UId, prm_AzDatum, 
           prm_Monat, pra_UId, pra_IstVerbucht 
      FROM sp_Pra_AccountList ( :pi_BuyUId )
     WHERE prm_Monat >= :iLcMonat 
       AND prm_Monat <= ( :iLcMonat + 1 )
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe      
      INTO :iPrmUId,   :iPrgUId, :dPrmAzDatum,
           :iPrmMonat, :iPraUId, :bPraIstVerbucht
  DO 
  BEGIN

    IF ( ( bIstFound = 0 ) AND ( iPrmUId = iLcPrmUId ) ) THEN
      bIstFound = 1;


    IF (bIstFound = 1) THEN 
    BEGIN

      IF ( ( iPrmUId <> iLcPrmUId ) AND (bIstOK = 0) ) THEN 
        iLcPrmUId = iPrmUId; 


      IF ( iLcPrmUId = iPrmUId ) THEN 
      BEGIN 


        IF ((iPraUId IS NULL) OR (iPraUId = 0)) THEN 
        BEGIN   
        
          /* Abrechnung noch nicht angelegt*/
          
          EXECUTE PROCEDURE sp_Pra_Insert
                              :iPrmUId,         /* PrmUId*/
                              :iPrgUId,         /* PrgUId*/
                              :dPrmAzDatum,     /* AZDatum*/
                              0,                /* IstVerbucht*/
                              1,                /* IstAktiv*/
                              :pi_UsrUId        /* CreateUser*/
            RETURNING_VALUES :iNewPraUId;
            
          -- Set pra_LA_Text = fir_LA_Text
          UPDATE pra_PayrollAccount 
             SET pra_LA_Text = (
                SELECT fir_LA_Text 
                  FROM buy_BusinessYear
                  JOIN fir_Firm ON fir_UId = buy_FirUId
                 WHERE buy_UId = :pi_BuyUId
             )
            WHERE pra_UId = :iNewPraUId;
 
            bIstOK = 1;

        END 
        ELSE 
        BEGIN
   
          IF ( bPraIstVerbucht = 0 ) THEN
            bIstOK = 1;
        
        END
        
      END

    END

  END


  /* Erste unverbuchte Abrechnung aus PRA_PayrollAccont suchen, sonst letzte verbuchte Abrecnnung */

  pi_PraUId  = 0;
  
  FOR 
    SELECT pra_UId, pra_IstVerbucht 
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
      LEFT JOIN prg_PayrollGroup   ON prg_UId    = pra_PrgUId  
     WHERE prm_BuyUId = :pi_BuyUId
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe
      INTO :iPraUId, :bPraIstVerbucht
  DO 
  BEGIN

    pi_PraUId = iPraUId;
    
    IF (bPraIstVerbucht = 0) THEN 
      EXIT;
      
  END

END!!
COMMIT!!

-- +++

-- Update all pra_LA_Text values
UPDATE pra_PayrollAccount 
   SET pra_LA_Text = ( 
      SELECT prm_LA_Text
        FROM prm_PayrollMonth
       WHERE prm_UId = pra_PrmUId
   )!!
COMMIT!!   
   

-- FS#841:END
-- ++

SET TERM ;!!
