﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.11
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#729:START - PKLohn - SQL Error because of SDT entry

CREATE OR ALTER PROCEDURE sp_Say_GetAgrDataByEmy 
(
    pi_EmyUId DI_UID,
    pi_SdtUId DI_UID,
    pi_Month  DI_INT
)
RETURNS 
(
    dMinStartDate       DD_DATE,
    dMaxStartDate       DD_DATE,
    dMaxEndDate         DD_DATE,
    nGrossWage          DN_NUMBER2,
    nGrossWageCurMonth  DN_NUMBER2
)
AS
  /* Get aggregate salary data ( gross wage and salary period )*/
  
  DECLARE iBerechBasisNr    DI_SMLINT;
  DECLARE sBerechBasisNr    DS_STR50;

BEGIN
  
  SELECT MIN( say_DatumVom   ),
         MAX( say_DatumVom   ),
         MAX( say_DatumBis   )
    FROM say_Salary
    LEFT JOIN pra_PayrollAccount ON pra_UId = say_PraUId
    LEFT JOIN prm_PayrollMonth   ON prm_UId = pra_PrmUId
   WHERE say_EmyUId = :pi_EmyUId 
     AND (
            ( :pi_Month = 0 AND prm_Monat <= 0  )
            OR
            ( prm_Monat BETWEEN 1 AND :pi_Month )
         )
    INTO :dMinStartDate,
         :dMaxStartDate,
         :dMaxEndDate;         
         
   /* Get BasisNo from SalaryDeducation_Typ  */
   SELECT sdt_BerechBasisNr 
     FROM sdt_SalaryDeductionType 
    WHERE sdt_UId= :pi_SdtUId 
     INTO :iBerechBasisNr;
     
  IF ( iBerechBasisNr > 0 ) THEN
  BEGIN
    
    sBerechBasisNr = ' AND sdt_Basis' || :iBerechBasisNr || ' = 1 ';
    
  END
  ELSE
  BEGIN
    
    sBerechBasisNr = '';
    
  END

         
  EXECUTE STATEMENT  
      'SELECT SUM( sad_Total )
         FROM say_Salary                       
         LEFT JOIN pra_PayrollAccount       ON pra_UId    = say_praUId 
         LEFT JOIN prm_PayrollMonth         ON prm_UId    = pra_prmUId 
        INNER JOIN sad_SalaryDetail        ON sad_sayUID = say_UId    
         LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_sdtUId 
        WHERE say_emyUId       = ' || :pi_EmyUId       ||
       '  AND sdt_Typ          = ''L'''                || :sBerechBasisNr ||       
       '  AND (
                ( '||:pi_Month ||' = 0 AND prm_Monat <= 0   )
                OR
                ( prm_Monat BETWEEN 1 AND '|| :pi_Month || ')
             ) '
    INTO :nGrossWage;


    EXECUTE STATEMENT  
      'SELECT SUM( sad_Total )
         FROM say_Salary                       
         LEFT JOIN pra_PayrollAccount       ON pra_UId    = say_praUId 
         LEFT JOIN prm_PayrollMonth         ON prm_UId    = pra_prmUId 
        INNER JOIN sad_SalaryDetail        ON sad_sayUID = say_UId    
         LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_sdtUId 
        WHERE say_emyUId       = ' || :pi_EmyUId       ||
       '  AND sdt_Typ          = ''L'''                || :sBerechBasisNr ||       
       '  AND '||:pi_Month ||' > 0 AND prm_Monat = '|| :pi_Month
    INTO :nGrossWageCurMonth;
    
  IF ( nGrossWageCurMonth IS NULL ) THEN
    nGrossWageCurMonth = 0;    
  
  SUSPEND;
  
END!!
COMMIT!!

-- FS#729:END
-- +++

-- +++
-- FS#794:START - PKLohn - New Selection functionality (Arbeitsliste)

EXECUTE BLOCK AS

  DECLARE bExists DB_BOOLEAN;

BEGIN
  
  EXECUTE PROCEDURE sp_DDL_ExistsTable 'grd_GridSelection'
   RETURNING_VALUES : bExists;
   
  IF ( bExists = 1 ) THEN EXIT;
  
  EXECUTE STATEMENT
    'CREATE TABLE grd_GridSelection 
     (
       grd_UId           DI_UID_NN,
       grd_FormName      DS_STR50_NN,
       grd_GridName      DS_STR50_NN,
       grd_UniqueColumn  DS_STR50_NN,
       grd_CheckCaption  DS_STR50_NN,
       grd_IstAktiv      DB_ISACTIVE_NN,
       grd_CreateDate    DD_DATE_NN,
       grd_CreateUsrUId  DI_UID_NN,
       grd_MutDate       DD_DATE_NN,
       grd_MutUsrUId     DI_UID
     )';  
  
END!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreatePrimaryKey 'grd_GridSelection', 'grd_UId', 'PK_Grd', 'IDX_Grd_PK'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateUnique 'grd_GridSelection', 'UNQ_FormGrid', 'grd_FormName, grd_GridName'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateForeignKey 
  'grd_GridSelection', 'grd_CreateUsrUId', 'usr_User', 'usr_UId', 
  'FK_GrdCreateUsr2Usr', 'IDX_GrdByCreateUsr'!!
COMMIT!!  

EXECUTE PROCEDURE sp_DDL_CreateForeignKey 
  'grd_GridSelection', 'grd_MutUsrUId', 'usr_User', 'usr_UId', 
  'FK_GrdMutUsr2Usr', 'IDX_GrdByMutUsr'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateIndex 'grd_GridSelection', 'IDX_GrdByGridName', 'grd_FormName, grd_GridName'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateGenerator 'GEN_Grd_UId'!!
COMMIT!!

-- +++

CREATE OR ALTER TRIGGER TRG_Grd_BeforeIns_0 FOR grd_GridSelection
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  
  IF ( ( new.grd_UId IS NULL ) OR ( new.grd_UId = 0 ) ) THEN
  BEGIN
     new.grd_UId = GEN_ID (GEN_Grd_UId, 1);
  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER TRIGGER TRG_Grd_AfterInsUpd_99 FOR grd_GridSelection
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 99
AS

  -- Update modification date for cat_Category

BEGIN

  EXECUTE PROCEDURE sp_Ztb_InsertOrUpdate( 'grd' );

END!!
COMMIT!!

-- +++
-- +++

EXECUTE BLOCK AS

  DECLARE bExists DB_BOOLEAN;

BEGIN
  
  EXECUTE PROCEDURE sp_DDL_ExistsTable 'sel_Selection'
   RETURNING_VALUES : bExists;
   
  IF ( bExists = 1 ) THEN EXIT;
  
  EXECUTE STATEMENT
    'CREATE TABLE sel_Selection 
     (
       sel_UId           DI_UID_NN,
       sel_GrdUId        DI_UID,       
       sel_RecUId        DI_UID,
       sel_SecondUId     DI_UID,
       sel_IstAktiv      DB_ISACTIVE_NN,
       sel_CreateDate    DD_DATE_NN,
       sel_CreateUsrUId  DI_UID_NN,
       sel_MutDate       DD_DATE_NN,
       sel_MutUsrUId     DI_UID
     )';  
  
END!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreatePrimaryKey 'sel_Selection', 'sel_UId', 'PK_Sel', 'IDX_Sel_PK'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateUnique 'sel_Selection', 'UNQ_SelGridRec', 'sel_GrdUId, sel_RecUId, sel_SecondUId'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateForeignKey 
  'sel_Selection', 'sel_GrdUId', 'grd_GridSelection', 'grd_UId', 
  'FK_SelGrd2Grd', 'IDX_SelByGrd'!!
COMMIT!!  

EXECUTE PROCEDURE sp_DDL_CreateForeignKey 
  'sel_Selection', 'sel_CreateUsrUId', 'usr_User', 'usr_UId', 
  'FK_SelCreateUsr2Usr', 'IDX_SelByCreateUsr'!!
COMMIT!!  

EXECUTE PROCEDURE sp_DDL_CreateForeignKey 
  'sel_Selection', 'sel_MutUsrUId', 'usr_User', 'usr_UId', 
  'FK_SelMutUsr2Usr', 'IDX_SelByMutUsr'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateIndex 'sel_Selection', 'IDX_SelByGridRec', 'sel_GrdUId, sel_RecUId, sel_SecondUId'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_CreateGenerator 'GEN_Sel_UId'!!
COMMIT!!

-- +++

CREATE OR ALTER TRIGGER TRG_Sel_BeforeIns_0 FOR sel_Selection
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  
  IF ( ( new.sel_UId IS NULL ) OR ( new.sel_UId = 0 ) ) THEN
  BEGIN
     new.sel_UId = GEN_ID (GEN_Sel_UId, 1);
  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER TRIGGER TRG_Sel_AfterInsUpd_99 FOR sel_Selection
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 99
AS

  -- Update modification date for cat_Category

BEGIN

  EXECUTE PROCEDURE sp_Ztb_InsertOrUpdate( 'sel' );

END!!
COMMIT!!

COMMENT ON TABLE sel_Selection IS 'Selection grid records'!!
COMMENT ON COLUMN sel_Selection.sel_UId          IS 'Unique record Id'!!
COMMENT ON COLUMN sel_Selection.sel_GrdUId       IS 'Reference to grd_GridSelection record'!!
COMMENT ON COLUMN sel_Selection.sel_RecUId       IS 'Selection grid record UId'!!
COMMENT ON COLUMN sel_Selection.sel_SecondUId    IS 'Selection grid secondary UId'!!
COMMENT ON COLUMN sel_Selection.sel_IstAktiv     IS 'Active/Disabled flag'!!
COMMENT ON COLUMN sel_Selection.sel_CreateDate   IS 'Record creation date'!!
COMMENT ON COLUMN sel_Selection.sel_CreateUsrUId IS 'User whom created the record'!!
COMMENT ON COLUMN sel_Selection.sel_MutDate      IS 'Record last modifcation date'!!
COMMENT ON COLUMN sel_Selection.sel_MutUsrUId    IS 'User whom last time modified the record'!!

-- +++

EXECUTE BLOCK
AS

  -- Insert ClosePraFRM employee table grid

BEGIN
  
  IF ( NOT EXISTS
           ( 
            SELECT grd_UId 
              FROM grd_GridSelection 
             WHERE grd_FormName = 'TfrmClosePra' 
               AND grd_GridName = 'grdEmployeeList'
           )
  )
  THEN
  BEGIN
    
    INSERT INTO grd_GridSelection
    ( 
      grd_FormName  , grd_GridName    , grd_UniqueColumn, grd_CheckCaption, grd_IstAktiv,
      grd_CreateDate, grd_CreateUsrUId, grd_MutDate     , grd_MutUsrUId 
    )
    VALUES
    ( 
      'frmClosePra', 'grdEmployeeList', 'colEmpUId', 'Arbeitsliste', 1, 
      Current_Timestamp, 1, Current_Timestamp, 1
    );
    
  END
  
  IF ( NOT EXISTS
           ( 
              SELECT par_UId 
                FROM par_Parameter 
               WHERE par_Code = 'SHOW_GRID_SELECTION'
           ) 
     ) 
  THEN
  BEGIN
    
    INSERT INTO par_Parameter (
      par_MastUId, par_MastPrefix, par_Code, par_Bezeich, par_Typ, par_Val,
      par_CreateDate, par_CreateUsrUId, par_MutDate, par_MutUsrUId
    )
    VALUES (
      0, 'APP', 'SHOW_GRID_SELECTION', 'Show grid selection column', 1, '0',
      Current_Timestamp, 1, Current_Timestamp, 1
    );
    
  END
  
END!!
COMMIT!!

-- FS#794:END
-- +++

-- +++
-- FS#801:START - PKLohn - Additional parameter for reports

EXECUTE BLOCK
AS
BEGIN

  IF ( NOT EXISTS
           ( 
              SELECT par_UId 
                FROM par_Parameter 
               WHERE par_Code = 'HIDE_REPORT_OVERLAY'
           ) 
     ) 
  THEN
  BEGIN
    
    INSERT INTO par_Parameter (
      par_MastUId, par_MastPrefix, par_Code, par_Bezeich, par_Typ, par_Val,
      par_CreateDate, par_CreateUsrUId, par_MutDate, par_MutUsrUId
    )
    VALUES (
      0, 'APP', 'HIDE_REPORT_OVERLAY', 'Hide report overlay', 1, '0',
      Current_Timestamp, 1, Current_Timestamp, 1
    );
    
  END

END!!
COMMIT!!  
  
-- FS#801:END
-- +++

-- +++
-- FS#795:START - PKLohn - Improvement for ClosePraFRM

EXECUTE PROCEDURE sp_DDL_SafeAddField 'pra_PayrollAccount', 'pra_VbDatum', 'DD_DATE'!!
COMMIT!!

ALTER TABLE pra_PayrollAccount ALTER pra_VbDatum POSITION 5!!
COMMIT!!

-- FS#795:END
-- +++

-- +++
-- FS#795:START - PKLohn - Improvement for ClosePraFRM

CREATE OR ALTER PROCEDURE sp_Pra_EmployeeList 
(
    PI_PRAUID DI_UID
)
RETURNS 
(
    emp_UId                 DI_UID,
    emp_PersNr              DI_INT,
    emp_PeidNr              DS_STR20,
    emp_Name                DS_STR50,
    emp_Vorname             DS_STR50,
    emp_Strasse             DS_STR50,
    emp_LandUId             DI_UID,
    emp_DepCode             DS_DESCR,
    emp_CatCode             DS_DESCR,
    emp_Aufenthalt          DS_DESCR,
    coi_IsoCode             DS_CODE,
    coi_Bezeichnung         DS_DESCR,
    emp_Plz                 DS_PLZ,
    emp_Ort                 DS_STR50,
    emp_GeburtsDatum        DD_DATE,
    emp_PensionDatum        DD_DATE,
    emp_EintrittsDatum      DD_DATE,
    emp_AustrittsDatum      DD_DATE,
    emp_Geschlecht          DS_ONECHARFLAG,
    emp_GeschlechtBezei     DS_DESCR,
    emp_PrgUId              DI_UID,
    emp_Stellung            DS_STR50,
    emy_Besgrad             DN_NUMBER2,
    emy_Ivgrad              DN_NUMBER2,
    say_UId                 DI_UID,
    say_EmyUId              DI_UID,
    say_DatumVom            DD_DATE,
    say_DatumBis            DD_DATE,
    say_Anzdetails          DI_INT,
    say_BruttoLohn          DN_NUMBER2,
    say_NettoLohn           DN_NUMBER2,
    say_La_Text             DS_STR1024,
    say_JahresLohn          DN_NUMBER2,
    say_Status              DI_SMLINT,
    prm_Bezeichnung         DS_DESCR,
    buy_GeschJahr           DI_BUSINESSYEAR
)
AS
  /* The procedure creates the employee list in the form SalaryManageFRM for the ID <pi_PraUId>.  */
  /*                                                               */
  /* The procedure creates the list of employees in the form SalaryManageFRM. */
  /* Following is considered:*/
  /*   a) already existing accounts per employee                  */
  /*   b) Firm/BusninessYear settings "Lohnabrechnung gruppiert ..." */
  /*   c) Filter settings for special accounts in "Abrechnungsvorlagen" */
                                       
  DECLARE iBuyUId         DI_UID;
  DECLARE iPrmUId         DI_UID;
  DECLARE iPrmMonat       DI_SMLINT;
  DECLARE iPrmAbreNr      DI_SMLINT;
  DECLARE iPrmCoiUId      DI_UID;
  DECLARE iPrmDepUId      DI_UID;
  DECLARE iPrmCatUId      DI_UID;
  DECLARE iPrmPrgUId      DI_UID;
  DECLARE bPrmIstUnd      DB_BOOLEAN;
  DECLARE iPraPrgUId      DI_UID;
  DECLARE bPrgInMoAre     DB_BOOLEAN;
  DECLARE bPrgIstStandard DB_BOOLEAN;
  DECLARE dEmyPjAnfang    DD_DATE;
  DECLARE dEmyPjEnde      DD_DATE;
  DECLARE iEmpLandUId     DI_UID;
  DECLARE iEmpDepUId      DI_UID;
  DECLARE iEmpCatUId      DI_UID;
  DECLARE iEmpPrgUId      DI_UID;
  DECLARE bIstOK          DB_BOOLEAN;
  DECLARE bCoiIstOK       DB_BOOLEAN;
  DECLARE bDepIstOK       DB_BOOLEAN;
  DECLARE bCatIstOK       DB_BOOLEAN;
  DECLARE bPrgIstOK       DB_BOOLEAN;
  DECLARE bPrmIsGroupped  DB_BOOLEAN;
  DECLARE bSuspendRec     DB_BOOLEAN;
  DECLARE iEmptyStatus    DI_SMLINT;
  
BEGIN

  /* Abrechnungs-Infos */
  
  SELECT pra_PrgUId,      prm_BuyUId,     prm_UId,    prm_Monat,  prm_AbreNr,        prm_CoiUId, 
         prm_DepUId,      prm_CatUId,     prm_PrgUId, prm_IstUnd, prg_IstInMoAbrech, prg_IstStandard,
         prm_Bezeichnung, buy_GeschJahr,  prm_IstSoGruppiert
    FROM pra_PayrollAccount
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
    LEFT JOIN prg_PayrollGroup ON prg_UId = pra_PrgUId
    LEFT JOIN buy_BusinessYear ON buy_UId = prm_BuyUId
   WHERE pra_UId = :pi_PraUId 
    INTO :iPraPrgUId,      :iBuyUId,       :iPrmUId,    :iPrmMonat,  :iPrmAbreNr,  :iPrmCoiUId,
         :iPrmDepUId,      :iPrmCatUId,    :iPrmPrgUId, :bPrmIstUnd, :bPrgInMoAre, :bPrgIstStandard,
         :prm_Bezeichnung, :buy_GeschJahr, :bPrmIsGroupped;
         
         
  
  iEmptyStatus = -1;

  /* 1. Alle Mitarbeiter die bereits in der Abrechnung Lohndaten haben */

  FOR 
    SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,           
           emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
           emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
           emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   say_UId,         
           say_EmyUId,         say_DatumVom,       say_DatumBis,     say_AnzDetails,
           say_BruttoLohn,     say_NettoLohn,      say_LA_Text,      emy_BesGrad,
           emy_IVGrad,         emp_PrgUId,         coi_IsoCode,      emp_Stellung,
           dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung,
           (
              SELECT IIF( COUNT(1) > 0, 1, 0 )
                FROM sad_SalaryDetail
                JOIN sdt_SalaryDeductionType ON sdt_UId = sad_SdtUId
               WHERE sad_SayUId = say_UId
                 AND sdt_IstVariabel = 1
           )
      FROM pra_PayrollAccount
     INNER JOIN say_Salary           ON say_PraUId = pra_UId
      LEFT JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
      LEFT JOIN emp_Employee         ON emp_UID    = emy_EmpUId
      LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId 
      LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
      LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
      LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
     WHERE pra_UId = :pi_PraUId
     ORDER BY emp_UId, emy_UId
      INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,           
           :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
           :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
           :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_UId,         
           :say_EmyUId,         :say_DatumVom,       :say_DatumBis,     :say_AnzDetails,
           :say_BruttoLohn,     :say_NettoLohn,      :say_LA_Text,      :emy_BesGrad,
           :emy_IVGrad,         :emp_PrgUId,         :coi_IsoCode,      :emp_Stellung,
           :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt,
           :say_Status
  DO 
  BEGIN
  
     EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
       RETURNING_VALUES say_JahresLohn; 
       
     EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
       RETURNING_VALUES emp_GeschlechtBezei; 
       
     SUSPEND;
  END 


  IF ( iPrmAbreNr = 0 ) THEN 
  BEGIN

    /* Wenn Monatsabrechnung*/

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/

      /* Alle MA's, welche eine BesPeriode im aktuellen Monat haben und dieser Abrechnung noch */
      /* keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,         emp_PersNr,         emp_PeidNr,         emp_Name, 
               emp_Vorname,     emp_Strasse,        emp_LandUId,        coi_Bezeichnung,    
               emp_PLZ,         emp_ORT,            emp_GeburtsDatum,   emp_PensionDatum, 
               emp_Geschlecht,  emp_EintrittsDatum, emp_AustrittsDatum, emy_UId,  
               emy_PjAnfang,    emy_PjEnde,         emy_BesGrad,        emy_IVGrad,
               emp_PrgUId,      coi_IsoCode,        emp_Stellung,       :iEmptyStatus,
               dep_Bezeichnung, cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,        :emp_PersNr,         :emp_PeidNr,         :emp_Name,    
               :emp_Vorname,    :emp_Strasse,        :emp_LandUId,        :coi_Bezeichnung,    
               :emp_PLZ,        :emp_ORT,            :emp_GeburtsDatum,   :emp_PensionDatum, 
               :emp_Geschlecht, :emp_EintrittsDatum, :emp_AustrittsDatum, :say_EmyUId,  
               :dEmyPjAnfang,   :dEmyPjEnde,         :emy_BesGrad,        :emy_IVGrad,
               :emp_PrgUId,     :coi_IsoCode,        :emp_Stellung,       :say_Status,
               :emp_DepCode,    :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis */
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;
        
        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 

        SUSPEND;

      END 


    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       

      /* Alle MA's der Gruppe, welche eine BesPeriode im aktuellen Monat haben und in allen */
      /* Abrechnungen von diesem Monat noch keine Lohndaten vorhanden sind*/

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emy_UId,         
               emy_PjAnfang,       emy_PjEnde,         emy_BesGrad,      emy_IVGrad,
               emp_PrgUId,         coi_IsoCode,        emp_Stellung,    :iEmptyStatus,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
          LEFT JOIN prg_PayrollGroup     ON prg_UId    = emp_PrgUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId         = :iBuyUId
           AND emp_PrgUId         = :iPraPrgUId
           AND prg_IstInMoAbrech  = 1
           AND emy_IsUnemployed   = 0 
           AND :iPrmMonat         >= EXTRACT(MONTH FROM emy_PjAnfang )
           AND :iPrmMonat         <= EXTRACT(MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :say_EmyUId,      
               :dEmyPjAnfang,       :dEmyPjEnde,         :emy_BesGrad,      :emy_IVGrad,
               :emp_PrgUId,         :coi_IsoCode,        :emp_Stellung,     :say_Status,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        /* Datum Von */
        EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
          RETURNING_VALUES :say_DatumVom; 

        IF ( dEmyPjAnfang > say_DatumVom ) THEN 
          say_DatumVom = dEmyPjAnfang; 
   
        /* Datum Bis*/
        EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
          RETURNING_VALUES :say_DatumBis; 

        IF ( dEmyPjEnde < say_DatumBis ) THEN 
          say_DatumBis = dEmyPjEnde; 

        say_UId        = NULL;
        say_AnzDetails = 0;
        say_BruttoLohn = 0;
        say_NettoLohn  = 0;
        say_LA_Text    = NULL;

        EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
          RETURNING_VALUES say_JahresLohn;
          
        EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
          RETURNING_VALUES emp_GeschlechtBezei; 
          
        SUSPEND;

      END

    END

  END 
  ELSE 
  BEGIN

     /*** Wenn Sonderabrechnung ***/
     
    IF ( 
          ( 
            iPrmCoiUId IS NOT NULL
            OR
            iPrmDepUId IS NOT NULL
            OR 
            iPrmCatUId IS NOT NULL
            OR
            iPrmPrgUId IS NOT NULL
          )
          AND
          ( bPrmIsGroupped = 0 )
          AND 
          ( bPrmIstUnd     = 1 )
       )
    THEN
      bSuspendRec = 1;
    ELSE
      bSuspendRec = bPrmIsGroupped;
    

    IF ( bPrgIstStandard = 1 ) THEN 
    BEGIN

      /*** Wenn NICHT gruppiert ***/       

      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name, 
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId = :iBuyUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM say_Salary 
                  WHERE say_EmyUId = emy_UId 
                    AND say_PraUId = :pi_PraUId )
         ORDER BY emp_UId, emy_UId                    
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name, 
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
        bPrgIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND ( emp_LandUId <> iPrmCoiUId ) ) THEN 
          bCoiIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1;

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId )
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;          

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId ) 
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;
                  
        /* PersonenGruppe als Filter definiert */
        IF ( ( iPrmPrgUId IS NOT NULL ) AND ( emp_PrgUId <> iPrmPrgUId ) )
        THEN
          bPrgIstOK = 0; 
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmPrgUId IS NOT NULL ) ) THEN
          bPrgIstOK = 1;
                  

        /* UND- / ODER- Verknuepfung */
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN /* UND-Verknuepfung  */
          
          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) = 4 ) THEN
            bIstOK = 1;
            
        END 
        ELSE 
        BEGIN /* OR-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK + bPrgIstOK ) > 0 ) THEN
            bIstOK = 1;

        END


        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von */
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
          
          SUSPEND;

        END

      END        

    END 
    ELSE 
    BEGIN

      /*** Wenn gruppiert ***/       
        
      FOR 
        SELECT emp_UID,            emp_PersNr,         emp_PeidNr,       emp_Name,   
               emp_Vorname,        emp_Strasse,        emp_LandUId,      coi_Bezeichnung, 
               emp_PLZ,            emp_ORT,            emp_GeburtsDatum, emp_PensionDatum, 
               emp_EintrittsDatum, emp_AustrittsDatum, emp_Geschlecht,   emp_DepUId,         
               emp_CatUId,         emy_UId,            emy_PjAnfang,     emy_PjEnde,         
               emy_BesGrad,        emy_IVGrad,         emp_PrgUId,       coi_IsoCode,
               emp_Stellung,       :iEmptyStatus,
               dep_Bezeichnung,    cat_Bezeichnung,    luk_Bezeichnung
          FROM emp_Employee 
          LEFT JOIN coi_CountryISO       ON coi_UId    = emp_LandUId
         INNER JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UID
          LEFT JOIN cat_Category         ON cat_UId    = emp_CatUId
          LEFT JOIN dep_Department       ON dep_UId    = emp_DepUId
          LEFT JOIN luk_Lookup           ON luk_Gruppe = 'AUFENTHALT' AND luk_Code = emp_Aufenthalt
         WHERE emp_BuyUId       = :iBuyUId
           AND emp_PrgUId       = :iPraPrgUId
           AND emy_IsUnemployed = 0
           AND :iPrmMonat       >= EXTRACT( MONTH FROM emy_PjAnfang )
           AND :iPrmMonat       <= EXTRACT( MONTH FROM emy_PjEnde   )
           AND NOT EXISTS 
               ( SELECT * 
                   FROM pra_PayrollAccount 
                  INNER JOIN say_Salary ON say_PraUId = pra_UId
                  WHERE pra_PrmUId = :iPrmUId 
                    AND say_EmyUId = emy_UId )  
         ORDER BY emp_UId, emy_UId
          INTO :emp_UID,            :emp_PersNr,         :emp_PeidNr,       :emp_Name,   
               :emp_Vorname,        :emp_Strasse,        :emp_LandUId,      :coi_Bezeichnung, 
               :emp_PLZ,            :emp_ORT,            :emp_GeburtsDatum, :emp_PensionDatum, 
               :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Geschlecht,   :iEmpDepUId,         
               :iEmpCatUId,         :say_EmyUId,         :dEmyPjAnfang,     :dEmyPjEnde,         
               :emy_BesGrad,        :emy_IVGrad,         :emp_PrgUId,       :coi_IsoCode,
               :emp_Stellung,       :say_Status,
               :emp_DepCode,        :emp_CatCode,        :emp_Aufenthalt
      DO 
      BEGIN  

        bCoiIstOK = bSuspendRec;
        bDepIstOK = bSuspendRec;
        bCatIstOK = bSuspendRec;
 
        /* Wohnsitz als Filter definiert */
        IF ( ( iPrmCoiUId IS NOT NULL ) AND (emp_LandUId <> iPrmCoiUId) )
        THEN 
          bCoiIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCoiUId IS NOT NULL ) ) THEN
          bCoiIstOK = 1; 

        /* Abteilung als Filter definiert */
        IF ( 
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NOT NULL ) AND ( iEmpDepUId <> iPrmDepUId) 
              OR
              ( iPrmDepUId IS NOT NULL ) AND ( iEmpDepUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bDepIstOK = 0;   
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmDepUId IS NOT NULL ) ) THEN
          bDepIstOK = 1;
                  

        /* Kategorie als Filter definiert */
        IF ( 
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NOT NULL ) AND ( iEmpCatUId <> iPrmCatUId )
              OR
              ( iPrmCatUId IS NOT NULL ) AND ( iEmpCatUId IS NULL     ) AND ( bPrmIsGroupped = 0 )
           ) 
        THEN
          bCatIstOK = 0;
        ELSE
        IF ( ( bPrmIstUnd = 0 ) AND ( iPrmCatUId IS NOT NULL ) ) THEN
          bCatIstOK = 1;


        /* UND- / ODER- Verknuepfung*/
        
        bIstOK = 0;
        
        IF ( bPrmIstUnd = 1 ) THEN 
        BEGIN   /* UND-Verknuepfung */

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) = 3 ) THEN
            bIstOK = 1;

        END 
        ELSE 
        BEGIN  /* OR-Verknuepfung*/

          IF ( ( bCoiIstOK + bDepIstOK + bCatIstOK ) > 0 ) THEN
            bIstOK = 1;

        END

        IF ( bIstOK = 1 ) THEN 
        BEGIN

          /* Datum Von*/
          EXECUTE PROCEDURE sp_DateEncode 1, :iPrmMonat, EXTRACT( YEAR FROM :dEmyPjAnfang )
            RETURNING_VALUES :say_DatumVom; 

          IF ( dEmyPjAnfang > say_DatumVom ) THEN 
            say_DatumVom = dEmyPjAnfang; 
   
          /* Datum Bis */
          EXECUTE PROCEDURE sp_GetEndOfMonth :say_DatumVom 
            RETURNING_VALUES :say_DatumBis; 
 
          IF ( dEmyPjEnde < say_DatumBis ) THEN 
            say_DatumBis = dEmyPjEnde; 

          say_UId        = NULL;
          say_AnzDetails = 0;
          say_BruttoLohn = 0;
          say_NettoLohn  = 0;
          say_LA_Text    = NULL;

          EXECUTE PROCEDURE sp_Say_GetEmpJahresLohnNetto :emp_UId 
            RETURNING_VALUES say_JahresLohn;
            
          EXECUTE PROCEDURE sp_Luk_SelectBezeichnung 'GESCHLECHT', :emp_Geschlecht        
            RETURNING_VALUES emp_GeschlechtBezei; 
            
          SUSPEND;

        END

      END
 
    END

  END

END!!
COMMIT!!

-- FS#795:END
-- +++

-- +++
-- FS#820:START - Bug in form EmployeeManageFRM, Tab „Stunden/Ferien“, Hours Calculation

CREATE OR ALTER PROCEDURE sp_Emh_SetDefWorkHoursPerDay 
(
    pi_EmpUId DI_UID
)
AS
  /* Set default value for working hours per day (emh_Soll_AzTag)*/
  
DECLARE VARIABLE iEmhUId          DI_UID;
DECLARE VARIABLE iEmhSollAzMonat  DI_INT;
DECLARE VARIABLE nEmhBesGrad      DN_NUMBER4;  
DECLARE VARIABLE iTplPraUId       DI_UID;
DECLARE VARIABLE iBuyUId          DI_UID;

BEGIN

  SELECT emp_BuyUId
      FROM emp_Employee
     WHERE emp_UId = :pi_EmpUId
      INTO :iBuyUId;
  
    EXECUTE PROCEDURE sp_Pra_GetAccountForTemplate :iBuyUId
     RETURNING_VALUES :iTplPraUId;
  
  FOR
    SELECT emh_UId,   
           emh_Soll_AzMonat, 
           ( SELECT emh_BesGrad FROM sp_Emh_CalcBestGrad( :pi_EmpUId, emh_Monat ) ) AS emh_BesGrad
      FROM emh_EmployeeHours
     WHERE emh_EmpUId = :pi_EmpUId
       AND NOT EXISTS
           (
              SELECT say_UId
                FROM say_Salary
                JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                         AND emy_EmpUId = :pi_EmpUId
               WHERE say_PraUId <> :iTplPraUId
                 AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                               AND     EXTRACT(MONTH FROM say_DatumBis)
           )
      INTO :iEmhUId,  
           :iEmhSollAzMonat, 
           :nEmhBesGrad
  DO
  BEGIN    
    
    iEmhSollAzMonat = IIF( nEmhBesGrad = 0, 0, iEmhSollAzMonat / nEmhBesGrad );
    
    UPDATE emh_EmployeeHours
       SET emh_Soll_AzMonat = :iEmhSollAzMonat
     WHERE emh_UId = :iEmhUId;
    
  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emy_UpdateEmpHours 
(
    pi_EmpUId     DI_UID_NN,
    pi_TplPraUId  DI_UID   DEFAULT NULL
)
AS
  /* Update emh_BesGrad field in table emh_EmployeeHours*/
  
  DECLARE  iTplPraUId     DI_UID;
  DECLARE  iBuyUId        DI_UID;

BEGIN

  iTplPraUId = pi_TplPraUId;
  
  IF ( iTplPraUId IS NULL ) THEN
  BEGIN
  
    SELECT emp_BuyUId
      FROM emp_Employee
     WHERE emp_UId = :pi_EmpUId
      INTO :iBuyUId;
  
    EXECUTE PROCEDURE sp_Pra_GetAccountForTemplate :iBuyUId
     RETURNING_VALUES :iTplPraUId;
    
  END

  UPDATE emh_EmployeeHours
     SET emh_BesGrad = ( SELECT emh_BesGrad FROM sp_Emh_CalcBestGrad( :pi_EmpUId, emh_Monat ) )
   WHERE emh_EmpUId  = :pi_EmpUId
     AND NOT EXISTS
         (
            SELECT say_UId
              FROM say_Salary
              JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                       AND emy_EmpUId = :pi_EmpUId
             WHERE say_PraUId <> :iTplPraUId
               AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                             AND     EXTRACT(MONTH FROM say_DatumBis)
         );
   
  UPDATE emh_EmployeeHours
     SET emh_Soll_AzMonat = emh_Soll_AzMonat * emh_BesGrad
   WHERE emh_EmpUId  = :pi_EmpUId
     AND NOT EXISTS 
         (
            SELECT say_UId
              FROM say_Salary
              JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                       AND emy_EmpUId = :pi_EmpUId
             WHERE say_PraUId <> :iTplPraUId
               AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                             AND     EXTRACT(MONTH FROM say_DatumBis)
         );

END!!
COMMIT!!

-- FS#820:END
-- +++

-- +++
-- FS#818:START - PKLohn - Improve logic of MeldungAnAmt.fr3 in RptOtherNotificationsFRM

CREATE OR ALTER PROCEDURE sp_Pra_RptEinAustritte 
(
    pi_BuyUId DI_UID,
    pi_Monat  DI_INT = NULL
)
RETURNS 
(
    buy_UId             DI_UID,
    pra_UId             DI_UID,
    emp_UId             DI_UID,
    emp_Peidnr          DS_STR20,
    emp_Name            DS_STR50,
    emp_Vorname         DS_STR50,
    emp_Strasse         DS_STR50,
    emp_HausNr          DS_STR5,
    emp_Land            DS_CODE,
    emp_Plz             DS_PLZ,
    emp_Ort             DS_STR50,
    emp_GeburtsDatum    DD_DATE,
    emp_Geschlecht      DS_ONECHARFLAG,
    emp_EintrittsDatum  DD_DATE,
    emp_AustrittsDatum  DD_DATE,
    emp_Aufenthalt      DS_ONECHARFLAG,
    emp_Nation          DS_CODE,
    emp_Zivilstand      DS_ONECHARFLAG,
    emp_Ahv_FiiUId      DI_UID,
    emp_IstEintritt     DS_ONECHARFLAG,
    emp_IstAustritt     DS_ONECHARFLAG,
    emy_Besgrad         DN_NUMBER2,
    fii_AbrechnungNr    DS_STR20,
    fii_Code            DS_CODE,
    fii_Name            DS_STR50,
    fii_NameZusatz      DS_STR50,
    fii_Strasse         DS_STR50,
    fii_Plz             DS_PLZ,
    fii_Ort             DS_STR50
)
AS
DECLARE VARIABLE iCbxMonat    DI_SMLINT;
DECLARE VARIABLE iPraMonat    DI_SMLINT;
DECLARE VARIABLE iPraJahr     DI_BUSINESSYEAR;
DECLARE VARIABLE iEinMonat    DI_SMLINT;
DECLARE VARIABLE iAusMonat    DI_SMLINT;
DECLARE VARIABLE iEinJahr     DI_BUSINESSYEAR;
DECLARE VARIABLE iAusJahr     DI_BUSINESSYEAR;
BEGIN

  pra_UId = NULL;

  iCbxMonat = :pi_Monat;
  
   SELECT DISTINCT
          :iCbxMonat,
          buy_UId,
          buy_GeschJahr,
          pra_UId
     FROM buy_businessyear buy
     LEFT JOIN prm_PayrollMonth prm ON prm.prm_buyuid = buy.buy_uid  
     LEFT JOIN pra_PayrollAccount pra ON pra.pra_PrmUId = prm.prm_UId
     WHERE buy.buy_uid = :pi_BuyUId
     AND ( :pi_Monat IS NULL OR :pi_Monat = prm_Monat )
     AND prm_AbreNr = 0
    INTO :iPraMonat,
         :buy_UId,
         :iPraJAHR,
         :pra_UId;

  IF (buy_UId IS NOT NULL) THEN
  BEGIN

     FOR 
       SELECT DISTINCT emp_UId
         FROM emp_Employee
         LEFT JOIN emy_EmploymentPeriod ON emy_EmpUId = emp_UId
        WHERE emp_BuyUid = :buy_UId          
          AND emp_AHV_FiiUId IS NOT NULL
         INTO :emp_UId

     DO 
     BEGIN
       
        SELECT emp_PeidNr,      emp_Name,            emp_Vorname,         emp_Strasse,
               CL.coi_IsoCode,  emp_Plz,             emp_Ort,             emp_GeburtsDatum,
               emp_Geschlecht,  emp_EintrittsDatum,  emp_AustrittsDatum,  emp_Aufenthalt,
               emp_Zivilstand,  CN.coi_IsoCode,      emp_AHV_FiiUId,      fii_AbrechnungNr,
               fii_Code,        fii_Name,            fii_NameZusatz,      fii_Strasse,
               fii_Plz,         fii_Ort,             emp_HausNr
          FROM emp_Employee
          LEFT JOIN coi_CountryIso   CL ON CL.coi_UId = emp_LandUId
          LEFT JOIN coi_CountryIso   CN ON CN.coi_UId = emp_NationUId
          LEFT JOIN fii_FirmInstitution ON fii_UId    = emp_AHV_FiiUId
         WHERE emp_UID = :emp_UID
          INTO :emp_PeidNr,     :emp_Name,           :emp_Vorname,        :emp_Strasse,
               :emp_Land,       :emp_Plz,            :emp_Ort,            :emp_GeburtsDatum,
               :emp_Geschlecht, :emp_EintrittsDatum, :emp_AustrittsDatum, :emp_Aufenthalt,
               :emp_Zivilstand, :emp_Nation,         :emp_AHV_FiiUId,     :fii_AbrechnungNr,
               :fii_Code,       :fii_Name,           :fii_NameZusatz,     :fii_Strasse,
               :fii_Plz,        :fii_Ort,            :emp_HausNr;


       emp_IstEintritt = '0';
       emp_IstAustritt = '0';

       iEinMonat = EXTRACT( MONTH FROM :emp_EintrittsDatum );
       iEinJahr  = EXTRACT( YEAR  FROM :emp_EintrittsDatum );
       iAusMonat = 0;
       iAusJahr  = 0;


       IF (emp_AustrittsDatum IS NOT NULL) THEN 
       BEGIN
      
         iAusMonat = EXTRACT( MONTH FROM :emp_AustrittsDatum );
         iAusJahr  = EXTRACT( YEAR  FROM :emp_AustrittsDatum );

       END

       IF ( ( iPraJahr = iEinJahr ) AND ( iPraMONAT = iEinMonat ) ) THEN
       BEGIN
         emp_IstEintritt = '1';
       END 
          
       IF ( ( iPraJahr = iAusJahr ) AND ( iPraMonat = iAusMonat ) ) THEN 
       BEGIN
         emp_IstAustritt = '1';
       END 

      IF ( ( emp_IstEintritt = '1' ) OR ( emp_IstAustritt = '1' ) ) THEN 
      BEGIN
           
         -- BesGrad des Mitarbeiters bei der Abrechnung   
         FOR 
           SELECT emy_BesGrad 
             FROM emy_EmploymentPeriod 
            WHERE emy_EmpUId = :emp_UId 
             INTO :emy_BesGrad 
         DO 
         BEGIN
           
           IF ( emy_BesGrad IS NULL ) THEN 
             emy_BesGrad = 0;
             
         END

         SUSPEND;

      END

    END

  END

END!!
COMMIT!!

-- FS#818:END
-- +++

SET TERM ;!!
