﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.10
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++

-- +++
-- FS#756:START - PKLohn - Hours Improvements in EmployeeManageFRM

CREATE OR ALTER PROCEDURE sp_Emy_UpdateEmpHours 
(
  pi_EmpUId       DI_UID_NN,
  pi_TplPraUId    DI_UID DEFAULT NULL
)
AS
  /* Update emh_BesGrad field in table emh_EmployeeHours*/
  
  DECLARE  iTplPraUId     DI_UID;
  DECLARE  iBuyUId        DI_UID;

BEGIN

  iTplPraUId = pi_TplPraUId;
  
  IF ( iTplPraUId IS NULL ) THEN
  BEGIN
  
    SELECT emp_BuyUId
      FROM emp_Employee
     WHERE emp_UId = :pi_EmpUId
      INTO :iBuyUId;
  
    EXECUTE PROCEDURE sp_Pra_GetAccountForTemplate :iBuyUId
     RETURNING_VALUES :iTplPraUId;
    
  END

  UPDATE emh_EmployeeHours
     SET emh_BesGrad = ( SELECT emh_BesGrad FROM sp_Emh_CalcBestGrad( :pi_EmpUId, emh_Monat ) )
   WHERE emh_EmpUId  = :pi_EmpUId
     AND NOT EXISTS
         (
            SELECT say_UId
              FROM say_Salary
              JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                       AND emy_EmpUId = :pi_EmpUId
             WHERE say_PraUId <> :pi_TplPraUId
               AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                             AND     EXTRACT(MONTH FROM say_DatumBis)
         );
   
  UPDATE emh_EmployeeHours
     SET emh_Soll_AzMonat = emh_Soll_AzMonat * emh_BesGrad
   WHERE emh_EmpUId  = :pi_EmpUId
     AND NOT EXISTS 
         (
            SELECT say_UId
              FROM say_Salary
              JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                       AND emy_EmpUId = :pi_EmpUId
             WHERE say_PraUId <> :pi_TplPraUId
               AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                             AND     EXTRACT(MONTH FROM say_DatumBis)
         );

END!!
COMMIT!!

COMMENT ON PROCEDURE sp_Emy_UpdateEmpHours IS 'Update emh_BesGrad field in table emh_EmployeeHours'!!
COMMENT ON PARAMETER sp_Emy_UpdateEmpHours.pi_EmpUId     IS 'Id of the Employee'!!
COMMENT ON PARAMETER sp_Emy_UpdateEmpHours.pi_TplPraUId  IS 'Payroll account UId'!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Emh_FillData 
(
  pi_EmpUId           DI_UID_NN,
  pi_BuyUId           DI_UID_NN,
  pi_App_ActiveUser   DI_UID_NN,
  pb_ZeroValues       DB_BOOLEAN = 0
)
AS
  /* Fill EmployeeHours data by Employee Id and Business Year Id*/

  DECLARE iEmhCount          DI_INT;
  DECLARE bZeroValues        DB_BOOLEAN;
  DECLARE iTplPraUId         DI_UID;

BEGIN
  
  SELECT COUNT(1)
    FROM emh_EmployeeHours 
   WHERE emh_EmpUId = :pi_EmpUId
    INTO :iEmhCount;   
 
  bZeroValues = COALESCE( pb_ZeroValues, 0 );
  
  EXECUTE PROCEDURE sp_Pra_GetAccountForTemplate :pi_BuyUId
   RETURNING_VALUES :iTplPraUId;
   
  IF ( iEmhCount = 0 ) THEN
  BEGIN

    INSERT INTO emh_EmployeeHours
    (
      emh_EmpUId,
      emh_Monat,
      emh_Besgrad,
      emh_Soll_Tage,
      emh_Soll_AzMonat,
      emh_IstAktiv,
      emh_CreateDate,
      emh_CreateUsrUId, 
      emh_MutDate,
      emh_MutUsrUId
    ) 
    SELECT :pi_EmpUId,
            fih_Monat,
            0,
            IIF( :bZeroValues = 1, 0, fih_SollTage     ),
            IIF( :bZeroValues = 1, 0, fih_SollAzMonat  ),
            1,
            Current_TimeStamp, 
           :pi_app_ActiveUser, 
            Current_TimeStamp, 
           :pi_app_ActiveUser
      FROM fih_FirmHours
     WHERE fih_BuyUId = :pi_BuyUId
       AND NOT EXISTS
           (
              SELECT say_UId
                FROM say_Salary
                JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                         AND emy_EmpUId = :pi_EmpUId
               WHERE say_PraUId <> :iTplPraUId               
                 AND fih_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                               AND     EXTRACT(MONTH FROM say_DatumBis)
           );

  END
  ELSE
  BEGIN
  
    UPDATE  emh_EmployeeHours
       SET  emh_Soll_Tage = 
              IIF
              ( 
                :bZeroValues = 1, 
                0, 
                ( 
                  SELECT fih_SollTage 
                    FROM fih_FirmHours 
                   WHERE fih_BuyUId = :pi_BuyUId 
                     AND fih_Monat  = emh_Monat
                )
              ),
            emh_Soll_AzMonat = 
              IIF
              ( 
                :bZeroValues = 1, 
                0, 
                (
                  SELECT fih_SollAzMonat 
                    FROM fih_FirmHours 
                   WHERE fih_BuyUId = :pi_BuyUId 
                     AND fih_Monat  = emh_Monat
                )
              )
     WHERE emh_EmpUId = :pi_EmpUId
       AND NOT EXISTS
           (
              SELECT say_UId
                FROM say_Salary
                JOIN emy_EmploymentPeriod ON emy_UId    = say_EmyUId
                                         AND emy_EmpUId = :pi_EmpUId
               WHERE say_PraUId <> :iTplPraUId
                 AND emh_Monat BETWEEN EXTRACT(MONTH FROM say_DatumVom)
                               AND     EXTRACT(MONTH FROM say_DatumBis)
           );
  
  END

  EXECUTE PROCEDURE sp_Emy_UpdateEmpHours( :pi_EmpUId, :iTplPraUId );

END!!
COMMIT!!

-- FS#756:END
-- +++

-- +++
-- FS#755:START - PKLohn - SDT Import Wizard Bug

CREATE OR ALTER PROCEDURE sp_Sdt_DeleteByBuyAndType 
(
    pi_BuyUId   DI_UID,
    ps_SdtType  DS_ONECHARFLAG DEFAULT NULL
)
AS
  /* Delete salary deduction record by business year and type*/

BEGIN

  DELETE FROM sdt_SalaryDeductionType
   WHERE sdt_UId IN 
         (
            SELECT sdt_UId 
              FROM sdt_SalaryDeductionType SDT
             WHERE sdt_BuyUId = :pi_BuyUId
               AND ( :ps_SdtType IS NULL OR :ps_SdtType = sdt_Typ )
               AND sdt_LArt_SdtUId IS NOT NULL
               AND NOT EXISTS
                   (
                      SELECT sad_UId AS rec_UId
                        FROM sad_SalaryDetail
                       WHERE sad_SdtUId = SDT.sdt_UId
                       UNION ALL
                      SELECT fii_UId AS rec_UId
                        FROM fii_FirmInstitution
                       WHERE fii_A1_SdtUId IS NOT NULL AND fii_A1_SdtUId = SDT.sdt_UId
                          OR fii_A2_SdtUId IS NOT NULL AND fii_A2_SdtUId = SDT.sdt_UId
                          OR fii_A3_SdtUId IS NOT NULL AND fii_A3_SdtUId = SDT.sdt_UId
                          OR fii_A4_SdtUId IS NOT NULL AND fii_A4_SdtUId = SDT.sdt_UId
                   )
         );     
  
  DELETE FROM sdt_SalaryDeductionType
   WHERE sdt_BuyUId = :pi_BuyUId
     AND ( :ps_SdtType IS NULL OR :ps_SdtType = sdt_Typ )
     AND NOT EXISTS
         (
            SELECT sad_UId AS rec_UId
              FROM sad_SalaryDetail
             WHERE sad_SdtUId = sdt_UId
             UNION ALL
            SELECT fii_UId AS rec_UId
              FROM fii_FirmInstitution
             WHERE fii_A1_SdtUId IS NOT NULL AND fii_A1_SdtUId = sdt_UId
                OR fii_A2_SdtUId IS NOT NULL AND fii_A2_SdtUId = sdt_UId
                OR fii_A3_SdtUId IS NOT NULL AND fii_A3_SdtUId = sdt_UId
                OR fii_A4_SdtUId IS NOT NULL AND fii_A4_SdtUId = sdt_UId
         );
  
END!!
COMMIT!!

-- FS#755:END
-- +++

-- +++
-- FS#770:START - PKLohn - Error in RptSalaryFRM

CREATE OR ALTER PROCEDURE sp_Sar_EmployeeList 
(
  pi_BuyUId   DI_UID
)
RETURNS 
(
    sar_UId           DI_UID,
    sar_Count         DI_INT,
    emp_UId           DI_UID,
    emp_BuyUId        DI_UID,
    emp_PersNr        DI_INT,
    emp_PeidNr        DS_STR20,
    emp_Name          DS_STR50,
    emp_Vorname       DS_STR50,
    emp_Strasse       DS_STR50,
    emp_HausNr        DS_STR5,
    emp_Aufenthalt    DS_ONECHARFLAG,
    coi_IsoCode       DS_CODE,
    fir_La_LayoutTyp  DS_ONECHARFLAG,
    fir_La_KopfTyp    DS_ONECHARFLAG,
    emp_MutDate       DD_TIMESTAMP,
    emp_MutUsrUId     DI_UID
)
AS
  
  /* Get employee list for salary report, select all employees which have salary data*/
  DECLARE VARIABLE iPraUId DI_UID;

BEGIN

  FOR 
    SELECT E.emp_UId,
           E.emp_BuyUId,
           E.emp_PersNr,
           E.emp_PEIDNr,
           E.emp_Name,
           E.emp_Vorname,
           E.emp_Strasse,
           E.emp_HausNr,
           E.emp_Aufenthalt,
           C.coi_IsoCode,
           F.fir_LA_LayoutTyp,
           F.fir_LA_KopfTyp,
           E.emp_MutDate,
           E.emp_MutUsrUId
      FROM emp_Employee E
      LEFT JOIN buy_BusinessYear Y  ON Y.buy_UId = E.emp_BuyUId
      LEFT JOIN fir_Firm         F  ON F.fir_UId = Y.buy_FirUId
      LEFT JOIN coi_CountryISO   C  ON C.coi_UId = E.emp_LandUId

     WHERE emp_BuyUId = :pi_BuyUId

     INTO  :emp_uid, 
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_Aufenthalt,
           :coi_IsoCode,
           :fir_LA_LayoutTyp,
           :fir_LA_KopfTyp,
           :emp_MutDate,
           :emp_MutUsrUId
  DO 
  BEGIN

    sar_UId = NULL;    
    
    SELECT sar_UId 
      FROM sar_SalaryReport
     WHERE sar_EmpUId = :emp_uid
      INTO :sar_UId;
      
    SELECT COUNT(sar_UId)
      FROM sar_SalaryReport
      JOIN emp_Employee ON emp_UId = sar_EmpUId
     WHERE emp_BuyUId = :pi_BuyUId
      INTO :sar_Count;

    SUSPEND;
    
  END
  
END!!
COMMIT!!

-- FS#770:END
-- +++

-- +++
-- FS#738:START

-- +++++++++++++++++++++++++++++++++++++++++++++++
-- Create a new table for Application PDF template

CREATE TABLE apd_AppPdfTemplate
(
   apd_UId           DI_UID_NN,
   apd_Name          DS_STR50_NN,
   apd_Schablone     DS_STR255_NN,
   apd_Mappe         DS_STR255,
   apd_IstAktiv      DB_ISACTIVE_NN,
   apd_CreateDate    DD_TIMESTAMP_NN,
   apd_CreateUsrUId  DI_UID_NN,
   apd_MutDate       DD_TIMESTAMP_NN,
   apd_MutUsrUId     DI_UID_NN
 )!!


COMMENT ON TABLE apd_AppPdfTemplate IS 'Application PDF templates list'!!

COMMENT ON COLUMN apd_AppPdfTemplate.apd_UId           IS 'Unique record Id'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_Name          IS 'PDF template verbal name'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_Schablone     IS 'PDF template file name'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_Mappe         IS 'Subfolder from the Listen folder where template is located'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_IstAktiv      IS 'Active/Disabled flag'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_CreateDate    IS 'Record creation date'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_CreateUsrUId  IS 'User Id whom created the record'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_MutDate       IS 'Record last modifcation date'!!
COMMENT ON COLUMN apd_AppPdfTemplate.apd_MutUsrUId     IS 'User Id whom last time modified the record'!!


ALTER TABLE apd_AppPdfTemplate  ADD CONSTRAINT PK_Apd PRIMARY KEY (apd_UId) USING INDEX IDX_Apd_PK!!

ALTER TABLE apd_AppPdfTemplate
  ADD CONSTRAINT FK_ApdCreateUsr2Usr
  FOREIGN KEY (apd_CreateUsrUId)
  REFERENCES usr_User(usr_UId)
  USING INDEX IDX_Apd_ByCreateUsr!!

ALTER TABLE apd_AppPdfTemplate
  ADD CONSTRAINT FK_ApdMutUsr2Usr
  FOREIGN KEY (apd_MutUsrUId)
  REFERENCES usr_User(usr_UId)
  USING INDEX IDX_Apd_ByMutUsr!!

CREATE INDEX IDX_Apd_ByName ON apd_AppPdfTemplate( apd_Name )!!

COMMENT ON INDEX IDX_Apd_PK           IS 'apd_AppPdfTemplate by UId - Primary Key'!!
COMMENT ON INDEX IDX_Apd_PK           IS 'apd_AppPdfTemplate by template verbal name'!!
COMMENT ON INDEX IDX_Apt_ByCreateUsr  IS 'apd_AppPdfTemplate by CreateUsr ID (search over FK usage)'!!
COMMENT ON INDEX IDX_Apt_ByMutUsr     IS 'apd_AppPdfTemplate by MutUsr ID (search over FK usage)'!!

COMMIT!!


-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- Create generator and triggers for table apd_AppPdfTemplate


CREATE GENERATOR GEN_Apd_UId!!

SET GENERATOR GEN_Apd_UId TO 1!!

COMMENT ON GENERATOR GEN_Apd_UId IS 'ID for apd_AppPdfTemplate table'!!


-- Create trigger for new record of apd_AppPdfTemplate table that initiate Id


CREATE TRIGGER TRG_Apd_BeforeIns_0
  FOR apd_AppPdfTemplate ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN

  IF ( ( new.apd_UId IS NULL ) OR ( new.apd_UId = 0 ) ) THEN
  BEGIN
     new.apd_UId = GEN_ID ( GEN_Apd_UId, 1 );
  END

END!!


COMMENT ON TRIGGER TRG_Apt_BeforeIns_0 IS 'apd_AppPdfTemplate: Set ID for new record'!!

COMMIT!!

-- ++++++++++++++++++++++++++++++++++
-- Insert PDF templates list to table

DELETE FROM apd_AppPdfTemplate!!

INSERT INTO apd_AppPdfTemplate
(
  apd_Name,
  apd_Schablone,
  apd_Mappe,
  apd_IstAktiv,
  apd_CreateDate,
  apd_CreateUsrUId,
  apd_MutDate,
  apd_MutUsrUId
)
VALUES
(
  'Austritt Mitarbeiter',
  'SF_Report_AustrittMitarbeiter.pdf',
  'PDF',
  1,
  Current_TimeStamp,
  1,
  Current_TimeStamp,
  1
)!!

INSERT INTO apd_AppPdfTemplate
(
  apd_Name,
  apd_Schablone,
  apd_Mappe,
  apd_IstAktiv,
  apd_CreateDate,
  apd_CreateUsrUId,
  apd_MutDate,
  apd_MutUsrUId
)
VALUES
(
  'Eintritt Mitarbeiter (Obligatorisch)',
  'SF_Report_EintrittMitarbeiter_Obligatorisch.pdf',
  'PDF',
  1,
  Current_TimeStamp,
  1,
  Current_TimeStamp,
  1
)!!

INSERT INTO apd_AppPdfTemplate
(
  apd_Name,
  apd_Schablone,
  apd_Mappe,
  apd_IstAktiv,
  apd_CreateDate,
  apd_CreateUsrUId,
  apd_MutDate,
  apd_MutUsrUId
)
VALUES
(
  'Eintritt Mitarbeiter (Ueberobligatorisch)',
  'SF_Report_EintrittMitarbeiter_Ueberobligatorisch.pdf',
  'PDF',
  1,
  Current_TimeStamp,
  1,
  Current_TimeStamp,
  1
)!!

INSERT INTO apd_AppPdfTemplate
(
  apd_Name,
  apd_Schablone,
  apd_Mappe,
  apd_IstAktiv,
  apd_CreateDate,
  apd_CreateUsrUId,
  apd_MutDate,
  apd_MutUsrUId
)
VALUES
(
  'Gesundheitserklärung',
  'SF_Report_Gesundheitserklärung.pdf',
  'PDF',
  1,
  Current_TimeStamp,
  1,
  Current_TimeStamp,
  1
)!!

INSERT INTO apd_AppPdfTemplate
(
  apd_Name,
  apd_Schablone,
  apd_Mappe,
  apd_IstAktiv,
  apd_CreateDate,
  apd_CreateUsrUId,
  apd_MutDate,
  apd_MutUsrUId
)
VALUES
(
  'Mutationsmeldung',
  'SF_Report_Mutationsmeldung.pdf',
  'PDF',
  1,
  Current_TimeStamp,
  1,
  Current_TimeStamp,
  1
)!!

COMMIT!!

-- FS#738:END
-- +++

-- +++
-- FS#739:START - PKLohn - PDF Templates for Sozialfondsmeldungen Form

CREATE OR ALTER PROCEDURE sp_Emp_Select 
(
  pi_BuyUId DI_UID
)
RETURNS 
(
    emp_UId                 DI_UID,
    emp_Buyuid              DI_UID,
    emp_Persnr              DI_INT,
    emp_Peidnr              DS_STR20,
    emp_Name                DS_STR50,
    emp_Vorname             DS_STR50,
    emp_Strasse             DS_STR50,
    emp_Hausnr              DS_STR5,
    emp_Landuid             DI_UID,
    emp_Plz                 DS_PLZ,
    emp_Steuergde           DS_PLZ,
    emp_Ort                 DS_STR50,
    emp_Geburtsdatum        DD_DATE,
    emp_GeburtsDay          DI_INT,    
    emp_GeburtsMonth        DI_INT,    
    emp_Pensiondatum        DD_DATE,
    emp_Geschlecht          DS_ONECHARFLAG,
    emp_Eintrittsdatum      DD_DATE,
    emp_Austrittsdatum      DD_DATE,
    emp_Zivilstand          DS_ONECHARFLAG,
    emp_Aufenthalt          DS_ONECHARFLAG,
    emp_Nationuid           DI_UID,
    emp_Heimatort           DS_STR50,
    emp_Anzkinder           DI_SMLINT,
    emp_Telefon             DS_STR30,
    emp_Handy               DS_STR30,
    emp_Email               DS_STR30,
    emp_Beruf               DS_STR50,
    emp_Stellung            DS_STR50,
    emp_Lohnklasse          DS_STR50,
    emp_Depuid              DI_UID,
    emp_Catuid              DI_UID,
    emp_Prguid              DI_UID,
    emp_Emiuid              DI_UID,
    emp_Ahv_fiiuid          DI_UID,
    emp_Alv_fiiuid          DI_UID,
    emp_Pk_fiiuid           DI_UID,
    emp_Kkp_fiiuid          DI_UID,
    emp_Kkt_fiiuid          DI_UID,
    emp_Unf_fiiuid          DI_UID,
    emp_Ste_fiiuid          DI_UID,
    emp_Zpk_fiiuid          DI_UID,
    emp_Vortragstd          DN_NUMBER2,
    emp_Vortragferien       DN_NUMBER2,
    emp_Sonderferien        DN_NUMBER2,
    emp_Anspruchferien      DN_NUMBER2,
    emp_La_Iststunden       DB_BOOLEAN,
    emp_La_Istferien        DB_BOOLEAN,
    emp_La_Istzahlstelle    DB_BOOLEAN,
    emp_IstAktiv            DB_ISACTIVE,
    emp_CreateDate          DD_TIMESTAMP,
    emp_CreateUsrUId        DI_UID,
    emp_MutDate             DD_TIMESTAMP,
    emp_MutUsrUId           DI_UID,
    emp_CreateUser          DS_USERLOGIN,
    emp_MutUser             DS_USERLOGIN,
    emp_Landisocode         DS_CODE,
    emp_Landbezeichnung     DS_DESCR,
    emp_Nationisocode       DS_CODE,
    emp_Nationbezeichnung   DS_DESCR,
    emp_Istch               DB_BOOLEAN,
    emp_Ch_peidnr           DS_STR20,
    emp_Prevyearuid         DI_UID,
    dep_Code                DS_STR12,
    dep_Bezeichnung         DS_STR50,
    cat_Code                DS_STR12,
    cat_Bezeichnung         DS_STR50,
    prg_Gruppe              DS_STR12,
    prg_Bezeichnung         DS_STR50,
    ahv_Code                DS_CODE,
    ahv_Name                DS_STR50,
    ahv_Strasse             DS_STR50,
    ahv_Plz                 DS_PLZ,
    ahv_Ort                 DS_STR50,
    ahv_Intuid              DI_UID,
    ahv_Abrenr              DS_STR20,
    alv_Code                DS_CODE,
    alv_Name                DS_STR50,
    alv_Strasse             DS_STR50,
    alv_Plz                 DS_PLZ,
    alv_Ort                 DS_STR50,
    alv_Intuid              DI_UID,
    alv_Abrenr              DS_STR20,
    pk_Code                 DS_CODE,
    pk_Name                 DS_STR50,
    pk_Strasse              DS_STR50,
    pk_Plz                  DS_PLZ,
    pk_Ort                  DS_STR50,
    pk_Intuid               DI_UID,
    pk_Abrenr               DS_STR20,
    kkp_Code                DS_CODE,
    kkp_Name                DS_STR50,
    kkp_Strasse             DS_STR50,
    kkp_Plz                 DS_PLZ,
    kkp_Ort                 DS_STR50,
    kkp_Intuid              DI_UID,
    kkp_Abrenr              DS_STR20,
    kkt_Code                DS_CODE,
    kkt_Name                DS_STR50,
    kkt_Strasse             DS_STR50,
    kkt_Plz                 DS_PLZ,
    kkt_Ort                 DS_STR50,
    kkt_Intuid              DI_UID,
    kkt_Abrenr              DS_STR20,
    unf_Code                DS_CODE,
    unf_Name                DS_STR50,
    unf_Strasse             DS_STR50,
    unf_Plz                 DS_PLZ,
    unf_Ort                 DS_STR50,
    unf_Intuid              DI_UID,
    unf_Abrenr              DS_STR20,
    ste_Code                DS_CODE,
    ste_Name                DS_STR50,
    ste_Strasse             DS_STR50,
    ste_Plz                 DS_PLZ,
    ste_Ort                 DS_STR50,
    ste_Intuid              DI_UID,
    ste_Abrenr              DS_STR20,
    zpk_Code                DS_CODE,
    zpk_Name                DS_STR50,
    zpk_Strasse             DS_STR50,
    zpk_Plz                 DS_PLZ,
    zpk_Ort                 DS_STR50,
    zpk_Intuid              DI_UID,
    zpk_Abrenr              DS_STR20,
    luk_Zivilstand          DS_DESCR
    )
AS
  /* Select Employee data by Id or by Employee*/
  
  DECLARE bIsIndustrieMinuten  DB_BOOLEAN;
  DECLARE iVortragStd          DI_INT;  
  DECLARE iVortragFerien       DI_INT;  
  DECLARE iFirUId              DI_INT;
  DECLARE iPrevBuyUId          DI_INT;
  DECLARE iBusYear             DI_INT;

BEGIN  
  
  SELECT buy_FirUId, buy_GeschJahr
    FROM buy_BusinessYear
   WHERE buy_UId = :pi_BuyUId
    INTO :iFirUId, :iBusYear;
    
  SELECT buy_UId 
    FROM buy_BusinessYear
   WHERE buy_FirUId = :iFirUId
     AND buy_GeschJahr = (:iBusYear - 1)
    INTO :iPrevBuyUId;

  /* Determine setting industry minutes (Industrieminuten) */
  
  EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByBuy( :pi_BuyUId )
   RETURNING_VALUES :bIsIndustrieMinuten;

  FOR

    SELECT emp_UId,
           emp_BuyUId,
           emp_PersNr,
           emp_PEIDNr,
           emp_Name,
           emp_Vorname,
           emp_Strasse,
           emp_HausNr,
           emp_LandUId,
           emp_PLZ,
           emp_SteuerGde,
           emp_Ort,
           emp_GeburtsDatum,
           EXTRACT(DAY   FROM emp_GeburtsDatum),
           EXTRACT(MONTH FROM emp_GeburtsDatum),           
           emp_PensionDatum,
           emp_Geschlecht,
           emp_EintrittsDatum,
           emp_AustrittsDatum,
           emp_Zivilstand,
           emp_Aufenthalt,
           emp_NationUId,
           emp_HeimatOrt,
           emp_AnzKinder,
           emp_Telefon,
           emp_Handy,
           emp_Email,
           emp_Beruf,
           emp_Stellung,
           emp_Lohnklasse,
           emp_DepUId,
           emp_CatUId,
           emp_PrgUId,
           emp_EmiUId,
           emp_AHV_FiiUId,
           emp_ALV_FiiUId,
           emp_PK_FiiUId,
           emp_KKP_FiiUId,
           emp_KKT_FiiUId,
           emp_UNF_FiiUId,
           emp_STE_FiiUId,
           emp_ZPK_FiiUId,
           emp_VortragStd,
           emp_VortragFerien,
           emp_SonderFerien,
           emp_AnspruchFerien,
           emp_LA_IstStunden,
           emp_LA_IstFerien,
           emp_LA_IstZahlstelle,
           emp_IstAktiv,
           emp_CreateDate,
           emp_CreateUsrUId,
           emp_MutDate,
           emp_MutUsrUId,
           USR_C.usr_Login AS emp_CreateUser,
           USR_M.usr_Login AS emp_MutUser,
           COUNTRY.coi_IsoCode      AS emp_LandIsoCode,
           COUNTRY.coi_Bezeichnung  AS emp_LandBezeichnung,
           NATION.coi_IsoCode       AS emp_NationIsoCode,
           NATION.coi_Bezeichnung   AS emp_NationBezeichnung,
           emp_IstCh,
           emp_Ch_PeidNr,
           dep_code,
           dep_Bezeichnung,
           cat_code,
           cat_Bezeichnung,
           prg_Gruppe,
           prg_Bezeichnung,
           
           (
            SELECT E.emp_UId 
              FROM emp_Employee E
             WHERE E.emp_BuyUId = :iPrevBuyUId
               AND E.emp_PersNr = EMP.emp_PersNr
           ),

           AHV.fii_Code         AS AHV_Code,
           AHV.fii_Name         AS AHV_Name,
           AHV.fii_Strasse      AS AHV_Strasse,
           AHV.fii_PLZ          AS AHV_PLZ,
           AHV.fii_Ort          AS AHV_Ort,
           AHV.fii_IntUId       AS AHV_IntUId,
           AHV.fii_AbrechnungNr AS AHV_AbreNr,

           ALV.fii_Code         AS ALV_Code,
           ALV.fii_Name         AS ALV_Name,
           ALV.fii_Strasse      AS ALV_Strasse,
           ALV.fii_PLZ          AS ALV_PLZ,
           ALV.fii_Ort          AS ALV_Ort,
           ALV.fii_IntUId       AS ALV_IntUId,
           ALV.fii_AbrechnungNr AS ALV_AbreNr,

           PK.fii_Code          AS PK_Code,
           PK.fii_Name          AS PK_Name,
           PK.fii_Strasse       AS PK_Strasse,
           PK.fii_PLZ           AS PK_PLZ,
           PK.fii_Ort           AS PK_Ort,
           PK.fii_IntUId        AS PK_IntUId,
           PK.fii_AbrechnungNr  AS PK_AbreNr,

           KKP.fii_Code         AS KKP_Code,
           KKP.fii_Name         AS KKP_Name,
           KKP.fii_Strasse      AS KKP_Strasse,
           KKP.fii_PLZ          AS KKP_PLZ,
           KKP.fii_Ort          AS KKP_Ort,
           KKP.fii_IntUId       AS KKP_IntUId,
           KKP.fii_AbrechnungNr AS KKP_AbreNr,

           KKT.fii_Code         AS KKT_Code,
           KKT.fii_Name         AS KKT_Name,
           KKT.fii_Strasse      AS KKT_Strasse,
           KKT.fii_PLZ          AS KKT_PLZ,
           KKT.fii_Ort          AS KKT_Ort,
           KKT.fii_IntUId       AS KKT_IntUId,
           KKT.fii_AbrechnungNr AS KKT_AbreNr,

           UNF.fii_Code         AS UNF_Code,
           UNF.fii_Name         AS UNF_Name,
           UNF.fii_Strasse      AS UNF_Strasse,
           UNF.fii_PLZ          AS UNF_PLZ,
           UNF.fii_Ort          AS UNF_Ort,
           UNF.fii_IntUId       AS UNF_IntUId,
           UNF.fii_AbrechnungNr AS UNF_AbreNr,

           STE.fii_Code         AS STE_Code,
           STE.fii_Name         AS STE_Name,
           STE.fii_Strasse      AS STE_Strasse,
           STE.fii_PLZ          AS STE_PLZ,
           STE.fii_Ort          AS STE_Ort,
           STE.fii_IntUId       AS STE_IntUId,
           STE.fii_AbrechnungNr AS STE_AbreNr,

           ZPK.fii_Code         AS ZPK_Code,
           ZPK.fii_Name         AS ZPK_Name,
           ZPK.fii_Strasse      AS ZPK_Strasse,
           ZPK.fii_PLZ          AS ZPK_PLZ,
           ZPK.fii_Ort          AS ZPK_Ort,
           ZPK.fii_IntUId       AS ZPK_IntUId,
           ZPK.fii_AbrechnungNr AS ZPK_AbreNr,
           
           LUK.luk_Bezeichnung  AS luk_Zivilstand

      FROM emp_Employee EMP

      LEFT JOIN usr_User            USR_C     ON emp_CreateUsrUId = USR_C.usr_UId
      LEFT JOIN usr_User            USR_M     ON emp_MutUsrUId    = USR_M.usr_UId
      LEFT JOIN coi_CountryISO      COUNTRY   ON emp_LandUId      = COUNTRY.coi_UId
      LEFT JOIN coi_CountryISO      NATION    ON emp_NationUId    = NATION.coi_UId
      LEFT JOIN dep_Department                ON emp_DepUId       = dep_UId
      LEFT JOIN cat_Category                  ON emp_CatUId       = cat_UId
      LEFT JOIN prg_PayrollGroup              ON emp_PrgUId       = prg_UId
      LEFT JOIN fii_FirmInstitution AHV       ON emp_AHV_FiiUId   = AHV.fii_UId
      LEFT JOIN fii_FirmInstitution ALV       ON emp_ALV_FiiUId   = ALV.fii_UId
      LEFT JOIN fii_FirmInstitution PK        ON emp_PK_FiiUId    = PK.fii_UId
      LEFT JOIN fii_FirmInstitution KKP       ON emp_KKP_FiiUId   = KKP.fii_UId
      LEFT JOIN fii_FirmInstitution KKT       ON emp_KKT_FiiUId   = KKT.fii_UId
      LEFT JOIN fii_FirmInstitution UNF       ON emp_UNF_FiiUId   = UNF.fii_UId
      LEFT JOIN fii_FirmInstitution STE       ON emp_STE_FiiUId   = STE.fii_UId
      LEFT JOIN fii_FirmInstitution ZPK       ON emp_ZPK_FiiUId   = ZPK.fii_UId
      LEFT JOIN luk_Lookup          LUK       ON emp_Zivilstand   = LUK.luk_Code 
                                             AND LUK.luk_Gruppe   = 'ZIVILSTAND'

     WHERE :pi_BuyUId IS NULL OR emp_BuyUId = :pi_BuyUId

  ORDER BY emp_BuyUId, emp_PersNr

      INTO :emp_UId,
           :emp_BuyUId,
           :emp_PersNr,
           :emp_PEIDNr,
           :emp_Name,
           :emp_Vorname,
           :emp_Strasse,
           :emp_HausNr,
           :emp_LandUId,
           :emp_PLZ,
           :emp_SteuerGde,
           :emp_Ort,
           :emp_GeburtsDatum,
           :emp_GeburtsDay,
           :emp_GeburtsMonth,
           :emp_PensionDatum,
           :emp_Geschlecht,
           :emp_EintrittsDatum,
           :emp_AustrittsDatum,
           :emp_Zivilstand,
           :emp_Aufenthalt,
           :emp_NationUId,
           :emp_HeimatOrt,
           :emp_AnzKinder,
           :emp_Telefon,
           :emp_Handy,
           :emp_Email,
           :emp_Beruf,
           :emp_Stellung,
           :emp_Lohnklasse,
           :emp_DepUId,
           :emp_CatUId,
           :emp_PrgUId,
           :emp_EmiUId,
           :emp_AHV_FiiUId,
           :emp_ALV_FiiUId,
           :emp_PK_FiiUId,
           :emp_KKP_FiiUId,
           :emp_KKT_FiiUId,
           :emp_UNF_FiiUId,
           :emp_STE_FiiUId,
           :emp_ZPK_FiiUId,
           :iVortragStd,
           :iVortragFerien,
           :emp_SonderFerien,
           :emp_AnspruchFerien,
           :emp_LA_IstStunden,
           :emp_LA_IstFerien,
           :emp_LA_IstZahlstelle,
           :emp_IstAktiv,
           :emp_CreateDate,
           :emp_CreateUsrUId,
           :emp_MutDate,
           :emp_MutUsrUId,
           :emp_CreateUser,
           :emp_MutUser,
           :emp_LandIsoCode,
           :emp_LandBezeichnung,
           :emp_NationIsoCode,
           :emp_NationBezeichnung,
           :emp_IstCh,
           :emp_Ch_PeidNr,
           :dep_code,
           :dep_Bezeichnung,
           :cat_code,
           :cat_Bezeichnung,
           :prg_Gruppe,
           :prg_Bezeichnung,
           
           :emp_PrevYearUId,

           :AHV_Code,
           :AHV_Name,
           :AHV_Strasse,
           :AHV_PLZ,
           :AHV_Ort,
           :AHV_IntUId,
           :AHV_AbreNr,

           :ALV_Code,
           :ALV_Name,
           :ALV_Strasse,
           :ALV_PLZ,
           :ALV_Ort,
           :ALV_IntUId,
           :ALV_AbreNr,

           :PK_Code,
           :PK_Name,
           :PK_Strasse,
           :PK_PLZ,
           :PK_Ort,
           :PK_IntUId,
           :PK_AbreNr,

           :KKP_Code,
           :KKP_Name,
           :KKP_Strasse,
           :KKP_PLZ,
           :KKP_Ort,
           :KKP_IntUId,
           :KKP_AbreNr,

           :KKT_Code,
           :KKT_Name,
           :KKT_Strasse,
           :KKT_PLZ,
           :KKT_Ort,
           :KKT_IntUId,
           :KKT_AbreNr,

           :UNF_Code,
           :UNF_Name,
           :UNF_Strasse,
           :UNF_PLZ,
           :UNF_Ort,
           :UNF_IntUId,
           :UNF_AbreNr,

           :STE_Code,
           :STE_Name,
           :STE_Strasse,
           :STE_PLZ,
           :STE_Ort,
           :STE_IntUId,
           :STE_AbreNr,

           :ZPK_Code,
           :ZPK_Name,
           :ZPK_Strasse,
           :ZPK_PLZ,
           :ZPK_Ort,
           :ZPK_IntUId,
           :ZPK_AbreNr,
           
           :luk_Zivilstand

  DO
  BEGIN
    
    EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragStd,    :bIsIndustrieMinuten )
     RETURNING_VALUES :emp_VortragStd;
    
    EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :bIsIndustrieMinuten )
     RETURNING_VALUES :emp_VortragFerien;
    
    SUSPEND;
    
  END

END!!
COMMIT!!

-- FS#739:END
-- +++

-- +++
-- FS#758:START - PKLohn - Sonstige Meldungen Form

EXECUTE BLOCK
AS

  -- Fill payroll hours reports

DECLARE VARIABLE   iAfr_UId          DI_UID;
DECLARE VARIABLE   iApg_UId          DI_UID;
DECLARE VARIABLE   iUsr_UId          DI_UID;
DECLARE VARIABLE   iAfa_UId          DI_UID;

BEGIN  

  iApg_UId = NULL;
  
  iUsr_UId = 1;

  -- search Basisdaten group

  SELECT MIN( apg_UId )
    FROM apg_AppObjectGroup
   WHERE apg_Typ  = 'F'          
     AND apg_Name = UPPER( 'Auswertungen' ) 
    INTO :iApg_UId;

  IF ( iApg_UId IS NULL ) THEN EXIT;
  
  -- store form
  EXECUTE PROCEDURE sp_Afr_InsertOrUpdate :iApg_UId, 'Sozialfonds-Meldungen', '', 'TfrmPdfTemplatesPrint', :iUsr_UId
   RETURNING_VALUES :iAfr_UId;   
  
    EXECUTE PROCEDURE sp_Afa_InsertOrUpdate :iAfr_UId, 0, 6, 'Report Drucken', 0, 1  
     RETURNING_VALUES :iAfa_UId;
    
END!!
COMMIT!!

-- +++

EXECUTE BLOCK
AS

  -- Fill payroll hours reports

DECLARE VARIABLE   iAfr_UId          DI_UID;
DECLARE VARIABLE   iApg_UId          DI_UID;
DECLARE VARIABLE   iUsr_UId          DI_UID;
DECLARE VARIABLE   iApr_UId          DI_UID;
DECLARE VARIABLE   iApt_UId          DI_UID;
DECLARE VARIABLE   iAfa_UId          DI_UID;

BEGIN  

  iApg_UId = NULL;
  
  iUsr_UId = 1;

  -- search Basisdaten group

  SELECT MIN( apg_UId )
    FROM apg_AppObjectGroup
   WHERE apg_Typ  = 'F'          
     AND apg_Name = UPPER( 'Auswertungen' ) 
    INTO :iApg_UId;

  IF ( iApg_UId IS NULL ) THEN EXIT;
  
  -- store form
  EXECUTE PROCEDURE sp_Afr_InsertOrUpdate :iApg_UId, 'Sonstige Meldungen', '', 'TfrmRptOtherNotifications', :iUsr_UId
   RETURNING_VALUES :iAfr_UId; 

    EXECUTE PROCEDURE sp_Afa_InsertOrUpdate :iAfr_UId, 0, 6, 'Report Drucken', 0, 1  
     RETURNING_VALUES :iAfa_UId;
     
    EXECUTE PROCEDURE sp_Afa_InsertOrUpdate :iAfr_UId, 0, 7, 'Report Design', 0, 1
     RETURNING_VALUES :iAfa_UId;
  
    EXECUTE PROCEDURE sp_Apr_InsertOrUpdate :iAfr_UId, 2, 'Sonstige Meldungen Report', 'Sonstige Meldungen Report', 1, 1  
     RETURNING_VALUES :iApr_UId;
     
        EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Lohnabrechnung', 'Lohnabrechnung.fr3', '', 1, 1, 1
         RETURNING_VALUES :iApt_UId;
        
        EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Ein- u. Austritte an Amt', 'MeldungAnAmt.fr3', '', 0, 1, 1  
         RETURNING_VALUES :iApt_UId;
        
        EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Mitarbeiterliste', 'Mitarbeiterliste.fr3', '', 0, 1, 1
         RETURNING_VALUES :iApt_UId;
         
        EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Geburtstagsliste', 'Geburtstagsliste.fr3', '', 0, 1, 1
         RETURNING_VALUES :iApt_UId;
        
        EXECUTE PROCEDURE sp_Apt_InsertOrUpdate :iApr_UId, 'Jubilarenliste', 'Jubilarenliste.fr3', '', 0, 1, 1
         RETURNING_VALUES :iApt_UId;
    
END!!
COMMIT!!

-- +++

EXECUTE BLOCK AS

  DECLARE iCount    DI_INT;
  DECLARE iLukUId   DI_UID;
  DECLARE sGroup    DS_CODE;

BEGIN 

  sGroup = 'EMP_SORT';
  
  SELECT COUNT(luk_UId)
    FROM luk_Lookup
   WHERE luk_Gruppe = :sGroup
    INTO :iCount;
    
  IF ( iCount > 0 ) THEN EXIT;
  
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '0', 'Vorname', 1, 1, 1    
   RETURNING_VALUES :iLukUId;
   
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '1', 'Nachname', 0, 1, 1 
   RETURNING_VALUES :iLukUId;
   
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '2', 'Pers.-Nr.', 0, 1, 1    
   RETURNING_VALUES :iLukUId;
  
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '3', 'Wohnort', 0, 1, 1    
   RETURNING_VALUES :iLukUId;
   
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '4', 'Aufenthalt', 0, 1, 1    
   RETURNING_VALUES :iLukUId;
   
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '5', 'Geburtsdatum', 0, 1, 1    
   RETURNING_VALUES :iLukUId;
   
  EXECUTE PROCEDURE sp_Luk_Insert
    :sGroup, '6', 'Land', 0, 1, 1    
   RETURNING_VALUES :iLukUId;
  
END!!
COMMIT!!

-- FS#758:END
-- +++

SET TERM ;!!
