﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.09
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++
-- FS#760 - PKLohn - BusYearAddWizardFRM bug

CREATE OR ALTER PROCEDURE sp_Rpt_HoursPerEmp 
(
  pi_EmpUId   DI_UID,
  pi_MonatVon DI_SMLINT,
  pi_MonatBis DI_SMLINT
)
RETURNS 
(
    emp_UId                 DI_UID,
    emh_Monat               DI_SMLINT,
    emh_Besgrad             DN_NUMBER4,
    emh_Soll_Tage           DN_NUMBER2,
    emh_Soll_AzTag          DN_NUMBER2,
    emh_Soll_AzMonat        DN_NUMBER2,
    emh_Ist_AzMonat         DN_NUMBER2,
    emh_Ist_FerienTage      DN_NUMBER4,
    emh_Ist_FerienTage2     DN_NUMBER4,
    emh_Ist_FerienStd       DN_NUMBER4,
    emh_Ist_AbsenzTage      DN_NUMBER2,
    emh_Ist_AbsenzStd       DN_NUMBER2,
    emh_Ist_KrankTage       DN_NUMBER2,
    emh_Ist_KrankStd        DN_NUMBER2,
    emh_Ist_KorrGz          DN_NUMBER2,
    fer_Vortrag_Tage        DN_NUMBER2,
    fer_Anspruch_Tage       DN_NUMBER2,
    fer_Sonder_Tage         DN_NUMBER2,
    total_Ist_Std           DN_NUMBER2,
    total_Diff_Monat        DN_NUMBER2,
    total_Gz_Saldo          DN_NUMBER2,
    total_Fer_Saldo         DN_NUMBER4,
    total_Fer_Tage          DN_NUMBER4,
    total_Soll_AzTag        DN_NUMBER4,
    buy_IstindustrieMinuten DB_BOOLEAN
)
AS
  DECLARE  iEmhIstferientage2   DN_NUMBER4;
  DECLARE  iEmhIstferienStd     DN_NUMBER4;
  DECLARE  iSollAztagWorkStd    DI_INT;
  DECLARE  iSollAzmonWorkStd    DI_INT;
  DECLARE  iIstAzmonWorkStd     DI_INT;
  DECLARE  iIstFerienWorkStd    DI_INT;
  DECLARE  iIstAbsenzWorkStd    DI_INT;
  DECLARE  iIstKrankWorkStd     DI_INT;
  DECLARE  iIstKorrGzWorkStd    DI_INT;
  DECLARE  iIstTotalWorkStd     DI_INT;
  DECLARE  iTotalGzWorkStd      DI_INT;
  DECLARE  iTotalFerWorkStd     DI_INT;
  DECLARE  iTotalSollAzTag      DN_NUMBER4;
  DECLARE  iTotalDiffMonat      DI_INT;
  DECLARE  bIstOk               DB_BOOLEAN;
  DECLARE  sum_Soll_tage        DN_NUMBER4;
  DECLARE  sum_Soll_aztag       DI_INT;
  DECLARE  sum_Soll_azmonat     DI_INT;
  DECLARE  sum_Ist_azmonat      DI_INT;
  DECLARE  sum_Ist_ferientage   DN_NUMBER4;
  DECLARE  sum_Ist_ferientage2  DN_NUMBER4;
  DECLARE  sum_Ist_ferienstd    DI_INT;
  DECLARE  sum_Ist_absenztage   DN_NUMBER2;
  DECLARE  sum_Ist_absenzstd    DI_INT;
  DECLARE  sum_Ist_kranktage    DN_NUMBER2;
  DECLARE  sum_Ist_krankstd     DI_INT;
  DECLARE  sum_Ist_korrgz       DI_INT;
  DECLARE  sum_Total_ist_std    DI_INT;
  DECLARE  sum_Total_fer_tage   DN_NUMBER4;
BEGIN

   SUM_SOLL_TAGE       = 0;
   SUM_SOLL_AZTAG      = 0;
   SUM_SOLL_AZMONAT    = 0;
   SUM_IST_AZMONAT     = 0;
   SUM_IST_FERIENTAGE  = 0;
   SUM_IST_FERIENTAGE2 = 0;
   SUM_IST_FERIENSTD   = 0;
   SUM_IST_ABSENZTAGE  = 0;
   SUM_IST_ABSENZSTD   = 0;
   SUM_IST_KRANKTAGE   = 0;
   SUM_IST_KRANKSTD    = 0;
   SUM_IST_KORRGZ      = 0;
   SUM_TOTAL_IST_STD   = 0;
   SUM_TOTAL_FER_TAGE  = 0;
   EMH_IST_FERIENTAGE2 = 0;

   bIstOk = 0;

   FOR SELECT EMP_UID,
              EMH_MONAT,
              EMH_BESGRAD,
              COALESCE(EMH_SOLL_TAGE,     0.0),
              COALESCE(EMH_SOLL_AZTAG,      0),
              COALESCE(EMH_SOLL_AZMONAT,  0.0),
              COALESCE(EMH_IST_AZMONAT,     0),
              COALESCE(EMH_IST_FERIENTAGE,0.0),
              COALESCE(EMH_IST_FERIENSTD,   0),
              COALESCE(EMH_IST_ABSENZTAGE,0.0),
              COALESCE(EMH_IST_ABSENZSTD,   0),
              COALESCE(EMH_IST_KRANKTAGE, 0.0),
              COALESCE(EMH_IST_KRANKSTD,    0),
              COALESCE(EMH_IST_KORRGZ,      0),
              FER_VORTRAG_TAGE,
              FER_ANSPRUCH_TAGE,
              FER_SONDER_TAGE,
              COALESCE(TOTAL_IST_STD,     0.0),
              COALESCE(TOTAL_DIFF_MONAT,  0.0),
              TOTAL_GZ_SALDO,
              TOTAL_FER_SALDO,
              TOTAL_FER_TAGE,
              TOTAL_SOLL_AZTAG,
              BUY_ISTINDUSTRIEMINUTEN


       FROM SP_RPT_HOURSPEREMP_HLP ( :PI_EMPUID ) 
          ORDER BY EMH_MONAT

       INTO   :EMP_UID,
              :EMH_MONAT,
              :EMH_BESGRAD,  
              :EMH_SOLL_TAGE,
              :iSollAzTagWorkStd,           
              :iSollAzMonWorkStd,         
              :iIstAzMonWorkStd,          
              :emh_ist_ferientage,
              :iEmhIstFerienStd,
              :EMH_IST_ABSENZTAGE,
              :iIstAbsenzWorkStd,       
              :EMH_IST_KRANKTAGE,
              :iIstKrankWorkStd,      
              :iIstKorrGzWorkStd,     
              :FER_VORTRAG_TAGE,
              :FER_ANSPRUCH_TAGE,
              :FER_SONDER_TAGE,
              :iIstTotalWorkStd,
              :iTotalDiffMonat, 
              :iTotalGzWorkStd,    
              :iTotalFerWorkStd,
              :TOTAL_FER_TAGE,
              :iTotalSollAzTag,
              :BUY_ISTINDUSTRIEMINUTEN 
   
   DO 
   BEGIN       

      IF (PI_MONATVON = 1) THEN
         PI_MONATVON = 0;


      IF ( ( EMH_MONAT >= PI_MONATVON ) AND ( EMH_MONAT <= PI_MONATBIS ) ) THEN 
      BEGIN

         bIstOk = 1;

         IF ( itotalsollaztag != 0 ) THEN
          iemhistferientage2  =  iemhistferienstd / itotalsollaztag;
          
         EMH_IST_FERIENTAGE2 = iemhistferientage2;

         -- Summen bilden ------------------------------------------
         SUM_SOLL_TAGE       = SUM_SOLL_TAGE      + EMH_SOLL_TAGE; 
         SUM_SOLL_AZTAG      = SUM_SOLL_AZTAG     + iSollAzTagWorkStd;
         SUM_SOLL_AZMONAT    = SUM_SOLL_AZMONAT   + iSollAzMonWorkStd;
         SUM_IST_AZMONAT     = SUM_IST_AZMONAT    + iIstAzMonWorkStd;
         SUM_IST_FERIENTAGE  = SUM_IST_FERIENTAGE + EMH_IST_FERIENTAGE;
         SUM_IST_FERIENTAGE2 = SUM_IST_FERIENTAGE2 + iemhistferientage2;
         SUM_IST_FERIENSTD   = SUM_IST_FERIENSTD  + iEmhIstFerienStd;
         SUM_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE + EMH_IST_ABSENZTAGE;
         SUM_IST_ABSENZSTD   = SUM_IST_ABSENZSTD  + iIstAbsenzWorkStd;
         SUM_IST_KRANKTAGE   = SUM_IST_KRANKTAGE  + EMH_IST_KRANKTAGE;
         SUM_IST_KRANKSTD    = SUM_IST_KRANKSTD   + iIstKrankWorkStd;
         SUM_IST_KORRGZ      = SUM_IST_KORRGZ     + iIstKorrGzWorkStd;
         SUM_TOTAL_IST_STD   = SUM_TOTAL_IST_STD  + iIstTotalWorkStd;


         -- Alle Work-Stunden in Anzeigeformat umrechnen -----------

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzTagWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iEmhIstFerienStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAbsenzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKrankWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKorrGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstTotalWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_GZ_SALDO;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalFerWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_FER_SALDO;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalSollAzTag, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_SOLL_AZTAG;
        
         SUSPEND;

      END

      IF ( EMH_MONAT <= PI_MONATBIS ) THEN
      BEGIN

         bIstOk = 1;

         -- Summen bilden ------------------------------------------
         SUM_TOTAL_FER_TAGE  = SUM_TOTAL_FER_TAGE + :iemhistferientage2;

      END


   END



   ----------- Total anhÃƒÂ¤ngen ----------------------------------------------- 
   IF ( bIstOk = 1 ) THEN 
   BEGIN

      EMH_MONAT           = 13;
      EMH_BESGRAD         = NULL;
      EMH_SOLL_TAGE       = SUM_SOLL_TAGE;
      EMH_IST_FERIENTAGE  = SUM_IST_FERIENTAGE;
      EMH_IST_FERIENTAGE2 = SUM_IST_FERIENTAGE2;
      EMH_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE; 
      EMH_IST_KRANKTAGE   = SUM_IST_KRANKTAGE;
      TOTAL_FER_TAGE      = FER_ANSPRUCH_TAGE + FER_VORTRAG_TAGE + FER_SONDER_TAGE - SUM_TOTAL_FER_TAGE;
      TOTAL_DIFF_MONAT    = 0; 
      SUM_SOLL_AZTAG      = SUM_SOLL_AZTAG /12;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZTAG, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;
   
      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_FERIENSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_ABSENZSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KRANKSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KORRGZ, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_TOTAL_IST_STD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

      iTotalDiffMonat = SUM_TOTAL_IST_STD - SUM_SOLL_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;


      SUSPEND;

   END
   
END!!
COMMIT!!

-- FS#760:END
-- +++



SET TERM ;!!
