﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.07
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++

-- FS#740:START - PKLohn - Employee Hours Improvement

CREATE OR ALTER PROCEDURE sp_Emh_StundenFerien 
(
  pi_PraUId DI_UID,
  pi_EmyUId DI_UID
)
RETURNS 
(
    pra_UId               DI_UID,
    prm_UId               DI_UID,
    emy_UId               DI_UID,
    emp_UId               DI_UID,
    iMonat                DI_SMLINT,
    ist_IndustrieMinuten  DB_BOOLEAN,
    min_Avg_AzTag         DI_INT,
    std_Avg_AzTag         DN_NUMBER2,
    tag_Soll_tage         DN_NUMBER2,
    std_Soll_AzTag        DN_NUMBER2,
    min_Soll_AzTag        DI_INT,
    std_Soll_AzMonat      DN_NUMBER2,
    min_Soll_AzMonat      DI_INT,
    std_Ist_AzMonat       DN_NUMBER2,
    min_Ist_AzMonat       DI_INT,
    tag_Ist_Ferien        DN_NUMBER2,
    std_Ist_Ferien        DN_NUMBER2,
    min_Ist_Ferien        DI_INT,
    tag_Ist_Absenz        DN_NUMBER2,
    std_Ist_Absenz        DN_NUMBER2,
    min_Ist_Absenz        DI_INT,
    tag_Ist_Krank         DN_NUMBER2,
    std_Ist_Krank         DN_NUMBER2,
    min_Ist_Krank         DI_INT,
    std_Ist_KorrGz        DN_NUMBER2,
    min_Ist_KorrGz        DI_INT,
    std_Diff_Monat        DN_NUMBER2,
    min_Diff_Monat        DI_INT,
    std_VortragVorMonat   DN_NUMBER2,
    min_VortragVorMonat   DI_INT,
    tag_Fer_Vortrag       DN_NUMBER2,
    tag_Fer_Anspruch      DN_NUMBER2,
    tag_Fer_Soferien      DN_NUMBER2,
    tag_Fer_BezugVorMonat DN_NUMBER2,
    tag_Fer_BezugAktMonat DN_NUMBER2,
    std_Fer_BezugVorMonat DN_NUMBER2
)
AS
-- The procedure is used to show summary information for hours and holiday days.
-- It is used in the form SalaryManage - hours and in the Report Month Salary
  DECLARE  ISTD_VORTRAGVJ DI_INT;
  DECLARE  IVORTRAGFERIEN DI_INT;
  DECLARE  NJAHRES_TAGE DN_NUMBER2;
  DECLARE  IJAHRES_AZ DI_INT;
  DECLARE  IJAHRES_AZ_AVG DN_NUMBER2;
  DECLARE  IMINUTEN DI_INT;
  DECLARE  IMINUTEN1 DI_INT;
  DECLARE  IMINUTEN2 DI_INT;
  DECLARE  NSOLL_TAGE DN_NUMBER2;
  DECLARE  ISOLL_AZTAG DI_INT;
  DECLARE  IIST_AZMONAT DI_INT;
  DECLARE  NIST_FERIENTAGE DN_NUMBER2;
  DECLARE  NIST_ABSENZTAGE DN_NUMBER2;
  DECLARE  NIST_KRANKTAGE DN_NUMBER2;
  DECLARE  IIST_KORRGZ DI_INT;
  DECLARE  ISUM_VORSOLL DI_INT;
  DECLARE  ISUM_VORIST DI_INT;
BEGIN
 

  SELECT emy_UId,           emp_UId,            emp_VortragFerien, 
         emp_SonderFerien,  emp_AnspruchFerien, emp_VortragStd,    buy_IstIndustrieMinuten
    FROM emy_EmploymentPeriod
    JOIN emp_Employee     ON emp_UId = emy_EmpUId
    JOIN buy_BusinessYear ON buy_UId = emp_BuyUId
   WHERE emy_UId = :pi_EmyUId
    INTO :emy_UId,          :emp_UID,           :iVortragFerien, 
         :tag_Fer_Soferien, :tag_Fer_Anspruch,  :iStd_Vortragvj,   :ist_IndustrieMinuten;
         
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :ist_IndustrieMinuten )
   RETURNING_VALUES :tag_Fer_Vortrag;

  
  SELECT prm_UId,   prm_Monat,  pra_UId
    FROM pra_PayrollAccount    
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :prm_UId,  :iMonat,    :pra_UId;

  -- Durschnittelche AbreitsZeit pro Tag rechnen (ueber das ganzes Jahr) 
  -- Average working hours per day expected (over the whole year)
  
  SELECT SUM( emh_Soll_Tage ), TRUNC( SUM( emh_Soll_Tage * emh_Soll_AzTag ) ) 
    FROM emh_EmployeeHours
   WHERE emh_EmpUId = :emp_UId
    INTO :nJahres_Tage, iJahres_Az;
 
  -- Durschschn. JahresAbreitszeit in Minuten /  Average. Annual working time in minutes
  
  iJahres_Az_Avg = IIF( nJahres_Tage = 0, 0, TRUNC(ROUND(TRUNC( iJahres_Az / nJahres_Tage,1 ), 0)) ); 
  min_Avg_AzTag  = iJahres_Az_Avg;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :iJahres_Az_Avg, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Avg_AzTag;


  -- StundenVortrag Vormonate, FerienSaldo Vormonate rechnen  
  -- Expected hours lecture prior month holiday entitlement previous months
  
  iSum_Vorsoll           = 0;   -- Total aller Soll-Minuten der Vormonate / Total of all debit-minutes of the previous months
  iSum_Vorist            = 0;   -- Total aller IST-Minuten der Vormonate  / Total of all IST-minutes of the previous months
  tag_Fer_BezugvorMonat  = 0;   -- Total aller FerienTage der Vormonate   / Total of all the holidays of the previous months
  std_Fer_BezugvorMonat  = 0;   -- Total aller FerienStunden der Vormonate   / Total of all the holiday hours of the previous months

  FOR 
    SELECT emh_Soll_Tage,                     emh_Soll_AzTag, 
           COALESCE( emh_Ist_AzMonat,    0 ), COALESCE( emh_Ist_FerienTage, 0 ),
           COALESCE( emh_Ist_AbsenzTage, 0 ), COALESCE( emh_Ist_KrankTage,  0 ),
           COALESCE( emh_Ist_Korrgz,     0 )
      FROM emh_EmployeeHours
     WHERE emh_EmpUId = :emp_UId 
       AND emh_Monat  < :iMonat 
      INTO :nSoll_Tage,      :iSoll_AzTag,
           :iIst_AzMonat,    :nIst_FerienTage,
           :nIst_AbsenzTage, :nIst_KrankTage, 
           :iIst_Korrgz

  DO 
  BEGIN
  
     -- Summe aller Soll-Minuten der Vormonate (AnzahlTage x SollAZTag)
     -- ???
     iMinuten     = nSoll_Tage * iSoll_AzTag;
     iSum_Vorsoll = iSum_Vorsoll + iMinuten;
 
     -- Summe aller ist-minuten (absenztage x durschnittliche-jahres-az pro tag)
     -- ???
     iMinuten  = nIst_FerienTage * iSoll_AzTag;
     iMinuten1 = nIst_AbsenzTage * iSoll_AzTag;
     iMinuten2 = nIst_KrankTage  * iSoll_AzTag;

     iSum_Vorist  = iSum_Vorist  + iIst_AzMonat + iMinuten + iMinuten1 + iMinuten2 + iIst_Korrgz;

     -- Ferienbezug vormanate in tagen 
     -- ???
     tag_Fer_BezugVormonat = tag_Fer_BezugVormonat + nIst_FerienTage;
     
     -- Ferienbezug vormonate in Stunden
     -- ???
     std_Fer_BezugVormonat = std_Fer_BezugVormonat + (nIst_FerienTage * iSoll_AzTag); 

  END
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :std_Fer_BezugVormonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Fer_BezugVormonat;

  -- Gleitsaldo der Vormonate in Stunden
  -- ???saldo from previous monthes (minutes)
  min_VortragVormonat = iSum_Vorist + iStd_VortragVj - iSum_Vorsoll;

  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_VortragVormonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_VortragVormonat;


  -- Ist-Stunden, Soll-Stunden, Ferbeinezug aktueller Monat
  SELECT emh_Soll_Tage,                     emh_Soll_AzTag,
         emh_Soll_AzMonat,
         COALESCE( emh_Ist_AzMonat,    0 ), COALESCE( emh_Ist_FerienTage, 0 ),
         COALESCE( emh_Ist_AbsenzTage, 0 ), COALESCE( emh_Ist_KrankTage,  0 ),
         COALESCE( emh_Ist_Korrgz,     0 )
    FROM emh_EmployeeHours
   WHERE emh_EmpUId = :emp_UId 
     AND emh_Monat  = :iMonat 
    INTO :nSoll_Tage,      :iSoll_AzTag,
         :min_Soll_AzMonat,
         :iIst_AzMonat,    :nIst_FerienTage,
         :nIst_AbsenzTage, :nIst_KrankTage, 
         :iIst_Korrgz;

  tag_Soll_Tage         = nSoll_Tage;
  tag_Ist_Ferien        = nIst_FerienTage;
  tag_Ist_Absenz        = nIst_AbsenzTage;
  tag_Ist_Krank         = nIst_KrankTage;  

  min_Soll_Aztag   =  iSoll_AzTag;                        -- Soll-AZ pro Tag im Min
  min_Ist_AzMonat  =  iIst_AzMonat;                       -- Ist-AZ in Min  
  
  min_Ist_Ferien   =  nIst_FerienTage * min_Soll_Aztag;   -- Ferienbezug in Min 
  min_Ist_Absenz   =  nIst_AbsenzTage * min_Soll_Aztag;   -- Absenzen in Min
  min_Ist_Krank    =  nIst_KrankTage  * min_Soll_Aztag;   -- Krank in Minuten
  min_Ist_Korrgz   =  iIst_Korrgz;                        -- Korr. Gleitzeit in Minuten
  
  tag_Fer_BezugAktMonat = min_Ist_Ferien;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Soll_Aztag,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Soll_AzTag;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Soll_AzMonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Soll_AzMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_AzMonat,  :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_AzMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Ferien,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Ferien;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :tag_Fer_BezugAktMonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :tag_Fer_BezugAktMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Absenz,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Absenz;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Krank,    :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Krank;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Korrgz,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_KorrGz;
   
  -- Differenz diesen Monat (= Ist-Soll) / Difference this month (= ???)
  min_Diff_Monat = 
    ( min_Ist_AzMonat + min_Ist_Ferien + min_Ist_Absenz + min_Ist_Krank + min_Ist_Korrgz )
    - min_Soll_AzMonat;

  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Diff_Monat,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Diff_Monat;

  SUSPEND;

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_HoursPerEmp_Hlp 
(
  pi_EmpUId DI_UID
)
RETURNS 
(
    emp_UId                 DI_UID,
    emh_Monat               DI_SMLINT,
    emh_Besgrad             DN_NUMBER4,
    emh_Soll_Tage           DN_NUMBER2,
    emh_Soll_AzTag          DI_INT,
    emh_Soll_AzMonat        DI_INT,
    emh_Ist_AzMonat         DI_INT,
    emh_Ist_FerienTage      DN_NUMBER2,
    emh_Ist_FerienStd       DI_INT,
    emh_Ist_AbsenzTage      DN_NUMBER2,
    emh_Ist_AbsenzStd       DI_INT,
    emh_Ist_KrankTage       DN_NUMBER2,
    emh_Ist_KrankStd        DI_INT,
    emh_Ist_KorrGz          DI_INT,
    fer_Vortrag_Tage        DN_NUMBER2,
    fer_Vortrag_Std         DI_INT,
    fer_Anspruch_Tage       DN_NUMBER2,
    fer_Sonder_Tage         DN_NUMBER2,
    total_Ist_Std           DI_INT,
    total_Diff_Monat        DI_INT,
    total_Gz_Saldo          DI_INT,
    total_Fer_Saldo         DI_INT,
    total_Fer_Tage          DN_NUMBER2,
    total_Soll_AzTag        DI_INT,
    buy_IstindustrieMinuten DB_BOOLEAN
)
AS
  DECLARE  bIsindustrialHours DB_BOOLEAN;
  DECLARE  nYearDays          DN_NUMBER2;
  DECLARE  iYearAz            DI_INT;
  DECLARE  iYearazAvg         DI_INT;
  DECLARE  iVortragStd        DI_INT;
  DECLARE  iFerienVortragStd  DI_INT;
  DECLARE  iGzSaldoWorkStd    DI_INT;
  DECLARE  iMonthAzAvg        DI_INT;
  DECLARE  iWorkStd           DI_INT;
  DECLARE  iFerSaldoWorkStd   DI_INT;
  
BEGIN

   -- Durchschn. Arbeitszeit pro Tag uber das Ganze Jahr -------

   SELECT SUM( EMH_SOLL_TAGE ), SUM( EMH_SOLL_AZMONAT ) 
     FROM EMH_EMPLOYEEHOURS
    WHERE EMH_EMPUID = :PI_EMPUID
     INTO :nYearDays,           :iYearAz; 

   IF (nYearDays IS NULL) THEN nYearDays = 0; 
   IF (iYearAz IS NULL)   THEN iYearAz   = 0; 

   iYearAzAVG = 0;

   if (nYearDays <> 0) then
      iYearAzAVG = ROUND(iYearAz / nYearDays , 0);   -- Durchsch. AZ pro Tag ganzes Jahr
      TOTAL_SOLL_AZTAG = iYearAzAVG;

   -- Vertraege und Anspruch werden in Monat 0 zurueckgegeben  ----------------------

   SELECT EMP_UID,
          COALESCE(EMP_VORTRAGSTD    , 0),
          COALESCE(EMP_VORTRAGFERIEN , 0),
          COALESCE(EMP_SONDERFERIEN  , 0),
          COALESCE(EMP_ANSPRUCHFERIEN, 0.0)
    FROM EMP_EMPLOYEE
   WHERE EMP_UID = :PI_EMPUID
    INTO  :EMP_UID,
          :iVortragStd,
          :iFerienVortragStd,  
          :FER_SONDER_TAGE,
          :FER_ANSPRUCH_TAGE; 


   -- Einstellung IndurieMinuten oder 100er Zeit ----------

   EXECUTE PROCEDURE sp_Buy_GetWorkHourModeByEmp :EMP_UID
        RETURNING_VALUES :bIsIndustrialHours;

   BUY_ISTINDUSTRIEMINUTEN = bIsIndustrialHours;

   -- Ferien Vortrag und Anspruch des Mitarbeiters ---

   fer_Vortrag_Std  = iFerienVortragStd;

   fer_Vortrag_Tage = 0;
   IF ( iYearAzAVG <> 0.0 ) THEN
      fer_Vortrag_Tage = Round( ( iFerienVortragStd * 1.00 ) / ( iYearAzAVG * 1.00 ), 2 );


   --------------------------- Vortrag Vorjahr zurueckgeben -------------------------------
   EMH_MONAT           = 0;
   EMH_BESGRAD         = 0;
   EMH_SOLL_TAGE       = NULL;
   EMH_SOLL_AZTAG      = NULL;
   EMH_SOLL_AZMONAT    = NULL;
   EMH_IST_FERIENTAGE  = NULL;
   EMH_IST_FERIENSTD   = NULL;
   EMH_IST_ABSENZTAGE  = NULL;
   EMH_IST_ABSENZSTD   = NULL;
   EMH_IST_KRANKTAGE   = NULL;
   EMH_IST_KRANKSTD    = NULL;
   EMH_IST_KORRGZ      = NULL;
   TOTAL_DIFF_MONAT    = 0; 

   -- Gelitzeitsaldo in WorkMinutes

   iGzSaldoWorkStd = :iVortragStd;

   -- Total IST Zeit ---

   EMH_IST_AZMONAT   = iVortragStd;
   TOTAL_IST_STD     = EMH_IST_AZMONAT;
   TOTAL_GZ_SALDO    = EMH_IST_AZMONAT;
   TOTAL_DIFF_MONAT  = TOTAL_IST_STD; 


   -- Ferien-Saldo und Tage --------------------

   TOTAL_FER_SALDO = iFerienVortragStd                     +
                     Trunc(FER_SONDER_TAGE   * iYearAzAVG) +
                     Trunc(FER_ANSPRUCH_TAGE * iYearAzAVG);

   iFerSaldoWorkStd = TOTAL_FER_SALDO;

   TOTAL_FER_TAGE  = 0;
   IF (iYearAzAVG <> 0) THEN
       TOTAL_FER_TAGE = Round( (TOTAL_FER_SALDO * 1.00) / (iYearAzAVG * 1.00), 2 );

  
   SUSPEND;

   -- Alle Monate von EMH_EMPLOYEEHOURS_ zurueckgeben   -----------------
   FOR SELECT EMH_EMPUID,
              EMH_BESGRAD,
              EMH_MONAT, 
              COALESCE(EMH_SOLL_TAGE,      0.0),
              COALESCE(EMH_SOLL_AZTAG,       0),
              COALESCE(EMH_SOLL_AZMONAT,     0),
              COALESCE(EMH_IST_AZMONAT,      0),
              COALESCE(EMH_IST_FERIENTAGE, 0.0),
              COALESCE(EMH_IST_ABSENZTAGE, 0.0),
              COALESCE(EMH_IST_KRANKTAGE,  0.0),
              COALESCE(EMH_IST_KORRGZ,       0)

       FROM EMH_EMPLOYEEHOURS
       WHERE EMH_EMPUID = :PI_EMPUID     
       ORDER BY emh_Monat
        INTO  :EMP_UID,
              :EMH_BESGRAD, 
              :EMH_MONAT,
              :EMH_SOLL_TAGE,
              :EMH_SOLL_AZTAG,
              :EMH_SOLL_AZMONAT,
              :EMH_IST_AZMONAT,   
              :EMH_IST_FERIENTAGE,
              :EMH_IST_ABSENZTAGE,
              :EMH_IST_KRANKTAGE,
              :EMH_IST_KORRGZ

   DO BEGIN

      -- SOll-Arbeitszeit pro Tag in WorkMinutes errechnen

      iMonthAzAVG = 0;

      IF ( EMH_SOLL_TAGE <> 0 ) then begin

         iMonthAzAVG = Trunc(EMH_SOLL_AZMONAT / EMH_SOLL_TAGE );

      END

      -- IST-Arbeitszeit pro Monat umrechnen --*

      iGzSaldoWorkStd = iGzSaldoWorkStd + EMH_IST_AZMONAT;


      -- IST Ferienbezug pro Monat umrechnen --*

      iWorkStd = Trunc( EMH_IST_FERIENTAGE * iMonthAzAVG );  

      iGzSaldoWorkStd   = iGzSaldoWorkStd  + iWorkStd;
      iFerSaldoWorkStd  = iFerSaldoWorkStd - iWorkStd;

      EMH_IST_FERIENSTD = iWorkStd;


      -- IST Absenzen pro Monat umrechnen --*

      iWorkStd = Trunc( EMH_IST_ABSENZTAGE * iMonthAzAVG );  

      iGzSaldoWorkStd   = iGzSaldoWorkStd + iWorkStd;
      EMH_IST_ABSENZSTD = iWorkStd;


      -- IST Krankheit pro Monat umrechnen --*

      iWorkStd = Trunc( EMH_IST_KRANKTAGE * iMonthAzAVG );  

      iGzSaldoWorkStd   = iGzSaldoWorkStd + iWorkStd;
      EMH_IST_KRANKSTD  = iWorkStd;


      -- Korrektur Gleitzeit 
 
      iGzSaldoWorkStd = iGzSaldoWorkStd + EMH_IST_KORRGZ; 



      -- Sollzeit pro Maonat vom Saldo abziehen

      iGzSaldoWorkStd = iGzSaldoWorkStd - EMH_SOLL_AZMONAT;


      -- Total IST-Stunden des Monats errechnen  

      TOTAL_IST_STD = EMH_IST_AZMONAT + EMH_IST_FERIENSTD  + 
                      EMH_IST_ABSENZSTD + EMH_IST_KRANKSTD + EMH_IST_KORRGZ;


      -- Gleitzeitsaldo umrechnen
      TOTAL_DIFF_MONAT  = TOTAL_IST_STD - EMH_SOLL_AZMONAT; 

      TOTAL_GZ_SALDO    =  iGzSaldoWorkStd;


      -- FerienSaldo umrechnen

      TOTAL_FER_SALDO = iFerSaldoWorkStd;

      -- FerienSaldo in Tage umrechnen

      TOTAL_FER_TAGE = 0;
      if (iYearAzAVG <> 0) THEN
         TOTAL_FER_TAGE = Round( (TOTAL_FER_SALDO*1.00) / (iYearAzAVG*1.00), 2 );

 
      SUSPEND;

   END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_HoursPerEmp 
(
  pi_EmpUId   DI_UID,
  pi_MonatVon DI_SMLINT,
  pi_MonatBis DI_SMLINT
)
RETURNS 
(
    emp_UId                 DI_UID,
    emh_Monat               DI_SMLINT,
    emh_Besgrad             DN_NUMBER4,
    emh_Soll_Tage           DN_NUMBER2,
    emh_Soll_AzTag          DN_NUMBER2,
    emh_Soll_AzMonat        DN_NUMBER2,
    emh_Ist_AzMonat         DN_NUMBER2,
    emh_Ist_FerienTage      DN_NUMBER4,
    emh_Ist_FerienTage2     DN_NUMBER4,
    emh_Ist_FerienStd       DN_NUMBER4,
    emh_Ist_AbsenzTage      DN_NUMBER2,
    emh_Ist_AbsenzStd       DN_NUMBER2,
    emh_Ist_KrankTage       DN_NUMBER2,
    emh_Ist_KrankStd        DN_NUMBER2,
    emh_Ist_KorrGz          DN_NUMBER2,
    fer_Vortrag_Tage        DN_NUMBER2,
    fer_Anspruch_Tage       DN_NUMBER2,
    fer_Sonder_Tage         DN_NUMBER2,
    total_Ist_Std           DN_NUMBER2,
    total_Diff_Monat        DN_NUMBER2,
    total_Gz_Saldo          DN_NUMBER2,
    total_Fer_Saldo         DN_NUMBER4,
    total_Fer_Tage          DN_NUMBER4,
    total_Soll_AzTag        DN_NUMBER4,
    buy_IstindustrieMinuten DB_BOOLEAN
)
AS
  DECLARE  iEmhIstferientage2   DN_NUMBER4;
  DECLARE  iEmhIstferienStd     DN_NUMBER4;
  DECLARE  iSollAztagWorkStd    DI_INT;
  DECLARE  iSollAzmonWorkStd    DI_INT;
  DECLARE  iIstAzmonWorkStd     DI_INT;
  DECLARE  iIstFerienWorkStd    DI_INT;
  DECLARE  iIstAbsenzWorkStd    DI_INT;
  DECLARE  iIstKrankWorkStd     DI_INT;
  DECLARE  iIstKorrGzWorkStd    DI_INT;
  DECLARE  iIstTotalWorkStd     DI_INT;
  DECLARE  iTotalGzWorkStd      DI_INT;
  DECLARE  iTotalFerWorkStd     DI_INT;
  DECLARE  iTotalSollAzTag      DN_NUMBER4;
  DECLARE  iTotalDiffMonat      DI_INT;
  DECLARE  bIstOk               DB_BOOLEAN;
  DECLARE  sum_Soll_tage        DN_NUMBER4;
  DECLARE  sum_Soll_aztag       DI_INT;
  DECLARE  sum_Soll_azmonat     DI_INT;
  DECLARE  sum_Ist_azmonat      DI_INT;
  DECLARE  sum_Ist_ferientage   DN_NUMBER4;
  DECLARE  sum_Ist_ferientage2  DN_NUMBER4;
  DECLARE  sum_Ist_ferienstd    DI_INT;
  DECLARE  sum_Ist_absenztage   DN_NUMBER2;
  DECLARE  sum_Ist_absenzstd    DI_INT;
  DECLARE  sum_Ist_kranktage    DN_NUMBER2;
  DECLARE  sum_Ist_krankstd     DI_INT;
  DECLARE  sum_Ist_korrgz       DI_INT;
  DECLARE  sum_Total_ist_std    DI_INT;
  DECLARE  sum_Total_fer_tage   DN_NUMBER4;
BEGIN

   SUM_SOLL_TAGE       = 0;
   SUM_SOLL_AZTAG      = 0;
   SUM_SOLL_AZMONAT    = 0;
   SUM_IST_AZMONAT     = 0;
   SUM_IST_FERIENTAGE  = 0;
   SUM_IST_FERIENTAGE2 = 0;
   SUM_IST_FERIENSTD   = 0;
   SUM_IST_ABSENZTAGE  = 0;
   SUM_IST_ABSENZSTD   = 0;
   SUM_IST_KRANKTAGE   = 0;
   SUM_IST_KRANKSTD    = 0;
   SUM_IST_KORRGZ      = 0;
   SUM_TOTAL_IST_STD   = 0;
   SUM_TOTAL_FER_TAGE  = 0;
   EMH_IST_FERIENTAGE2 = 0;

   bIstOk = 0;

   FOR SELECT EMP_UID,
              EMH_MONAT,
              EMH_BESGRAD,
              COALESCE(EMH_SOLL_TAGE,     0.0),
              COALESCE(EMH_SOLL_AZTAG,      0),
              COALESCE(EMH_SOLL_AZMONAT,  0.0),
              COALESCE(EMH_IST_AZMONAT,     0),
              COALESCE(EMH_IST_FERIENTAGE,0.0),
              COALESCE(EMH_IST_FERIENSTD,   0),
              COALESCE(EMH_IST_ABSENZTAGE,0.0),
              COALESCE(EMH_IST_ABSENZSTD,   0),
              COALESCE(EMH_IST_KRANKTAGE, 0.0),
              COALESCE(EMH_IST_KRANKSTD,    0),
              COALESCE(EMH_IST_KORRGZ,      0),
              FER_VORTRAG_TAGE,
              FER_ANSPRUCH_TAGE,
              FER_SONDER_TAGE,
              COALESCE(TOTAL_IST_STD,     0.0),
              COALESCE(TOTAL_DIFF_MONAT,  0.0),
              TOTAL_GZ_SALDO,
              TOTAL_FER_SALDO,
              TOTAL_FER_TAGE,
              TOTAL_SOLL_AZTAG,
              BUY_ISTINDUSTRIEMINUTEN


       FROM SP_RPT_HOURSPEREMP_HLP ( :PI_EMPUID ) 
          ORDER BY EMH_MONAT

       INTO   :EMP_UID,
              :EMH_MONAT,
              :EMH_BESGRAD,  
              :EMH_SOLL_TAGE,
              :iSollAzTagWorkStd,           
              :iSollAzMonWorkStd,         
              :iIstAzMonWorkStd,          
              :emh_ist_ferientage,
              :iEmhIstFerienStd,
              :EMH_IST_ABSENZTAGE,
              :iIstAbsenzWorkStd,       
              :EMH_IST_KRANKTAGE,
              :iIstKrankWorkStd,      
              :iIstKorrGzWorkStd,     
              :FER_VORTRAG_TAGE,
              :FER_ANSPRUCH_TAGE,
              :FER_SONDER_TAGE,
              :iIstTotalWorkStd,
              :iTotalDiffMonat, 
              :iTotalGzWorkStd,    
              :iTotalFerWorkStd,
              :TOTAL_FER_TAGE,
              :iTotalSollAzTag,
              :BUY_ISTINDUSTRIEMINUTEN 
   
   DO 
   BEGIN       

      IF (PI_MONATVON = 1) THEN
         PI_MONATVON = 0;


      IF ( ( EMH_MONAT >= PI_MONATVON ) AND ( EMH_MONAT <= PI_MONATBIS ) ) THEN 
      BEGIN

         bIstOk = 1;

         iemhistferientage2  =  iemhistferienstd / itotalsollaztag;
         EMH_IST_FERIENTAGE2 = iemhistferientage2;

         -- Summen bilden ------------------------------------------
         SUM_SOLL_TAGE       = SUM_SOLL_TAGE      + EMH_SOLL_TAGE; 
         SUM_SOLL_AZTAG      = SUM_SOLL_AZTAG     + iSollAzTagWorkStd;
         SUM_SOLL_AZMONAT    = SUM_SOLL_AZMONAT   + iSollAzMonWorkStd;
         SUM_IST_AZMONAT     = SUM_IST_AZMONAT    + iIstAzMonWorkStd;
         SUM_IST_FERIENTAGE  = SUM_IST_FERIENTAGE + EMH_IST_FERIENTAGE;
         SUM_IST_FERIENTAGE2 = SUM_IST_FERIENTAGE2 + iemhistferientage2;
         SUM_IST_FERIENSTD   = SUM_IST_FERIENSTD  + iEmhIstFerienStd;
         SUM_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE + EMH_IST_ABSENZTAGE;
         SUM_IST_ABSENZSTD   = SUM_IST_ABSENZSTD  + iIstAbsenzWorkStd;
         SUM_IST_KRANKTAGE   = SUM_IST_KRANKTAGE  + EMH_IST_KRANKTAGE;
         SUM_IST_KRANKSTD    = SUM_IST_KRANKSTD   + iIstKrankWorkStd;
         SUM_IST_KORRGZ      = SUM_IST_KORRGZ     + iIstKorrGzWorkStd;
         SUM_TOTAL_IST_STD   = SUM_TOTAL_IST_STD  + iIstTotalWorkStd;


         -- Alle Work-Stunden in Anzeigeformat umrechnen -----------

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzTagWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iEmhIstFerienStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAbsenzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKrankWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKorrGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstTotalWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_GZ_SALDO;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalFerWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_FER_SALDO;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalSollAzTag, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_SOLL_AZTAG;
        
         SUSPEND;

      END

      IF ( EMH_MONAT <= PI_MONATBIS ) THEN
      BEGIN

         bIstOk = 1;

         -- Summen bilden ------------------------------------------
         SUM_TOTAL_FER_TAGE  = SUM_TOTAL_FER_TAGE + :iemhistferientage2;

      END


   END



   ----------- Total anhÃƒÂ¤ngen ----------------------------------------------- 
   IF ( bIstOk = 1 ) THEN 
   BEGIN

      EMH_MONAT           = 13;
      EMH_BESGRAD         = NULL;
      EMH_SOLL_TAGE       = SUM_SOLL_TAGE;
      EMH_IST_FERIENTAGE  = SUM_IST_FERIENTAGE;
      EMH_IST_FERIENTAGE2 = SUM_IST_FERIENTAGE2;
      EMH_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE; 
      EMH_IST_KRANKTAGE   = SUM_IST_KRANKTAGE;
      TOTAL_FER_TAGE      = FER_ANSPRUCH_TAGE + FER_VORTRAG_TAGE + FER_SONDER_TAGE - SUM_TOTAL_FER_TAGE;
      TOTAL_DIFF_MONAT    = 0; 
      SUM_SOLL_AZTAG      = SUM_SOLL_AZTAG /12;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZTAG, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;
   
      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_FERIENSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_ABSENZSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KRANKSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KORRGZ, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_TOTAL_IST_STD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

      iTotalDiffMonat = SUM_TOTAL_IST_STD - SUM_SOLL_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;


      SUSPEND;

   END
   
END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_Hours_Employees 
(
  pi_BuyUId     DI_UID,
  pi_MonatVon   DI_SMLINT,
  pi_MonatBis   DI_SMLINT,
  pi_EmpUId     DI_UID = null,
  pi_LandUId    DI_UID = null,
  pi_DepUId     DI_UID = null,
  pi_CatUId     DI_UID = null,
  pi_PrgUId     DI_UID = null
)
RETURNS 
(
    buy_GeschJahr             DI_BUSINESSYEAR,
    buy_IstindustrieMinuten   DB_BOOLEAN,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Strasse               DS_STR50,
    fir_HausNr                DS_STR5,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    emp_Uid                   DI_UID,
    emp_PersNr                DI_INT,
    emp_PeidNr                DS_STR20,
    emp_Name                  DS_STR50,
    emp_Vorname               DS_STR50,
    emp_Strasse               DS_STR50,
    emp_HausNr                DS_STR5,
    coi_IsoCode               DS_CODE,
    emp_Plz                   DS_PLZ,
    emp_Ort                   DS_STR50,
    emp_GeburtsDatum          DD_DATE,
    emh_Monat                 DI_SMLINT,
    emh_Besgrad               DN_NUMBER4,
    emh_Soll_Tage             DN_NUMBER2,
    emh_Soll_AzTag            DN_NUMBER2,
    emh_Soll_AzMonat          DN_NUMBER2,
    emh_Ist_AzMonat           DN_NUMBER2,
    emh_Ist_FerienTage        DN_NUMBER2,
    emh_Ist_FerienStd         DN_NUMBER2,
    emh_Ist_AbsenzTage        DN_NUMBER2,
    emh_Ist_AbsenzStd         DN_NUMBER2,
    emh_Ist_KrankTage         DN_NUMBER2,
    emh_Ist_KrankStd          DN_NUMBER2,
    emh_Ist_KorrGz            DN_NUMBER2,
    fer_Vortrag_Tage          DN_NUMBER2,
    fer_Anspruch_Tage         DN_NUMBER2,
    fer_Sonder_Tage           DN_NUMBER2,
    total_Ist_Std             DN_NUMBER2,
    total_Diff_Monat          DN_NUMBER2,
    total_Gz_Saldo            DN_NUMBER2,
    total_Fer_Saldo           DN_NUMBER2,
    total_Fer_Tage            DN_NUMBER2,
    total_Soll_AzTag          DN_NUMBER2
)
AS
  DECLARE  sStmt    VARCHAR(512);
  DECLARE  iCoiUId  DI_INT;
  
BEGIN
   
    -- Get Firm - Fields 
    SELECT Y.BUY_GESCHJAHR,
           F.FIR_CODE, 
           F.FIR_BEZEICHNUNG, 
           F.FIR_BEZEICHNUNG2,
           F.FIR_STRASSE,
           F.fir_HausNr,
           F.FIR_PLZ,
           F.FIR_ORT 
  
   FROM BUY_BUSINESSYEAR Y

       LEFT JOIN FIR_FIRM F ON F.FIR_UID=Y.BUY_FIRUID

       WHERE BUY_UID = :PI_BUYUID

   INTO    :BUY_GESCHJAHR,
           :FIR_CODE,
           :FIR_BEZEICHNUNG,
           :FIR_BEZEICHNUNG2,
           :FIR_STRASSE,
           :fir_HausNr,
           :FIR_PLZ,
           :FIR_ORT; 



  sStmt = 'SELECT EMP_UID, EMP_PERSNR, EMP_PEIDNR, EMP_NAME, EMP_VORNAME,      '||
          '       EMP_STRASSE, emp_HausNr, EMP_LANDUID, EMP_PLZ, EMP_ORT, EMP_GEBURTSDATUM '|| 
          ' FROM EMP_EMPLOYEE                                                  '||
          ' WHERE (EMP_BUYUID = :piBUYUID) ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  FOR EXECUTE STATEMENT (sStmt) ( piBUYUID := :PI_BUYUID )
      INTO :EMP_UID,     :EMP_PERSNR,  :EMP_PEIDNR, :EMP_NAME, :EMP_VORNAME,
           :EMP_STRASSE, :emp_HausNr, :iCoiUid, :EMP_PLZ,    :EMP_ORT, :EMP_GEBURTSDATUM
 
  DO BEGIN

     SELECT COI_ISOCODE FROM COI_COUNTRYISO
       WHERE COI_UID = :iCoiUid 
     INTO :COI_ISOCODE;
    


     FOR SELECT EMH_MONAT,
                EMH_BESGRAD,
                EMH_SOLL_TAGE,
                EMH_SOLL_AZTAG,
                EMH_SOLL_AZMONAT,
                EMH_IST_AZMONAT,
                EMH_IST_FERIENTAGE,
                EMH_IST_FERIENSTD,
                EMH_IST_ABSENZTAGE,
                EMH_IST_ABSENZSTD,
                EMH_IST_KRANKTAGE,
                EMH_IST_KRANKSTD,
                EMH_IST_KORRGZ,
                FER_VORTRAG_TAGE,
                FER_ANSPRUCH_TAGE,
                FER_SONDER_TAGE,
                TOTAL_IST_STD,
                TOTAL_DIFF_MONAT, 
                TOTAL_GZ_SALDO,
                TOTAL_FER_SALDO,
                TOTAL_FER_TAGE,
                TOTAL_SOLL_AZTAG,
                BUY_ISTINDUSTRIEMINUTEN

         FROM SP_RPT_HOURSPEREMP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS )
         ORDER BY EMH_MONAT  
         
         INTO   :EMH_MONAT,
                :EMH_BESGRAD,
                :EMH_SOLL_TAGE,
                :EMH_SOLL_AZTAG,
                :EMH_SOLL_AZMONAT,
                :EMH_IST_AZMONAT,
                :EMH_IST_FERIENTAGE,
                :EMH_IST_FERIENSTD,
                :EMH_IST_ABSENZTAGE,
                :EMH_IST_ABSENZSTD,
                :EMH_IST_KRANKTAGE,
                :EMH_IST_KRANKSTD,
                :EMH_IST_KORRGZ,
                :FER_VORTRAG_TAGE,
                :FER_ANSPRUCH_TAGE,
                :FER_SONDER_TAGE,
                :TOTAL_IST_STD,
                :TOTAL_DIFF_MONAT, 
                :TOTAL_GZ_SALDO,
                :TOTAL_FER_SALDO,
                :TOTAL_FER_TAGE,
                :TOTAL_SOLL_AZTAG,
                :BUY_ISTINDUSTRIEMINUTEN

     DO 
      SUSPEND;     

  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_SalaryAccount_Emp 
(
  pi_PraUId DI_UID,
  pi_EmyUId DI_UID
)
RETURNS 
(
    SAY_UID DI_UID,
    GRUPPE DS_ONECHARFLAG,
    SDTSORT DI_UID,
    LA_SORT DS_STR30,
    EMY_UID DI_UID,
    SAD_UID DI_UID,
    STD_UID DI_UID,
    SDT_TYP DS_ONECHARFLAG,
    SDT_LART DS_STR5,
    SDT_ISTNULLAUSGABE DB_BOOLEAN,
    SDT_ISTLOHNTEIL DB_BOOLEAN,
    SDT_BERECHBASISNR DI_SMLINT,
    SDT_MASSEINHEIT DS_STR10,
    SCT_CALCTYPE DI_SMLINT,
    SAD_TEXT DS_DESCR,
    SAD_MENGE DN_NUMBER2,
    SAD_ANSATZAG DN_NUMBER4,
    SAD_ANSATZAN DN_NUMBER4,
    SAD_BASIS DN_NUMBER2,
    SAD_FAKTOR DN_NUMBER4,
    SAD_TOTAL DN_NUMBER2,
    EMB_UID DI_UID,
    EMB_VERGTYP DS_ONECHARFLAG,
    EMB_IBANNR DS_STR35,
    EMB_KONTONR DS_STR35,
    EMB_BETRAG DN_NUMBER2,
    BAN_NAME DS_STR50,
    BAN_PLZ DS_PLZ,
    BAN_ORT DS_STR50,
    EMP_VORTRAGFERIEN DN_NUMBER2,
    EMP_SONDERFERIEN DN_NUMBER2,
    EMP_ANSPRUCHFERIEN DN_NUMBER2,
    FERIENBEZUG_VORMONAT DN_NUMBER2,
    FERIENBEZUG_MONAT DN_NUMBER2,
    STD_VORJAHR DN_NUMBER2,
    STD_SOLL_AZMONAT DN_NUMBER2,
    STD_IST_AZMONAT DN_NUMBER2,
    STD_IST_KRANK DN_NUMBER2,
    STD_IST_ABSENZ DN_NUMBER2,
    STD_IST_FERIEN DN_NUMBER2,
    STD_IST_KORRGZ DN_NUMBER2,
    STD_VORTRAG_VORMONAT DN_NUMBER2,
    STD_DIFF_MONAT DN_NUMBER2,
    STD_GZ_MONAT DN_NUMBER2,
    TXT_TEXT DS_STR1024
)
AS

  DECLARE  NAZBETRAG DN_NUMBER2;
  DECLARE  IEMPUID DI_UID;
  DECLARE  IMONAT DI_UID;
  DECLARE  IEHMONAT DI_UID;
  DECLARE  NSOLL_TAGE DN_NUMBER2;
  DECLARE  NSOLL_AZTAG DN_NUMBER2;
  DECLARE  NIST_AZMONAT DN_NUMBER2;
  DECLARE  NIST_FERIENTAGE DN_NUMBER2;
  DECLARE  NIST_ABSENZTAGE DN_NUMBER2;
  DECLARE  NIST_KRANKTAGE DN_NUMBER2;
  DECLARE  SSAY_LA_TEXT DS_STR1024;
  DECLARE  SPRM_LA_TEXT DS_STR1024;
  DECLARE  B_LA_ISTSTUNDEN DB_BOOLEAN;
  DECLARE  B_LA_ISTFERIEN DB_BOOLEAN;
  DECLARE  B_LA_ISTZAHLSTELLE DB_BOOLEAN;
  DECLARE  V_SOLL DN_NUMBER2;
  DECLARE  V_IST DN_NUMBER2;
  DECLARE  SABRETYP DS_ONECHARFLAG;
  DECLARE  BISINDUSTRIEMINUTEN DB_BOOLEAN;
  DECLARE  SFIRLASORTTYP DS_ONECHARFLAG;
  DECLARE  IEMPPERSNR DI_INT;
  DECLARE  SEMPNAME DS_STR50;
  DECLARE  SEMPVORNAME DS_STR50;
  DECLARE  SDEPCODE DS_STR12;
  DECLARE  SCATCODE DS_STR12;
  DECLARE  IEMPVORTRAGVERIEN DI_INT;
  DECLARE  BISINDUSTRIALHOURS DB_BOOLEAN;
  
BEGIN

   -- PayrollAccount-Data from one Employee 

  -- 1. Get Data from Employee and generate Sort field

  SELECT p.emy_EmpUId,       e.emp_La_IstStunden, 
         e.emp_La_IstFerien, e.emp_La_IstZahlstelle,
         e.emp_PersNr,       e.emp_Name, e.emp_Vorname,
         d.dep_Code,         c.cat_Code,
         f.fir_la_sorttyp  

    FROM emy_EmploymentPeriod p

    LEFT JOIN emp_Employee          e ON e.emp_UId = p.emy_EmpUId 
    LEFT JOIN buy_BusinessYear      y ON y.buy_UId = e.emp_BuyUId
    LEFT JOIN fir_firm              f on f.fir_uid = y.buy_firUId
    LEFT OUTER JOIN dep_department  d ON d.dep_UId = e.emp_depUId
    LEFT OUTER JOIN cat_category    c ON c.cat_UId = e.emp_catUId

   WHERE p.emy_UId = :pi_EmyUId

    INTO :iEmpUId, :b_La_IstStunden, 
         :b_La_IstFerien, :b_La_IstZahlStelle,
         :iEmpPersNr, :sEmpName, :sEmpVorname, :sDepCode, 
         :sCatCode,:sFirLASortTyp;


  -- Geneate SortField for salay Report Order
  LA_SORT  = '';

  if (sDepCode is NULL) THEN 
     sDepCode = '';

  if (sCatCode is NULL) THEN 
     sCatCode = '';
   

  if (sFirLASortTyp = '0') THEN BEGIN              

      -- salary sort = emp_PersNr

     LA_SORT = LPAD( CAST( iEmpPersNr AS VARCHAR(14) ), 14, '0' );

  END ELSE if (sFirLASortTyp = '1') THEN BEGIN       

     -- salary sort = emp_Name + epm_Vorname 

     LA_SORT = RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');


  END ELSE if (sFirLASortTyp = '2') THEN BEGIN    

     -- salary sort = Dep_Code + emp_Name + epm_Vorname 

     LA_SORT = RPAD(sDepCode, 12,' ') ||
              RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');


  END ELSE if (sFirLASortTyp = '3') THEN BEGIN       

     -- salary sort = Cat_Code + emp_Name + epm_Vorname 

     LA_SORT = RPAD(sCatCode, 12,' ') || 
               RPAD( LEFT (sEmpName, 6), 6,' ') || RPAD( LEFT (sEmpVorname, 6), 6,' ');

  END ELSE BEGIN                                       

     -- salary sort = emp_PersNr

     LA_SORT = LPAD( CAST( iEmpPersNr AS VARCHAR(14) ), 14, '0' );

  END


   --  2. Get all exists SalaryDeduction types from SalaryDetail

  emb_UId             = NULL;     ferienbezug_Monat   = NULL;
  emb_VergTyp         = NULL;     std_VorJahr         = NULL;
  emb_IbanNr          = NULL;     std_Soll_AzMonat    = NULL;
  emb_kontoNr         = NULL;     std_Ist_AzMonat     = NULL;
  emb_betrag          = NULL;     std_Ist_Krank       = NULL;  
  ban_Name            = NULL;     std_Ist_Absenz      = NULL;  
  ban_Plz             = NULL;     std_Ist_Ferien      = NULL;
  ban_Ort             = NULL;     std_Ist_Korrgz      = NULL; 
  emp_VortragFerien   = NULL;     std_Vortrag_Vormonat= NULL;
  emp_SonderFerien    = NULL;     txt_Text            = NULL; 
  emp_AnspruchFerien  = NULL;     sSay_La_Text        = NULL;
  ferienbezug_VorMonat= NULL;     sPrm_La_Text        = NULL;


  sdtSort             = 0;
  nAzbetrag           = 0;    

  FOR 
    SELECT  sa.say_UId,
            sa.say_EmyUId, 
            sa.say_La_Text,
            sd.sad_UId,
            sd.sad_SdtUId,
            st.sdt_Typ, 
            st.sdt_IstNullAusgabe, 
            st.sdt_IstLohnTeil,
            st.sdt_BerechBasisNr,
            st.sdt_LArt,
            st.sdt_Masseinheit, 
            st.sdt_StdAbreTyp,
            ct.sct_CalcType, 
            COALESCE( sd.sad_Text, st.sdt_Text, sd.sad_Text ),
            sd.sad_Menge,
            sd.sad_AnsatzAg,
            sd.sad_AnsatzAn,
            sd.sad_Basis,
            sd.sad_Faktor,
            sd.sad_Total, 
            y.buy_IstIndustrieMinuten
      FROM  say_Salary sa
     INNER JOIN sad_SalaryDetail        sd ON sd.sad_SayUId = sa.say_UId
      LEFT JOIN sdt_SalaryDeductionType st ON st.sdt_UId    = sd.sad_SdtUId
      LEFT JOIN buy_BusinessYear        y  ON y .buy_UId    = st.sdt_BuyUId
      LEFT JOIN sct_SalaryCalcType      ct ON ct.sct_UId    = st.sdt_SctUId

     WHERE sa.say_PraUId = :pi_PraUId AND sa.say_EmyUId = :pi_EmyUId 

     ORDER BY st.sdt_IstLohnTeil DESC, st.sdt_Typ DESC, st.sdt_SortNr

      INTO :say_UId,
           :emy_UId,
           :sSay_La_Text,   
           :sad_UId,
           :std_UId,
           :sdt_Typ,
           :sdt_IstNullAusgabe,
           :sdt_IstLohnTeil,
           :sdt_BerechBasisNr,
           :sdt_LArt, 
           :sdt_Masseinheit,
           :sAbretyp, 
           :sct_CalcType,
           :sad_Text,
           :sad_Menge,
           :sad_AnsatzAg,
           :sad_AnsatzAn,
           :sad_Basis,
           :sad_Faktor,   
           :sad_Total,
           :bIsIndustrieMinuten
  DO 
  BEGIN

    gruppe  = 'a';
    sdtSort = sdtSort+1; 

    IF ( sdt_Typ = 'L' ) THEN 
    BEGIN

      nAzbetrag = nAzbetrag + sad_Total;

      -- If there's an hour-based field, then one has to encode that field
      IF  ( sct_CalcType = 5 )  THEN                                           -- WF: 17.04.2015
      BEGIN

        EXECUTE PROCEDURE sp_WorkMinutesToHours( :sad_Menge, :bIsIndustrieMinuten )
         RETURNING_VALUES :sad_Menge;

      END

    END 
    ELSE 
    BEGIN  

      nAzbetrag = nAzbetrag - sad_Total;
      
    END     

    SUSPEND;

  END
  
  
  -- 3. Get payout value(s) for all employee-payout-bank(s)

  IF ( ( b_La_IstZahlStelle = 1 ) AND ( nAzbetrag > 0 ) ) THEN
  BEGIN

    sad_UId             = NULL;        emp_VortragFerien   = NULL;
    std_UId             = NULL;        emp_SonderFerien    = NULL;
    sdt_Typ             = NULL;        emp_AnspruchFerien  = NULL;
    sdt_LArt            = NULL;        ferienbezug_VorMonat= NULL; 
    sdt_IstNullAusgabe  = NULL;        ferienbezug_Monat   = NULL; 
    sdt_IstLohnTeil     = NULL;        std_VorJahr         = NULL;
    sdt_BerechBasisNr   = NULL;        std_Soll_AzMonat    = NULL;
    sct_CalcType        = NULL;        std_Ist_AzMonat     = NULL; 
    sad_Text            = NULL;        std_Ist_Krank       = NULL;
    sad_Menge           = NULL;        std_Ist_Absenz      = NULL;
    sad_AnsatzAg        = NULL;        std_Ist_Ferien      = NULL; 
    sad_AnsatzAn        = NULL;        std_Ist_Korrgz      = NULL; 
    sad_Basis           = NULL;        std_Vortrag_Vormonat= NULL;
    sad_Faktor          = NULL;        txt_Text            = NULL; 
    sad_Total           = NULL; 

   
    sdtSort    = 0;  

    FOR 
      SELECT  pa.emb_UId,
              pa.emb_VergTyp,    
              pa.emb_IbanNr,
              pa.emb_kontoNr,
              pa.az_betrag, 
              b.ban_Name,
              b.ban_Plz,
              b.ban_Ort 
        FROM  sp_Pra_Payout_Splitt ( :iEmpUId, :nAzbetrag, 0.0 ) pa
        LEFT OUTER JOIN ban_Bank b ON b.ban_UId = pa.emb_BanUId
       ORDER BY pa.emb_Sort 
        INTO :emb_UId,
             :emb_VergTyp,
             :emb_IbanNr,
             :emb_kontoNr,
             :emb_betrag,
             :ban_Name,
             :ban_Plz,
             :ban_Ort
    DO 
    BEGIN

       gruppe  = 'b';
       sdtSort = sdtSort + 1;

       SUSPEND;  

    END

  END

   --  Stunden und Ferienrechnung 

  IF ( ( b_La_IstStunden = 1 ) OR ( b_La_IstFerien = 1 ) ) THEN
  BEGIN

    sdt_Typ             = NULL;   sad_Faktor          = NULL;
    sdt_LArt            = NULL;   sad_Total           = NULL; 
    sdt_IstNullAusgabe  = NULL;   emb_UId             = NULL;
    sdt_IstLohnTeil     = NULL;   emb_VergTyp         = NULL;
    sdt_BerechBasisNr   = NULL;   emb_IbanNr          = NULL;
    sdt_Masseinheit     = NULL;   emb_kontoNr         = NULL;
    sct_CalcType        = NULL;   emb_betrag          = NULL;
    sad_Text            = NULL;   ban_Name            = NULL;
    sad_Menge           = NULL;   ban_Plz             = NULL;
    sad_AnsatzAg        = NULL;   ban_Ort             = NULL;
    sad_AnsatzAn        = NULL;   txt_Text            = NULL; 
    sad_Basis           = NULL;

    emp_VortragFerien    = 0;
    emp_SonderFerien     = 0;
    emp_AnspruchFerien   = 0;
    ferienbezug_VorMonat = 0;
    ferienbezug_Monat    = 0;
    std_VorJahr          = 0;
    std_Soll_AzMonat     = 0;
    std_Ist_AzMonat      = 0;
    std_Ist_Krank        = 0;
    std_Ist_Absenz       = 0;
    std_Ist_Ferien       = 0;
    std_Ist_Korrgz       = 0; 
    std_Vortrag_Vormonat = 0;
    std_Diff_Monat       = 0;  
    std_GZ_Monat         = 0;  

    SELECT m.prm_Monat, m.prm_La_Text 
      FROM pra_PayrollAccount a
      LEFT JOIN prm_PayrollMonth m ON m.prm_UId = a.pra_PrmUId
     WHERE a.pra_UId = :pi_PraUId
      INTO :iMonat, :sPrm_La_Text;

     -- Salovortrag vom Vorjahr 

    SELECT FER_VORTRAG_TAGE, FER_SONDER_TAGE,
           FER_ANSPRUCH_TAGE, TOTAL_GZ_SALDO
       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, 12 )
       WHERE EMH_MONAT = 0
    INTO  :emp_VortragFerien,  :emp_SonderFerien,
          :emp_AnspruchFerien, :std_VorJahr;

    -- Werte aus dem Vormonats 
    SELECT TOTAL_GZ_SALDO,
           EMH_IST_FERIENTAGE2
       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, (:iMonat - 1) )
       WHERE EMH_MONAT = 13
    INTO :std_Vortrag_Vormonat,
         :ferienbezug_VorMonat;

    -- Werte Bezuege aus aktuellem Monat 
    SELECT EMH_SOLL_AZMONAT,
           EMH_IST_AZMONAT, 
           EMH_IST_KRANKSTD,  
           EMH_IST_ABSENZSTD,
           EMH_IST_FERIENSTD,
           EMH_IST_KORRGZ,
           TOTAL_DIFF_MONAT,
           TOTAL_GZ_SALDO,
           EMH_IST_FERIENTAGE2

       FROM SP_RPT_HOURSPEREMP ( :iEmpUId, 1, 12 )
       WHERE EMH_MONAT = :iMonat
 
    INTO :std_Soll_AzMonat,
         :std_Ist_AzMonat,
         :std_Ist_Krank,
         :std_Ist_Absenz,
         :std_Ist_Ferien,
         :std_Ist_Korrgz, 
         :std_Diff_Monat,
         :std_GZ_Monat,
         :ferienbezug_Monat;

    gruppe  = 'C';
    sdtSort = 1; 

    SUSPEND;  


  END ELSE BEGIN

    SELECT m.prm_La_Text 
      FROM pra_PayrollAccount a
      LEFT JOIN prm_PayrollMonth m ON m.prm_UId = a.pra_PrmUId
     WHERE a.pra_UId = :pi_PraUId
      INTO :sPrm_La_Text;

  END


  -- Text und Zusatztexte auf Abrechnung

  sad_UId              = NULL;   emb_kontoNr          = NULL;
  std_UId              = NULL;   emb_betrag           = NULL;
  sdt_Typ              = NULL;   ban_Name             = NULL;
  sdt_LArt             = NULL;   ban_Plz              = NULL;
  sdt_IstNullAusgabe   = NULL;   ban_Ort              = NULL;
  sdt_IstLohnTeil      = NULL;   emp_VortragFerien    = NULL; 
  sdt_BerechBasisNr    = NULL;   emp_SonderFerien     = NULL;
  sdt_Masseinheit      = NULL;   emp_AnspruchFerien   = NULL;
  sct_CalcType         = NULL;   ferienbezug_VorMonat = NULL;
  sad_Text             = NULL;   ferienbezug_Monat    = NULL;
  sad_Menge            = NULL;   std_VorJahr          = NULL;
  sad_AnsatzAg         = NULL;   std_Soll_AzMonat     = NULL;
  sad_AnsatzAn         = NULL;   std_Ist_AzMonat      = NULL;
  sad_Basis            = NULL;   std_Ist_Krank        = NULL;
  sad_Faktor           = NULL;   std_Ist_Absenz       = NULL;
  sad_Total            = NULL;   std_Ist_Ferien       = NULL;
  emb_UId              = NULL;   std_Ist_Korrgz       = NULL;  
  emb_VergTyp          = NULL;   std_Vortrag_Vormonat = NULL;
  emb_IbanNr           = NULL;   txt_Text             = NULL;    

     
  -- Zusatztext aktuelle Abrechnung

  IF ( ( sSay_La_Text IS NOT NULL ) AND ( sSay_La_Text <> '' ) ) THEN 
  BEGIN

    txt_Text  = sSay_La_Text; 
    gruppe    = 'D';
    sdtSort   = 1; 

    SUSPEND;  

  END 


  --  Zusatztext alle Abrechnungen

  IF ( ( sPrm_La_Text IS NOT NULL ) AND ( sPrm_La_Text <> '' ) ) THEN 
  BEGIN

    txt_Text = sPrm_La_Text; 
    gruppe   = 'e';
    sdtSort  = 1; 

    SUSPEND;  
    
  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Rpt_Hours_Survey 
(
    pi_BuyUId     DI_UID,
    pi_MonatVon   DI_SMLINT,
    pi_MonatBis   DI_SMLINT,
    pi_EmpUId     DI_UID = null,
    pi_LandUId    DI_UID = null,
    pi_DepUId     DI_UID = null,
    pi_CatUId     DI_UID = null,
    pi_PrgUId     DI_UID = null
)
RETURNS 
(
    buy_Geschjahr             DI_BUSINESSYEAR,
    buy_Istindustrieminuten   DB_BOOLEAN,
    fir_Code                  DS_CODE,
    fir_Bezeichnung           DS_DESCR,
    fir_Bezeichnung2          DS_STR50,
    fir_Strasse               DS_STR50,
    fir_HausNr                DS_STR5,
    fir_Plz                   DS_PLZ,
    fir_Ort                   DS_STR50,
    emp_UId                   DI_UID,
    emp_PersNr                DI_INT,
    emp_PeidNr                DS_STR20,
    emp_Name                  DS_STR50,
    emp_Vorname               DS_STR50,
    emp_Strasse               DS_STR50,
    emp_HausNr                DS_STR5,
    coi_IsoCode               DS_CODE,
    emp_Plz                   DS_PLZ,
    emp_Ort                   DS_STR50,
    emp_GeburtsDatum          DD_DATE,
    monat_Von                 DI_SMLINT,
    monat_Bis                 DI_SMLINT,
    emh_Monat                 DI_INT,
    emh_Soll_Tage             DN_NUMBER2,
    emh_Soll_AzTag            DN_NUMBER2,
    emh_Soll_AzMonat          DN_NUMBER2,
    emh_Ist_AzMonat           DN_NUMBER2,
    emh_Ist_FerienTage        DN_NUMBER2,
    emh_Ist_FerienStd         DN_NUMBER2,
    emh_Ist_AbsenzTage        DN_NUMBER2,
    emh_Ist_AbsenzStd         DN_NUMBER2,
    emh_Ist_KrankTage         DN_NUMBER2,
    emh_Ist_KrankStd          DN_NUMBER2,
    emh_Ist_KorrGz            DN_NUMBER2,
    fer_Vortrag_Tage          DN_NUMBER2,
    fer_Anspruch_Tage         DN_NUMBER2,
    fer_Sonder_Tage           DN_NUMBER2,
    total_Ist_Std             DN_NUMBER2,
    total_Diff_Monat          DN_NUMBER2,
    total_Gz_Saldo            DN_NUMBER2,
    total_Fer_Saldo           DN_NUMBER2,
    total_Fer_Tage            DN_NUMBER2,
    total_Soll_AzTag          DN_NUMBER2
)
AS
  DECLARE sStmt     VARCHAR(512);
  DECLARE iCoiUId   DI_INT;
  
BEGIN
   
    -- Get Firm - Fields 
    SELECT Y.BUY_GESCHJAHR,
           F.FIR_CODE, 
           F.FIR_BEZEICHNUNG, 
           F.FIR_BEZEICHNUNG2,
           F.FIR_STRASSE,
           F.fir_HausNr,
           F.FIR_PLZ,
           F.FIR_ORT 
  
   FROM BUY_BUSINESSYEAR Y

       LEFT JOIN FIR_FIRM F ON F.FIR_UID=Y.BUY_FIRUID

       WHERE BUY_UID = :PI_BUYUID

   INTO    :BUY_GESCHJAHR,
           :FIR_CODE,
           :FIR_BEZEICHNUNG,
           :FIR_BEZEICHNUNG2,
           :FIR_STRASSE,
           :fir_HausNr,
           :FIR_PLZ,
           :FIR_ORT; 



  sStmt = 'SELECT EMP_UID, EMP_PERSNR, EMP_PEIDNR, EMP_NAME, EMP_VORNAME,      '||
          '       EMP_STRASSE, emp_HausNr, EMP_LANDUID, EMP_PLZ, EMP_ORT, EMP_GEBURTSDATUM '|| 
          ' FROM EMP_EMPLOYEE                                                  '||
          ' WHERE (EMP_BUYUID = :piBUYUID) ';

  IF (( PI_EMPUID IS NOT NULL ) AND ( PI_EMPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_UID= ' || PI_EMPUID || ')';

  IF (( PI_LANDUID IS NOT NULL ) AND (PI_LANDUID > 0)) THEN
     sStmt = sStmt || ' AND (EMP_LANDUID= ' || PI_LANDUID || ')';

  IF ( PI_DEPUID IS NOT NULL AND (PI_DEPUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_DEPUID= ' || PI_DEPUID || ')';

  IF (( PI_CATUID IS NOT NULL ) AND (PI_CATUID > 0 )) THEN
     sStmt = sStmt || ' AND (EMP_CATUID= ' || PI_CATUID || ')';

  sStmt = sStmt || ' ORDER BY EMP_NAME,EMP_VORNAME ' ;


  -- Monatsbereich fuer Liste zurueckgeben--

  MONAT_VON  = PI_MONATVON;
  MONAT_BIS  = PI_MONATBIS;


  FOR 
    EXECUTE STATEMENT (sStmt) ( piBUYUID := :PI_BUYUID )
      INTO :EMP_UID,     :EMP_PERSNR,  :EMP_PEIDNR, :EMP_NAME, :EMP_VORNAME,
           :EMP_STRASSE, :emp_HausNr, :iCoiUid, :EMP_PLZ,    :EMP_ORT, :EMP_GEBURTSDATUM
 
  DO 
  BEGIN

     SELECT COI_ISOCODE FROM COI_COUNTRYISO
       WHERE COI_UID = :iCoiUid 
     INTO :COI_ISOCODE;


     SELECT EMH_MONAT,
            EMH_SOLL_TAGE,
            EMH_SOLL_AZTAG,
            EMH_SOLL_AZMONAT,
            EMH_IST_AZMONAT,
            EMH_IST_FERIENTAGE,
            EMH_IST_FERIENSTD,
            EMH_IST_ABSENZTAGE,
            EMH_IST_ABSENZSTD,
            EMH_IST_KRANKTAGE,
            EMH_IST_KRANKSTD,
            EMH_IST_KORRGZ,
            FER_VORTRAG_TAGE,
            FER_ANSPRUCH_TAGE,
            FER_SONDER_TAGE,
            TOTAL_IST_STD,
            TOTAL_DIFF_MONAT,
            TOTAL_GZ_SALDO,
            TOTAL_FER_SALDO,
            TOTAL_FER_TAGE,
            TOTAL_SOLL_AZTAG,
            BUY_ISTINDUSTRIEMINUTEN

     FROM SP_RPT_HOURSPEREMP ( :EMP_UID, :PI_MONATVON, :PI_MONATBIS )
         WHERE (EMH_MONAT = 13)
         
     INTO   :EMH_MONAT,
            :EMH_SOLL_TAGE,
            :EMH_SOLL_AZTAG,
            :EMH_SOLL_AZMONAT,
            :EMH_IST_AZMONAT,
            :EMH_IST_FERIENTAGE,
            :EMH_IST_FERIENSTD,
            :EMH_IST_ABSENZTAGE,
            :EMH_IST_ABSENZSTD,
            :EMH_IST_KRANKTAGE,
            :EMH_IST_KRANKSTD,
            :EMH_IST_KORRGZ,
            :FER_VORTRAG_TAGE,
            :FER_ANSPRUCH_TAGE,
            :FER_SONDER_TAGE,
            :TOTAL_IST_STD,
            :TOTAL_DIFF_MONAT, 
            :TOTAL_GZ_SALDO,
            :TOTAL_FER_SALDO,
            :TOTAL_FER_TAGE,
            :TOTAL_SOLL_AZTAG,
            :BUY_ISTINDUSTRIEMINUTEN;
    
     SUSPEND;  

  END

END!!
COMMIT!!

-- FS#740:END
-- +++

-- +++
-- FS#720:START - Move database code in the application code - Stage #1 - (Users & UserGroups)

CREATE OR ALTER PROCEDURE sp_Apa_UserGroupListAccess 
(
  pi_Apa_ObjUId     DI_UID_NN,
  ps_Apa_ObjPrefix  DS_TABPREFIX_NN
)
RETURNS 
(
  usg_UId           DI_UID,
  usg_Code          DS_CODE,
  usg_Name          DS_USGNAME,
  apa_IstSichtbar   DB_BOOLEAN,
  apa_IstAktiviert  DB_BOOLEAN
)
AS
  -- Get list of user groups with access for given element

BEGIN

  FOR
  
    SELECT usg_UId,
           usg_Code,
           usg_Name
      FROM usg_UserGroup
     ORDER BY usg_Code
      INTO :usg_UId,
           :usg_Code,
           :usg_Name
           
  DO
  BEGIN

    IF ( ps_apa_ObjPrefix IN ('AFR', 'AFA', 'APR', 'APT') )

    THEN
    BEGIN

      EXECUTE PROCEDURE sp_Apa_GetFullAccess
                         :pi_apa_ObjUId,
                         :ps_apa_ObjPrefix,
                         :usg_UId,
                         'USG'
        RETURNING_VALUES :apa_IstAktiviert,
                         :apa_IstSichtbar;

      IF ( apa_IstAktiviert IS NULL ) THEN
        apa_IstAktiviert = 0;

      IF ( apa_IstSichtbar  IS NULL ) THEN
        apa_IstSichtbar  = 0;

    END

    ELSE
    BEGIN

      apa_IstAktiviert = NULL;
      apa_IstSichtbar  = NULL;

    END

    SUSPEND;

  END

END!!
COMMIT!!

COMMENT ON PROCEDURE sp_Apa_UserGroupListAccess IS 'Get list of user groups with access for given element'!!
COMMENT ON PARAMETER sp_Apa_UserGroupListAccess.pi_Apa_ObjUId     IS 'Object UId, foreign key to afr_UId, afa_UId, apr_UId or apt_UId'!!
COMMENT ON PARAMETER sp_Apa_UserGroupListAccess.ps_Apa_ObjPrefix  IS 'Prefix of the table owner of FK Id above: AFR, AFA, APR or APT'!!

-- +++

CREATE OR ALTER PROCEDURE sp_Fir_SelectByUser 
(
  pi_UsrUId     DI_UID_NN,
  pb_InFirm     DB_BOOLEAN_NN,
  pb_IstAktiv   DB_BOOLEAN
)
RETURNS 
(
  fir_UId           DI_UID,
  fir_Code          DS_CODE,
  fir_Bezeichnung   DS_DESCR,
  fir_Postfach      DS_STR50,
  fir_Strasse       DS_STR50,
  fir_Plz           DS_PLZ,
  fir_Ort           DS_STR50,
  fir_PlzOrt        DS_STR80,
  fir_IstAktiv      DB_BOOLEAN,
  fir_CuiIsoCode    DS_CODE,
  fir_CuiUId        DI_UID,
  fir_CoiUId        DI_UID,
  coi_IsoCode       DS_CODE
)
AS
  /* Select firms accessable/restricted for the user*/
  
  DECLARE iUsgUId     DI_UID;
  DECLARE sFirUIds    DS_STR255   DEFAULT '';
  DECLARE sFirUId     DS_STR50    DEFAULT '';
  

BEGIN  

  FOR

    SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
           fir_Postfach,  fir_Strasse,  fir_Plz,
           fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
           fir_IstAktiv,  cui_IsoCode,   cui_UId,
           fir_CoiUId,    coi_IsoCode
      FROM fir_Firm
      LEFT JOIN cul_CurrencyList ON cul_MastUId = fir_UId AND cul_MastPrefix = 'FIR' AND cul_IstBasis = 1
      LEFT JOIN cui_CurrencyISO  ON cul_CuiUId  = cui_UId
      LEFT JOIN coi_CountryISO   ON coi_UId     = fir_CoiUId
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM dtm_Data2Master
                  WHERE dtm_MastUId    = fir_UId
                    AND dtm_MastPrefix = 'FIR'
                    AND dtm_TabUId     = :pi_UsrUId
                    AND dtm_TabPrefix  = 'USR' )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR fir_IstAktiv = :pb_IstAktiv ) 
     ORDER BY fir_Bezeichnung
      INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
           :fir_Postfach,   :fir_Strasse,     :fir_Plz,
           :fir_Ort,        :fir_PlzOrt,
           :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
           :fir_CoiUId,     :coi_IsoCode
  DO
  BEGIN
  
    IF ( sFirUIds <> '' ) THEN
      sFirUIds = sFirUIds || ',';
      
    sFirUIds = sFirUIds || CAST( fir_UId AS DS_STR255 );
    
    SUSPEND;
    
  END

  /* +++*/
    
  FOR
  
    SELECT usg_UId
      FROM usg_UserGroup      
     WHERE (
             (
               :pb_InFirm = 1
               AND
               EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
             OR
             (
               :pb_InFirm = 0
               AND
               NOT EXISTS
               ( SELECT 1
                   FROM utg_User2Group
                  WHERE utg_UsgUId = usg_UId
                    AND utg_UsrUId = :pi_UsrUId )
             )
           )
           AND ( :pb_IstAktiv IS NULL OR usg_IstAktiv = :pb_IstAktiv )  
     ORDER BY usg_Name   
      INTO :iUsgUId
    
  DO
  BEGIN
    
    FOR
    
      SELECT fir_UId,       fir_Code,     fir_Bezeichnung, 
             fir_Postfach,  fir_Strasse,  fir_Plz,
             fir_Ort,       fir_Plz || ' ' || fir_Ort AS fir_PlzOrt,
             fir_IstAktiv,  fir_CuiIsoCode,   fir_CuiUId,
             fir_CoiUId,    coi_IsoCode
        FROM sp_Fir_SelectByUserGroup( :iUsgUId, :pb_InFirm, :pb_IstAktiv )
        INTO :fir_UId,        :fir_Code,        :fir_Bezeichnung,
             :fir_Postfach,   :fir_Strasse,     :fir_Plz,
             :fir_Ort,        :fir_PlzOrt,
             :fir_IstAktiv,   :fir_CuiIsoCode,  :fir_CuiUId,
             :fir_CoiUId,     :coi_IsoCode
             
    DO
    BEGIN
    
      sFirUId = CAST( fir_UId AS DS_STR50 );
      
      IF ( POSITION( sFirUId IN sFirUIds ) = 0 ) THEN      
        SUSPEND;
      
    END
    
  END

END!!
COMMIT!!

COMMENT ON PROCEDURE sp_Fir_SelectByUser IS 'Select users whom has/has no access to firm'!!
COMMENT ON PARAMETER sp_Fir_SelectByUser.pi_UsrUId   IS 'User Id'!!
COMMENT ON PARAMETER sp_Fir_SelectByUser.pb_InFirm   IS 'Flag: 1 - User have access to firm, 0 - user has no access to firm'!!
COMMENT ON PARAMETER sp_Fir_SelectByUser.pb_IstAktiv IS 'If TRUE - then select active firms only'!!

-- +++

CREATE OR ALTER PROCEDURE sp_Apa_UserListAccess 
(
  pi_Apa_ObjUId     DI_UID_NN,
  ps_Apa_ObjPrefix  DS_TABPREFIX_NN
)
RETURNS 
(
  usr_UId           DI_UID,
  usr_Login         DS_USERLOGIN,
  usr_Name          DS_USERNAME,
  apa_IstSichtbar   DB_BOOLEAN,
  apa_IstAktiviert  DB_BOOLEAN
)
AS
  -- Get list of users with access for given element

BEGIN

  FOR
    
    SELECT usr_UId,
           usr_Login,
           usr_Name
      FROM usr_User
     ORDER BY usr_Login
      INTO :usr_UId,
           :usr_Login,
           :usr_Name
  DO
  BEGIN

    IF ( ps_apa_ObjPrefix IN ('AFR', 'AFA', 'APR', 'APT') )

    THEN
    BEGIN

      EXECUTE PROCEDURE sp_Apa_GetFullAccess
                         :pi_apa_ObjUId,
                         :ps_apa_ObjPrefix,
                         :usr_UId,
                         'USR'
        RETURNING_VALUES :apa_IstAktiviert,
                         :apa_IstSichtbar;

      IF ( apa_IstAktiviert IS NULL ) THEN
        apa_IstAktiviert = 0;

      IF ( apa_IstSichtbar  IS NULL ) THEN
        apa_IstSichtbar  = 0;

    END

    ELSE
    BEGIN

      apa_IstAktiviert = NULL;
      apa_IstSichtbar  = NULL;

    END

    SUSPEND;

  END

END!!
COMMIT!!

COMMENT ON PROCEDURE sp_Apa_UserListAccess IS 'Get list of users with access for given element'!!
COMMENT ON PARAMETER sp_Apa_UserListAccess.pi_Apa_ObjUId IS 'Object UId, foreign key to afr_UId, afa_UId, apr_UId or apt_UId'!!
COMMENT ON PARAMETER sp_Apa_UserListAccess.ps_Apa_ObjPrefix IS 'Prefix of the table owner of FK Id above: AFR, AFA, APR or APT'!!

-- +++

CREATE OR ALTER PROCEDURE sp_Apa_GetDirectAccess 
(
  pi_Apa_ObjUId       DI_UID_NN,
  ps_Apa_ObjPrefix    DS_TABPREFIX_NN,
  pi_Apa_UsrUId       DI_UID_NN,
  ps_Apa_UsrPrefix    DS_TABPREFIX_NN
)
RETURNS 
(
  apa_IstAktiviert  DB_BOOLEAN,
  apa_IstSichtbar   DB_BOOLEAN
)
AS
  -- Get access of users or groups to application objects

BEGIN

  apa_IstAktiviert = NULL;
  apa_IstSichtbar  = NULL;

  -- System Master user

  IF (
           ( UPPER(ps_apa_UsrPrefix) = 'USR' )
       AND ( :pi_apa_UsrUId          = 1     )
     )
  THEN
  BEGIN

    apa_IstAktiviert = 1;
    apa_IstSichtbar  = 1;
    EXIT;

  END

  -- Another Master user
  
  IF (
       ( 
         UPPER( :ps_apa_UsrPrefix ) = 'USR' )
         AND
         EXISTS
         ( 
            SELECT 1
              FROM usr_User
             WHERE UPPER( usr_typ ) = 'M'
               AND usr_UId = :pi_apa_UsrUId
         )
     )
  THEN
  BEGIN

    apa_IstAktiviert = 1;
    apa_IstSichtbar  = 1;
    EXIT;

  END

  -- Administrators group

  IF (
           ( UPPER(ps_apa_UsrPrefix) = 'USG' )
       AND ( :pi_apa_UsrUId = 1              )
     )
  THEN
  BEGIN

    apa_IstAktiviert = 1;
    apa_IstSichtbar  = 1;
    EXIT;

  END

  -- search rigths

  SELECT apa_IstAktiviert,
         apa_IstSichtbar
    FROM apa_AppAccess
   WHERE ( apa_ObjUId    = :pi_apa_ObjUId    )
     AND ( apa_ObjPrefix = :ps_apa_ObjPrefix )
     AND ( apa_UsrUId    = :pi_apa_UsrUId    )
     AND ( apa_UsrPrefix = :ps_apa_UsrPrefix )
    INTO :apa_IstAktiviert,
         :apa_IstSichtbar;

END!!
COMMIT!!

COMMENT ON PROCEDURE sp_Apa_GetDirectAccess IS 'Get direct access of users or groups to application objects'!!
COMMENT ON PARAMETER sp_Apa_GetDirectAccess.pi_Apa_ObjUId    IS 'Object UId, foreign key to afr_UId, afa_UId, apr_UId or apt_UId'!!
COMMENT ON PARAMETER sp_Apa_GetDirectAccess.ps_Apa_ObjPrefix IS 'Prefix of the table owner of FK Id above: AFR, AFA, APR or APT'!!
COMMENT ON PARAMETER sp_Apa_GetDirectAccess.pi_Apa_UsrUId    IS 'User or User group ID to which access is granted'!!
COMMENT ON PARAMETER sp_Apa_GetDirectAccess.ps_Apa_UsrPrefix IS 'Prefix of the table owner of ID above: USR or USG'!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Utg_Select'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Utg_SelectG'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Utg_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Utg_Update'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Utg_Delete'!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_Select'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_Update'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_Delete'!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_Select'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_GetCount'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_Select4Firm'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_Select4Firm'!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_SelectByFirm'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usg_SelectByFirm'!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_Update'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Usr_Delete'!!
COMMIT!!

-- FS#720:END
-- +++

-- +++
-- FS#734:START - Move database code in the application code - Stage #3 - (Reports management)

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Afr_GetReports'!!
COMMIT!!

-- FS#734:END
-- +++

-- +++
-- FS#733:START - Move database code in the application code - Stage #2 - (Access management)

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_CopyRights'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetAppObjectsStrAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetAppObjectsStructure'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetFormAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetFormActionsAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_UserGroupListAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_UserListAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetFullAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_GetDirectAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_SetFullAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_SetAccess'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_Select'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_Insert'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_Update'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Apa_Delete'!!
COMMIT!!

-- FS#733:END
-- +++

-- +++
-- FS#735:START - Move database code in the application code - Stage #4 - (Archives management)

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_Select'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_Update'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_Delete'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_GetArmUIdByMaster'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_IsExistsForMaster'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arf_SelectDocumentsByFirm'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arf_SelectDocuments'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_GetDocDetails'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_Delete'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_RemoveOrSetInvalid'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_DocsExist'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_Insert'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Ard_Update'!!
COMMIT!! 

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_GetArfUIdForLinked'!! 
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_AdjustArchiveLinksByBuy'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_AdjustArchiveLink'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_GetFirstBuyEmpUId'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fii_GetFirstBuyFiiUId'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fib_GetFirstBuyFibUId'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fir_GetIdForArchiveMaster'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fii_GetIdForArchiveMaster'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fib_GetIdForArchiveMaster'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_GetIdForArchiveMaster'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fii_GetArchiveDesc'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fib_GetArchiveDesc'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Fir_GetArchiveDesc'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Emp_GetArchiveDesc'!!
COMMIT!!

-- +++

EXECUTE PROCEDURE sp_DDL_SafeDropTrigger 'TRG_Emp_AfterIns_Payroll_10'!!
EXECUTE PROCEDURE sp_DDL_SafeDropTrigger 'TRG_Fib_AfterIns_Payroll_1'!!
EXECUTE PROCEDURE sp_DDL_SafeDropTrigger 'TRG_Fii_AfterIns_Payroll_1'!!
EXECUTE PROCEDURE sp_DDL_SafeDropTrigger 'TRG_Fir_AfterIns_Payroll_10'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_CreateLinkToArchive'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_GetUIdForLinked'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arl_DeleteByMaster'!!
COMMIT!!


EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arf_CrtFolderForArchMaster'!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Arm_GetArchiveList'!! 
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_IsMasterPrefix'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_GetArmMastIdByTable'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_GetArhiveInfo'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_Insert'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_Update'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Art_Delete'!!
COMMIT!!

-- FS#735:END
-- +++

-- +++
-- FS#746:START - Adjust PayrollAccount removal

CREATE OR ALTER PROCEDURE sp_Pra_DeleteEmptyAccounts
(
  pi_BuyUId DI_UID
)
AS
  -- The procedure deletes all empty and not fixed records. The procedure is executing when closing 
  -- the form SalaryManageFRM
  
  DECLARE VARIABLE iPraUId        DI_UID;
  DECLARE VARIABLE iAnzMitInabre  DI_INT;
  DECLARE VARIABLE bIstVerbucht   DB_BOOLEAN;
  
BEGIN

  -- Alle nicht verbuchten und leeren Abrechnungen entfernen 

  FOR
   
    SELECT pra_UId, pra_IstVerbucht, COALESCE( pra_AnzMitInabre, 0 )
      FROM pra_PayrollAccount
      JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
     WHERE prm_BuyUId = :pi_BuyUId
       AND prm_Monat  > 0
     ORDER BY prm_Monat DESC, prm_AbreNr DESC
      INTO :iPraUId, :bIstVerbucht, :iAnzMitInabre
  DO
  BEGIN
    
    IF ( bIstVerbucht = 1 OR iAnzMitInabre > 0 ) THEN LEAVE;    
    
    EXECUTE PROCEDURE sp_Pra_Delete :iPraUId;    
        
  END

END!!
COMMIT!!

-- FS#746:END
-- +++

-- +++
-- FS#742:START - Move par_Parameter stored procedures to Delphi code

EXECUTE PROCEDURE sp_DDL_SafeDropTrigger   'TRG_Usr_AfterDel_1'!!
EXECUTE PROCEDURE sp_DDL_SafeDropTrigger   'TRG_Usr_AfterIns_1'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_DeleteDefUserParams'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_InsertDefUserParams'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_InsOrUpd'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_Select'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_DelByCode'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_DelByUId'!!
EXECUTE PROCEDURE sp_DDL_SafeDropProcedure 'sp_Par_GetValue'!!
COMMIT!!

-- FS#742:END
-- +++

SET TERM ;!!
