﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.07
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++

--FS#578:START - Firebird V3.0-RC1: Error on CREATE OR ALTER PROCEDURE - FOR WITH RECURSIVE TREE ...

CREATE OR ALTER PROCEDURE sp_DDL_GetObjectDependencies
(
  ps_DependedOnName   DS_STR50,
  ps_FieldName        DS_STR50 DEFAULT NULL
)
RETURNS
(
  sDependentName    DS_STR50,
  sDependedOnName   DS_STR50,
  sFieldName        DS_STR50
)
AS

  -- Get dependent objects

BEGIN
  
  FOR
  
    WITH RECURSIVE TREE AS
    (
      SELECT rdb$Dependent_Name, rdb$Depended_On_Name, rdb$Field_Name
        FROM rdb$Dependencies
       WHERE ( UPPER( :ps_DependedOnName ) = rdb$Depended_On_Name )
         AND ( :ps_FieldName IS NULL OR  UPPER( :ps_FieldName ) = rdb$Field_Name )
       UNION ALL
      SELECT DEP.rdb$Dependent_Name, DEP.rdb$Depended_On_Name, DEP.rdb$Field_Name
        FROM rdb$Dependencies DEP, TREE T
       WHERE T.rdb$Dependent_Name = DEP.rdb$Depended_On_Name
    )
    SELECT rdb$Dependent_Name, rdb$Depended_On_Name, rdb$Field_Name
      FROM TREE
      INTO :sDependentName, :sDependedOnName, :sFieldName
  
  DO
    SUSPEND;
  
END!!

COMMENT ON PROCEDURE sp_DDL_GetObjectDependencies IS 'Get dependent objects'!!
COMMENT ON PARAMETER sp_DDL_GetObjectDependencies.ps_DependedOnName IS 'Depended on object name'!!
COMMENT ON PARAMETER sp_DDL_GetObjectDependencies.ps_FieldName      IS 'Depended field name'!!

COMMIT!!

--FS#578:END
-- +++

-- +++
-- FS#708:START - PKLohn - Improvement SP_RPT_HOURSPEREMP

CREATE OR ALTER PROCEDURE sp_Rpt_HoursPerEmp 
(
    pi_EmpUId     DI_UID,
    pi_MonatVon   DI_SMLINT,
    pi_MonatBis   DI_SMLINT
)
RETURNS 
(
    emp_UId                   DI_UID,
    emh_Monat                 DI_SMLINT,
    emh_Besgrad               DN_NUMBER4,
    emh_Soll_Tage             DN_NUMBER2,
    emh_Soll_Aztag            DN_NUMBER2,
    emh_Soll_Azmonat          DN_NUMBER2,
    emh_Ist_AzMonat           DN_NUMBER2,
    emh_Ist_FerienTage        DN_NUMBER2,
    emh_Ist_FerienStd         DN_NUMBER2,
    emh_Ist_AbsenzTage        DN_NUMBER2,
    emh_Ist_AbsenzStd         DN_NUMBER2,
    emh_Ist_KrankTage         DN_NUMBER2,
    emh_Ist_KrankStd          DN_NUMBER2,
    emh_Ist_KorrGz            DN_NUMBER2,
    fer_Vortrag_Tage          DN_NUMBER2,
    fer_Anspruch_Tage         DN_NUMBER2,
    fer_Sonder_Tage           DN_NUMBER2,
    total_Ist_Std             DN_NUMBER2,
    total_Diff_Monat          DN_NUMBER2,
    total_Gz_Saldo            DN_NUMBER2,
    total_Fer_Saldo           DN_NUMBER2,
    total_Fer_Tage            DN_NUMBER2,
    buy_IstIndustrieMinuten   DB_BOOLEAN
)

AS
  DECLARE  iSollAzTagWorkStd    DI_INT;
  DECLARE  iSollAzMonWorkStd    DI_INT;
  DECLARE  iIstAzMonWorkStd     DI_INT;
  DECLARE  iIstFerienWorkStd    DI_INT;
  DECLARE  iIstAbsenzWorkStd    DI_INT;
  DECLARE  iIstKrankWorkStd     DI_INT;
  DECLARE  iIstKorrGzWorkStd    DI_INT;
  DECLARE  iIstTotalWorkStd     DI_INT;
  DECLARE  iTotalGzWorkStd      DI_INT;
  DECLARE  iTotalFerWorkStd     DI_INT;
  DECLARE  iTotalDiffMonat      DI_INT;
  DECLARE  bIstOk               DB_BOOLEAN;
  DECLARE  sum_Soll_Tage        DN_NUMBER2;
  DECLARE  sum_Soll_AzTag       DI_INT;
  DECLARE  sum_Soll_AzMonat     DI_INT;
  DECLARE  sum_Ist_AzMonat      DI_INT;
  DECLARE  sum_Ist_FerienTage   DN_NUMBER2;
  DECLARE  sum_Ist_FerienStd    DI_INT;
  DECLARE  sum_Ist_AbsenzTage   DN_NUMBER2;
  DECLARE  sum_Ist_AbsenzStd    DI_INT;
  DECLARE  sum_Ist_KrankTage    DN_NUMBER2;
  DECLARE  sum_Ist_KrankStd     DI_INT;
  DECLARE  sum_Ist_KorrGz       DI_INT;
  DECLARE  sum_Total_Ist_Std    DI_INT;
  DECLARE  sum_Total_Fer_Tage   DI_INT;
  
BEGIN

   SUM_SOLL_TAGE       = 0;
   SUM_SOLL_AZTAG      = 0;
   SUM_SOLL_AZMONAT    = 0;
   SUM_IST_AZMONAT     = 0;
   SUM_IST_FERIENTAGE  = 0;
   SUM_IST_FERIENSTD   = 0;
   SUM_IST_ABSENZTAGE  = 0;
   SUM_IST_ABSENZSTD   = 0;
   SUM_IST_KRANKTAGE   = 0;
   SUM_IST_KRANKSTD    = 0;
   SUM_IST_KORRGZ      = 0;
   SUM_TOTAL_IST_STD   = 0;
   SUM_TOTAL_FER_TAGE  = 0;

   bIstOk = 0;

   FOR SELECT EMP_UID,
              EMH_MONAT,
              EMH_BESGRAD,
              COALESCE(EMH_SOLL_TAGE,     0.0),
              COALESCE(EMH_SOLL_AZTAG,      0),
              COALESCE(EMH_SOLL_AZMONAT,  0.0),
              COALESCE(EMH_IST_AZMONAT,     0),
              COALESCE(EMH_IST_FERIENTAGE,0.0),
              COALESCE(EMH_IST_FERIENSTD,   0),
              COALESCE(EMH_IST_ABSENZTAGE,0.0),
              COALESCE(EMH_IST_ABSENZSTD,   0),
              COALESCE(EMH_IST_KRANKTAGE, 0.0),
              COALESCE(EMH_IST_KRANKSTD,    0),
              COALESCE(EMH_IST_KORRGZ,      0),
              FER_VORTRAG_TAGE,
              FER_ANSPRUCH_TAGE,
              FER_SONDER_TAGE,
              COALESCE(TOTAL_IST_STD,     0.0),
              COALESCE(TOTAL_DIFF_MONAT,  0.0),
              TOTAL_GZ_SALDO,
              TOTAL_FER_SALDO,
              TOTAL_FER_TAGE,
              BUY_ISTINDUSTRIEMINUTEN   

       FROM SP_RPT_HOURSPEREMP_HLP ( :PI_EMPUID ) 
          ORDER BY EMH_MONAT

       INTO   :EMP_UID,
              :EMH_MONAT,
              :EMH_BESGRAD,  
              :EMH_SOLL_TAGE,
              :iSollAzTagWorkStd,           
              :iSollAzMonWorkStd,         
              :iIstAzMonWorkStd,          
              :EMH_IST_FERIENTAGE,
              :iIstFerienWorkStd,         
              :EMH_IST_ABSENZTAGE,
              :iIstAbsenzWorkStd,       
              :EMH_IST_KRANKTAGE,
              :iIstKrankWorkStd,      
              :iIstKorrGzWorkStd,     
              :FER_VORTRAG_TAGE,
              :FER_ANSPRUCH_TAGE,
              :FER_SONDER_TAGE,
              :iIstTotalWorkStd,
              :iTotalDiffMonat, 
              :iTotalGzWorkStd,    
              :iTotalFerWorkStd,
              :TOTAL_FER_TAGE,
              :BUY_ISTINDUSTRIEMINUTEN 
   
   DO 
   BEGIN       

      IF (PI_MONATVON = 1) THEN
         PI_MONATVON = 0;

      IF ( EMH_MONAT <= PI_MONATBIS ) THEN 
      BEGIN

         bIstOk = 1;

         -- Summen bilden ------------------------------------------
         SUM_TOTAL_FER_TAGE  = SUM_TOTAL_FER_TAGE + EMH_IST_FERIENTAGE;

      END

      IF ( ( EMH_MONAT >= PI_MONATVON ) AND ( EMH_MONAT <= PI_MONATBIS ) ) THEN 
      BEGIN

         bIstOk = 1;

         -- Summen bilden ------------------------------------------
         SUM_SOLL_TAGE       = SUM_SOLL_TAGE      + EMH_SOLL_TAGE; 
         SUM_SOLL_AZTAG      = SUM_SOLL_AZTAG     + iSollAzTagWorkStd;
         SUM_SOLL_AZMONAT    = SUM_SOLL_AZMONAT   + iSollAzMonWorkStd;
         SUM_IST_AZMONAT     = SUM_IST_AZMONAT    + iIstAzMonWorkStd;
         SUM_IST_FERIENTAGE  = SUM_IST_FERIENTAGE + EMH_IST_FERIENTAGE;
         SUM_IST_FERIENSTD   = SUM_IST_FERIENSTD  + iIstFerienWorkStd;
         SUM_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE + EMH_IST_ABSENZTAGE;
         SUM_IST_ABSENZSTD   = SUM_IST_ABSENZSTD  + iIstAbsenzWorkStd;
         SUM_IST_KRANKTAGE   = SUM_IST_KRANKTAGE  + EMH_IST_KRANKTAGE;
         SUM_IST_KRANKSTD    = SUM_IST_KRANKSTD   + iIstKrankWorkStd;
         SUM_IST_KORRGZ      = SUM_IST_KORRGZ     + iIstKorrGzWorkStd;
         SUM_TOTAL_IST_STD   = SUM_TOTAL_IST_STD  + iIstTotalWorkStd;


         -- Alle Work-Stunden in Anzeigeformat umrechnen -----------

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzTagWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iSollAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAzMonWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstFerienWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstAbsenzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKrankWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstKorrGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iIstTotalWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalGzWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_GZ_SALDO;

         EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :iTotalFerWorkStd, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_FER_SALDO;

        
         SUSPEND;

      END


   END



   ----------- Total anhÃ¤ngen ----------------------------------------------- 
   IF ( bIstOk = 1 ) THEN 
   BEGIN

      EMH_MONAT           = 13;
      EMH_BESGRAD         = NULL;
      EMH_SOLL_TAGE       = SUM_SOLL_TAGE;
      EMH_IST_FERIENTAGE  = SUM_IST_FERIENTAGE;
      EMH_IST_ABSENZTAGE  = SUM_IST_ABSENZTAGE; 
      EMH_IST_KRANKTAGE   = SUM_IST_KRANKTAGE;
      TOTAL_FER_TAGE      = FER_ANSPRUCH_TAGE + FER_VORTRAG_TAGE + FER_SONDER_TAGE - SUM_TOTAL_FER_TAGE;
      TOTAL_DIFF_MONAT    = 0; 

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZTAG, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZTAG;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_SOLL_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_SOLL_AZMONAT;
   
      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_AZMONAT, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_FERIENSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_FERIENSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_ABSENZSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_ABSENZSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KRANKSTD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KRANKSTD;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_IST_KORRGZ, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :EMH_IST_KORRGZ;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS :SUM_TOTAL_IST_STD, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_IST_STD;

      iTotalDiffMonat = SUM_TOTAL_IST_STD - SUM_SOLL_AZMONAT;

      EXECUTE PROCEDURE SP_WORKMINUTESTOHOURS iTotalDiffMonat, :BUY_ISTINDUSTRIEMINUTEN
             RETURNING_VALUES :TOTAL_DIFF_MONAT;


      SUSPEND;

   END
   
END!!
COMMIT!!

GRANT EXECUTE ON PROCEDURE sp_Rpt_HoursPerEmp_Hlp TO PROCEDURE sp_Rpt_HoursPerEmp!!
GRANT EXECUTE ON PROCEDURE sp_WorkMinutesToHours TO PROCEDURE sp_Rpt_HoursPerEmp!!
GRANT EXECUTE ON PROCEDURE sp_Rpt_HoursPerEmp TO SYSDBA!!
COMMIT!!

-- FS#708:END
-- +++

-- +++
-- FS#707:START - PKLohn - Calculation of 'Vortrag vom Vormonat' +
-- FS#713:START - PKLohn - SalaryManageFRM ‚Bezug Vormonate‘

CREATE OR ALTER PROCEDURE sp_Emh_StundenFerien 
(
  pi_PraUId DI_UID,
  pi_EmyUId DI_UID
)
RETURNS 
(
  pra_UId               DI_UID,
  prm_UId               DI_UID,
  emy_UId               DI_UID,
  emp_UId               DI_UID,
  iMonat                DI_SMLINT,
  ist_IndustrieMinuten  DB_BOOLEAN,

  min_Avg_AzTag         DI_INT,      -- Durchschn AZ pro Tag in Min (je nach System) / Average per day in AZ min (depending on system) 
  std_Avg_AzTag         DN_NUMBER2,  -- Durchschn AZ pro Tag in STD (ganzes Jahr)    / Average per day in AZ STD (full year)

  tag_Soll_Tage         DN_NUMBER2,  -- Soll-Tage dieser Monat                / Target days in the current month 
  std_Soll_AzTag        DN_NUMBER2,  -- Soll-Arbeitszeit pro Tag in Std.      / Target working time per day (in hours)
  min_Soll_AzTag        DI_INT,      -- Soll-Arbeitszeit pro Tag in Min.      / Target working time per day (in minutes)
  std_Soll_AzMonat      DN_NUMBER2,  -- Soll-Abreitszeit diesen Monat in Std. / Target working time this month (in hours)
  min_Soll_AzMonat      DI_INT,      -- Soll-Abreitszeit diesen Monat in Min. / Target working time this month (in minutes)

  std_Ist_AzMonat       DN_NUMBER2,  -- Ist-Arbeitszeit diesen Monat in Std. / Actual working time this month (in hours)
  min_Ist_AzMonat       DI_INT,      -- Ist-Arbeitszeit diesen Monat in Min. / Actual working time this month (in minutes)

  tag_Ist_Ferien        DN_NUMBER2,  -- FerienBezug diesen Monat in Tagen / I had holiday xx days this month (in days)  
  std_Ist_Ferien        DN_NUMBER2,  -- FerienBezug diesen Monat in Std.  / I had holiday xx days this month (in hours)
  min_Ist_Ferien        DI_INT,      -- FerienBezug diesen Monat in Min.  / I had holiday xx days this month (in minutes)

  tag_Ist_Absenz        DN_NUMBER2,  -- Absenzen diesen Monat in Tagen   / Absense time this month (in days)    
  std_Ist_Absenz        DN_NUMBER2,  -- Absenzen diesen Monat in Stunden / Absense time this month (in hours)
  min_Ist_Absenz        DI_INT,      -- Absenzen diesen Monat in Min     / Absense time this month (in minutes)

  tag_Ist_Krank         DN_NUMBER2,  -- Krankheit diesen Monat in Tagen   / Sick time this month (in days)
  std_Ist_Krank         DN_NUMBER2,  -- Krankheit diesen Monat in Stunden / Sick time this month (in hours)
  min_Ist_Krank         DI_INT,      -- Krankheit diesen Monat in Min     / Sick time this month (in minutes)

  std_Ist_KorrGz        DN_NUMBER2,  -- Korr. Gleitzeit diesen Monat in Stunden / Adjustment for flexitime (hours)  
  min_Ist_KorrGz        DI_INT,      -- Korr. Gleitzeit diesen Monat in Min     / Adjustment for flexitime (minutes)

  std_Diff_Monat        DN_NUMBER2,  -- Differenz diesen Monat in Stunden / This month difference in hours
  min_Diff_Monat        DI_INT,      -- Differenz diesen Monat in Min     / This month difference in minutes

  std_VortragVorMonat   DN_NUMBER2,  -- Vortrag Vormonat in Stunden / Lecture (?) previous month's balance (in hours)
  min_VortragVorMonat   DI_INT,      -- Vortrag Vormonat in Minuten / Lecture (?) previous month's balance (in minutes)

  tag_Fer_Vortrag       DN_NUMBER2,  -- Ferinen-Vortrag Vorjahr in Tagen    / Previous years's balance for holidays (in days)
  tag_Fer_Anspruch      DN_NUMBER2,  -- Ferinen-Anspruch Lfd. Jahr in Tagen / Entitlement to holidays in current year (in days)
  tag_Fer_Soferien      DN_NUMBER2,  -- Sonder-Ferinen  Lfd. Jahr in Tagen  / Special holidays in current year (in days)
  tag_Fer_BezugVorMonat DN_NUMBER2,  -- Ferinen-Bezug  Vormonate in Tagen   / I had holiday xx days previous months (in days) 
  tag_Fer_BezugAktMonat DN_NUMBER2,   -- Ferinen-Bezug  akt Monat in Tagen   / I had holiday xx days in this (current) months (in days)
  std_Fer_BezugVorMonat DN_NUMBER2
)
AS

  -- The procedure is used to show summary information for hours and holiday days.
  -- It is used in the form SalaryManage - hours and in the Report Month Salary
  
  DECLARE iStd_Vortragvj   DI_INT;
  DECLARE iVortragFerien   DI_INT;
  DECLARE nJahres_Tage     DN_NUMBER2;
  DECLARE iJahres_Az       DI_INT;
  DECLARE iJahres_Az_Avg   DN_NUMBER2;
  DECLARE iMinuten         DI_INT;
  DECLARE iMinuten1        DI_INT;
  DECLARE iMinuten2        DI_INT;
  DECLARE nSoll_Tage       DN_NUMBER2;
  DECLARE iSoll_AzTag      DI_INT;
  DECLARE iIst_AzMonat     DI_INT;
  DECLARE nIst_FerienTage  DN_NUMBER2;
  DECLARE nIst_AbsenzTage  DN_NUMBER2;
  DECLARE nIst_KrankTage   DN_NUMBER2;
  DECLARE iIst_Korrgz      DI_INT;
  DECLARE iSum_Vorsoll     DI_INT;
  DECLARE iSum_Vorist      DI_INT;

BEGIN
 

  SELECT emy_UId,           emp_UId,            emp_VortragFerien, 
         emp_SonderFerien,  emp_AnspruchFerien, emp_VortragStd,    buy_IstIndustrieMinuten
    FROM emy_EmploymentPeriod
    JOIN emp_Employee     ON emp_UId = emy_EmpUId
    JOIN buy_BusinessYear ON buy_UId = emp_BuyUId
   WHERE emy_UId = :pi_EmyUId
    INTO :emy_UId,          :emp_UID,           :iVortragFerien, 
         :tag_Fer_Soferien, :tag_Fer_Anspruch,  :iStd_Vortragvj,   :ist_IndustrieMinuten;
         
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :iVortragFerien, :ist_IndustrieMinuten )
   RETURNING_VALUES :tag_Fer_Vortrag;

  
  SELECT prm_UId,   prm_Monat,  pra_UId
    FROM pra_PayrollAccount    
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :prm_UId,  :iMonat,    :pra_UId;

  -- Durschnittelche AbreitsZeit pro Tag rechnen (ueber das ganzes Jahr) 
  -- Average working hours per day expected (over the whole year)
  
  SELECT SUM( emh_Soll_Tage ), TRUNC( SUM( emh_Soll_Tage * emh_Soll_AzTag ) ) 
    FROM emh_EmployeeHours
   WHERE emh_EmpUId = :emp_UId
    INTO :nJahres_Tage, iJahres_Az;
 
  -- Durschschn. JahresAbreitszeit in Minuten /  Average. Annual working time in minutes
  
  iJahres_Az_Avg = IIF( nJahres_Tage = 0, 0, TRUNC( iJahres_Az / nJahres_Tage ) );
  
  min_Avg_AzTag  = iJahres_Az_Avg;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :iJahres_Az_Avg, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Avg_AzTag;


  -- StundenVortrag Vormonate, FerienSaldo Vormonate rechnen  
  -- Expected hours lecture prior month holiday entitlement previous months
  
  iSum_Vorsoll           = 0;   -- Total aller Soll-Minuten der Vormonate / Total of all debit-minutes of the previous months
  iSum_Vorist            = 0;   -- Total aller IST-Minuten der Vormonate  / Total of all IST-minutes of the previous months
  tag_Fer_BezugvorMonat  = 0;   -- Total aller FerienTage der Vormonate   / Total of all the holidays of the previous months
  std_Fer_BezugvorMonat  = 0;   -- Total aller FerienStunden der Vormonate   / Total of all the holiday hours of the previous months

  FOR 
    SELECT emh_Soll_Tage,                     emh_Soll_AzTag, 
           COALESCE( emh_Ist_AzMonat,    0 ), COALESCE( emh_Ist_FerienTage, 0 ),
           COALESCE( emh_Ist_AbsenzTage, 0 ), COALESCE( emh_Ist_KrankTage,  0 ),
           COALESCE( emh_Ist_Korrgz,     0 )
      FROM emh_EmployeeHours
     WHERE emh_EmpUId = :emp_UId 
       AND emh_Monat  < :iMonat 
      INTO :nSoll_Tage,      :iSoll_AzTag,
           :iIst_AzMonat,    :nIst_FerienTage,
           :nIst_AbsenzTage, :nIst_KrankTage, 
           :iIst_Korrgz

  DO 
  BEGIN
  
     -- Summe aller Soll-Minuten der Vormonate (AnzahlTage x SollAZTag)
     -- ???
     iMinuten     = nSoll_Tage * iSoll_AzTag;
     iSum_Vorsoll = iSum_Vorsoll + iMinuten;
 
     -- Summe aller ist-minuten (absenztage x durschnittliche-jahres-az pro tag)
     -- ???
     iMinuten  = nIst_FerienTage * iSoll_AzTag;
     iMinuten1 = nIst_AbsenzTage * iSoll_AzTag;
     iMinuten2 = nIst_KrankTage  * iSoll_AzTag;

     iSum_Vorist  = iSum_Vorist  + iIst_AzMonat + iMinuten + iMinuten1 + iMinuten2 + iIst_Korrgz;

     -- Ferienbezug vormanate in tagen 
     -- ???
     tag_Fer_BezugVormonat = tag_Fer_BezugVormonat + nIst_FerienTage;
     
     -- Ferienbezug vormonate in Stunden
     -- ???
     std_Fer_BezugVormonat = std_Fer_BezugVormonat + (nIst_FerienTage * iSoll_AzTag); 

  END
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :std_Fer_BezugVormonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Fer_BezugVormonat;

  -- Gleitsaldo der Vormonate in Stunden
  -- ???saldo from previous monthes (minutes)
  min_VortragVormonat = iSum_Vorist + iStd_VortragVj - iSum_Vorsoll;

  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_VortragVormonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_VortragVormonat;


  -- Ist-Stunden, Soll-Stunden, Ferbeinezug aktueller Monat
  SELECT emh_Soll_Tage,                     emh_Soll_AzTag,
         emh_Soll_AzMonat,
         COALESCE( emh_Ist_AzMonat,    0 ), COALESCE( emh_Ist_FerienTage, 0 ),
         COALESCE( emh_Ist_AbsenzTage, 0 ), COALESCE( emh_Ist_KrankTage,  0 ),
         COALESCE( emh_Ist_Korrgz,     0 )
    FROM emh_EmployeeHours
   WHERE emh_EmpUId = :emp_UId 
     AND emh_Monat  = :iMonat 
    INTO :nSoll_Tage,      :iSoll_AzTag,
         :min_Soll_AzMonat,
         :iIst_AzMonat,    :nIst_FerienTage,
         :nIst_AbsenzTage, :nIst_KrankTage, 
         :iIst_Korrgz;

  tag_Soll_Tage         = nSoll_Tage;
  tag_Ist_Ferien        = nIst_FerienTage;
  tag_Ist_Absenz        = nIst_AbsenzTage;
  tag_Ist_Krank         = nIst_KrankTage;  

  min_Soll_Aztag   =  iSoll_AzTag;                        -- Soll-AZ pro Tag im Min
  min_Ist_AzMonat  =  iIst_AzMonat;                       -- Ist-AZ in Min  
  
  min_Ist_Ferien   =  nIst_FerienTage * min_Soll_Aztag;   -- Ferienbezug in Min 
  min_Ist_Absenz   =  nIst_AbsenzTage * min_Soll_Aztag;   -- Absenzen in Min
  min_Ist_Krank    =  nIst_KrankTage  * min_Soll_Aztag;   -- Krank in Minuten
  min_Ist_Korrgz   =  iIst_Korrgz;                        -- Korr. Gleitzeit in Minuten
  
  tag_Fer_BezugAktMonat = min_Ist_Ferien;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Soll_Aztag,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Soll_AzTag;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Soll_AzMonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Soll_AzMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_AzMonat,  :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_AzMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Ferien,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Ferien;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :tag_Fer_BezugAktMonat, :ist_IndustrieMinuten )
   RETURNING_VALUES :tag_Fer_BezugAktMonat;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Absenz,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Absenz;
   
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Krank,    :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_Krank;
  
  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Ist_Korrgz,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Ist_KorrGz;
   
  -- Differenz diesen Monat (= Ist-Soll) / Difference this month (= ???)
  min_Diff_Monat = 
    ( min_Ist_AzMonat + min_Ist_Ferien + min_Ist_Absenz + min_Ist_Krank + min_Ist_Korrgz )
    - min_Soll_AzMonat;

  EXECUTE PROCEDURE sp_WorkMinutesToHours( :min_Diff_Monat,   :ist_IndustrieMinuten )
   RETURNING_VALUES :std_Diff_Monat;

  SUSPEND;

END!!

COMMENT ON PROCEDURE sp_Emh_StundenFerien           IS 'Summary working hours/days information'!!
COMMENT ON PARAMETER sp_Emh_StundenFerien.pi_PraUId IS 'Payroll Account Id'!!
COMMENT ON PARAMETER sp_Emh_StundenFerien.pi_EmyUId IS 'Employment period Id'!!

COMMIT!!

-- FS#707:END +
-- FS#713:END
-- +++


-- +++
-- FS#717:START - PKLohn - Improvement of day fields

EXECUTE BLOCK AS
BEGIN
  
  UPDATE emp_Employee
     SET emp_SonderFerien   = COALESCE( emp_SonderFerien  , 0 ),
         emp_AnspruchFerien = COALESCE( emp_AnspruchFerien, 0 );
  
END!!
COMMIT!!

-- +++

UPDATE rdb$Relation_Fields
   SET rdb$Field_Source = 'DN_NUMBER2_NN'
 WHERE rdb$Relation_Name = 'EMP_EMPLOYEE' 
   AND rdb$Field_Name IN ( 'EMP_SONDERFERIEN', 'EMP_ANSPRUCHFERIEN' )!!
COMMIT!!   

-- FS#717:END
-- +++

SET TERM ;!!
