﻿-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- VER: Payroll 2.00.06
-- REF: --
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
SET TERM !!;

-- +++

-- FS#633:START - PKLohn - Changes in Salary Statement

CREATE OR ALTER PROCEDURE SP_SAR_CALCEMPLOYEE 
(
    PI_SARUID DI_UID,
    PI_APP_ACTIVEUSER DI_UID
)
AS   
  declare variable IEMPUID DI_UID;
  declare variable ISSDUID DI_UID;
  declare variable SEMPPEID DS_STR20;
  declare variable DEMPGEB DD_DATE;
  declare variable SEMPAUF DS_ONECHARFLAG;
  declare variable SSALCODE DS_STR10;
  declare variable BISAUSWCH DB_BOOLEAN;
  declare variable SFIRMASITZ DS_CODE;
  declare variable BISTFIRMASITZ_FL DB_BOOLEAN;
  declare variable BCALCAUSWEISDATACH DB_BOOLEAN;
  declare variable NTOTAL DN_NUMBER2;
  declare variable NMENGE DN_NUMBER2;
  declare variable SSALTYP DS_ONECHARFLAG;
  declare variable SFIRNAME1 DS_DESCR;
  declare variable SFIRNAME2 DS_STR50;
  declare variable SFIRSTR DS_STR50;
  declare variable SFIRHAUS DS_STR5;
  declare variable SFIRPLZ DS_PLZ;
  declare variable SFIRORT DS_STR50;
  declare variable SFIRTEL DS_STR50;
  declare variable BFL_A DB_BOOLEAN;
  declare variable BFL_B DB_BOOLEAN;
  declare variable BFL_F DB_BOOLEAN;
  declare variable BFL_G DB_BOOLEAN;
  declare variable SFL_23 DS_STR1024;
  declare variable SFL_3 DS_STR1024;
  declare variable SFL_4 DS_STR1024;
  declare variable SFL_6 DS_STR1024;
  declare variable SFL_7 DS_STR1024;
  declare variable SFL_1312 DS_STR1024;
  declare variable SFL_1323 DS_STR1024;
  declare variable SFL_14 DS_STR1024;
  declare variable SFL_15 DS_STR1024;
  declare variable SFL_C DS_STR20;
  declare variable SCH_C DS_STR20;
  declare variable IFL_D DI_INT;
  declare variable DFL_E1 DD_DATE;
  declare variable DFL_E2 DD_DATE;
  declare variable IFL_1 DI_INT;
  declare variable IFL_21 DI_INT;
  declare variable IFL_22 DI_INT;
  declare variable IFL_23 DI_INT;
  declare variable IFL_3 DI_INT;
  declare variable IFL_4 DI_INT;
  declare variable IFL_5 DI_INT;
  declare variable IFL_6 DI_INT;
  declare variable IFL_7 DI_INT;
  declare variable IFL_9 DI_INT;
  declare variable IFL_101 DI_INT;
  declare variable IFL_102 DI_INT;
  declare variable IFL_12 DI_INT;
  declare variable BFL_1310 DB_BOOLEAN;
  declare variable IFL_1311 DI_INT;
  declare variable IFL_1312 DI_INT;
  declare variable IFL_1321 DI_INT;
  declare variable IFL_1322 DI_INT;
  declare variable IFL_1323 DI_INT;
  declare variable IFL_133 DI_INT;
  declare variable SFL_ORT DS_STR128;
  declare variable SFL_FIR DS_STR512;
  declare variable IAT_1A DI_INT;
  declare variable IAT_1B1 DI_INT;
  declare variable IAT_1B2 DI_INT;
  declare variable IAT_1B3 DI_INT;
  declare variable IAT_1B4 DI_INT;
  declare variable IAT_1B5 DI_INT;
  declare variable IAT_1B6 DI_INT;
  declare variable IAT_1B7 DI_INT;
  declare variable IAT_1C1 DI_INT;
  declare variable IAT_1C21 DI_INT;
  declare variable IAT_1C22 DI_INT;
  declare variable IAT_1C31 DI_INT;
  declare variable IAT_1C32 DI_INT;
  declare variable IAT_1C4 DI_INT;
  declare variable IAT_1D1 DI_INT;
  declare variable IAT_1D2 DI_INT;
  declare variable IAT_1D3 DI_INT;
  declare variable IAT_1D4 DI_INT;
  declare variable SAT_1D51 DS_STR1024;
  declare variable IAT_1D52 DI_INT;
  declare variable IAT_21 DI_INT;
  declare variable IAT_22 DI_INT;
  declare variable IAT_23 DI_INT;
  declare variable SAT_241 DS_STR1024;
  declare variable IAT_242 DI_INT;
  declare variable IAT_251 DI_INT;
  declare variable IAT_252 DI_INT;
  declare variable IAT_31 DI_INT;
  declare variable IAT_32 DI_INT;
  declare variable IAT_33 DI_INT;
  declare variable IAT_34 DI_INT;
  declare variable IAT_35 DI_INT;
  declare variable SAT_361 DS_STR1024;
  declare variable IAT_362 DI_INT;
  
BEGIN

   -- Get EmpUid -----------------------------------------------
   SELECT SAR_EMPUID
      FROM SAR_SALARYREPORT 
       WHERE SAR_UID=:PI_SARUID
   INTO :iEmpUid;


   -- Get Employee Data ----------------------------------------
   sFL_C  = '';     -- FL -PEID-Nr  
     sCH_C  = '';     -- CH -PEID-Nr     
   iFL_D  = 0;
   dFL_E1 = NULL;
   dFL_E2 = NULL;

   
   SELECT Y.BUY_GESCHJAHR,
          E.EMP_AUFENTHALT,
          E.EMP_PEIDNR,
          E.EMP_GEBURTSDATUM,
          E.emp_IstCh,
          E.emp_Ch_PeidNr,
          C.COI_ISOCODE

     FROM EMP_EMPLOYEE E
     LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID=E.EMP_BUYUID
     LEFT JOIN FIR_FIRM F ON F.FIR_UID=Y.BUY_FIRUID
     LEFT OUTER JOIN COI_COUNTRYISO C ON C.COI_UID=F.FIR_COIUID 
     WHERE EMP_UID=:iEmpUid

   INTO :iFL_D,
        :sEmpAuf,
        :sEmpPEID,
        :dEmpGeb,
        :bIsAuswCH,
        :sCH_C,
        :sFirmaSitz;

   sEmpAuf = Trim(sEmpAuf);

   bIstFirmaSitz_FL = 1;
   IF (NOT ((Trim(sFirmaSitz) = 'LI') OR (Trim(sFirmaSitz) = 'FL'))) THEN BEGIN
      bIstFirmaSitz_FL = 0;
   END


   IF ( (sEmpPEID IS NULL) OR ( Trim(sEmpPEID) = '') ) THEN BEGIN

      sFL_C = CAST( dEmpGeb AS VARCHAR(20) );

   END ELSE BEGIN

      sFL_C = sEmpPEID;

   END


   SELECT MIN(EMY_PJANFANG),
          MAX(EMY_PJENDE) 

     FROM EMY_EMPLOYMENTPERIOD

   WHERE (EMY_EMPUID=:iEmpUid) AND (EMY_ISUNEMPLOYED = 0)

     INTO: dFL_E1,
           dFL_E2;
    



   -- Lohnausweis-Settings from Employee 
   EXECUTE PROCEDURE SP_SSD_GETUIDBYMASTER( :iEmpUid, 'EMP' )
        RETURNING_VALUES :iSsdUid;  

   bFL_A     = 1;
   bFL_B     = 0;
   bFL_F     = 0;
   bFL_G     = 0;
   sFL_23    = '';
   sFL_3     = '';
   sFL_4     = '';
   sFL_6     = '';
   sFL_7     = '';
   bFL_1310  = 0 ;        
   sFL_1312  = '';
   sFL_1323  = '';
   sFL_14    = '';
   sFL_15    = '';


   SELECT SSD_FIXEDEXPENSESCHECK,
          SSD_SALARYCERT,
          SSD_PENSIONCERT,
          SSD_FREETRANSPORT,
          SSD_CATERING,
          SSD_OTHERFRINGEBENEFITS,
          SSD_IRREGULARSERVICES,   
          SSD_CAPITALBENEFITS,
          SSD_ORGANCOMPENSATION,
          SSD_OTHERSERVICES,
          SSD_OTHERACTUALEXPENSES,
          SSD_OTHERFIXEDEXPENSES,
          SSD_MOREFRINGEBENEFITS,
          SSD_COMMENTS  

     FROM SSD_SALDESCRIPTIONTEMPLATE
  
   WHERE SSD_UID = :iSsdUid

     INTO :bFL_1310,
          :bFL_A,
          :bFL_B,
          :bFL_F, 
          :bFL_G,
          :sFL_23,
          :sFL_3,
          :sFL_4,
          :sFL_6,
          :sFL_7,
          :sFL_1312,
          :sFL_1323,
          :sFL_14,
          :sFL_15;



   -- CH - Ausweis nur falls Grenzgaenger CH -> Sonst immer FL-Ausweis

   IF (bIstFirmaSitz_FL = 1) THEN BEGIN

       IF (sEmpAuf <> '2') THEN BEGIN  -- wenn KEIN Grenzgaenger CH

          IF (bIsAuswCH = 1) THEN
             bIsAuswCH = 0;             -- Kein CH-Ausweis

       END 

       bCalcAusweisDataCH = 0;      
       IF (sEmpAuf = '2') THEN BEGIN  
          -- Wenn Grenzgaenger CH immer Daten fuer CH-Ausweis aufbereiten auch wenn FL-AUsweis
          bCalcAusweisDataCH = 1;  
       END     
        

   END ELSE BEGIN   -- wenn FiremSitz in CH
   
       bCalcAusweisDataCH = 1;        -- Daten nach CH-Ausweis aufbereiten      
       
       IF (sEmpAuf = '2') THEN BEGIN  -- wenn Grenzgaenger FL

          if (bIsAuswCH = 0) THEN BEGIN

             bCalcAusweisDataCH = 0;    -- Daten nach FL-Ausweis aufbereiten         

          END

       END ELSE BEGIN

          bIsAuswCH = 1;               -- immer ein CH-Ausweis

       END

   END
  

   -------------------------------------------------------------------
   -- FL 1. Seite berechnen-------------------------------------------
   -------------------------------------------------------------------

   --  Values Loehne -------------------------------------------------

  iFL_1  = 0;   iFL_4    = 0;   iFL_1312 = 0;  sFL_Ort = ''; 
  iFL_21 = 0;   iFL_5    = 0;   iFL_1321 = 0;  sFL_Fir = '';
  iFL_22 = 0;   iFL_6    = 0;   iFL_1322 = 0;
  iFL_23 = 0;   iFL_7    = 0;   iFL_1323 = 0;
  iFL_3  = 0;   iFL_1311 = 0;   iFL_133  = 0;


  sSalTyp = 'A';   -- Autom. Texte gemaess FL

  IF (bCalcAusweisDataCH = 1)  THEN BEGIN 


     -- Falls Daten nach CH-Ausweis aufbereitet werden sollen

     sSalTyp = 'C';  -- Autom. Texte gemaess CH


     FOR SELECT SS.SAL_CODE,
         SUM( COALESCE( D.SAD_BEITRAGAG, D.SAD_TOTAL ) )

         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_C_SALUID   
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_C_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'L')                                   


         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal
   
     DO BEGIN

        IF (sSalCode IS NULL) THEN  sSalCode = '';

        IF ( Trim(sSalCode) = '1') THEN BEGIN

           iFL_1   = Round( nTotal , 0);
 
        END ELSE IF ( Trim(sSalCode) = '2.1') THEN BEGIN
   
           iFL_21  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.2') THEN BEGIN
  
           iFL_22  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.3') THEN BEGIN
  
           iFL_23  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3') THEN BEGIN
  
           iFL_3   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '4') THEN BEGIN
  
           iFL_4   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '5') THEN BEGIN
  
           iFL_5   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '6') THEN BEGIN
  
          iFL_6   = Round( nTotal , 0);
  
        END ELSE IF ( Trim(sSalCode) = '7') THEN BEGIN
  
           iFL_7   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.1.1') THEN BEGIN

           iFL_1311 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.1.2') THEN BEGIN

           iFL_1312 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.2.1') THEN BEGIN

           iFL_1321 = Round( nTotal , 0);
   
        END ELSE IF ( Trim(sSalCode) = '13.2.2') THEN BEGIN
  
           iFL_1322 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.2.3') THEN BEGIN

           iFL_1323 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.3') THEN BEGIN

           iFL_133  = Round( nTotal , 0);

        END

     END
 

  END ELSE BEGIN


     -- Daten nach FL-Auswies aufbereiten

     FOR SELECT SS.SAL_CODE,
         SUM( COALESCE( D.SAD_BEITRAGAG, D.SAD_TOTAL ) )

         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_A_SALUID   
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_A_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'L') 

         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal
   
     DO BEGIN
     
        IF (sSalCode IS NULL) THEN  sSalCode = '';

        IF ( Trim(sSalCode) = '1') THEN BEGIN

           iFL_1   = Round( nTotal , 0);
 
        END ELSE IF ( Trim(sSalCode) = '2.1') THEN BEGIN
   
           iFL_21  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.2') THEN BEGIN
  
           iFL_22  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.3') THEN BEGIN
  
           iFL_23  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3') THEN BEGIN
  
           iFL_3   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '4') THEN BEGIN
  
           iFL_4   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '5') THEN BEGIN
  
           iFL_5   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '6') THEN BEGIN
  
          iFL_6   = Round( nTotal , 0);
  
        END ELSE IF ( Trim(sSalCode) = '7') THEN BEGIN
  
           iFL_7   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.1.1') THEN BEGIN

           iFL_1311 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.1.2') THEN BEGIN

           iFL_1312 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.2.1') THEN BEGIN

           iFL_1321 = Round( nTotal , 0);
   
        END ELSE IF ( Trim(sSalCode) = '13.2.2') THEN BEGIN
  
           iFL_1322 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.2.3') THEN BEGIN

           iFL_1323 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '13.3') THEN BEGIN

           iFL_133  = Round( nTotal , 0);

        END

     END 

  END




  --  Values Lohn-Abzuege -------------------------------------------------
  iFL_9    = 0;    
  iFL_101  = 0;   
  iFL_102  = 0;    
  iFL_12   = 0;    


  IF (bCalcAusweisDataCH = 1)  THEN BEGIN 

     -- Wenn Grenzgaenger CH immer Daten fuer CH-Ausweis aufbereiten auch wenn FL-AUsweis

     FOR SELECT SS.SAL_CODE,
         SUM(D.SAD_BEITRAGAN)

         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_C_SALUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_C_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'A')                                         

         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal
     DO BEGIN
     
        IF (sSalCode IS NULL) THEN 
           sSalCode = '';

        IF ( Trim(sSalCode) = '9') THEN BEGIN
 
           iFL_9   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '10.1') THEN BEGIN

           iFL_101  = Round( nTotal , 0);
 
        END ELSE IF ( Trim(sSalCode) = '10.2') THEN BEGIN

           iFL_102  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '12') THEN BEGIN

           iFL_12   = Round( nTotal , 0);

        END

     END 


  END ELSE BEGIN


     FOR SELECT SS.SAL_CODE,
         SUM(D.SAD_BEITRAGAN)

         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_A_SALUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_A_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'A') 

         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal
     DO BEGIN
     
        IF (sSalCode IS NULL) THEN 
           sSalCode = '';

        IF ( Trim(sSalCode) = '9') THEN BEGIN
 
           iFL_9   = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '10.1') THEN BEGIN

           iFL_101  = Round( nTotal , 0);
 
        END ELSE IF ( Trim(sSalCode) = '10.2') THEN BEGIN

           iFL_102  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '12') THEN BEGIN

           iFL_12   = Round( nTotal , 0);

        END

     END 
 
  END 

  -------------------------------------------------------------------------------------
  -- Texte, falls am MA definiert -> Text vom MA, falls nicht -> Texte aus Lohnarten --
  -------------------------------------------------------------------------------------


  --------- Text: FL Punkt 2.3 ----- 
  if (iFL_23 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp ,'2.3', :sFL_23 )
     INTO :sFL_23;

  end else begin

     sFL_23 = NULL;

  end


  --------- Text: FL Punkt 3 ----- 
  if (iFL_3 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '3', :sFL_3 )
     INTO :sFL_3;

  end else begin

     sFL_3 = NULL;

  end

  --------- Text: FL Punkt 4 ----- 
  if (iFL_4 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '4', :sFL_4 )
     INTO :sFL_4;

  end else begin

     sFL_4 = NULL;

  end
    
  --------- Text: FL Punkt 6 (!! nicht auf CH-Ausweis !!) -----  *********************************************
  if (iFL_6 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '6', :sFL_6 )
     INTO :sFL_6;

  end else begin

     sFL_6 = NULL;

  end

  IF (bIsAuswCH = '1') THEN BEGIN   -- Wenn CH-Ausweis -> kein Text 6

     sFL_6 = NULL;

  END


  --------- Text: FL Punkt 7 ----- 
  if (iFL_7 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '7', :sFL_7 )
     INTO :sFL_7;

  end else begin

     sFL_7 = NULL;

  end


  --------- Text: FL Punkt 13.1.2 ----- 
  if (iFL_1312 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '13.1.2', :sFL_1312 )
     INTO :sFL_1312;

  end else begin

     sFL_1312 = NULL;

  end

  --------- Text: FL Punkt 13.2.3 ----- 
  if (iFL_1323 <> 0) then begin

     SELECT PS_LA_TEXT 
         FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '13.2.3', :sFL_1323 )
     INTO :sFL_1323;

  end else begin

     sFL_1323 = NULL;

  end

  --------- Text: FL Punkt 14 (Weitere Gehaltsnebenleistungen) ----- 


  SELECT PS_LA_TEXT 
       FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, :sSalTyp, '14', :sFL_14 )
  INTO :sFL_14;



  --------- Text: FL Punkt 15 (Bermerkungen) ----- 

  --  !!!! sFL_15




  --  Ort, Datum, FirmaAdr und TelNr---------------------------------
  sFirName1 = '';   sFirPlz   = ''; 
  sFirName2 = '';   sFirOrt   = '';
  sFirStr   = '';   sFirTel   = ''; 
  sFirHaus  = '';

  SELECT F.FIR_BEZEICHNUNG,
         F.FIR_BEZEICHNUNG2,
         F.FIR_STRASSE,
         F.fir_HausNr,
         F.FIR_PLZ,
         F.FIR_ORT,
         F.FIR_TELEFON
 
     FROM EMP_EMPLOYEE E

      LEFT JOIN BUY_BUSINESSYEAR Y ON Y.BUY_UID=E.EMP_BUYUID
      LEFT JOIN FIR_FIRM F ON F.FIR_UID=Y.BUY_FIRUID
  WHERE E.EMP_UID = :iEmpUid

  INTO :sFirName1,
       :sFirName2,
       :sFirStr, 
       :sFirHaus,
       :sFirPlz, 
       :sFirOrt,
       :sFirTel; 

  IF (sFirName1 IS NULL) THEN sFirName1 = ''; 
  IF (sFirName2 IS NULL) THEN sFirName2 = ''; 
  IF (sFirStr   IS NULL) THEN sFirStr   = ''; 
  IF (sFirHaus  IS NULL) THEN sFirHaus  = ''; 
  IF (sFirPlz   IS NULL) THEN sFirPlz   = ''; 
  IF (sFirOrt   IS NULL) THEN sFirOrt   = ''; 
  IF (sFirTel   IS NULL) THEN sFirTel   = ''; 


  -- Ort und Datum --------------------------
  sFL_Ort = EXTRACT( DAY   FROM Current_TimeStamp)||'.'||
            EXTRACT( MONTH FROM Current_TimeStamp)||'.'||
            EXTRACT( YEAR  FROM Current_TimeStamp);

  if ( CHAR_LENGTH (sFirOrt)  > 0 ) THEN 
     sFL_Ort = Trim(sFirOrt)||', '||sFL_Ort;

  -- Firma-Adresse und Telefon -------------

  sFL_Fir = Trim( sFirName1 );

  if (CHAR_LENGTH ( Trim( sFirName2 ) ) > 0) then begin
     if ( CHAR_LENGTH (sFL_Fir)  > 0 ) THEN 
        sFL_Fir = sFL_Fir||ascii_char(13);
    sFL_Fir = sFL_Fir || Trim( sFirName2 );
  end 

  if (CHAR_LENGTH ( Trim( sFL_Fir ) ) > 0) then begin
     if ( CHAR_LENGTH (sFL_Fir)  > 0 ) THEN 
        sFL_Fir = sFL_Fir||ascii_char(13);
    sFL_Fir = sFL_Fir || Trim( sFirStr );
  end 
  
  IF ( CHAR_LENGTH( Trim( sFirHaus ) ) > 0 ) THEN 
  BEGIN
  
     IF ( CHAR_LENGTH( sFL_Fir ) > 0 ) THEN
        sFL_Fir = sFL_Fir || ' ';
        
    sFL_Fir = sFL_Fir || Trim( sFirHaus );
    
  END

  if (CHAR_LENGTH ( Trim( sFirOrt ) ) > 0) then begin
     if ( CHAR_LENGTH (sFL_Fir)  > 0 ) THEN 
        sFL_Fir = sFL_Fir||ascii_char(13);
    sFL_Fir = sFL_Fir || Trim( sFirPlz ) ||' '|| Trim( sFirOrt ); 
  end 

  if (CHAR_LENGTH ( Trim( sFirTel ) ) > 0) then begin
     if ( CHAR_LENGTH (sFL_Fir)  > 0 ) THEN 
        sFL_Fir = sFL_Fir||ascii_char(13);
    sFL_Fir = sFL_Fir || 'Tel. '|| Trim( sFirTel ); 
  end 



  -------------------------------------------------------------------
  -- FL 2. Seite nur fur Grenzgaenger AT-----------------------------
  -------------------------------------------------------------------
  iAT_1A  = 0;   iAT_1C1  = 0;   iAT_1D1  = 0;
  iAT_1B1 = 0;   iAT_1C21 = 0;   iAT_1D2  = 0;
  iAT_1B2 = 0;   iAT_1C22 = 0;   iAT_1D3  = 0; 
  iAT_1B3 = 0;   iAT_1C31 = 0;   iAT_1D4  = 0; 
  iAT_1B4 = 0;   iAT_1C32 = 0;   sAT_1D51 = ''; 
  iAT_1B5 = 0;   iAT_1C4  = 0;   iAT_1D52 = 0;
  iAT_1B6 = 0;
  iAT_1B7 = 0;

  iAT_21   = 0;  iAT_31   = 0;
  iAT_22   = 0;  iAT_32   = 0; 
  iAT_23   = 0;  iAT_33   = 0;
  sAT_241  = ''; iAT_34   = 0;
  iAT_242  = 0;  iAT_35   = 0; 
  iAT_251  = 0;  sAT_361  = '';
  iAT_252  = 0;  iAT_362  = 0;
  

  -- Nur berechnen, wenn Grenzgaenger AT -------------------------------

  IF (sEmpAuf = '3') THEN BEGIN


     -- Alle Loehne ----------------------------------------
     FOR SELECT SS.SAL_CODE,
         SUM( COALESCE( D.SAD_BEITRAGAG, D.SAD_TOTAL ) ),
         SUM(D.SAD_MENGE)
         
         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_Z_SALUID   
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_Z_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'L') 

         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal,
              :nMenge

   
     DO BEGIN
     
        IF (sSalCode IS NULL) THEN  sSalCode = '';

        IF ( Trim(sSalCode) = '1A)') THEN BEGIN

           iAT_1A   = Round( nTotal , 0);
 
        END ELSE IF ( Trim(sSalCode) = '1B).1') THEN BEGIN
   
           iAT_1B1  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).2') THEN BEGIN
   
           iAT_1B2  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).3') THEN BEGIN
   
           iAT_1B3  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).4') THEN BEGIN
   
           iAT_1B4  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).5') THEN BEGIN
   
           iAT_1B5  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).6') THEN BEGIN
   
           iAT_1B6  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1B).7') THEN BEGIN
   
           iAT_1B7  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1C).1') THEN BEGIN
   
           iAT_1C1  = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1C).2') THEN BEGIN

           iAT_1C21 = Round( nMenge , 0);   -- Anz. Stunden
           iAT_1C22 = Round( nTotal , 0);  

        END ELSE IF ( Trim(sSalCode) = '1C).3') THEN BEGIN
   
           iAT_1C31 = Round( nMenge , 0);   -- Anz. Stunden  
           iAT_1C32 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1C).4') THEN BEGIN
   
           iAT_1C4 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1D).1') THEN BEGIN

           iAT_1D1 = Round( nTotal , 0); 

        END ELSE IF ( Trim(sSalCode) = '1D).2') THEN BEGIN

           iAT_1D2 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1D).3') THEN BEGIN

           iAT_1D3 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1D).4') THEN BEGIN

           iAT_1D4 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '1D).5') THEN BEGIN

           iAT_1D52 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.1') THEN BEGIN

           iAT_21 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.2') THEN BEGIN

           iAT_22 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.3') THEN BEGIN

           iAT_23 = Round( nTotal , 0); 

        END ELSE IF ( Trim(sSalCode) = '2.4') THEN BEGIN

           iAT_242 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '2.5') THEN BEGIN

           iAT_251 = Round( nMenge , 0);   -- Anz. Jahre  
           iAT_252 = Round( nTotal , 0);

        END

     END 


     -- Alle Anzuege ----------------------------------------

     FOR SELECT SS.SAL_CODE,
         SUM(D.SAD_BEITRAGAN)

         FROM EMP_EMPLOYEE E

         INNER JOIN EMY_EMPLOYMENTPERIOD    Y ON Y.EMY_EMPUID = E.EMP_UID
         INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID
         INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
         LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID
         LEFT OUTER JOIN SAL_SALARYSTATEMENT SS ON SS.SAL_UID = T.SDT_Z_SALUID
         LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID
         LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID

         WHERE (E.EMP_UID=:iEmpUid) AND (A.PRA_ISTVERBUCHT = 1) AND
               (T.SDT_Z_SALUID IS NOT NULL) AND (M.PRM_MONAT > 0) AND
               (T.SDT_TYP = 'A') 

         GROUP BY SS.SAL_CODE
     
         INTO :sSalCode,
              :nTotal
     DO BEGIN
     
        IF (sSalCode IS NULL) THEN 
           sSalCode = '';

        IF ( Trim(sSalCode) = '3.1') THEN BEGIN

           iAT_31 = Round( nTotal , 0);
  
        END ELSE IF ( Trim(sSalCode) = '3.2') THEN BEGIN

           iAT_32 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3.3') THEN BEGIN

           iAT_33 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3.4') THEN BEGIN

           iAT_34 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3.5') THEN BEGIN

           iAT_35 = Round( nTotal , 0);

        END ELSE IF ( Trim(sSalCode) = '3.6') THEN BEGIN

           iAT_362 = Round( nTotal , 0); 

        END

    END


    -------------------------------------------------------------------------------------
    -- Texte fuer AT-ZusatzBlatt -> Keine Textvorlagen am Mitarbeiter                  --
    -------------------------------------------------------------------------------------

    --------- Text: AT Punkt "1D).5" ----- 

    SELECT PS_LA_TEXT 
          FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, 'Z' ,'1D).5', '' )
    INTO :sAT_1D51;


    --------- Text: AT Punkt "2.4" ----- 

    SELECT PS_LA_TEXT 
          FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, 'Z' ,'2.4', '' )
    INTO :sAT_241;

    --------- Text: AT Punkt "3.6" ----- 

    SELECT PS_LA_TEXT 
          FROM SP_SAR_CALCEMPLOYEE_HLP ( :iEmpUid, 'Z' ,'3.6', '' )
    INTO :sAT_361;



  END


        
  --  Update Values  -------------------------------------------------
  EXECUTE PROCEDURE SP_SAR_UPDATE (
          :PI_SARUID,
          :bIsAuswCH,
          :bFL_A,
          :bFL_B,
          :sFL_C,
                    :sCH_C,
          :iFL_D,         
          :dFL_E1,         
          :dFL_E2,         
          :bFL_F,
          :bFL_G,
          :iFL_1,
          :iFL_21,
          :iFL_22,
          :sFL_23,
          :iFL_23,
          :sFL_3,
          :iFL_3,
          :sFL_4,
          :iFL_4,
          :iFL_5,
          :sFL_6,
          :iFL_6,
          :sFL_7,
          :iFL_7,
          :iFL_9,
          :iFL_101,
          :iFL_102,
          :iFL_12,
          :bFL_1310,
          :iFL_1311,
          :sFL_1312,
          :iFL_1312,
          :iFL_1321,
          :iFL_1322,
          :sFL_1323,
          :iFL_1323,
          :iFL_133,
          :sFL_14,
          :sFL_15,
          :sFL_Ort,
          :sFL_Fir,
          :iAT_1A,
          :iAT_1B1,
          :iAT_1B2,
          :iAT_1B3,
          :iAT_1B4,
          :iAT_1B5,
          :iAT_1B6,
          :iAT_1B7,
          :iAT_1C1,
          :iAT_1C21,
          :iAT_1C22,
          :iAT_1C31,
          :iAT_1C32,
          :iAT_1C4,
          :iAT_1D1,
          :iAT_1D2,
          :iAT_1D3,
          :iAT_1D4,
          :sAT_1D51, 
          :iAT_1D52,
          :iAT_21,
          :iAT_22,
          :iAT_23,
          :sAT_241,
          :iAT_242,
          :iAT_251,
          :iAT_252,
          :iAT_31,
          :iAT_32,
          :iAT_33,
          :iAT_34,
          :iAT_35,
          :sAT_361,
          :iAT_362,
          :PI_APP_ACTIVEUSER);


END!!
COMMIT!!

--FS#633:END

-- +++

-- FS#632:START - PKLohn - Changes in Report "Jahresabrechnung PK.fr3"

create or alter procedure SP_RPT_PERIOD_HLP 
(
    PI_EMYUID DI_UID,
    PS_INT_TYP DS_STR3
)
returns (
    EMP_UID DI_UID,
    SAX_UID DI_UID,
    EMY_UID DI_UID,
    EMY_PJANFANG DD_DATE,
    EMY_PJENDE DD_DATE,
    EMY_BESGRAD DN_NUMBER2,
    EMY_ISUNEMPLOYED DB_BOOLEAN,
    BRUTTOLOHN DN_NUMBER2,
    FREIBETRAG DN_NUMBER2,
    PFLICHTLOHN DN_NUMBER2,
    BEITRAGAG DN_NUMBER2,
    BEITRAGAN DN_NUMBER2)
as
declare variable BOK DI_SMLINT;
declare variable IBUYUID DN_NUMBER2;
declare variable NPFLICHT DN_NUMBER2;
declare variable NBEITRAGAG DN_NUMBER2;
declare variable NBEITRAGAN DN_NUMBER2;
declare variable NFREIBETRAG DN_NUMBER2;
BEGIN
     
    SELECT EMY_UID,EMY_PJANFANG,EMY_PJENDE,EMY_BESGRAD,EMY_ISUNEMPLOYED FROM EMY_EMPLOYMENTPERIOD
        WHERE EMY_UID=:PI_EMYUID
    INTO :EMY_UID,:EMY_PJANFANG,:EMY_PJENDE,:EMY_BESGRAD,:EMY_ISUNEMPLOYED;

    -- Bruttolohn fuer Periode rechnen  --------------------------------------------
    SELECT SUM(D.SAD_TOTAL) 

       FROM EMY_EMPLOYMENTPERIOD Y   

       INNER JOIN SAY_SALARY              S ON S.SAY_EMYUID = Y.EMY_UID               
       INNER JOIN SAD_SALARYDETAIL        D ON D.SAD_SAYUID = S.SAY_UID
       LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T ON T.SDT_UID    = D.SAD_SDTUID 
       LEFT  JOIN PRA_PAYROLLACCOUNT      A ON A.PRA_UID    = S.SAY_PRAUID        
       LEFT  JOIN PRM_PAYROLLMONTH        M ON M.PRM_UID    = A.PRA_PRMUID      

    WHERE (Y.EMY_UID=:PI_EMYUID) AND (A.PRA_ISTVERBUCHT = 1) AND
          (T.SDT_TYP = 'L') AND (T.SDT_ISTLOHNTEIL = 1)

    INTO :BRUTTOLOHN;   


    -- Basis(pflichtiger Lohn) und Beitraege rechnen ------------------------------
    bOk = 0;


    SELECT E.EMP_BUYUID FROM EMY_EMPLOYMENTPERIOD Y
      LEFT JOIN EMP_EMPLOYEE E ON E.EMP_UID=Y.EMY_EMPUID
        WHERE Y.EMY_UID=:PI_EMYUID
    INTO :iBuyUId;

    FOR SELECT DISTINCT TX.SAX_UID
        FROM EMP_EMPLOYEE E   
        INNER JOIN EMY_EMPLOYMENTPERIOD Y ON Y.EMY_EMPUID=E.EMP_UID
        INNER JOIN SAY_SALARY              S  ON S.SAY_EMYUID = Y.EMY_UID
        INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SAYUID = S.SAY_UID
        LEFT  JOIN SDT_SALARYDEDUCTIONTYPE T  ON T.SDT_UID    = D.SAD_SDTUID
        LEFT  JOIN INT_INSTITUTIONTYPE     TI ON TI.INT_UID   = T.SDT_INTUID
        LEFT  JOIN SAX_SALARYCATEGORIE     TX ON TX.SAX_UID   = T.SDT_SAXUID
        LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
        LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
        WHERE (E.EMP_BUYUID=:iBuyUId) AND (A.PRA_ISTVERBUCHT = 1) AND
              (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) AND
              (TI.INT_TYP=:PS_INT_TYP)

        ORDER BY TX.SAX_UID
        INTO :SAX_UID

    DO BEGIN

       bOk = 1;

       NPFLICHT    = 0.0;
       NBEITRAGAG  = 0.0;
       NBEITRAGAN  = 0.0;
       NFREIBETRAG = 0.0;


       --  Alle Lohnarten "Prozent von BASIS" ------------------------------------------
       SELECT SUM(D.SAD_BASIS),
              SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN),
              MAX(D.SAD_FREIBETRAG)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE in (2,3,4)) 
             AND (Y.EMY_UID=:PI_EMYUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NPFLICHT,:NBEITRAGAG,:NBEITRAGAN, :NFREIBETRAG;

       IF (NPFLICHT    IS NULL) THEN NPFLICHT    = 0.0;        
       IF (NBEITRAGAG  IS NULL) THEN NBEITRAGAG  = 0.0;        
       IF (NBEITRAGAN  IS NULL) THEN NBEITRAGAN  = 0.0;        
       IF (NFREIBETRAG IS NULL) THEN NFREIBETRAG = 0.0; 

       PFLICHTLOHN   = NPFLICHT;
       BEITRAGAG     = NBEITRAGAG;
       BEITRAGAN     = NBEITRAGAN;
       FREIBETRAG    = NFREIBETRAG;


       --  Alle Lohnarten NICHT "Prozent von BASIS" ------------------------------------
       NPFLICHT   = 0.0;
       NBEITRAGAG = 0.0;
       NBEITRAGAN = 0.0;

       SELECT SUM(D.SAD_BEITRAGAG),
              SUM(D.SAD_BEITRAGAN)

       FROM SDT_SALARYDEDUCTIONTYPE T

       LEFT  JOIN SCT_SALARYCALCTYPE      C  ON C.SCT_UID    = T.SDT_SCTUID
       INNER JOIN SAD_SALARYDETAIL        D  ON D.SAD_SDTUID = T.SDT_UID
       LEFT  JOIN SAY_SALARY              S  ON S.SAY_UID    = D.SAD_SAYUID
       LEFT  JOIN PRA_PAYROLLACCOUNT      A  ON A.PRA_UID    = S.SAY_PRAUID
       LEFT  JOIN PRM_PAYROLLMONTH        M  ON M.PRM_UID    = A.PRA_PRMUID
       LEFT  JOIN EMY_EMPLOYMENTPERIOD    Y  ON Y.EMY_UID    = S.SAY_EMYUID
       LEFT  JOIN EMP_EMPLOYEE            E  ON E.EMP_UID    = Y.EMY_EMPUID

       WHERE (T.SDT_SAXUID = :SAX_UID) AND (T.SDT_TYP = 'A') AND (T.SDT_ISTLOHNTEIL = 1) 
             AND (C.SCT_CALCTYPE not in (2,3,4)) 
             AND (Y.EMY_UID=:PI_EMYUID) AND (A.PRA_ISTVERBUCHT = 1)
             AND ((D.SAD_ANSATZAN <> 0.0) OR (D.SAD_ANSATZAG <> 0.0))
        
       INTO :NBEITRAGAG,:NBEITRAGAN;

       IF (NBEITRAGAG IS NULL) THEN NBEITRAGAG = 0.0;        
       IF (NBEITRAGAN IS NULL) THEN NBEITRAGAN = 0.0;        

       --  Total fuer Rueckgabe ---------------------------------------------------------

       PFLICHTLOHN   = PFLICHTLOHN + NPFLICHT;
       BEITRAGAG     = BEITRAGAG   + NBEITRAGAG;
       BEITRAGAN     = BEITRAGAN   + NBEITRAGAN;


       SUSPEND;

    END
  

    -- Bruttolohn zurueckgaben, falls keine Abzuege (zB bei STE)
    IF (bOk = 0) THEN 
       SUSPEND;

END!!
COMMIT!!

-- FS#632:END

-- +++

-- FS#634:START - PKLohn - Where is the automatic tax calculation logic

CREATE OR ALTER PROCEDURE sp_Say_GetAgrDataByEmy
(
  pi_EmyUId     DI_UID,
  pi_SdtUId     DI_UID,
  pi_Month      DI_INT
)
RETURNS
(
  dMinStartDate           DD_DATE,
  dMaxStartDate           DD_DATE,
  dMaxEndDate             DD_DATE,
  nGrossWage              DN_NUMBER2,
  nGrossWageCurMonth      DN_NUMBER2
)
AS

  -- Get aggregate salary data ( gross wage and salary period )
  
  DECLARE iBerechBasisNr    DI_SMLINT;

BEGIN
  
  SELECT MIN( say_DatumVom   ),
         MAX( say_DatumVom   ),
         MAX( say_DatumBis   )
    FROM say_Salary
    LEFT JOIN pra_PayrollAccount ON pra_UId = say_PraUId
    LEFT JOIN prm_PayrollMonth   ON prm_UId = pra_PrmUId
   WHERE say_EmyUId = :pi_EmyUId 
     AND (
            ( :pi_Month = 0 AND prm_Monat <= 0  )
            OR
            ( prm_Monat BETWEEN 1 AND :pi_Month )
         )
    INTO :dMinStartDate,
         :dMaxStartDate,
         :dMaxEndDate;         
         
   -- Get BasisNo from SalaryDeducation_Typ  
   SELECT sdt_BerechBasisNr 
     FROM sdt_SalaryDeductionType 
    WHERE sdt_UId= :pi_SdtUId 
     INTO :iBerechBasisNr;

         
  EXECUTE STATEMENT  
      'SELECT SUM( sad_Total )
         FROM say_Salary                       
         LEFT JOIN pra_PayrollAccount       ON pra_UId    = say_praUId 
         LEFT JOIN prm_PayrollMonth         ON prm_UId    = pra_prmUId 
        INNER JOIN sad_SalaryDetail        ON sad_sayUID = say_UId    
         LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_sdtUId 
        WHERE say_emyUId       = ' || :pi_EmyUId       ||
       '  AND sdt_Typ          = ''L'''                ||
       '  AND sdt_Basis'           || :iBerechBasisNr  || ' = 1
          AND (
                ( '||:pi_Month ||' = 0 AND prm_Monat <= 0   )
                OR
                ( prm_Monat BETWEEN 1 AND '|| :pi_Month || ')
             ) '
    INTO :nGrossWage;


    EXECUTE STATEMENT  
      'SELECT SUM( sad_Total )
         FROM say_Salary                       
         LEFT JOIN pra_PayrollAccount       ON pra_UId    = say_praUId 
         LEFT JOIN prm_PayrollMonth         ON prm_UId    = pra_prmUId 
        INNER JOIN sad_SalaryDetail        ON sad_sayUID = say_UId    
         LEFT JOIN sdt_SalaryDeductionType ON sdt_UId    = sad_sdtUId 
        WHERE say_emyUId       = ' || :pi_EmyUId       ||
       '  AND sdt_Typ          = ''L'''                ||
       '  AND sdt_Basis'           || :iBerechBasisNr  || ' = 1
          AND '||:pi_Month ||' > 0 AND prm_Monat = '|| :pi_Month
    INTO :nGrossWageCurMonth;
    
  IF ( nGrossWageCurMonth IS NULL ) THEN
    nGrossWageCurMonth = 0;    
  
  SUSPEND;
  
END!!

COMMENT ON PROCEDURE sp_Say_GetAgrDataByEmy IS 'Get aggregate salary data ( gross wage and salary period )'!!
COMMENT ON PARAMETER sp_Say_GetAgrDataByEmy.pi_EmyUId IS 'Employement period UId'!!
COMMENT ON PARAMETER sp_Say_GetAgrDataByEmy.pi_SdtUId IS 'Salary deduction type UId'!!
COMMENT ON PARAMETER sp_Say_GetAgrDataByEmy.pi_Month  IS 'Month number'!!
COMMIT!!

-- FS#634:END

-- +++

-- FS#635:START - Close Accounting Form - Improvement for FibuBeleg

UPDATE OR INSERT INTO LUK_LOOKUP ( LUK_GRUPPE, LUK_CODE, LUK_BEZEICHNUNG, LUK_ISTDEFAULT, LUK_ISTAKTIV, LUK_CREATEDATE, LUK_CREATEUSRUID, LUK_MUTDATE, LUK_MUTUSRUID )
VALUES ( 'BUY_SAGE', '3', 'Nur AN-Beiträge', 0, 1, Current_Timestamp, 1, Current_Timestamp, 1 )
MATCHING (luk_Gruppe, luk_Code)!!
COMMIT!!

EXECUTE PROCEDURE sp_DDL_SafeDropFK 'CHK_BUY_SAGE_KONTIERUNGTYPT'!!
COMMIT!!

ALTER TABLE BUY_BUSINESSYEAR Add CONSTRAINT CHK_BUY_SAGE_KONTIERUNGTYPT CHECK ( buy_Sage_KontierungTyp IN ( '0', '1', '2','3' ) )!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_Fibubeleg_Det
(
    pi_PraUId DI_UID
)
RETURNS 
(
    say_UId     DI_UID,
    say_EmyUId  DI_UID,
    acn_UId     DI_UID,
    grp_Id      DI_UID,
    sdt_UId     DI_UID,
    konto       DS_BANK,
    ist_Ag      DB_BOOLEAN,
    ist_An      DB_BOOLEAN,
    betrag      DN_NUMBER2
)
AS
  DECLARE VARIABLE NBETRAGAG DN_NUMBER2;
  DECLARE VARIABLE NTOTAL DN_NUMBER2;
  DECLARE VARIABLE NBETRAGAN DN_NUMBER2;
  DECLARE VARIABLE SKONTOS DS_STR13;
  DECLARE VARIABLE SKONTOH DS_STR13;
  DECLARE VARIABLE IKONTOS DI_UID;
  DECLARE VARIABLE IKONTOH DI_UID;
  DECLARE VARIABLE SKONTOTMP DS_BANK;
  DECLARE VARIABLE SBANK DS_BANK;
  DECLARE VARIABLE SLART DS_STR5;
  DECLARE VARIABLE SLARTTYP DS_ONECHARFLAG;
  DECLARE VARIABLE BISTLOHN DB_BOOLEAN;
BEGIN

  -- Alle Detail-BetrÃ¤ge gesplittet nach AG/AN / Bank usw.  

  FOR
  
    SELECT say_UId,  say_EmyUId
      FROM say_Salary
     WHERE say_PraUId = :pi_PraUId  
      INTO :say_UId, :say_EmyUId

  DO 
  BEGIN
    
   /* 1. Alle FirmenBanken des Mitarbeiters mit AZ-betrag */
   
    FOR
    
      SELECT az_betrag,                       acn_Konto, 
             COALESCE( ban_Code, 'BANK_AG' ), fib_AcnUId 
        FROM sp_Pra_PaymentOrders_Emp( :pi_PraUId, :say_EmyUId )
        LEFT JOIN fib_Firmbank      ON fib_UId = emb_FibUId
        LEFT JOIN ban_Bank          ON ban_UId = fib_BanUId
        LEFT JOIN acn_AccountNumber ON acn_UId = fib_AcnUId      
        INTO :nBetragAG,  :sKontoH,  
             :sBank,      :acn_UId
    DO 
    BEGIN

      IF ( ( nBetragAG IS NOT NULL ) AND ( nBetragAG > 0.0 ) ) THEN 
      BEGIN

        sdt_UId = -1;

        ist_Ag  = 1;
        IST_AN  = 0;

        grp_Id  = -99;        

        IF ( ( sKontoH  IS NULL ) OR ( sKontoH = '' ) )  THEN 
        BEGIN

          konto      = sBank;
          acn_UId    = -1;
          betrag     = 0-nBetragAG;

          SUSPEND;

        END 
        ELSE 
        BEGIN

          IST_AN     = 1;
          konto      = sKontoH;
          betrag     = 0-nBetragAG;

          SUSPEND;

        END 

             
      END 

    END


    /* 2. Alle Lohn und Abzugsarten des Mitarbeiters */


    FOR 
    
      SELECT  t.sdt_UId,                          t.sdt_Typ,                        
              t.sdt_LArt,                         t.sdt_IstLohnTeil,  
              COALESCE( sd.sad_BeitragAg, 0.0 ),  COALESCE( sd.sad_BeitragAn, 0.0 ), 
              COALESCE( sd.sad_TOTAL,     0.0 ),
              t.sdt_Soll_AcnUId,                  t.sdt_Haben_AcnUId, 
              ks.acn_Konto AS konto_Soll,         kh.acn_Konto AS konto_Haben

        FROM sad_SalaryDetail sd

        LEFT JOIN sdt_SalaryDeductionType t ON t.sdt_UId  = sd.sad_SdtUId
        LEFT JOIN acn_AccountNumber ks      ON ks.acn_UId = t.sdt_Soll_AcnUId
        LEFT JOIN acn_AccountNumber kh      ON kh.acn_UId = t.sdt_Haben_AcnUId

       WHERE sd.sad_SayUId = :say_UId
        INTO  :sdt_UId,                           :sLArtTyp,          
              :sLArt,                             :bIstLohn,          
              :nBetragAG,                         :nBetragAN,
              :nTotal,
              :iKontoS,                           :iKontoH,           
              :sKontoS,                           :sKontoH
              
    DO 
    BEGIN      
      

      IST_AN  = 0;
      grp_Id  = say_EmyUId; 

      IF ( sLArtTyp = 'L' ) THEN 
      BEGIN         

        -- Bei den Lohnarten Taggeld, wird der BeitragAG nicht geschrieben
        -- der Wert ist im Feld SAD_TOTAL
        IF ( ( nBetragAG = 0.0 ) AND ( nBetragAN = 0.0 ) AND ( nTotal <> 0.0 ) ) THEN 
        BEGIN
           nBetragAG = nTotal;
        END


        ist_Ag  = 1;

        IF ( ( sKontoS IS NULL ) OR ( sKontoS = '' ) ) THEN 
        BEGIN

          sKontoTmp = sLArt || '_AG';
          acn_UId   = -1;

        END 
        ELSE 
        BEGIN

          sKontoTmp = sKontoS;
          acn_UId   = iKontoS;

        END

        IF ( nBetragAG <> 0.0 ) THEN 
        BEGIN         

          IST_AN  = 1;
          konto   = sKontoTmp;
          betrag  = nBetragAG;

          SUSPEND;

          IF ( ( sKontoH IS NOT NULL ) AND ( sKontoH <> '' ) ) THEN 
          BEGIN

            konto   = sKontoH;
            acn_UId = iKontoH;
            betrag  = 0-nBetragAG;

            SUSPEND;

          END  

        END

      END 
      ELSE 
      BEGIN

        IF ( nBetragAG <> 0.0 ) THEN 
        BEGIN         
     
          ist_Ag  = 1;

          IF ( ( sKontoS IS NULL ) OR ( sKontoS = '' ) ) THEN 
          BEGIN

            sKontoS  = sLArt || '_AG';
            acn_UId  = -1;

          END 
          ELSE 
          BEGIN
          
            acn_UId  = iKontoS;
              
          END


          IF ( ( sKontoH IS NULL ) OR ( sKontoH = '' ) ) THEN 
          BEGIN

            sKontoTmp = sLArt || '_AG';

          END 
          ELSE 
          BEGIN

            sKontoTmp = sKontoH;
            acn_UId   = iKontoH;

          END

           
          /* Soll-Buchung */
          konto   = sKontoS;
          betrag  = nBetragAG;

          SUSPEND;
           

          /* Haben-Buchung */
          konto   = sKontoTmp;
          betrag  = 0-nBetragAG;

          SUSPEND;

        END

        IF ( nBetragAN <> 0.0 ) THEN 
        BEGIN         

          ist_Ag  = 0;
          IST_AN  = 1;

          IF ( ( sKontoH IS NULL ) OR ( sKontoH = '' ) ) THEN 
          BEGIN

            sKontoTmp = sLArt || '_AN';
            acn_UId  = -1;

          END 
          ELSE 
          BEGIN

            sKontoTmp = sKontoH;
            acn_UId   = iKontoH;

          END

          /* Haben-Buchung */
          konto     = sKontoTmp;
          betrag    = 0-nBetragAN;

          SUSPEND;
         
        END 

      END

    END

  END

END!!
COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_Fibubeleg
(
    pi_PraUId     DI_UID,
    ps_AusgabeTyp DS_ONECHARFLAG
)
RETURNS 
(
    konto       DS_BANK,
    konto_Bez   DS_STR50,
    sh          DS_ONECHARFLAG,
    betrag      DN_NUMBER2,
    text1       DS_STR128,
    text2       DS_STR128
)
AS
DECLARE VARIABLE NBETRAG DN_NUMBER2;
DECLARE VARIABLE IMONAT DI_UID;
DECLARE VARIABLE SMONAT DS_STR15;
DECLARE VARIABLE IGRP_ID DI_UID;
DECLARE VARIABLE ISDT_UID DI_UID;
DECLARE VARIABLE SSDT_TYP DS_ONECHARFLAG;
DECLARE VARIABLE SSDT_LART DS_STR5;
DECLARE VARIABLE SSDT_BEZ DS_DESCR;
DECLARE VARIABLE BSDT_ISTLOHN DB_BOOLEAN;
DECLARE VARIABLE IEMP_PERSNR DI_INT;
DECLARE VARIABLE SEMP_NAME DS_STR50;
DECLARE VARIABLE SEMP_VORNAME DS_STR50;
DECLARE VARIABLE IIST_AG DI_INT;
DECLARE VARIABLE IBUYUID DI_INT;
BEGIN

  /*  ps_AusgabeTyp 1= Zusammen pro Firma   */
  /*                2= Zusammen pro MA      */
  /*                3= Detailliert pro MA   */
  /*                4= Nur AN-Beitraege     */

  sMonat = '';
  
  SELECT prm_Monat,prm_BUYUID 
    FROM pra_PayrollAccount
    LEFT JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :iMonat,:iBuyUID;

  IF ( iMonat = 1 ) THEN
    sMonat = 'Januar';
  ELSE 
  IF ( iMonat = 2 ) THEN
    sMonat = 'Februar';
  ELSE 
  IF ( iMonat = 3 ) THEN
    sMonat = 'März';
  ELSE 
  IF ( iMonat = 4 ) THEN
    sMonat = 'April';
  ELSE 
  IF ( iMonat = 5 ) THEN
    sMonat = 'Mai';
  ELSE 
  IF ( iMonat = 6 ) THEN
    sMonat = 'Juni';
  ELSE 
  IF ( iMonat = 7 ) THEN
    sMonat = 'Juli';
  ELSE 
  IF ( iMonat = 8 ) THEN
    sMonat = 'August';
  ELSE 
  IF ( iMonat = 9 ) THEN
    sMonat = 'September';
  ELSE 
  IF ( iMonat = 10 ) THEN
    sMonat = 'Oktober';
  ELSE 
  IF ( iMonat = 11 ) THEN
    sMonat = 'November';
  ELSE 
  IF ( iMonat = 12 ) THEN
    sMonat = 'Dezember';  

  IF ( ps_AusgabeTyp = '1' )  THEN
  BEGIN
     
    text1 = 'Löhne ' || sMonat;
    text2 = '';

        
    FOR 
      SELECT konto, SUM( betrag ) 
        FROM sp_Pra_Fibubeleg_Det( :pi_PraUId )
       GROUP BY konto
        INTO :konto, :nBetrag

    DO 
    BEGIN

      -- Kontobezeichnung ermitteln 
      KONTO_BEZ = NULL;
      SELECT ACN_BEZEICHNUNG 
          FROM ACN_ACCOUNTNUMBER
          WHERE ACN_BUYUID=:iBuyUID AND ACN_KONTO=:konto
      INTO :KONTO_BEZ;


      IF ( nBetrag < 0.0 ) THEN 
      BEGIN
        sh     = 'H';
        betrag = ABS(nBetrag);
      END 
      ELSE 
      BEGIN
        
        sh     = 'S';
        betrag = nBetrag;
        
      END           

      SUSPEND;
      
    END


  END 
  ELSE 
  IF ( ps_AusgabeTyp = '2' ) THEN 
  BEGIN

    FOR 
    
      SELECT konto, grp_Id, sdt_UId, SUM( betrag ) 
        FROM sp_Pra_Fibubeleg_Det( :pi_PraUId )
       GROUP BY konto, grp_Id, sdt_UId
        INTO :konto, :iGrp_Id, :iSdt_UId, :nBetrag

    DO 
    BEGIN

      -- Kontobezeichnung ermitteln 
      KONTO_BEZ = NULL;
      SELECT ACN_BEZEICHNUNG 
          FROM ACN_ACCOUNTNUMBER
          WHERE ACN_BUYUID=:iBuyUID AND ACN_KONTO=:konto
      INTO :KONTO_BEZ;

      IF ( iGrp_Id > 0 ) THEN 
      BEGIN

        SELECT sdt_Typ,   sdt_LArt,   sdt_Bezeichnung, sdt_IstLohnTeil 
          FROM sdt_SalaryDeductionType
         WHERE sdt_UId = :iSdt_UId
          INTO :sSdt_Typ, :sSdt_LArt, :sSdt_Bez,       :bSdt_IstLohn;

              
        SELECT emp_PersNr,    emp_Name,   emp_Vorname
          FROM emy_EmploymentPeriod
          LEFT JOIN emp_Employee ON emp_UId = emy_EmpUId
         WHERE emy_UId = :iGrp_Id
          INTO :iEmp_PersNr, :sEmp_Name, :sEmp_Vorname;

        text2 = sEmp_Name || ' ' || sEmp_Vorname;

        IF ( sSdt_Typ = 'L' ) THEN 
        BEGIN

          IF ( bSdt_IstLohn = 1 ) THEN          
            text1 = sSdt_Bez || ' ' || sMonat;          
          ELSE
            text1 = sSdt_LArt || '-Beitrag '|| sMonat;
            
        END 
        ELSE 
        BEGIN

          text1 = sSdt_LArt || '-Beitrag '|| sMonat;

        END

      END 
      ELSE 
      BEGIN
             
        text1 = 'Löhne '||sMonat;

      END
  

      IF (nBetrag < 0.0) THEN 
      BEGIN
      
        sh     = 'H';
        betrag = ABS(nBetrag);
        
      END 
      ELSE 
      BEGIN
      
        sh     = 'S';
        betrag = nBetrag;
        
      END           

      SUSPEND;
      
    END

  END 
  ELSE 
  IF ( ps_AusgabeTyp = '3' ) THEN 
  BEGIN

    FOR 
    
      SELECT konto,   grp_Id,   sdt_UId,   ist_Ag,  SUM(betrag) 
        FROM sp_Pra_Fibubeleg_Det( :pi_PraUId )
       GROUP BY konto,grp_Id,sdt_UId,ist_Ag
        INTO :konto, :iGrp_Id, :iSdt_UId, :iIst_Ag, :nBetrag

    DO 
    BEGIN

      -- Kontobezeichnung ermitteln 
      KONTO_BEZ = NULL;
      SELECT ACN_BEZEICHNUNG 
          FROM ACN_ACCOUNTNUMBER
          WHERE ACN_BUYUID=:iBuyUID AND ACN_KONTO=:konto
      INTO :KONTO_BEZ;


      IF ( iGrp_Id > 0 ) THEN
      BEGIN

        SELECT sdt_Typ,  sdt_LArt,   sdt_Bezeichnung, sdt_IstLohnTeil 
          FROM sdt_SalaryDeductionType
         WHERE sdt_UId = :iSdt_UId
          INTO :sSdt_Typ,:sSdt_LArt, :sSdt_Bez,       :bSdt_IstLohn;

              
        SELECT emp_PersNr,    emp_Name,   emp_Vorname 
          FROM emy_EmploymentPeriod
          LEFT JOIN emp_Employee ON emp_UId = emy_EmpUId
         WHERE emy_UId = :iGrp_Id
          INTO :iEmp_PersNr, :sEmp_Name,  :sEmp_Vorname;

        text2 = sEmp_Name || ' ' || sEmp_Vorname;

        IF ( sSdt_Typ = 'L' ) THEN 
        BEGIN

          IF ( bSdt_IstLohn = 1 ) THEN
            text1 = sSdt_Bez || ' ' || sMonat;
          ELSE
            text1 = sSdt_LArt || '-Beitrag AG '|| sMonat;
          
        END 
        ELSE 
        BEGIN

          IF (iIst_Ag = 1) THEN
            text1 = sSdt_LArt || '-Beitrag AG '|| sMonat;
          ELSE
            text1 = sSdt_LArt || '-Beitrag AN '|| sMonat;
            
          
        END
        
      END 
      ELSE 
      BEGIN

        text1 = 'Löhne '||sMonat;

      END
  

      IF ( nBetrag < 0.0 ) THEN 
      BEGIN
            sh     = 'H';
            betrag = ABS(nBetrag);
      END 
      ELSE 
      BEGIN
      
        sh     = 'S';
        betrag = nBetrag;
        
      END           

      SUSPEND;
      
    END
    
  END
  ELSE 
  IF ( ps_AusgabeTyp = '4' ) THEN 
  BEGIN

    text1 = 'Löhne ' || sMonat;
    text2 = '';

        
    FOR 
      SELECT konto, SUM( betrag ) 
        FROM sp_Pra_Fibubeleg_Det( :pi_PraUId )
       WHERE IST_AN = 1 OR ( SDT_UID = -1 AND GRP_ID = -99 )
       GROUP BY konto
        INTO :konto, :nBetrag

    DO 
    BEGIN

      -- Kontobezeichnung ermitteln 
      KONTO_BEZ = NULL;
      SELECT ACN_BEZEICHNUNG 
          FROM ACN_ACCOUNTNUMBER
          WHERE ACN_BUYUID=:iBuyUID AND ACN_KONTO=:konto
      INTO :KONTO_BEZ;


      IF ( nBetrag < 0.0 ) THEN 
      BEGIN
        sh     = 'H';
        betrag = ABS(nBetrag);
      END 
      ELSE 
      BEGIN
        
        sh     = 'S';
        betrag = nBetrag;
        
      END           

      SUSPEND;
      
    END

  END
     
END!!
COMMIT!!

-- FS#635:END

-- +++

--FS#636:START - PKLohn - Delete Accounting if no SAY entry attached

CREATE OR ALTER PROCEDURE sp_Pra_CanBeDeleted
(
  pi_PraUId     DI_UID
)
RETURNS
(
  canBeDeleted  DB_BOOLEAN
)
AS

  -- Check if payroll account can be deleted
  
  DECLARE iBuyUId     DI_UID;
  DECLARE iPrmMonat   DI_SMLINT;
  DECLARE iPrmAbreNr  DI_SMLINT;
  DECLARE iCount      DI_INT;

BEGIN

  SELECT prm_BuyUId, prm_Monat, prm_AbreNr
    FROM pra_PayrollAccount
    JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE pra_UId = :pi_PraUId
    INTO :iBuyUId, :iPrmMonat, :iPrmAbreNr;
  
  SELECT COUNT(1)
    FROM pra_PayrollAccount
    JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
   WHERE prm_BuyUId = :iBuyUId
     AND pra_IstVerbucht = 0
     AND prm_Monat > 0
     AND ( prm_Monat > :iPrmMonat OR prm_AbreNr > :iPrmAbreNr )
    INTO :iCount;
  
  canBeDeleted = IIF( iCount >= 1, 0, 1 );
  
END!!

COMMENT ON PROCEDURE sp_Pra_CanBeDeleted IS 'Check if payroll account can be deleted'!!
COMMENT ON PARAMETER sp_Pra_CanBeDeleted.pi_PraUId IS 'Payroll account UId'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_CheckNextAccount 
(
  pi_BuyUId DI_UID,  -- Business Year Id
  pi_UsrUId DI_UID   -- Application active user Id
)
RETURNS 
(
  pi_PraUId DI_UID
)
AS

  -- This procedure determines the UID of the next billing to be processed.
  --
  -- If the next account is not yet created, it will be automatically generated and the pra_UId of 
  -- the new account will be returned.                                             
  --                                                               
  -- If all invoices are fixed(verbucht) and no further invoices more exist, the pra_UId of the last 
  -- account is returned (if grouping is active, all groups will be inserted)         

  DECLARE VARIABLE iPrmFirst       DI_UID;
  DECLARE VARIABLE iPraUId         DI_UID;
  DECLARE VARIABLE iPrmUId         DI_UID;
  DECLARE VARIABLE iPrgUId         DI_UID;
  DECLARE VARIABLE bPraIstVerbucht DB_BOOLEAN;
  DECLARE VARIABLE iPrmMonat       DI_SMLINT;
  DECLARE VARIABLE iAnzAHL         DI_INT;
  DECLARE VARIABLE iLcMonat        DI_SMLINT;
  DECLARE VARIABLE iLcPraUId       DI_UID;
  DECLARE VARIABLE iLcPrmUId       DI_UID;
  DECLARE VARIABLE iLcPrgUId       DI_INT;
  DECLARE VARIABLE iNewPraUId      DI_INT;
  DECLARE VARIABLE bIstOK          DB_BOOLEAN;
  DECLARE VARIABLE bIstFound       DB_BOOLEAN;
  DECLARE VARIABLE dPrmAzDatum     DD_DATE;
  
BEGIN

  -- Letzte Verbuchte Abrechnung suchen und alle nicht verbuchten und leeren Abrechnungen entfernen 
  iLcMonat  = 0;
  iPrmFirst = 0;
  iLcPrmUId = 0;
   
  FOR 
    SELECT prm_Monat,  pra_UId,         pra_PrmUId, 
           pra_PrgUId, pra_IstVerbucht, pra_AnzMitInabre 
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
     WHERE prm_BuyUId = :pi_BuyUId 
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr
      INTO :iPrmMonat, :iPraUId,         :iPrmUId,
           :iPrgUId,   :bPraIstVerbucht, :iAnzAHL
  DO 
  BEGIN

    --- Hold first prm_UId in the Year   
    IF ( iPrmFirst = 0 ) THEN 
      iPrmFirst = iPrmUId;


    IF ( bPraIstVerbucht = 1 ) THEN 
    BEGIN

      --- Hold last Closed PayrollAccont in then Year

      iLcPraUId = iPraUId;
      iLcPrmUId = iPrmUId;
      iLcPrgUId = iPrgUId;
      iLcMonat  = iPrmMonat;

    END

  END


   -- Alle Abrechnungen zuletzt verbuchten Monats bzw. Folgemonats anlegen, 
   -- falls Abrechnungen noch nicht anlegeleg

   -- Keine verbuchte Abrechnung im Jahr gefunden
   
  IF ( iLcMonat = 0 ) THEN 
  BEGIN       
    iLcMonat  = 1;
    iLcPrmUId = 0;
  END

   
  bIstFound = 0;
  
  -- Wenn noch gar keine Abrechnung angelegt ist
  
  IF ( iPrmFirst = 0 ) THEN 
  BEGIN        
    bIstFound = 1;
    iLcPrmUId = 0;
  END

  bIstOK    = 0;
  
  FOR 
    SELECT prm_UId,   prg_UId, prm_AzDatum, 
           prm_Monat, pra_UId, pra_IstVerbucht 
      FROM sp_Pra_AccountList ( :pi_BuyUId )
     WHERE prm_Monat >= :iLcMonat 
       AND prm_Monat <= ( :iLcMonat + 1 )
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe      
      INTO :iPrmUId,   :iPrgUId, :dPrmAzDatum,
           :iPrmMonat, :iPraUId, :bPraIstVerbucht
  DO 
  BEGIN

    IF ( ( bIstFound = 0 ) AND ( iPrmUId = iLcPrmUId ) ) THEN
      bIstFound = 1;


    IF (bIstFound = 1) THEN 
    BEGIN

      IF ( ( iPrmUId <> iLcPrmUId ) AND (bIstOK = 0) ) THEN 
        iLcPrmUId = iPrmUId; 


      IF ( iLcPrmUId = iPrmUId ) THEN 
      BEGIN 


        IF ((iPraUId IS NULL) OR (iPraUId = 0)) THEN 
        BEGIN   
        
          -- Abrechnung noch nicht angelegt
          
          EXECUTE PROCEDURE sp_Pra_Insert
                              :iPrmUId,         -- PrmUId
                              :iPrgUId,         -- PrgUId
                              :dPrmAzDatum,     -- AZDatum
                              0,                -- IstVerbucht
                              1,                -- IstAktiv
                              :pi_UsrUId        -- CreateUser
            RETURNING_VALUES :iNewPraUId;
 
            bIstOK = 1;

        END 
        ELSE 
        BEGIN
   
          IF ( bPraIstVerbucht = 0 ) THEN
            bIstOK = 1;
        
        END
        
      END

    END

  END


  -- Erste unverbuchte Abrechnung aus PRA_PayrollAccont suchen, sonst letzte verbuchte Abrecnnung 

  pi_PraUId  = 0;
  
  FOR 
    SELECT pra_UId, pra_IstVerbucht 
      FROM prm_PayrollMonth
     INNER JOIN pra_PayrollAccount ON pra_PrmUId = prm_UId
      LEFT JOIN prg_PayrollGroup   ON prg_UId    = pra_PrgUId  
     WHERE prm_BuyUId = :pi_BuyUId
       AND prm_Monat  > 0
     ORDER BY prm_Monat, prm_AbreNr, prg_SortNr, prg_Gruppe
      INTO :iPraUId, :bPraIstVerbucht
  DO 
  BEGIN

    pi_PraUId = iPraUId;
    
    IF (bPraIstVerbucht = 0) THEN 
      EXIT;
      
  END

END!!


COMMENT ON PROCEDURE sp_Pra_CheckNextAccount IS 'This procedure determines the UID of the next billing to be processed' !!

COMMENT ON PARAMETER sp_Pra_CheckNextAccount.pi_BuyUId IS 'Business Year Id'!!
COMMENT ON PARAMETER sp_Pra_CheckNextAccount.pi_UsrUId IS 'Application active user Id'!!

COMMIT!!

-- +++

CREATE OR ALTER PROCEDURE sp_Pra_DeleteEmptyAccounts 
(
  pi_BuyUId DI_UID  -- Business year UId
)
AS

  -- The procedure deletes all empty and not fixed records. The procedure is executing when closing 
  -- the form SalaryManageFRM
  
  DECLARE VARIABLE iPraUId        DI_UID;
  DECLARE VARIABLE iAnzMitInabre  DI_INT;
  DECLARE VARIABLE bIstVerbucht   DB_BOOLEAN;
  
BEGIN

  -- Alle nicht verbuchten und leeren Abrechnungen entfernen 

  FOR
   
    SELECT pra_UId, pra_IstVerbucht, COALESCE( pra_AnzMitInabre, 0 )
      FROM pra_PayrollAccount
      JOIN prm_PayrollMonth ON prm_UId = pra_PrmUId
     WHERE prm_BuyUId = :pi_BuyUId
     ORDER BY prm_Monat DESC, prm_AbreNr DESC
      INTO :iPraUId, :bIstVerbucht, :iAnzMitInabre
  DO
  BEGIN
    
    IF ( bIstVerbucht = 1 OR iAnzMitInabre > 0 ) THEN LEAVE;    
    
    EXECUTE PROCEDURE sp_Pra_Delete :iPraUId;    
        
  END

END!!

COMMENT ON PROCEDURE sp_Pra_DeleteEmptyAccounts IS 'The procedure deletes all empty and not fixed records' !!
COMMENT ON PARAMETER sp_Pra_DeleteEmptyAccounts.pi_BuyUId IS 'Business year UId'!!
COMMIT!!

--FS#636:END

SET TERM ;!!
